/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.ArrayList;
import kafka.common.InterBrokerSendThread;
import kafka.common.RequestAndCompletionHandler;
import kafka.utils.MockTime;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.NotImplementedError;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019\t\u0005\u0001)A\u0005m!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB7\u0001A\u0003%A\tC\u0004o\u0001\t\u0007I\u0011B8\t\rM\u0004\u0001\u0015!\u0003q\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015i\b\u0001\"\u0001v\u0011\u0015y\b\u0001\"\u0001v\u0011\u0019\t\u0019\u0001\u0001C\u0001k\u001a1\u0011q\u0001\u0001\u0005\u0003\u0013Aaa\n\b\u0005\u0002\u0005\u001d\u0002bBA\u0016\u001d\u0011\u0005\u0013Q\u0006\u0004\u0005\r\u0002!q\tC\u0003(#\u0011\u00051\u000bC\u0004U#\u0001\u0007I\u0011A+\t\u000fe\u000b\u0002\u0019!C\u00015\"1\u0001-\u0005Q!\nYC\u0011\"Y\tA\u0002\u0003\u0007I\u0011\u00012\t\u0013\u0019\f\u0002\u0019!a\u0001\n\u00039\u0007\"C5\u0012\u0001\u0004\u0005\t\u0015)\u0003d\u0011\u0015Q\u0017\u0003\"\u0011l\u0005eIe\u000e^3s\u0005J|7.\u001a:TK:$G\u000b\u001b:fC\u0012$Vm\u001d;\u000b\u0005qi\u0012AB2p[6|gNC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t1$\u0001\u0003uS6,W#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005Aj\u0012!B;uS2\u001c\u0018B\u0001\u001a0\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!\u00048fi^|'o[\"mS\u0016tG/F\u00017!\t9t(D\u00019\u0015\tI$(A\u0004dY&,g\u000e^:\u000b\u0005yY$B\u0001\u001f>\u0003\u0019\t\u0007/Y2iK*\ta(A\u0002pe\u001eL!\u0001\u0011\u001d\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\n\u0011cY8na2,G/[8o\u0011\u0006tG\r\\3s+\u0005!\u0005CA#\u0012\u001b\u0005\u0001!!F*uk\n\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM]\n\u0004#!\u0003\u0006CA%O\u001b\u0005Q%BA&M\u0003\u0011a\u0017M\\4\u000b\u00035\u000bAA[1wC&\u0011qJ\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]\n\u0016B\u0001*9\u0005a\u0011V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\u000b\u0002\t\u0006\u0001S\r_3dkR,GmV5uQ\u0012K7oY8o]\u0016\u001cG/\u001a3SKN\u0004xN\\:f+\u00051\u0006C\u0001\u0012X\u0013\tA6EA\u0004C_>dW-\u00198\u0002I\u0015DXmY;uK\u0012<\u0016\u000e\u001e5ESN\u001cwN\u001c8fGR,GMU3ta>t7/Z0%KF$\"a\u00170\u0011\u0005\tb\u0016BA/$\u0005\u0011)f.\u001b;\t\u000f}#\u0012\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002C\u0015DXmY;uK\u0012<\u0016\u000e\u001e5ESN\u001cwN\u001c8fGR,GMU3ta>t7/\u001a\u0011\u0002\u0011I,7\u000f]8og\u0016,\u0012a\u0019\t\u0003o\u0011L!!\u001a\u001d\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXm\u0018\u0013fcR\u00111\f\u001b\u0005\b?^\t\t\u00111\u0001d\u0003%\u0011Xm\u001d9p]N,\u0007%\u0001\u0006p]\u000e{W\u000e\u001d7fi\u0016$\"a\u00177\t\u000b\u0005L\u0002\u0019A2\u0002%\r|W\u000e\u001d7fi&|g\u000eS1oI2,'\u000fI\u0001\u0011e\u0016\fX/Z:u)&lWm\\;u\u001bN,\u0012\u0001\u001d\t\u0003EEL!A]\u0012\u0003\u0007%sG/A\tsKF,Xm\u001d;US6,w.\u001e;Ng\u0002\n1e\u001d5pk2$gj\u001c;TK:$\u0017I\\=uQ&twm\u00165f]:{'+Z9vKN$8\u000fF\u0001\\Q\tQq\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{{\u0005)!.\u001e8ji&\u0011A0\u001f\u0002\u0005)\u0016\u001cH/A\u0018tQ>,H\u000eZ\"sK\u0006$Xm\u00117jK:$(+Z9vKN$\u0018I\u001c3TK:$w\u000b[3o\u001d>$W-S:SK\u0006$\u0017\u0010\u000b\u0002\fo\u0006\u00195\u000f[8vY\u0012\u001c\u0015\r\u001c7D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJ<\u0016\u000e\u001e5ESN\u001cwN\u001c8fGR,GMU3ta>t7/Z,iK:tu\u000eZ3O_R\u0014V-\u00193zQ\taq/\u0001\u000euKN$h)Y5mS:<W\t\u001f9je\u0016$'+Z9vKN$8\u000f\u000b\u0002\u000eo\n\u00112\u000b^;c%\u0016\fX/Z:u\u0005VLG\u000eZ3s'\rq\u00111\u0002\t\u0007\u0003\u001b\tY\"!\t\u000f\t\u0005=\u0011qC\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005A!/Z9vKN$8O\u0003\u0002\u001du%!\u0011\u0011DA\t\u0003=\t%m\u001d;sC\u000e$(+Z9vKN$\u0018\u0002BA\u000f\u0003?\u0011qAQ;jY\u0012,'O\u0003\u0003\u0002\u001a\u0005E\u0001c\u0001\u0012\u0002$%\u0019\u0011QE\u0012\u0003\u000f9{G\u000f[5oOR\u0011\u0011\u0011\u0006\t\u0003\u000b:\tQAY;jY\u0012$B!!\t\u00020!9\u0011\u0011\u0007\tA\u0002\u0005M\u0012a\u0002<feNLwN\u001c\t\u0004E\u0005U\u0012bAA\u001cG\t)1\u000b[8si\u0002")
public class InterBrokerSendThreadTest {
    private final MockTime kafka$common$InterBrokerSendThreadTest$$time = new MockTime();
    private final NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient = (NetworkClient)EasyMock.createMock(NetworkClient.class);
    private final StubCompletionHandler completionHandler = new StubCompletionHandler();
    private final int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;

    public MockTime kafka$common$InterBrokerSendThreadTest$$time() {
        return this.kafka$common$InterBrokerSendThreadTest$$time;
    }

    public NetworkClient kafka$common$InterBrokerSendThreadTest$$networkClient() {
        return this.kafka$common$InterBrokerSendThreadTest$$networkClient;
    }

    private StubCompletionHandler completionHandler() {
        return this.completionHandler;
    }

    public int kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs() {
        return this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs;
    }

    @Test
    public void shouldNotSendAnythingWhenNoRequests() {
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this){
            private final int requestTimeoutMs;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public Iterable<Nothing$> generateRequests() {
                return (Iterable)Iterable$.MODULE$.empty();
            }
            {
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCreateClientRequestAndSendWhenNodeIsReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, handler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler handler$1;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.handler$1, (List)Nil$.MODULE$);
            }
            {
                this.handler$1 = handler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), true);
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds())).andReturn((Object)true);
        this.kafka$common$InterBrokerSendThreadTest$$networkClient().send(clientRequest, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void shouldCallCompletionHandlerWithDisconnectedResponseWhenNodeNotReady() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler requestAndCompletionHandler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, requestAndCompletionHandler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler requestAndCompletionHandler$1;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.requestAndCompletionHandler$1, (List)Nil$.MODULE$);
            }
            {
                this.requestAndCompletionHandler$1 = requestAndCompletionHandler$1;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), true);
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", 0L, true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), requestAndCompletionHandler.handler());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)requestAndCompletionHandler.request()), EasyMock.anyLong(), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)requestAndCompletionHandler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds())).andReturn((Object)false);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong())).andReturn((Object)0L);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node)).andReturn((Object)true);
        EasyMock.expect((Object)((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().authenticationException(node))).andReturn((Object)new AuthenticationException(""));
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    @Test
    public void testFailingExpiredRequests() {
        StubRequestBuilder request = new StubRequestBuilder();
        Node node = new Node(1, "", 8080);
        RequestAndCompletionHandler handler = new RequestAndCompletionHandler(node, (AbstractRequest.Builder)request, (RequestCompletionHandler)this.completionHandler());
        InterBrokerSendThread sendThread = new InterBrokerSendThread(this, handler){
            private final int requestTimeoutMs;
            private final RequestAndCompletionHandler handler$2;

            public int requestTimeoutMs() {
                return this.requestTimeoutMs;
            }

            public List<RequestAndCompletionHandler> generateRequests() {
                return new .colon.colon((Object)this.handler$2, (List)Nil$.MODULE$);
            }
            {
                this.handler$2 = handler$2;
                super("name", $outer.kafka$common$InterBrokerSendThreadTest$$networkClient(), (Time)$outer.kafka$common$InterBrokerSendThreadTest$$time(), true);
                this.requestTimeoutMs = $outer.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs();
            }
        };
        ClientRequest clientRequest = new ClientRequest("dest", (AbstractRequest.Builder)request, 0, "1", this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds(), true, this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs(), handler.handler());
        this.kafka$common$InterBrokerSendThreadTest$$time().sleep(1500L);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().newClientRequest((String)EasyMock.eq((Object)"1"), (AbstractRequest.Builder)EasyMock.same((Object)handler.request()), EasyMock.eq((long)this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds()), EasyMock.eq((boolean)true), EasyMock.eq((int)this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs()), (RequestCompletionHandler)EasyMock.same((Object)handler.handler()))).andReturn((Object)clientRequest);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().ready(node, this.kafka$common$InterBrokerSendThreadTest$$time().milliseconds())).andReturn((Object)false);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionDelay((Node)EasyMock.anyObject(), EasyMock.anyLong())).andReturn((Object)0L);
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().poll(EasyMock.anyLong(), EasyMock.anyLong())).andReturn(new ArrayList());
        EasyMock.expect((Object)this.kafka$common$InterBrokerSendThreadTest$$networkClient().connectionFailed(node)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        sendThread.doWork();
        EasyMock.verify((Object[])new Object[]{this.kafka$common$InterBrokerSendThreadTest$$networkClient()});
        Assert.assertFalse((boolean)sendThread.hasUnsentRequests());
        Assert.assertTrue((boolean)this.completionHandler().executedWithDisconnectedResponse());
    }

    public InterBrokerSendThreadTest() {
        this.kafka$common$InterBrokerSendThreadTest$$requestTimeoutMs = 1000;
    }

    private class StubCompletionHandler
    implements RequestCompletionHandler {
        private boolean executedWithDisconnectedResponse;
        private ClientResponse response;

        public boolean executedWithDisconnectedResponse() {
            return this.executedWithDisconnectedResponse;
        }

        public void executedWithDisconnectedResponse_$eq(boolean x$1) {
            this.executedWithDisconnectedResponse = x$1;
        }

        public ClientResponse response() {
            return this.response;
        }

        public void response_$eq(ClientResponse x$1) {
            this.response = x$1;
        }

        public void onComplete(ClientResponse response) {
            this.executedWithDisconnectedResponse_$eq(response.wasDisconnected());
            this.response_$eq(response);
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubCompletionHandler$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubCompletionHandler() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            this.executedWithDisconnectedResponse = false;
        }
    }

    private class StubRequestBuilder
    extends AbstractRequest.Builder<Nothing$> {
        public Nothing$ build(short version) {
            throw new NotImplementedError();
        }

        public /* synthetic */ InterBrokerSendThreadTest kafka$common$InterBrokerSendThreadTest$StubRequestBuilder$$$outer() {
            return InterBrokerSendThreadTest.this;
        }

        public StubRequestBuilder() {
            if (InterBrokerSendThreadTest.this == null) {
                throw null;
            }
            super(ApiKeys.END_TXN);
        }
    }
}

