/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.ProducerStateEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t=d\u0001\u0002\u001c8\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004P\u0001\u0001\u0006I!\u0013\u0005\b!\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0003A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011\u0001%\t\rU\u0003\u0001\u0015!\u0003J\u0011\u001d1\u0006A1A\u0005\u0002]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%\ta\u0016\u0005\u0007E\u0002\u0001\u000b\u0011\u0002-\t\u000f\r\u0004!\u0019!C\u0001\u0011\"1A\r\u0001Q\u0001\n%Cq!\u001a\u0001C\u0002\u0013\u0005a\rC\u0004\u0002\u0006\u0001\u0001\u000b\u0011B4\t\u0013\u0005\u001d\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0003\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005%\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0003\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0007\u0001\u0005B\u0005e\u0002bBA(\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u00033\u0002A\u0011AA\u001d\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003sAq!a\u001a\u0001\t\u0003\tI\u0004C\u0004\u0002l\u0001!\t!!\u000f\t\u000f\u0005=\u0004\u0001\"\u0001\u0002:!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBAK\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u00033\u0003A\u0011AA\u001d\u0011\u001d\ti\n\u0001C\u0001\u0003sAq!!)\u0001\t\u0003\tI\u0004C\u0004\u0002&\u0002!\t!!\u000f\t\u000f\u0005%\u0006\u0001\"\u0001\u0002:!9\u0011Q\u0016\u0001\u0005\u0002\u0005e\u0002bBAY\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0004A\u0011AA\u001d\u0011\u001d\t9\u000e\u0001C\u0001\u0003sAq!a7\u0001\t\u0003\tI\u0004C\u0004\u0002`\u0002!I!!9\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!1\u0002\u0001\u0005\n\t5\u0001\"\u0003B\u000e\u0001E\u0005I\u0011\u0002B\u000f\u0011%\u0011\u0019\u0004AI\u0001\n\u0013\u0011)\u0004C\u0005\u0003:\u0001\t\n\u0011\"\u0003\u0003<!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B#\u0001\u0011%!q\t\u0005\n\u0005G\u0002\u0011\u0013!C\u0005\u0005KB\u0011B!\u001b\u0001#\u0003%IA!\u001a\t\u0013\t-\u0004!%A\u0005\n\tU\u0002\"\u0003B7\u0001E\u0005I\u0011\u0002B\u001b\u0005A!&/\u00198tC\u000e$\u0018n\u001c8t)\u0016\u001cHO\u0003\u00029s\u0005\u0019\u0011\r]5\u000b\u0003i\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001{A\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)O\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002C\u007f\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u0002o\u0005Qa.^7TKJ4XM]:\u0016\u0003%\u0003\"AS'\u000e\u0003-S\u0011\u0001T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d.\u00131!\u00138u\u0003-qW/\\*feZ,'o\u001d\u0011\u00025Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;\u00027Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2fe\u000e{WO\u001c;!\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA\u0005ibn\u001c8Ue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:D_VtG/\u0001\u0010o_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001cu.\u001e8uA\u00051Ao\u001c9jGF*\u0012\u0001\u0017\t\u00033zk\u0011A\u0017\u0006\u00037r\u000bA\u0001\\1oO*\tQ,\u0001\u0003kCZ\f\u0017BA0[\u0005\u0019\u0019FO]5oO\u00069Ao\u001c9jGF\u0002\u0013A\u0002;pa&\u001c''A\u0004u_BL7M\r\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u00039qW/\u001c)beRLG/[8og\u0002\na\u0003\u001e:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'o]\u000b\u0002OB\u0019\u0001.\\8\u000e\u0003%T!A[6\u0002\u000f5,H/\u00192mK*\u0011AnS\u0001\u000bG>dG.Z2uS>t\u0017B\u00018j\u0005\u0019\u0011UO\u001a4feB!\u0001O\u001f?}\u001b\u0005\t(B\u0001:t\u0003!\u0001(o\u001c3vG\u0016\u0014(B\u0001;v\u0003\u001d\u0019G.[3oiNT!A\u000f<\u000b\u0005]D\u0018AB1qC\u000eDWMC\u0001z\u0003\ry'oZ\u0005\u0003wF\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bc\u0001&~\u007f&\u0011ap\u0013\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0015\u0006\u0005\u0011bAA\u0002\u0017\n!!)\u001f;f\u0003]!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001c\b%\u0001\fue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:t+\t\tY\u0001\u0005\u0003i[\u00065\u0001CBA\b\u0003+aH0\u0004\u0002\u0002\u0012)\u0019\u00111C:\u0002\u0011\r|gn];nKJLA!a\u0006\u0002\u0012\ti1*\u00194lC\u000e{gn];nKJ\fq\u0003\u001e:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o\u001d\u0011\u000239|g\u000e\u0016:b]N\f7\r^5p]\u0006d7i\u001c8tk6,'o]\u0001\u001b]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\u0011\u00111\u0005\t\u0007\u0003K\t9#a\u000b\u000e\u0003-L1!!\u000bl\u0005\r\u0019V-\u001d\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G\u001d\u0002\rM,'O^3s\u0013\u0011\t)$a\f\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003w\u00012ASA\u001f\u0013\r\tyd\u0013\u0002\u0005+:LG\u000fK\u0002\u0018\u0003\u0007\u0002B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013B\u0018!\u00026v]&$\u0018\u0002BA'\u0003\u000f\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007a\t\u0019\u0006\u0005\u0003\u0002F\u0005U\u0013\u0002BA,\u0003\u000f\u0012Q!\u00114uKJ\fQ\u0003^3ti\n\u000b7/[2Ue\u0006t7/Y2uS>t7\u000fK\u0002\u001a\u0003;\u0002B!!\u0012\u0002`%!\u0011\u0011MA$\u0005\u0011!Vm\u001d;\u0002eQ,7\u000f\u001e*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM]*i_VdGMT8u'\u0016,WK\u001c3fG&$W\r\u001a#bi\u0006D3AGA/\u0003)\"Xm\u001d;EK2\f\u00170\u001a3GKR\u001c\u0007.\u00138dYV$Wm]!c_J$X\r\u001a+sC:\u001c\u0018m\u0019;j_:D3aGA/\u0003i!Xm\u001d;TK:$wJ\u001a4tKR\u001cx+\u001b;i\u000fJ|W\u000f]%eQ\ra\u0012QL\u0001!i\u0016\u001cHoU3oI>3gm]3ug^KG\u000f[$s_V\u0004X*\u001a;bI\u0006$\u0018\rK\u0002\u001e\u0003;\n!b]3oI>3gm]3u)\u0011\tY$a\u001e\t\u000f\u0005ed\u00041\u0001\u0002|\u000511m\\7nSR\u0004\"BSA?_\u0006\u0005\u0015QBA\u001e\u0013\r\tyh\u0013\u0002\n\rVt7\r^5p]N\u0002B!a!\u0002\u0012:!\u0011QQAG!\r\t9iS\u0007\u0003\u0003\u0013S1!a#<\u0003\u0019a$o\\8u}%\u0019\u0011qR&\u0002\rA\u0013X\rZ3g\u0013\ry\u00161\u0013\u0006\u0004\u0003\u001f[\u0015a\u0005;fgR4UM\\2j]\u001e|enQ8n[&$\bfA\u0010\u0002^\u0005AB/Z:u\r\u0016t7-\u001b8h\u001f:\u001cVM\u001c3PM\u001a\u001cX\r^:)\u0007\u0001\ni&\u0001\u0017uKN$xJ\u001a4tKRlU\r^1eCR\f\u0017J\\*f]\u0012|eMZ:fiN$v\u000e\u0016:b]N\f7\r^5p]\"\u001a\u0011%!\u0018\u0002#Q,7\u000f\u001e$f]\u000eLgnZ(o'\u0016tG\rK\u0002#\u0003;\n!\u0004^3ti\u001a+gnY5oO>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]ND3aIA/\u0003\t\"Xm\u001d;GK:\u001c\u0017N\\4P]R\u0013\u0018M\\:bGRLwN\\#ya&\u0014\u0018\r^5p]\"\u001aA%!\u0018\u00029Q,7\u000f^'vYRL\u0007\u000f\\3NCJ\\WM]:P]\u0016dU-\u00193fe\"\u001aQ%!\u0018\u0002IQ,7\u000f^\"p]N,7-\u001e;jm\u0016d\u0017PU;o\u0013:LG\u000f\u0016:b]N\f7\r^5p]NDsAJA/\u0003k\u000b9,\u0001\u0005fqB,7\r^3eG\t\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\r\ty,^\u0001\u0007G>lWn\u001c8\n\t\u0005\r\u0017Q\u0018\u0002\u000f\u0017\u000647.Y#yG\u0016\u0004H/[8o\u0003q!Xm\u001d;D_6l\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRDsaJA/\u0003k\u000bIm\t\u0002\u0002LB!\u0011QZAj\u001b\t\tyM\u0003\u0003\u0002R\u0006u\u0016AB3se>\u00148/\u0003\u0003\u0002V\u0006='\u0001\u0005+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o\u0003i!Xm\u001d;Ck6\u0004HK]1og\u0006\u001cG/[8oC2,\u0005o\\2iQ\rA\u0013QL\u0001\u0018i\u0016\u001cHOR1jYV\u0014X\rV8GK:\u001cW-\u00129pG\"D3!KA/\u0003\u001d\u001aXM\u001c3Ue\u0006t7/Y2uS>t\u0017\r\\'fgN\fw-Z:XSRDg+\u00197vKJ\u000bgnZ3\u0015\u0019\u0005m\u00121]As\u0003S\fi/!=\t\u000bIT\u0003\u0019A8\t\u000f\u0005\u001d(\u00061\u0001\u0002\u0002\u0006)Ao\u001c9jG\"1\u00111\u001e\u0016A\u0002%\u000bQa\u001d;beRDa!a<+\u0001\u0004I\u0015aA3oI\"9\u00111\u001f\u0016A\u0002\u0005U\u0018aD<jY2\u0014UmQ8n[&$H/\u001a3\u0011\u0007)\u000b90C\u0002\u0002z.\u0013qAQ8pY\u0016\fg.A\u0006tKJ4XM\u001d)s_B\u001cHCAA\u0000!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u00039\u0006!Q\u000f^5m\u0013\u0011\u0011IAa\u0001\u0003\u0015A\u0013x\u000e]3si&,7/A\u000ede\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u000b\t\u0003\u001b\u0011yAa\u0005\u0003\u0018!I!\u0011\u0003\u0017\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\u0006OJ|W\u000f\u001d\u0005\t\u0005+a\u0003\u0013!a\u0001\u0013\u0006qQ.\u0019=Q_2d'+Z2pe\u0012\u001c\b\"\u0003B\rYA\u0005\t\u0019AA\u0000\u0003\u0015\u0001(o\u001c9t\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003 )\"\u0011\u0011\u0011B\u0011W\t\u0011\u0019\u0003\u0005\u0003\u0003&\t=RB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0017\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tE\"q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!J2sK\u0006$XMU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119DK\u0002J\u0005C\tQe\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu\"\u0006BA\u0000\u0005C\tQd\u0019:fCR,'+Z1e+:\u001cw.\\7jiR,GmQ8ogVlWM\u001d\u000b\u0005\u0003\u001b\u0011\u0019\u0005C\u0004\u0003\u0012A\u0002\r!!!\u00027\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3s)-y'\u0011\nB'\u0005/\u0012YFa\u0018\t\u000f\t-\u0013\u00071\u0001\u0002\u0002\u0006yAO]1og\u0006\u001cG/[8oC2LE\rC\u0005\u0003PE\u0002\n\u00111\u0001\u0003R\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN\u00042A\u0013B*\u0013\r\u0011)f\u0013\u0002\u0005\u0019>tw\rC\u0005\u0003ZE\u0002\n\u00111\u0001\u0003R\u0005QQ.\u0019=CY>\u001c7.T:\t\u0011\tu\u0013\u0007%AA\u0002%\u000b\u0011\u0003Z3mSZ,'/\u001f+j[\u0016|W\u000f^'t\u0011!\u0011\t'\rI\u0001\u0002\u0004I\u0015\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003\u0015\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003h)\"!\u0011\u000bB\u0011\u0003\u0015\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2fe\u0012\"WMZ1vYR$3'A\u0013de\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005)3M]3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ$C-\u001a4bk2$H%\u000e")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        int n = 0;
        int until$extension_end = this.transactionalProducerCount();
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var5_4 = null;
        int n2 = 0;
        int until$extension_end2 = this.transactionalConsumerCount();
        Range.Exclusive foreach_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
        if (!foreach_this2.isEmpty()) {
            int foreach_i = foreach_this2.start();
            while (true) {
                this.createReadCommittedConsumer("transactional-group", 500, new Properties());
                if (foreach_i == foreach_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this2.step();
            }
        }
        Object var7_8 = null;
        int n3 = 0;
        int until$extension_end3 = this.nonTransactionalConsumerCount();
        Range.Exclusive foreach_this3 = new Range.Exclusive(n3, until$extension_end3, 1);
        if (!foreach_this3.isEmpty()) {
            int foreach_i = foreach_this3.start();
            while (true) {
                this.createReadUncommittedConsumer("non-transactional-group");
                if (foreach_i == foreach_this3.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this3.step();
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, 15000L);
        .colon.colon toSet_this = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$))));
        Object var6_5 = null;
        scala.collection.immutable.Set expectedValues = IterableOnceOps.toSet$((IterableOnceOps)toSet_this);
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), Long.valueOf(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Integer.valueOf(0), Long.valueOf(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Integer.valueOf(0), Long.valueOf(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        readUncommittedConsumer.assign((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, 15000L);
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        Long $minus$greater$extension_y = latestWrittenTimestamp;
        Object var13_10 = null;
        objectArray[0] = new Tuple2((Object)tp1, (Object)$minus$greater$extension_y);
        Long $minus$greater$extension_y2 = latestWrittenTimestamp;
        Object var14_11 = null;
        objectArray[1] = new Tuple2((Object)tp2, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq2 = null;
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        readCommittedConsumer.assign((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L).foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        readCommittedConsumer.assignment().forEach(tp -> Assert.assertEquals((long)1L, (long)readCommittedConsumer.position(tp)));
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        Long $minus$greater$extension_y3 = latestWrittenTimestamp;
        Object var15_15 = null;
        objectArray2[0] = new Tuple2((Object)tp1, (Object)$minus$greater$extension_y3);
        Long $minus$greater$extension_y4 = latestWrittenTimestamp;
        Object var16_16 = null;
        objectArray2[1] = new Tuple2((Object)tp2, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq4 = null;
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        void apply_elems;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", 60000L, 60000L, 120000, 30000);
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Integer.valueOf(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = "group";
        int x$3 = 500;
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        readCommittedConsumer.assign((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, 15000L);
        if (records == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)records.length());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsetsWithGroupId() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        boolean sendOffset_create_e = false;
        BooleanRef sendOffset_shouldCommit = new BooleanRef(sendOffset_create_e);
        int sendOffset_create_e2 = 0;
        IntRef sendOffset_recordsProcessed = new IntRef(sendOffset_create_e2);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.length();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.length());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.length()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.length(), (long)sendOffset_valueSet.size());
    }

    @Test
    public void testSendOffsetsWithGroupMetadata() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, new Properties());
        sendOffset_consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        boolean sendOffset_create_e = false;
        BooleanRef sendOffset_shouldCommit = new BooleanRef(sendOffset_create_e);
        int sendOffset_create_e2 = 0;
        IntRef sendOffset_recordsProcessed = new IntRef(sendOffset_create_e2);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), 15000L);
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.length();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)));
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.length());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.length()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.length(), (long)sendOffset_valueSet.size());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, new Properties());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        boolean create_e = false;
        BooleanRef shouldCommit = new BooleanRef(create_e);
        int create_e2 = 0;
        IntRef recordsProcessed = new IntRef(create_e2);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), 15000L);
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.length();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, 15000L).map((Function1 & Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)));
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)numSeedMessages, (long)valueSeq.length());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(valueSeq.length()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)valueSeq.length(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            producer1.commitTransaction();
            throw Assertions$.MODULE$.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L);
            TopicPartition $minus$greater$extension_$this = new TopicPartition("foobartopic", 0);
            Object var5_5 = null;
            offsetAndMetadata = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            producer1.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava(), "foobarGroup");
            throw Assertions$.MODULE$.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        void apply_elems;
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, 500, new Properties());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(15), "some metadata");
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        objectArray[0] = new Tuple2((Object)tp, (Object)offsetAndMetadata);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava(), groupId);
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$1(offsetAndMetadata, consumer, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("cannot read committed offset", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)server.logManager().liveLogDirs().map((Function1 & Serializable)x$9 -> x$9.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableOps)server.logManager().liveLogDirs().map((Function1 & Serializable)x$10 -> x$10.getAbsolutePath())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.beginTransaction();
        Assert.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            throw Assertions$.MODULE$.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, 15000L);
        if (records == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)records.length());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assert.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleMarkersOneLeader() {
        String string;
        void apply_end;
        void apply_start;
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(2));
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig);
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, 15000L);
        int n = 11000;
        boolean bl = false;
        if (package$.MODULE$.Range() == null) {
            throw null;
        }
        Range.Exclusive map_this = new Range.Exclusive((int)apply_start, (int)apply_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            string = Integer.toString(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var9_10 = null;
        Object var10_11 = null;
        Object var11_12 = null;
        string = null;
        scala.collection.immutable.Set expectedValues = ((IndexedSeq)map_strictOptimizedMap_b.result()).toSet();
        allRecords.foreach((Function1 & Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=KafkaException.class)
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", 60000L, 60000L, 120000, 30000);
        producer.initTransactions();
        producer.initTransactions();
        throw Assertions$.MODULE$.fail("Should have raised a KafkaException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
    }

    @Test(expected=TimeoutException.class)
    public void testCommitTransactionTimeout() {
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$3, 1000L, x$4, x$5);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord(this.topic1(), (Object)"foobar".getBytes()));
        int n = 0;
        Buffer<KafkaServer> buffer = this.servers();
        if (buffer == null) {
            throw null;
        }
        Buffer<KafkaServer> size_this = buffer;
        Object var11_6 = null;
        int until$extension_end = size_this.length();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_8 = null;
        try {
            producer.commitTransaction();
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @Test
    public void testBumpTransactionalEpoch() {
        long x$4 = 60000L;
        long x$5 = 60000L;
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("transactionalProducer", x$4, x$5, 5000, 5000);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(testTopic, 0), 15000L);
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, (Integer)0, "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$6 = new TopicPartition(testTopic, 0);
            boolean x$7 = qual$1.getLog$default$2();
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((Log)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, (Integer)0, "4", "4", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, (Integer)0, "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers();
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, (Integer)0, "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, (Integer)0, "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$8 = new TopicPartition(testTopic, 0);
            boolean x$9 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((Log)qual$2.getLog(x$8, x$9).get()).producerStateManager().activeProducers().apply((Object)producerId);
            Assert.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @Test
    public void testFailureToFenceEpoch() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        long x$3 = 60000L;
        int x$4 = 120000;
        int x$5 = 30000;
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("transactional-producer", x$3, 1000L, x$4, x$5);
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)0, "4", "4", true));
        producer1.commitTransaction();
        int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(this.topic1(), 0), 15000L);
        LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$6 = new TopicPartition(this.topic1(), 0);
        boolean x$7 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((Log)qual$1.getLog(x$6, x$7).get()).producerStateManager().activeProducers().head())._2();
        long producerId = producerStateEntry.producerId();
        short initialProducerEpoch = producerStateEntry.producerEpoch();
        this.killBroker(0);
        this.killBroker(1);
        try {
            try {
                producer2.initTransactions();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw Assertions$.MODULE$.fail("Got an unexpected exception from initTransactions", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            }
        }
        finally {
            producer2.close();
        }
        this.restartDeadBrokers();
        try {
            try {
                producer1.beginTransaction();
            }
            catch (ProducerFencedException producerFencedException) {
            }
            catch (Exception e) {
                throw Assertions$.MODULE$.fail("Got an unexpected exception from commitTransaction", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            }
        }
        finally {
            producer1.close();
        }
        long x$10 = 60000L;
        int x$11 = 120000;
        int x$12 = 30000;
        KafkaProducer<byte[], byte[]> producer3 = this.createTransactionalProducer("transactional-producer", x$10, 5000L, x$11, x$12);
        producer3.initTransactions();
        producer3.beginTransaction();
        producer3.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)0, "4", "4", true));
        producer3.commitTransaction();
        LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
        TopicPartition x$13 = new TopicPartition(this.topic1(), 0);
        boolean x$14 = qual$2.getLog$default$2();
        producerStateEntry = (ProducerStateEntry)((Log)qual$2.getLog(x$13, x$14).get()).producerStateManager().activeProducers().apply((Object)producerId);
        Assert.assertEquals((long)((short)(initialProducerEpoch + 1)), (long)producerStateEntry.producerEpoch());
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        Range.Exclusive foreach_this = new Range.Exclusive(start, end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var6_6 = null;
        producer.flush();
    }

    private Properties serverProps() {
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(3));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(2));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return serverProps;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String x$6 = "earliest";
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, false, true, maxPollRecords, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        Buffer<KafkaConsumer<byte[], byte[]>> buffer = this.transactionalConsumers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String x$4 = "earliest";
        boolean x$5 = false;
        int x$6 = 500;
        SecurityProtocol x$7 = SecurityProtocol.PLAINTEXT;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        ByteArrayDeserializer x$10 = new ByteArrayDeserializer();
        ByteArrayDeserializer x$11 = new ByteArrayDeserializer();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, false, x$5, x$6, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        Buffer<KafkaConsumer<byte[], byte[]>> buffer = this.nonTransactionalConsumers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne(consumer);
        return consumer;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs, int requestTimeoutMs) {
        Buffer<KafkaServer> x$2 = this.servers();
        int x$7 = 16384;
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$7, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs, requestTimeoutMs);
        Buffer<KafkaProducer<byte[], byte[]>> buffer = this.transactionalProducers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    private int createTransactionalProducer$default$5() {
        return 30000;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ int $anonfun$sendOffset$4(ConsumerRecord record) {
        return Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testOffsetMetadataInSendOffsetsToTransaction$1(OffsetAndMetadata offsetAndMetadata$1, KafkaConsumer consumer$1, TopicPartition tp$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        return offsetAndMetadata$1.equals(consumer$1.committed(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()).get(tp$1));
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$11) {
        return Integer.toString(x$11);
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testCommitTransactionTimeout$1(TransactionsTest $this, int i) {
        $this.killBroker(i);
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = Integer.toString(i);
        String x$5 = Integer.toString(i);
        return producer$2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ KafkaProducer $anonfun$setUp$1$adapted(TransactionsTest $this, Object x$2) {
        return $this.createTransactionalProducer("transactional-producer", 60000L, 60000L, 120000, 30000);
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$2$adapted(TransactionsTest $this, Object x$3) {
        return $this.createReadCommittedConsumer("transactional-group", 500, new Properties());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$3$adapted(TransactionsTest $this, Object x$4) {
        return $this.createReadUncommittedConsumer("non-transactional-group");
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$8, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2$adapted(Object x$11) {
        return TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$11));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1$adapted(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, Object i) {
        return TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer$2, topic$1, willBeCommitted$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

