/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dg\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B(\t\r\u0015\u0004\u0001\u0015!\u0003Q\u0011\u00151\u0007\u0001\"\u0015h\u0011\u001d\u0001\bA1A\u0005REDaa\u001f\u0001!\u0002\u0013\u0011\bb\u0002?\u0001\u0005\u0004%\t&\u001d\u0005\u0007{\u0002\u0001\u000b\u0011\u0002:\t\u000by\u0004A\u0011I@\t\r\u0005U\u0001\u0001\"\u0011\u0000\u0011\u0019\ty\u0002\u0001C\u0001\u007f\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!!0\u0001\t\u0013\ty\fC\u0004\u0002P\u0002!I!!5\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"9\u00111\u001d\u0001\u0005\n\u0005\u0015\bbBAu\u0001\u0011%\u00111\u001e\u0005\n\u0005o\u0001\u0011\u0013!C\u0005\u0005sAqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003p\u0001!IA!\u001d\t\u0013\t\u0015\u0005!%A\u0005\n\tm\u0002b\u0002BD\u0001\u0011%!\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WC\u0011B!/\u0001#\u0003%IAa/\t\u000f\t}\u0006\u0001\"\u0003\u0003B\nYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\t9\u0003&A\u0002ba&T\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001A\u0006\r\t\u0003[9j\u0011AJ\u0005\u0003_\u0019\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003[EJ!A\r\u0014\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u00016!\ti\u0003!A\u0006ce>\\WM]\"pk:$X#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%\u0001\u0007mSN$XM\\3s\u001d\u0006lW-F\u0001B!\t\u0011E*D\u0001D\u0015\t!U)A\u0004oKR<xN]6\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002*\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\ti5I\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003m\u00032\u0001X1Q\u001b\u0005i&B\u00010`\u0003%IW.\\;uC\ndWM\u0003\u0002au\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n\u0001d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7f\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:KC\u0006\u001cXI\u001c;ss:\u000bW.\u001a\u0011\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dW#\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017\u0001B1vi\"T!!\\#\u0002\u0011M,7-\u001e:jifL!a\u001c6\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001s!\rI4/^\u0005\u0003ij\u0012AaU8nKB\u0011a/_\u0007\u0002o*\u0011\u0001\u0010V\u0001\u0005kRLG.\u0003\u0002{o\nQ\u0001K]8qKJ$\u0018.Z:\u0002+M,'O^3s'\u0006\u001cH\u000e\u0015:pa\u0016\u0014H/[3tA\u0005!2\r\\5f]R\u001c\u0016m\u001d7Qe>\u0004XM\u001d;jKN\fQc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\u0002A\u0019\u0011(a\u0001\n\u0007\u0005\u0015!H\u0001\u0003V]&$\bf\u0001\t\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010)\u000bQA[;oSRLA!a\u0005\u0002\u000e\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004#\u0005e\u0001\u0003BA\u0006\u00037IA!!\b\u0002\u000e\t)\u0011I\u001a;fe\u0006YA/Z:u\u001b\u0016$(/[2tQ\r\u0011\u00121\u0005\t\u0005\u0003\u0017\t)#\u0003\u0003\u0002(\u00055!\u0001\u0002+fgR\f1b]3oIJ+7m\u001c:egRQ\u0011\u0011AA\u0017\u0003\u0017\ny%a\u0015\t\u000f\u0005=2\u00031\u0001\u00022\u0005A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u00024\u0005m\u0012qHA \u001b\t\t)D\u0003\u0003\u00020\u0005]\"bAA\u001d\u000f\u000691\r\\5f]R\u001c\u0018\u0002BA\u001f\u0003k\u0011QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#B\u001d\u0002B\u0005\u0015\u0013bAA\"u\t)\u0011I\u001d:bsB\u0019\u0011(a\u0012\n\u0007\u0005%#H\u0001\u0003CsR,\u0007BBA''\u0001\u0007\u0001(\u0001\u0006ok6\u0014VmY8sINDa!!\u0015\u0014\u0001\u0004A\u0014A\u0003:fG>\u0014HmU5{K\"9\u0011QK\nA\u0002\u0005]\u0013A\u0001;q!\u0011\tI&a\u0017\u000e\u0003\u0015K1!!\u0018F\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQdZ3oKJ\fG/Z!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u000b\u0005\u0003\u0003\t\u0019\u0007C\u0004\u0002VQ\u0001\r!a\u0016\u0002SY,'/\u001b4z\u0017\u000647.\u0019*bi\u0016lU\r\u001e:jGND\u0015M^3Dk6,H.\u0019;jm\u0016\u001cu.\u001e8u)\u0019\t\t!!\u001b\u0002l!9\u0011qF\u000bA\u0002\u0005E\u0002bBA7+\u0001\u0007\u0011qN\u0001\tG>t7/^7feBA\u0011\u0011OA;\u0003\u007f\ty$\u0004\u0002\u0002t)!\u0011QNA\u001c\u0013\u0011\t9(a\u001d\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s\u0003i1XM]5gs\u000ec\u0017.\u001a8u-\u0016\u00148/[8o\u001b\u0016$(/[2t)\u0019\t\t!! \u0002&\"9\u0011q\u0010\fA\u0002\u0005\u0005\u0015aB7fiJL7m\u001d\u0019\u0005\u0003\u0007\u000b\u0019\nE\u0004w\u0003\u000b\u000bI)a$\n\u0007\u0005\u001duOA\u0002NCB\u0004B!!\u0017\u0002\f&\u0019\u0011QR#\u0003\u00155+GO]5d\u001d\u0006lW\r\u0005\u0003\u0002\u0012\u0006ME\u0002\u0001\u0003\r\u0003+\u000bi(!A\u0001\u0002\u000b\u0005\u0011q\u0013\u0002\u0004?\u0012\n\u0014\u0003BAM\u0003?\u00032!OAN\u0013\r\tiJ\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\tI&!)\n\u0007\u0005\rVI\u0001\u0004NKR\u0014\u0018n\u0019\u0005\b\u0003O3\u0002\u0019AAU\u0003\u0019)g\u000e^5usB!\u00111VA]\u001d\u0011\ti+!.\u0011\u0007\u0005=&(\u0004\u0002\u00022*\u0019\u00111\u0017\u0016\u0002\rq\u0012xn\u001c;?\u0013\r\t9LO\u0001\u0007!J,G-\u001a4\n\u0007]\u000bYLC\u0002\u00028j\n\u0011E^3sS\u001aL(I]8lKJ\fU\u000f\u001e5f]RL7-\u0019;j_:lU\r\u001e:jGN$B!!\u0001\u0002B\"9\u00111Y\fA\u0002\u0005\u0015\u0017AB:feZ,'\u000f\u0005\u0003\u0002H\u0006-WBAAe\u0015\r\t\u0019\rK\u0005\u0005\u0003\u001b\fIMA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018\u0001\n<fe&4\u0017P\u0011:pW\u0016\u0014X*Z:tC\u001e,7i\u001c8wKJ\u001c\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u0011\u0005\u0005\u00111[Ak\u0003/Dq!a1\u0019\u0001\u0004\t)\r\u0003\u0004\u0002Ra\u0001\r\u0001\u000f\u0005\b\u0003+B\u0002\u0019AA,\u0003U1XM]5gs\n\u0013xn[3s5.lU\r\u001e:jGN$b!!\u0001\u0002^\u0006}\u0007bBAb3\u0001\u0007\u0011Q\u0019\u0005\b\u0003CL\u0002\u0019AAU\u0003\u0015!x\u000e]5d\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0005\u0003\u0003\t9\u000fC\u0004\u0002Dj\u0001\r!!2\u0002#Y,'/\u001b4z\u0017\u000647.Y'fiJL7-\u0006\u0003\u0002n\u0006MHCCAx\u00057\u0011yBa\u000b\u0003.Q!\u0011\u0011_A\u0000!\u0011\t\t*a=\u0005\u000f\u0005U8D1\u0001\u0002x\n\tA+\u0005\u0003\u0002\u001a\u0006e\bcA\u001d\u0002|&\u0019\u0011Q \u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\u0002m\u0001\rAa\u0001\u0002\rY,'/\u001b4z!\u001dI$Q\u0001B\u0005\u0003cL1Aa\u0002;\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0003\f\tU\u0011q\u0014\b\u0005\u0005\u001b\u0011\tB\u0004\u0003\u00020\n=\u0011\"A\u001e\n\u0007\tM!(A\u0004qC\u000e\\\u0017mZ3\n\t\t]!\u0011\u0004\u0002\t\u0013R,'/\u00192mK*\u0019!1\u0003\u001e\t\u000f\tu1\u00041\u0001\u0002*\u0006!a.Y7f\u0011\u001d\tyh\u0007a\u0001\u0005C\u0001DAa\t\u0003(A9a/!\"\u0002\n\n\u0015\u0002\u0003BAI\u0005O!AB!\u000b\u0003 \u0005\u0005\t\u0011!B\u0001\u0003/\u00131a\u0018\u00133\u0011\u001d\t9k\u0007a\u0001\u0003SC\u0011Ba\f\u001c!\u0003\u0005\rA!\r\u0002\u000b\u001d\u0014x.\u001e9\u0011\u000be\u0012\u0019$!+\n\u0007\tU\"H\u0001\u0004PaRLwN\\\u0001\u001cm\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\t\tm\"\u0011K\u000b\u0003\u0005{QCA!\r\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GMC\u0002\u0003Li\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yE!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0004\u0002vr\u0011\r!a>\u0002'5\f\u0007pS1gW\u0006lU\r\u001e:jGZ\u000bG.^3\u0015\u0015\t]#Q\fB0\u0005W\u0012i\u0007E\u0002:\u00053J1Aa\u0017;\u0005\u0019!u.\u001e2mK\"9!QD\u000fA\u0002\u0005%\u0006bBA@;\u0001\u0007!\u0011\r\u0019\u0005\u0005G\u00129\u0007E\u0004w\u0003\u000b\u000bII!\u001a\u0011\t\u0005E%q\r\u0003\r\u0005S\u0012y&!A\u0001\u0002\u000b\u0005\u0011q\u0013\u0002\u0004?\u0012\u001a\u0004bBAT;\u0001\u0007\u0011\u0011\u0016\u0005\b\u0005_i\u0002\u0019\u0001B\u0019\u0003e1XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3\u0015\u0015\u0005\u0005!1\u000fB;\u0005\u0003\u0013\u0019\tC\u0004\u0003\u001ey\u0001\r!!+\t\u000f\u0005}d\u00041\u0001\u0003xA\"!\u0011\u0010B?!\u001d1\u0018QQAE\u0005w\u0002B!!%\u0003~\u0011a!q\u0010B;\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\n\u0019q\f\n\u001b\t\u000f\u0005\u001df\u00041\u0001\u0002*\"I!q\u0006\u0010\u0011\u0002\u0003\u0007!\u0011G\u0001$m\u0016\u0014\u0018NZ=LC\u001a\\\u0017-T3ue&\u001c'+Z2pe\u0012,G\r\n3fM\u0006,H\u000e\u001e\u00135\u0003EI\u0018-\\7fe6+GO]5d-\u0006dW/\u001a\u000b\u0005\u0003s\u0014Y\tC\u0004\u0003\u001e\u0001\u0002\r!!+\u0002\u001fe\fW.\\3s\u0011&\u001cHo\\4sC6$BA!%\u0003(B!!1\u0013BR\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015\u0001B2pe\u0016TA!a \u0003\u001c*!!Q\u0014BP\u0003\u0019I\u0018-\\7fe*\u0011!\u0011U\u0001\u0004G>l\u0017\u0002\u0002BS\u0005+\u0013\u0011\u0002S5ti><'/Y7\t\u000f\tu\u0011\u00051\u0001\u0002*\u0006Qb/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fIR1!q\u000bBW\u0005_CqA!\b#\u0001\u0004\tI\u000bC\u0005\u0003\u0002\t\u0002\n\u00111\u0001\u00032B9\u0011H!\u0002\u0003X\tM\u0006cA\u001d\u00036&\u0019!q\u0017\u001e\u0003\u000f\t{w\u000e\\3b]\u0006!c/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fI\u0012\"WMZ1vYR$#'\u0006\u0002\u0003>*\"!\u0011\u0017B \u0003Y1XM]5gs:{'+Z9vKN$X*\u001a;sS\u000e\u001cH\u0003BA\u0001\u0005\u0007DqA!2%\u0001\u0004\tI+\u0001\u0007feJ|'/T3tg\u0006<W\r")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @Before
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, 15000L);
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    /*
     * WARNING - void declaration
     */
    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        Future future;
        byte[] bytes = new byte[recordSize];
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            future = producer.send(new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), Long.valueOf(BoxesRunTime.unboxToInt((Object)object)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)object)).toString().getBytes(), (Object)bytes));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        IndexedSeq cfr_ignored_0 = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        future = null;
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", "SCRAM-SHA-256");
        String x$1 = this.brokerList();
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = 0x100000L;
        int x$9 = Integer.MAX_VALUE;
        int x$10 = 30000;
        int x$11 = 0;
        int x$12 = 16384;
        String x$13 = "none";
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, 0, 1000L, x$8, x$9, x$10, x$11, x$12, x$13, 1000, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Integer.valueOf(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        void apply_elems;
        Set consumerMetricNames = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, consumer.metrics().keySet()).asScala().toSet();
        ((IterableOnceOps)consumerMetricNames.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, producer.metrics().keySet()).asScala().toSet();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set producerExclusions = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        ((IterableOnceOps)((IterableOps)producerMetricNames.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", (Option<String>)None$.MODULE$);
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        .colon.colon foreach_these = new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, string);
            foreach_these = (List)foreach_these.tail();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("failed-authentication-total not updated", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assert.assertTrue((String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString(), (tempBytes >= (double)recordSize ? 1 : 0) != 0);
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString(), (boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue));
        Object var9_7 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString(), (boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2));
        Object var12_9 = null;
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        long newCount = histogram.count();
        Assert.assertTrue((String)"ZooKeeper latency not recorded", (newCount > initialCount ? 1 : 0) != 0);
        double min = histogram.min();
        Assert.assertTrue((String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString(), (min >= 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unexpected ZK state", (Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"));
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        try {
            this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assert.assertEquals((long)(startErrorMetricCount + 1), (long)currentErrorMetricCount);
        Assert.assertTrue((String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString(), (currentErrorMetricCount < 10 ? 1 : 0) != 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 1, 100, new TopicPartition("non-existent", 0));
        this.verifyYammerMetricRecorded(new StringBuilder(44).append(errorMetricPrefix).append(",request=Metadata,error=LEADER_NOT_AVAILABLE").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)matchingMetrics.nonEmpty());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, metrics).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, group, x0$1)));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)verifyKafkaMetric_matchingMetrics.nonEmpty());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assert.assertTrue((String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString(), (value > 0.0 ? 1 : 0) != 0);
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var4_5;
        scala.collection.mutable.Map allMetrics = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Option option = allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$7 -> x$7.getMBeanName())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }
        Object var5_3 = null;
        Tuple2 tuple2 = (Tuple2)getOrElse_this.get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_5 instanceof Meter) {
            return (double)((Meter)var4_5).count();
        }
        if (var4_5 instanceof Histogram) {
            return ((Histogram)var4_5).max();
        }
        if (var4_5 instanceof Gauge) {
            return ((Gauge)var4_5).value();
        }
        throw Assertions$.MODULE$.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_5.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_5;
        scala.collection.mutable.Map allMetrics = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Option option = allMetrics.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1)));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable)x$8 -> x$8.getMBeanName())).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        }
        Object var5_3 = null;
        Tuple2 tuple2 = (Tuple2)getOrElse_this.get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (var4_5 instanceof Histogram) {
            return (Histogram)var4_5;
        }
        throw Assertions$.MODULE$.fail(new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_5.getClass()).toString(), new Position("MetricsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
    }

    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assert.assertTrue((String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString(), (boolean)verify.apply$mcZD$sp(metricValue));
        return metricValue;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assert.assertTrue((String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString(), (boolean)metrics.isEmpty());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assert.assertTrue((String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString(), (totalExists || totalTimeExists ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assert.assertEquals((long)1L, (long)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assert.assertNotNull((String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString(), (Object)value);
        Assert.assertNotNull((String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString(), (Object)(value instanceof String && !((String)value).isEmpty() ? 1 : 0));
        Assert.assertTrue((String)"Client-id not specified", (boolean)metric.metricName().tags().containsKey("client-id"));
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        None$ verifyKafkaMetric_group = None$.MODULE$;
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)metrics$1).asScala().filter(arg_0 -> MetricsTest.$anonfun$verifyKafkaMetric$1$adapted(name, (Option)verifyKafkaMetric_group, arg_0));
        Assert.assertTrue((String)new StringBuilder(17).append("Metric not found ").append(name).toString(), (boolean)verifyKafkaMetric_matchingMetrics.nonEmpty());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((IterableOnceOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.name();
            if (!(string != null ? !string.equals(name$2) : name$2 != null)) {
                String string2;
                if (group$1 == null) {
                    throw null;
                }
                if (group$1.isEmpty() || MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, string2 = (String)group$1.get())) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)0.0, (Function2 & Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        }
        throw new MatchError(null);
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableDoc(), "false");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        Statics.releaseFence();
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(KafkaProducer producer$1, TopicPartition tp$1, byte[] bytes$1, Object i) {
        return producer$1.send(new ProducerRecord(tp$1.topic(), Integer.valueOf(tp$1.partition()), Long.valueOf(BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes$1));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$1$adapted(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$1($this, metrics$1, entity$1, name);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$verifyKafkaMetric$2$adapted(MetricName metricName$1, String x$6) {
        return BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName$1, x$6));
    }
}

