/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\tef\u0001B%K\u0001=CQ\u0001\u0019\u0001\u0005\u0002\u0005DQa\u0019\u0001\u0005B\u0011Dqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004z\u0001\u0001\u0006I!\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u0019y\b\u0001)A\u0005y\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u0011-\t\t\u0003\u0001a\u0001\u0002\u0004%I!a\t\t\u0017\u0005=\u0002\u00011A\u0001B\u0003&\u0011Q\u0001\u0005\f\u0003c\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019\u0004C\u0006\u0002N\u0001\u0001\r\u00111A\u0005\n\u0005=\u0003bCA*\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kA1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X!Y\u0011\u0011\u000e\u0001A\u0002\u0003\u0007I\u0011BA6\u0011-\ty\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0017\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004\u0002CAC\u0001\u0001\u0006I!!\u001e\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002t!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fC\u0011\"!3\u0001#\u0003%\t!a3\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011Q\u001e\u0001\u0005\u0002\u0005\r\bbBA|\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u0003\u0001A\u0011AAr\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003GDqA!\u0003\u0001\t\u0003\t\u0019\u000fC\u0004\u0003\u000e\u0001!\t!a9\t\u000f\tE\u0001\u0001\"\u0001\u0002d\"9!Q\u0003\u0001\u0005\u0002\u0005\r\bb\u0002B\r\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005;\u0001A\u0011AAr\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003GDqA!\n\u0001\t\u0003\t\u0019\u000fC\u0004\u0003*\u0001!\t!a9\t\u000f\t5\u0002\u0001\"\u0001\u0002d\"9!\u0011\u0007\u0001\u0005\u0002\u0005\r\bb\u0002B\u001b\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005s\u0001A\u0011AAr\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003GDqA!\u0011\u0001\t\u0003\t\u0019\u000fC\u0004\u0003F\u0001!\t!a9\t\u000f\t%\u0003\u0001\"\u0001\u0002d\"9!Q\n\u0001\u0005\u0002\u0005\r\bb\u0002B)\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005+\u0002A\u0011AAr\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003GDqA!\u0018\u0001\t\u0003\t\u0019\u000fC\u0004\u0003b\u0001!\t!a9\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002d\"9!\u0011\u000e\u0001\u0005\u0002\u0005\r\bb\u0002B7\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005c\u0002A\u0011AAr\u0011\u001d\u0011)\b\u0001C\u0001\u0003GDqA!\u001f\u0001\t\u0003\t\u0019\u000fC\u0004\u0003~\u0001!\t!a9\t\u000f\t\u0005\u0005\u0001\"\u0001\u0002d\"9!Q\u0011\u0001\u0005\u0002\u0005\r\bb\u0002BE\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005\u001b\u0003A\u0011AAr\u0011\u001d\u0011\t\n\u0001C\u0001\u0003GDqA!&\u0001\t\u0003\t\u0019\u000fC\u0004\u0003\u001a\u0002!\t!a9\t\u000f\tu\u0005\u0001\"\u0001\u0002d\"9!\u0011\u0015\u0001\u0005\u0002\u0005\r\bb\u0002BS\u0001\u0011\u0005\u00111\u001d\u0005\b\u0005S\u0003A\u0011AAr\u0011\u001d\u0011i\u000b\u0001C\u0001\u0003GDqA!-\u0001\t\u0003\t\u0019\u000fC\u0004\u00036\u0002!\t!a9\u0003?Q{\u0007/[2D_6l\u0017M\u001c3XSRD\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002L\u0019\u0006)\u0011\rZ7j]*\tQ*A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0001f\u000b\u0018\t\u0003#Rk\u0011A\u0015\u0006\u0003'2\u000b1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011QK\u0015\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011qKW\u0007\u00021*\u0011\u0011\fT\u0001\u0006kRLGn]\u0005\u00037b\u0013q\u0001T8hO&tw\r\u0005\u0002^=6\t!*\u0003\u0002`\u0015\ni!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#\u00012\u0011\u0005u\u0003\u0011aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003\u0015\u00042AZ6n\u001b\u00059'B\u00015j\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002U\u0006)1oY1mC&\u0011An\u001a\u0002\u0004'\u0016\f\bC\u00018r\u001b\u0005y'B\u00019M\u0003\u0019\u0019XM\u001d<fe&\u0011!o\u001c\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002kB\u0011ao^\u0007\u0002S&\u0011\u00010\u001b\u0002\u0004\u0013:$\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0019I\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014X#\u0001?\u0011\u0005Yl\u0018B\u0001@j\u0005\u0015\u0019\u0006n\u001c:u\u0003e!WMZ1vYR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0011\u0002\u0019Q|\u0007/[2TKJ4\u0018nY3\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u00037qA!!\u0003\u0002\u00189!\u00111BA\u000b\u001d\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u001d\u00061AH]8pizJ\u0011!T\u0005\u0003\u00172K1!!\u0007K\u00031!v\u000e]5d\u0007>lW.\u00198e\u0013\u0011\ti\"a\b\u0003/\u0005#W.\u001b8DY&,g\u000e\u001e+pa&\u001c7+\u001a:wS\u000e,'bAA\r\u0015\u0006\u0001Bo\u001c9jGN+'O^5dK~#S-\u001d\u000b\u0005\u0003K\tY\u0003E\u0002w\u0003OI1!!\u000bj\u0005\u0011)f.\u001b;\t\u0013\u00055\u0002\"!AA\u0002\u0005\u0015\u0011a\u0001=%c\u0005iAo\u001c9jGN+'O^5dK\u0002\n1\"\u00193nS:\u001cE.[3oiV\u0011\u0011Q\u0007\t\u0005\u0003o\tI%\u0004\u0002\u0002:)\u00191*a\u000f\u000b\t\u0005u\u0012qH\u0001\bG2LWM\u001c;t\u0015\ri\u0015\u0011\t\u0006\u0005\u0003\u0007\n)%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\n1a\u001c:h\u0013\u0011\tY%!\u000f\u0003\u000b\u0005#W.\u001b8\u0002\u001f\u0005$W.\u001b8DY&,g\u000e^0%KF$B!!\n\u0002R!I\u0011QF\u0006\u0002\u0002\u0003\u0007\u0011QG\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u000ei\u0016\u001cH\u000fV8qS\u000et\u0015-\\3\u0016\u0005\u0005e\u0003\u0003BA.\u0003GrA!!\u0018\u0002`A\u0019\u0011QB5\n\u0007\u0005\u0005\u0014.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003K\n9G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003CJ\u0017!\u0005;fgR$v\u000e]5d\u001d\u0006lWm\u0018\u0013fcR!\u0011QEA7\u0011%\tiCDA\u0001\u0002\u0004\tI&\u0001\buKN$Hk\u001c9jG:\u000bW.\u001a\u0011\u0002\u0013}#Xm\u001d;OC6,WCAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\nQA];mKNTA!a \u0002F\u0005)!.\u001e8ji&!\u00111QA=\u0005!!Vm\u001d;OC6,\u0017AC0uKN$h*Y7fA\u0005AA/Z:u\u001d\u0006lW\rK\u0002\u0013\u0003\u0017\u0003B!!$\u0002\u00106\u0011\u0011QP\u0005\u0005\u0003#\u000biH\u0001\u0003Sk2,\u0017AD1tg\u0016\u0014H/\u0012=ji\u000e{G-\u001a\u000b\u0007\u0003K\t9*a'\t\r\u0005e5\u00031\u0001v\u0003!)\u0007\u0010]3di\u0016$\u0007bBAO'\u0001\u0007\u0011qT\u0001\u0007[\u0016$\bn\u001c3\u0011\u000bY\f\t+!\n\n\u0007\u0005\r\u0016NA\u0005Gk:\u001cG/[8oa\u00059\u0012m]:feR\u001c\u0005.Z2l\u0003J<7/\u0012=ji\u000e{G-\u001a\u000b\u0007\u0003K\tI+a+\t\r\u0005eE\u00031\u0001v\u0011\u001d\ti\u000b\u0006a\u0001\u0003_\u000bqa\u001c9uS>t7\u000f\u0005\u0003\u0002\b\u0005E\u0016\u0002BAZ\u0003?\u00111\u0003V8qS\u000e\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\f!c\u0019:fCR,\u0017I\u001c3XC&$Hk\u001c9jGR!\u0011QEA]\u0011\u001d\tY,\u0006a\u0001\u0003_\u000bAa\u001c9ug\u0006\u0019r/Y5u\r>\u0014Hk\u001c9jG\u000e\u0013X-\u0019;fIR1\u0011QEAa\u0003\u000bDq!a1\u0017\u0001\u0004\tI&A\u0005u_BL7MT1nK\"A\u0011q\u0019\f\u0011\u0002\u0003\u0007Q/A\u0004uS6,w.\u001e;\u0002;]\f\u0017\u000e\u001e$peR{\u0007/[2De\u0016\fG/\u001a3%I\u00164\u0017-\u001e7uII*\"!!4+\u0007U\fym\u000b\u0002\u0002RB!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017!C;oG\",7m[3e\u0015\r\tY.[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAp\u0003+\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u0019X\r^;q)\t\t)\u0003K\u0002\u0019\u0003O\u0004B!!$\u0002j&!\u00111^A?\u0005\u0019\u0011UMZ8sK\u0006)1\r\\8tK\"\u001a\u0011$!=\u0011\t\u00055\u00151_\u0005\u0005\u0003k\fiHA\u0003BMR,'/A\nuKN$\b+\u0019:tK\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u001b\u0003w\u0004B!!$\u0002~&!\u0011q`A?\u0005\u0011!Vm\u001d;\u0002GQ,7\u000f\u001e)beN,\u0017i]:jO:lWM\u001c;EkBd\u0017nY1uK\u0016sGO]5fg\"\u001a1$a?\u0002YQ,7\u000f\u001e)beN,\u0017i]:jO:lWM\u001c;QCJ$\u0018\u000e^5p]N|e\rR5gM\u0016\u0014XM\u001c;TSj,\u0007f\u0001\u000f\u0002|\u0006\tC/Z:u\u0007>tg-[4PaR<\u0016\u000e\u001e5C_>$8\u000f\u001e:baN+'O^3sg\"\u001aQ$a?\u0002\u0015Q,7\u000f^\"sK\u0006$X\rK\u0002\u001f\u0003w\fa\u0003^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdGo\u001d\u0015\u0004?\u0005m\u0018\u0001\t;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:D3\u0001IA~\u0003}!Xm\u001d;De\u0016\fG/Z,ji\"$UMZ1vYR\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004C\u0005m\u0018!\u0006;fgR\u001c%/Z1uK^KG\u000f[\"p]\u001aLwm\u001d\u0015\u0004E\u0005m\u0018a\u0007;fgR\u001c%/Z1uK^CWM\\!me\u0016\fG-_#ySN$8\u000fK\u0002$\u0003w\f!\u0006^3ti\u000e\u0013X-\u0019;f/\",g.\u00117sK\u0006$\u00170\u0012=jgR\u001cx+\u001b;i\u0013\u001atu\u000e^#ySN$8\u000fK\u0002%\u0003w\fq\u0004^3ti\u000e\u0013X-\u0019;f/&$\bNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\r)\u00131`\u0001'i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0013:4\u0018\r\\5e%\u0016\u0004H.[2bi&|gNR1di>\u0014\bf\u0001\u0014\u0002|\u00069C/Z:u\u0007J,\u0017\r^3XSRDg*Z4bi&4XMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\r9\u00131`\u0001*i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0007!\nY0\u0001\u0017uKN$8I]3bi\u0016<\u0016\u000e\u001e5BgNLwM\\7f]R\fe\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u001a\u0011&a?\u0002IQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0004\u0016M\u001d;ji&|gnQ8v]RD3AKA~\u0003m!Xm\u001d;J]Z\fG.\u001b3U_BL7\rT3wK2\u001cuN\u001c4jO\"\u001a1&a?\u0002\u001dQ,7\u000f\u001e'jgR$v\u000e]5dg\"\u001aA&a?\u00027Q,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[,iSR,G.[:uQ\ri\u00131`\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0004]\u0005m\u0018a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\ry\u00131`\u0001\u0014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e\u001e\u0015\u0004a\u0005m\u0018a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X-Q:tS\u001etW.\u001a8u)\"\fg\u000eU1si&$\u0018n\u001c8tQ\r\t\u00141`\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]RD3AMA~\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a1'a?\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000fK\u00025\u0003w\fQ\u0004^3ti\u0006cG/\u001a:XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004k\u0005m\u0018!\u000b;fgR\fE\u000e^3s/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u00027\u0003w\f\u0011\u0005^3ti\u000e\u0013X-\u0019;f\u00032$XM\u001d+pa&\u001cw+\u001b;i%\u0006\u001c7.Q<be\u0016D3aNA~\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8oQ\rA\u00141`\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t\u0007fA\u001d\u0002|\u00069B/Z:u\t\u0016dW\r^3J]R,'O\\1m)>\u0004\u0018n\u0019\u0015\u0004u\u0005m\u0018A\b;fgR$U\r\\3uK^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:uQ\rY\u00141`\u0001+i\u0016\u001cH\u000fR3mKR,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR<\u0016\u000e\u001e5JM\u0016C\u0018n\u001d;tQ\ra\u00141`\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0004{\u0005m\u0018\u0001\t;fgR$Um]2sS\n,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgRD3APA~\u00031\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u0002@\u0003w\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f.\u0019<bS2\f'\r\\3QCJ$\u0018\u000e^5p]ND3\u0001QA~\u0003\u0015\"Xm\u001d;EKN\u001c'/\u001b2f+:$WM\u001d*fa2L7-\u0019;fIB\u000b'\u000f^5uS>t7\u000fK\u0002B\u0003w\f\u0011\u0005^3ti\u0012+7o\u0019:jE\u0016,f\u000eZ3s\u001b&t\u0017j\u001d:QCJ$\u0018\u000e^5p]ND3AQA~\u0003\u0005#Xm\u001d;EKN\u001c'/\u001b2f+:$WM\u001d*fa2L7-\u0019;fIB\u000b'\u000f^5uS>t7o\u00165f]J+\u0017m]:jO:lWM\u001c;Jg&s\u0007K]8he\u0016\u001c8\u000fK\u0002D\u0003w\fa\u0004^3ti\u0012+7o\u0019:jE\u0016\fE/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:)\u0007\u0011\u000bY0\u0001\u0014uKN$H)Z:de&\u0014W-\u00168eKJl\u0015N\\%teB\u000b'\u000f^5uS>t7/T5yK\u0012D3!RA~\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f%\u0016\u0004xN\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jOND3ARA~\u00039\"Xm\u001d;EKN\u001c'/\u001b2f\u0003:$G*[:u)>\u0004\u0018nY:XSRDw.\u001e;J]R,'O\\1m)>\u0004\u0018nY:)\u0007\u001d\u000bY0\u0001\u001fuKN$H)Z:de&\u0014W\rR8fg:{GOR1jY^CWM\u001c'jgRLgn\u001a*fCN\u001c\u0018n\u001a8nK:$\u0018j]+oCV$\bn\u001c:ju\u0016$\u0007f\u0001%\u0002|\u0002")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;
    private final TestName _testName = new TestName();

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        String x$2 = this.zkConnect();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var16_3 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var18_5 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var20_7 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var22_9 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var24_11 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var26_13 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = true;
        boolean x$7 = true;
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        None$ x$10 = None$.MODULE$;
        boolean x$11 = true;
        boolean x$12 = false;
        boolean x$13 = false;
        boolean x$14 = false;
        int x$15 = 1;
        boolean x$16 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, x$6, x$7, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setup() {
        void mkString_end;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_2 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        LazyList lazyList = Random$.MODULE$.alphanumeric().take(10);
        if (lazyList == null) {
            throw null;
        }
        LazyList mkString_this = lazyList;
        String mkString_mkString_sep = "";
        String string = "";
        String mkString_start = "";
        Object var5_6 = null;
        string = null;
        Object var4_4 = null;
        Object var2_3 = null;
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_mkString_sep, (String)mkString_end)).toString());
    }

    @After
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testParseAssignment() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void apply_elems4;
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4});
        if (list$ == null) {
            throw null;
        }
        List$ apply_this = list$;
        Object var8_3 = null;
        arraySeq = null;
        Object $minus$greater$extension_y3 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems4);
        Integer $minus$greater$extension_$this = 0;
        Object var2_5 = null;
        Object var3_4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y3);
        List$ list$2 = package$.MODULE$.List();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2});
        if (list$2 == null) {
            throw null;
        }
        List$ apply_this2 = list$2;
        Object var10_7 = null;
        arraySeq2 = null;
        Object object = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems3);
        Integer $minus$greater$extension_$this2 = 1;
        Object var4_9 = null;
        object = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        List$ list$3 = package$.MODULE$.List();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0});
        if (list$3 == null) {
            throw null;
        }
        List$ apply_this3 = list$3;
        Object var12_11 = null;
        arraySeq3 = null;
        Object object2 = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems2);
        Integer $minus$greater$extension_$this3 = 2;
        Object var6_13 = null;
        object2 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)), (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"}));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"}));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"});
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)1000, (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateWhenAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    @Test
    public void testCreateWhenAlreadyExistsWithIfNotExists() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithReplicaAssignment() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems3), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        List$ list$2 = package$.MODULE$.List();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2});
        if (list$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)list$2, (scala.collection.immutable.Seq)apply_elems2), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        List$ list$3 = package$.MODULE$.List();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0});
        if (list$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)list$3, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_4 = null;
        Object var6_5 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        Assert.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterAssignment() {
        void apply_elems;
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id())));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 427));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()}));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        Object var3_2 = null;
        TopicCommand.AdminClientTopicService topicService = new TopicCommand.AdminClientTopicService(apply_adminClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }

    @Test
    public void testAlterWhenTopicDoesntExistWithIfExists() {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_2 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_4 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_6 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_8 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_10 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_12 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                Integer ArrowAssoc_self = tp.partition();
                Object var4_3 = null;
                Integer $minus$greater$extension_$this = ArrowAssoc_self;
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            }
            throw new MatchError(null);
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                Seq replicas = (Seq)x0$2._2();
                Integer ArrowAssoc_self = tp.partition();
                Object var4_3 = null;
                Integer $minus$greater$extension_$this = ArrowAssoc_self;
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            }
            throw new MatchError(null);
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
    }

    @Test
    public void testDeleteWhenTopicDoesntExistWithIfExists() {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeWhenTopicDoesntExist() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
    }

    @Test
    public void testDescribeWhenTopicDoesntExistWithIfExists() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get())).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$8))).get()).partition();
            this.killBroker(0);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$7(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var11_6 = null;
            Object var12_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$12)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var3_2 = null;
            Object var4_3 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$13)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_3 = null;
            Object var5_4 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        void apply_elems;
        void apply_elems2;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$14)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)firstPartition.replicas()).asScala().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(targetReplica))))).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Reassignment didn't add the second node", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var22_14 = null;
        Object var23_15 = null;
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assert.assertEquals((long)2L, (long)simpleDescribeOutputRows.length);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var25_18 = null;
        Object var26_19 = null;
        String underReplicatedOutput = grabConsoleOutput_out2.toString();
        Assert.assertEquals((String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString(), (Object)"", (Object)underReplicatedOutput);
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Option option = Option$.MODULE$.apply((Object)reassignments);
        if (option == null) {
            throw null;
        }
        Object var13_23 = null;
        Option forall_this = option;
        Assert.assertFalse((forall_this.isEmpty() || TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7((PartitionReassignment)forall_this.get()) ? 1 : 0) != 0);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(0, Collections.singletonList(0))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(0, Arrays.asList(1, 2, 3))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$17)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var9_7 = null;
            Object var10_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        output = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        void apply_elems;
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var6_1 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)2L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:1").toString());
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$8) {
        return x$8.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponseData.MetadataResponseTopic x$10) {
        return x$10.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$11) {
        return x$11.partitionIndex() == partitionOnBroker0$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        void apply_elems;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$10))).get()).partitions()).asScala().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$11)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
        }
        if (testPartitionMetadata instanceof Some) {
            MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
            return result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        }
        throw new MatchError((Object)testPartitionMetadata);
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.servers().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$9)))).foldLeft((Object)true, (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandWithAdminClientTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$12) {
        return x$12.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$13) {
        return x$13.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandWithAdminClientTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$16) {
        return x$16.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$17) {
        return x$17.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        this.numPartitions = 1;
    }

    public static final /* synthetic */ Object $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7$adapted(PartitionReassignment x$16) {
        return BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$16));
    }
}

