/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.controller.ReplicaAssignment;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u0001+!)a\u0005\u0001C\u0001O!9\u0011\u0006\u0001a\u0001\n\u0003Q\u0003bB\u001d\u0001\u0001\u0004%\tA\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0015B\u0016\t\u000b\t\u0003A\u0011I\"\t\u000b5\u0003A\u0011A\"\t\u000bI\u0003A\u0011A\"\t\u000bQ\u0003A\u0011A\"\t\u000bY\u0003A\u0011A\"\t\u000ba\u0003A\u0011A\"\t\u000bi\u0003A\u0011A\"\t\u000bq\u0003A\u0011A\"\t\u000by\u0003A\u0011A\"\t\u000b\u0001\u0004A\u0011A\"\u0003#\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002\u0012%\u0005)\u0011\rZ7j]*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00011BD\t\t\u0003/ii\u0011\u0001\u0007\u0006\u00033I\t!A_6\n\u0005mA\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 %\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h!\t\u0019C%D\u0001\u0011\u0013\t)\u0003CA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\t\u0001\u0002\u000fM,'O^3sgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a.\u0005\r\u0019V-\u001d\t\u0003i]j\u0011!\u000e\u0006\u0003mI\taa]3sm\u0016\u0014\u0018B\u0001\u001d6\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u0003=J!AP\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u000e\t\t\u00111\u0001,\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001<Q\t)Q\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006)!.\u001e8ji*\t!*A\u0002pe\u001eL!\u0001T$\u0003\u000b\u00053G/\u001a:\u00027Q,7\u000f^'b]V\fGNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\t1q\n\u0005\u0002G!&\u0011\u0011k\u0012\u0002\u0005)\u0016\u001cH/A\u000buKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:LeNW&)\u0005\u001dy\u0015A\b;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[\"pY2L7/[8oQ\tAq*A\u0011uKN$Xj\\2lK\u0012\u001cuN\\2veJ,g\u000e\u001e+pa&\u001c7I]3bi&|g\u000e\u000b\u0002\n\u001f\u0006YB/Z:u\u0007>t7-\u001e:sK:$Hk\u001c9jG\u000e\u0013X-\u0019;j_:D#AC(\u0002+Q,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u00121bT\u0001$g\"|W\u000f\u001c3Qe>\u0004\u0018mZ1uK\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4tQ\taq*A\u000euKN$(i\\8ugR\u0014\u0018\r]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u0015\u0003\u001b=\u000ba\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0015\u0003\u001d=\u0003")
public class AdminZkClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testManualReplicaAssignment() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void apply_elems4;
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        List brokers = (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems4);
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object[] objectArray = new Tuple2[1];
            SeqOps $minus$greater$extension_y = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            Object[] objectArray = new Tuple2[2];
            SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
            Integer $minus$greater$extension_$this2 = 1;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            Object[] objectArray = new Tuple2[2];
            SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = 1;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 2;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            Object[] objectArray = new Tuple2[3];
            SeqOps $minus$greater$extension_y3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 0;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this3 = 3;
            Object var6_7 = null;
            seqOps2 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_y3;
            Object[] objectArray = new Tuple2[4];
            SeqOps $minus$greater$extension_y4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = -1;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 1;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this3 = 2;
            Object var6_7 = null;
            seqOps2 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
            SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this4 = 4;
            Object var8_9 = null;
            seqOps3 = null;
            objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Object[] objectArray = new Tuple2[2];
        List$ list$2 = package$.MODULE$.List();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        if (list$2 == null) {
            throw null;
        }
        List$ apply_this = list$2;
        Object var10_5 = null;
        arraySeq2 = null;
        Object object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems3);
        Integer $minus$greater$extension_$this = 0;
        Object var5_7 = null;
        object = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        List$ list$3 = package$.MODULE$.List();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        if (list$3 == null) {
            throw null;
        }
        List$ apply_this2 = list$3;
        Object var12_9 = null;
        arraySeq3 = null;
        Object object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems2);
        Integer $minus$greater$extension_$this2 = 1;
        Object var7_11 = null;
        object2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.adminZkClient().createTopicWithAssignment("test", topicConfig, assignment);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"});
        if (set$ == null) {
            throw null;
        }
        arraySeq4 = null;
        Map found = this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertEquals((Object)assignment.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                void $minus$greater$extension_y;
                void apply_removingReplicas;
                int k = x0$1._1$mcI$sp();
                List v = (List)x0$1._2();
                Nil$ nil$ = Nil$.MODULE$;
                Nil$ apply_addingReplicas = Nil$.MODULE$;
                Object var5_4 = null;
                nil$ = null;
                ReplicaAssignment replicaAssignment = new ReplicaAssignment((Seq)v, (Seq)apply_addingReplicas, (Seq)apply_removingReplicas);
                Integer $minus$greater$extension_$this = k;
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }
            throw new MatchError(null);
        }), (Object)found.apply((Object)"test"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreationInZK() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_y13;
        void apply_elems2;
        void $minus$greater$extension_y14;
        void apply_elems3;
        void $minus$greater$extension_y15;
        void apply_elems4;
        void $minus$greater$extension_y16;
        void apply_elems5;
        void $minus$greater$extension_y17;
        void apply_elems6;
        void $minus$greater$extension_y18;
        void apply_elems7;
        void $minus$greater$extension_y19;
        void apply_elems8;
        void $minus$greater$extension_y20;
        void apply_elems9;
        void $minus$greater$extension_y21;
        void apply_elems10;
        void $minus$greater$extension_y22;
        void apply_elems11;
        void $minus$greater$extension_y23;
        void apply_elems12;
        void $minus$greater$extension_y24;
        void apply_elems13;
        Object[] objectArray = new Tuple2[12];
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        if (list$ == null) {
            throw null;
        }
        List$ apply_this = list$;
        Object var55_2 = null;
        arraySeq = null;
        Object object = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems13);
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var6_4 = null;
        object = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y24);
        List$ list$2 = package$.MODULE$.List();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        if (list$2 == null) {
            throw null;
        }
        List$ apply_this2 = list$2;
        Object var57_6 = null;
        arraySeq2 = null;
        Object object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems12);
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var8_8 = null;
        object2 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y23);
        List$ list$3 = package$.MODULE$.List();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4});
        if (list$3 == null) {
            throw null;
        }
        List$ apply_this3 = list$3;
        Object var59_10 = null;
        arraySeq3 = null;
        Object object3 = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems11);
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var10_12 = null;
        object3 = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y22);
        List$ list$4 = package$.MODULE$.List();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0});
        if (list$4 == null) {
            throw null;
        }
        List$ apply_this4 = list$4;
        Object var61_14 = null;
        arraySeq4 = null;
        Object object4 = IterableFactory.apply$((IterableFactory)apply_this4, (scala.collection.immutable.Seq)apply_elems10);
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var12_16 = null;
        object4 = null;
        objectArray[3] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y21);
        List$ list$5 = package$.MODULE$.List();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1});
        if (list$5 == null) {
            throw null;
        }
        List$ apply_this5 = list$5;
        Object var63_18 = null;
        arraySeq5 = null;
        Object object5 = IterableFactory.apply$((IterableFactory)apply_this5, (scala.collection.immutable.Seq)apply_elems9);
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)4);
        Object var14_20 = null;
        object5 = null;
        objectArray[4] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y20);
        List$ list$6 = package$.MODULE$.List();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3});
        if (list$6 == null) {
            throw null;
        }
        List$ apply_this6 = list$6;
        Object var65_22 = null;
        arraySeq6 = null;
        Object object6 = IterableFactory.apply$((IterableFactory)apply_this6, (scala.collection.immutable.Seq)apply_elems8);
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)5);
        Object var16_24 = null;
        object6 = null;
        objectArray[5] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y19);
        List$ list$7 = package$.MODULE$.List();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4});
        if (list$7 == null) {
            throw null;
        }
        List$ apply_this7 = list$7;
        Object var67_26 = null;
        arraySeq7 = null;
        Object object7 = IterableFactory.apply$((IterableFactory)apply_this7, (scala.collection.immutable.Seq)apply_elems7);
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)6);
        Object var18_28 = null;
        object7 = null;
        objectArray[6] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y18);
        List$ list$8 = package$.MODULE$.List();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0});
        if (list$8 == null) {
            throw null;
        }
        List$ apply_this8 = list$8;
        Object var69_30 = null;
        arraySeq8 = null;
        Object object8 = IterableFactory.apply$((IterableFactory)apply_this8, (scala.collection.immutable.Seq)apply_elems6);
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)7);
        Object var20_32 = null;
        object8 = null;
        objectArray[7] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y17);
        List$ list$9 = package$.MODULE$.List();
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1});
        if (list$9 == null) {
            throw null;
        }
        List$ apply_this9 = list$9;
        Object var71_34 = null;
        arraySeq9 = null;
        Object object9 = IterableFactory.apply$((IterableFactory)apply_this9, (scala.collection.immutable.Seq)apply_elems5);
        Object $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc((Object)8);
        Object var22_36 = null;
        object9 = null;
        objectArray[8] = new Tuple2($minus$greater$extension_$this9, (Object)$minus$greater$extension_y16);
        List$ list$10 = package$.MODULE$.List();
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2});
        if (list$10 == null) {
            throw null;
        }
        List$ apply_this10 = list$10;
        Object var73_38 = null;
        arraySeq10 = null;
        Object object10 = IterableFactory.apply$((IterableFactory)apply_this10, (scala.collection.immutable.Seq)apply_elems4);
        Object $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc((Object)9);
        Object var24_40 = null;
        object10 = null;
        objectArray[9] = new Tuple2($minus$greater$extension_$this10, (Object)$minus$greater$extension_y15);
        List$ list$11 = package$.MODULE$.List();
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        if (list$11 == null) {
            throw null;
        }
        List$ apply_this11 = list$11;
        Object var75_42 = null;
        arraySeq11 = null;
        Object object11 = IterableFactory.apply$((IterableFactory)apply_this11, (scala.collection.immutable.Seq)apply_elems3);
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)10);
        Object var26_44 = null;
        object11 = null;
        objectArray[10] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y14);
        List$ list$12 = package$.MODULE$.List();
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4});
        if (list$12 == null) {
            throw null;
        }
        List$ apply_this12 = list$12;
        Object var77_46 = null;
        arraySeq12 = null;
        Object object12 = IterableFactory.apply$((IterableFactory)apply_this12, (scala.collection.immutable.Seq)apply_elems2);
        Object $minus$greater$extension_$this12 = Predef$.MODULE$.ArrowAssoc((Object)11);
        Object var28_48 = null;
        object12 = null;
        objectArray[11] = new Tuple2($minus$greater$extension_$this12, (Object)$minus$greater$extension_y13);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[12];
        Integer n = 0;
        Object $minus$greater$extension_$this13 = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var30_51 = null;
        n = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this13, (Object)$minus$greater$extension_y12);
        Integer n2 = 1;
        Object $minus$greater$extension_$this14 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var32_53 = null;
        n2 = null;
        objectArray2[1] = new Tuple2($minus$greater$extension_$this14, (Object)$minus$greater$extension_y11);
        Integer n3 = 2;
        Object $minus$greater$extension_$this15 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var34_55 = null;
        n3 = null;
        objectArray2[2] = new Tuple2($minus$greater$extension_$this15, (Object)$minus$greater$extension_y10);
        Integer n4 = 3;
        Object $minus$greater$extension_$this16 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var36_57 = null;
        n4 = null;
        objectArray2[3] = new Tuple2($minus$greater$extension_$this16, (Object)$minus$greater$extension_y9);
        Integer n5 = 4;
        Object $minus$greater$extension_$this17 = Predef$.MODULE$.ArrowAssoc((Object)4);
        Object var38_59 = null;
        n5 = null;
        objectArray2[4] = new Tuple2($minus$greater$extension_$this17, (Object)$minus$greater$extension_y8);
        Integer n6 = 0;
        Object $minus$greater$extension_$this18 = Predef$.MODULE$.ArrowAssoc((Object)5);
        Object var40_61 = null;
        n6 = null;
        objectArray2[5] = new Tuple2($minus$greater$extension_$this18, (Object)$minus$greater$extension_y7);
        Integer n7 = 1;
        Object $minus$greater$extension_$this19 = Predef$.MODULE$.ArrowAssoc((Object)6);
        Object var42_63 = null;
        n7 = null;
        objectArray2[6] = new Tuple2($minus$greater$extension_$this19, (Object)$minus$greater$extension_y6);
        Integer n8 = 2;
        Object $minus$greater$extension_$this20 = Predef$.MODULE$.ArrowAssoc((Object)7);
        Object var44_65 = null;
        n8 = null;
        objectArray2[7] = new Tuple2($minus$greater$extension_$this20, (Object)$minus$greater$extension_y5);
        Integer n9 = 3;
        Object $minus$greater$extension_$this21 = Predef$.MODULE$.ArrowAssoc((Object)8);
        Object var46_67 = null;
        n9 = null;
        objectArray2[8] = new Tuple2($minus$greater$extension_$this21, (Object)$minus$greater$extension_y4);
        Integer n10 = 4;
        Object $minus$greater$extension_$this22 = Predef$.MODULE$.ArrowAssoc((Object)9);
        Object var48_69 = null;
        n10 = null;
        objectArray2[9] = new Tuple2($minus$greater$extension_$this22, (Object)$minus$greater$extension_y3);
        Integer n11 = 1;
        Object $minus$greater$extension_$this23 = Predef$.MODULE$.ArrowAssoc((Object)10);
        Object var50_71 = null;
        n11 = null;
        objectArray2[10] = new Tuple2($minus$greater$extension_$this23, (Object)$minus$greater$extension_y2);
        Integer n12 = 1;
        Object $minus$greater$extension_$this24 = Predef$.MODULE$.ArrowAssoc((Object)11);
        Object var52_73 = null;
        n12 = null;
        objectArray2[11] = new Tuple2($minus$greater$extension_$this24, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)scala.collection.immutable.Map$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        String topic = "test";
        Properties topicConfig = new Properties();
        List$ list$13 = package$.MODULE$.List();
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4});
        if (list$13 == null) {
            throw null;
        }
        arraySeq13 = null;
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)list$13, (scala.collection.immutable.Seq)apply_elems)));
        this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaMap = ((IterableOnceOps)leaderForPartitionMap.keys().map((Function1 & Serializable)p -> AdminZkClientTest.$anonfun$testTopicCreationInZK$1(this, topic, BoxesRunTime.unboxToInt((Object)p)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaMap.size());
        int n13 = 0;
        int until$extension_end = actualReplicaMap.size();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n13, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicCreationInZK$2(expectedReplicaAssignment, actualReplicaMap, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var80_81 = null;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreationWithCollision() {
        void apply_elems;
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems)));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, 3, 1, x$4, x$5);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Properties x$9 = qual$2.createTopic$default$4();
            RackAwareMode x$10 = qual$2.createTopic$default$5();
            qual$2.createTopic(collidingTopic, 3, 1, x$9, x$10);
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMockedConcurrentTopicCreation() {
        void apply_elems;
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkMock.topicExists(topic)).andReturn((Object)false);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        EasyMock.expect((Object)zkMock.getAllTopicsInCluster(false)).andReturn(IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        EasyMock.replay((Object[])new Object[]{zkMock});
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentTopicCreation() {
        void apply_elems;
        String topic = "test-concurrent-topic-creation";
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems)));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)Nil$.MODULE$)), 15000);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        void createServer_time;
        void createServer_config;
        int partitions = 3;
        String topic = "my-topic";
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Object var11_5 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, partitions, 1, x$4, x$5);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).map((Function1 & Serializable)x$1 -> {
            Time createServer_time = Time.SYSTEM;
            return TestUtils$.MODULE$.createServer((KafkaConfig)x$1, createServer_time, (Option<String>)None$.MODULE$);
        })));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(limit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(limit))})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(newLimit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(newLimit))})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            Assert.assertEquals((long)newLimit, (long)Integer.parseInt(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp())));
            Assert.assertEquals((long)newLimit, (long)Integer.parseInt(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp())));
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBootstrapClientIdConfig() {
        void createServer_time;
        void createServer_config;
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overridden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Object var5_6 = null;
        kafkaConfig = null;
        time = null;
        KafkaServer server = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetBrokerMetadatas() {
        void apply_elems;
        void apply_elems2;
        Object var41_32;
        int fill_n;
        Object var38_24;
        int fill_n2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        int n = 0;
        int to$extension_end = 5;
        Range.Inclusive brokerList = new Range.Inclusive(n, to$extension_end, 1);
        Object[] objectArray = new Tuple2[5];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var20_5 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var22_7 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var24_9 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var26_11 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y2);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 5;
        Object var28_13 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y);
        Map rackInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Set filterNot_pred = rackInfo.keySet();
        Object var30_15 = null;
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)StrictOptimizedIterableOps.filterNot$((StrictOptimizedIterableOps)brokerList, (Function1)filterNot_pred)));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$22 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$22);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id())));
        int n2 = SeqOps.size$((SeqOps)brokerList);
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        ListBuffer fill_b = new ListBuffer();
        fill_b.sizeHint(fill_n2);
        for (int fill_i = 0; fill_i < fill_n2; ++fill_i) {
            None$ fill_$plus$eq_elem = None$.MODULE$;
            fill_b.addOne((Object)fill_$plus$eq_elem);
            var38_24 = null;
        }
        Object var36_22 = null;
        var38_24 = null;
        Assert.assertEquals((Object)((SeqOps)fill_b.result()), (Object)processedMetadatas1.map((Function1 & Serializable)x$3 -> x$3.rack()));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$32 = RackAwareMode.Safe$.MODULE$;
        Option x$42 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$32, x$42);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        int n3 = SeqOps.size$((SeqOps)brokerList);
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        ListBuffer fill_b2 = new ListBuffer();
        fill_b2.sizeHint(fill_n);
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            None$ fill_$plus$eq_elem = None$.MODULE$;
            fill_b2.addOne((Object)fill_$plus$eq_elem);
            var41_32 = null;
        }
        Object var39_30 = null;
        var41_32 = null;
        Assert.assertEquals((Object)((SeqOps)fill_b2.result()), (Object)processedMetadatas2.map((Function1 & Serializable)x$5 -> x$5.rack()));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            return qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        List$ list$ = package$.MODULE$.List();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5});
        if (list$ == null) {
            throw null;
        }
        arraySeq = null;
        List partialList = (List)IterableFactory.apply$((IterableFactory)list$, (scala.collection.immutable.Seq)apply_elems2);
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo), (Object)processedMetadatas3.flatMap((Function1 & Serializable)x$7 -> x$7.rack()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        qual$4.createTopic("foo", numPartitions, 2, x$11, (RackAwareMode)x$10);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$testTopicCreationInZK$1(AdminZkClientTest $this, String topic$1, int p) {
        void $minus$greater$extension_y;
        Seq seq = $this.zkClient().getReplicasForPartition(new TopicPartition(topic$1, p));
        Integer $minus$greater$extension_$this = p;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$testTopicCreationInZK$2(Map expectedReplicaAssignment$1, scala.collection.immutable.Map actualReplicaMap$1, int i) {
        Assert.assertEquals((Object)expectedReplicaAssignment$1.get((Object)i).get(), (Object)actualReplicaMap$1.apply((Object)i));
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Seq seq = partitionReplicaAssignment.replicas();
            if (seq == null) {
                throw null;
            }
            Assert.assertEquals((String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString(), (long)1L, (long)seq.length());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$3, Properties props$1) {
        void var6_7;
        void apply_elems;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            qual$1.createTopic(topic$3, 3, 1, props$1, x$5);
        }
        catch (TopicExistsException topicExistsException) {}
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$3});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assert.assertEquals((long)3L, (long)var6_7.size());
        var6_7.foreach((Function1 & Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$3);
        Assert.assertEquals((Object)props$1, (Object)savedProps);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(messageSize));
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assert.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assert.assertEquals((Object)ArrayOps$.MODULE$.toIndexedSeq$extension((Object)expected.split(",")), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$2(String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1, int part) {
        TopicPartition tp = new TopicPartition(topic$4, part);
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(tp, x$2);
        Assert.assertTrue((boolean)log.isDefined());
        Assert.assertEquals((Object)retentionMs$1, (Object)((Log)log.get()).config().retentionMs());
        Assert.assertEquals((Object)messageSize$1, (Object)((Log)log.get()).config().maxMessageSize());
        AdminZkClientTest.checkList$1(((Log)log.get()).config().LeaderReplicationThrottledReplicas(), throttledLeaders$1);
        AdminZkClientTest.checkList$1(((Log)log.get()).config().FollowerReplicationThrottledReplicas(), throttledFollowers$1);
        Assert.assertEquals((Object)quotaManagerIsThrottled$1, (Object)server$1.quotaManagers().leader().isThrottled(tp));
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, partitions$1, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicConfigChange$2(topic$4, server$1, retentionMs$1, messageSize$1, throttledLeaders$1, throttledFollowers$1, quotaManagerIsThrottled$1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$4, KafkaServer server$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$4, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().leader().upperBound());
        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().follower().upperBound());
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$3(AdminZkClientTest $this, long limit$1) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long limit) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$3(this, limit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$5() {
        return None$.MODULE$;
    }
}

