/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001\u0002\u000f\u001e\u0001\tBQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001A\u0002\u0013\u0005a\u0006C\u00048\u0001\u0001\u0007I\u0011\u0001\u001d\t\r\u0005\u0003\u0001\u0015)\u00030\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCqa\u0012\u0001A\u0002\u0013\u0005\u0001\n\u0003\u0004K\u0001\u0001\u0006K\u0001\u0012\u0005\b\u0017\u0002\u0001\r\u0011\"\u0001/\u0011\u001da\u0005\u00011A\u0005\u00025Caa\u0014\u0001!B\u0013y\u0003b\u0002)\u0001\u0001\u0004%\ta\u0011\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0011\u0019!\u0006\u0001)Q\u0005\t\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB/\u0001A\u0003%q\u000bC\u0004_\u0001\u0001\u0007I\u0011A0\t\u000f%\u0004\u0001\u0019!C\u0001U\"1A\u000e\u0001Q!\n\u0001DQ!\u001c\u0001\u0005B9DQ\u0001\u001f\u0001\u0005B9DQ! \u0001\u0005\u00029Da!!\u0002\u0001\t\u0003q\u0007BBA\u0005\u0001\u0011\u0005a\u000e\u0003\u0004\u0002\u000e\u0001!\tA\u001c\u0005\u0007\u0003#\u0001A\u0011\u00018\t\r\u0005U\u0001\u0001\"\u0001o\u0011\u001d\tI\u0002\u0001C\u0001\u00037\u0011!dU3sm\u0016\u0014x)\u001a8fe\u0006$XM\u0011:pW\u0016\u0014\u0018\n\u001a+fgRT!AH\u0010\u0002\rM,'O^3s\u0015\u0005\u0001\u0013!B6bM.\f7\u0001A\n\u0003\u0001\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u0010\u0002\u0005i\\\u0017B\u0001\u0015&\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011!H\u0001\u0007aJ|\u0007o]\u0019\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0006Qe>\u0004XM\u001d;jKN\f!\u0002\u001d:paN\ft\fJ3r)\tIt\b\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0003V]&$\bb\u0002!\u0004\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0014a\u00029s_B\u001c\u0018\u0007I\u0001\bG>tg-[42+\u0005!\u0005C\u0001\u0017F\u0013\t1UDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aC2p]\u001aLw-M0%KF$\"!O%\t\u000f\u00013\u0011\u0011!a\u0001\t\u0006A1m\u001c8gS\u001e\f\u0004%\u0001\u0004qe>\u00048OM\u0001\u000baJ|\u0007o\u001d\u001a`I\u0015\fHCA\u001dO\u0011\u001d\u0001\u0015\"!AA\u0002=\nq\u0001\u001d:paN\u0014\u0004%A\u0004d_:4\u0017n\u001a\u001a\u0002\u0017\r|gNZ5he}#S-\u001d\u000b\u0003sMCq\u0001\u0011\u0007\u0002\u0002\u0003\u0007A)\u0001\u0005d_:4\u0017n\u001a\u001a!\u0003M\u0011'o\\6fe6+G/\u0019)s_B\u001ch)\u001b7f+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001.4\u0003\u0011a\u0017M\\4\n\u0005qK&AB*ue&tw-\u0001\u000bce>\\WM]'fi\u0006\u0004&o\u001c9t\r&dW\rI\u0001\bg\u0016\u0014h/\u001a:t+\u0005\u0001\u0007cA1eM6\t!M\u0003\u0002dw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0014'aA*fcB\u0011AfZ\u0005\u0003Qv\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\tI4\u000eC\u0004A#\u0005\u0005\t\u0019\u00011\u0002\u0011M,'O^3sg\u0002\nQa]3u+B$\u0012!\u000f\u0015\u0003'A\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u000b),h.\u001b;\u000b\u0003U\f1a\u001c:h\u0013\t9(O\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u0012AC\u001f\t\u0003cnL!\u0001 :\u0003\u000b\u00053G/\u001a:\u00021Q,7\u000f^!vi><UM\\3sCR,'I]8lKJLE\r\u000b\u0002\u0016\u007fB\u0019\u0011/!\u0001\n\u0007\u0005\r!O\u0001\u0003UKN$\u0018A\t;fgR,6/\u001a:D_:4\u0017nZ!oI\u001e+g.\u001a:bi\u0016$'I]8lKJLE\r\u000b\u0002\u0017\u007f\u0006aB/Z:u\t&\u001c\u0018M\u00197f\u000f\u0016tWM]1uK\u0012\u0014%o\\6fe&#\u0007FA\f\u0000\u0003q!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0019><G)\u001b:t\u001b\u0016$\u0018\r\u0015:paND#\u0001G@\u0002aQ,7\u000f^\"p]NL7\u000f^3oi\n\u0013xn[3s\u0013\u00124%o\\7Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ'fi\u0006\u0004&o\u001c9tQ\tIr0A\u0010uKN$(I]8lKJlU\r^1eCR\fwJ\\%e\u0007>dG.[:j_:D#AG@\u0002)Y,'/\u001b4z\u0005J|7.\u001a:NKR\fG-\u0019;b)\u0019\ti\"a\t\u0002>A\u0019!(a\b\n\u0007\u0005\u00052HA\u0004C_>dW-\u00198\t\u000f\u0005\u00152\u00041\u0001\u0002(\u00059An\\4ESJ\u001c\b\u0003B1e\u0003S\u0001B!a\u000b\u0002:9!\u0011QFA\u001b!\r\tycO\u0007\u0003\u0003cQ1!a\r\"\u0003\u0019a$o\\8u}%\u0019\u0011qG\u001e\u0002\rA\u0013X\rZ3g\u0013\ra\u00161\b\u0006\u0004\u0003oY\u0004bBA 7\u0001\u0007\u0011\u0011I\u0001\tEJ|7.\u001a:JIB\u0019!(a\u0011\n\u0007\u0005\u00153HA\u0002J]R\u0004")
public class ServerGenerateBrokerIdTest
extends ZooKeeperTestHarness {
    private Properties props1 = null;
    private KafkaConfig config1 = null;
    private Properties props2 = null;
    private KafkaConfig config2 = null;
    private final String brokerMetaPropsFile;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateBrokerId() {
        void createServer_threadNamePrefix;
        void createServer_config;
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        Nil$ x$4 = Nil$.MODULE$;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, (Seq)x$4);
        server1.startup();
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        KafkaConfig kafkaConfig = this.config1();
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Object var6_8 = null;
        kafkaConfig = null;
        option = null;
        server1 = createServer_this.createServer((KafkaConfig)createServer_config, Time.SYSTEM, (Option<String>)createServer_threadNamePrefix);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$12 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        Nil$ x$4 = Nil$.MODULE$;
        KafkaServer server1 = new KafkaServer(x$12, x$3, x$2, (Seq)x$4);
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        Nil$ x$8 = Nil$.MODULE$;
        KafkaServer server2 = new KafkaServer(x$5, x$7, x$6, (Seq)x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = Time.SYSTEM;
        Nil$ x$122 = Nil$.MODULE$;
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, (Seq)x$122);
        server1.startup();
        Assert.assertEquals((long)server1.config().brokerId(), (long)1001L);
        server2.startup();
        Assert.assertEquals((long)server2.config().brokerId(), (long)0L);
        server3.startup();
        Assert.assertEquals((long)server3.config().brokerId(), (long)1002L);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableGeneratedBrokerId() {
        void createServer_threadNamePrefix;
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props3.put(KafkaConfig$.MODULE$.BrokerIdGenerationEnableProp(), "false");
        props3.put(KafkaConfig$.MODULE$.MaxReservedBrokerIdProp(), "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Object var4_4 = null;
        option = null;
        KafkaServer server3 = createServer_this.createServer(config3, Time.SYSTEM, (Option<String>)createServer_threadNamePrefix);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assert.assertEquals((long)server3.config().brokerId(), (long)3L);
        server3.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        Nil$ x$4 = Nil$.MODULE$;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, (Seq)x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils.tempDirectory(null, null).getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        Nil$ x$8 = Nil$.MODULE$;
        server1 = new KafkaServer(x$5, x$7, x$6, (Seq)x$8);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        Nil$ x$4 = Nil$.MODULE$;
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, (Seq)x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = Time.SYSTEM;
        Nil$ x$8 = Nil$.MODULE$;
        server1 = new KafkaServer(x$5, x$7, x$6, (Seq)x$8);
        try {
            server1.startup();
        }
        catch (InconsistentBrokerIdException inconsistentBrokerIdException) {}
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerMetadataOnIdCollision() {
        void createServer_threadNamePrefix;
        void createServer_threadNamePrefix2;
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        Option option = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        Object var12_4 = null;
        option = null;
        KafkaServer serverA = createServer_this.createServer(configA, Time.SYSTEM, (Option<String>)createServer_threadNamePrefix2);
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = Time.SYSTEM;
        Nil$ x$4 = Nil$.MODULE$;
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, (Seq)x$4);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> serverB.startup(), ClassTag$.MODULE$.apply(KeeperException.NodeExistsException.class), new Position("ServerGenerateBrokerIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        serverB.config().logDirs().foreach((Function1 & Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$2(this, logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty(KafkaConfig$.MODULE$.BrokerIdProp(), "2");
        KafkaConfig newConfigB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option option2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        TestUtils$ createServer_this2 = TestUtils$.MODULE$;
        Object var14_14 = null;
        option2 = null;
        KafkaServer newServerB = createServer_this2.createServer(newConfigB, Time.SYSTEM, (Option<String>)createServer_threadNamePrefix);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)newServerB, (List)Nil$.MODULE$)));
        serverA.shutdown();
        newServerB.shutdown();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)newServerB.config().logDirs(), 2));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(this, brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$2(ServerGenerateBrokerIdTest $this, String logDir) {
        Assert.assertFalse((boolean)new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString()).exists());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateBrokerIdTest $this, int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            if (((BrokerMetadata)((Some)brokerMetadataOpt).value()).brokerId() != brokerId$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
            return;
        }
        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
    }

    public ServerGenerateBrokerIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

