/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.Log$;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005a4A!\u0004\b\u0001'!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0015\u0001A\u0003%!\u0005C\u0004*\u0001\t\u0007I\u0011\u0002\u0016\t\r9\u0002\u0001\u0015!\u0003,\u0011\u001dy\u0003A1A\u0005\nABa\u0001\u000e\u0001!\u0002\u0013\t\u0004\"B\u001b\u0001\t\u00031\u0004\"B!\u0001\t\u00031\u0004\"B\"\u0001\t\u0013!\u0005\"\u0002.\u0001\t\u0013Y\u0006\"\u0002:\u0001\t\u0013\u0019(\u0001\u0005#fY\u0006LX\r\u001a$fi\u000eDG+Z:u\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0005fCNLXn\\2l\u0015\u0005I\u0012aA8sO&\u00111D\u0006\u0002\u0010\u000b\u0006\u001c\u00180T8dWN+\b\u000f]8si\u00061A(\u001b8jiz\"\u0012A\b\t\u0003?\u0001i\u0011AD\u0001\t[\u0006D()\u001f;fgV\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CEA\u0002J]R\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\t1\u0006\u0005\u0002 Y%\u0011QF\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013\u0001\u0004:fa2L7-Y)v_R\fW#A\u0019\u0011\u0005}\u0011\u0014BA\u001a\u000f\u00051\u0011V\r\u001d7jG\u0006\fVo\u001c;b\u00035\u0011X\r\u001d7jG\u0006\fVo\u001c;bA\u0005AB/Z:u\r\u0016$8\r[,ji\"4UM\\2fI\u0016\u0003xn\u00195\u0015\u0003]\u0002\"a\t\u001d\n\u0005e\"#\u0001B+oSRD#\u0001C\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005yB\u0012!\u00026v]&$\u0018B\u0001!>\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e(pi2+\u0017\rZ3s\u001fJ4u\u000e\u001c7po\u0016\u0014\bFA\u0005<\u0003I\u0011W/\u001b7e\r\u0016$8\r['fi\u0006$\u0017\r^1\u0015\t\u0015C%*\u0016\t\u0003?\u0019K!a\u0012\b\u0003\u001b\u0019+Go\u00195NKR\fG-\u0019;b\u0011\u0015I%\u00021\u0001#\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0003L\u0015\u0001\u0007A*\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\u00055\u001bV\"\u0001(\u000b\u0005=\u0003\u0016AB2p[6|gN\u0003\u0002\u0012#*\u0011!\u000bG\u0001\u0007CB\f7\r[3\n\u0005Qs%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006-*\u0001\raV\u0001\fM\u0016$8\r[*uCR,8\u000f\u0005\u0002 1&\u0011\u0011L\u0004\u0002\u0015\r\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0002=\u0015D\b/Z2u%\u0016\fGM\u0012:p[J+\u0007\u000f\\5dC^KG\u000f[#se>\u0014H#B\u001c];zS\u0007\"B%\f\u0001\u0004\u0011\u0003\"B&\f\u0001\u0004a\u0005\"B0\f\u0001\u0004\u0001\u0017A\u00054fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\u0004\"!Y4\u000f\u0005\t,W\"A2\u000b\u0005\u0011t\u0015\u0001\u0003:fcV,7\u000f^:\n\u0005\u0019\u001c\u0017\u0001\u0004$fi\u000eD'+Z9vKN$\u0018B\u00015j\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*\u0011am\u0019\u0005\u0006W.\u0001\r\u0001\\\u0001\u0006KJ\u0014xN\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_:\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003c:\u0014a!\u0012:s_J\u001c\u0018\u0001\u00072vS2$'+Z1e%\u0016\u001cX\u000f\u001c;XSRDWI\u001d:peR\u0011Ao\u001e\t\u0003?UL!A\u001e\b\u0003\u001b1{wMU3bIJ+7/\u001e7u\u0011\u0015YG\u00021\u0001m\u0001")
public class DelayedFetchTest
extends EasyMockSupport {
    private final int maxBytes;
    private final ReplicaManager replicaManager = (ReplicaManager)this.mock(ReplicaManager.class);
    private final ReplicaQuota replicaQuota = (ReplicaQuota)this.mock(ReplicaQuota.class);

    private int maxBytes() {
        return this.maxBytes;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private ReplicaQuota replicaQuota() {
        return this.replicaQuota;
    }

    @Test
    public void testFetchWithFencedEpoch() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(10);
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        None$ create_e = None$.MODULE$;
        Object var14_8 = null;
        ObjectRef fetchResultOpt = new ObjectRef((Object)create_e);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$1(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        Partition partition = (Partition)this.mock(Partition.class);
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andReturn((Object)partition);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(currentLeaderEpoch, true)).andThrow((Throwable)new FencedLeaderEpochException("Requested epoch has been fenced"));
        EasyMock.expect((Object)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)false);
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.FENCED_LEADER_EPOCH);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
        FetchPartitionData fetchResult = (FetchPartitionData)((Option)fetchResultOpt.elem).get();
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.error());
    }

    @Test
    public void testNotLeaderOrFollower() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        long fetchOffset = 500L;
        long logStartOffset = 0L;
        Optional<Integer> currentLeaderEpoch = Optional.of(10);
        int replicaId = 1;
        FetchPartitionStatus fetchStatus = new FetchPartitionStatus(new LogOffsetMetadata(fetchOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), new FetchRequest.PartitionData(fetchOffset, logStartOffset, this.maxBytes(), currentLeaderEpoch));
        FetchMetadata fetchMetadata = this.buildFetchMetadata(replicaId, topicPartition, fetchStatus);
        None$ create_e = None$.MODULE$;
        Object var12_8 = null;
        ObjectRef fetchResultOpt = new ObjectRef((Object)create_e);
        DelayedFetch delayedFetch = new DelayedFetch(500L, fetchMetadata, this.replicaManager(), this.replicaQuota(), (Option)None$.MODULE$, (Function1 & Serializable)responses -> {
            DelayedFetchTest.callback$2(responses, fetchResultOpt);
            return BoxedUnit.UNIT;
        });
        EasyMock.expect((Object)this.replicaManager().getPartitionOrException(topicPartition)).andThrow((Throwable)new NotLeaderOrFollowerException(new StringBuilder(26).append("Replica for ").append(topicPartition).append(" not available").toString()));
        this.expectReadFromReplicaWithError(replicaId, topicPartition, fetchStatus.fetchInfo(), Errors.NOT_LEADER_OR_FOLLOWER);
        EasyMock.expect((Object)this.replicaManager().isAddingReplica((TopicPartition)EasyMock.anyObject(), EasyMock.anyInt())).andReturn((Object)false);
        this.replayAll();
        Assert.assertTrue((boolean)delayedFetch.tryComplete());
        Assert.assertTrue((boolean)delayedFetch.isCompleted());
        Assert.assertTrue((boolean)((Option)fetchResultOpt.elem).isDefined());
    }

    private FetchMetadata buildFetchMetadata(int replicaId, TopicPartition topicPartition, FetchPartitionStatus fetchStatus) {
        return new FetchMetadata(1, this.maxBytes(), false, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, replicaId, (Seq)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchStatus), (List)Nil$.MODULE$));
    }

    private void expectReadFromReplicaWithError(int replicaId, TopicPartition topicPartition, FetchRequest.PartitionData fetchPartitionData, Errors error) {
        FetchLogEnd$ x$3 = FetchLogEnd$.MODULE$;
        int x$4 = this.maxBytes();
        .colon.colon x$6 = new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)fetchPartitionData), (List)Nil$.MODULE$);
        None$ x$7 = None$.MODULE$;
        ReplicaQuota x$8 = this.replicaQuota();
        EasyMock.expect((Object)this.replicaManager().readFromLocalLog(replicaId, true, (FetchIsolation)x$3, x$4, false, (Seq)x$6, x$8, (Option)x$7)).andReturn((Object)new .colon.colon((Object)new Tuple2((Object)topicPartition, (Object)this.buildReadResultWithError(error)), (List)Nil$.MODULE$));
    }

    private LogReadResult buildReadResultWithError(Errors error) {
        Some x$1 = new Some((Object)error.exception());
        FetchDataInfo x$2 = new FetchDataInfo(LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata(), (Records)MemoryRecords.EMPTY, false, (Option)None$.MODULE$);
        None$ x$8 = None$.MODULE$;
        None$ x$9 = None$.MODULE$;
        return new LogReadResult(x$2, -1L, -1L, -1L, -1L, -1L, (Option)x$8, (Option)x$9, (Option)x$1);
    }

    private static final void callback$1(Seq responses, ObjectRef fetchResultOpt$1) {
        fetchResultOpt$1.elem = new Some(((Tuple2)responses.head())._2());
    }

    private static final void callback$2(Seq responses, ObjectRef fetchResultOpt$2) {
        fetchResultOpt$2.elem = new Some(((Tuple2)responses.head())._2());
    }

    public DelayedFetchTest() {
        this.maxBytes = 1024;
    }
}

