/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import kafka.common.KafkaException;
import kafka.security.auth.Group$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import org.apache.kafka.common.resource.PatternType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!3A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)!\u0007\u0001C\u0001;!)A\u0007\u0001C\u0001;!)a\u0007\u0001C\u0001;!)\u0001\b\u0001C\u0001;!)!\b\u0001C\u0001;!)A\b\u0001C\u0001;\ta!+Z:pkJ\u001cW\rV3ti*\u00111\u0002D\u0001\u0005CV$\bN\u0003\u0002\u000e\u001d\u0005A1/Z2ve&$\u0018PC\u0001\u0010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t!\"A\u0019tQ>,H\u000e\u001a+ie><xJ\u001c+x_B\u000b'\u000f^*ue&twmV5uQVs7N\\8x]J+7o\\;sG\u0016$\u0016\u0010]3\u0015\u0003y\u0001\"aE\u0010\n\u0005\u0001\"\"\u0001B+oSRDCA\u0001\u0012+WA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002O\u0005\u0019qN]4\n\u0005%\"#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002YA\u0011Q\u0006M\u0007\u0002])\u0011qFD\u0001\u0007G>lWn\u001c8\n\u0005Er#AD&bM.\fW\t_2faRLwN\\\u0001&g\"|W\u000f\u001c3UQJ|wo\u00148CC\u0012\u0014Vm]8ve\u000e,G+\u001f9f'\u0016\u0004\u0018M]1u_JDCa\u0001\u0012+W\u0005Y2\u000f[8vY\u0012\u0004\u0016M]:f\u001f2$Gk^8QCJ$8\u000b\u001e:j]\u001eD#\u0001\u0002\u0012\u0002WMDw.\u001e7e!\u0006\u00148/Z(mIR;x\u000eU1si^KG\u000f[#nE\u0016$G-\u001a3TKB\f'/\u0019;peND#!\u0002\u0012\u00025MDw.\u001e7e!\u0006\u00148/\u001a+ie\u0016,\u0007+\u0019:u'R\u0014\u0018N\\4)\u0005\u0019\u0011\u0013AK:i_VdG\rU1sg\u0016$\u0006N]3f!\u0006\u0014HoV5uQ\u0016k'-\u001a3eK\u0012\u001cV\r]1sCR|'o\u001d\u0015\u0003\u000f\t\n\u0001d\u001d5pk2$'k\\;oIR\u0013\u0018\u000e\u001d,jCN#(/\u001b8hQ\tA!\u0005\u000b\u0004\u0001\u007f\t\u001bUI\u0012\t\u0003'\u0001K!!\u0011\u000b\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003\u0011\u000bA'V:fA=\u0014xML1qC\u000eDWML6bM.\fgfY8n[>tgF]3t_V\u00148-\u001a\u0018SKN|WO]2f!\u0006$H/\u001a:o\u0003\u0015\u0019\u0018N\\2fC\u00059\u0015!C*j]\u000e,\u0007E\r\u00186\u0001")
public class ResourceTest {
    @Test(expected=KafkaException.class)
    public void shouldThrowOnTwoPartStringWithUnknownResourceType() {
        Resource$.MODULE$.fromString("Unknown:fred");
    }

    @Test(expected=KafkaException.class)
    public void shouldThrowOnBadResourceTypeSeparator() {
        Resource$.MODULE$.fromString("Topic-fred");
    }

    @Test
    public void shouldParseOldTwoPartString() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:fred"));
        Assert.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:t"));
    }

    @Test
    public void shouldParseOldTwoPartWithEmbeddedSeparators() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldParseThreePartString() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED:fred"));
        Assert.assertEquals((Object)new Resource((ResourceType)Topic$.MODULE$, "t", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Topic:LITERAL:t"));
    }

    @Test
    public void shouldParseThreePartWithEmbeddedSeparators() {
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.PREFIXED), (Object)Resource$.MODULE$.fromString("Group:PREFIXED::This:is:a:weird:group:name:"));
        Assert.assertEquals((Object)new Resource((ResourceType)Group$.MODULE$, ":This:is:a:weird:group:name:", PatternType.LITERAL), (Object)Resource$.MODULE$.fromString("Group:LITERAL::This:is:a:weird:group:name:"));
    }

    @Test
    public void shouldRoundTripViaString() {
        Resource expected = new Resource((ResourceType)Group$.MODULE$, "fred", PatternType.PREFIXED);
        Resource actual = Resource$.MODULE$.fromString(expected.toString());
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

