/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055e!B\n\u0015\u0003\u0003I\u0002\"\u0002\u0013\u0001\t\u0003)\u0003\"B\u0014\u0001\t\u0003A\u0003\"B\u0018\u0001\t\u0003B\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005G\u0001\u0001\u0007\t\u0011)Q\u0005e!)q\t\u0001C\u0001\u0011\")a\u000b\u0001C!/\")A\f\u0001C!/\")\u0011\r\u0001C\u0001/\")a\r\u0001C\u0001/\")\u0001\u000e\u0001C\u0001S\")Q\u0010\u0001C!}\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011%\ty\u0007AI\u0001\n\u0003\t\t\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\nA\")Y:f\u0003\u0012l\u0017N\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005U1\u0012aA1qS*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Qb\u0004\u0005\u0002\u001c95\tA#\u0003\u0002\u001e)\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"-\u0005)Q\u000f^5mg&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\u001c\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#aA%oi\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003\u0019\u0019G.[3oiV\t!\u0007\u0005\u00024{5\tAG\u0003\u00026m\u0005)\u0011\rZ7j]*\u0011q\u0007O\u0001\bG2LWM\u001c;t\u0015\t9\u0012H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 5\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"A\u000b\"\n\u0005\r[#\u0001B+oSRDq!R\u0003\u0002\u0002\u0003\u0007!'A\u0002yIE\nqa\u00197jK:$\b%A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u0002\u0013B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0006eVdWm\u001d\u0006\u0003\u001dn\nQA[;oSRL!\u0001U&\u0003\u000fQKW.Z8vi\"\u0012qA\u0015\t\u0003'Rk\u0011!T\u0005\u0003+6\u0013AAU;mK\u0006)1/\u001a;VaR\t\u0011\t\u000b\u0002\t3B\u00111KW\u0005\u000376\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005%q\u0006CA*`\u0013\t\u0001WJA\u0003BMR,'/\u0001\fuKN$8I]3bi\u0016$U\r\\3uKR{\u0007/[2tQ\tQ1\r\u0005\u0002TI&\u0011Q-\u0014\u0002\u0005)\u0016\u001cH/\u0001\ruKN$\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]ND#aC2\u00029\r|gNZ5hkJ,Gm\u00117vgR,'\u000fU3s[&\u001c8/[8ogV\t!\u000eE\u0002leVt!\u0001\u001c9\u0011\u00055\\S\"\u00018\u000b\u0005=D\u0012A\u0002\u001fs_>$h(\u0003\u0002rW\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\u0007M+GO\u0003\u0002rWA\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0004C\u000ed'B\u0001>9\u0003\u0019\u0019w.\\7p]&\u0011Ap\u001e\u0002\r\u0003\u000edw\n]3sCRLwN\\\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0005\u0005{\bbBA\u0001\u001b\u0001\u0007\u00111A\u0001\bG>tg-[4t!\u0019\t)!a\u0003\u0002\u00105\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Y\u0013AC2pY2,7\r^5p]&!\u0011QBA\u0004\u0005\r\u0019V-\u001d\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0016\u0005\u0005\r\u0002\u0003CA\t\u0003K\tI#a\f\n\t\u0005\u001d\u00121\u0003\u0002\u0004\u001b\u0006\u0004\bcA6\u0002,%\u0019\u0011Q\u0006;\u0003\rM#(/\u001b8h!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"\u0002BA\u001b\u0003/\tA\u0001\\1oO&!\u0011\u0011HA\u001a\u0005\u0019y%M[3di\u0006iq/Y5u\r>\u0014Hk\u001c9jGN$r!QA \u0003\u0003\n9\u0005C\u00031\u001f\u0001\u0007!\u0007C\u0004\u0002D=\u0001\r!!\u0012\u0002\u001f\u0015D\b/Z2uK\u0012\u0004&/Z:f]R\u0004b!!\u0002\u0002\f\u0005%\u0002bBA%\u001f\u0001\u0007\u0011QI\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003\u001f\n)&a\u0016\u0002\\\u0005\u0015\u0004cA\u001a\u0002R%\u0019\u00111\u000b\u001b\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007\"\u0002\u0019\u0011\u0001\u0004\u0011\u0004bBA-!\u0001\u0007\u0011\u0011F\u0001\u0006i>\u0004\u0018n\u0019\u0005\n\u0003;\u0002\u0002\u0013!a\u0001\u0003?\nq\u0002Z3tGJL'-Z(qi&|gn\u001d\t\u0004g\u0005\u0005\u0014bAA2i\t)B)Z:de&\u0014W\rV8qS\u000e\u001cx\n\u001d;j_:\u001c\b\"CA4!A\u0005\t\u0019AA5\u0003a)\u0007\u0010]3di\u0016$g*^7QCJ$\u0018\u000e^5p]N|\u0005\u000f\u001e\t\u0005U\u0005-\u0014&C\u0002\u0002n-\u0012aa\u00149uS>t\u0017AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTCAA:U\u0011\ty&!\u001e,\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!!,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\u000bYHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"!a#+\t\u0005%\u0014Q\u000f")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), 15000L);
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateDeleteTopics() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        this.client_$eq(Admin.create(this.createConfig()));
        .colon.colon topics = new .colon.colon((Object)"mytopic", (List)new .colon.colon((Object)"mytopic2", (List)new .colon.colon((Object)"mytopic3", (List)Nil$.MODULE$)));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        java.util.List list = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)1, (List)new .colon.colon((Object)2, (List)Nil$.MODULE$))).asJava();
        Integer $minus$greater$extension_$this = 0;
        Object var13_3 = null;
        list = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        java.util.List list2 = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)2, (List)new .colon.colon((Object)0, (List)Nil$.MODULE$))).asJava();
        Integer $minus$greater$extension_$this2 = 1;
        Object var15_5 = null;
        list2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic("mytopic", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava()), (List)new .colon.colon((Object)new NewTopic("mytopic2", 3, (short)3), (List)new .colon.colon((Object)new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension((Option)None$.MODULE$), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension((Option)None$.MODULE$)), (List)Nil$.MODULE$)));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        Assert.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, (Option<String>)None$.MODULE$);
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)false, (Object)topic0.isInternal());
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topic0Partition0.isr()).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id())));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topic0Partition0.replicas()).asScala().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id())));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topic0Partition1.isr()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topic0Partition1.replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)false, (Object)topic1.isInternal());
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        int n = 0;
        int until$extension_end = 3;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$5(this, topic1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var19_19 = null;
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assert.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)topic3.partitions().size());
        Assert.assertEquals((long)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (long)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assert.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assert.assertEquals((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, this.configuredClusterPermissions()).asJava(), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        .colon.colon newTopics = new .colon.colon((Object)new NewTopic(topic, 3, (short)3), (List)Nil$.MODULE$);
        this.client().createTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assert.assertEquals((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)AclEntry$.MODULE$.supportedOperations(ResourceType.TOPIC)).asJava(), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER);
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        configs.foreach((Function1 & Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            if (!config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp())) {
                return config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    public java.util.Map<String, Object> createConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties()).forEach((key, value) -> config.put((String)key, value));
        return config;
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("timed out waiting for topics", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        TopicDescription topicDescription = null;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            Object var12_11;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            try {
                void $anonfun$getTopicMetadata$1_apply_elems;
                topicDescription = (TopicDescription)((KafkaFuture)client.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)$anonfun$getTopicMetadata$1_apply_elems))).asJava(), describeOptions).values().get(topic)).get();
                if (expectedNumPartitionsOpt == null) {
                    throw null;
                }
                None$ $anonfun$getTopicMetadata$1_getOrElse_this = expectedNumPartitionsOpt.isEmpty() ? None$.MODULE$ : new Some((Object)(BoxesRunTime.unboxToInt((Object)expectedNumPartitionsOpt.get()) == topicDescription.partitions().size() ? 1 : 0));
                var12_11 = null;
                bl = BoxesRunTime.unboxToBoolean((Object)($anonfun$getTopicMetadata$1_getOrElse_this.isEmpty() ? Boolean.valueOf(true) : $anonfun$getTopicMetadata$1_getOrElse_this.get()));
            }
            catch (Throwable throwable) {
                if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                    bl = false;
                }
                throw throwable;
            }
            Object var11_9 = null;
            var12_11 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        return topicDescription;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assert.assertEquals((Object)2, (Object)result.numPartitions("mytopic").get());
        Assert.assertEquals((Object)2, (Object)result.replicationFactor("mytopic").get());
        Assert.assertEquals((Object)3, (Object)result.numPartitions("mytopic2").get());
        Assert.assertEquals((Object)3, (Object)result.replicationFactor("mytopic2").get());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)result.numPartitions("mytopic3").get());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (Object)result.replicationFactor("mytopic3").get());
        Assert.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$5(BaseAdminIntegrationTest $this, TopicDescription topic1$1, int partitionId) {
        TopicPartitionInfo partition = (TopicPartitionInfo)topic1$1.partitions().get(partitionId);
        Assert.assertEquals((long)partitionId, (long)partition.partition());
        Assert.assertEquals((long)3L, (long)partition.replicas().size());
        partition.replicas().forEach(replica -> {
            Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((replica.id() < $this.brokerCount() ? 1 : 0) != 0);
        });
        SeqOps seqOps = (SeqOps)((SeqOps)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partition.replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()))).distinct();
        if (seqOps == null) {
            throw null;
        }
        Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)seqOps.length());
        Assert.assertEquals((long)3L, (long)partition.isr().size());
        Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
        Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$2(ObjectRef result$1, int x$7) {
        return x$7 == ((TopicDescription)result$1.elem).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava(), describeOptions$1).values().get(topic$1);
        try {
            result$1.elem = (TopicDescription)topicResult.get();
            if (expectedNumPartitionsOpt$1 == null) {
                throw null;
            }
            None$ getOrElse_this = expectedNumPartitionsOpt$1.isEmpty() ? None$.MODULE$ : new Some((Object)(BoxesRunTime.unboxToInt((Object)expectedNumPartitionsOpt$1.get()) == ((TopicDescription)result$1.elem).partitions().size() ? 1 : 0));
            Object var7_7 = null;
            return BoxesRunTime.unboxToBoolean((Object)(getOrElse_this.isEmpty() ? Boolean.valueOf(true) : getOrElse_this.get()));
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExecutionException && ((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return new StringBuilder(35).append("Timed out waiting for metadata for ").append(topic$1).toString();
    }
}

