/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.controller.ReplicaAssignment;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]w!\u0002/^\u0011\u0003\u0001g!\u00022^\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003Y\u0007b\u00027\u0002\u0005\u0004%I!\u001c\u0005\u0007m\u0006\u0001\u000b\u0011\u00028\t\u000f]\f!\u0019!C\u0001q\"1A0\u0001Q\u0001\neDQ!`\u0001\u0005\u0002yDq!a\t\u0002\t\u0003\t)C\u0002\u0004\u00020\u0005\u0001\u0015\u0011\u0007\u0005\u000b\u0003\u0017J!Q3A\u0005\u0002\u00055\u0003BCA(\u0013\tE\t\u0015!\u0003\u0002\u0010!I\u0011\u0011K\u0005\u0003\u0016\u0004%\t\u0001\u001f\u0005\n\u0003'J!\u0011#Q\u0001\neD\u0011\"!\u0016\n\u0005+\u0007I\u0011\u0001=\t\u0013\u0005]\u0013B!E!\u0002\u0013I\bBCA-\u0013\tU\r\u0011\"\u0001\u0002\\!Q\u00111M\u0005\u0003\u0012\u0003\u0006I!!\u0018\t\u0013\u0005\u0015\u0014B!f\u0001\n\u0003A\b\"CA4\u0013\tE\t\u0015!\u0003z\u0011%\tI'\u0003BK\u0002\u0013\u0005\u0001\u0010C\u0005\u0002l%\u0011\t\u0012)A\u0005s\"1!.\u0003C\u0001\u0003[B\u0011\"a\u001f\n\u0005\u0004%\t!a\u0017\t\u0011\u0005u\u0014\u0002)A\u0005\u0003;B\u0011\"a \n\u0003\u0003%\t!!!\t\u0013\u0005=\u0015\"%A\u0005\u0002\u0005E\u0005\"CAT\u0013E\u0005I\u0011AAU\u0011%\ti+CI\u0001\n\u0003\tI\u000bC\u0005\u00020&\t\n\u0011\"\u0001\u00022\"I\u0011QW\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003oK\u0011\u0013!C\u0001\u0003SC\u0001\"!/\n\u0003\u0003%\t%\u001c\u0005\t\u0003wK\u0011\u0011!C\u0001q\"I\u0011QX\u0005\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u0017L\u0011\u0011!C!\u0003\u001bD\u0011\"a7\n\u0003\u0003%\t!!8\t\u0013\u0005\u001d\u0018\"!A\u0005B\u0005%\b\"CAw\u0013\u0005\u0005I\u0011IAx\u0011%\t\t0CA\u0001\n\u0003\n\u0019\u0010C\u0005\u0002v&\t\t\u0011\"\u0011\u0002x\u001eI!qH\u0001\u0002\u0002#\u0005!\u0011\t\u0004\n\u0003_\t\u0011\u0011!E\u0001\u0005\u0007BaA\u001b\u0016\u0005\u0002\tU\u0003\"CAyU\u0005\u0005IQIAz\u0011%\u00119FKA\u0001\n\u0003\u0013I\u0006C\u0005\u0003h)\n\t\u0011\"!\u0003j!I!1\u0010\u0016\u0002\u0002\u0013%!Q\u0010\u0004\u0007\u0005\u000b\u000b\u0001Aa\"\t\r)\u0004D\u0011\u0001BQ\u0011!\u0011)\u000b\rb\u0001\n\u0003i\u0007b\u0002BTa\u0001\u0006IA\u001c\u0005\t\u0005S\u0003\u0004\u0019!C\u0001[\"I!1\u0016\u0019A\u0002\u0013\u0005!Q\u0016\u0005\b\u0005c\u0003\u0004\u0015)\u0003o\u0011!\u0011\u0019\f\rb\u0001\n\u0003A\bb\u0002B[a\u0001\u0006I!\u001f\u0005\n\u0005o\u0003\u0004\u0019!C\u0001\u0005sC\u0011B!41\u0001\u0004%\tAa4\t\u0011\tM\u0007\u0007)Q\u0005\u0005wC\u0011B!61\u0005\u0004%\tAa6\t\u0011\t5\b\u0007)A\u0005\u00053D\u0011Ba<1\u0005\u0004%\tAa6\t\u0011\tE\b\u0007)A\u0005\u00053D\u0011Ba=1\u0001\u0004%\tA!>\t\u0013\rE\u0001\u00071A\u0005\u0002\rM\u0001\u0002CB\fa\u0001\u0006KAa>\t\u000f\re\u0001\u0007\"\u0001\u0004\u001c!911\u0005\u0019\u0005B\t5\u0002bBA\u0012a\u0011\u00051Q\u0005\u0005\b\u0007[\u0001D\u0011AB\u0018\u0011\u001d\u0019\u0019\u0004\rC\u0001\u0007kAqaa\u00151\t\u0003\u0011i\u0003C\u0004\u0004VA\"\taa\u0016\t\u000f\r\r\u0004\u0007\"\u0001\u0004f!911\u0010\u0019\u0005\u0002\ru\u0004bBBCa\u0011\u00051q\u0011\u0005\b\u0007;\u0003D\u0011ABP\u0011\u001d\u0019\u0019\u000b\rC\u0001\u0007KCqa!.1\t\u0003\u0011i\u0003C\u0004\u00048B\"Ia!/\t\u000f\r%\u0007\u0007\"\u0001\u0004L\u001a1!\u0011A\u0001\u0001\u0005\u0007AaA\u001b*\u0005\u0002\t\u0015\u0001\"\u0003B\u0004%\n\u0007I\u0011\u0002B\u0005\u0011!\u00119B\u0015Q\u0001\n\t-\u0001b\u0002B\r%\u0012\u0005!1\u0004\u0005\b\u0005?\u0011F\u0011\u0001B\u0011\u0011\u001d\u0011YC\u0015C\u0001\u0005[AqAa\fS\t\u0003\u0011i\u0003C\u0004\u00032I#\tAa\r\t\u000f\t\u0015\"\u000b\"\u0001\u0003:\u0005A\"+\u001a9mS\u000e\fG/[8o#V|G/Y:UKN$(+[4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002b\u00035\tQL\u0001\rSKBd\u0017nY1uS>t\u0017+^8uCN$Vm\u001d;SS\u001e\u001c\"!\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001-A\u0002eSJ,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u0006!A-\u001b:!\u0003\u0005YW#A=\u0011\u0005\u0015T\u0018BA>g\u0005\rIe\u000e^\u0001\u0003W\u0002\nA!\\1j]R\u0019q0!\u0002\u0011\u0007\u0015\f\t!C\u0002\u0002\u0004\u0019\u0014A!\u00168ji\"9\u0011qA\u0004A\u0002\u0005%\u0011\u0001B1sON\u0004R!ZA\u0006\u0003\u001fI1!!\u0004g\u0005\u0015\t%O]1z!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+1WBAA\f\u0015\r\tIbX\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ua-\u0001\u0004Qe\u0016$WMZ\u0005\u0004k\u0006\u0005\"bAA\u000fM\u0006\u0019!/\u001e8\u0015\u000f}\f9#a?\u0003<!9\u0011\u0011\u0006\u0005A\u0002\u0005-\u0012AB2p]\u001aLw\rE\u0002\u0002.%i\u0011!\u0001\u0002\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0014\r%!\u00171GA\u001d!\r)\u0017QG\u0005\u0004\u0003o1'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\u0005c\u0002BA\u000b\u0003\u007fI\u0011aZ\u0005\u0004\u0003\u00072\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\nIE\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002D\u0019\fAA\\1nKV\u0011\u0011qB\u0001\u0006]\u0006lW\rI\u0001\bEJ|7.\u001a:t\u0003!\u0011'o\\6feN\u0004\u0013A\u00039beRLG/[8og\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003!!\bN]8ui2,WCAA/!\r)\u0017qL\u0005\u0004\u0003C2'\u0001\u0002'p]\u001e\f\u0011\u0002\u001e5s_R$H.\u001a\u0011\u0002!5\u001cxm\u001d)feB\u000b'\u000f^5uS>t\u0017!E7tON\u0004VM\u001d)beRLG/[8oA\u00059Qn]4TSj,\u0017\u0001C7tONK'0\u001a\u0011\u0015\u001d\u0005-\u0012qNA9\u0003g\n)(a\u001e\u0002z!9\u00111\n\fA\u0002\u0005=\u0001BBA)-\u0001\u0007\u0011\u0010\u0003\u0004\u0002VY\u0001\r!\u001f\u0005\b\u000332\u0002\u0019AA/\u0011\u0019\t)G\u0006a\u0001s\"1\u0011\u0011\u000e\fA\u0002e\fa\u0003^1sO\u0016$()\u001f;fgB+'O\u0011:pW\u0016\u0014XJQ\u0001\u0018i\u0006\u0014x-\u001a;CsR,7\u000fU3s\u0005J|7.\u001a:N\u0005\u0002\nAaY8qsRq\u00111FAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0005\"CA&3A\u0005\t\u0019AA\b\u0011!\t\t&\u0007I\u0001\u0002\u0004I\b\u0002CA+3A\u0005\t\u0019A=\t\u0013\u0005e\u0013\u0004%AA\u0002\u0005u\u0003\u0002CA33A\u0005\t\u0019A=\t\u0011\u0005%\u0014\u0004%AA\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014*\"\u0011qBAKW\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0013Ut7\r[3dW\u0016$'bAAQM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00161\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WS3!_AK\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00024*\"\u0011QLAK\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t-a2\u0011\u0007\u0015\f\u0019-C\u0002\u0002F\u001a\u00141!\u00118z\u0011!\tIMIA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002PB1\u0011\u0011[Al\u0003\u0003l!!a5\u000b\u0007\u0005Ug-\u0001\u0006d_2dWm\u0019;j_:LA!!7\u0002T\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty.!:\u0011\u0007\u0015\f\t/C\u0002\u0002d\u001a\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002J\u0012\n\t\u00111\u0001\u0002B\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rq\u00171\u001e\u0005\t\u0003\u0013,\u0013\u0011!a\u0001s\u0006A\u0001.Y:i\u0007>$W\rF\u0001z\u0003!!xn\u0015;sS:<G#\u00018\u0002\r\u0015\fX/\u00197t)\u0011\ty.!?\t\u0013\u0005%\u0007&!AA\u0002\u0005\u0005\u0007bBA\u007f\u0011\u0001\u0007\u0011q`\u0001\bU>,(O\\1m!\r\tiC\u0015\u0002\b\u0015>,(O\\1m'\t\u0011F\r\u0006\u0002\u0002\u0000\u0006\u0019An\\4\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tE!/\u0001\u0002j_&!!Q\u0003B\b\u0005\u00111\u0015\u000e\\3\u0002\t1|w\rI\u0001\u0010CB\u0004XM\u001c3U_*{WO\u001d8bYR\u0019qP!\b\t\u000f\u0005%b\u000b1\u0001\u0002,\u0005Y\u0011\r\u001d9f]\u0012\u001c\u0005.\u0019:u)\u0015y(1\u0005B\u0014\u0011\u001d\u0011)c\u0016a\u0001\u0003\u001f\tA\u0001]1uQ\"9!\u0011F,A\u0002\u0005}\u0017!\u00024jeN$\u0018A\u00025fC\u0012,'\u000fF\u0001\u0000\u0003\u00191wn\u001c;fe\u00061\u0011\r\u001d9f]\u0012$2a B\u001b\u0011\u001d\u00119D\u0017a\u0001\u0003\u001f\tq!\\3tg\u0006<W\r\u0006\u0002\u0002\u0010!9!Q\b\u0005A\u0002\u0005}\u0017!\u00063jgBd\u0017-_\"iCJ$8o\u00148TGJ,WM\\\u0001\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0011\u0007\u00055\"fE\u0003+\u0005\u000b\u0012\t\u0006\u0005\b\u0003H\t5\u0013qB=z\u0003;J\u00180a\u000b\u000e\u0005\t%#b\u0001B&M\u00069!/\u001e8uS6,\u0017\u0002\u0002B(\u0005\u0013\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\u0011iAa\u0015\n\t\u0005\u001d#q\u0002\u000b\u0003\u0005\u0003\nQ!\u00199qYf$b\"a\u000b\u0003\\\tu#q\fB1\u0005G\u0012)\u0007C\u0004\u0002L5\u0002\r!a\u0004\t\r\u0005ES\u00061\u0001z\u0011\u0019\t)&\fa\u0001s\"9\u0011\u0011L\u0017A\u0002\u0005u\u0003BBA3[\u0001\u0007\u0011\u0010\u0003\u0004\u0002j5\u0002\r!_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YGa\u001e\u0011\u000b\u0015\u0014iG!\u001d\n\u0007\t=dM\u0001\u0004PaRLwN\u001c\t\fK\nM\u0014qB=z\u0003;J\u00180C\u0002\u0003v\u0019\u0014a\u0001V;qY\u00164\u0004\"\u0003B=]\u0005\u0005\t\u0019AA\u0016\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u007f\u00022a\u001cBA\u0013\r\u0011\u0019\t\u001d\u0002\u0007\u001f\nTWm\u0019;\u0003\u0015\u0015C\b/\u001a:j[\u0016tGoE\u00031\u0005\u0013\u0013)\n\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y)X\u0001\u0003u.LAAa%\u0003\u000e\n!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004BAa&\u0003\u001e6\u0011!\u0011\u0014\u0006\u0004\u00057k\u0016!B;uS2\u001c\u0018\u0002\u0002BP\u00053\u0013q\u0001T8hO&tw\r\u0006\u0002\u0003$B\u0019\u0011Q\u0006\u0019\u0002\u0013Q|\u0007/[2OC6,\u0017A\u0003;pa&\u001cg*Y7fA\u0005qQ\r\u001f9fe&lWM\u001c;OC6,\u0017AE3ya\u0016\u0014\u0018.\\3oi:\u000bW.Z0%KF$2a BX\u0011!\tI-NA\u0001\u0002\u0004q\u0017aD3ya\u0016\u0014\u0018.\\3oi:\u000bW.\u001a\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\bg\u0016\u0014h/\u001a:t+\t\u0011Y\f\u0005\u0004\u0002R\nu&\u0011Y\u0005\u0005\u0005\u007f\u000b\u0019NA\u0002TKF\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0004\u0005\u000fl\u0016AB:feZ,'/\u0003\u0003\u0003L\n\u0015'aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0019qP!5\t\u0013\u0005%'(!AA\u0002\tm\u0016\u0001C:feZ,'o\u001d\u0011\u0002\u00171,\u0017\rZ3s%\u0006$Xm]\u000b\u0003\u00053\u0004rAa7\u0003bf\u0014)/\u0004\u0002\u0003^*!!q\\Aj\u0003\u001diW\u000f^1cY\u0016LAAa9\u0003^\n\u0019Q*\u00199\u0011\u000b\u0015\fYAa:\u0011\u0007\u0015\u0014I/C\u0002\u0003l\u001a\u0014a\u0001R8vE2,\u0017\u0001\u00047fC\u0012,'OU1uKN\u0004\u0013!\u00044pY2|w/\u001a:SCR,7/\u0001\bg_2dwn^3s%\u0006$Xm\u001d\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0003\u0005o\u0004BA!?\u0004\u000e5\u0011!1 \u0006\u0005\u0005{\u0014y0A\u0003bI6LgN\u0003\u0003\u0004\u0002\r\r\u0011aB2mS\u0016tGo\u001d\u0006\u0004=\u000e\u0015!\u0002BB\u0004\u0007\u0013\ta!\u00199bG\",'BAB\u0006\u0003\ry'oZ\u0005\u0005\u0007\u001f\u0011YPA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\ry8Q\u0003\u0005\n\u0003\u0013\f\u0015\u0011!a\u0001\u0005o\fA\"\u00193nS:\u001cE.[3oi\u0002\nAb\u001d;beR\u0014%o\\6feN$2a`B\u000f\u0011\u001d\u0019yb\u0011a\u0001\u0007C\t\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u000b\u0005E'QX=\u0002\u0011Q,\u0017M\u001d#po:$ra`B\u0014\u0007S\u0019Y\u0003C\u0004\u0002*\u0015\u0003\r!a\u000b\t\u000f\u0005uX\t1\u0001\u0002\u0000\"9!QH#A\u0002\u0005}\u0017a\u0006<bY&$\u0017\r^3BY2|eMZ:fiNl\u0015\r^2i)\ry8\u0011\u0007\u0005\b\u0003S1\u0005\u0019AA\u0016\u0003%awnZ(viB,H\u000fF\u0004\u0000\u0007o\u0019Id!\u0011\t\u000f\u0005%r\t1\u0001\u0002,!911H$A\u0002\ru\u0012\u0001\u0003:fa2L7-Y:\u0011\u000f\u0005E7qH=\u0004\"%!!1]Aj\u0011\u001d\u0019\u0019e\u0012a\u0001\u0007\u000b\nQB\\3x\u0003N\u001c\u0018n\u001a8nK:$\b\u0003CAi\u0007\u007f\u00199e!\t\u0011\t\r%3qJ\u0007\u0003\u0007\u0017RAa!\u0014\u0004\u0004\u000511m\\7n_:LAa!\u0015\u0004L\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!H<bSR4uN\u001d*fCN\u001c\u0018n\u001a8nK:$Hk\\\"p[BdW\r^3\u0002\u0017I,g\u000eZ3s\u0007\"\f'\u000f\u001e\u000b\n\u007f\u000ee3QLB0\u0007CBqaa\u0017J\u0001\u0004\u0011I.\u0001\u0003eCR\f\u0007bBA&\u0013\u0002\u0007\u0011q\u0002\u0005\b\u0003{L\u0005\u0019AA\u0000\u0011\u001d\u0011i$\u0013a\u0001\u0003?\fA#\\1zE\u0016$\u0015n\u001d9mCf|enU2sK\u0016tG#B@\u0004h\r%\u0004b\u0002B\u001f\u0015\u0002\u0007\u0011q\u001c\u0005\b\u0007WR\u0005\u0019AB7\u0003\u0015\u0019\u0007.\u0019:u!\u0011\u0019yga\u001e\u000e\u0005\rE$\u0002BB6\u0007gRAa!\u001e\u0004\n\u0005)!N\u001a:fK&!1\u0011PB9\u0005)QeI]3f\u0007\"\f'\u000f^\u0001\foJLG/\u001a+p\r&dW\rF\u0004\u0000\u0007\u007f\u001a\tia!\t\u000f\u0005-3\n1\u0001\u0002\u0010!9\u0011Q`&A\u0002\u0005}\bbBB6\u0017\u0002\u00071QN\u0001\fGJ,\u0017\r^3DQ\u0006\u0014H\u000f\u0006\u0004\u0004n\r%51\u0012\u0005\b\u0003\u0017b\u0005\u0019AA\b\u0011\u001d\u0019i\t\u0014a\u0001\u0007\u001f\u000bq\u0001Z1uCN,G\u000f\u0005\u0003\u0004\u0012\u000eeUBABJ\u0015\u0011\u0019)ja&\u0002\u0005aL(\u0002BB.\u0007gJAaa'\u0004\u0014\n\u0011\u0002,W*fe&,7oQ8mY\u0016\u001cG/[8o\u00039\tG\r\u001a#bi\u0006$vn\u00115beR$Baa$\u0004\"\"911L'A\u0002\te\u0017A\u0002:fG>\u0014H\r\u0006\u0005\u0004(\u000e%6QVBY!\u0015)'Q\u000eBs\u0011\u001d\u0019YK\u0014a\u0001\u00053\fQA]1uKNDaaa,O\u0001\u0004I\u0018\u0001\u00032s_.,'/\u00133\t\u000f\rMf\n1\u0001\u0003h\u0006Y1-\u001e:sK:$(+\u0019;f\u0003A\u0001(/\u001b8u%\u0006$X-T3ue&\u001c7/\u0001\u0007nK\u0006\u001cXO]3e%\u0006$X\r\u0006\u0004\u0003h\u000em6q\u0018\u0005\b\u0007{\u0003\u0006\u0019\u0001Ba\u0003\u0019\u0011'o\\6fe\"91\u0011\u0019)A\u0002\r\r\u0017a\u0002:faRK\b/\u001a\t\u0005\u0005\u0007\u001c)-\u0003\u0003\u0004H\n\u0015'!C)v_R\fG+\u001f9f\u0003\u0011Q7o\u001c8\u0015\t\u0005=1Q\u001a\u0005\b\u0007\u001f\f\u0006\u0019ABi\u0003\u0015!x\u000e]5d!\u0015)71[A\b\u0013\r\u0019)N\u001a\u0002\u000byI,\u0007/Z1uK\u0012t\u0004")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
        ReplicationQuotasTestRig$.MODULE$.run(config, journal, displayChartsOnScreen);
    }

    public static void main(String[] args) {
        ReplicationQuotasTestRig$.MODULE$.main(args);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        private Admin adminClient = null;

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            String println_x = "Starting Brokers";
            Console$.MODULE$.println((Object)println_x);
            Object var4_2 = null;
            this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)brokerIds.map((Function1 & Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1))).map((Function1 & Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), Time.SYSTEM, (Option<String>)None$.MODULE$))));
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
            String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            Object[] objectArray = new Tuple2[1];
            String ArrowAssoc_self = "bootstrap.servers";
            Object var5_4 = null;
            String $minus$greater$extension_$this = ArrowAssoc_self;
            Object var3_5 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)brokerList);
            this.adminClient_$eq(Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava()));
        }

        @Override
        public void tearDown() {
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        /*
         * WARNING - void declaration
         */
        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            void var9_30;
            void mkString_end;
            Tuple2 tuple2;
            this.experimentName_$eq(config.name());
            int n = 100;
            int to$extension_end = 100 + config.brokers();
            Range.Inclusive brokers = new Range.Inclusive(n, to$extension_end, 1);
            int n2 = 0;
            int shift = Math.round((float)config.brokers() / 2.0f);
            int n3 = 0;
            int to$extension_end2 = config.partitions();
            Range.Inclusive map_this = new Range.Inclusive(n3, to$extension_end2, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                void $anonfun$run$1_$minus$greater$extension_y;
                int $anonfun$run$1_partition = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
                SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100 + (++n2 + shift) % config.brokers()}));
                Integer $anonfun$run$1_$minus$greater$extension_$this = $anonfun$run$1_partition;
                Object var33_15 = null;
                seqOps = null;
                tuple2 = new Tuple2((Object)$anonfun$run$1_$minus$greater$extension_$this, (Object)$anonfun$run$1_$minus$greater$extension_y);
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                tuple2 = null;
            }
            Object var16_11 = null;
            Object var17_12 = null;
            Object var18_13 = null;
            tuple2 = null;
            scala.collection.immutable.Map replicas = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            String println_x = "Writing Data";
            Console$.MODULE$.println((Object)println_x);
            Object var25_19 = null;
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);
            int n4 = 0;
            int until$extension_end = config.msgsPerPartition();
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n4, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$run$2(this, config, producer, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var20_23 = null;
            String println_x2 = "Generating Reassignment";
            Console$.MODULE$.println((Object)println_x2);
            Object var26_25 = null;
            String mkString_sep = ",";
            String string = "";
            String mkString_start = "";
            Object var30_28 = null;
            string = null;
            Object var15_26 = null;
            Tuple2 tuple22 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.adminClient(), this.json((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), IterableOnceOps.mkString$((IterableOnceOps)brokers, (String)mkString_start, (String)mkString_sep, (String)mkString_end), true);
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            Map newAssignment = (Map)tuple22._1();
            String println_x3 = "Starting Reassignment";
            Console$.MODULE$.println((Object)println_x3);
            Object var27_31 = null;
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.adminClient(), false, new String(ReassignPartitionsZNode$.MODULE$.encode((Map)var9_30), StandardCharsets.UTF_8), config.throttle(), -1L, 10000L, Time.SYSTEM);
            this.waitForReassignmentToComplete();
            String println_x4 = new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString();
            Console$.MODULE$.println((Object)println_x4);
            Object var28_33 = null;
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)var9_30);
            String println_x5 = new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString();
            Console$.MODULE$.println((Object)println_x5);
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        /*
         * WARNING - void declaration
         */
        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Map actual = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).apply((Object)this.topicName());
            String println_x = new java.lang.StringBuilder(17).append("The replicas are ").append(((IterableOps)replicas.toSeq().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString())).toString();
            Console$.MODULE$.println((Object)println_x);
            Object var6_6 = null;
            String println_x2 = new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    void $minus$greater$extension_y;
                    int k = x0$1._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                    Seq seq = v.replicas();
                    Integer $minus$greater$extension_$this = k;
                    return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
                throw new MatchError(null);
            })).toString();
            Console$.MODULE$.println((Object)println_x2);
            Object var7_7 = null;
            String println_x3 = new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString();
            Console$.MODULE$.println((Object)println_x3);
            Object var8_8 = null;
            String println_x4 = new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    void $minus$greater$extension_y;
                    int k = x0$2._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                    Seq seq = v.replicas();
                    Integer $minus$greater$extension_$this = k;
                    return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                }
                throw new MatchError(null);
            })).toString();
            Console$.MODULE$.println((Object)println_x4);
            Object var9_9 = null;
            String println_x5 = new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString();
            Console$.MODULE$.println((Object)println_x5);
            Object var10_10 = null;
            String println_x6 = new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString();
            Console$.MODULE$.println((Object)println_x6);
            Object var11_11 = null;
            String println_x7 = new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString();
            Console$.MODULE$.println((Object)println_x7);
            Object var12_12 = null;
            String println_x8 = new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString();
            Console$.MODULE$.println((Object)println_x8);
            Object var13_13 = null;
            String println_x9 = new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString();
            Console$.MODULE$.println((Object)println_x9);
            Object var14_14 = null;
            String println_x10 = new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString();
            Console$.MODULE$.println((Object)println_x10);
            Object var15_15 = null;
            String println_x11 = new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString();
            Console$.MODULE$.println((Object)println_x11);
        }

        public void waitForReassignmentToComplete() {
            long waitUntilTrue_pause = 1000L;
            long waitUntilTrue_waitTimeMs = 3600000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!Experiment.$anonfun$waitForReassignmentToComplete$1(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail("Partition reassignments didn't complete.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, waitUntilTrue_pause));
            }
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            String println_x = new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString();
            Console$.MODULE$.println((Object)println_x);
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            if (displayChartsOnScreen) {
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
                return;
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            return ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }

        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return dataset;
        }

        /*
         * WARNING - void declaration
         */
        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            void $plus$plus$extension_evidence$25;
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)brokerId, (Function0 & Serializable)() -> (double[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()));
            ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
            double[] $plus$plus$extension_xs = new double[]{currentRate};
            Object var6_6 = null;
            doubleManifest = null;
            leaderRatesBroker = (double[])ArrayOps$.MODULE$.appendedAll$extension((Object)leaderRatesBroker, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25);
            return rates.put((Object)brokerId, (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            if (AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)broker.metrics().metrics()).asScala().contains((Object)metricName)) {
                return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
            }
            return -1.0;
        }

        /*
         * WARNING - void declaration
         */
        public String json(scala.collection.immutable.Seq<String> topic) {
            void mkString_sep;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)topic.map((Function1 & Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString());
            String string = ",";
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps mkString_this = iterableOnceOps;
            Object var3_3 = null;
            string = null;
            String topicStr = mkString_this.mkString("", (String)mkString_sep, "");
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(IntRef count$1, int shift$1, ExperimentDef config$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Tuple2 $anonfun$run$1(IntRef count$1, int shift$1, ExperimentDef config$1, int partition) {
            void $minus$greater$extension_y;
            int[] nArray = new int[1];
            ++count$1.elem;
            nArray[0] = 100 + (count$1.elem + shift$1) % config$1.brokers();
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(nArray));
            Integer $minus$greater$extension_$this = partition;
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }

        public static final /* synthetic */ void $anonfun$run$2(Experiment $this, ExperimentDef config$1, KafkaProducer producer$1, int x) {
            int n = 0;
            int until$extension_end = config$1.partitions();
            Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    producer$1.send(new ProducerRecord($this.topicName(), Integer.valueOf(foreach_i), null, (Object)new byte[config$1.msgSize()]));
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public static final /* synthetic */ long $anonfun$validateAllOffsetsMatch$4() {
            return -1L;
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$2(Experiment $this, KafkaServer broker$1, ExperimentDef config$2, int partitionId) {
            LogManager qual$1 = broker$1.getLogManager();
            TopicPartition x$1 = new TopicPartition($this.topicName(), partitionId);
            boolean x$2 = qual$1.getLog$default$2();
            Option option = qual$1.getLog(x$1, x$2);
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Log)map_this.get()).logEndOffset());
            Object var9_7 = null;
            None$ getOrElse_this = object;
            Object var10_8 = null;
            long offset = BoxesRunTime.unboxToLong((Object)(getOrElse_this.isEmpty() ? Long.valueOf(-1L) : getOrElse_this.get()));
            if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker$1.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
            }
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            int n = 0;
            int until$extension_end = config$2.partitions();
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$validateAllOffsetsMatch$2($this, broker, config$2, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
        }

        public static final /* synthetic */ boolean $anonfun$waitForReassignmentToComplete$1(Experiment $this) {
            $this.printRateMetrics();
            return ((java.util.Map)$this.adminClient().listPartitionReassignments().reassignments().get()).isEmpty();
        }

        public static final /* synthetic */ String $anonfun$waitForReassignmentToComplete$2() {
            return "Partition reassignments didn't complete.";
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$2(XYSeries series$1, IntRef x$5, double value) {
            series$1.add((double)x$5.elem, value);
            ++x$5.elem;
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                double[] values = (double[])x0$1._2();
                XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
                int n = 0;
                for (double d : values) {
                    series.add((double)n, d);
                    ++n;
                }
                dataset$1.addSeries(series);
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
            if (broker.config().brokerId() == 100) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
            }
            $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
            if (leaderRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
            }
            double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
            $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
            if (followerRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
                return;
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }

        public static final /* synthetic */ Tuple2 $anonfun$run$1$adapted(IntRef count$1, int shift$1, ExperimentDef config$1, Object partition) {
            return Experiment.$anonfun$run$1(count$1, shift$1, config$1, BoxesRunTime.unboxToInt((Object)partition));
        }

        public static final /* synthetic */ Future $anonfun$run$3$adapted(Experiment $this, KafkaProducer producer$1, ExperimentDef config$1, Object partition) {
            return producer$1.send(new ProducerRecord($this.topicName(), Integer.valueOf(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config$1.msgSize()]));
        }

        public static final /* synthetic */ Object $anonfun$validateAllOffsetsMatch$3$adapted(Log x$2) {
            return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
        }
    }

    public static class ExperimentDef
    implements Product,
    Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.brokers();
                }
                case 2: {
                    return this.partitions();
                }
                case 3: {
                    return this.throttle();
                }
                case 4: {
                    return this.msgsPerPartition();
                }
                case 5: {
                    return this.msgSize();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "brokers";
                }
                case 2: {
                    return "partitions";
                }
                case 3: {
                    return "throttle";
                }
                case 4: {
                    return "msgsPerPartition";
                }
                case 5: {
                    return "msgSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.brokers());
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.throttle()));
            n = Statics.mix((int)n, (int)this.msgsPerPartition());
            n = Statics.mix((int)n, (int)this.msgSize());
            int finalizeHash_length = 6;
            return Statics.avalanche((int)(n ^ finalizeHash_length));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof ExperimentDef)) break block3;
                    ExperimentDef experimentDef = (ExperimentDef)x$1;
                    if (this.brokers() != experimentDef.brokers() || this.partitions() != experimentDef.partitions() || this.throttle() != experimentDef.throttle() || this.msgsPerPartition() != experimentDef.msgsPerPartition() || this.msgSize() != experimentDef.msgSize()) break block3;
                    String string = this.name();
                    String string2 = experimentDef.name();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !experimentDef.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            String message = new java.lang.StringBuilder(82).append("\n\n<h3>").append(config.name()).append("</h3>").append("<p>- BrokerCount: ").append(config.brokers()).append("<p>- PartitionCount: ").append(config.partitions()).append(StringOps$.MODULE$.format$extension("<p>- Throttle: %,.0f MB/s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)config.throttle()}))).append(StringOps$.MODULE$.format$extension("<p>- MsgCount: %,.0f ", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)config.msgsPerPartition()}))).append(StringOps$.MODULE$.format$extension("<p>- MsgSize: %,.0f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{(double)config.msgSize()}))).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            if (first) {
                message.append("<p><p>");
            }
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            if (!first) {
                message.append("<p><p>");
            }
            this.append(message.result());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, stream, message){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

