/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public <A, B> A min(Iterable<A> iterable, A ifEmpty, Ordering<B> cmp) {
        if (iterable.isEmpty()) {
            return ifEmpty;
        }
        return (A)iterable.min(cmp);
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(e.getMessage(), e);
                    return;
                }
            } else if (Level.WARN.equals(logLevel)) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(e.getMessage(), e);
                    return;
                }
            } else if (Level.INFO.equals(logLevel)) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(e.getMessage(), e);
                    return;
                }
            } else if (Level.DEBUG.equals(logLevel)) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(e.getMessage(), e);
                    return;
                }
            } else if (Level.TRACE.equals(logLevel)) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(e.getMessage(), e);
                    return;
                }
            } else {
                throw new MatchError((Object)logLevel);
            }
            return;
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(Seq<String> files) {
        files.foreach((Function1 & Serializable)f -> {
            CoreUtils$.$anonfun$delete$1(f);
            return BoxedUnit.UNIT;
        });
    }

    public void tryAll(Seq<Function0<BoxedUnit>> all) {
        ObjectRef exception = new ObjectRef(null);
        all.foreach((Function1 & Serializable)element -> {
            CoreUtils$.$anonfun$tryAll$1(exception, element);
            return BoxedUnit.UNIT;
        });
        if ((Throwable)exception.elem != null) {
            throw (Throwable)exception.elem;
        }
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(25).append("Failed to register Mbean ").append(name).toString(), (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public void unregisterMBean(String name) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        synchronized (mbs) {
            ObjectName objName = new ObjectName(name);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
            return;
        }
    }

    public int read(ReadableByteChannel channel, ByteBuffer buffer) {
        int n = channel.read(buffer);
        switch (n) {
            case -1: {
                throw new EOFException("Received -1 when reading from channel, socket has likely been closed.");
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> parseCsvMap(String str) {
        void toMap_ev;
        HashMap map = new HashMap();
        if ("".equals(str)) {
            return map;
        }
        String[] map$extension_$this = str.split("\\s*,\\s*");
        int map$extension_len = map$extension_$this.length;
        Object[] map$extension_ys = new Tuple2[map$extension_len];
        if (map$extension_len > 0) {
            for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                Tuple2 array_update_value = CoreUtils$.$anonfun$parseCsvMap$1(map$extension_$this[map$extension_i]);
                map$extension_ys[map$extension_i] = array_update_value;
                Object var9_7 = null;
            }
        }
        Object var5_3 = null;
        Object var7_5 = null;
        Object[] keyVals = map$extension_ys;
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray(keyVals);
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (ofRef2 == null) {
            throw null;
        }
        return IterableOnceOps.toMap$((IterableOnceOps)ofRef2, (.less.colon.less)toMap_ev);
    }

    public Seq<String> parseCsvList(String csvList) {
        Object object;
        Object var2_2;
        if (csvList == null || csvList.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        String[] refArrayOps_xs = csvList.split("\\s*,\\s*");
        void v0 = var2_2;
        var2_2 = null;
        void filter$extension_$this = v0;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        Object var7_4 = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = object;
        for (int filter$extension_i = 0; filter$extension_i < ((void)filter$extension_$this).length; ++filter$extension_i) {
            void filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!CoreUtils$.$anonfun$parseCsvList$1((String)filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var3_3 = null;
        Object var4_6 = null;
        Object var6_8 = null;
        return Predef$.MODULE$.wrapRefArray((Object[])filter$extension_res.result());
    }

    public <T> T createObject(String className, scala.collection.immutable.Seq<Object> args) {
        return (T)Class.forName(className, true, Utils.getContextOrKafkaClassLoader()).getConstructor((Class[])((IterableOnceOps)args.map((Function1 & Serializable)x$1 -> x$1.getClass())).toArray(ClassTag$.MODULE$.apply(Class.class))).newInstance((Object[])args.toArray(ClassTag$.MODULE$.AnyRef()));
    }

    public <T> Iterator<T> circularIterator(Iterable<T> coll) {
        JFunction0.mcI.sp & Serializable continually_elem = (JFunction0.mcI.sp & Serializable)() -> 1;
        Object var2_2 = null;
        return new /* Unavailable Anonymous Inner Class!! */.flatMap((Function1 & Serializable)x$2 -> CoreUtils$.$anonfun$circularIterator$2(coll, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public String replaceSuffix(String s, String oldSuffix, String newSuffix) {
        if (!s.endsWith(oldSuffix)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("Expected string to end with '%s' but string is '%s'", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{oldSuffix, s})));
        }
        return new StringBuilder(0).append(s.substring(0, s.length() - oldSuffix.length())).append(newSuffix).toString();
    }

    public int readInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> Iterable<T> duplicates(Iterable<T> s) {
        return ((MapOps)s.groupBy((Function1 & Serializable)x -> Predef$.MODULE$.identity(x)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object k = x0$1._1();
                Iterable l = (Iterable)x0$1._2();
                return new Tuple2(k, (Object)l.size());
            }
            throw new MatchError(null);
        }).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$duplicates$3(x0$2)))).keys();
    }

    public Seq<EndPoint> listenerListToEndPoints(String listeners, Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        Seq seq;
        try {
            seq = (Seq)this.parseCsvList(listeners).map((Function1 & Serializable)x$6 -> EndPoint$.MODULE$.createEndPoint((String)x$6, (Option<Map<ListenerName, SecurityProtocol>>)new Some((Object)securityProtocolMap)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Error creating broker listeners from '").append(listeners).append("': ").append(e.getMessage()).toString(), e);
        }
        Seq endPoints = seq;
        CoreUtils$.validate$1(endPoints, listeners);
        return endPoints;
    }

    public String generateUuidAsBase64() {
        UUID uuid = UUID.randomUUID();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.getBytesFromUuid(uuid));
    }

    public byte[] getBytesFromUuid(UUID uuid) {
        ByteBuffer uuidBytes = ByteBuffer.wrap(new byte[16]);
        uuidBytes.putLong(uuid.getMostSignificantBits());
        uuidBytes.putLong(uuid.getLeastSignificantBits());
        return uuidBytes.array();
    }

    public Properties propsWith(String key, String value) {
        return this.propsWith((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value)}));
    }

    public Properties propsWith(scala.collection.immutable.Seq<Tuple2<String, String>> props) {
        Properties properties = new Properties();
        props.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return properties.put(k, v);
            }
            throw new MatchError(null);
        });
        return properties;
    }

    public <K, V> V atomicGetOrUpdate(scala.collection.concurrent.Map<K, V> map, K key, Function0<V> createValue) {
        Option option = map.get(key);
        if (option instanceof Some) {
            return (V)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            Object value = createValue.apply();
            Option option2 = map.putIfAbsent(key, value);
            if (option2 == null) {
                throw null;
            }
            Option getOrElse_this = option2;
            if (getOrElse_this.isEmpty()) {
                return (V)value;
            }
            return (V)getOrElse_this.get();
        }
        throw new MatchError((Object)option);
    }

    public <T, K, B> Map<K, B> groupMapReduce(Iterable<T> elements, Function1<T, K> key, Function1<T, B> f, Function2<B, B, B> reduce) {
        return elements.groupMapReduce(key, f, reduce);
    }

    public static final /* synthetic */ void $anonfun$delete$1(String f) {
        Utils.delete((File)new File(f));
    }

    public static final /* synthetic */ void $anonfun$tryAll$1(ObjectRef exception$1, Function0 element) {
        try {
            element.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if ((Throwable)exception$1.elem != null) {
                ((Throwable)exception$1.elem).addSuppressed(e);
                return;
            }
            exception$1.elem = e;
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$parseCsvMap$1(String s) {
        int lio = s.lastIndexOf(":");
        return new Tuple2((Object)s.substring(0, lio).trim(), (Object)s.substring(lio + 1).trim());
    }

    public static final /* synthetic */ boolean $anonfun$parseCsvList$1(String v) {
        return !v.equals("");
    }

    public static final /* synthetic */ Iterable $anonfun$circularIterator$2(Iterable coll$1, int x$2) {
        return (Iterable)coll$1.map((Function1 & Serializable)t -> t);
    }

    public static final /* synthetic */ boolean $anonfun$duplicates$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._2$mcI$sp() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$4(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different port, listeners: ").append(listeners$1).toString();
    }

    public static final /* synthetic */ String $anonfun$listenerListToEndPoints$5(String listeners$1) {
        return new StringBuilder(53).append("Each listener must have a different name, listeners: ").append(listeners$1).toString();
    }

    private static final void validate$1(Seq endPoints, String listeners$1) {
        Seq portsExcludingZero = (Seq)((IterableOps)endPoints.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.port()))).filter((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> x$4 != 0);
        Seq distinctPorts = (Seq)portsExcludingZero.distinct();
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1 & Serializable)x$5 -> x$5.listenerName())).distinct();
        if (distinctPorts == null) {
            throw null;
        }
        if (!(distinctPorts.length() == portsExcludingZero.length())) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$4(listeners$1)).toString());
        }
        if (distinctListenerNames == null) {
            throw null;
        }
        if (!(distinctListenerNames.length() == endPoints.length())) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)CoreUtils$.$anonfun$listenerListToEndPoints$5(listeners$1)).toString());
        }
    }

    public static final /* synthetic */ Object $anonfun$atomicGetOrUpdate$1(Object value$1) {
        return value$1;
    }

    private CoreUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$parseCsvList$1$adapted(String v) {
        return BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$parseCsvList$1(v));
    }
}

