/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.StringOps$;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0005\tuw!\u0002\u001d:\u0011\u0003\u0001e!\u0002\":\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005b\u0002'\u0002\u0005\u0004%\t!\u0014\u0005\u0007#\u0006\u0001\u000b\u0011\u0002(\t\u000fI\u000b!\u0019!C\u0001\u001b\"11+\u0001Q\u0001\n9Cq\u0001V\u0001C\u0002\u0013\u0005Q\n\u0003\u0004V\u0003\u0001\u0006IA\u0014\u0005\b-\u0006\u0011\r\u0011\"\u0001N\u0011\u00199\u0016\u0001)A\u0005\u001d\"9\u0001,\u0001b\u0001\n\u0003I\u0006BB3\u0002A\u0003%!\fC\u0004g\u0003\t\u0007I\u0011A-\t\r\u001d\f\u0001\u0015!\u0003[\r\u0011\u0011\u0015\b\u00015\t\u0011=|!\u0011!Q\u0001\n9C\u0001\u0002]\b\u0003\u0002\u0003\u0006I!\u001d\u0005\to>\u0011\t\u0011)A\u0005q\"A1p\u0004B\u0001B\u0003%A\u0010\u0003\u0006\u0002\u0006=\u0011\t\u0011)A\u0005\u0003\u000fA!\"!\u0004\u0010\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\t9c\u0004B\u0001B\u0003%\u0011\u0011\u0006\u0005\u0007\u0015>!\t!a\r\u0006\r\u0005\u0015s\u0002AA$\u0011%\tYg\u0004b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002\b>\u0001\u000b\u0011BA8\u0011%\tIi\u0004b\u0001\n\u0013\tY\t\u0003\u0005\u0002\u001a>\u0001\u000b\u0011BAG\u0011)\tYj\u0004b\u0001\n\u0003I\u0014Q\u0014\u0005\t\u0003k{\u0001\u0015!\u0003\u0002 \"Q\u0011qW\bC\u0002\u0013\u0005\u0011(!/\t\u0011\u0005\u001dw\u0002)A\u0005\u0003wC\u0001\"!3\u0010\u0005\u0004%I!\u0014\u0005\b\u0003\u0017|\u0001\u0015!\u0003O\u0011%\tim\u0004b\u0001\n\u0013\ty\r\u0003\u0005\u0002X>\u0001\u000b\u0011BAi\u0011!\tIn\u0004C\u0001s\u0005m\u0007bBAs\u001f\u0011\u0005\u0011q\u001d\u0005\b\u0005\u0003yA\u0011\u0001B\u0002\u0011\u001d\u0011)a\u0004C\u0001\u0005\u000fAqAa\u000b\u0010\t\u0003\u0011i\u0003C\u0004\u00036=!IAa\u000e\t\u000f\t\u0005s\u0002\"\u0001\u0003D!9!qJ\b\u0005\u0002\tE\u0003b\u0002B.\u001f\u0011\u0005!Q\f\u0005\u0007\u0005CzA\u0011B'\t\u000f\t\rt\u0002\"\u0003\u0003f!A!1P\b\u0005\u0002e\u0012i\bC\u0004\u0003\n>!\tAa#\t\u000f\teu\u0002\"\u0001\u0003\u001c\"9!\u0011T\b\u0005\u0002\t}\u0005b\u0002BS\u001f\u0011%!1\u0001\u0005\b\u0005O{A\u0011\u0001BU\u0011%\u0011\u0019mDI\u0001\n\u0003\u0011)\rC\u0004\u0003\\>!\tAa\u0001\u0002/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(B\u0001\u001e<\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005qj\u0014aC2p_J$\u0017N\\1u_JT\u0011AP\u0001\u0006W\u000647.Y\u0002\u0001!\t\t\u0015!D\u0001:\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001!\u0002?\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5/F\u0001O!\t)u*\u0003\u0002Q\r\n\u0019\u0011J\u001c;\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000fI\u0001#\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:\u0002G\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005QC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\u0018a\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj\u001d\u0011\u0002]\u0011+g-Y;miJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\u000e^3sm\u0006dWj]\u00010\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5\u000fI\u0001\r\u001b\u0016$(/[2t\u000fJ|W\u000f]\u000b\u00025B\u00111L\u0019\b\u00039\u0002\u0004\"!\u0018$\u000e\u0003yS!aX \u0002\rq\u0012xn\u001c;?\u0013\t\tg)\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u0014aa\u0015;sS:<'BA1G\u00035iU\r\u001e:jGN<%o\\;qA\u0005qAj\\1e)&lWmU3og>\u0014\u0018a\u0004'pC\u0012$\u0016.\\3TK:\u001cxN\u001d\u0011\u0014\u0007=!\u0015\u000e\u0005\u0002k[6\t1N\u0003\u0002m{\u0005)Q\u000f^5mg&\u0011an\u001b\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0017\u0001\u0003>l\u00072LWM\u001c;\u0011\u0005I,X\"A:\u000b\u0005Ql\u0014A\u0001>l\u0013\t18OA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\ng\u000eDW\rZ;mKJ\u0004\"A[=\n\u0005i\\'!C*dQ\u0016$W\u000f\\3s\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042!`A\u0001\u001b\u0005q(BA@>\u0003\u0019\u0019XM\u001d<fe&\u0019\u00111\u0001@\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u000611m\u001c8gS\u001e\u00042!QA\u0005\u0013\r\tY!\u000f\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0017\u0001\u0002;j[\u0016\u0004B!!\u0005\u0002$5\u0011\u00111\u0003\u0006\u0004Y\u0006U!\u0002BA\f\u00033\taaY8n[>t'b\u0001 \u0002\u001c)!\u0011QDA\u0010\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011E\u0001\u0004_J<\u0017\u0002BA\u0013\u0003'\u0011A\u0001V5nK\u00069Q.\u001a;sS\u000e\u001c\b\u0003BA\u0016\u0003_i!!!\f\u000b\t\u0005\u001d\u0012QC\u0005\u0005\u0003c\tiCA\u0004NKR\u0014\u0018nY:\u0015!\u0005U\u0012qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0003CA!\u0010\u0011\u0015yw\u00031\u0001O\u0011\u0015\u0001x\u00031\u0001r\u0011\u00159x\u00031\u0001y\u0011\u0015Yx\u00031\u0001}\u0011\u001d\t)a\u0006a\u0001\u0003\u000fAq!!\u0004\u0018\u0001\u0004\ty\u0001C\u0004\u0002(]\u0001\r!!\u000b\u0003-M+g\u000e\u001a+y]6\u000b'o[3sg\u000e\u000bG\u000e\u001c2bG.\u0004B\"RA%\u001d\u00065\u0013\u0011LA0\u0003KJ1!a\u0013G\u0005%1UO\\2uS>tG\u0007\u0005\u0003\u0002P\u0005USBAA)\u0015\u0011\t\u0019&!\u0006\u0002\u0011I,\u0017/^3tiNLA!a\u0016\u0002R\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u0007\u0005\u000bY&C\u0002\u0002^e\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u00042!QA1\u0013\r\t\u0019'\u000f\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rE\u0002F\u0003OJ1!!\u001bG\u0005\u0011)f.\u001b;\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005=\u0004\u0003BA9\u0003\u0007k!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0007CR|W.[2\u000b\t\u0005e\u00141P\u0001\u000bG>t7-\u001e:sK:$(\u0002BA?\u0003\u007f\nA!\u001e;jY*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006M$!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$H/\u001b8h\t><h\u000eI\u0001\ngR\fG/\u001a'pG.,\"!!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#SA!a%\u0002x\u0005)An\\2lg&!\u0011qSAI\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017AC:uCR,Gj\\2lA\u0005\tBn\\1eS:<\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005}\u0005CBAQ\u0003W\u000by+\u0004\u0002\u0002$*!\u0011QUAT\u0003\u001diW\u000f^1cY\u0016T1!!+G\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\u000b\u0019KA\u0002TKR\u00042!QAY\u0013\r\t\u0019,\u000f\u0002#)J\fgn]1di&|g\u000eU1si&$\u0018n\u001c8B]\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0002%1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7\u000fI\u0001\u0019iJ\fgn]1di&|g.T3uC\u0012\fG/Y\"bG\",WCAA^!\u001d\t\t+!0O\u0003\u0003LA!a0\u0002$\n\u0019Q*\u00199\u0011\u0007\u0005\u000b\u0019-C\u0002\u0002Ff\u0012Q\u0003\u0016=o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3F]R\u0014\u00180A\rue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013A\b;sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003}!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000fI\u0001\u0014a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN]\u000b\u0003\u0003#\u0004B!a\u000b\u0002T&!\u0011Q[A\u0017\u0005\u0019\u0019VM\\:pe\u0006!\u0002/\u0019:uSRLwN\u001c'pC\u0012\u001cVM\\:pe\u0002\n1#\u00193e\u0019>\fG-\u001b8h!\u0006\u0014H/\u001b;j_:$b!!\u001a\u0002^\u0006\u0005\bBBApK\u0001\u0007a*A\u0006qCJ$\u0018\u000e^5p]&#\u0007BBArK\u0001\u0007a*\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006!B/[7fI>+H\u000f\u0016:b]N\f7\r^5p]N$\"!!;\u0011\r\u0005-\u0018Q_A~\u001d\u0011\ti/!=\u000f\u0007u\u000by/C\u0001H\u0013\r\t\u0019PR\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t90!?\u0003\u0011%#XM]1cY\u0016T1!a=G!\r\t\u0015Q`\u0005\u0004\u0003\u007fL$!\t+sC:\u001c\u0018m\u0019;j_:\fG.\u00133B]\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ#q_\u000eD\u0017aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]R\u0011\u0011QM\u0001\u0014O\u0016$HK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0005\u0005\u0013\u00119\u0003\u0005\u0005\u0002l\n-!q\u0002B\u000e\u0013\u0011\u0011i!!?\u0003\r\u0015KG\u000f[3s!\u0011\u0011\tBa\u0006\u000e\u0005\tM!\u0002\u0002B\u000b\u0003+\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u00053\u0011\u0019B\u0001\u0004FeJ|'o\u001d\t\u0006\u000b\nu!\u0011E\u0005\u0004\u0005?1%AB(qi&|g\u000eE\u0002B\u0005GI1A!\n:\u0005y\u0019un\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u00118e)btW*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0003*!\u0002\rAW\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0006q\u0002/\u001e;Ue\u0006t7/Y2uS>t7\u000b^1uK&3gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0005_\u0011\t\u0004\u0005\u0005\u0002l\n-!q\u0002B\u0011\u0011\u001d\u0011\u0019$\u000ba\u0001\u00033\n1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uC\u0006qr-\u001a;B]\u0012l\u0015-\u001f2f\u0003\u0012$GK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0007\u0005\u0013\u0011IDa\u000f\t\r\t%\"\u00061\u0001[\u0011\u001d\u0011iD\u000ba\u0001\u0005\u007f\tQc\u0019:fCR,G\r\u0016=o\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fE\u0003F\u0005;\tI&\u0001\u000fwC2LG-\u0019;f)J\fgn]1di&|g\u000eV5nK>,H/T:\u0015\t\t\u0015#1\n\t\u0004\u000b\n\u001d\u0013b\u0001B%\r\n9!i\\8mK\u0006t\u0007B\u0002B'W\u0001\u0007a*\u0001\u0007uq:$\u0016.\\3pkRl5/A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!1\u000b\t\u0005\u0005+\u00129&\u0004\u0002\u0002|%!!\u0011LA>\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004\u001d\n}\u0003B\u0002B\u0015[\u0001\u0007!,A\u0011hKR$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/A\fm_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR1!q\rB7\u0005s\u0002bA\u001bB55\u0006e\u0013b\u0001B6W\n!\u0001k\\8m\u0011\u001d\u0011yg\fa\u0001\u0005c\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003t\tUTBAA\u000b\u0013\u0011\u00119(!\u0006\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u00111]\u0018A\u00029\u000bA$\u00193e\u0019>\fG-\u001a3Ue\u0006t7/Y2uS>t7\u000fV8DC\u000eDW\r\u0006\u0005\u0002f\t}$1\u0011BC\u0011\u0019\u0011\t\t\ra\u0001\u001d\u0006\tB\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8\t\r\u0005\r\b\u00071\u0001O\u0011\u001d\u00119\t\ra\u0001\u0005O\n!\u0003\\8bI\u0016$GK]1og\u0006\u001cG/[8og\u0006!Cn\\1e)J\fgn]1di&|gn\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002f\t5%q\u0012BI\u0011\u0019\ty.\ra\u0001\u001d\"1\u00111]\u0019A\u00029CqAa%2\u0001\u0004\u0011)*\u0001\btK:$G\u000b\u001f8NCJ\\WM]:\u0011\u0007\t]\u0005$D\u0001\u0010\u0003\u0019\u0012X-\\8wKR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003K\u0012i\n\u0003\u0004\u0002`J\u0002\rA\u0014\u000b\u0007\u0003K\u0012\tKa)\t\r\u0005}7\u00071\u0001O\u0011\u0019\t\u0019o\ra\u0001\u001d\u0006qc/\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;JgN#\u0018M\u00197f\u0003Y\t\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><G\u0003DA3\u0005W\u0013iKa,\u00034\nu\u0006B\u0002B\u0015k\u0001\u0007!\f\u0003\u0004\u0002dV\u0002\rA\u0014\u0005\b\u0005c+\u0004\u0019AA0\u0003-qWm^'fi\u0006$\u0017\r^1\t\u000f\tUV\u00071\u0001\u00038\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\b\u000b\ne&qBA3\u0013\r\u0011YL\u0012\u0002\n\rVt7\r^5p]FB\u0011Ba06!\u0003\u0005\rA!1\u0002\u0019I,GO]=P]\u0016\u0013(o\u001c:\u0011\u000f\u0015\u0013ILa\u0004\u0003F\u0005\u0001\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8U_2{w\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u00119M\u000b\u0003\u0003B\n%7F\u0001Bf!\u0011\u0011iMa6\u000e\u0005\t='\u0002\u0002Bi\u0005'\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUg)\u0001\u0006b]:|G/\u0019;j_:LAA!7\u0003P\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011MDW\u000f\u001e3po:\u0004")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            long now = $this.time.milliseconds();
            Lock inReadLock_inLock_lock = this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$2(this, now);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        void var2_2;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata));
        if (either == null) {
            throw null;
        }
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> map_this = either;
        if (map_this instanceof Right) {
            Object map_b = ((Right)map_this).value();
            Option option = (Option)map_b;
            return new Right((Object)TransactionStateManager.$anonfun$putTransactionStateIfNotExists$1(txnMetadata, option));
        }
        return var2_2;
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        Option<Object> option = this.zkClient.getTopicPartitionCount("__transaction_state");
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)this.config.transactionLogNumPartitions()) : getOrElse_this.get();
        Object var1_1 = null;
        return BoxesRunTime.unboxToInt((Object)object);
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            long create_e = log.logStartOffset();
            LongRef currOffset = new LongRef(create_e);
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var15_15 = null;
                    Object var16_16 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        Option previousTxnMetadataCacheEntryOpt = this.transactionMetadataCache().put((Object)txnTopicPartition, (Object)txnMetadataCacheEntry);
        if (previousTxnMetadataCacheEntryOpt == null) {
            throw null;
        }
        if (!previousTxnMetadataCacheEntryOpt.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry2 = (TxnMetadataCacheEntry)previousTxnMetadataCacheEntryOpt.get();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return;
        }
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var17_9 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var21_12 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        var21_12 = null;
        var16_10 = null;
        var17_9 = null;
        records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        v0 = Predef$.MODULE$.Map();
        v1 = new Tuple2[1];
        v1[0] = new Tuple2((Object)topicPartition, (Object)records);
        var13_16 = ScalaRunTime$.MODULE$.wrapRefArray(v1);
        if (v0 == null) {
            throw null;
        }
        var13_16 = null;
        recordsPerPartition = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)v0, (Seq)apply_elems);
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block11: {
                block10: {
                    var22_19 = false;
                    var23_20 = null;
                    var24_21 = this.getTransactionState(transactionalId);
                    if (!(var24_21 instanceof Left)) break block10;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var24_21).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block11;
                }
                if (!(var24_21 instanceof Right)) ** GOTO lbl-1000
                var22_19 = true;
                var23_20 = (Right)var24_21;
                var26_23 = (Option)var23_20.value();
                if (None$.MODULE$.equals(var26_23)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var22_19 && (var27_24 = (Option)var23_20.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var27_24).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback), this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8());
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var24_21);
                }
            }
            var23_20 = null;
            var24_21 = null;
            var25_22 = null;
            var26_23 = null;
            var27_24 = null;
            var28_25 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$5));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (Ongoing$.MODULE$.equals(transactionState)) {
                return txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
            return Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((TransactionMetadata)x0$3._2()).txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$12(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, TopicPartition topicPartition$1, ProduceResponse.PartitionResponse response$1) {
        scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)topicPartition$1.partition());
        Option option = $this.transactionMetadataCache().get((Object)topicPartition$1.partition());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            toRemove.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)x0$1._2();
            Lock inReadLock_inLock_lock = $this.stateLock().readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$12($this, transactionalIdByPartition$1, topicPartition, response);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$2(TransactionStateManager $this, long now$2) {
        scala.collection.immutable.Map transactionalIdByPartition = ((IterableOps)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)x0$1._2();
                return (Iterable)((IterableOps)((IterableOps)entry.metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5($this, now$2, x0$3)))).map((Function1 & Serializable)x0$4 -> {
                    if (x0$4 != null) {
                        String transactionalId = (String)x0$4._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$4._2();
                        TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable)() -> txnMetadata.prepareDead());
                        return new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        })).groupBy((Function1 & Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)$this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable)x0$5 -> {
            if (x0$5 != null) {
                void withRecords_timestampType;
                int partition = x0$5._1$mcI$sp();
                SimpleRecord[] deletes = (SimpleRecord[])((IterableOnceOps)((scala.collection.mutable.Iterable)x0$5._2()).map((Function1 & Serializable)entry -> new SimpleRecord(now$2, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                CompressionType withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
                byte withRecords_magic = 2;
                TimestampType timestampType = TimestampType.CREATE_TIME;
                long withRecords_initialOffset = 0L;
                timestampType = null;
                Object var7_4 = null;
                MemoryRecords records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])deletes);
                TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
                return new Tuple2((Object)topicPartition, (Object)records);
            }
            throw new MatchError(null);
        });
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
            return BoxedUnit.UNIT;
        }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ Nothing$ $anonfun$putTransactionStateIfNotExists$2(TransactionMetadata txnMetadata$3) {
        throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata$3).toString());
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$putTransactionStateIfNotExists$1(TransactionMetadata txnMetadata$3, Option x$1) {
        if (x$1 == null) {
            throw null;
        }
        if (x$1.isEmpty()) {
            throw TransactionStateManager.$anonfun$putTransactionStateIfNotExists$2(txnMetadata$3);
        }
        return (CoordinatorEpochAndTxnMetadata)x$1.get();
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$2) {
        return x$2.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$5(TransactionMetadata createdTxnMetadata$1) {
        return createdTxnMetadata$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$4(TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2, TransactionMetadata createdTxnMetadata) {
        Option option = Option$.MODULE$.apply((Object)cacheEntry$1.metadataPerTransactionalId().putIfNotExists(transactionalId$2, createdTxnMetadata));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        return (TransactionMetadata)(getOrElse_this.isEmpty() ? createdTxnMetadata : getOrElse_this.get());
    }

    public static final /* synthetic */ Option $anonfun$getAndMaybeAddTransactionState$3(Option createdTxnMetadataOpt$1, TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2) {
        if (createdTxnMetadataOpt$1.isEmpty()) {
            return None$.MODULE$;
        }
        TransactionMetadata transactionMetadata = (TransactionMetadata)createdTxnMetadataOpt$1.get();
        return new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$4(cacheEntry$1, transactionalId$2, transactionMetadata));
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$getAndMaybeAddTransactionState$6(TxnMetadataCacheEntry cacheEntry$1, TransactionMetadata x$3) {
        return new CoordinatorEpochAndTxnMetadata(cacheEntry$1.coordinatorEpoch(), x$3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$2, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$2);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$2)))) {
            void apply_value;
            Errors errors = Errors.COORDINATOR_LOAD_IN_PROGRESS;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            return new Left((Object)apply_value);
        }
        Option option = $this.transactionMetadataCache().get((Object)partitionId);
        if (option instanceof Some) {
            void apply_value;
            None$ none$;
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option option2 = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$2));
            if (option2 == null) {
                throw null;
            }
            Option orElse_this = option2;
            Option option3 = orElse_this.isEmpty() ? TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(createdTxnMetadataOpt$1, cacheEntry, transactionalId$2) : orElse_this;
            Object var7_7 = null;
            Option txnMetadata = option3;
            Right$ right$ = package$.MODULE$.Right();
            if (txnMetadata == null) {
                throw null;
            }
            if (txnMetadata.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                None$ none$2;
                TransactionMetadata transactionMetadata = (TransactionMetadata)txnMetadata.get();
                none$ = none$2 = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$6(cacheEntry, transactionMetadata));
            }
            if (right$ == null) {
                throw null;
            }
            return new Right((Object)apply_value);
        }
        if (None$.MODULE$.equals(option)) {
            void apply_value;
            Errors errors = Errors.NOT_COORDINATOR;
            if (package$.MODULE$.Left() == null) {
                throw null;
            }
            return new Left((Object)apply_value);
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ long $anonfun$loadTransactionMetadata$1() {
        return -1L;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        Option<Object> option = this.replicaManager.getLogEndOffset(topicPartition$2);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? Long.valueOf(-1L) : getOrElse_this.get();
        Object var2_2 = null;
        return BoxesRunTime.unboxToLong((Object)object);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ String $anonfun$loadTransactionMetadata$8() {
        return "Transaction state log's key should not be null";
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        if (!record.hasKey()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"Transaction state log's key should not be null").toString());
        }
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    return txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            void $plus$eq_elem;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            return transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        }
                        if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            void $plus$eq_elem;
                            TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                            if (transactionsPendingForCompletion == null) {
                                throw null;
                            }
                            return transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError(null);
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)txnTransitMetadata.coordinatorEpoch(), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - BoxesRunTime.unboxToLong((Object)startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - BoxesRunTime.unboxToLong((Object)startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        String transactionalId = (String)x0$1._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                        return txnMetadata.inLock((Function0 & Serializable)() -> {
                            TransactionState transactionState = txnMetadata.state();
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                void $plus$eq_elem;
                                TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                                if (transactionsPendingForCompletion == null) {
                                    throw null;
                                }
                                return transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                void $plus$eq_elem;
                                TransactionalIdCoordinatorEpochAndTransitMetadata transactionalIdCoordinatorEpochAndTransitMetadata = new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()));
                                if (transactionsPendingForCompletion == null) {
                                    throw null;
                                }
                                return transactionsPendingForCompletion.addOne((Object)$plus$eq_elem);
                            }
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError(null);
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)txnTransitMetadata.coordinatorEpoch(), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        void $minus$minus$eq_xs;
        Set<TransactionPartitionAndLeaderEpoch> set = $this.loadingPartitions();
        IterableOnce iterableOnce = (IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$4)));
        if (set == null) {
            throw null;
        }
        set.subtractAll((IterableOnce)$minus$minus$eq_xs);
        iterableOnce = null;
        Option option = $this.transactionMetadataCache().remove((Object)partitionId$2);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)partitionId$3);
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$4).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension("Append status %s should only have one partition %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var11_10 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            create_e = v1;
                            var29_11 = null;
                            responseError = new ObjectRef((Object)create_e);
                            v2 = (Errors)responseError.elem;
                            var12_13 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_13) == false : var12_13 != null) break block9;
                            var13_14 = false;
                            var14_15 = null;
                            var15_16 = this.getTransactionState(transactionalId$4);
                            if (!(var15_16 instanceof Left)) break block10;
                            err = (Errors)((Left)var15_16).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var15_16 instanceof Right)) break block12;
                        var13_14 = true;
                        var14_15 = (Right)var15_16;
                        var17_18 = (Option)var14_15.value();
                        if (!(var17_18 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_18).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var13_14 || !None$.MODULE$.equals(var20_21 = (Option)var14_15.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_16);
            }
            var21_22 = false;
            var22_23 = null;
            var23_24 = this.getTransactionState(transactionalId$4);
            if (!(var23_24 instanceof Right)) ** GOTO lbl-1000
            var21_22 = true;
            var22_23 = (Right)var23_24;
            var24_25 = (Option)var22_23.value();
            if (var24_25 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_25).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_22 && None$.MODULE$.equals(var27_28 = (Option)var22_23.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var23_24 instanceof Left) {
                error = (Errors)((Left)var23_24).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var23_24);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$4, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$4);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$4, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$4).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$5) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }

    public static final /* synthetic */ Object $anonfun$addLoadedTransactionsToCache$1$adapted(TransactionStateManager $this, int txnTopicPartition$1, int coordinatorEpoch$2, TxnMetadataCacheEntry previousTxnMetadataCacheEntry) {
        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$enableTransactionalIdExpiration$13$adapted(TransactionStateManager $this, scala.collection.mutable.Iterable toRemove$1, ProduceResponse.PartitionResponse response$1, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        toRemove$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
            String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
            TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
            return txnMetadata.inLock((Function0 & Serializable)() -> {
                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                    Errors errors = response$1.error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                    }
                }
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        });
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$removeTransactionsForTxnTopicPartition$3$adapted(TransactionStateManager $this, TopicPartition topicPartition$4, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
        return BoxedUnit.UNIT;
    }
}

