/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import kafka.coordinator.group.DelayedHeartbeat;
import kafka.coordinator.group.DelayedJoin;
import kafka.coordinator.group.GroupConfig;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.group.GroupMetadataManager;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.LeaveGroupResult;
import kafka.coordinator.group.LeaveMemberResponse;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.OffsetConfig;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class GroupCoordinator$ {
    public static final GroupCoordinator$ MODULE$ = new GroupCoordinator$();
    private static final String NoState = "";
    private static final String NoProtocolType = "";
    private static final String NoProtocol = "";
    private static final String NoLeader = "";
    private static final int NoGeneration = -1;
    private static final List<MemberSummary> NoMembers = Nil$.MODULE$;
    private static final GroupSummary EmptyGroup = new GroupSummary(MODULE$.NoState(), MODULE$.NoProtocolType(), MODULE$.NoProtocol(), MODULE$.NoMembers());
    private static final GroupSummary DeadGroup = new GroupSummary("Dead", MODULE$.NoProtocolType(), MODULE$.NoProtocol(), MODULE$.NoMembers());
    private static final int NewMemberJoinTimeoutMs = 300000;

    public String NoState() {
        return NoState;
    }

    public String NoProtocolType() {
        return NoProtocolType;
    }

    public String NoProtocol() {
        return NoProtocol;
    }

    public String NoLeader() {
        return NoLeader;
    }

    public int NoGeneration() {
        return NoGeneration;
    }

    public List<MemberSummary> NoMembers() {
        return NoMembers;
    }

    public GroupSummary EmptyGroup() {
        return EmptyGroup;
    }

    public GroupSummary DeadGroup() {
        return DeadGroup;
    }

    public int NewMemberJoinTimeoutMs() {
        return NewMemberJoinTimeoutMs;
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, Time time, Metrics metrics) {
        DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Heartbeat", config.brokerId(), 1000, true, true);
        DelayedOperationPurgatory<DelayedJoin> joinPurgatory = DelayedOperationPurgatory$.MODULE$.apply("Rebalance", config.brokerId(), 1000, true, true);
        return this.apply(config, zkClient, replicaManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public OffsetConfig offsetConfig(KafkaConfig config) {
        return new OffsetConfig(BoxesRunTime.unboxToInt((Object)config.offsetMetadataMaxSize()), BoxesRunTime.unboxToInt((Object)config.offsetsLoadBufferSize()), (long)BoxesRunTime.unboxToInt((Object)config.offsetsRetentionMinutes()) * 60L * 1000L, BoxesRunTime.unboxToLong((Object)config.offsetsRetentionCheckIntervalMs()), BoxesRunTime.unboxToInt((Object)config.offsetsTopicPartitions()), BoxesRunTime.unboxToInt((Object)config.offsetsTopicSegmentBytes()), BoxesRunTime.unboxToShort((Object)config.offsetsTopicReplicationFactor()), config.offsetsTopicCompressionCodec(), BoxesRunTime.unboxToInt((Object)config.offsetCommitTimeoutMs()), BoxesRunTime.unboxToShort((Object)config.offsetCommitRequiredAcks()));
    }

    public GroupCoordinator apply(KafkaConfig config, KafkaZkClient zkClient, ReplicaManager replicaManager, DelayedOperationPurgatory<DelayedHeartbeat> heartbeatPurgatory, DelayedOperationPurgatory<DelayedJoin> joinPurgatory, Time time, Metrics metrics) {
        OffsetConfig offsetConfig = this.offsetConfig(config);
        GroupConfig groupConfig = new GroupConfig(BoxesRunTime.unboxToInt((Object)config.groupMinSessionTimeoutMs()), BoxesRunTime.unboxToInt((Object)config.groupMaxSessionTimeoutMs()), BoxesRunTime.unboxToInt((Object)config.groupMaxSize()), BoxesRunTime.unboxToInt((Object)config.groupInitialRebalanceDelay()));
        GroupMetadataManager groupMetadataManager = new GroupMetadataManager(config.brokerId(), config.interBrokerProtocolVersion(), offsetConfig, replicaManager, zkClient, time, metrics);
        return new GroupCoordinator(config.brokerId(), groupConfig, offsetConfig, groupMetadataManager, heartbeatPurgatory, joinPurgatory, time, metrics);
    }

    public LeaveMemberResponse kafka$coordinator$group$GroupCoordinator$$memberLeaveError(LeaveGroupRequestData.MemberIdentity memberIdentity, Errors error) {
        return new LeaveMemberResponse(memberIdentity.memberId(), (Option<String>)Option$.MODULE$.apply((Object)memberIdentity.groupInstanceId()), error);
    }

    public LeaveGroupResult kafka$coordinator$group$GroupCoordinator$$leaveError(Errors topLevelError, List<LeaveMemberResponse> memberResponses) {
        return new LeaveGroupResult(topLevelError, memberResponses);
    }

    private GroupCoordinator$() {
    }
}

