/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019Y\u0006\u0001)A\u0005\u001d\"IA\f\u0001a\u0001\u0002\u0004%I!\u0018\u0005\nC\u0002\u0001\r\u00111A\u0005\n\tD\u0011b\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u00020\t\u000b1\u0004A\u0011I7\t\u000bU\u0004A\u0011I7\t\u000bi\u0004A\u0011A7\t\r}\u0004A\u0011BA\u0001\u0011\u0019\t\u0019\u0003\u0001C\u0001[\"1\u0011\u0011\u0007\u0001\u0005\u00025Da!!\u000e\u0001\t\u0003i\u0007BBA\u001d\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002>\u0001!\t!\u001c\u0005\u0007\u0003\u0003\u0002A\u0011A7\t\r\u0005\u0015\u0003\u0001\"\u0001n\u0011\u0019\tI\u0005\u0001C\u0001[\"1\u0011Q\n\u0001\u0005\u00025Da!!\u0015\u0001\t\u0003i\u0007BBA+\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002Z\u0001!\t!\u001c\u0005\u0007\u0003;\u0002A\u0011A7\t\r\u0005\u0005\u0004\u0001\"\u0001n\u0011\u0019\t)\u0007\u0001C\u0001[\"1\u0011\u0011\u000e\u0001\u0005\u00025Da!!\u001c\u0001\t\u0003i\u0007BBA9\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002v\u0001!\t!\u001c\u0005\u0007\u0003s\u0002A\u0011A7\t\r\u0005u\u0004\u0001\"\u0001n\u0011\u0019\t\t\t\u0001C\u0001[\"1\u0011Q\u0011\u0001\u0005\u00025Da!!#\u0001\t\u0003i\u0007BBAG\u0001\u0011\u0005Q\u000e\u0003\u0004\u0002\u0012\u0002!\t!\u001c\u0005\u0007\u0003+\u0003A\u0011A7\t\r\u0005e\u0005\u0001\"\u0001n\u0011\u0019\ti\n\u0001C\u0001[\"1\u0011\u0011\u0015\u0001\u0005\u00025Dq!!*\u0001\t\u0003\t9\u000b\u0003\u0004\u0002P\u0002!\t!\u001c\u0005\u0007\u0003'\u0004A\u0011A7\t\r\u0005]\u0007\u0001\"\u0003n\u0011\u001d\tI\u000e\u0001C\u0005\u00037\u00141CW8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e+fgRT!AM\u001a\u0002\u0013i|wn[3fa\u0016\u0014(\"\u0001\u001b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003uM\n!A_6\n\u0005qJ$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u007fA\u0011\u0001\tA\u0007\u0002c\u0005AQn\\2l!\u0006$\b.F\u0001D!\t!\u0015*D\u0001F\u0015\t1u)\u0001\u0003mC:<'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u0013aa\u0015;sS:<\u0017!C7pG.\u0004\u0016\r\u001e5!\u0003\u0011!\u0018.\\3\u0016\u00039\u0003\"aT-\u000e\u0003AS!!\u0015*\u0002\u000bU$\u0018\u000e\\:\u000b\u0005M#\u0016AB2p[6|gN\u0003\u00025+*\u0011akV\u0001\u0007CB\f7\r[3\u000b\u0003a\u000b1a\u001c:h\u0013\tQ\u0006K\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013a\u0004>p_.+W\r]3s\u00072LWM\u001c;\u0016\u0003y\u0003\"\u0001Q0\n\u0005\u0001\f$a\u0004.p_.+W\r]3s\u00072LWM\u001c;\u0002'i|wnS3fa\u0016\u00148\t\\5f]R|F%Z9\u0015\u0005\rL\u0007C\u00013h\u001b\u0005)'\"\u00014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!,'\u0001B+oSRDqA[\u0004\u0002\u0002\u0003\u0007a,A\u0002yIE\n\u0001C_8p\u0017\u0016,\u0007/\u001a:DY&,g\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0003\rD#!C8\u0011\u0005A\u001cX\"A9\u000b\u0005I<\u0016!\u00026v]&$\u0018B\u0001;r\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u000boB\u0011\u0001\u000f_\u0005\u0003sF\u0014Q!\u00114uKJ\fQ\u0004^3tiVs'/Z:pYZ\f'\r\\3D_:tWm\u0019;TiJLgn\u001a\u0015\u0003\u0017q\u0004\"\u0001]?\n\u0005y\f(\u0001\u0002+fgR\fAC];o]&twMW6TK:$G\u000b\u001b:fC\u0012\u001cXCAA\u0002!\u0019\t)!a\u0003\u0002\u00105\u0011\u0011q\u0001\u0006\u0004\u0003\u0013)\u0017AC2pY2,7\r^5p]&!\u0011QBA\u0004\u0005\r\u0019V\r\u001e\t\u0005\u0003#\tyB\u0004\u0003\u0002\u0014\u0005m\u0001cAA\u000bK6\u0011\u0011q\u0003\u0006\u0004\u00033)\u0014A\u0002\u001fs_>$h(C\u0002\u0002\u001e\u0015\fa\u0001\u0015:fI\u00164\u0017b\u0001&\u0002\")\u0019\u0011QD3\u0002+Q,7\u000f^\"p]:,7\r^5p]RKW.Z8vi\"2Q\u0002`A\u0014\u0003S\t\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003W\u00012\u0001QA\u0017\u0013\r\ty#\r\u0002 5>|7*Z3qKJ\u001cE.[3oiRKW.Z8vi\u0016C8-\u001a9uS>t\u0017A\u0004;fgR\u001cuN\u001c8fGRLwN\u001c\u0015\u0003\u001dq\fA\u0004^3ti\u000e{gN\\3di&|gNV5b\u001d\u0016$H/_\"mS\u0016tG\u000f\u000b\u0002\u0010y\u0006QB/Z:u\t\u0016dW\r^3O_:,\u00050[:uK:$(LT8eK\"\u0012\u0001\u0003`\u0001\u0018i\u0016\u001cH\u000fR3mKR,W\t_5ti&twM\u0017(pI\u0016D#!\u0005?\u00025Q,7\u000f^#ySN$8OT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0005Ia\u0018a\u0006;fgR,\u00050[:ug\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\t\u0019B0A\u000euKN$x)\u001a;ECR\fgj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0003)q\f\u0001\u0004^3ti\u001e+G\u000fR1uC\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\t)B0A\u000euKN$8+\u001a;ECR\fgj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0003-q\f\u0001\u0004^3tiN+G\u000fR1uC\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\t9B0\u0001\u000euKN$x)\u001a;BG2tuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002\u0019y\u00069B/Z:u\u000f\u0016$\u0018i\u00197Fq&\u001cH/\u001b8h5:{G-\u001a\u0015\u00033q\f!\u0004^3tiN+G/Q2m\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D#A\u0007?\u0002?Q,7\u000f^$fi\u000eC\u0017\u000e\u001c3sK:tuN\\#ySN$XM\u001c;[\u001d>$W\r\u000b\u0002\u001cy\u0006aB/Z:u\u000f\u0016$8\t[5mIJ,g.\u0012=jgRLgn\u001a.O_\u0012,\u0007F\u0001\u000f}\u0003!\"Xm\u001d;HKR\u001c\u0005.\u001b7ee\u0016tW\t_5ti&twM\u0017(pI\u0016<\u0016\u000e\u001e5DQ&dGM]3oQ\tiB0\u0001\u000buKN$\b+\u001b9fY&tW\rZ$fi\u0012\u000bG/\u0019\u0015\u0003=q\f\u0011\u0003^3ti6K\u00070\u001a3QSB,G.\u001b8fQ\tyB0A\u0011uKN$(LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u00148I]3bi&|g\u000e\u000b\u0002!y\u0006\tC/Z:u5:{G-Z\"iC:<W\rS1oI2,'OR8s\t\u0016dW\r^5p]\"\u0012\u0011\u0005`\u0001$i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'\u000fR1uC\u000eC\u0017M\\4fQ\t\u0011C0\u0001\u001auKN$(\t\\8dW>s'+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8Ge>l7\u000b^1uK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3sQ\t\u0019C0\u0001\u0015uKN$X\t_2faRLwN\\%o\u0005\u00164wN]3J]&$\u0018.\u00197ju&twmU3tg&|g\u000e\u000b\u0002%y\u0006IC/Z:u5:{G-Z\"iS2$7\t[1oO\u0016D\u0015M\u001c3mKJ4uN]\"iS2$7\t[1oO\u0016D#!\n?\u0002kQ,7\u000f\u001e.O_\u0012,7\t[5mI\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s\r>\u00148\t[5mI\u000eC\u0017M\\4f\u001d>$HK]5hO\u0016\u0014X\r\u001a\u0015\u0003Mq\fA\u0005^3tiN#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0006+H\u000f\u001b$bS2,(/\u001a\u0015\u0003Oq\fA\u0005^3ti\u000e{gN\\3di&|g\u000eT8tgJ+\u0017/^3tiR+'/\\5oCRLwN\u001c\u0015\u0003Qq\f\u0011\u0003^3tiN+7o]5p]\u0016C\b/\u001b:zQ\tIC0\u0001\u000fuKN$8+Z:tS>tW\t\u001f9jef$UO]5oO\u000ecwn]3)\u0005)b\u0018\u0001F5t\u000bb\u0004Xm\u0019;fI6+GO]5d\u001d\u0006lW\r\u0006\u0004\u0002*\u0006=\u00161\u001a\t\u0004I\u0006-\u0016bAAWK\n9!i\\8mK\u0006t\u0007bBAYW\u0001\u0007\u00111W\u0001\u000b[\u0016$(/[2OC6,\u0007\u0003BA[\u0003\u000fl!!a.\u000b\t\u0005e\u00161X\u0001\u0005G>\u0014XM\u0003\u0003\u0002>\u0006}\u0016aB7fiJL7m\u001d\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003\u000b\f1aY8n\u0013\u0011\tI-a.\u0003\u00155+GO]5d\u001d\u0006lW\rC\u0004\u0002N.\u0002\r!a\u0004\u0002\t9\fW.Z\u0001$i\u0016\u001cHOW8p\u0017\u0016,\u0007/\u001a:Ti\u0006$Xm\u00115b]\u001e,'+\u0019;f\u001b\u0016$(/[2tQ\taC0A\u0010uKN$(l\\8LK\u0016\u0004XM]*fgNLwN\\*uCR,W*\u001a;sS\u000eD#!\f?\u0002)\rdW-\u00198NKR\u0014\u0018nY:SK\u001eL7\u000f\u001e:z\u0003\u0015\u0011\u0017\u0010^3t+\t\ti\u000eE\u0003e\u0003?\f\u0019/C\u0002\u0002b\u0016\u0014Q!\u0011:sCf\u00042\u0001ZAs\u0013\r\t9/\u001a\u0002\u0005\u0005f$X\r")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@Before");
        this.cleanMetricsRegistry();
        super.setUp();
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "testMetricGroup", "testMetricType"));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@After");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            new ZooKeeperClient("some.invalid.hostname.foo.bar.local", this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
            return;
        }
        catch (ZooKeeperClientTimeoutException zooKeeperClientTimeoutException) {
            if (Predef$.MODULE$.Set() == null) {
                throw null;
            }
            Assert.assertEquals((String)"ZooKeeper client threads still running", (Object)Set.EmptySet$.MODULE$, this.runningZkSendThreads());
            return;
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((IterableOps)((IterableOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, Thread.getAllStackTraces().keySet()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isAlive()))).map((Function1 & Serializable)x$3 -> x$3.getName())).filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test(expected=ZooKeeperClientTimeoutException.class)
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testConnection() {
        try (ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            scala.collection.mutable.Set threads = (scala.collection.mutable.Set)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, Thread.getAllStackTraces().keySet()).asScala().map((Function1 & Serializable)x$4 -> x$4.getName());
            Assert.assertTrue((String)new StringBuilder(48).append("ZooKeeperClient event thread not found, threads=").append(threads).toString(), (boolean)threads.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains(ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix()))));
        }
    }

    @Test
    public void testConnectionViaNettyClient() {
        ZKClientConfig clientConfig = new ZKClientConfig();
        String propKey = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        String propVal = "org.apache.zookeeper.ClientCnxnSocketNetty";
        KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, propKey, (Object)propVal);
        try (ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", (Option)None$.MODULE$, (Option)new Some((Object)clientConfig));){
            Assert.assertEquals((Object)new Some((Object)propVal), (Object)KafkaConfig$.MODULE$.getZooKeeperClientProperty(client.getClientConfig(), propKey));
            ZKClientConfig badClientConfig = new ZKClientConfig();
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(badClientConfig, propKey, (Object)new StringBuilder(12).append(propVal).append("BadClassName").toString());
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType", (Option)None$.MODULE$, (Option)new Some((Object)badClientConfig)), ClassTag$.MODULE$.apply(Exception.class), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        }
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> deleteResponse.maybeThrow(), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode());
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)existsResponse.resultCode());
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode());
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match created znode data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode());
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match setData's data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode());
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getAcl should be OK", (Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode());
        Assert.assertEquals((String)new StringBuilder(14).append("ACL should be ").append(AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString(), (Object)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode());
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode());
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return no children", (Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children());
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create child2 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return two children", (Object)new .colon.colon((Object)child1, (List)new .colon.colon((Object)child2, (List)Nil$.MODULE$)), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPipelinedGetData() {
        GetDataRequest getDataRequest;
        CreateRequest createRequest;
        int n = 1;
        int to$extension_end = 3;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            createRequest = ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            createRequest = null;
        }
        Object var5_3 = null;
        Object var6_4 = null;
        Object var7_5 = null;
        createRequest = null;
        ((IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b.result()).map(arg_0 -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$2(this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient(), arg_0))).foreach((Function1 & Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        int n2 = 1;
        int to$extension_end2 = 3;
        Range.Inclusive map_this2 = new Range.Inclusive(n2, to$extension_end2, 1);
        map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it2 = map_this2.iterator();
        while (map_strictOptimizedMap_it2.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            getDataRequest = ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it2.next()));
            if (map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            map_strictOptimizedMap_b2.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            getDataRequest = null;
        }
        Object var9_9 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        getDataRequest = null;
        IndexedSeq getDataRequests = (IndexedSeq)map_strictOptimizedMap_b2.result();
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)getDataResponses.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", new byte[0], -1, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)getDataRequest, (List)new .colon.colon((Object)setDataRequest, (List)Nil$.MODULE$)));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertArrayEquals((String)"Data for getData should be empty", (byte[])new byte[0], (byte[])((GetDataResponse)responses.head()).data());
        Assert.assertEquals((String)"Response code for setData should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode());
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)existsRequest, (List)new .colon.colon((Object)createRequest, (List)Nil$.MODULE$)));
        Assert.assertEquals((String)"Response code for exists should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive delete notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Option)None$.MODULE$);
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)new .colon.colon((Object)createRequest, (List)new .colon.colon((Object)existsRequest, (List)Nil$.MODULE$)));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], -1, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive data change notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                try {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread reinitializeThread = new Thread(this){
            private final /* synthetic */ ZooKeeperClientTest $outer;

            public void run() {
                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                this.name = this.getClass().getName();
            }
        };
        AtomicInteger goodCalls = new AtomicInteger(0);
        StateChangeHandler goodHandler = new StateChangeHandler(null, goodCalls){
            private final String name;
            private final AtomicInteger goodCalls$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.goodCalls$1.incrementAndGet();
            }
            {
                this.goodCalls$1 = goodCalls$1;
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(faultyHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(goodHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
        Assert.assertEquals((long)1L, (long)goodCalls.get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), true, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        Assert.assertTrue((String)"Failed to receive child change notification", (boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChangeNotTriggered() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$2;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$2 = zNodeChildChangeHandlerCountDownLatch$2;
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), false, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, new byte[0], (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        Assert.assertFalse((String)"Child change notification received", (boolean)zNodeChildChangeHandlerCountDownLatch.await(100L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assert.assertTrue((String)"Failed to receive auth failed notification", (boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConnectionLossRequestTermination() {
        int batchSize = 10;
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), 2, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");){
            GetDataRequest getDataRequest;
            int n = 1;
            Range.Inclusive map_this = new Range.Inclusive(n, batchSize, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                getDataRequest = ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                getDataRequest = null;
            }
            Object var10_4 = null;
            Object var11_5 = null;
            Object var12_6 = null;
            getDataRequest = null;
            IndexedSeq requests = (IndexedSeq)map_strictOptimizedMap_b.result();
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, running, zooKeeperClient, requests, unexpectedResponses, countDownLatch){
                private final AtomicBoolean running$1;
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final ArrayBlockingQueue unexpectedResponses$1;
                private final CountDownLatch countDownLatch$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$12.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$12 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.running$1 = running$1;
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                    this.countDownLatch$1 = countDownLatch$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$12 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            if (!countDownLatch.await(30L, TimeUnit.SECONDS)) {
                running.set(false);
                requestThread.join(5000L);
                throw Assertions$.MODULE$.fail("Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
            }
            if (!unexpectedResponses.isEmpty()) {
                throw Assertions$.MODULE$.fail(new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString(), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = new VolatileObjectRef(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendCompleteSemaphore, sendSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendCompleteSemaphore$1;
            public final Semaphore sendSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable)response -> {
                    $anon$13.$anonfun$send$1(this, processResponse, response);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$13 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new Runnable($this, processResponse$1, response){
                    private final /* synthetic */ $anon$13 $outer;
                    private final Function1 processResponse$1;
                    private final AsyncResponse response$1;

                    public void run() {
                        this.$outer.sendCompleteSemaphore$1.release();
                        this.$outer.sendSemaphore$1.acquire();
                        this.processResponse$1.apply((Object)this.response$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.processResponse$1 = processResponse$1;
                        this.response$1 = response$1;
                    }
                });
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$13 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            void apply_elems;
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, stateChanges, sendSemaphore, sendSize, zooKeeperClient){
                private final String name;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assert.assertTrue((String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString(), (boolean)threadName.startsWith(this.zooKeeperClient$2.expiryScheduler().threadNamePrefix()));
                }
                {
                    this.stateChanges$1 = stateChanges$1;
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    GetDataRequest getDataRequest;
                    int n = 1;
                    int to$extension_end = this.sendSize$1;
                    Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
                    map_this.scala$collection$immutable$Range$$validateMaxLength();
                    Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
                    Iterator map_strictOptimizedMap_it = map_this.iterator();
                    while (map_strictOptimizedMap_it.hasNext()) {
                        void map_strictOptimizedMap_$plus$eq_elem;
                        getDataRequest = $anon$16.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
                        if (map_strictOptimizedMap_b == null) {
                            throw null;
                        }
                        map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                        getDataRequest = null;
                    }
                    Object var3_3 = null;
                    Object var4_4 = null;
                    Object var5_5 = null;
                    getDataRequest = null;
                    IndexedSeq requests = (IndexedSeq)map_strictOptimizedMap_b.result();
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable)x$6 -> x$6.resultCode());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4$adapted(Object i) {
                    return $anon$16.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                throw Assertions$.MODULE$.fail("Request thread did not complete", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
            }
            Assert.assertEquals((Object)new .colon.colon((Object)"beforeInitializingSession", (List)new .colon.colon((Object)"afterInitializingSession", (List)Nil$.MODULE$)), (Object)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, stateChanges).asScala().toSeq());
            Seq seq = (Seq)resultCodes.elem;
            if (seq == null) {
                throw null;
            }
            Assert.assertEquals((long)seq.length(), (long)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$7)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount <= maxInflightRequests ? 1 : 0) != 0);
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$8)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString(), (expiredCount <= maxInflightRequests ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount + expiredCount > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertTrue((String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString(), (boolean)((SeqOps)((Seq)resultCodes.elem).filterNot(arg_0 -> ZooKeeperClientTest.$anonfun$testSessionExpiry$3$adapted((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), arg_0))).isEmpty());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)zooKeeperClient.expiryScheduler().isStarted());
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable)() -> semaphore.acquireUninterruptibly(), 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleSessionExpiryHandler();
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertFalse((String)"Close completed without shutting down expiry scheduler gracefully", (boolean)closeFuture.isDone());
            Assert.assertTrue((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().currentZooKeeper().getState().isAlive());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().isStarted());
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(name) : name != null)) {
            String string2 = metricName.getGroup();
            String string3 = "testMetricGroup";
            if (string2 != null && string2.equals(string3)) {
                String string4 = metricName.getType();
                String string5 = "testMetricType";
                if (string4 != null && string4.equals(string5)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assert.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = KafkaYammerMetrics.defaultRegistry();
        metrics.allMetrics().keySet().forEach(x$1 -> metrics.removeMetric(x$1));
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), Integer.toString(x * 2).getBytes(), (Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ CreateResponse $anonfun$testPipelinedGetData$2(ZooKeeperClient eta$0$1$1, CreateRequest request) {
        return (CreateResponse)eta$0$1$1.handleRequest((AsyncRequest)request);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            GetDataResponse getDataResponse = (GetDataResponse)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
            Assert.assertEquals((String)"Data for getData should match", (Object)((i + 1) * 2), (Object)Integer.valueOf(new String(getDataResponse.data())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$7) {
        KeeperException.Code code = x$7;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$8) {
        KeeperException.Code code = x$8;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testZooKeeperStateChangeRateMetrics$1(String name$1) {
        String error_message = new StringBuilder(31).append("Unable to find meter with name ").append(name$1).toString();
        throw new RuntimeException(error_message);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Option option = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric meter = (Metric)x1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            return (B1)meter2;
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    if ((Metric)x1._2() instanceof Meter && this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw ZooKeeperClientTest.$anonfun$testZooKeeperStateChangeRateMetrics$1(name);
        }
        Object var5_3 = null;
        Meter meter = (Meter)getOrElse_this.get();
        Assert.assertEquals((String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString(), (long)expected, (long)meter.count());
    }

    private final Option gaugeValue$1(String name) {
        return AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().collectFirst((PartialFunction)new Serializable(this, name){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric gauge = (Metric)x1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            return (B1)((String)gauge2.value());
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    if ((Metric)x1._2() instanceof Gauge && this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1$adapted(Object x) {
        return ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4$adapted(Object x) {
        return ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1$adapted(Object i) {
        return ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testSessionExpiry$3$adapted(scala.collection.immutable.Set eta$0$1$2, KeeperException.Code elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$2.contains((Object)elem));
    }
}

