/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.MapFactory;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Right;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-Bq!\b\u0001C\u0002\u0013%a\u0006\u0003\u0004;\u0001\u0001\u0006Ia\f\u0005\u0006w\u0001!I\u0001\u0010\u0005\u0006\u0005\u0002!Ia\u0011\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t9\u0003\u0001C\u0001\u0003'Aq!a\u000b\u0001\t\u0003\t\u0019\u0002C\u0004\u00020\u0001!\t!a\u0005\t\u000f\u0005M\u0002\u0001\"\u0001\u0002\u0014!9\u0011q\u0007\u0001\u0005\u0002\u0005M\u0001bBA\u001e\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u007f\u0001A\u0011AA\n\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003'Aq!a\u0012\u0001\t\u0003\t\u0019\u0002C\u0004\u0002L\u0001!\t!a\u0005\t\u000f\u0005=\u0003\u0001\"\u0001\u0002\u0014!9\u00111\u000b\u0001\u0005\u0002\u0005M\u0001bBA,\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0002A\u0011AA\n\u0011\u001d\ty\u0006\u0001C\u0001\u0003'Aq!a\u0019\u0001\t\u0003\t\u0019\u0002C\u0004\u0002h\u0001!\t!a\u0005\t\u000f\u0005-\u0004\u0001\"\u0001\u0002\u0014\ti!j]8o-\u0006dW/\u001a+fgRT!!\b\u0010\u0002\t)\u001cxN\u001c\u0006\u0003?\u0001\nQ!\u001e;jYNT\u0011!I\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"!\f\u0001\u000e\u0003q)\u0012a\f\t\u0003a]r!!M\u001b\u0011\u0005I2S\"A\u001a\u000b\u0005Q\u0012\u0013A\u0002\u001fs_>$h(\u0003\u00027M\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1d%A\u0003kg>t\u0007%A\u0003qCJ\u001cX\r\u0006\u0002>\u0001B\u0011QFP\u0005\u0003\u007fq\u0011\u0011BS:p]Z\u000bG.^3\t\u000b\u0005#\u0001\u0019A\u0018\u0002\u0003M\f\u0001\"Y:tKJ$Hk\\\u000b\u0003\tB#2!R-\\)\t1\u0015\n\u0005\u0002&\u000f&\u0011\u0001J\n\u0002\u0005+:LG\u000fC\u0004K\u000b\u0005\u0005\t9A&\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002.\u0019:K!!\u0014\u000f\u0003\u0015\u0011+7m\u001c3f\u0015N|g\u000e\u0005\u0002P!2\u0001A!B)\u0006\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006CA\u0013U\u0013\t)fEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015:\u0016B\u0001-'\u0005\r\te.\u001f\u0005\u00065\u0016\u0001\rAT\u0001\tKb\u0004Xm\u0019;fI\")A,\u0002a\u0001;\u0006I!n]8o-\u0006dW/\u001a\t\u0005Ky\u0003W(\u0003\u0002`M\tIa)\u001e8di&|g.\r\t\u0003[\u0005L!A\u0019\u000f\u0003\u0015)\u001bxN\\(cU\u0016\u001cG/A\u0007bgN,'\u000f\u001e+p\r\u0006LGn]\u000b\u0003K.$\"A\u001a7\u0015\u0005\u0019;\u0007b\u00025\u0007\u0003\u0003\u0005\u001d![\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u0017MUB\u0011qj\u001b\u0003\u0006#\u001a\u0011\rA\u0015\u0005\u00069\u001a\u0001\r!X\u0001\fCN\u001cXM\u001d;UQJ|w/\u0006\u0002poR\u0019\u0001/a\u0002\u0015\u0005\u0019\u000b\bb\u0002:\b\u0003\u0003\u0005\u001da]\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004c\u0001\u0019um&\u0011Q/\u000f\u0002\t\u001b\u0006t\u0017NZ3tiB\u0011qj\u001e\u0003\u0006q\u001e\u0011\r!\u001f\u0002\u0002\u000bF\u00111K\u001f\t\u0004w\u0006\u0005aB\u0001?\u007f\u001d\t\u0011T0C\u0001(\u0013\tyh%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\n)\"\u0014xn^1cY\u0016T!a \u0014\t\u0011\u0005%q\u0001\"a\u0001\u0003\u0017\tAAY8esB!Q%!\u0004G\u0013\r\tyA\n\u0002\ty\tLh.Y7f}\u0005\u0001B/Z:u\u0003NT5o\u001c8PE*,7\r\u001e\u000b\u0002\r\"\u001a\u0001\"a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005)!.\u001e8ji*\u0011\u0011\u0011E\u0001\u0004_J<\u0017\u0002BA\u0013\u00037\u0011A\u0001V3ti\u00061B/Z:u\u0003NT5o\u001c8PE*,7\r^(qi&|g\u000eK\u0002\n\u0003/\tq\u0002^3ti\u0006\u001b(j]8o\u0003J\u0014\u0018-\u001f\u0015\u0004\u0015\u0005]\u0011!\u0006;fgR\f5OS:p]\u0006\u0013(/Y=PaRLwN\u001c\u0015\u0004\u0017\u0005]\u0011!\u0005;fgRT5o\u001c8PE*,7\r^$fi\"\u001aA\"a\u0006\u0002'Q,7\u000f\u001e&t_:|%M[3di\u0006\u0003\b\u000f\\=)\u00075\t9\"\u0001\fuKN$(j]8o\u001f\nTWm\u0019;Ji\u0016\u0014\u0018\r^8sQ\rq\u0011qC\u0001\u0016i\u0016\u001cHOS:p]\u0006\u0013(/Y=Ji\u0016\u0014\u0018\r^8sQ\ry\u0011qC\u0001\u0014i\u0016\u001cHOS:p]Z\u000bG.^3FcV\fGn\u001d\u0015\u0004!\u0005]\u0011!\u0006;fgRT5o\u001c8WC2,X\rS1tQ\u000e{G-\u001a\u0015\u0004#\u0005]\u0011!\u0006;fgRT5o\u001c8WC2,X\rV8TiJLgn\u001a\u0015\u0004%\u0005]\u0011!\u0005;fgR$UmY8eK\n{w\u000e\\3b]\"\u001a1#a\u0006\u0002!Q,7\u000f\u001e#fG>$Wm\u0015;sS:<\u0007f\u0001\u000b\u0002\u0018\u0005iA/Z:u\t\u0016\u001cw\u000eZ3J]RD3!FA\f\u00039!Xm\u001d;EK\u000e|G-\u001a'p]\u001eD3AFA\f\u0003A!Xm\u001d;EK\u000e|G-\u001a#pk\ndW\rK\u0002\u0018\u0003/\tQ\u0002^3ti\u0012+7m\u001c3f'\u0016\f\bf\u0001\r\u0002\u0018\u0005iA/Z:u\t\u0016\u001cw\u000eZ3NCBD3!GA\f\u0003A!Xm\u001d;EK\u000e|G-Z(qi&|g\u000eK\u0002\u001b\u0003/\u0001")
public class JsonValueTest {
    private final String json = StringOps$.MODULE$.stripMargin$extension("\n    |{\n    |  \"boolean\": false,\n    |  \"int\": 1234,\n    |  \"long\": 3000000000,\n    |  \"double\": 16.244355,\n    |  \"string\": \"string\",\n    |  \"number_as_string\": \"123\",\n    |  \"array\": [4.0, 11.1, 44.5],\n    |  \"object\": {\n    |    \"a\": true,\n    |    \"b\": false\n    |  },\n    |  \"null\": null\n    |}\n   ", '|');

    private String json() {
        return this.json;
    }

    private JsonValue parse(String s) {
        Option option = Json$.MODULE$.parseFull(s);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw JsonValueTest.$anonfun$parse$1(s);
        }
        return (JsonValue)getOrElse_this.get();
    }

    private <T> void assertTo(T expected, Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$1) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right(expected), (Object)parsed.toEither(evidence$1));
        Assert.assertEquals(expected, (Object)parsed.to(evidence$1));
    }

    private <T> void assertToFails(Function1<JsonObject, JsonValue> jsonValue, DecodeJson<T> evidence$2) {
        JsonValue parsed = (JsonValue)jsonValue.apply((Object)this.parse(this.json()).asJsonObject());
        Assert.assertTrue((boolean)parsed.toEither(evidence$2).isLeft());
        Class<JsonMappingException> classType_clazz = JsonMappingException.class;
        Object var4_4 = null;
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.to(evidence$2), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, classType_clazz, (List)Nil$.MODULE$));
    }

    public <E extends Throwable> void assertThrow(Function0<BoxedUnit> body, Manifest<E> evidence$3) {
        Class klass = evidence$3.runtimeClass();
        Option option = Exception$.MODULE$.catchingPromiscuously((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{klass})).opt(body);
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            BoxedUnit boxedUnit = (BoxedUnit)foreach_this.get();
            JsonValueTest.$anonfun$assertThrow$1(klass, boxedUnit);
            return;
        }
    }

    @Test
    public void testAsJsonObject() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue obj = parsed.apply("object");
        Assert.assertEquals((Object)obj, (Object)obj.asJsonObject());
        Class<JsonMappingException> classType_clazz = JsonMappingException.class;
        Object var3_3 = null;
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("array").asJsonObject(), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, classType_clazz, (List)Nil$.MODULE$));
    }

    @Test
    public void testAsJsonObjectOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("object").asJsonObjectOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("array").asJsonObjectOption());
    }

    @Test
    public void testAsJsonArray() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        JsonValue array = parsed.apply("array");
        Assert.assertEquals((Object)array, (Object)array.asJsonArray());
        Class<JsonMappingException> classType_clazz = JsonMappingException.class;
        Object var3_3 = null;
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("object").asJsonArray(), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, classType_clazz, (List)Nil$.MODULE$));
    }

    @Test
    public void testAsJsonArrayOption() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertTrue((boolean)parsed.apply("array").asJsonArrayOption().isDefined());
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.apply("object").asJsonArrayOption());
    }

    @Test
    public void testJsonObjectGet() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)new Some((Object)this.parse("{\"a\":true,\"b\":false}")), (Object)parsed.get("object"));
        Assert.assertEquals((Object)None$.MODULE$, (Object)parsed.get("aaaaa"));
    }

    @Test
    public void testJsonObjectApply() {
        JsonObject parsed = this.parse(this.json()).asJsonObject();
        Assert.assertEquals((Object)this.parse("{\"a\":true,\"b\":false}"), (Object)parsed.apply("object"));
        Class<JsonMappingException> classType_clazz = JsonMappingException.class;
        Object var2_2 = null;
        this.assertThrow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> parsed.apply("aaaaaaaa"), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, classType_clazz, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testJsonObjectIterator() {
        void apply_elems;
        void $minus$greater$extension_y;
        Vector$ vector$ = package$.MODULE$.Vector();
        Object[] objectArray = new Tuple2[2];
        JsonValue $minus$greater$extension_y2 = this.parse("true");
        String $minus$greater$extension_$this = "a";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        JsonValue jsonValue = this.parse("false");
        String $minus$greater$extension_$this2 = "b";
        Object var3_4 = null;
        jsonValue = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (vector$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)vector$, (Seq)apply_elems), (Object)this.parse(this.json()).asJsonObject().apply("object").asJsonObject().iterator().toVector());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testJsonArrayIterator() {
        void apply_elems;
        Vector$ vector$ = package$.MODULE$.Vector();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"4.0", "11.1", "44.5"});
        if (vector$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)((StrictOptimizedIterableOps)IterableFactory.apply$((IterableFactory)vector$, (Seq)apply_elems)).map((Function1 & Serializable)s -> this.parse((String)s)), (Object)this.parse(this.json()).asJsonObject().apply("array").asJsonArray().iterator().toVector());
    }

    @Test
    public void testJsonValueEquals() {
        Assert.assertEquals((Object)this.parse(this.json()), (Object)this.parse(this.json()));
        Assert.assertEquals((Object)this.parse("{\"blue\": true, \"red\": false}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertNotEquals((Object)this.parse("{\"blue\": true, \"red\": true}"), (Object)this.parse("{\"red\": false, \"blue\": true}"));
        Assert.assertEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[1, 2, 3]"));
        Assert.assertNotEquals((Object)this.parse("[1, 2, 3]"), (Object)this.parse("[2, 1, 3]"));
        Assert.assertEquals((Object)this.parse("1344"), (Object)this.parse("1344"));
        Assert.assertNotEquals((Object)this.parse("1344"), (Object)this.parse("144"));
    }

    @Test
    public void testJsonValueHashCode() {
        Assert.assertEquals((long)new ObjectMapper().readTree(this.json()).hashCode(), (long)this.parse(this.json()).hashCode());
    }

    @Test
    public void testJsonValueToString() {
        String js = "{\"boolean\":false,\"int\":1234,\"array\":[4.0,11.1,44.5],\"object\":{\"a\":true,\"b\":false}}";
        Assert.assertEquals((Object)js, (Object)this.parse(js).toString());
    }

    @Test
    public void testDecodeBoolean() {
        DecodeJson.DecodeBoolean$ assertTo_evidence$1 = DecodeJson.DecodeBoolean$.MODULE$;
        Boolean assertTo_expected = false;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("boolean");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeBoolean$ assertToFails_evidence$2 = DecodeJson.DecodeBoolean$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var6_6 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeString() {
        void assertTo_evidence$1;
        DecodeJson.DecodeString$ assertTo_evidence$12 = DecodeJson.DecodeString$.MODULE$;
        String assertTo_expected = "string";
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("string");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeString$ decodeString$ = DecodeJson.DecodeString$.MODULE$;
        String assertTo_expected2 = "123";
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("number_as_string");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_5 = null;
        decodeString$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeString$ assertToFails_evidence$2 = DecodeJson.DecodeString$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var9_9 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
        Object var7_7 = null;
        Object var8_8 = null;
        DecodeJson.DecodeString$ assertToFails_evidence$22 = DecodeJson.DecodeString$.MODULE$;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("array");
        Assert.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz2 = JsonMappingException.class;
        Object var12_12 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz2, (List)Nil$.MODULE$));
    }

    @Test
    public void testDecodeInt() {
        DecodeJson.DecodeInt$ assertTo_evidence$1 = DecodeJson.DecodeInt$.MODULE$;
        Integer assertTo_expected = 1234;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("int");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeInt$ assertToFails_evidence$2 = DecodeJson.DecodeInt$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("long");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var6_6 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeLong() {
        void assertTo_evidence$1;
        DecodeJson.DecodeLong$ assertTo_evidence$12 = DecodeJson.DecodeLong$.MODULE$;
        Long assertTo_expected = 3000000000L;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("long");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeLong$ decodeLong$ = DecodeJson.DecodeLong$.MODULE$;
        Long assertTo_expected2 = 1234L;
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_5 = null;
        decodeLong$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeLong$ assertToFails_evidence$2 = DecodeJson.DecodeLong$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var9_9 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeDouble() {
        void assertTo_evidence$1;
        void assertTo_evidence$12;
        DecodeJson.DecodeDouble$ assertTo_evidence$13 = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected = 16.244355;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("double");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$13));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$13));
        Object var1_2 = null;
        Object var2_1 = null;
        Object var3_3 = null;
        DecodeJson.DecodeDouble$ decodeDouble$ = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected2 = 1234.0;
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$12));
        Assert.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$12));
        Object var4_5 = null;
        decodeDouble$ = null;
        Object var6_6 = null;
        DecodeJson.DecodeDouble$ decodeDouble$2 = DecodeJson.DecodeDouble$.MODULE$;
        Double assertTo_expected3 = 3.0E9;
        JsonValue assertTo_parsed3 = this.parse(this.json()).asJsonObject().apply("long");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected3), (Object)assertTo_parsed3.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected3, (Object)assertTo_parsed3.to((DecodeJson)assertTo_evidence$1));
        Object var7_8 = null;
        decodeDouble$2 = null;
        Object var9_9 = null;
        DecodeJson.DecodeDouble$ assertToFails_evidence$2 = DecodeJson.DecodeDouble$.MODULE$;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var12_12 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeSeq() {
        void decodeSeq_factory;
        void decodeSeq_factory2;
        void decodeSeq_factory3;
        void assertTo_evidence$1;
        void decodeSeq_factory4;
        Seq$ iterableFactory_this = Seq$.MODULE$;
        Object var1_1 = null;
        Factory factory = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this);
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson = DecodeJson.DecodeDouble$.MODULE$;
        Object var17_3 = null;
        factory = null;
        DecodeJson$.anonfun.decodeSeq.3 var6_4 = new /* Unavailable Anonymous Inner Class!! */;
        SeqOps assertTo_expected = Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{4.0, 11.1, 44.5}));
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("array");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var5_5 = null;
        var6_4 = null;
        Object var7_6 = null;
        Seq$ iterableFactory_this2 = Seq$.MODULE$;
        Object var2_7 = null;
        Factory factory2 = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this2);
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson2 = DecodeJson.DecodeDouble$.MODULE$;
        Object var19_9 = null;
        factory2 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("string");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var10_12 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
        Object var8_10 = null;
        Object var9_11 = null;
        Seq$ iterableFactory_this3 = Seq$.MODULE$;
        Object var3_13 = null;
        Factory factory3 = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this3);
        DecodeJson.DecodeDouble$ decodeSeq_decodeJson3 = DecodeJson.DecodeDouble$.MODULE$;
        Object var21_15 = null;
        factory3 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$22 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("object");
        Assert.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz2 = JsonMappingException.class;
        Object var13_18 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz2, (List)Nil$.MODULE$));
        Object var11_16 = null;
        Object var12_17 = null;
        Seq$ iterableFactory_this4 = Seq$.MODULE$;
        Object var4_19 = null;
        Factory factory4 = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this4);
        DecodeJson.DecodeString$ decodeSeq_decodeJson4 = DecodeJson.DecodeString$.MODULE$;
        Object var23_21 = null;
        factory4 = null;
        DecodeJson$.anonfun.decodeSeq.3 assertToFails_evidence$23 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed3 = this.parse(this.json()).asJsonObject().apply("array");
        Assert.assertTrue((boolean)assertToFails_parsed3.toEither((DecodeJson)assertToFails_evidence$23).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz3 = JsonMappingException.class;
        Object var16_24 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed3, (DecodeJson)assertToFails_evidence$23)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz3, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeMap() {
        void decodeMap_factory;
        void decodeMap_factory2;
        void decodeMap_factory3;
        void assertTo_evidence$1;
        void apply_elems;
        void decodeMap_factory4;
        void $minus$greater$extension_y;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        Boolean $minus$greater$extension_y2 = true;
        String $minus$greater$extension_$this = "a";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Boolean bl = false;
        String $minus$greater$extension_$this2 = "b";
        Object var3_4 = null;
        bl = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Map$ mapFactory_this = Map$.MODULE$;
        Object var6_6 = null;
        Factory factory = MapFactory.mapFactory$((MapFactory)mapFactory_this);
        DecodeJson.DecodeBoolean$ decodeMap_decodeJson = DecodeJson.DecodeBoolean$.MODULE$;
        Object var22_8 = null;
        factory = null;
        DecodeJson$.anonfun.decodeMap.4 var11_9 = new /* Unavailable Anonymous Inner Class!! */;
        Object assertTo_expected = MapFactory.apply$((MapFactory)map$, (Seq)apply_elems);
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("object");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right(assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$1));
        Object var10_10 = null;
        var11_9 = null;
        Object var12_11 = null;
        Map$ mapFactory_this2 = Map$.MODULE$;
        Object var7_12 = null;
        Factory factory2 = MapFactory.mapFactory$((MapFactory)mapFactory_this2);
        DecodeJson.DecodeInt$ decodeMap_decodeJson2 = DecodeJson.DecodeInt$.MODULE$;
        Object var24_14 = null;
        factory2 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("object");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var15_17 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
        Object var13_15 = null;
        Object var14_16 = null;
        Map$ mapFactory_this3 = Map$.MODULE$;
        Object var8_18 = null;
        Factory factory3 = MapFactory.mapFactory$((MapFactory)mapFactory_this3);
        DecodeJson.DecodeString$ decodeMap_decodeJson3 = DecodeJson.DecodeString$.MODULE$;
        Object var26_20 = null;
        factory3 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$22 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed2 = this.parse(this.json()).asJsonObject().apply("object");
        Assert.assertTrue((boolean)assertToFails_parsed2.toEither((DecodeJson)assertToFails_evidence$22).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz2 = JsonMappingException.class;
        Object var18_23 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed2, (DecodeJson)assertToFails_evidence$22)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz2, (List)Nil$.MODULE$));
        Object var16_21 = null;
        Object var17_22 = null;
        Map$ mapFactory_this4 = Map$.MODULE$;
        Object var9_24 = null;
        Factory factory4 = MapFactory.mapFactory$((MapFactory)mapFactory_this4);
        DecodeJson.DecodeDouble$ decodeMap_decodeJson4 = DecodeJson.DecodeDouble$.MODULE$;
        Object var28_26 = null;
        factory4 = null;
        DecodeJson$.anonfun.decodeMap.4 assertToFails_evidence$23 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed3 = this.parse(this.json()).asJsonObject().apply("array");
        Assert.assertTrue((boolean)assertToFails_parsed3.toEither((DecodeJson)assertToFails_evidence$23).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz3 = JsonMappingException.class;
        Object var21_29 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed3, (DecodeJson)assertToFails_evidence$23)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz3, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDecodeOption() {
        void assertTo_evidence$1;
        DecodeJson.DecodeInt$ decodeOption_decodeJson = DecodeJson.DecodeInt$.MODULE$;
        Object var10_1 = null;
        DecodeJson$.anonfun.decodeOption.3 assertTo_evidence$12 = new /* Unavailable Anonymous Inner Class!! */;
        None$ assertTo_expected = None$.MODULE$;
        JsonValue assertTo_parsed = this.parse(this.json()).asJsonObject().apply("null");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected), (Object)assertTo_parsed.toEither((DecodeJson)assertTo_evidence$12));
        Assert.assertEquals((Object)assertTo_expected, (Object)assertTo_parsed.to((DecodeJson)assertTo_evidence$12));
        Object var1_3 = null;
        Object var2_2 = null;
        Object var3_4 = null;
        DecodeJson.DecodeInt$ decodeOption_decodeJson2 = DecodeJson.DecodeInt$.MODULE$;
        Object var11_5 = null;
        DecodeJson$.anonfun.decodeOption.3 var5_6 = new /* Unavailable Anonymous Inner Class!! */;
        Some assertTo_expected2 = new Some((Object)1234);
        JsonValue assertTo_parsed2 = this.parse(this.json()).asJsonObject().apply("int");
        if (package$.MODULE$.Right() == null) {
            throw null;
        }
        Assert.assertEquals((Object)new Right((Object)assertTo_expected2), (Object)assertTo_parsed2.toEither((DecodeJson)assertTo_evidence$1));
        Assert.assertEquals((Object)assertTo_expected2, (Object)assertTo_parsed2.to((DecodeJson)assertTo_evidence$1));
        Object var4_7 = null;
        var5_6 = null;
        Object var6_8 = null;
        DecodeJson.DecodeString$ decodeOption_decodeJson3 = DecodeJson.DecodeString$.MODULE$;
        Object var12_9 = null;
        DecodeJson$.anonfun.decodeOption.3 assertToFails_evidence$2 = new /* Unavailable Anonymous Inner Class!! */;
        JsonValue assertToFails_parsed = this.parse(this.json()).asJsonObject().apply("int");
        Assert.assertTrue((boolean)assertToFails_parsed.toEither((DecodeJson)assertToFails_evidence$2).isLeft());
        Class<JsonMappingException> assertToFails_classType_clazz = JsonMappingException.class;
        Object var9_12 = null;
        this.assertThrow((Function0<BoxedUnit>)((JFunction0.mcV.sp & Serializable)() -> JsonValueTest.$anonfun$assertToFails$1(assertToFails_parsed, (DecodeJson)assertToFails_evidence$2)), (Manifest)new ManifestFactory.ClassTypeManifest((Option)None$.MODULE$, assertToFails_classType_clazz, (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ Nothing$ $anonfun$parse$1(String s$1) {
        String error_message = new StringBuilder(22).append("Failed to parse json: ").append(s$1).toString();
        throw new RuntimeException(error_message);
    }

    public static final /* synthetic */ void $anonfun$assertThrow$1(Class klass$1, BoxedUnit x$1) {
        Assert.fail((String)new StringBuilder(53).append("Expected `").append(klass$1).append("` to be thrown, but no exception was thrown").toString());
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeBoolean$1(JsonObject x$2) {
        return x$2.apply("boolean");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeBoolean$2(JsonObject x$3) {
        return x$3.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$1(JsonObject x$4) {
        return x$4.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$2(JsonObject x$5) {
        return x$5.apply("number_as_string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$3(JsonObject x$6) {
        return x$6.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeString$4(JsonObject x$7) {
        return x$7.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeInt$1(JsonObject x$8) {
        return x$8.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeInt$2(JsonObject x$9) {
        return x$9.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$1(JsonObject x$10) {
        return x$10.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$2(JsonObject x$11) {
        return x$11.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeLong$3(JsonObject x$12) {
        return x$12.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$1(JsonObject x$13) {
        return x$13.apply("double");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$2(JsonObject x$14) {
        return x$14.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$3(JsonObject x$15) {
        return x$15.apply("long");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeDouble$4(JsonObject x$16) {
        return x$16.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$1(JsonObject x$17) {
        return x$17.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$2(JsonObject x$18) {
        return x$18.apply("string");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$3(JsonObject x$19) {
        return x$19.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeSeq$4(JsonObject x$20) {
        return x$20.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$1(JsonObject x$21) {
        return x$21.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$2(JsonObject x$22) {
        return x$22.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$3(JsonObject x$23) {
        return x$23.apply("object");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeMap$4(JsonObject x$24) {
        return x$24.apply("array");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$1(JsonObject x$25) {
        return x$25.apply("null");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$2(JsonObject x$26) {
        return x$26.apply("int");
    }

    public static final /* synthetic */ JsonValue $anonfun$testDecodeOption$3(JsonObject x$27) {
        return x$27.apply("int");
    }

    public static final /* synthetic */ Object $anonfun$assertThrow$1$adapted(Class klass$1, BoxedUnit x$1) {
        JsonValueTest.$anonfun$assertThrow$1(klass$1, x$1);
        return BoxedUnit.UNIT;
    }
}

