/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Properties;
import kafka.common.MessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.tools.ConsoleConsumer$;
import kafka.tools.DefaultMessageFormatter;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.MockDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0006\f\u00017!)!\u0005\u0001C\u0001G!)a\u0005\u0001C\u0001O!)A\u0007\u0001C\u0001O!)\u0011\b\u0001C\u0001O!)1\b\u0001C\u0001O!)Q\b\u0001C\u0001O!)q\b\u0001C\u0001O!)\u0011\t\u0001C\u0001O!)\u0011\u000b\u0001C\u0001O!)1\u000b\u0001C\u0001O!)Q\u000b\u0001C\u0001O!)q\u000b\u0001C\u0001O!)\u0011\f\u0001C\u0001O!)1\f\u0001C\u0001O!)Q\f\u0001C\u0001O!)q\f\u0001C\u0001O!)\u0011\r\u0001C\u0001O!)1\r\u0001C\u0001O!)Q\r\u0001C\u0001O!)q\r\u0001C\u0001O\t\u00192i\u001c8t_2,7i\u001c8tk6,'\u000fV3ti*\u0011q\u0003G\u0001\u0006i>|Gn\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011AF\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002QA\u0011Q$K\u0005\u0003Uy\u0011A!\u00168ji\"\u0012!\u0001\f\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQA[;oSRT\u0011!M\u0001\u0004_J<\u0017BA\u001a/\u0005\u0019\u0011UMZ8sK\u000613\u000f[8vY\u0012\u0014Vm]3u+:\u001cuN\\:v[\u0016$wJ\u001a4tKR\u001c()\u001a4pe\u0016,\u00050\u001b;)\u0005\r1\u0004CA\u00178\u0013\tAdF\u0001\u0003UKN$\u0018!I:i_VdG\rT5nSR\u0014V-\u00193t)>l\u0015\r_'fgN\fw-\u001a'j[&$\bF\u0001\u00037\u0003\r\u001a\bn\\;mIN#x\u000e],iK:|U\u000f\u001e9vi\u000eCWmY6FeJ|'OR1jYND#!\u0002\u001c\u0002GMDw.\u001e7e!\u0006\u00148/\u001a,bY&$7i\u001c8tk6,'OV1mS\u0012\u001cuN\u001c4jO\"\u0012aAN\u0001;g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRDg*^7fe&\u001cwJ\u001a4tKRD#a\u0002\u001c\u0002SMDw.\u001e7e\u000bbLGo\u00148V]J,7m\\4oSj,GMT3x\u0007>t7/^7fe>\u0003H/[8oQ\u0011Aag\u0011#\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u0012\t\u0003\r:s!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)S\u0012A\u0002\u001fs_>$h(C\u0001 \u0013\tie$A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&\u0001G%mY\u0016<\u0017\r\\!sOVlWM\u001c;Fq\u000e,\u0007\u000f^5p]*\u0011QJH\u0001:g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001c\u0016.\u001c9mK\u000e{gn];nKJ4\u0016\r\\5e\u0007>tg-[4XSRD7\u000b\u001e:j]\u001e|eMZ:fi\"\u0012\u0011BN\u00018g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5BkR|wJ\u001a4tKR\u0014Vm]3u\u0019\u0006$Xm\u001d;)\u0005)1\u0014!O:i_VdG\rU1sg\u00164\u0016\r\\5e\u0007>t7/^7fe\u000e{gNZ5h/&$\b.Q;u_>3gm]3u%\u0016\u001cX\r^#be2LWm\u001d;)\u0005-1\u0014!S:i_VdG\rU1sg\u00164\u0016\r\\5e\u0007>t7/^7fe\u000e{gNZ5h/&$\b.Q;u_>3gm]3u%\u0016\u001cX\r^!oI6\u000bGo\u00195j]\u001e4%o\\7CK\u001eLgN\\5oO\"\u0012ABN\u00010g\"|W\u000f\u001c3QCJ\u001cXMV1mS\u0012\u001cuN\\:v[\u0016\u00148i\u001c8gS\u001e<\u0016\u000e\u001e5O_>3gm]3u%\u0016\u001cX\r\u001e\u0015\u0003\u001bY\nqi\u001d5pk2$W\t_5u\u001f:LeN^1mS\u0012\u001cuN\u001c4jO^KG\u000f[!vi>|eMZ:fiJ+7/\u001a;B]\u0012\u001cuN\u001c4mS\u000e$\u0018N\\4Ge>l')Z4j]:Lgn\u001a\u0015\u0005\u001dY\u001aE)\u0001\u000etQ>,H\u000e\u001a)beN,7i\u001c8gS\u001e\u001chI]8n\r&dW\r\u000b\u0002\u0010m\u0005QsM]8va&#7\u000f\u0015:pm&$W\rZ%o\t&4g-\u001a:f]R\u0004F.Y2fg6+8\u000f^'bi\u000eD\u0007F\u0001\t7\u0003E\"Xm\u001d;DkN$x.\u001c)s_B,'\u000f^=TQ>,H\u000e\u001a\"f!\u0006\u001c8/\u001a3U_\u000e{gNZ5hkJ,W*\u001a;i_\u0012D#!\u0005\u001c\u0002YMDw.\u001e7e!\u0006\u00148/Z$s_V\u0004\u0018\n\u001a$s_6\u0014UmZ5o]&twmR5wK:$vnZ3uQ\u0016\u0014\bF\u0001\n7\u00031\u001a\bn\\;mI\u0016C\u0018\u000e^(o\u000fJ|W\u000f]%e\u0003:$\u0007+\u0019:uSRLwN\\$jm\u0016tGk\\4fi\",'\u000f\u000b\u0003\u0014m\r#\u0015AI:i_VdG-\u0012=ji>swJ\u001a4tKR<\u0016\u000e\u001e5pkR\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0003\u0015m\r#\u0005")
public class ConsoleConsumerTest {
    @Before
    public void setup() {
        ConsoleConsumer$.MODULE$.messageCount_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldResetUnConsumedOffsetsBeforeExit() {
        void apply_elems;
        String topic = "test";
        int maxMessages = 123;
        int totalMessages = 700;
        Long startOffset = 0L;
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.EARLIEST);
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        ConsoleConsumer.ConsumerWrapper consumer = new ConsoleConsumer.ConsumerWrapper((Option)new Some((Object)topic), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Consumer)mockConsumer, Long.MAX_VALUE);
        mockConsumer.rebalance((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)tp1, (Object)startOffset);
        objectArray[1] = new Tuple2((Object)tp2, (Object)startOffset);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        mockConsumer.updateBeginningOffsets(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems))).asJava());
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, totalMessages, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                mockConsumer.addRecord(new ConsumerRecord(topic, foreach$mVc$sp_i % 2, (long)(foreach$mVc$sp_i / 2), (Object)"key".getBytes(), (Object)"value".getBytes()));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var12_11 = null;
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsoleConsumer$.MODULE$.process(Integer.valueOf(maxMessages), formatter, consumer, System.out, false);
        Assert.assertEquals((long)totalMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        consumer.resetUnconsumedOffsets();
        Assert.assertEquals((long)maxMessages, (long)(mockConsumer.position(tp1) + mockConsumer.position(tp2)));
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)maxMessages))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
    }

    @Test
    public void shouldLimitReadsToMaxMessageLimit() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()));
        int messageLimit = 10;
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        ConsoleConsumer$.MODULE$.process(Integer.valueOf(messageLimit), formatter, consumer, System.out, true);
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)messageLimit))).receive();
        ((MessageFormatter)Mockito.verify((Object)formatter, (VerificationMode)Mockito.times((int)messageLimit))).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.any());
        consumer.cleanup();
    }

    @Test
    public void shouldStopWhenOutputCheckErrorFails() {
        ConsoleConsumer.ConsumerWrapper consumer = (ConsoleConsumer.ConsumerWrapper)Mockito.mock(ConsoleConsumer.ConsumerWrapper.class);
        MessageFormatter formatter = (MessageFormatter)Mockito.mock(MessageFormatter.class);
        PrintStream printStream = (PrintStream)Mockito.mock(PrintStream.class);
        ConsumerRecord record = new ConsumerRecord("foo", 1, 1L, Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()), Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Byte()));
        Mockito.when((Object)consumer.receive()).thenReturn((Object)record);
        Mockito.when((Object)printStream.checkError()).thenReturn((Object)true);
        ConsoleConsumer$.MODULE$.process(Integer.valueOf(-1), formatter, consumer, printStream, true);
        ((MessageFormatter)Mockito.verify((Object)formatter)).writeTo((ConsumerRecord)ArgumentMatchers.any(), (PrintStream)ArgumentMatchers.eq((Object)printStream));
        ((ConsoleConsumer.ConsumerWrapper)Mockito.verify((Object)consumer)).receive();
        ((PrintStream)Mockito.verify((Object)printStream)).checkError();
        consumer.cleanup();
    }

    @Test
    public void shouldParseValidConsumerValidConfig() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)true, (Object)config.fromBeginning());
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)3L, (long)config.offsetArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)config.partitionArg().get()));
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
        Assert.assertEquals((Object)false, (Object)((DefaultMessageFormatter)config.formatter()).printValue());
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)true, (Object)config.fromBeginning());
        Assert.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties consumerProperties = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
        Assert.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$2, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(BoxesRunTime.unboxToInt((Object)x$2), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"};
        try {
            ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
            ConsoleConsumer$.MODULE$.consumerProps(config);
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() {
        File propsFile = TestUtils.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("request.timeout.ms=1000\n".getBytes());
        propsStream.write("group.id=group1".getBytes());
        propsStream.close();
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"1000", (Object)config.consumerProps().getProperty("request.timeout.ms"));
        Assert.assertEquals((Object)"group1", (Object)config.consumerProps().getProperty("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$3, message) -> ConsoleConsumerTest.$anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(BoxesRunTime.unboxToInt((Object)x$3), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var6_1 = null;
        File propsFile = TestUtils.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        propsFile = TestUtils.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=test-group".getBytes());
        propsStream.close();
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Properties props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = TestUtils.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        propsFile = TestUtils.tempFile();
        propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("group.id=group-from-file".getBytes());
        propsStream.close();
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
            Assert.fail((String)"Expected groups ids provided in different places to match");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"};
        config = new ConsoleConsumer.ConsumerConfig(args);
        props = ConsoleConsumer$.MODULE$.consumerProps(config);
        Assert.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertTrue((boolean)(config.formatter() instanceof DefaultMessageFormatter));
        Assert.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assert.assertTrue((boolean)(formatter.keyDeserializer().get() instanceof MockDeserializer));
        Assert.assertEquals((long)1L, (long)((MockDeserializer)formatter.keyDeserializer().get()).configs.size());
        Assert.assertEquals((Object)"abc", ((MockDeserializer)formatter.keyDeserializer().get()).configs.get("my-props"));
        Assert.assertTrue((boolean)((MockDeserializer)formatter.keyDeserializer().get()).isKey);
    }

    @Test
    public void shouldParseGroupIdFromBeginningGivenTogether() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--from-beginning"};
        ConsoleConsumer.ConsumerConfig config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)-2L, (long)config.offsetArg());
        Assert.assertEquals((Object)true, (Object)config.fromBeginning());
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group"};
        config = new ConsoleConsumer.ConsumerConfig(args);
        Assert.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assert.assertEquals((Object)"test", (Object)config.topicArg());
        Assert.assertEquals((long)-1L, (long)config.offsetArg());
        Assert.assertEquals((Object)false, (Object)config.fromBeginning());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnGroupIdAndPartitionGivenTogether() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$4, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(BoxesRunTime.unboxToInt((Object)x$4), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--partition", "0"};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldExitOnOffsetWithoutPartition() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$5, message) -> ConsoleConsumerTest.$anonfun$shouldExitOnOffsetWithoutPartition$1(BoxesRunTime.unboxToInt((Object)x$5), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var3_1 = null;
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--offset", "10"};
        try {
            new ConsoleConsumer.ConsumerConfig(args);
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnUnrecognizedNewConsumerOption$1(int x$1, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        eq2 = null;
        throw new IllegalArgumentException((String)(message.isEmpty() ? orNull_ev.apply(null) : message.get()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning$1(int x$2, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        eq2 = null;
        throw new IllegalArgumentException((String)(message.isEmpty() ? orNull_ev.apply(null) : message.get()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$groupIdsProvidedInDifferentPlacesMustMatch$1(int x$3, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        eq2 = null;
        throw new IllegalArgumentException((String)(message.isEmpty() ? orNull_ev.apply(null) : message.get()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnGroupIdAndPartitionGivenTogether$1(int x$4, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        eq2 = null;
        throw new IllegalArgumentException((String)(message.isEmpty() ? orNull_ev.apply(null) : message.get()));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$shouldExitOnOffsetWithoutPartition$1(int x$5, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        eq2 = null;
        throw new IllegalArgumentException((String)(message.isEmpty() ? orNull_ev.apply(null) : message.get()));
    }
}

