/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\u001a5\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004M\u0001\u0001\u0006IA\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001F\u0011\u0019q\u0005\u0001)A\u0005\r\"9q\n\u0001b\u0001\n\u0003)\u0005B\u0002)\u0001A\u0003%a\tC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rm\u0003\u0001\u0015!\u0003T\u0011\u001da\u0006A1A\u0005\n\u0015Ca!\u0018\u0001!\u0002\u00131\u0005b\u00020\u0001\u0005\u0004%\t%\u0012\u0005\u0007?\u0002\u0001\u000b\u0011\u0002$\t\u000b\u0001\u0004A\u0011I1\t\u000b9\u0004A\u0011A1\t\u000bM\u0004A\u0011A1\t\u000bU\u0004A\u0011A1\t\u000b]\u0004A\u0011A1\t\u000be\u0004A\u0011A1\t\u000bm\u0004A\u0011A1\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAg\u0001\u0011%\u0011qZ\u0004\b\u0003+!\u0004\u0012AA\f\r\u0019\u0019D\u0007#\u0001\u0002\u001a!1\u0001I\u0007C\u0001\u0003C1\u0011\"a\t\u001b!\u0003\r\n#!\n\b\u000f\u0005u%\u0004#!\u0002\u0014\u001a9\u0011Q\u0012\u000e\t\u0002\u0006=\u0005B\u0002!\u001f\t\u0003\t\t\n\u0003\u0005\u0002Ny\t\t\u0011\"\u0011S\u0011!\tyEHA\u0001\n\u0003)\u0005\"CA)=\u0005\u0005I\u0011AAK\u0011%\tyFHA\u0001\n\u0003\n\t\u0007C\u0005\u0002py\t\t\u0011\"\u0001\u0002\u001a\"I\u00111\u0010\u0010\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u007fr\u0012\u0011!C!\u0003\u0003C\u0011\"a!\u001f\u0003\u0003%I!!\"\b\u000f\u0005}%\u0004#!\u0002L\u00199\u0011\u0011\u0006\u000e\t\u0002\u0006-\u0002B\u0002!*\t\u0003\tI\u0005\u0003\u0005\u0002N%\n\t\u0011\"\u0011S\u0011!\ty%KA\u0001\n\u0003)\u0005\"CA)S\u0005\u0005I\u0011AA*\u0011%\ty&KA\u0001\n\u0003\n\t\u0007C\u0005\u0002p%\n\t\u0011\"\u0001\u0002r!I\u00111P\u0015\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u007fJ\u0013\u0011!C!\u0003\u0003C\u0011\"a!*\u0003\u0003%I!!\"\u0003#1{w\rR5s\r\u0006LG.\u001e:f)\u0016\u001cHO\u0003\u00026m\u000511/\u001a:wKJT\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\b\u0005\u0002<}5\tAH\u0003\u0002>m\u0005\u0019\u0011\r]5\n\u0005}b$AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\u0011\u0005CA\"\u0001\u001b\u0005!\u0014!\u00049s_\u0012,8-\u001a:D_VtG/F\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\u000faJ|G-^2fe\u000e{WO\u001c;!\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\u0006q1m\u001c8tk6,'oQ8v]R\u0004\u0013a\u00032s_.,'oQ8v]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQ\u0001^8qS\u000e,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0002]1si&$\u0018n\u001c8Ok6\fQ\u0002]1si&$\u0018n\u001c8Ok6\u0004\u0013a\u00037pO\u0012K'oQ8v]R\fA\u0002\\8h\t&\u00148i\\;oi\u0002\nQa]3u+B$\u0012A\u0019\t\u0003\u000f\u000eL!\u0001\u001a%\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d\u0019\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000b),h.\u001b;\u000b\u0003-\f1a\u001c:h\u0013\ti\u0007N\u0001\u0004CK\u001a|'/Z\u0001%i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u0012:s_J4%o\\7GC&dWO]3P]2{wMU8mY\"\u0012q\u0002\u001d\t\u0003OFL!A\u001d5\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\t\u0001\u0002/A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\t\u0002/A\u0014uKN$\bK]8ek\u000e,WI\u001d:pe\u001a\u0013x.\u001c$bS2,(/Z(o\u0007\",7m\u001b9pS:$\bF\u0001\nq\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0003'A\fA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\t!\u0002/\u0001\u0016uKN$\bK]8ek\u000e,WI\u001d:peN4%o\\7M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005\t|\bbBA\u0001+\u0001\u0007\u00111A\u0001\fM\u0006LG.\u001e:f)f\u0004X\rE\u0002\u0002\u0006qq1!a\u0002\u001a\u001d\u0011\tI!a\u0005\u000f\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u00049\u0003\u0019a$o\\8u}%\tq'\u0003\u00026m\u0005\tBj\\4ESJ4\u0015-\u001b7ve\u0016$Vm\u001d;\u0011\u0005\rS2c\u0001\u000e\u0002\u001cA\u0019q)!\b\n\u0007\u0005}\u0001J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003/\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+\u001f9f'\ra\u00121D\u0015\u00049%r\"AC\"iK\u000e\\\u0007o\\5oiNI\u0011&a\u0007\u0002.\u0005E\u0012q\u0007\t\u0004\u0003_aR\"\u0001\u000e\u0011\u0007\u001d\u000b\u0019$C\u0002\u00026!\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002:\u0005\rc\u0002BA\u001e\u0003\u007fqA!a\u0003\u0002>%\t\u0011*C\u0002\u0002B!\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002F\u0005\u001d#\u0001D*fe&\fG.\u001b>bE2,'bAA!\u0011R\u0011\u00111\n\t\u0004\u0003_I\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004\u000f\u0006]\u0013bAA-\u0011\n\u0019\u0011I\\=\t\u0011\u0005uS&!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA2!\u0019\t)'a\u001b\u0002V5\u0011\u0011q\r\u0006\u0004\u0003SB\u0015AC2pY2,7\r^5p]&!\u0011QNA4\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0014\u0011\u0010\t\u0004\u000f\u0006U\u0014bAA<\u0011\n9!i\\8mK\u0006t\u0007\"CA/_\u0005\u0005\t\u0019AA+\u0003!A\u0017m\u001d5D_\u0012,G#\u0001$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012aU\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003\u000f\u00032\u0001VAE\u0013\r\tY)\u0016\u0002\u0007\u001f\nTWm\u0019;\u0003\tI{G\u000e\\\n\n=\u0005m\u0011QFA\u0019\u0003o!\"!a%\u0011\u0007\u0005=b\u0004\u0006\u0003\u0002V\u0005]\u0005\u0002CA/E\u0005\u0005\t\u0019\u0001$\u0015\t\u0005M\u00141\u0014\u0005\n\u0003;\"\u0013\u0011!a\u0001\u0003+\nAAU8mY\u0006Q1\t[3dWB|\u0017N\u001c;\u0002KQ,7\u000f\u001e)s_\u0012,8-Z!gi\u0016\u0014Hj\\4ESJ4\u0015-\u001b7ve\u0016|e\u000eT3bI\u0016\u0014Hc\u00012\u0002&\"9\u0011\u0011\u0001\fA\u0002\u0005\r\u0011AE2bkN,Gj\\4ESJ4\u0015-\u001b7ve\u0016$rAYAV\u0003[\u000b9\fC\u0004\u0002\u0002]\u0001\r!a\u0001\t\u000f\u0005=v\u00031\u0001\u00022\u0006aA.Z1eKJ\u001cVM\u001d<feB\u00191)a-\n\u0007\u0005UFGA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bbBA]/\u0001\u0007\u00111X\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!!0\u0002J6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0004d_6lwN\u001c\u0006\u0004o\u0005\u0015'bAAdU\u00061\u0011\r]1dQ\u0016LA!a3\u0002@\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\u000b\t\f\t.!9\t\rEC\u0002\u0019AAj!\u0011\t).!8\u000f\t\u0005]\u0017\u0011\u001c\t\u0004\u0003\u0017A\u0015bAAn\u0011\u00061\u0001K]3eK\u001aL1AWAp\u0015\r\tY\u000e\u0013\u0005\b\u0003GD\u0002\u0019AAs\u0003!\u0019wN\\:v[\u0016\u0014\b\u0003CAt\u0003_\f\u00190a=\u000e\u0005\u0005%(\u0002BAr\u0003WTA!!<\u0002D\u000691\r\\5f]R\u001c\u0018\u0002BAy\u0003S\u0014QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#B$\u0002v\u0006e\u0018bAA|\u0011\n)\u0011I\u001d:bsB\u0019q)a?\n\u0007\u0005u\bJ\u0001\u0003CsR,\u0007")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testProduceErrorFromFailureOnLogRoll() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        None$ create_e = None$.MODULE$;
        Object var33_1 = null;
        VolatileObjectRef statusCodeOption = new VolatileObjectRef((Object)create_e);
        Function2 & Serializable setHaltProcedure_haltProcedure = (Function2 & Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1);
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var26_3 = null;
        KafkaServer server = null;
        try {
            void createServer_time;
            int x$12 = this.brokerCount();
            String x$2 = this.zkConnect();
            boolean x$4 = true;
            boolean x$5 = true;
            TestUtils$ createBrokerConfig$default$5_this = TestUtils$.MODULE$;
            Object var34_9 = null;
            int x$6 = createBrokerConfig$default$5_this.RandomPort();
            None$ x$7 = None$.MODULE$;
            None$ x$8 = None$.MODULE$;
            None$ x$9 = None$.MODULE$;
            boolean x$10 = true;
            boolean x$11 = false;
            TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
            Object var35_16 = null;
            int x$122 = createBrokerConfig$default$11_this.RandomPort();
            boolean x$13 = false;
            TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
            Object var36_19 = null;
            int x$14 = createBrokerConfig$default$13_this.RandomPort();
            boolean x$15 = false;
            TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
            Object var37_22 = null;
            int x$16 = createBrokerConfig$default$15_this.RandomPort();
            None$ x$17 = None$.MODULE$;
            boolean x$18 = false;
            int x$19 = 1;
            short x$20 = 1;
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$6, (Option<SecurityProtocol>)x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, (Option<String>)x$17, 3, x$18, x$19, x$20);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            Time time = Time.SYSTEM;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            Object var38_32 = null;
            time = null;
            server = createServer_this.createServer(kafkaConfig, (Time)createServer_time, (Option<String>)None$.MODULE$);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!((Option)statusCodeOption.elem).contains((Object)1)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail("timed out waiting for broker to halt", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        catch (Throwable throwable) {
            Exit.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
            }
            throw throwable;
        }
        Exit.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testProduceErrorFromFailureOnCheckpoint() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        int n;
        int[] find$extension_$this;
        KafkaServer leaderServer;
        TopicPartition partition;
        KafkaProducer producer;
        block3: {
            this.producerConfig().setProperty("retries", "0");
            producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            partition = new TopicPartition(this.topic(), 0);
            PartitionInfo partitionInfo = (PartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
            int leaderServerId = partitionInfo.leader().id();
            leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
            Node[] map$extension_$this = partitionInfo.replicas();
            int map$extension_len = map$extension_$this.length;
            int[] map$extension_ys = new int[map$extension_len];
            if (map$extension_len > 0) {
                for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                    int n2;
                    map$extension_ys[map$extension_i] = n2 = map$extension_$this[map$extension_i].id();
                }
            }
            Object var12_6 = null;
            Object var14_8 = null;
            int[] intArrayOps_xs = map$extension_ys;
            Object var10_11 = null;
            find$extension_$this = intArrayOps_xs;
            for (int find$extension_indexWhere$extension_i = 0; find$extension_indexWhere$extension_i < find$extension_$this.length; ++find$extension_indexWhere$extension_i) {
                int n3 = find$extension_$this[find$extension_indexWhere$extension_i];
                if (!LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$4(leaderServerId, n3)) continue;
                n = find$extension_indexWhere$extension_i;
                break block3;
            }
            n = -1;
        }
        int find$extension_idx = n;
        Object var16_12 = null;
        int followerServerId = BoxesRunTime.unboxToInt((Object)(find$extension_idx == -1 ? None$.MODULE$ : new Some((Object)find$extension_$this[find$extension_idx])).get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int n4 = 1;
        int until$extension_end = this.partitionNum();
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)new Range.Exclusive(n4, until$extension_end, 1).find((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            Option option = leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), i));
            if (option == null) {
                throw null;
            }
            Option flatMap_this = option;
            Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((Partition)flatMap_this.get()).leaderLogIfLocal();
            Object var3_3 = null;
            return object.isDefined();
        }).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Integer.valueOf(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Integer.valueOf(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        this.causeLogDirFailure(failureType, leaderServer, partition);
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderOrFollowerException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof KafkaStorageException) {
                return;
            }
            if (throwable instanceof NotLeaderOrFollowerException) {
                return;
            }
            if (throwable != null) {
                throw Assertions$.MODULE$.fail(new StringBuilder(96).append("send() should fail with either KafkaStorageException or NotLeaderOrFollowerException instead of ").append(throwable.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            throw new MatchError(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Integer.valueOf(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$10))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$11))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, 15000L);
        this.causeLogDirFailure(failureType, leaderServer, partition);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 6000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, leaderServerId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Expected new leader for the partition", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, 15000L);
        Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        Assert.assertTrue((boolean)((KafkaServer)this.servers().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(x$13))).get()).kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$).contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
    }

    /*
     * WARNING - void declaration
     */
    private void causeLogDirFailure(LogDirFailureType failureType, KafkaServer leaderServer, TopicPartition partition) {
        File logDir = leaderServer.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable)() -> Utils.delete((File)logDir), (Logging)this, Level.WARN);
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (logDirFailureType != null && logDirFailureType.equals(logDirFailureTest$Roll$)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
                throw Assertions$.MODULE$.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            }
            catch (KafkaStorageException kafkaStorageException) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (logDirFailureType2 != null && logDirFailureType2.equals(logDirFailureTest$Checkpoint$)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 3000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$causeLogDirFailure$2(leaderServer, logDir)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Expected log directory offline", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)leaderServer.replicaManager().localLog(partition).isEmpty());
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long pollUntilTrue_waitTimeMs = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(Duration.ofMillis(100L));
            if (LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Expected non-empty assignment", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(pollUntilTrue_waitTimeMs, pollUntilTrue_waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)statusCode);
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).contains((Object)1);
    }

    public static final /* synthetic */ String $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4() {
        return "timed out waiting for broker to halt";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$4(int leaderServerId$1, int x$5) {
        return x$5 != leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ Option $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$7(Partition x$7) {
        return x$7.leaderLogIfLocal();
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$3, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$12) {
        return x$12.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$1, ProducerRecord record$1, int leaderServerId$3) {
        producer$1.send(record$1);
        return ((PartitionInfo)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)producer$1.partitionsFor($this.topic())).asScala().find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$12))).get()).leader().id() != leaderServerId$3;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(KafkaServer x$13) {
        return x$13.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$2(KafkaServer leaderServer$2, File logDir$2) {
        return !leaderServer$2.logManager().isLogDirOnline(logDir$2.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$3() {
        return "Expected log directory offline";
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(KafkaConsumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static final /* synthetic */ Object $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$3$adapted(Node x$4) {
        return BoxesRunTime.boxToInteger((int)x$4.id());
    }

    public static interface LogDirFailureType {
    }
}

