/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TransactionIndex;
import kafka.log.TxnIndexSearchResult;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatestplus.junit.JUnitSuite;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005}4A\u0001F\u000b\u00015!)Q\u0005\u0001C\u0001M!I\u0011\u0006\u0001a\u0001\u0002\u0004%\tA\u000b\u0005\ng\u0001\u0001\r\u00111A\u0005\u0002QB\u0011\"\u0010\u0001A\u0002\u0003\u0005\u000b\u0015B\u0016\t\u0013y\u0002\u0001\u0019!a\u0001\n\u0003y\u0004\"C\"\u0001\u0001\u0004\u0005\r\u0011\"\u0001E\u0011%1\u0005\u00011A\u0001B\u0003&\u0001\tC\u0004H\u0001\t\u0007I\u0011\u0001%\t\r1\u0003\u0001\u0015!\u0003J\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015)\u0006\u0001\"\u0001O\u0011\u0015Q\u0006\u0001\"\u0001O\u0011\u0015y\u0006\u0001\"\u0001O\u0011\u00151\u0007\u0001\"\u0001O\u0011\u0015)\b\u0001\"\u0001O\u0011\u00159\b\u0001\"\u0001O\u0011\u0015I\b\u0001\"\u0001O\u0011\u0015Y\b\u0001\"\u0001O\u0011\u0015i\b\u0001\"\u0001O\u0005Q!&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007\u0010V3ti*\u0011acF\u0001\u0004Y><'\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039\rj\u0011!\b\u0006\u0003=}\tQA[;oSRT!\u0001I\u0011\u0002\u001bM\u001c\u0017\r\\1uKN$\b\u000f\\;t\u0015\u0005\u0011\u0013aA8sO&\u0011A%\b\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0016\u0003\u00111\u0017\u000e\\3\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0005%|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012AAR5mK\u0006Aa-\u001b7f?\u0012*\u0017\u000f\u0006\u00026wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t!QK\\5u\u0011\u001da4!!AA\u0002-\n1\u0001\u001f\u00132\u0003\u00151\u0017\u000e\\3!\u0003\u0015Ig\u000eZ3y+\u0005\u0001\u0005C\u0001\u0015B\u0013\t\u0011UC\u0001\tUe\u0006t7/Y2uS>t\u0017J\u001c3fq\u0006I\u0011N\u001c3fq~#S-\u001d\u000b\u0003k\u0015Cq\u0001\u0010\u0004\u0002\u0002\u0003\u0007\u0001)\u0001\u0004j]\u0012,\u0007\u0010I\u0001\u0007_\u001a47/\u001a;\u0016\u0003%\u0003\"A\u000e&\n\u0005-;$\u0001\u0002'p]\u001e\fqa\u001c4gg\u0016$\b%A\u0003tKR,\b\u000fF\u00016Q\tQ\u0001\u000b\u0005\u0002R'6\t!K\u0003\u0002\u001fC%\u0011AK\u0015\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d3po:D#aC,\u0011\u0005EC\u0016BA-S\u0005\u0015\te\r^3s\u0003\t\"Xm\u001d;Q_NLG/[8o'\u0016$8i\u001c:sK\u000e$H._,iK:|\u0005/\u001a8fI\"\u0012A\u0002\u0018\t\u0003#vK!A\u0018*\u0003\tQ+7\u000f^\u0001\u0010i\u0016\u001cHoU1oSRL8\t[3dW\"\"Q\u0002X1c\u0003!)\u0007\u0010]3di\u0016$7%A2\u0011\u0005!\"\u0017BA3\u0016\u0005U\u0019uN\u001d:vaRLe\u000eZ3y\u000bb\u001cW\r\u001d;j_:\f!\u0004^3ti2\u000b7\u000f^(gMN,G/T;ti&s7M]3bg\u0016DCA\u0004/bQ\u000e\n\u0011\u000e\u0005\u0002ke:\u00111\u000e\u001d\b\u0003Y>l\u0011!\u001c\u0006\u0003]f\ta\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005E<\u0014a\u00029bG.\fw-Z\u0005\u0003gR\u0014\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\t\tx'\u0001\u000fuKN$H*Y:u\u001f\u001a47/\u001a;DC:tw\u000e\u001e#fGJ,\u0017m]3)\t=a\u0016\r[\u0001\u001fi\u0016\u001cHoQ8mY\u0016\u001cG/\u00112peR,G\r\u0016:b]N\f7\r^5p]ND#\u0001\u0005/\u0002\u0019Q,7\u000f\u001e+sk:\u001c\u0017\r^3)\u0005Ea\u0016a\u0005;fgR\f%m\u001c:uK\u0012$\u0006P\\*fe\u0012,\u0007F\u0001\n]\u0003=!Xm\u001d;SK:\fW.Z%oI\u0016D\bFA\n]\u0001")
public class TransactionIndexTest
extends JUnitSuite {
    private File file;
    private TransactionIndex index;
    private final long offset;

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public TransactionIndex index() {
        return this.index;
    }

    public void index_$eq(TransactionIndex x$1) {
        this.index = x$1;
    }

    public long offset() {
        return this.offset;
    }

    @Before
    public void setup() {
        this.file_$eq(TestUtils.tempFile());
        this.index_$eq(new TransactionIndex(this.offset(), this.file()));
    }

    @After
    public void teardown() {
        this.index().close();
    }

    @Test
    public void testPositionSetCorrectlyWhenOpened() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        .colon.colon foreach_these = abortedTxns;
        while (!foreach_these.isEmpty()) {
            AbortedTxn abortedTxn = (AbortedTxn)foreach_these.head();
            transactionIndex.append(abortedTxn);
            foreach_these = (List)foreach_these.tail();
        }
        Object var5_3 = null;
        this.index().close();
        TransactionIndex reopenedIndex = new TransactionIndex(0L, this.file());
        AbortedTxn anotherAbortedTxn = new AbortedTxn(3L, 50L, 60L, 55L);
        reopenedIndex.append(anotherAbortedTxn);
        .colon.colon $plus$plus_suffix = new .colon.colon((Object)anotherAbortedTxn, (List)Nil$.MODULE$);
        Object var6_7 = null;
        Assert.assertEquals((Object)abortedTxns.appendedAll((IterableOnce)$plus$plus_suffix), (Object)reopenedIndex.allAbortedTxns());
    }

    @Test(expected=CorruptIndexException.class)
    public void testSanityCheck() {
        .colon.colon abortedTxns = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        .colon.colon foreach_these = abortedTxns;
        while (!foreach_these.isEmpty()) {
            AbortedTxn abortedTxn = (AbortedTxn)foreach_these.head();
            transactionIndex.append(abortedTxn);
            foreach_these = (List)foreach_these.tail();
        }
        Object var3_3 = null;
        this.index().close();
        new TransactionIndex(100L, this.file()).sanityCheck();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetMustIncrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 15L, 11L));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLastOffsetCannotDecrease() {
        this.index().append(new AbortedTxn(1L, 5L, 15L, 13L));
        this.index().append(new AbortedTxn(0L, 0L, 10L, 11L));
    }

    @Test
    public void testCollectAbortedTransactions() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 11L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 13L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        .colon.colon foreach_these = abortedTransactions;
        while (!foreach_these.isEmpty()) {
            AbortedTxn abortedTxn = (AbortedTxn)foreach_these.head();
            transactionIndex.append(abortedTxn);
            foreach_these = (List)foreach_these.tail();
        }
        Object var4_3 = null;
        TxnIndexSearchResult result = this.index().collectAbortedTxns(0L, 100L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 32L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(0L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(10L, 35L);
        Assert.assertEquals((Object)abortedTransactions, (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(11L, 35L);
        Assert.assertEquals((Object)abortedTransactions.slice(1, 4), (Object)result.abortedTransactions());
        Assert.assertTrue((boolean)result.isComplete());
        result = this.index().collectAbortedTxns(20L, 41L);
        Assert.assertEquals((Object)abortedTransactions.slice(2, 4), (Object)result.abortedTransactions());
        Assert.assertFalse((boolean)result.isComplete());
    }

    @Test
    public void testTruncate() {
        .colon.colon abortedTransactions = new .colon.colon((Object)new AbortedTxn(0L, 0L, 10L, 2L), (List)new .colon.colon((Object)new AbortedTxn(1L, 5L, 15L, 16L), (List)new .colon.colon((Object)new AbortedTxn(2L, 18L, 35L, 25L), (List)new .colon.colon((Object)new AbortedTxn(3L, 32L, 50L, 40L), (List)Nil$.MODULE$))));
        TransactionIndex transactionIndex = this.index();
        .colon.colon foreach_these = abortedTransactions;
        while (!foreach_these.isEmpty()) {
            AbortedTxn abortedTxn = (AbortedTxn)foreach_these.head();
            transactionIndex.append(abortedTxn);
            foreach_these = (List)foreach_these.tail();
        }
        Object var3_3 = null;
        this.index().truncateTo(51L);
        Assert.assertEquals((Object)abortedTransactions, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().truncateTo(50L);
        Assert.assertEquals((Object)abortedTransactions.take(3), (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
        this.index().reset();
        if (package$.MODULE$.List() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)this.index().collectAbortedTxns(0L, 100L).abortedTransactions());
    }

    @Test
    public void testAbortedTxnSerde() {
        long pid = 983493L;
        long firstOffset = 137L;
        long lastOffset = 299L;
        long lastStableOffset = 200L;
        AbortedTxn abortedTxn = new AbortedTxn(pid, firstOffset, lastOffset, lastStableOffset);
        Assert.assertEquals((long)AbortedTxn$.MODULE$.CurrentVersion(), (long)abortedTxn.version());
        Assert.assertEquals((long)pid, (long)abortedTxn.producerId());
        Assert.assertEquals((long)firstOffset, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)lastOffset, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)lastStableOffset, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRenameIndex() {
        File renamed = TestUtils.tempFile();
        this.index().append(new AbortedTxn(0L, 0L, 10L, 2L));
        this.index().renameTo(renamed);
        this.index().append(new AbortedTxn(1L, 5L, 15L, 16L));
        List abortedTxns = this.index().collectAbortedTxns(0L, 100L).abortedTransactions();
        if (abortedTxns == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)abortedTxns));
        int apply_n = 0;
        Assert.assertEquals((long)0L, (long)((AbortedTxn)LinearSeqOps.apply$((LinearSeqOps)abortedTxns, (int)apply_n)).firstOffset());
        int apply_n2 = 1;
        Assert.assertEquals((long)5L, (long)((AbortedTxn)LinearSeqOps.apply$((LinearSeqOps)abortedTxns, (int)apply_n2)).firstOffset());
    }

    public TransactionIndexTest() {
        this.offset = 0L;
    }

    public static final /* synthetic */ Object $anonfun$testPositionSetCorrectlyWhenOpened$1$adapted(TransactionIndex eta$0$1$1, AbortedTxn abortedTxn) {
        eta$0$1$1.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSanityCheck$1$adapted(TransactionIndex eta$0$1$2, AbortedTxn abortedTxn) {
        eta$0$1$2.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testCollectAbortedTransactions$1$adapted(TransactionIndex eta$0$1$3, AbortedTxn abortedTxn) {
        eta$0$1$3.append(abortedTxn);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncate$1$adapted(TransactionIndex eta$0$1$4, AbortedTxn abortedTxn) {
        eta$0$1$4.append(abortedTxn);
        return BoxedUnit.UNIT;
    }
}

