/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u0017/\u0001MBQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004G\u0001\u0001\u0006I\u0001\u0011\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0013y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011B \t\r1\u0003\u0001\u0015!\u0003A\u0011\u001di\u0005A1A\u0005\u0002}BaA\u0014\u0001!\u0002\u0013\u0001\u0005bB(\u0001\u0005\u0004%\t\u0001\u0015\u0005\u00073\u0002\u0001\u000b\u0011B)\t\u000bi\u0003A\u0011A.\t\u000f!\u0004\u0001\u0019!C\u0005S\"9Q\u0010\u0001a\u0001\n\u0013q\bbBA\u0005\u0001\u0001\u0006KA\u001b\u0005\t\u0003\u0017\u0001\u0001\u0019!C\u0005S\"I\u0011Q\u0002\u0001A\u0002\u0013%\u0011q\u0002\u0005\b\u0003'\u0001\u0001\u0015)\u0003k\u0011!\t)\u0002\u0001a\u0001\n\u0013I\u0007\"CA\f\u0001\u0001\u0007I\u0011BA\r\u0011\u001d\ti\u0002\u0001Q!\n)D\u0001\"a\b\u0001\u0001\u0004%I!\u001b\u0005\n\u0003C\u0001\u0001\u0019!C\u0005\u0003GAq!a\n\u0001A\u0003&!\u000eC\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011\u0011\b\u0001!\u0002\u0013\ti\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011Q\b\u0001!\u0002\u0013\ti\u0003C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005E\u0003\u0001\"\u0011\u0002B!9\u00111\f\u0001\u0005\u0002\u0005\u0005\u0003bBA3\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003S\u0002A\u0011BA6\u0011\u001d\t\t\b\u0001C\u0001\u0003\u0003Bq!!\u001e\u0001\t\u0003\t\t\u0005C\u0004\u0002z\u0001!\t!!\u0011\t\u000f\u0005u\u0004\u0001\"\u0001\u0002B!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\u0005\u0003bBAC\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0013\u0003A\u0011AA!\u0011\u001d\ti\t\u0001C\u0001\u0003\u0003Bq!!%\u0001\t\u0003\t\tEA\u000eQe>$WoY3s\r\u0006LG.\u001e:f\u0011\u0006tG\r\\5oOR+7\u000f\u001e\u0006\u0003_A\n1!\u00199j\u0015\u0005\t\u0014!B6bM.\f7\u0001A\n\u0003\u0001Q\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0019\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003sY\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0002\"!\u0010\u0001\u000e\u00039\n!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{KV\t\u0001\t\u0005\u0002B\t6\t!IC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%IA\u0002J]R\f1\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{K\u0002\nQc]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7/\u0001\ftKJ4XM]'fgN\fw-Z'bq\nKH/Z:!\u0003u\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D\b+\u0019:uSRLwN\u001c\"zi\u0016\u001c\u0018A\b:fa2L7-\u0019$fi\u000eDW*\u0019=QCJ$\u0018\u000e^5p]\nKH/Z:!\u0003q\u0011X\r\u001d7jG\u00064U\r^2i\u001b\u0006D(+Z:q_:\u001cXMQ=uKN\fQD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7\u000fI\u0001\u000b]Vl7+\u001a:wKJ\u001c\u0018a\u00038v[N+'O^3sg\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002#B\u0011!kV\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\tA\fE\u0002^A\nl\u0011A\u0018\u0006\u0003?\n\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\tgLA\u0002TKF\u0004\"a\u00194\u000e\u0003\u0011T!!\u001a\u0019\u0002\rM,'O^3s\u0013\t9GMA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00039s_\u0012,8-\u001a:2+\u0005Q\u0007\u0003B6vo^l\u0011\u0001\u001c\u0006\u0003[:\f\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0003_B\fqa\u00197jK:$8O\u0003\u00022c*\u0011!o]\u0001\u0007CB\f7\r[3\u000b\u0003Q\f1a\u001c:h\u0013\t1HNA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004\u0003bT\u0018BA=C\u0005\u0015\t%O]1z!\t\t50\u0003\u0002}\u0005\n!!)\u001f;f\u00035\u0001(o\u001c3vG\u0016\u0014\u0018g\u0018\u0013fcR\u0019q0!\u0002\u0011\u0007\u0005\u000b\t!C\u0002\u0002\u0004\t\u0013A!\u00168ji\"A\u0011q\u0001\t\u0002\u0002\u0003\u0007!.A\u0002yIE\n!\u0002\u001d:pIV\u001cWM]\u0019!\u0003%\u0001(o\u001c3vG\u0016\u0014('A\u0007qe>$WoY3se}#S-\u001d\u000b\u0004\u007f\u0006E\u0001\u0002CA\u0004'\u0005\u0005\t\u0019\u00016\u0002\u0015A\u0014x\u000eZ;dKJ\u0014\u0004%A\u0005qe>$WoY3sg\u0005i\u0001O]8ek\u000e,'oM0%KF$2a`A\u000e\u0011!\t9AFA\u0001\u0002\u0004Q\u0017A\u00039s_\u0012,8-\u001a:4A\u0005I\u0001O]8ek\u000e,'\u000fN\u0001\u000eaJ|G-^2feRzF%Z9\u0015\u0007}\f)\u0003\u0003\u0005\u0002\be\t\t\u00111\u0001k\u0003)\u0001(o\u001c3vG\u0016\u0014H\u0007I\u0001\u0007i>\u0004\u0018nY\u0019\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MR+\u0001\u0003mC:<\u0017\u0002BA\u001c\u0003c\u0011aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005)1/\u001a;VaR\tq\u0010K\u0002 \u0003\u000b\u0002B!a\u0012\u0002N5\u0011\u0011\u0011\n\u0006\u0004\u0003\u0017\u001a\u0018!\u00026v]&$\u0018\u0002BA(\u0003\u0013\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0001\n)\u0006\u0005\u0003\u0002H\u0005]\u0013\u0002BA-\u0003\u0013\u0012Q!\u00114uKJ\fQ\u0004^3tiR{w\u000eT1sO\u0016\u0014VmY8sI^KG\u000f[!dWj+'o\u001c\u0015\u0004C\u0005}\u0003\u0003BA$\u0003CJA!a\u0019\u0002J\t!A+Z:u\u0003q!Xm\u001d;U_>d\u0015M]4f%\u0016\u001cwN\u001d3XSRD\u0017iY6P]\u0016D3AIA0\u0003-\u001a\u0007.Z2l)>|G*\u0019:hKJ+7m\u001c:e\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGcA@\u0002n!1\u0011qN\u0012A\u0002\u0001\u000bA\"\\1y\r\u0016$8\r[*ju\u0016\fQ\u0006^3tiB\u000b'\u000f^5uS>tGk\\8MCJ<WMR8s%\u0016\u0004H.[2bi&|gnV5uQ\u0006\u001b7.\u00117mQ\r!\u0013qL\u0001-i\u0016\u001cHOU3ta>t7/\u001a+p_2\u000b'oZ3G_J\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRD\u0017iY6BY2D3!JA0\u0003Q!Xm\u001d;O_:,\u00050[:uK:$Hk\u001c9jG\"\u001aa%a\u0018\u0002'Q,7\u000f^,s_:<'I]8lKJd\u0015n\u001d;)\u0007\u001d\ny&\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0004Q\u0005}\u0013a\u0005;fgR\u001cVM\u001c3BMR,'o\u00117pg\u0016$\u0007fA\u0015\u0002`\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\rK\u0002+\u0003?\nQ\u0003^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7\u000fK\u0002,\u0003?\n\u0001\u0006^3ti:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e3po:D3\u0001LA0\u0001")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$1 = this.brokerList();
        long x$6 = this.producerBufferSize();
        int x$7 = 30000;
        int x$8 = 0;
        int x$9 = 16384;
        String x$10 = "none";
        SecurityProtocol x$11 = SecurityProtocol.PLAINTEXT;
        None$ x$12 = None$.MODULE$;
        None$ x$13 = None$.MODULE$;
        ByteArraySerializer x$14 = new ByteArraySerializer();
        ByteArraySerializer x$15 = new ByteArraySerializer();
        boolean x$16 = false;
        this.producer1_$eq(TestUtils$.MODULE$.createProducer(x$1, 0, 10000L, x$6, 0, x$7, x$8, x$9, x$10, 30000, x$11, (Option<File>)x$12, (Option<Properties>)x$13, x$14, x$15, x$16));
        String x$17 = this.brokerList();
        long x$22 = this.producerBufferSize();
        int x$23 = 30000;
        int x$24 = 0;
        int x$25 = 16384;
        String x$26 = "none";
        SecurityProtocol x$27 = SecurityProtocol.PLAINTEXT;
        None$ x$28 = None$.MODULE$;
        None$ x$29 = None$.MODULE$;
        ByteArraySerializer x$30 = new ByteArraySerializer();
        ByteArraySerializer x$31 = new ByteArraySerializer();
        boolean x$32 = false;
        this.producer2_$eq(TestUtils$.MODULE$.createProducer(x$17, 1, 10000L, x$22, 0, x$23, x$24, x$25, x$26, 30000, x$27, (Option<File>)x$28, (Option<Properties>)x$29, x$30, x$31, x$32));
        String x$33 = this.brokerList();
        long x$38 = this.producerBufferSize();
        int x$39 = 30000;
        int x$40 = 0;
        int x$41 = 16384;
        String x$42 = "none";
        SecurityProtocol x$43 = SecurityProtocol.PLAINTEXT;
        None$ x$44 = None$.MODULE$;
        None$ x$45 = None$.MODULE$;
        ByteArraySerializer x$46 = new ByteArraySerializer();
        ByteArraySerializer x$47 = new ByteArraySerializer();
        boolean x$48 = false;
        this.producer3_$eq(TestUtils$.MODULE$.createProducer(x$33, -1, 10000L, x$38, 0, x$39, x$40, x$41, x$42, 30000, x$43, (Option<File>)x$44, (Option<Properties>)x$45, x$46, x$47, x$48));
    }

    @Override
    @After
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assert.assertNotNull((Object)recordMetadata);
        Assert.assertFalse((boolean)recordMetadata.hasOffset());
        Assert.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (RecordMetadata)this.producer2().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.numServers()));
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(maxMessageSize));
        String topic10 = "topic10";
        Buffer<KafkaServer> buffer = this.servers();
        if (buffer == null) {
            throw null;
        }
        this.createTopic(topic10, buffer.length(), this.numServers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (RecordMetadata)this.producer1().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    @Test
    public void testWrongBrokerList() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.producer4_$eq(TestUtils$.MODULE$.createProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (RecordMetadata)this.producer4().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testInvalidPartition() {
        this.createTopic(this.topic1(), 1, this.numServers(), this.createTopic$default$4());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Integer.valueOf(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        Throwable throwable = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (RecordMetadata)this.producer1().send(higherRecord).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195))).getCause();
        if (throwable instanceof TimeoutException) {
            return;
        }
        throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
    }

    @Test
    public void testSendAfterClosed() {
        String x$1 = this.topic1();
        int x$2 = this.numServers();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            this.producer1().close();
            return this.producer1().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            this.producer2().close();
            return this.producer2().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            this.producer3().close();
            return this.producer3().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (RecordMetadata)this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        Assert.assertTrue((String)new StringBuilder(55).append("Unexpected exception while sending to an invalid topic ").append(thrown.getCause()).toString(), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", Integer.toString(this.numServers() + 1));
        int x$2 = this.numServers();
        int x$4 = this.createTopic$default$2();
        this.createTopic(topicName, x$4, x$2, topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.producer3().send(record).get();
            Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            return;
        }
        catch (ExecutionException executionException) {
            if (!(executionException.getCause() instanceof NotEnoughReplicasException)) {
                Assert.fail((String)"Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
                return;
            }
            return;
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        block2: {
            String topicName = "minisrtest2";
            Properties topicProps = new Properties();
            topicProps.put("min.insync.replicas", Integer.toString(this.numServers()));
            int x$2 = this.numServers();
            int x$4 = this.createTopic$default$2();
            this.createTopic(topicName, x$4, x$2, topicProps);
            ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
            this.producer3().send(record).get();
            ((KafkaServer)this.servers().head()).shutdown();
            ((KafkaServer)this.servers().head()).awaitShutdown();
            try {
                this.producer3().send(record).get();
                Assert.fail((String)"Expected exception when producing to topic with fewer brokers than min.insync.replicas");
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException) break block2;
                Assert.fail((String)new StringBuilder(154).append("Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw ").append(e.getCause()).toString());
            }
        }
        ((KafkaServer)this.servers().head()).startup();
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), Integer.toString(this.replicaFetchMaxPartitionBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), Integer.toString(this.replicaFetchMaxResponseBytes()));
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        this.producer1 = null;
        this.producer2 = null;
        this.producer3 = null;
        this.producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

