/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMb!\u0002.\\\u0003\u0003\u0001\u0007\"\u00025\u0001\t\u0003I\u0007bB6\u0001\u0005\u0004%\t\u0005\u001c\u0005\u0007g\u0002\u0001\u000b\u0011B7\t\u000bQ\u0004A\u0011I;\t\u000fe\u0004!\u0019!C\u0001Y\"1!\u0010\u0001Q\u0001\n5Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B?\t\u0011\u00055\u0001A1A\u0005\u0002qDq!a\u0004\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001}\u0011\u001d\t\u0019\u0002\u0001Q\u0001\nuD\u0001\"!\u0006\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003/\u0001\u0001\u0015!\u0003~\u0011!\tI\u0002\u0001b\u0001\n\u0003a\bbBA\u000e\u0001\u0001\u0006I! \u0005\t\u0003;\u0001!\u0019!C\u0001Y\"9\u0011q\u0004\u0001!\u0002\u0013i\u0007\"CA\u0011\u0001\t\u0007I\u0011AA\u0012\u0011!\tY\u0004\u0001Q\u0001\n\u0005\u0015\u0002BCA\u001f\u0001!\u0015\r\u0011\"\u0015\u0002@!9\u00111\u000b\u0001\u0005\u0012\u0005U\u0003\"CAC\u0001\t\u0007I\u0011AAD\u0011!\t)\n\u0001Q\u0001\n\u0005%\u0005\"CAL\u0001\t\u0007I\u0011AAD\u0011!\tI\n\u0001Q\u0001\n\u0005%\u0005\"CAN\u0001\t\u0007I\u0011AAD\u0011!\ti\n\u0001Q\u0001\n\u0005%\u0005\"CAP\u0001\t\u0007I\u0011AAD\u0011!\t\t\u000b\u0001Q\u0001\n\u0005%\u0005\"CAR\u0001\t\u0007I\u0011AAD\u0011!\t)\u000b\u0001Q\u0001\n\u0005%\u0005\"CAT\u0001\t\u0007I\u0011AAD\u0011!\tI\u000b\u0001Q\u0001\n\u0005%\u0005\"CAV\u0001\t\u0007I\u0011AAD\u0011!\ti\u000b\u0001Q\u0001\n\u0005%\u0005bBAX\u0001\u0019\u0005\u0011\u0011\u0017\u0005\b\u0003\u0007\u0004a\u0011AAY\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!a5\u0001\t\u0003\t9\rC\u0004\u0002V\u0002!\t!a6\t\u000f\u0005m\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u001c\u0001\u0005\u0002\u0005\u001d\u0007bBAp\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003C\u0004A\u0011AAr\u0011\u001d\t9\u000f\u0001C\u0001\u0003\u000fDq!!;\u0001\t\u0003\t9\rC\u0004\u0002l\u0002!\t!a2\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9!Q\u0002\u0001\u0005\u0002\u0005=\bb\u0002B\b\u0001\u0011\u0005\u0011q\u001e\u0005\b\u0005#\u0001A\u0011AAx\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003_DqA!\u0006\u0001\t\u0003\ty\u000fC\u0004\u0003\u0018\u0001!\t!a<\t\r\te\u0001\u0001\"\u0011v\u0011\u0019\u0011I\u0003\u0001C!k\"1!1\u0007\u0001\u0005\u0002UDaA!\u0010\u0001\t#)\bb\u0002B \u0001\u0011%!\u0011\t\u0005\u0007\u0005K\u0002A\u0011A;\t\r\t%\u0004\u0001\"\u0001v\u0011\u0019\u0011i\u0007\u0001C\u0001k\"1!\u0011\u000f\u0001\u0005\u0002UDaA!\u001e\u0001\t\u0013)\bB\u0002B<\u0001\u0011%Q\u000fC\u0004\u0003z\u0001!IAa\u001f\t\u000f\t}\u0004\u0001\"\u0005\u0003\u0002\"1!Q\u0011\u0001\u0005\nUDaAa\"\u0001\t\u0003)\bB\u0002BF\u0001\u0011\u0005Q\u000f\u0003\u0004\u0003\u0010\u0002!\t!\u001e\u0005\u0007\u0005;\u0003A\u0011A;\t\r\t\u0005\u0006\u0001\"\u0003v\u0011\u0019\u0011\u0019\u000b\u0001C\u0001k\"1!q\u0015\u0001\u0005\u0002UDaAa+\u0001\t\u0013)\bB\u0002BW\u0001\u0011\u0005Q\u000fC\u0004\u00032\u0002!)Ba-\t\u000f\tM\u0007\u0001\"\u0006\u0003V\"I!\u0011 \u0001\u0012\u0002\u0013U!1 \u0005\n\u0007#\u0001\u0011\u0013!C\u000b\u0005wD\u0011ba\u0005\u0001#\u0003%)b!\u0006\t\u0013\re\u0001!%A\u0005\u0016\tm\b\"CB\u000e\u0001E\u0005IQCB\u000f\u0011\u001d\u0019\t\u0003\u0001C\u0005\u0007GA\u0011b!\f\u0001#\u0003%IAa?\t\u0013\r=\u0002!%A\u0005\n\tm\b\"CB\u0019\u0001E\u0005I\u0011BB\u000b\u0005e)e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u000b\u0005qk\u0016aA1qS*\ta,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\tW\r\u0005\u0002cG6\t1,\u0003\u0002e7\n1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002cM&\u0011qm\u0017\u0002\n'\u0006\u001cHnU3ukB\fa\u0001P5oSRtD#\u00016\u0011\u0005\t\u0004\u0011a\u00032s_.,'oQ8v]R,\u0012!\u001c\t\u0003]Fl\u0011a\u001c\u0006\u0002a\u0006)1oY1mC&\u0011!o\u001c\u0002\u0004\u0013:$\u0018\u0001\u00042s_.,'oQ8v]R\u0004\u0013aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f\u001e\u000b\u0002mB\u0011an^\u0005\u0003q>\u0014A!\u00168ji\u0006Qa.^7SK\u000e|'\u000fZ:\u0002\u00179,XNU3d_J$7\u000fI\u0001\fOJ|W\u000f\u001d)sK\u001aL\u00070F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0011\u0001\u00026bm\u0006L1!!\u0003\u0000\u0005\u0019\u0019FO]5oO\u0006aqM]8vaB\u0013XMZ5yA\u0005)qM]8va\u00061qM]8va\u0002\n1\u0002^8qS\u000e\u0004&/\u001a4jq\u0006aAo\u001c9jGB\u0013XMZ5yA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\n\u0001b^5mI\u000e\f'\u000fZ\u0001\no&dGmY1sI\u0002\nA\u0001]1si\u0006)\u0001/\u0019:uA\u0005\u0011A\u000f]\u000b\u0003\u0003K\u0001B!a\n\u000285\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0004d_6lwN\u001c\u0006\u0004=\u0006=\"\u0002BA\u0019\u0003g\ta!\u00199bG\",'BAA\u001b\u0003\ry'oZ\u0005\u0005\u0003s\tIC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%\u0001\bueV\u001cHo\u0015;pe\u00164\u0015\u000e\\3\u0016\u0005\u0005\u0005\u0003#\u00028\u0002D\u0005\u001d\u0013bAA#_\n!1k\\7f!\u0011\tI%a\u0014\u000e\u0005\u0005-#\u0002BA'\u0003\u0007\t!![8\n\t\u0005E\u00131\n\u0002\u0005\r&dW-A\bbkRDwN]5{KJ\u001cE.Y:t+\t\t9\u0006\r\u0003\u0002Z\u0005M\u0004CBA.\u0003S\nyG\u0004\u0003\u0002^\u0005\u0015\u0004cAA0_6\u0011\u0011\u0011\r\u0006\u0004\u0003Gz\u0016A\u0002\u001fs_>$h(C\u0002\u0002h=\fa\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012Qa\u00117bgNT1!a\u001ap!\u0011\t\t(a\u001d\r\u0001\u0011Y\u0011Q\u000f\f\u0002\u0002\u0003\u0005)\u0011AA<\u0005\ryF%M\t\u0005\u0003s\ny\bE\u0002o\u0003wJ1!! p\u0005\u001dqu\u000e\u001e5j]\u001e\u00042A\\AA\u0013\r\t\u0019i\u001c\u0002\u0004\u0003:L\u0018!\u0004;pa&\u001c'+Z:pkJ\u001cW-\u0006\u0002\u0002\nB!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006%\u0012\u0001\u0003:fg>,(oY3\n\t\u0005M\u0015Q\u0012\u0002\u0010%\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006qAo\u001c9jGJ+7o\\;sG\u0016\u0004\u0013!D4s_V\u0004(+Z:pkJ\u001cW-\u0001\bhe>,\bOU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002+A\u0014XMZ5yK\u0012$v\u000e]5d%\u0016\u001cx.\u001e:dK\u00061\u0002O]3gSb,G\rV8qS\u000e\u0014Vm]8ve\u000e,\u0007%A\u000bqe\u00164\u0017\u000e_3e\u000fJ|W\u000f\u001d*fg>,(oY3\u0002-A\u0014XMZ5yK\u0012<%o\\;q%\u0016\u001cx.\u001e:dK\u0002\nQc^5mI\u000e\f'\u000f\u001a+pa&\u001c'+Z:pkJ\u001cW-\u0001\fxS2$7-\u0019:e)>\u0004\u0018n\u0019*fg>,(oY3!\u0003U9\u0018\u000e\u001c3dCJ$wI]8vaJ+7o\\;sG\u0016\fac^5mI\u000e\f'\u000fZ$s_V\u0004(+Z:pkJ\u001cW\rI\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bYV\u0011\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003\u0011\tW\u000f\u001e5\u000b\t\u0005u\u0016\u0011F\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011YA\\\u00059Y\u0015MZ6b!JLgnY5qC2\fab[1gW\u0006\u0004&/\u001b8dSB\fG.A\tdYV\u001cH/\u001a:BGRLwN\\!sON,\"!!3\u0011\u000b9\fY-a4\n\u0007\u00055wNA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002\\\u0005E\u0017\u0002BA\u0005\u0003[\na\u0003^8qS\u000e\u0014%o\\6feJ+\u0017\rZ!dY\u0006\u0013xm]\u0001\u000faJ|G-^2f\u0003\u000ed\u0017I]4t)\u0011\tI-!7\t\u000f\u0005U\u0011\u00061\u0001\u0002P\u0006yA-Z:de&\u0014W-Q2m\u0003J<7/A\u000beK2,G/\u001a#fg\u000e\u0014\u0018NY3BG2\f%oZ:\u0002%\u0011,G.\u001a;f/JLG/Z!dY\u0006\u0013xm]\u0001\u000fG>t7/^7f\u0003\u000ed\u0017I]4t)\u0011\tI-!:\t\u000f\u0005UQ\u00061\u0001\u0002P\u0006aqM]8va\u0006\u001bG.\u0011:hg\u0006i\u0002O]8ek\u000e,7i\u001c8tk6,w+\u001b7eG\u0006\u0014H-Q2m\u0003J<7/\u0001\u0010qe>$WoY3D_:\u001cX/\\3Qe\u00164\u0017\u000e_3e\u0003\u000ed7/\u0011:hg\u0006\u00012\t\\;ti\u0016\u0014\u0018i\u0019;j_:\f5\r\\\u000b\u0003\u0003c\u0004b!a=\u0002~\n\u0005QBAA{\u0015\u0011\t90!?\u0002\u0013%lW.\u001e;bE2,'bAA~_\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0018Q\u001f\u0002\u0004'\u0016$\b\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\t\t\u001d\u0011\u0011F\u0001\u0004C\u000ed\u0017\u0002\u0002B\u0006\u0005\u000b\u0011!#Q2dKN\u001c8i\u001c8ue>dWI\u001c;ss\u0006\u0011Bk\u001c9jG\n\u0013xn[3s%\u0016\fG-Q2m\u000319%o\\;q%\u0016\fG-Q2m\u00031!v\u000e]5d%\u0016\fG-Q2m\u00035!v\u000e]5d/JLG/Z!dY\u0006\u0001Bk\u001c9jG\u0012+7o\u0019:jE\u0016\f5\r\\\u0001\u000f)>\u0004\u0018nY\"sK\u0006$X-Q2m\u0003\u0015\u0019X\r^+qQ\rA$Q\u0004\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")!!1EA\u001a\u0003\u0015QWO\\5u\u0013\u0011\u00119C!\t\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007fA\u001d\u0003.A!!q\u0004B\u0018\u0013\u0011\u0011\tD!\t\u0003\u000b\u00053G/\u001a:\u00027Q,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.\u001a,jC\u0006\u001b8/[4oQ\rQ$q\u0007\t\u0005\u0005?\u0011I$\u0003\u0003\u0003<\t\u0005\"\u0001\u0002+fgR\fadY8oM&\u0014XNU3bkRDWM\u001c;jG\u0006$\u0018n\u001c8NKR\u0014\u0018nY:\u0002\u0011\u001d,GoR1vO\u0016$BAa\u0011\u0003bA1!Q\tB,\u00057j!Aa\u0012\u000b\t\t%#1J\u0001\u0005G>\u0014XM\u0003\u0003\u0003N\t=\u0013aB7fiJL7m\u001d\u0006\u0005\u0005#\u0012\u0019&\u0001\u0004zC6lWM\u001d\u0006\u0003\u0005+\n1aY8n\u0013\u0011\u0011IFa\u0012\u0003\u000b\u001d\u000bWoZ3\u0011\u00079\u0014i&C\u0002\u0003`=\u0014a\u0001R8vE2,\u0007b\u0002B2y\u0001\u0007\u0011qZ\u0001\u000b[\u0016$(/[2OC6,\u0017A\b;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u00164\u0016.Y*vEN\u001c'/\u001b2fQ\ri$qG\u0001#i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlWmV5uQ^KG\u000eZ2be\u0012\f5\r\\:)\u0007y\u00129$\u0001\u0012uKN$\bK]8ek\u000e,7i\u001c8tk6,w+\u001b;i!J,g-\u001b=fI\u0006\u001bGn\u001d\u0015\u0004\u007f\t]\u0012a\f;fgR\u0004&o\u001c3vG\u0016\u001cuN\\:v[\u0016$v\u000e]5d\u0003V$xn\u0011:fCR,Gk\u001c9jG\u000e\u0013X-\u0019;f\u0003\u000ed\u0007f\u0001!\u00038\u000592/\u001a;XS2$7-\u0019:e%\u0016\u001cx.\u001e:dK\u0006\u001bGn]\u0001\u0018g\u0016$\bK]3gSb,GMU3t_V\u00148-Z!dYN\f1c]3u%\u0016\fG-\u00118e/JLG/Z!dYN$2A\u001eB?\u0011\u001d\t\tc\u0011a\u0001\u0003K\t\u0011c]3u\u0003\u000ed7/\u00118e!J|G-^2f)\r1(1\u0011\u0005\b\u0003C!\u0005\u0019AA\u0013\u0003Q\u0019X\r^\"p]N,X.\u001a:He>,\b/Q2mg\u0006)D/Z:u\u001d>$Um]2sS\n,\u0007K]8ek\u000e,wJ]\"p]N,X.Z,ji\"|W\u000f\u001e+pa&\u001cG)Z:de&\u0014W-Q2mQ\r1%qG\u0001\u001di\u0016\u001cHOT8Qe>$WoY3XSRDG)Z:de&\u0014W-Q2mQ\r9%qG\u0001)i\u0016\u001cHOT8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\b\u0011\n]\"1\u0013BK\u0003!)\u0007\u0010]3di\u0016$7E\u0001BL!\u0011\t9C!'\n\t\tm\u0015\u0011\u0006\u0002\u000f\u0017\u000647.Y#yG\u0016\u0004H/[8o\u0003-\"Xm\u001d;O_\u000e{gn];nK^KG\u000f[8vi\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007fA%\u00038\u0005\u0001cn\\\"p]N,X.Z,ji\"|W\u000f\u001e#fg\u000e\u0014\u0018NY3BG2\u001cV\r^;q\u0003\u0015\"Xm\u001d;O_\u000e{gn];nK^KG\u000f\u001b#fg\u000e\u0014\u0018NY3BG24\u0016.Y!tg&<g\u000eK\u0002L\u0005o\t\u0001\u0006^3ti:{7i\u001c8tk6,w+\u001b;i\t\u0016\u001c8M]5cK\u0006\u001bGNV5b'V\u00147o\u0019:jE\u0016D3\u0001\u0014B\u001c\u0003uqwnQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\\*fiV\u0004\u0018A\u0004;fgRtun\u0012:pkB\f5\r\u001c\u0015\u0004\u001d\n]\u0012aC:f]\u0012\u0014VmY8sIN$rA\u001eB[\u0005\u001f\u0014\t\u000eC\u0004\u00038>\u0003\rA!/\u0002\u0011A\u0014x\u000eZ;dKJ\u0004\u0002Ba/\u0003D\n\u001d'qY\u0007\u0003\u0005{SAAa.\u0003@*!!\u0011YA\u0017\u0003\u001d\u0019G.[3oiNLAA!2\u0003>\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RA\\Af\u0005\u0013\u00042A\u001cBf\u0013\r\u0011im\u001c\u0002\u0005\u0005f$X\rC\u0003z\u001f\u0002\u0007Q\u000eC\u0004\u0002\"=\u0003\r!!\n\u0002\u001d\r|gn];nKJ+7m\u001c:egRiaOa6\u0003f\n\u001d(1\u001eBw\u0005_DqA!7Q\u0001\u0004\u0011Y.\u0001\u0005d_:\u001cX/\\3s!!\u0011iN!9\u0003H\n\u001dWB\u0001Bp\u0015\u0011\u0011INa0\n\t\t\r(q\u001c\u0002\t\u0007>t7/^7fe\"9\u0011\u0010\u0015I\u0001\u0002\u0004i\u0007\u0002\u0003Bu!B\u0005\t\u0019A7\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\"I\u0011Q\u0003)\u0011\u0002\u0003\u0007\u0011q\u001a\u0005\t\u0003;\u0001\u0006\u0013!a\u0001[\"I!\u0011\u001f)\u0011\u0002\u0003\u0007!1_\u0001\bi&lWm\\;u!\rq'Q_\u0005\u0004\u0005o|'\u0001\u0002'p]\u001e\f\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iPK\u0002n\u0005\u007f\\#a!\u0001\u0011\t\r\r1QB\u0007\u0003\u0007\u000bQAaa\u0002\u0004\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007\u0017y\u0017AC1o]>$\u0018\r^5p]&!1qBB\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111q\u0003\u0016\u0005\u0003\u001f\u0014y0\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIU\n\u0001dY8ogVlWMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019yB\u000b\u0003\u0003t\n}\u0018!L2p]N,X.\u001a*fG>\u0014Hm]%h]>\u0014Xm\u00148f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]RIao!\n\u0004(\r%21\u0006\u0005\b\u000534\u0006\u0019\u0001Bn\u0011\u001dIh\u000b%AA\u00025D\u0001B!;W!\u0003\u0005\r!\u001c\u0005\n\u0003+1\u0006\u0013!a\u0001\u0003\u001f\fqgY8ogVlWMU3d_J$7/S4o_J,wJ\\3BkRDwN]5{CRLwN\\#yG\u0016\u0004H/[8oI\u0011,g-Y;mi\u0012\u0012\u0014aN2p]N,X.\u001a*fG>\u0014Hm]%h]>\u0014Xm\u00148f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$3'A\u001cd_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$C-\u001a4bk2$H\u0005\u000e")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final ResourcePattern topicResource;
    private final ResourcePattern groupResource;
    private final ResourcePattern clusterResource;
    private final ResourcePattern prefixedTopicResource;
    private final ResourcePattern prefixedGroupResource;
    private final ResourcePattern wildcardTopicResource;
    private final ResourcePattern wildcardGroupResource;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    public Class<?> authorizerClass() {
        return AclAuthorizer.class;
    }

    public ResourcePattern topicResource() {
        return this.topicResource;
    }

    public ResourcePattern groupResource() {
        return this.groupResource;
    }

    public ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    public ResourcePattern prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public ResourcePattern prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public ResourcePattern wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public ResourcePattern wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public abstract KafkaPrincipal clientPrincipal();

    public abstract KafkaPrincipal kafkaPrincipal();

    public String[] clusterActionArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()};
    }

    public String[] topicBrokerReadAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()};
    }

    public String[] produceAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] describeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] deleteDescribeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] deleteWriteAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] consumeAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] groupAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] produceConsumeWildcardAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()};
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> ClusterActionAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicBrokerReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> GroupReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicWriteAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicDescribeAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicCreateAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Should have been zero expired connections killed total", (double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0);
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        Option option = ((IterableOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, x0$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }
        Object var2_2 = null;
        return (Gauge)((Tuple2)getOrElse_this.get())._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int x$4 = 0;
        int x$5 = this.part();
        long x$6 = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, x$4, x$3, x$5, x$6);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setReadAndWriteAcls(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setReadAndWriteAcls$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        this.setReadAndWriteAcls(tp);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    private void setConsumerGroupAcls() {
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl() {
        void apply_elems;
        void apply_elems2;
        this.setConsumerGroupAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$2 = this.numRecords();
            String x$3 = this.tp().topic();
            int x$4 = 0;
            int x$5 = this.part();
            long x$6 = 10000L;
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, x$4, x$3, x$5, x$6);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ExecutionException e1 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            return (Map)adminClient.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()).all().get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause()).toString(), (boolean)(e1.getCause() instanceof TopicAuthorizationException));
        String topic2 = "topic2";
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.setReadAndWriteAcls(tp2);
        this.sendRecords(producer, this.numRecords(), tp2);
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$8 = this.numRecords();
        int x$10 = 0;
        int x$11 = this.part();
        long x$12 = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$8, x$10, topic2, x$11, x$12);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map describeResults = adminClient.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults.get(topic2)).get()).partitions().size());
        ExecutionException e2 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            return (Map)adminClient.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava()).all().get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause()).toString(), (boolean)(e2.getCause() instanceof TopicAuthorizationException));
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        this.sendRecords(producer, this.numRecords(), tp2);
        boolean create_e = false;
        BooleanRef topic2RecordConsumed = new BooleanRef(create_e);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long pollRecordsUntilTrue_waitTimeMs = 15000L;
            long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(100L));
                Assert.assertEquals((String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(consumerRecords).toString(), Collections.singleton(tp2), (Object)consumerRecords.partitions());
                topic2RecordConsumed$1.elem = true;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + pollRecordsUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail("Consumer didn't fail with authorization exception within timeout", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                Thread.sleep(Math.min(pollRecordsUntilTrue_waitTimeMs, pollRecordsUntilTrue_waitUntilTrue_pause));
            }
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.setReadAndWriteAcls(this.tp());
        if (!topic2RecordConsumed.elem) {
            this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 1, topic2);
        }
        this.sendRecords(producer, this.numRecords(), this.tp());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map describeResults2 = adminClient.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(this.topic())).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(topic2)).get()).partitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw Assertions$.MODULE$.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$3 = 1;
            int x$4 = 0;
            String x$5 = this.topic();
            int x$6 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$3, x$4, x$5, x$6, 3000L);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.setReadAndWriteAcls(this.tp());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$))).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$9 = 1;
            int x$10 = 0;
            String x$11 = this.topic();
            int x$12 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$9, x$10, x$11, x$12, 3000L);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic());
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), AccessControlEntryFilter.ANY);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$testNoGroupAcl$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        Future future;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            future = EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)object));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        future = null;
        try {
            ((IndexedSeq)map_strictOptimizedMap_b.result()).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, numRecords, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                EndToEndAuthorizationTest.$anonfun$consumeRecords$1(records, startingOffset, topic, part, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    private void consumeRecordsIgnoreOneAuthorizationException(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic) {
        try {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$2() {
        return 1;
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$3() {
        return 0;
    }

    private String consumeRecordsIgnoreOneAuthorizationException$default$4() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.clusterResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue(s, "expired-connections-killed-count");
        Assert.assertTrue((String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString(), (numExpiredKilled == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assert.assertTrue((String)"failed re-authentications not 0", (TestUtils$.MODULE$.totalMetricValue(s, "failed-reauthentication-total") == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        void $plus$plus_that4;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that4);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that3);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        SetOps setOps3 = setOps2.concat((IterableOnce)$plus$plus_that2);
        set4 = null;
        scala.collection.immutable.Set<AccessControlEntry> set5 = $this.TopicBrokerReadAcl();
        if (setOps3 == null) {
            throw null;
        }
        set5 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps3.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource(), AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that3);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that2);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        set4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps2.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource(), AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setReadAndWriteAcls$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that3);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that2);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        set4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps2.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, tp$1.topic(), PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    private static final boolean verifyNoRecords$1(ConsumerRecords records, TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1) {
        Assert.assertEquals((String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(records).toString(), Collections.singleton(tp2$1), (Object)records.partitions());
        topic2RecordConsumed$1.elem = true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$7() {
        return "Consumer didn't fail with authorization exception within timeout";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testNoGroupAcl$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Integer.valueOf(tp$2.partition()), (Object)String.valueOf((Object)i).getBytes(), (Object)String.valueOf((Object)i).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$2.send(record);
    }

    public static final /* synthetic */ void $anonfun$consumeRecords$1(Seq records$1, int startingOffset$1, String topic$1, int part$1, int i) {
        ConsumerRecord record = (ConsumerRecord)records$1.apply(i);
        int offset = startingOffset$1 + i;
        Assert.assertEquals((Object)topic$1, (Object)record.topic());
        Assert.assertEquals((long)part$1, (long)record.partition());
        Assert.assertEquals((long)offset, (long)record.offset());
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new ResourcePattern(ResourceType.TOPIC, this.topic(), PatternType.LITERAL);
        this.groupResource = new ResourcePattern(ResourceType.GROUP, this.group(), PatternType.LITERAL);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.prefixedTopicResource = new ResourcePattern(ResourceType.TOPIC, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new ResourcePattern(ResourceType.GROUP, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new ResourcePattern(ResourceType.TOPIC, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new ResourcePattern(ResourceType.GROUP, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClass().getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
        this.consumerConfig().setProperty("metadata.max.age.ms", "1500");
        Statics.releaseFence();
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, Object i) {
        return EndToEndAuthorizationTest.$anonfun$sendRecords$1($this, tp$2, producer$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$6$adapted(TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1, ConsumerRecords records) {
        return BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.verifyNoRecords$1(records, tp2$1, topic2RecordConsumed$1));
    }
}

