/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Optional;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArraySeq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y2Aa\u0002\u0005\u0001\u001b!)!\u0003\u0001C\u0001'!)Q\u0003\u0001C\u0001-!)a\u0005\u0001C\u0001-!)\u0001\u0007\u0001C\u0001-!)!\u0007\u0001C\u0001-!)A\u0007\u0001C\u0001-\t)B*[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9UKN$(BA\u0005\u000b\u0003\u0015\tG-\\5o\u0015\u0005Y\u0011!B6bM.\f7\u0001A\n\u0003\u00019\u0001\"a\u0004\t\u000e\u0003!I!!\u0005\u0005\u00031\r{gn];nKJ<%o\\;q\u0007>lW.\u00198e)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011q\u0002A\u0001\u0017i\u0016\u001cH\u000fT5ti\u000e{gn];nKJ<%o\\;qgR\tq\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0003V]&$\bF\u0001\u0002\u001f!\tyB%D\u0001!\u0015\t\t#%A\u0003kk:LGOC\u0001$\u0003\ry'oZ\u0005\u0003K\u0001\u0012A\u0001V3ti\u0006IC/Z:u\u0019&\u001cHoV5uQVs'/Z2pO:L'0\u001a3OK^\u001cuN\\:v[\u0016\u0014x\n\u001d;j_:DCa\u0001\u0010)S\u0005AQ\r\u001f9fGR,GmI\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013A\u00036paR\u001c\u0018.\u001c9mK&\u0011q\u0006\f\u0002\u0010\u001fB$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0006\u0001C/Z:u\u0019&\u001cHoQ8ogVlWM]$s_V\u00048oV5uQN#\u0018\r^3tQ\t!a$A\u0011uKN$8i\u001c8tk6,'o\u0012:pkB\u001cF/\u0019;fg\u001a\u0013x.\\*ue&tw\r\u000b\u0002\u0006=\u0005!B/Z:u\u0019&\u001cHo\u0012:pkB\u001cu.\\7b]\u0012D#A\u0002\u0010")
public class ListConsumerGroupTest
extends ConsumerGroupCommandTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroups() {
        void apply_elems;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--list"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.group(), simpleGroup});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set expectedGroups = (Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            Set set = service.listConsumerGroups().toSet();
            Set set2 = expectedGroups;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups).append(", but found ").append(set).append(".").toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test(expected=OptionException.class)
    public void testListWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--list"};
        this.getConsumerGroupService(cgcArgs);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListConsumerGroupsWithStates() {
        void apply_elems;
        Set set;
        void apply_elems2;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state"};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(simpleGroup, true, Optional.of(ConsumerGroupState.EMPTY)), new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set expectedListing = (Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values());
            if (ofRef2 == null) {
                throw null;
            }
            set = service.listConsumerGroupsWithState(IterableOnceOps.toSet$((IterableOnceOps)ofRef2)).toSet();
            Set set2 = expectedListing;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Expected to show groups ").append(expectedListing).append(", but found ").append(set).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupListing[]{new ConsumerGroupListing(this.group(), false, Optional.of(ConsumerGroupState.STABLE))});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Set expectedListingStable = (Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        set = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            void $anonfun$testListConsumerGroupsWithStates$3_apply_elems;
            Set$ set$3 = Predef$.MODULE$.Set();
            ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE});
            if (set$3 == null) {
                throw null;
            }
            arraySeq3 = null;
            set = service.listConsumerGroupsWithState((Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)$anonfun$testListConsumerGroupsWithStates$3_apply_elems)).toSet();
            Set set3 = expectedListingStable;
            if (!(set3 != null ? !set3.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail(new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable).append(", but found ").append(set).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroupStatesFromString() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable");
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Stable, PreparingRebalance");
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE, ConsumerGroupState.PREPARING_REBALANCE});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2), (Object)result);
        result = ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("Dead,CompletingRebalance,");
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.DEAD, ConsumerGroupState.COMPLETING_REBALANCE});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems), (Object)result);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("bad, wrong"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("stable"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("  bad, Stable"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ConsumerGroupCommand$.MODULE$.consumerGroupStatesFromString("   ,   ,"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ListConsumerGroupTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListGroupCommand() {
        String string;
        String simpleGroup = "simple-group";
        Iterable<TopicPartition> x$2 = this.addSimpleGroupExecutor$default$1();
        this.addSimpleGroupExecutor(x$2, simpleGroup);
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] create_e = new String[]{"--bootstrap-server", this.brokerList(), "--list"};
        Object var22_3 = null;
        ObjectRef cgcArgs = new ObjectRef((Object)create_e);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(!(string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(new StringBuilder(45).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and no header, but found ").append(string).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state"};
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem))).contains("STATE") && string.contains(simpleGroup) && string.contains(this.group()))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail(new StringBuilder(46).append("Expected to find ").append(simpleGroup).append(", ").append(this.group()).append(" and the header, but found ").append(string).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        cgcArgs.elem = new String[]{"--bootstrap-server", this.brokerList(), "--list", "--state", "Stable"};
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 15000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!((string = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem))).contains("STATE") && string.contains(this.group()) && string.contains("Stable"))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                throw Assertions$.MODULE$.fail(new StringBuilder(60).append("Expected to find ").append(this.group()).append(" in state Stable and the header, but found ").append(string).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs3, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroups$1(ObjectRef foundGroups$1, ConsumerGroupCommand.ConsumerGroupService service$1, Set expectedGroups$1) {
        foundGroups$1.elem = service$1.listConsumerGroups().toSet();
        Set set = expectedGroups$1;
        Set set2 = (Set)foundGroups$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroups$2(Set expectedGroups$1, ObjectRef foundGroups$1) {
        return new StringBuilder(44).append("Expected --list to show groups ").append(expectedGroups$1).append(", but found ").append((Set)foundGroups$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$1(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListing$1) {
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])ConsumerGroupState.values());
        if (ofRef2 == null) {
            throw null;
        }
        foundListing$1.elem = service$2.listConsumerGroupsWithState(IterableOnceOps.toSet$((IterableOnceOps)ofRef2)).toSet();
        Set set = expectedListing$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$2(Set expectedListing$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListing$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testListConsumerGroupsWithStates$3(ObjectRef foundListing$1, ConsumerGroupCommand.ConsumerGroupService service$2, Set expectedListingStable$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConsumerGroupState[]{ConsumerGroupState.STABLE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        foundListing$1.elem = service$2.listConsumerGroupsWithState((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).toSet();
        Set set = expectedListingStable$1;
        Set set2 = (Set)foundListing$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testListConsumerGroupsWithStates$4(Set expectedListingStable$1, ObjectRef foundListing$1) {
        return new StringBuilder(36).append("Expected to show groups ").append(expectedListingStable$1).append(", but found ").append((Set)foundListing$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$1(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return !((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$3(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(45).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and no header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$4(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1, String simpleGroup$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains(simpleGroup$1) && ((String)out$1.elem).contains($this.group());
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$6(ListConsumerGroupTest $this, String simpleGroup$1, ObjectRef out$1) {
        return new StringBuilder(46).append("Expected to find ").append(simpleGroup$1).append(", ").append($this.group()).append(" and the header, but found ").append((String)out$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testListGroupCommand$7(ListConsumerGroupTest $this, ObjectRef out$1, ObjectRef cgcArgs$1) {
        out$1.elem = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> ConsumerGroupCommand$.MODULE$.main((String[])cgcArgs$1.elem));
        return ((String)out$1.elem).contains("STATE") && ((String)out$1.elem).contains($this.group()) && ((String)out$1.elem).contains("Stable");
    }

    public static final /* synthetic */ String $anonfun$testListGroupCommand$9(ListConsumerGroupTest $this, ObjectRef out$1) {
        return new StringBuilder(60).append("Expected to find ").append($this.group()).append(" in state Stable and the header, but found ").append((String)out$1.elem).toString();
    }
}

