/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005!3A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)A\u0007\u0001C\u00019!)a\u0007\u0001C\u00019!)\u0001\b\u0001C\u00019!)!\b\u0001C\u00019!)A\b\u0001C\u00019!)a\b\u0001C\u00019!)\u0001\t\u0001C\u00019!)!\t\u0001C\u00019!)A\t\u0001C\u00019!)a\t\u0001C\u00019\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005=\u0001\u0012!B1e[&t'\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDCA\u0001\u0013-[A\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002S\u0005\u0019qN]4\n\u0005-2#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'\u0001\u0006k_B$8/[7qY\u0016L!a\r\u0019\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:\fQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003\u0007\u0011\n!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#\u0001\u0002\u0013\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0015!\u0013a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t1A%A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012q\u0001J\u0001\u0017i\u0016\u001cH\u000fR3mKR,7)\u001c3BY2<%o\\;qg\"\u0012\u0001\u0002J\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005%!\u0013!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\tQA%\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u0017\u0011\n1\u0006^3ti\u0012+G.\u001a;f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0005\u0019\u0011bS\u0006")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"};
        this.getConsumerGroupService(cgcArgs);
    }

    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_4 = null;
        Object var6_5 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup};
        Map result = this.getConsumerGroupService(cgcArgs).deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var10_6 = null;
        Object var11_7 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString(), (output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assert.assertNotNull((String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString(), (Object)result.apply((Object)this.group()));
        Assert.assertTrue((String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString(), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("The group did not become empty as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var17_10 = null;
        Object var18_11 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (boolean)output.contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteCmdAllGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        var7_1 = 1;
        to$extension_end = 3;
        map_this = new Range.Inclusive(var7_1, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object var33_6 : map_this) {
            var12_7 = DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1(this, BoxesRunTime.unboxToInt((Object)var33_6));
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            var12_7 = null;
        }
        var9_3 = null;
        var10_4 = null;
        var11_5 = null;
        var12_7 = null;
        groups = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--all-groups"};
        service = this.getConsumerGroupService(cgcArgs);
        var15_11 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$2(service, groups)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        groups.values().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$5$adapted(kafka.admin.ConsumerGroupCommandTest$ConsumerGroupExecutor ), (Lkafka/admin/ConsumerGroupCommandTest$ConsumerGroupExecutor;)Ljava/lang/Object;)());
        var21_14 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$6(groups, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not become empty as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testDeleteCmdAllGroups$9(kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()V)((ConsumerGroupCommand.ConsumerGroupService)service);
        grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        var25_17 = null;
        var26_18 = null;
        output = grabConsoleOutput_out.toString().trim();
        expectedGroupsForDeletion = groups.keySet();
        map$extension_$this = StringOps$.MODULE$.split$extension(output.substring(output.indexOf(40) + 1, output.indexOf(41)), ',');
        map$extension_len = map$extension_$this.length;
        map$extension_ys = new String[map$extension_len];
        if (map$extension_len > 0) {
            for (map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                array_update_value = DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$10(map$extension_$this[map$extension_i]);
                map$extension_ys[map$extension_i] = array_update_value;
                var34_26 = null;
            }
        }
        var28_22 = null;
        var30_24 = null;
        v0 = Predef$.MODULE$.wrapRefArray(map$extension_ys);
        if (v0 == null) {
            throw null;
        }
        toSet_this = v0;
        var8_27 = null;
        deletedGroupsGrepped = IterableOnceOps.toSet$((IterableOnceOps)toSet_this);
        if (!output.matches("Deletion of requested consumer groups (.*) was successful.")) ** GOTO lbl-1000
        v1 = deletedGroupsGrepped;
        if (!(v1 != null ? v1.equals(expectedGroupsForDeletion) == false : expectedGroupsForDeletion != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Assert.assertTrue((String)"The consumer group(s) could not be deleted as expected", (boolean)v2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("The group did not become empty as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        void $plus$plus$extension_evidence$25;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("The group did not become empty as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = new String[]{"--group", missingGroup};
        Object var7_12 = null;
        classTag = null;
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)cgcArgs, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service2.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var21_14 = null;
        Object var22_15 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        void $plus$plus$extension_evidence$25;
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("The group did not initialize as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("The group did not become empty as expected.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = new String[]{"--group", missingGroup};
        Object var6_12 = null;
        classTag = null;
        Map result = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)cgcArgs, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25)).deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()};
        this.getConsumerGroupService(cgcArgs);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$2) {
        SeqOps seqOps = (SeqOps)((Option)service$2.collectGroupMembers($this.group(), false)._2()).get();
        if (seqOps == null) {
            throw null;
        }
        return seqOps.length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$3) {
        SeqOps seqOps = (SeqOps)((Option)service$3.collectGroupMembers($this.group(), false)._2()).get();
        if (seqOps == null) {
            throw null;
        }
        return seqOps.length() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        if (service$4.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$4.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        String string = service$4.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1(DeleteConsumerGroupsTest $this, int i) {
        String group = new StringBuilder(0).append($this.group()).append(i).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        return new Tuple2((Object)group, (Object)executor);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$3(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Stable";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$2(ConsumerGroupCommand.ConsumerGroupService service$5, scala.collection.immutable.Map groups$1) {
        Set set = service$5.listConsumerGroups().toSet();
        Set set2 = groups$1.keySet();
        return !(set != null ? !set.equals(set2) : set2 != null) && groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$3(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$4() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$7(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map groups$1, ConsumerGroupCommand.ConsumerGroupService service$5) {
        return groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$7(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$8() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ void $anonfun$testDeleteCmdAllGroups$9(ConsumerGroupCommand.ConsumerGroupService service$5) {
        service$5.deleteGroups();
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$10(String x$1) {
        return x$1.replaceAll("'", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        if (service$6.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$6.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        String string = service$6.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        if (service$7.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$7.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        String string = service$7.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        if (service$8.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$8.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        String string = service$8.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1$adapted(DeleteConsumerGroupsTest $this, Object i) {
        return DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeleteCmdAllGroups$5$adapted(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
        executor.shutdown();
        return BoxedUnit.UNIT;
    }
}

