/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.tools.TestRecord;
import kafka.tools.TestRecord$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Utils;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntegralProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class LogCompactionTester$ {
    public static final LogCompactionTester$ MODULE$ = new LogCompactionTester$();
    private static final int ReadAheadLimit = 4906;

    private int ReadAheadLimit() {
        return ReadAheadLimit;
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        void mkString_end;
        void mkString_sep;
        String string;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec numMessagesOpt = parser.accepts("messages", "The number of messages to send or consume.").withRequiredArg().describedAs("count").ofType(Long.class).defaultsTo((Object)Long.MAX_VALUE, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec messageCompressionOpt = parser.accepts("compression-type", "message compression type").withOptionalArg().describedAs("compressionType").ofType(String.class).defaultsTo((Object)"none", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec numDupsOpt = parser.accepts("duplicates", "The number of duplicates for each key.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)5, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec brokerOpt = parser.accepts("bootstrap-server", "The server(s) to connect to.").withRequiredArg().describedAs("url").ofType(String.class);
        ArgumentAcceptingOptionSpec topicsOpt = parser.accepts("topics", "The number of topics to test.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec percentDeletesOpt = parser.accepts("percent-deletes", "The percentage of updates that are deletes.").withRequiredArg().describedAs("percent").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec sleepSecsOpt = parser.accepts("sleep", "Time in milliseconds to sleep between production and consumption.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]);
        OptionSet options = parser.parse(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "A tool to test log compaction. Valid options are: ");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerOpt, numMessagesOpt}));
        long messages = (Long)options.valueOf((OptionSpec)numMessagesOpt);
        String compressionType = (String)options.valueOf((OptionSpec)messageCompressionOpt);
        int percentDeletes = (Integer)options.valueOf((OptionSpec)percentDeletesOpt);
        int dups = (Integer)options.valueOf((OptionSpec)numDupsOpt);
        String brokerUrl = (String)options.valueOf((OptionSpec)brokerOpt);
        int topicCount = (Integer)options.valueOf((OptionSpec)topicsOpt);
        int sleepSecs = (Integer)options.valueOf((OptionSpec)sleepSecsOpt);
        long testId = new Random().nextLong();
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, topicCount, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            String string2;
            String string3 = string2 = LogCompactionTester$.$anonfun$main$1(testId, BoxesRunTime.unboxToInt((Object)object));
            string2 = null;
            string = string3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var31_20 = null;
        Object var32_21 = null;
        Object var33_22 = null;
        string = null;
        Object[] topics = (String[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(String.class));
        this.createTopics(brokerUrl, (scala.collection.immutable.Seq<String>)ArrayOps$.MODULE$.toIndexedSeq$extension((Object)topics));
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray(topics);
        String string4 = ",";
        if (ofRef2 == null) {
            throw null;
        }
        ArraySeq.ofRef mkString_this = ofRef2;
        String string5 = "";
        String mkString_start = "";
        Object var41_30 = null;
        string5 = null;
        Object var29_28 = null;
        string4 = null;
        String println_x = new StringBuilder(31).append("Producing ").append(messages).append(" messages..to topics ").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_sep, (String)mkString_end)).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var35_31 = null;
        Path producedDataFilePath = this.produceMessages(brokerUrl, (String[])topics, messages, compressionType, dups, percentDeletes);
        String println_x2 = new StringBuilder(24).append("Sleeping for ").append(sleepSecs).append(" seconds...").toString();
        Console$.MODULE$.println((Object)println_x2);
        Object var36_33 = null;
        Thread.sleep(sleepSecs * 1000);
        String println_x3 = "Consuming messages...";
        Console$.MODULE$.println((Object)println_x3);
        Object var37_34 = null;
        Path consumedDataFilePath = this.consumeMessages(brokerUrl, (String[])topics);
        int producedLines = this.lineCount(producedDataFilePath);
        int consumedLines = this.lineCount(consumedDataFilePath);
        double reduction = (double)100 * (1.0 - (double)consumedLines / (double)producedLines);
        String println_x4 = StringOps$.MODULE$.format$extension("%d rows of data produced, %d rows of data consumed (%.1f%% reduction).", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{producedLines, consumedLines, reduction}));
        Console$.MODULE$.println((Object)println_x4);
        Object var38_39 = null;
        String println_x5 = "De-duplicating and validating output files...";
        Console$.MODULE$.println((Object)println_x5);
        Object var39_40 = null;
        this.validateOutput(producedDataFilePath.toFile(), consumedDataFilePath.toFile());
        Utils.delete((File)producedDataFilePath.toFile());
        Utils.delete((File)consumedDataFilePath.toFile());
        String println_x6 = "Data verification is completed";
        Console$.MODULE$.println((Object)println_x6);
    }

    /*
     * WARNING - void declaration
     */
    public void createTopics(String brokerUrl, scala.collection.immutable.Seq<String> topics) {
        Properties adminConfig = new Properties();
        adminConfig.put("bootstrap.servers", brokerUrl);
        try (Admin adminClient = Admin.create((Properties)adminConfig);){
            void apply_elems;
            void $minus$greater$extension_y;
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "compact";
            String $minus$greater$extension_$this = "cleanup.policy";
            Object var8_6 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            scala.collection.immutable.Map topicConfigs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
            List newTopics = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)topics.map((Function1 & Serializable)name -> new NewTopic(name, 1, (short)1).configs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)topicConfigs).asJava())))).asJava();
            adminClient.createTopics((Collection)newTopics).all().get();
            scala.collection.immutable.Seq cfr_ignored_0 = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                scala.collection.immutable.Seq $anonfun$createTopics$2_allTopics = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Set)((Set)adminClient.listTopics().names().get())).asScala().toSeq();
                scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)topics.filter((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)LogCompactionTester$.$anonfun$createTopics$3(allTopics, topicName)));
                Object var17_13 = null;
                if (!seq.isEmpty()) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                        throw Assertions$.MODULE$.fail(new StringBuilder(31).append("timed out waiting for topics : ").append(seq).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                    }
                    Thread.sleep(Math.min(l, l2));
                    continue;
                }
                break;
            }
        }
    }

    public int lineCount(Path filPath) {
        return Files.readAllLines(filPath).size();
    }

    public void validateOutput(File producedDataFile, File consumedDataFile) {
        BufferedReader producedReader = this.externalSort(producedDataFile);
        BufferedReader consumedReader = this.externalSort(consumedDataFile);
        Iterator<TestRecord> produced = this.valuesIterator(producedReader);
        Iterator<TestRecord> consumed = this.valuesIterator(consumedReader);
        File producedDedupedFile = new File(new StringBuilder(8).append(producedDataFile.getAbsolutePath()).append(".deduped").toString());
        BufferedWriter producedDeduped = Files.newBufferedWriter(producedDedupedFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        File consumedDedupedFile = new File(new StringBuilder(8).append(consumedDataFile.getAbsolutePath()).append(".deduped").toString());
        BufferedWriter consumedDeduped = Files.newBufferedWriter(consumedDedupedFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
        int total = 0;
        int mismatched = 0;
        while (produced.hasNext() && consumed.hasNext()) {
            TestRecord p = (TestRecord)produced.next();
            producedDeduped.write(p.toString());
            producedDeduped.newLine();
            TestRecord c = (TestRecord)consumed.next();
            consumedDeduped.write(c.toString());
            consumedDeduped.newLine();
            if (!((Object)p).equals(c)) {
                ++mismatched;
            }
            ++total;
        }
        producedDeduped.close();
        consumedDeduped.close();
        String println_x = new StringBuilder(31).append("Validated ").append(total).append(" values, ").append(mismatched).append(" mismatches.").toString();
        Console$.MODULE$.println((Object)println_x);
        Object var15_15 = null;
        if (!(!produced.hasNext())) {
            System.err.println(new StringBuilder(25).append("Data validation failed : ").append((Object)"Additional values produced not found in consumer log.").toString());
            throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
        }
        if (!(!consumed.hasNext())) {
            System.err.println(new StringBuilder(25).append("Data validation failed : ").append((Object)"Additional values consumed not found in producer log.").toString());
            throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
        }
        if (!(mismatched == 0)) {
            System.err.println(new StringBuilder(25).append("Data validation failed : ").append((Object)"Non-zero number of row mismatches.").toString());
            throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
        }
        Utils.delete((File)producedDedupedFile);
        Utils.delete((File)consumedDedupedFile);
    }

    public void require(boolean requirement, Function0<Object> message) {
        if (!requirement) {
            System.err.println(new StringBuilder(25).append("Data validation failed : ").append(message.apply()).toString());
            throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
        }
    }

    public Iterator<TestRecord> valuesIterator(BufferedReader reader) {
        return AsScalaExtensions.IteratorHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Iterator)new AbstractIterator<TestRecord>(reader){
            private final BufferedReader reader$1;

            /*
             * WARNING - void declaration
             */
            public TestRecord makeNext() {
                void var1_1;
                TestRecord next = LogCompactionTester$.MODULE$.readNext(this.reader$1);
                while (next != null && next.delete()) {
                    next = LogCompactionTester$.MODULE$.readNext(this.reader$1);
                }
                if (next == null) {
                    return (TestRecord)this.allDone();
                }
                return var1_1;
            }
            {
                this.reader$1 = reader$1;
            }
        }).asScala();
    }

    public TestRecord readNext(BufferedReader reader) {
        String line = reader.readLine();
        if (line == null) {
            return null;
        }
        TestRecord curr = TestRecord$.MODULE$.parse(line);
        while (true) {
            TestRecord next;
            block7: {
                block6: {
                    if ((line = this.peekLine(reader)) == null) {
                        return curr;
                    }
                    next = TestRecord$.MODULE$.parse(line);
                    if (next == null) break block6;
                    String string = next.topicAndKey();
                    String string2 = curr.topicAndKey();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block7;
                }
                return curr;
            }
            curr = next;
            reader.readLine();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String peekLine(BufferedReader reader) {
        void var2_2;
        reader.mark(this.ReadAheadLimit());
        String line = reader.readLine();
        reader.reset();
        return var2_2;
    }

    public BufferedReader externalSort(File file) {
        Process process = new ProcessBuilder("sort", "--key=1,2", "--stable", "--buffer-size=20%", new StringBuilder(22).append("--temporary-directory=").append(Files.createTempDirectory("log_compaction_test", new FileAttribute[0])).toString(), file.getAbsolutePath()).start();
        new Thread(process){
            private final Process process$1;

            public void run() {
                if (this.process$1.waitFor() != 0) {
                    System.err.println("Process exited abnormally.");
                    while (this.process$1.getErrorStream().available() > 0) {
                        System.err.write(this.process$1.getErrorStream().read());
                    }
                }
            }
            {
                this.process$1 = process$1;
            }
        }.start();
        return new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8), 0xA00000);
    }

    public Path produceMessages(String brokerUrl, String[] topics, long messages, String compressionType, int dups, int percentDeletes) {
        Path path;
        Properties producerProps = new Properties();
        producerProps.setProperty("max.block.ms", ((Object)Long.MAX_VALUE).toString());
        producerProps.setProperty("bootstrap.servers", brokerUrl);
        producerProps.setProperty("compression.type", compressionType);
        try (KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            Random rand = new Random(1L);
            int keyCount = (int)(messages / (long)dups);
            Path producedFilePath = Files.createTempFile("kafka-log-cleaner-produced-", ".txt", new FileAttribute[0]);
            String println_x = new StringBuilder(28).append("Logging produce requests to ").append(producedFilePath).toString();
            Console$.MODULE$.println((Object)println_x);
            Object var15_12 = null;
            BufferedWriter producedWriter = Files.newBufferedWriter(producedFilePath, StandardCharsets.UTF_8, new OpenOption[0]);
            IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)(messages * (long)topics.length)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)i -> {
                String topic = topics[(int)(i % (long)topics.length)];
                int key = rand.nextInt(keyCount);
                boolean delete = i % 100L < (long)percentDeletes;
                ProducerRecord msg = delete ? new ProducerRecord(topic, (Object)((Object)key).toString().getBytes(StandardCharsets.UTF_8), null) : new ProducerRecord(topic, (Object)((Object)key).toString().getBytes(StandardCharsets.UTF_8), (Object)((Object)i).toString().getBytes(StandardCharsets.UTF_8));
                producer.send(msg);
                producedWriter.write(new TestRecord(topic, key, i, delete).toString());
                producedWriter.newLine();
            });
            producedWriter.close();
            path = producedFilePath;
        }
        return path;
    }

    public KafkaConsumer<String, String> createConsumer(String brokerUrl) {
        Properties consumerProps = new Properties();
        consumerProps.setProperty("group.id", new StringBuilder(17).append("log-cleaner-test-").append(new Random().nextInt(Integer.MAX_VALUE)).toString());
        consumerProps.setProperty("bootstrap.servers", brokerUrl);
        consumerProps.setProperty("auto.offset.reset", "earliest");
        return new KafkaConsumer(consumerProps, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
    }

    public Path consumeMessages(String brokerUrl, String[] topics) {
        Path path;
        KafkaConsumer<String, String> consumer = this.createConsumer(brokerUrl);
        consumer.subscribe(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)ArrayOps$.MODULE$.toIndexedSeq$extension((Object)topics)).asJava());
        Path consumedFilePath = Files.createTempFile("kafka-log-cleaner-consumed-", ".txt", new FileAttribute[0]);
        String println_x = new StringBuilder(29).append("Logging consumed messages to ").append(consumedFilePath).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var9_5 = null;
        BufferedWriter consumedWriter = Files.newBufferedWriter(consumedFilePath, StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            boolean done = false;
            while (!done) {
                ConsumerRecords consumerRecords = consumer.poll(Duration.ofSeconds(20L));
                if (!consumerRecords.isEmpty()) {
                    AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)consumerRecords).asScala().foreach((Function1 & Serializable)record -> {
                        LogCompactionTester$.$anonfun$consumeMessages$1(consumedWriter, record);
                        return BoxedUnit.UNIT;
                    });
                    continue;
                }
                done = true;
            }
            path = consumedFilePath;
        }
        finally {
            consumedWriter.close();
            consumer.close();
        }
        return path;
    }

    public String readString(ByteBuffer buffer) {
        return Utils.utf8((ByteBuffer)buffer);
    }

    public static final /* synthetic */ String $anonfun$main$1(long testId$1, int x$1) {
        return new StringBuilder(18).append("log-cleaner-test-").append(testId$1).append("-").append(x$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$3(scala.collection.immutable.Seq allTopics$1, String topicName) {
        return !allTopics$1.contains((Object)topicName);
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$2(Admin adminClient$1, ObjectRef pendingTopics$1, scala.collection.immutable.Seq topics$1) {
        scala.collection.immutable.Seq allTopics = AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Set)((Set)adminClient$1.listTopics().names().get())).asScala().toSeq();
        pendingTopics$1.elem = (scala.collection.immutable.Seq)topics$1.filter((Function1 & Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)LogCompactionTester$.$anonfun$createTopics$3(allTopics, topicName)));
        return ((scala.collection.immutable.Seq)pendingTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$createTopics$4(ObjectRef pendingTopics$1) {
        return new StringBuilder(31).append("timed out waiting for topics : ").append((scala.collection.immutable.Seq)pendingTopics$1.elem).toString();
    }

    public static final /* synthetic */ String $anonfun$validateOutput$1() {
        return "Additional values produced not found in consumer log.";
    }

    public static final /* synthetic */ String $anonfun$validateOutput$2() {
        return "Additional values consumed not found in producer log.";
    }

    public static final /* synthetic */ String $anonfun$validateOutput$3() {
        return "Non-zero number of row mismatches.";
    }

    public static final /* synthetic */ void $anonfun$consumeMessages$1(BufferedWriter consumedWriter$1, ConsumerRecord record) {
        long l;
        boolean delete;
        boolean bl = delete = record.value() == null;
        if (delete) {
            l = -1L;
        } else {
            String toLong$extension_$this = (String)record.value();
            l = Long.parseLong(toLong$extension_$this);
            Object var5_3 = null;
        }
        long value = l;
        consumedWriter$1.write(new TestRecord(record.topic(), Integer.parseInt((String)record.key()), value, delete).toString());
        consumedWriter$1.newLine();
    }

    private LogCompactionTester$() {
    }

    public static final /* synthetic */ String $anonfun$main$1$adapted(long testId$1, Object x$1) {
        return LogCompactionTester$.$anonfun$main$1(testId$1, BoxesRunTime.unboxToInt((Object)x$1));
    }
}

