/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055h!B\u0012%\u0003\u0003I\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003F\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011C9\t\ri\u0004\u0001\u0015!\u0003s\u0011\u001dY\bA1A\u0005\nqDq!!\u0001\u0001A\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0002\"CA-\u0001E\u0005I\u0011CA.\u0011%\t\t\bAI\u0001\n#\tY\u0006C\u0005\u0002t\u0001\t\n\u0011\"\u0005\u0002\\!I\u0011Q\u000f\u0001\u0012\u0002\u0013E\u0011q\u000f\u0005\n\u0003w\u0002\u0011\u0013!C\t\u0003{B\u0011\"!!\u0001#\u0003%\t\"! \t\u000f\u0005\r\u0005\u0001\"\u0005\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0001bBAR\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003O\u0003A\u0011AA\u0003\u0011\u001d\tY\u000b\u0001C\t\u0003[C\u0011\"a.\u0001#\u0003%\t\"a\u0017\t\u0013\u0005e\u0006!%A\u0005\u0012\u0005u\u0004bBA^\u0001\u0011E\u0011Q\u0018\u0005\b\u0003+\u0004A\u0011AA\u0003\u0011\u001d\tI\u000e\u0001C\u0001\u0003\u000bAq!!8\u0001\t\u0003\t)\u0001C\u0004\u0002b\u0002!\t!!\u0002\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u001e\u0001\u0005\u0002\u0005\u0015!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00020Y\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00017!\r9DHP\u0007\u0002q)\u0011\u0011HO\u0001\u000bG>dG.Z2uS>t'\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uB$aA*fcB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0003%aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8ogVlWM]\u000b\u0002\rB!q\t\u0015*S\u001b\u0005A%B\u0001#J\u0015\tQ5*A\u0004dY&,g\u000e^:\u000b\u0005\u001db%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\r\u0019FKV\u0007\u0002u%\u0011QK\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'^K!\u0001\u0017\u001e\u0003\t\tKH/Z\u0001\rG>t7/^7fe~#S-\u001d\u000b\u00037z\u0003\"a\u0015/\n\u0005uS$\u0001B+oSRDqa\u0018\u0003\u0002\u0002\u0003\u0007a)A\u0002yIE\n\u0011bY8ogVlWM\u001d\u0011\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1\u0007(A\u0004nkR\f'\r\\3\n\u0005!,'A\u0002\"vM\u001a,'\u000f\u0005\u0003k[J\u0013V\"A6\u000b\u00051L\u0015\u0001\u00039s_\u0012,8-\u001a:\n\u00059\\'!D&bM.\f\u0007K]8ek\u000e,'/\u0001\u0006qe>$WoY3sg\u0002\nQ\u0001^8qS\u000e,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\u0005i\bCA*\u007f\u0013\ty(HA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005)1/\u001a;VaR\t1\fK\u0002\r\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fq\u0015!\u00026v]&$\u0018\u0002BA\n\u0003\u001b\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u00075\tI\u0002\u0005\u0003\u0002\f\u0005m\u0011\u0002BA\u000f\u0003\u001b\u0011Q!\u00114uKJ\fab\u0019:fCR,\u0007K]8ek\u000e,'\u000fF\bj\u0003G\tY$a\u0010\u0002D\u0005\u001d\u00131JA+\u0011\u001d\t)C\u0004a\u0001\u0003O\t!B\u0019:pW\u0016\u0014H*[:u!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[QTBAA\u0018\u0015\r\t\t\u0004K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\"(\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u0006e\"bAA\u001bu!A\u0011Q\b\b\u0011\u0002\u0003\u0007Q0\u0001\u0005mS:<WM]'t\u0011!\t\tE\u0004I\u0001\u0002\u0004i\u0018!\u00053fY&4XM]=US6,w.\u001e;Ng\"A\u0011Q\t\b\u0011\u0002\u0003\u0007Q0A\u0005cCR\u001c\u0007nU5{K\"I\u0011\u0011\n\b\u0011\u0002\u0003\u0007\u0011qE\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qK\"I\u0011Q\n\b\u0011\u0002\u0003\u0007\u0011qJ\u0001\u000b[\u0006D(\t\\8dW6\u001b\bcA*\u0002R%\u0019\u00111\u000b\u001e\u0003\t1{gn\u001a\u0005\n\u0003/r\u0001\u0013!a\u0001\u0003\u001f\n!BY;gM\u0016\u00148+\u001b>f\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003;R3!`A0W\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA6u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0014Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002z)\"\u0011qEA0\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u007fRC!a\u0014\u0002`\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014HcA5\u0002\b\")A.\u0006a\u0001S\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$\bf\u0001\f\u0002\u000eB!\u00111BAH\u0013\u0011\t\t*!\u0004\u0003\tQ+7\u000f\u001e\u0015\b-\u0005U\u0015QTAP!\u0011\t9*!'\u000e\u0005\u0005%\u0014\u0002BAN\u0003S\u0012aA\\8xCJt\u0017!\u0002<bYV,\u0017EAAQ\u0003=\u0019\u0017\r^\u001feKB\u0014XmY1uS>t\u0017a\n;fgR\u001cVM\u001c3D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016D3aFAG\u0003)\"Xm\u001d;TK:$gj\u001c8D_6\u0004(/Z:tK\u0012lUm]:bO\u0016<\u0016\u000e\u001e5De\u0016\fG/\u001a+j[\u0016D3\u0001GAG\u00035\u0019XM\u001c3B]\u00124VM]5gsR91,a,\u00022\u0006M\u0006\"\u00027\u001a\u0001\u0004I\u0007bB>\u001a!\u0003\u0005\r! \u0005\n\u0003kK\u0002\u0013!a\u0001\u0003\u001f\n\u0011\u0002^5nK>,H/T:\u0002/M,g\u000eZ!oIZ+'/\u001b4zI\u0011,g-Y;mi\u0012\u0012\u0014aF:f]\u0012\fe\u000e\u001a,fe&4\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003Y\u0019XM\u001c3B]\u00124VM]5gsRKW.Z:uC6\u0004H#B.\u0002@\u0006\u0005\u0007\"\u00027\u001d\u0001\u0004I\u0007bBAb9\u0001\u0007\u0011QY\u0001\u000ei&lWm\u001d;b[B$\u0016\u0010]3\u0011\t\u0005\u001d\u0017\u0011[\u0007\u0003\u0003\u0013TA!a3\u0002N\u00061!/Z2pe\u0012T1!a4L\u0003\u0019\u0019w.\\7p]&!\u00111[Ae\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\u0006IA/Z:u\u00072|7/\u001a\u0015\u0004;\u00055\u0015a\u0005;fgR\u001cVM\u001c3U_B\u000b'\u000f^5uS>t\u0007f\u0001\u0010\u0002\u000e\u0006AC/Z:u'\u0016tGMQ3g_J,\u0017I\u001c3BMR,'\u000fU1si&$\u0018n\u001c8FqB\fgn]5p]\"\u001aq$!$\u0002\u0013Q,7\u000f\u001e$mkND\u0007f\u0001\u0011\u0002\u000e\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7)\u00197mKJ$\u0006N]3bI\"\u001a\u0011%!$\u0002QQ,7\u000f^\"m_N,w+\u001b;i5\u0016\u0014x\u000eV5nK>,HO\u0012:p[N+g\u000eZ3s)\"\u0014X-\u00193)\u0007\t\ni\t")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Map map;
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), ((Object)4).toString());
        String x$2 = this.zkConnect();
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Map map2 = map = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        map = null;
        Map x$12 = map2;
        int n = 1;
        boolean bl6 = false;
        int n2 = 1;
        short s = 1;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, false, bl, (Option<SecurityProtocol>)x$4, x$5, x$6, bl2, bl3, bl4, bl5, (Map<Object, String>)x$12, n, bl6, n2, s).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps));
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        String string;
        String string2;
        super.setUp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String string3 = string2 = "group";
        string2 = null;
        String x$3 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$4 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
    }

    @Override
    @After
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        ByteArraySerializer byteArraySerializer;
        ByteArraySerializer byteArraySerializer2;
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = 20000;
        ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
        byteArraySerializer2 = null;
        ByteArraySerializer x$14 = byteArraySerializer3;
        ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
        byteArraySerializer = null;
        ByteArraySerializer x$15 = byteArraySerializer4;
        boolean bl = false;
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, n, maxBlockMs, bufferSize, n2, deliveryTimeoutMs, lingerMs, batchSize, compressionType, n3, x$3, x$4, x$5, x$14, x$15, bl);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public long createProducer$default$7() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        Buffer<KafkaProducer<byte[], byte[]>> buffer = this.producers();
        if (buffer == null) {
            throw null;
        }
        buffer.addOne(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            Integer n;
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Integer.valueOf(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Integer.valueOf(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            Integer n2 = n = Integer.valueOf(partition);
            n = null;
            ProducerRecord record2 = new ProducerRecord(this.topic(), n2, null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Integer.valueOf(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.callback$2(callback$module, partition));
                throw Assertions$.MODULE$.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                int n3 = 1;
                int to$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
                Range.Inclusive foreach_this = new Range.Inclusive(n3, to$extension_end, 1);
                if (!foreach_this.isEmpty()) {
                    int foreach_i = foreach_this.start();
                    while (true) {
                        producer.send(record0, (Callback)this.callback$2(callback$module, partition));
                        if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                        foreach_i += foreach_this.step();
                    }
                }
                Object var11_12 = null;
                Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$1 = this.brokerList();
        int x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        long x$7 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, Integer.MAX_VALUE, Integer.MAX_VALUE, x$5, "gzip", x$6, x$7);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    /*
     * WARNING - void declaration
     */
    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            IndexedSeq indexedSeq;
            Future future2;
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            int n = 1;
            Range.Inclusive map_this = new Range.Inclusive(n, numRecords, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future3;
                Future future4 = future3 = BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)object));
                future3 = null;
                future2 = future4;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future2 = null;
            }
            IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
            Object var10_6 = null;
            Object var11_7 = null;
            Object var12_8 = null;
            future2 = null;
            indexedSeq = null;
            IndexedSeq futures = indexedSeq2;
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)0, (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    /*
     * WARNING - void declaration
     */
    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            IndexedSeq indexedSeq;
            Tuple2 tuple2;
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
            } else {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            }
            this.createTopic(this.topic(), 1, 2, topicProps);
            int n = 1;
            int to$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Tuple2 tuple22;
                Tuple2 tuple23 = tuple22 = BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)object));
                tuple22 = null;
                tuple2 = tuple23;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                tuple2 = null;
            }
            IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
            Object var14_11 = null;
            Object var15_12 = null;
            Object var16_13 = null;
            tuple2 = null;
            indexedSeq = null;
            IndexedSeq recordAndFutures = indexedSeq2;
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            int n = 1;
            int to$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Inclusive foreach_this = new Range.Inclusive(n, to$extension_end, 1);
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    producer.send(record0);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach_i += foreach_this.step();
                }
            }
            Object var6_5 = null;
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            Future future;
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            int n = 1;
            int to$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future2;
                Future future3 = future2 = BaseProducerSendTest.$anonfun$testSendToPartition$1(this, producer, partition, now, BoxesRunTime.unboxToInt((Object)object));
                future2 = null;
                future = future3;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future = null;
            }
            Object var8_6 = null;
            Object var9_7 = null;
            Object var10_8 = null;
            future = null;
            int n2 = 0;
            int until$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
            ((IterableOps)((IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)x$6 -> (RecordMetadata)x$6.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)new Range.Exclusive(n2, until$extension_end, 1))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$7);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableOnceOps)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        Future future;
        String x$1 = this.brokerList();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        int x$5 = this.createProducer$default$4();
        String x$6 = this.createProducer$default$5();
        long x$7 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$5, x$6, 5000L, x$7);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        int n = 1;
        int to$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3 = future2 = BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$1(this, producer, partition0, BoxesRunTime.unboxToInt((Object)object));
            future2 = null;
            future = future3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var28_11 = null;
        Object var29_12 = null;
        Object var30_13 = null;
        future = null;
        int n2 = 0;
        int until$extension_end = this.kafka$api$BaseProducerSendTest$$numRecords();
        ((IterableOps)((IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)x$8 -> (RecordMetadata)x$8.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)new Range.Exclusive(n2, until$extension_end, 1))).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$9 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$9);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        try {
            Integer n3;
            Integer n4 = n3 = Integer.valueOf(partition1);
            n3 = null;
            producer.send(new ProducerRecord(this.topic(), n4, null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw Assertions$.MODULE$.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        }
        catch (ExecutionException executionException) {
            Future future4;
            Future future5;
            void apply_elems;
            Throwable throwable = executionException.getCause();
            if (!(throwable instanceof TimeoutException)) {
                throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
            }
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                Integer n;
                Integer n2;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
                Integer n3 = n2 = Integer.valueOf(topicPartition.partition());
                n2 = null;
                Integer n4 = n = n3;
                n = null;
                Integer $minus$greater$extension_$this = n4;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                Object var4_5 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            });
            AdminZkClient qual$1 = this.adminZkClient();
            String x$102 = this.topic();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$82 = qual$2.getBrokerMetadatas$default$1();
            Option x$92 = qual$2.getBrokerMetadatas$default$2();
            Seq x$122 = qual$2.getBrokerMetadatas(x$82, x$92);
            Option x$14 = qual$1.addPartitions$default$5();
            boolean x$15 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$102, existingAssignment, x$122, 2, x$14, x$15);
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, 15000L);
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, 15000L);
            int n5 = 1;
            int to$extension_end2 = this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Inclusive map_this2 = new Range.Inclusive(n5, to$extension_end2, 1);
            map_this2.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this2) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future6;
                Future future7 = future6 = BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$6(this, producer, partition1, BoxesRunTime.unboxToInt((Object)object));
                future6 = null;
                future5 = future7;
                if (map_strictOptimizedMap_b2 == null) {
                    throw null;
                }
                map_strictOptimizedMap_b2.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future5 = null;
            }
            Object var32_34 = null;
            Object var33_35 = null;
            Object var34_36 = null;
            future5 = null;
            int n6 = 0;
            int until$extension_end2 = this.kafka$api$BaseProducerSendTest$$numRecords();
            ((IterableOps)((IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b2.result()).map((Function1 & Serializable)x$10 -> (RecordMetadata)x$10.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)new Range.Exclusive(n6, until$extension_end2, 1))).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$11 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$11);
                return BoxedUnit.UNIT;
            });
            int n7 = 1;
            int to$extension_end3 = this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Inclusive map_this3 = new Range.Inclusive(n7, to$extension_end3, 1);
            map_this3.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b3 = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this3) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future8;
                Future future9 = future8 = BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$10(this, producer, partition0, BoxesRunTime.unboxToInt((Object)object));
                future8 = null;
                future4 = future9;
                if (map_strictOptimizedMap_b3 == null) {
                    throw null;
                }
                map_strictOptimizedMap_b3.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future4 = null;
            }
            Object var36_44 = null;
            Object var37_45 = null;
            Object var38_46 = null;
            future4 = null;
            int n8 = this.kafka$api$BaseProducerSendTest$$numRecords();
            int until$extension_end3 = 2 * this.kafka$api$BaseProducerSendTest$$numRecords();
            ((IterableOps)((IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b3.result()).map((Function1 & Serializable)x$12 -> (RecordMetadata)x$12.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)new Range.Exclusive(n8, until$extension_end3, 1))).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable)x$13 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$13);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            int n = 0;
            int until$extension_end = 50;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    BaseProducerSendTest.$anonfun$testFlush$1(this, producer, record, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var5_5 = null;
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        Integer n;
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        Integer n2 = n = Integer.valueOf(partition);
        n = null;
        ProducerRecord record0 = new ProducerRecord(this.topic(), n2, null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        int n3 = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n3, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$1(this, record0, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        Integer n;
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        Integer n2 = n = Integer.valueOf(partition);
        n = null;
        ProducerRecord record = new ProducerRecord(this.topic(), n2, null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        int n3 = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach_this = new Range.Exclusive(n3, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Integer.valueOf(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$2, (long)recordMetadata.partition());
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Integer.valueOf(partition$3), Long.valueOf(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assert.assertEquals((Object)record.timestamp(), (Object)recordMetadata.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Future $anonfun$testSendToPartition$1(BaseProducerSendTest $this, KafkaProducer producer$5, int partition$4, long now$1, int i) {
        Long l;
        Long l2 = l = Long.valueOf(now$1);
        l = null;
        return producer$5.send(new ProducerRecord($this.topic(), Integer.valueOf(partition$4), l2, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8)));
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$7) {
        if (x$7 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$7._1();
            Assert.assertEquals((long)x$7._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition$4, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assert.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assert.assertEquals((long)partition$4, (long)record.partition());
            Assert.assertEquals((long)i, (long)record.offset());
            Assert.assertNull((Object)record.key());
            Assert.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$1(BaseProducerSendTest $this, KafkaProducer producer$6, int partition0$1, int i) {
        Integer n;
        Integer n2 = n = Integer.valueOf(partition0$1);
        n = null;
        return producer$6.send(new ProducerRecord($this.topic(), n2, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8)));
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$9) {
        if (x$9 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$9._1();
            Assert.assertEquals((long)x$9._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$6(BaseProducerSendTest $this, KafkaProducer producer$6, int partition1$1, int i) {
        Integer n;
        Integer n2 = n = Integer.valueOf(partition1$1);
        n = null;
        return producer$6.send(new ProducerRecord($this.topic(), n2, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8)));
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$11) {
        if (x$11 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$11._1();
            Assert.assertEquals((long)x$11._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition1$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$10(BaseProducerSendTest $this, KafkaProducer producer$6, int partition0$1, int i) {
        Integer n;
        Integer n2 = n = Integer.valueOf(partition0$1);
        n = null;
        return producer$6.send(new ProducerRecord($this.topic(), n2, null, (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8)));
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$13) {
        if (x$13 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$13._1();
            Assert.assertEquals((long)x$13._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$15) {
        return !x$15.isDone();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testFlush$1(BaseProducerSendTest $this, KafkaProducer producer$7, ProducerRecord record$1, int x$17) {
        IndexedSeq indexedSeq;
        Future future;
        int n = 0;
        int until$extension_end = $this.kafka$api$BaseProducerSendTest$$numRecords();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            Future future4 = future3 = producer$7.send(record$1);
            future3 = null;
            Future future5 = future2 = future4;
            future2 = null;
            future = future5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        future = null;
        indexedSeq = null;
        IndexedSeq responses = indexedSeq2;
        Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$15))));
        producer$7.flush();
        Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isDone())));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$19) {
        return !x$19.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        try {
            future.get();
            throw Assertions$.MODULE$.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$1(BaseProducerSendTest $this, ProducerRecord record0$3, int x$20) {
        IndexedSeq indexedSeq;
        Future future2;
        KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6(), $this.createProducer$default$7());
        int n = 0;
        int until$extension_end = $this.kafka$api$BaseProducerSendTest$$numRecords();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future3;
            Future future4;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            Future future5 = future4 = producer.send(record0$3);
            future4 = null;
            Future future6 = future3 = future5;
            future3 = null;
            future2 = future6;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future2 = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        future2 = null;
        indexedSeq = null;
        IndexedSeq responses = indexedSeq2;
        Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$19))));
        producer.close(Duration.ZERO);
        responses.foreach((Function1 & Serializable)future -> {
            BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)$this.consumer().poll(Duration.ofMillis(50L)).count());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    int n = 0;
                    int until$extension_end = this.$outer.kafka$api$BaseProducerSendTest$$numRecords();
                    Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
                    if (!foreach_this.isEmpty()) {
                        int foreach_i = foreach_this.start();
                        while (true) {
                            Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, foreach_i);
                            if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                            foreach_i += foreach_this.step();
                        }
                    }
                    Object var4_5 = null;
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$21) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1$adapted(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, Object x$21) {
                return Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1($this, BoxesRunTime.unboxToInt((Object)x$21));
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$22) {
        return !x$22.isDone();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6(), $this.createProducer$default$7());){
            IndexedSeq indexedSeq;
            Future future;
            int n = 0;
            int until$extension_end = $this.kafka$api$BaseProducerSendTest$$numRecords();
            Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            for (Object object : map_this) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Future future2;
                Future future3 = future2 = BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)object));
                future2 = null;
                future = future3;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                future = null;
            }
            IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
            Object var7_6 = null;
            Object var8_7 = null;
            Object var9_8 = null;
            future = null;
            indexedSeq = null;
            IndexedSeq responses = indexedSeq2;
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$22))));
            producer.flush();
            Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isDone())));
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L);
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }

    public static final /* synthetic */ Future $anonfun$testSendOffset$1$adapted(BaseProducerSendTest $this, KafkaProducer producer$1, ProducerRecord record0$1, LazyRef callback$module$1, int partition$1, Object x$4) {
        return producer$1.send(record0$1, (Callback)$this.callback$2(callback$module$1, partition$1));
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1$adapted(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, Object i) {
        return BaseProducerSendTest.$anonfun$sendAndVerify$1($this, partition$2, producer$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1$adapted(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, Object i) {
        return BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1($this, partition$3, baseTimestamp$1, producer$3, callback$module$2, timestampType$1, startTime$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testClose$1$adapted(KafkaProducer producer$4, ProducerRecord record0$2, Object x$5) {
        return producer$4.send(record0$2);
    }

    public static final /* synthetic */ Future $anonfun$testSendToPartition$1$adapted(BaseProducerSendTest $this, KafkaProducer producer$5, int partition$4, long now$1, Object i) {
        return BaseProducerSendTest.$anonfun$testSendToPartition$1($this, producer$5, partition$4, now$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$1$adapted(BaseProducerSendTest $this, KafkaProducer producer$6, int partition0$1, Object i) {
        return BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$1($this, producer$6, partition0$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$6$adapted(BaseProducerSendTest $this, KafkaProducer producer$6, int partition1$1, Object i) {
        return BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$6($this, producer$6, partition1$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testSendBeforeAndAfterPartitionExpansion$10$adapted(BaseProducerSendTest $this, KafkaProducer producer$6, int partition0$1, Object i) {
        return BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$10($this, producer$6, partition0$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1$adapted(BaseProducerSendTest $this, ProducerRecord record$2, Object i) {
        return BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1($this, record$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Future $anonfun$testFlush$2$adapted(KafkaProducer producer$7, ProducerRecord record$1, Object x$14) {
        return producer$7.send(record$1);
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromCallerThread$2$adapted(KafkaProducer producer$8, ProducerRecord record0$3, Object x$18) {
        return producer$8.send(record0$3);
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2$adapted(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, Object i) {
        return BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer$9, record$2, BoxesRunTime.unboxToInt((Object)i));
    }
}

