/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\ra\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CQA\u0014\u0001\u0005\u0002=Cqa\u0018\u0001A\u0002\u0013\u0005\u0001\rC\u0005\u0002B\u0002\u0001\r\u0011\"\u0001\u0002D\"9\u0011q\u0019\u0001!B\u0013\t\u0007bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u0003+\u0004A\u0011IAU\u0011%\ty\u000e\u0001b\u0001\n\u0003\t\t\u000f\u0003\u0005\u0002v\u0002\u0001\u000b\u0011BAr\u0011\u001d\t9\u0010\u0001C\u0001\u0003SCqA!\u0001\u0001\t\u0003\tI\u000bC\u0004\u0003\u0006\u0001!\t!!+\t\u000f\t%\u0001\u0001\"\u0001\u0002*\"9!Q\u0002\u0001\u0005\u0002\u0005%\u0006b\u0002B\t\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005+\u0001A\u0011\u0002B\f\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u000b\u0001\t\u0003\tI\u000bC\u0004\u0003.\u0001!IAa\f\t\u000f\t]\u0003\u0001\"\u0003\u0003Z!9!Q\u0006\u0001\u0005\n\t\u0015\u0004b\u0002B,\u0001\u0011%!Q\u000f\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u0011y\b\u0001C\u0005\u0005+CqA!(\u0001\t\u0013\u0011yJ\u0002\u0004\u0003H\u0002\u0001!\u0011\u001a\u0005\u000b\u0005#T\"\u0011!Q\u0001\n\tM\u0007B\u0003Bm5\t\u0015\r\u0011\"\u0001\u0003\\\"Q!Q\u001c\u000e\u0003\u0002\u0003\u0006I!a\u0007\t\r)SB\u0011\u0001Bp\u0011%\u00119O\u0007b\u0001\n\u0003\u0011I\u000f\u0003\u0005\u0003rj\u0001\u000b\u0011\u0002Bv\u0011%\u0011\u0019P\u0007b\u0001\n\u0003\u0011)\u0010\u0003\u0005\u0003~j\u0001\u000b\u0011\u0002B|\u0011%\u0011yP\u0007b\u0001\n\u0003\u0011)\u0010\u0003\u0005\u0004\u0002i\u0001\u000b\u0011\u0002B|\r\u0011\u0019\u0007\u0001\u00013\t\u0011M,#Q1A\u0005\u0002QD\u0011\"!\u0002&\u0005\u0003\u0005\u000b\u0011B;\t\r)+C\u0011AA\u0004\u0011%\tY!\nb\u0001\n\u0003\ti\u0001\u0003\u0005\u0002(\u0015\u0002\u000b\u0011BA\b\u0011%\tI#\nb\u0001\n\u0003\tY\u0003\u0003\u0005\u00028\u0015\u0002\u000b\u0011BA\u0017\u0011%\tI$\nb\u0001\n\u0003\tY\u0004\u0003\u0005\u0002V\u0015\u0002\u000b\u0011BA\u001f\u0011%\t9&\na\u0001\n\u0003\tI\u0006C\u0005\u0002n\u0015\u0002\r\u0011\"\u0001\u0002p!A\u00111P\u0013!B\u0013\tY\u0006\u0003\u0005\u0002~\u0015\u0002\r\u0011\"\u0001u\u0011%\ty(\na\u0001\n\u0003\t\t\tC\u0004\u0002\u0006\u0016\u0002\u000b\u0015B;\t\u0013\u0005\u001dU\u00051A\u0005\u0002\u0005%\u0005\"CAPK\u0001\u0007I\u0011AAQ\u0011!\t)+\nQ!\n\u0005-\u0005bBATK\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003W+C\u0011AAU\u0011\u001d\ti+\nC\u0001\u0003SCq!a,&\t\u0003\t\t\fC\u0004\u0002@\u0016\"\t%!+\u0003CI+\u0017m]:jO:\u0004\u0016M\u001d;ji&|gn]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005}\u0002\u0015!B1e[&t'\"A!\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0002\u000b!A_6\n\u0005%3%\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011Q\nA\u0007\u0002}\u0005iq\r\\8cC2$\u0016.\\3pkR,\u0012\u0001\u0015\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000bQA];mKNT!!\u0016,\u0002\u000b),h.\u001b;\u000b\u0003]\u000b1a\u001c:h\u0013\tI&KA\u0004US6,w.\u001e;)\u0005\tY\u0006C\u0001/^\u001b\u0005!\u0016B\u00010U\u0005\u0011\u0011V\u000f\\3\u0002\u000f\rdWo\u001d;feV\t\u0011\r\u0005\u0002cK5\t\u0001AA\u000fSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u00072,8\u000f^3s'\r)S-\u001c\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017B\u00017h\u0005\u0019y%M[3diB\u0011a.]\u0007\u0002_*\u0011\u0001/[\u0001\u0003S>L!A]8\u0003\u0013\rcwn]3bE2,\u0017!\u0003>l\u0007>tg.Z2u+\u0005)\bC\u0001<\u0000\u001d\t9X\u0010\u0005\u0002yw6\t\u0011P\u0003\u0002{\u0005\u00061AH]8pizR\u0011\u0001`\u0001\u0006g\u000e\fG.Y\u0005\u0003}n\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@|\u0003)Q8nQ8o]\u0016\u001cG\u000f\t\u000b\u0004C\u0006%\u0001\"B:)\u0001\u0004)\u0018a\u00022s_.,'o]\u000b\u0003\u0003\u001f\u0001\u0002\"!\u0005\u0002\u0018\u0005m\u00111E\u0007\u0003\u0003'Q1!!\u0006|\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\t\u0019BA\u0002NCB\u0004B!!\b\u0002 5\t10C\u0002\u0002\"m\u00141!\u00138u!\r1\u0017QE\u0005\u0004\u0003\u00039\u0017\u0001\u00032s_.,'o\u001d\u0011\u0002\rQ|\u0007/[2t+\t\ti\u0003\u0005\u0005\u0002\u0012\u0005]\u00111EA\u0018!\u0019\t\t\"!\r\u00026%!\u00111GA\n\u0005\r\u0019V-\u001d\t\u0007\u0003#\t\t$a\u0007\u0002\u000fQ|\u0007/[2tA\u0005i!M]8lKJ\u001cuN\u001c4jON,\"!!\u0010\u0011\r\u0005}\u0012QIA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005M\u0011aB7vi\u0006\u0014G.Z\u0005\u0005\u0003\u000f\n\tE\u0001\u0004Ck\u001a4WM\u001d\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ5\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003'\niE\u0001\u0006Qe>\u0004XM\u001d;jKN\faB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b%A\u0004tKJ4XM]:\u0016\u0005\u0005m\u0003CBA \u0003;\n\t'\u0003\u0003\u0002`\u0005\u0005#aC!se\u0006L()\u001e4gKJ\u0004B!a\u0019\u0002j5\u0011\u0011Q\r\u0006\u0004\u0003O\u0002\u0015AB:feZ,'/\u0003\u0003\u0002l\u0005\u0015$aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR!\u0011\u0011OA<!\u0011\ti\"a\u001d\n\u0007\u0005U4P\u0001\u0003V]&$\b\"CA=a\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005Q!M]8lKJd\u0015n\u001d;\u0002\u001d\t\u0014xn[3s\u0019&\u001cHo\u0018\u0013fcR!\u0011\u0011OAB\u0011!\tIhMA\u0001\u0002\u0004)\u0018a\u00032s_.,'\u000fT5ti\u0002\n1\"\u00193nS:\u001cE.[3oiV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000bY*\u0004\u0002\u0002\u0010*\u0019q(!%\u000b\t\u0005M\u0015QS\u0001\bG2LWM\u001c;t\u0015\r\t\u0015q\u0013\u0006\u0004\u000333\u0016AB1qC\u000eDW-\u0003\u0003\u0002\u001e\u0006=%!B!e[&t\u0017aD1e[&t7\t\\5f]R|F%Z9\u0015\t\u0005E\u00141\u0015\u0005\n\u0003s2\u0014\u0011!a\u0001\u0003\u0017\u000bA\"\u00193nS:\u001cE.[3oi\u0002\nQa]3ukB$\"!!\u001d\u0002\u001b\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:t\u00031\u0019'/Z1uKR{\u0007/[2t\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cH\u0003CA9\u0003g\u000b9,a/\t\r\u0005U6\b1\u0001v\u0003\u0015!x\u000e]5d\u0011\u001d\tIl\u000fa\u0001\u00037\t\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\u0005u6\b1\u0001\u0002\u001c\u0005Ya.^7NKN\u001c\u0018mZ3t\u0003\u0015\u0019Gn\\:f\u0003-\u0019G.^:uKJ|F%Z9\u0015\t\u0005E\u0014Q\u0019\u0005\t\u0003s\"\u0011\u0011!a\u0001C\u0006A1\r\\;ti\u0016\u0014\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\ti\r\u0005\u0004\u0002\u0012\u0005E\u0012q\u001a\t\u0005\u0003G\n\t.\u0003\u0003\u0002T\u0006\u0015$aC&bM.\f7i\u001c8gS\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u000f\u0005e\u0007c\u0001/\u0002\\&\u0019\u0011Q\u001c+\u0003\u000b\u00053G/\u001a:\u00021UtG\u000f\u001b:piRdW\r\u001a\"s_.,'oQ8oM&<7/\u0006\u0002\u0002dBA\u0011Q]Av\u00037\ti/\u0004\u0002\u0002h*!\u0011\u0011^A\n\u0003%IW.\\;uC\ndW-\u0003\u0003\u0002\u001a\u0005\u001d\b\u0003CAs\u0003W\f\u0019#a<\u0011\t\u0005u\u0011\u0011_\u0005\u0004\u0003g\\(\u0001\u0002'p]\u001e\f\u0011$\u001e8uQJ|G\u000f\u001e7fI\n\u0013xn[3s\u0007>tg-[4tA\u0005\u0001B/Z:u%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004\u0015\u0005m\bc\u0001/\u0002~&\u0019\u0011q +\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cH\u000fT3hC\u000eL(+Z1tg&<g.\\3oi\"\u001a1\"a?\u0002WQ,7\u000f\u001e%jO\"<\u0016\r^3s\u001b\u0006\u00148.\u00114uKJ\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]RD3\u0001DA~\u0003e!Xm\u001d;UQJ|G\u000f\u001e7fIJ+\u0017m]:jO:lWM\u001c;)\u00075\tY0A\u0018uKN$\bK]8ek\u000e,\u0017I\u001c3D_:\u001cX/\\3XSRD'+Z1tg&<g.\\3oi&s\u0007K]8he\u0016\u001c8\u000fK\u0002\u000f\u0003w\f\u0001\u0003^3ti\u000e\u000bgnY3mY\u0006$\u0018n\u001c8)\u0007=\tY0A\u000exC&$hi\u001c:Ce>\\WM\u001d'fm\u0016dG\u000b\u001b:piRdWm\u001d\u000b\u0005\u0003c\u0012I\u0002C\u0004\u0003\u001cA\u0001\rA!\b\u0002\u001fQ\f'oZ3u)\"\u0014x\u000e\u001e;mKN\u0004\u0002\"!\u0005\u0002\u0018\u0005m!q\u0004\t\b\u0003#\t9\"^Ax\u0003q!Wm]2sS\n,'I]8lKJdUM^3m)\"\u0014x\u000e\u001e;mKN$BA!\b\u0003&!9!qE\tA\u0002\u0005U\u0012!\u00032s_.,'/\u00133t\u0003e!Xm\u001d;SKBd\u0017nY1ESJ,7\r^8ss6{g/Z:)\u0007I\tY0A\nsk:4VM]5gs\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0005\u00032\t\u001d#\u0011\nB'!\u0011\u0011\u0019D!\u0011\u000f\t\tU\"Q\b\b\u0005\u0005o\u0011YDD\u0002y\u0005sI\u0011!Q\u0005\u0003\u007f\u0001K1Aa\u0010?\u0003e\u0011V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:D_6l\u0017M\u001c3\n\t\t\r#Q\t\u0002\u0017-\u0016\u0014\u0018NZ=BgNLwM\\7f]R\u0014Vm];mi*\u0019!q\b \t\u000f\u0005\u001d5\u00031\u0001\u0002\f\"1!1J\nA\u0002U\f!B[:p]N#(/\u001b8h\u0011\u001d\u0011ye\u0005a\u0001\u0005#\n\u0011\u0003\u001d:fg\u0016\u0014h/\u001a+ie>$H\u000f\\3t!\u0011\tiBa\u0015\n\u0007\tU3PA\u0004C_>dW-\u00198\u0002/]\f\u0017\u000e\u001e$peZ+'/\u001b4z\u0003N\u001c\u0018n\u001a8nK:$HCCA9\u00057\u0012iFa\u0018\u0003b!9\u0011q\u0011\u000bA\u0002\u0005-\u0005B\u0002B&)\u0001\u0007Q\u000fC\u0004\u0003PQ\u0001\rA!\u0015\t\u000f\t\rD\u00031\u0001\u00032\u0005qQ\r\u001f9fGR,GMU3tk2$H\u0003\u0003B\u0019\u0005O\u0012\tHa\u001d\t\u000f\t%T\u00031\u0001\u0003l\u0005A!p[\"mS\u0016tG\u000fE\u0002F\u0005[J1Aa\u001cG\u00055Y\u0015MZ6b5.\u001cE.[3oi\"1!1J\u000bA\u0002UDqAa\u0014\u0016\u0001\u0004\u0011\t\u0006\u0006\u0006\u0002r\t]$\u0011\u0010B>\u0005{BqA!\u001b\u0017\u0001\u0004\u0011Y\u0007\u0003\u0004\u0003LY\u0001\r!\u001e\u0005\b\u0005\u001f2\u0002\u0019\u0001B)\u0011\u001d\u0011\u0019G\u0006a\u0001\u0005c\tAC];o\u000bb,7-\u001e;f\u0003N\u001c\u0018n\u001a8nK:$H\u0003DA9\u0005\u0007\u0013)I!#\u0003\u000e\nE\u0005bBAD/\u0001\u0007\u00111\u0012\u0005\b\u0005\u000f;\u0002\u0019\u0001B)\u0003)\tG\rZ5uS>t\u0017\r\u001c\u0005\u0007\u0005\u0017;\u0002\u0019A;\u0002!I,\u0017m]:jO:lWM\u001c;Kg>t\u0007b\u0002BH/\u0001\u0007\u0011q^\u0001\u0014S:$XM\u001d\"s_.,'\u000f\u00165s_R$H.\u001a\u0005\b\u0005';\u0002\u0019AAx\u0003m\u0011X\r\u001d7jG\u0006\fE\u000e^3s\u0019><G)\u001b:t)\"\u0014x\u000e\u001e;mKRA\u0011\u0011\u000fBL\u00053\u0013Y\nC\u0004\u0003ja\u0001\rAa\u001b\t\r\t-\u0005\u00041\u0001v\u0011\u001d\u0011y\t\u0007a\u0001\u0003_\f1C];o\u0007\u0006t7-\u001a7BgNLwM\\7f]R$\u0002B!)\u0003B\n\r'Q\u0019\t\t\u0003;\u0011\u0019Ka*\u0003:&\u0019!QU>\u0003\rQ+\b\u000f\\33!\u00151(\u0011\u0016BW\u0013\u0011\u0011Y+a\u0001\u0003\u0007M+G\u000f\u0005\u0003\u00030\nUVB\u0001BY\u0015\u0011\u0011\u0019,!&\u0002\r\r|W.\\8o\u0013\u0011\u00119L!-\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B)aO!+\u0003<B!!q\u0016B_\u0013\u0011\u0011yL!-\u0003+Q{\u0007/[2QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\"9\u0011qQ\rA\u0002\u0005-\u0005B\u0002B&3\u0001\u0007Q\u000fC\u0004\u0003Pe\u0001\rA!\u0015\u0003\u0015\t\u0013xn[3s\t&\u00148oE\u0002\u001b\u0005\u0017\u0004B!!\b\u0003N&\u0019!qZ>\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0011Xm];miB!\u0011Q\u0012Bk\u0013\u0011\u00119.a$\u0003+\u0011+7o\u0019:jE\u0016dun\u001a#jeN\u0014Vm];mi\u0006A!M]8lKJLE-\u0006\u0002\u0002\u001c\u0005I!M]8lKJLE\r\t\u000b\u0007\u0005C\u0014\u0019O!:\u0011\u0005\tT\u0002b\u0002Bi=\u0001\u0007!1\u001b\u0005\b\u00053t\u0002\u0019AA\u000e\u0003\u001dawn\u001a#jeN,\"Aa;\u0011\u000b\u0005}\"Q^;\n\t\t=\u0018\u0011\t\u0002\b\u0011\u0006\u001c\bnU3u\u0003!awn\u001a#jeN\u0004\u0013AC2ve2{w\rR5sgV\u0011!q\u001f\t\b\u0003\u007f\u0011IP!,v\u0013\u0011\u0011Y0!\u0011\u0003\u000f!\u000b7\u000f['ba\u0006Y1-\u001e:M_\u001e$\u0015N]:!\u000351W\u000f^;sK2{w\rR5sg\u0006qa-\u001e;ve\u0016dun\u001a#jeN\u0004\u0003")
public class ReassignPartitionsIntegrationTest
extends ZooKeeperTestHarness {
    private ReassignPartitionsTestCluster cluster = null;
    private final scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs;

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)300000L);
    }

    public ReassignPartitionsTestCluster cluster() {
        return this.cluster;
    }

    public void cluster_$eq(ReassignPartitionsTestCluster x$1) {
        this.cluster = x$1;
    }

    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(5, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Override
    @After
    public void tearDown() {
        Utils.closeQuietly((AutoCloseable)this.cluster(), (String)"ReassignPartitionsTestCluster");
        super.tearDown();
    }

    public scala.collection.immutable.Map<Object, scala.collection.immutable.Map<String, Object>> unthrottledBrokerConfigs() {
        return this.unthrottledBrokerConfigs;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignment() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Object[] objectArray = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true);
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 0);
        Object var4_3 = null;
        partitionReassignmentState = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true);
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition("bar", 0);
        Object var6_5 = null;
        partitionReassignmentState2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForVerifyAssignment(this.zkClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Assert.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        Object[] objectArray2 = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState3 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true);
        TopicPartition $minus$greater$extension_$this3 = new TopicPartition("foo", 0);
        Object var8_8 = null;
        partitionReassignmentState3 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState4 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true);
        TopicPartition $minus$greater$extension_$this4 = new TopicPartition("bar", 0);
        Object var10_10 = null;
        partitionReassignmentState4 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Assert.assertFalse((boolean)this.runVerifyAssignment(this.zkClient(), assignment, false).movesOngoing());
        this.waitForVerifyAssignment(this.zkClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        Assert.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLegacyReassignment() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"bar\",\"partition\":0,\"replicas\":[3,2,0],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.zkClient(), assignment, -1L);
        Object[] objectArray = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), true);
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 0);
        Object var3_3 = null;
        partitionReassignmentState = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 0})), true);
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition("bar", 0);
        Object var5_5 = null;
        partitionReassignmentState2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForVerifyAssignment(this.zkClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
    }

    @Test
    public void testHighWaterMarkAfterPartitionReassignment() {
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[3,1,2],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        TopicPartition part = new TopicPartition("foo", 0);
        ((KafkaServer)this.cluster().servers().apply(0)).replicaManager().logManager().truncateFullyAndStartAt(part, 123L, false);
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, -1L);
        Object[] objectArray = new Tuple2[1];
        ReassignPartitionsCommand.PartitionReassignmentState $minus$greater$extension_y = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), true);
        Object var4_3 = null;
        objectArray[0] = new Tuple2((Object)part, (Object)$minus$greater$extension_y);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testHighWaterMarkAfterPartitionReassignment$1(this, part)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("broker 3 should be the new leader", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
        Assert.assertEquals((String)new StringBuilder(10).append("Expected broker 3 to have the correct high water mark for the ").append("partition.").toString(), (long)123L, (long)((KafkaServer)this.cluster().servers().apply(3)).replicaManager().localLogOrException(part).highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testThrottledReassignment() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        Integer n8;
        void $minus$greater$extension_y4;
        Long l;
        void $minus$greater$extension_y5;
        Long l2;
        void $minus$greater$extension_y6;
        Long l3;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 50);
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,3,2],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Object[] objectArray = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true);
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 0);
        Object var8_3 = null;
        partitionReassignmentState = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y8);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true);
        TopicPartition $minus$greater$extension_$this2 = new TopicPartition("baz", 2);
        Object var10_5 = null;
        partitionReassignmentState2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y7);
        Map initialAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assert.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false), (Object)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false));
        Assert.assertEquals((Object)new ReassignPartitionsCommand.VerifyAssignmentResult(initialAssignment, false, (Map)Map$.MODULE$.empty(), false), (Object)this.runVerifyAssignment(this.zkClient(), assignment, false));
        Assert.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 300000L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        Object[] objectArray2 = new Tuple2[3];
        Long l4 = l3 = Long.valueOf(interBrokerThrottle);
        l3 = null;
        Long l5 = l4;
        String $minus$greater$extension_$this3 = ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle();
        Object var12_10 = null;
        l5 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y6);
        Long l6 = l2 = Long.valueOf(interBrokerThrottle);
        l2 = null;
        Long l7 = l6;
        String $minus$greater$extension_$this4 = ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle();
        Object var14_13 = null;
        l7 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y5);
        Long l8 = l = Long.valueOf(-1L);
        l = null;
        Long l9 = l8;
        String $minus$greater$extension_$this5 = ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle();
        Object var16_16 = null;
        l9 = null;
        objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y4);
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Object[] objectArray3 = new Tuple2[5];
        Integer n9 = n8 = Integer.valueOf(0);
        n8 = null;
        Integer n10 = n7 = n9;
        n7 = null;
        Integer $minus$greater$extension_$this6 = n10;
        Object var18_20 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)throttledConfigMap);
        Integer n11 = n6 = Integer.valueOf(1);
        n6 = null;
        Integer n12 = n5 = n11;
        n5 = null;
        Integer $minus$greater$extension_$this7 = n12;
        Object var19_23 = null;
        objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)throttledConfigMap);
        Integer n13 = n4 = Integer.valueOf(2);
        n4 = null;
        Integer n14 = n3 = n13;
        n3 = null;
        Integer $minus$greater$extension_$this8 = n14;
        Object var20_26 = null;
        objectArray3[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)throttledConfigMap);
        Integer n15 = n2 = Integer.valueOf(3);
        n2 = null;
        Integer n16 = n = n15;
        n = null;
        Integer $minus$greater$extension_$this9 = n16;
        Object var21_29 = null;
        objectArray3[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)throttledConfigMap);
        Object object = this.unthrottledBrokerConfigs().apply((Object)4);
        Integer $minus$greater$extension_$this10 = 4;
        Object var22_31 = null;
        object = null;
        objectArray3[4] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y3);
        Map throttledBrokerConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        Object[] objectArray4 = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState3 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), true);
        TopicPartition $minus$greater$extension_$this11 = new TopicPartition("foo", 0);
        Object var24_34 = null;
        partitionReassignmentState3 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState4 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true);
        TopicPartition $minus$greater$extension_$this12 = new TopicPartition("baz", 2);
        Object var26_36 = null;
        partitionReassignmentState4 = null;
        objectArray4[1] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        long l10 = 15000L;
        long l11 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$1(this, assignment, throttledBrokerConfigs)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l10) {
                throw Assertions$.MODULE$.fail("Expected reassignment to complete.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l10, l11));
        }
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForVerifyAssignment(this.zkClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProduceAndConsumeWithReassignmentInProgress() {
        void apply_elems;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        this.cluster().produceMessages("baz", 2, 60);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"baz\",\"partition\":2,\"replicas\":[3,2,1],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, 300L, -1L);
        this.cluster().produceMessages("baz", 2, 100);
        TopicPartition part = new TopicPartition("baz", 2);
        try (KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(this.cluster().brokerList(), "group", "earliest", true, false, 500, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArrayDeserializer(), new ByteArrayDeserializer());){
            consumer.assign(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part})))).asJava());
            TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 100, 15000L);
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{part});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.cluster().adminClient(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))), (Set<TopicPartition>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        Object[] objectArray = new Tuple2[1];
        ReassignPartitionsCommand.PartitionReassignmentState $minus$greater$extension_y = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), true);
        Object var6_6 = null;
        objectArray[0] = new Tuple2((Object)part, (Object)$minus$greater$extension_y);
        Map finalAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, false, new ReassignPartitionsCommand.VerifyAssignmentResult(finalAssignment, false, (Map)Map$.MODULE$.empty(), false));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCancellation() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        Integer n8;
        void $minus$greater$extension_y4;
        Long l;
        void $minus$greater$extension_y5;
        Long l2;
        void $minus$greater$extension_y6;
        Long l3;
        this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
        this.cluster().setup();
        this.cluster().produceMessages("foo", 0, 200);
        this.cluster().produceMessages("baz", 1, 200);
        String assignment = "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"baz\",\"partition\":1,\"replicas\":[0,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}";
        Assert.assertEquals(this.unthrottledBrokerConfigs(), this.describeBrokerLevelThrottles((Seq<Object>)this.unthrottledBrokerConfigs().keySet().toSeq()));
        long interBrokerThrottle = 1L;
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, interBrokerThrottle, -1L);
        Object[] objectArray = new Tuple2[3];
        Long l4 = l3 = Long.valueOf(interBrokerThrottle);
        l3 = null;
        Long l5 = l4;
        String $minus$greater$extension_$this = ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle();
        Object var6_5 = null;
        l5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        Long l6 = l2 = Long.valueOf(interBrokerThrottle);
        l2 = null;
        Long l7 = l6;
        String $minus$greater$extension_$this2 = ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle();
        Object var8_8 = null;
        l7 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        Long l8 = l = Long.valueOf(-1L);
        l = null;
        Long l9 = l8;
        String $minus$greater$extension_$this3 = ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle();
        Object var10_11 = null;
        l9 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[5];
        Integer n9 = n8 = Integer.valueOf(0);
        n8 = null;
        Integer n10 = n7 = n9;
        n7 = null;
        Integer $minus$greater$extension_$this4 = n10;
        Object var12_15 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)throttledConfigMap);
        Integer n11 = n6 = Integer.valueOf(1);
        n6 = null;
        Integer n12 = n5 = n11;
        n5 = null;
        Integer $minus$greater$extension_$this5 = n12;
        Object var13_18 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)throttledConfigMap);
        Integer n13 = n4 = Integer.valueOf(2);
        n4 = null;
        Integer n14 = n3 = n13;
        n3 = null;
        Integer $minus$greater$extension_$this6 = n14;
        Object var14_21 = null;
        objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)throttledConfigMap);
        Integer n15 = n2 = Integer.valueOf(3);
        n2 = null;
        Integer n16 = n = n15;
        n = null;
        Integer $minus$greater$extension_$this7 = n16;
        Object var15_24 = null;
        objectArray2[3] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)throttledConfigMap);
        Object object = this.unthrottledBrokerConfigs().apply((Object)4);
        Integer $minus$greater$extension_$this8 = 4;
        Object var16_26 = null;
        object = null;
        objectArray2[4] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y3);
        Map throttledBrokerConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        Object[] objectArray3 = new Tuple2[2];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), false);
        TopicPartition $minus$greater$extension_$this9 = new TopicPartition("foo", 0);
        Object var18_29 = null;
        partitionReassignmentState = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y2);
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), false);
        TopicPartition $minus$greater$extension_$this10 = new TopicPartition("baz", 1);
        Object var20_31 = null;
        partitionReassignmentState2 = null;
        objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)), true, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$), false));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 1)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$2 == null) {
            throw null;
        }
        nil$ = null;
        Assert.assertEquals((Object)new Tuple2(IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4), IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems3)), this.runCancelAssignment(this.cluster().adminClient(), assignment, true));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        Set$ set$3 = Predef$.MODULE$.Set();
        Nil$ nil$2 = Nil$.MODULE$;
        if (set$3 == null) {
            throw null;
        }
        nil$2 = null;
        Set$ set$4 = Predef$.MODULE$.Set();
        Nil$ nil$3 = Nil$.MODULE$;
        if (set$4 == null) {
            throw null;
        }
        nil$3 = null;
        Assert.assertEquals((Object)new Tuple2(IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems2), IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems)), this.runCancelAssignment(this.cluster().adminClient(), assignment, false));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Assert.assertFalse((boolean)this.runVerifyAssignment(this.cluster().adminClient(), assignment, false).partsOngoing());
    }

    private void waitForBrokerLevelThrottles(Map<Object, Map<String, Object>> targetThrottles) {
        Map<Object, Map<String, Object>> map;
        Map cfr_ignored_0 = (Map)Map$.MODULE$.empty();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!targetThrottles.equals(map = this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles.keySet().toSeq()))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append(map).toString()).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
    }

    private Map<Object, Map<String, Object>> describeBrokerLevelThrottles(Seq<Object> brokerIds) {
        return ((IterableOnceOps)brokerIds.map((Function1 & Serializable)brokerId -> ReassignPartitionsIntegrationTest.$anonfun$describeBrokerLevelThrottles$1(this, BoxesRunTime.unboxToInt((Object)brokerId)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaDirectoryMoves() {
        Integer n;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        Integer n2;
        Integer n3;
        void $minus$greater$extension_y7;
        Long l;
        void $minus$greater$extension_y8;
        Long l2;
        void $minus$greater$extension_y9;
        Long l3;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_y11;
        None$ none$;
        String curFoo1Dir;
        block7: {
            void apply_elems;
            Integer n4;
            this.cluster_$eq(new ReassignPartitionsTestCluster(this, this.zkConnect()));
            this.cluster().setup();
            this.cluster().produceMessages("foo", 0, 7000);
            this.cluster().produceMessages("baz", 1, 6000);
            Admin admin = this.cluster().adminClient();
            int n5 = 0;
            int to$extension_end = 4;
            Range.Inclusive map_this = new Range.Inclusive(n5, to$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Integer n6;
                Integer n7;
                Integer n8;
                Integer n9 = n8 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
                n8 = null;
                Integer n10 = n7 = n9;
                n7 = null;
                Integer n11 = n6 = n10;
                n6 = null;
                n4 = n11;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                n4 = null;
            }
            Object var35_3 = null;
            Object var36_4 = null;
            Object var37_5 = null;
            n4 = null;
            DescribeLogDirsResult result0 = admin.describeLogDirs(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)((IndexedSeq)map_strictOptimizedMap_b.result())).asJavaCollection());
            BrokerDirs info0 = new BrokerDirs(this, result0, 0);
            Assert.assertTrue((boolean)info0.futureLogDirs().isEmpty());
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("baz", 0), new TopicPartition("baz", 1), new TopicPartition("baz", 2)});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)info0.curLogDirs().keySet());
            curFoo1Dir = (String)info0.curLogDirs().getOrElse((Object)new TopicPartition("foo", 0), (Function0 & Serializable)() -> "");
            Assert.assertFalse((boolean)curFoo1Dir.equals(""));
            HashSet<String> hashSet = info0.logDirs();
            if (hashSet == null) {
                throw null;
            }
            for (Object find_a : hashSet) {
                String string = (String)find_a;
                if (!ReassignPartitionsIntegrationTest.$anonfun$testReplicaDirectoryMoves$3(curFoo1Dir, string)) continue;
                none$ = new Some(find_a);
                break block7;
            }
            none$ = None$.MODULE$;
        }
        None$ none$2 = none$;
        Object var50_14 = null;
        Object var51_15 = null;
        none$ = null;
        String newFoo1Dir = (String)none$2.get();
        String assignment = new StringBuilder(77).append("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1,2],").append(StringOps$.MODULE$.format$extension("\"log_dirs\":[\"%s\",\"any\",\"any\"]}", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{newFoo1Dir}))).append("]}").toString();
        this.runExecuteAssignment(this.cluster().adminClient(), false, assignment, -1L, 1L);
        Object[] objectArray = new Tuple2[1];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true);
        TopicPartition $minus$greater$extension_$this = new TopicPartition("foo", 0);
        Object var10_21 = null;
        partitionReassignmentState = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y11);
        Object[] objectArray2 = new Tuple2[1];
        ReassignPartitionsCommand.ActiveMoveState activeMoveState = new ReassignPartitionsCommand.ActiveMoveState(curFoo1Dir, newFoo1Dir, newFoo1Dir);
        TopicPartitionReplica $minus$greater$extension_$this2 = new TopicPartitionReplica("foo", 0, 0);
        Object var12_23 = null;
        activeMoveState = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y10);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), true));
        Object[] objectArray3 = new Tuple2[3];
        Long l4 = l3 = Long.valueOf(-1L);
        l3 = null;
        Long l5 = l4;
        String $minus$greater$extension_$this3 = ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle();
        Object var14_26 = null;
        l5 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y9);
        Long l6 = l2 = Long.valueOf(-1L);
        l2 = null;
        Long l7 = l6;
        String $minus$greater$extension_$this4 = ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle();
        Object var16_29 = null;
        l7 = null;
        objectArray3[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y8);
        Long l8 = l = Long.valueOf(1L);
        l = null;
        Long l9 = l8;
        String $minus$greater$extension_$this5 = ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle();
        Object var18_32 = null;
        l9 = null;
        objectArray3[2] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y7);
        Map throttledConfigMap = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        Object[] objectArray4 = new Tuple2[5];
        Integer n12 = n3 = Integer.valueOf(0);
        n3 = null;
        Integer n13 = n2 = n12;
        n2 = null;
        Integer $minus$greater$extension_$this6 = n13;
        Object var20_36 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)throttledConfigMap);
        Object object = this.unthrottledBrokerConfigs().apply((Object)1);
        Integer $minus$greater$extension_$this7 = 1;
        Object var21_38 = null;
        object = null;
        objectArray4[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y6);
        Object object2 = this.unthrottledBrokerConfigs().apply((Object)2);
        Integer $minus$greater$extension_$this8 = 2;
        Object var23_40 = null;
        object2 = null;
        objectArray4[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y5);
        Object object3 = this.unthrottledBrokerConfigs().apply((Object)3);
        Integer $minus$greater$extension_$this9 = 3;
        Object var25_42 = null;
        object3 = null;
        objectArray4[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y4);
        Object object4 = this.unthrottledBrokerConfigs().apply((Object)4);
        Integer $minus$greater$extension_$this10 = 4;
        Object var27_44 = null;
        object4 = null;
        objectArray4[4] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y3);
        Map throttledBrokerConfigs = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs);
        this.cluster().adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, "0"), Collections.singletonList(new AlterConfigOp(new ConfigEntry(ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), ""), AlterConfigOp.OpType.DELETE)))).all().get();
        this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)this.unthrottledBrokerConfigs());
        Object[] objectArray5 = new Tuple2[1];
        ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState2 = new ReassignPartitionsCommand.PartitionReassignmentState((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), true);
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0));
        Object var29_47 = null;
        partitionReassignmentState2 = null;
        objectArray5[0] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y2);
        Object[] objectArray6 = new Tuple2[1];
        ReassignPartitionsCommand.CompletedMoveState completedMoveState = new ReassignPartitionsCommand.CompletedMoveState(newFoo1Dir);
        Object $minus$greater$extension_$this12 = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0));
        Object var31_49 = null;
        completedMoveState = null;
        objectArray6[0] = new Tuple2($minus$greater$extension_$this12, (Object)$minus$greater$extension_y);
        this.waitForVerifyAssignment(this.cluster().adminClient(), assignment, true, new ReassignPartitionsCommand.VerifyAssignmentResult((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5)), false, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray6)), false));
        Admin admin = this.cluster().adminClient();
        int n14 = 0;
        int to$extension_end = 4;
        Range.Inclusive map_this = new Range.Inclusive(n14, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer n15;
            Integer n16;
            Integer n17;
            Integer n18 = n17 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            n17 = null;
            Integer n19 = n16 = n18;
            n16 = null;
            Integer n20 = n15 = n19;
            n15 = null;
            n = n20;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        Object var39_52 = null;
        Object var40_53 = null;
        Object var41_54 = null;
        n = null;
        BrokerDirs info1 = new BrokerDirs(this, admin.describeLogDirs(AsJavaExtensions.IterableHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Iterable)((IndexedSeq)map_strictOptimizedMap_b.result())).asJavaCollection()), 0);
        Assert.assertEquals((Object)newFoo1Dir, (Object)info1.curLogDirs().getOrElse((Object)new TopicPartition("foo", 0), (Function0 & Serializable)() -> ""));
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        String println_x = new StringBuilder(46).append("==> verifyAssignment(adminClient, jsonString=").append(jsonString).append(")").toString();
        Console$.MODULE$.println((Object)println_x);
        Object var4_4 = null;
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(adminClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignmentResult;
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!expectedResult.equals((Object)(verifyAssignmentResult = this.runVerifyAssignment(adminClient, jsonString, preserveThrottles)))) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append(verifyAssignmentResult).toString()).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
    }

    private ReassignPartitionsCommand.VerifyAssignmentResult runVerifyAssignment(KafkaZkClient zkClient, String jsonString, boolean preserveThrottles) {
        String println_x = new StringBuilder(43).append("==> verifyAssignment(zkClient, jsonString=").append(jsonString).append(")").toString();
        Console$.MODULE$.println((Object)println_x);
        Object var4_4 = null;
        return ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkClient, jsonString, preserveThrottles);
    }

    private void waitForVerifyAssignment(KafkaZkClient zkClient, String jsonString, boolean preserveThrottles, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult) {
        long l = 15000L;
        long waitUntilTrue_pause = 10L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            String $anonfun$waitForVerifyAssignment$3_println_x = new StringBuilder(0).append(new StringBuilder(44).append("==> verifyAssignment(zkClient, jsonString=").append(jsonString).append(", ").toString()).append(new StringBuilder(19).append("preserveThrottles=").append(preserveThrottles).append(")").toString()).toString();
            Console$.MODULE$.println((Object)$anonfun$waitForVerifyAssignment$3_println_x);
            Object var11_8 = null;
            ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignmentResult = ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkClient, jsonString, preserveThrottles);
            if (expectedResult.equals((Object)verifyAssignmentResult)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append(verifyAssignmentResult).toString()).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
    }

    private void runExecuteAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long replicaAlterLogDirsThrottle) {
        String println_x = new StringBuilder(0).append(new StringBuilder(48).append("==> executeAssignment(adminClient, additional=").append(additional).append(", ").toString()).append(new StringBuilder(19).append("reassignmentJson=").append(reassignmentJson).append(", ").toString()).append(new StringBuilder(22).append("interBrokerThrottle=").append(interBrokerThrottle).append(", ").toString()).append(new StringBuilder(30).append("replicaAlterLogDirsThrottle=").append(replicaAlterLogDirsThrottle).append("))").toString()).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var8_6 = null;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(adminClient, additional, reassignmentJson, interBrokerThrottle, replicaAlterLogDirsThrottle, 10000L, Time.SYSTEM);
    }

    private void runExecuteAssignment(KafkaZkClient zkClient, String reassignmentJson, long interBrokerThrottle) {
        String println_x = new StringBuilder(0).append("==> executeAssignment(adminClient, ").append(new StringBuilder(19).append("reassignmentJson=").append(reassignmentJson).append(", ").toString()).append(new StringBuilder(21).append("interBrokerThrottle=").append(interBrokerThrottle).append(")").toString()).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var5_4 = null;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkClient, reassignmentJson, interBrokerThrottle);
    }

    private Tuple2<Set<TopicPartition>, Set<TopicPartitionReplica>> runCancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        String println_x = new StringBuilder(46).append("==> cancelAssignment(adminClient, jsonString=").append(jsonString).append(")").toString();
        Console$.MODULE$.println((Object)println_x);
        Object var4_4 = null;
        return ReassignPartitionsCommand$.MODULE$.cancelAssignment(adminClient, jsonString, preserveThrottles, 10000L, Time.SYSTEM);
    }

    public static final /* synthetic */ Tuple2 $anonfun$unthrottledBrokerConfigs$1(int brokerId) {
        scala.collection.immutable.Map $minus$greater$extension_y = ((IterableOnceOps)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttle -> new Tuple2(throttle, (Object)BoxesRunTime.boxToLong((long)-1L)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Integer $minus$greater$extension_$this = brokerId;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ Option $anonfun$testHighWaterMarkAfterPartitionReassignment$2(Partition x$1) {
        return x$1.leaderLogIfLocal();
    }

    public static final /* synthetic */ boolean $anonfun$testHighWaterMarkAfterPartitionReassignment$1(ReassignPartitionsIntegrationTest $this, TopicPartition part$1) {
        Option option = ((KafkaServer)$this.cluster().servers().apply(3)).replicaManager().nonOfflinePartition(part$1);
        if (option == null) {
            throw null;
        }
        Option flatMap_this = option;
        Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((Partition)flatMap_this.get()).leaderLogIfLocal();
        None$ none$ = object;
        Object var2_2 = null;
        object = null;
        return none$.isDefined();
    }

    public static final /* synthetic */ String $anonfun$testHighWaterMarkAfterPartitionReassignment$3() {
        return "broker 3 should be the new leader";
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$2(Tuple2 x$2) {
        return ((ReassignPartitionsCommand.PartitionReassignmentState)x$2._2()).done();
    }

    public static final /* synthetic */ boolean $anonfun$testThrottledReassignment$1(ReassignPartitionsIntegrationTest $this, String assignment$1, Map throttledBrokerConfigs$1) {
        ReassignPartitionsCommand.VerifyAssignmentResult result = $this.runVerifyAssignment($this.cluster().adminClient(), assignment$1, true);
        if (!result.partsOngoing()) {
            return true;
        }
        Assert.assertTrue((String)new StringBuilder(64).append("Expected at least one partition reassignment to be ongoing when ").append(new StringBuilder(9).append("result = ").append(result).toString()).toString(), (!result.partStates().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testThrottledReassignment$2(x$2))) ? 1 : 0) != 0);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3, 2})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("foo", 0))).targetReplicas());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1})), (Object)((ReassignPartitionsCommand.PartitionReassignmentState)result.partStates().apply((Object)new TopicPartition("baz", 2))).targetReplicas());
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Current result: {}", (Object)result);
        }
        $this.waitForBrokerLevelThrottles((Map<Object, Map<String, Object>>)throttledBrokerConfigs$1);
        return false;
    }

    public static final /* synthetic */ String $anonfun$testThrottledReassignment$3() {
        return "Expected reassignment to complete.";
    }

    public static final /* synthetic */ boolean $anonfun$waitForBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, ObjectRef curThrottles$1, Map targetThrottles$1) {
        curThrottles$1.elem = $this.describeBrokerLevelThrottles((Seq<Object>)targetThrottles$1.keySet().toSeq());
        return targetThrottles$1.equals((Object)((Map)curThrottles$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForBrokerLevelThrottles$2(Map targetThrottles$1, ObjectRef curThrottles$1) {
        return new StringBuilder(0).append(new StringBuilder(51).append("timed out waiting for broker throttle to become ").append(targetThrottles$1).append(".  ").toString()).append(new StringBuilder(22).append("Latest throttles were ").append((Map)curThrottles$1.elem).toString()).toString();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeBrokerLevelThrottles$1(ReassignPartitionsIntegrationTest $this, int brokerId) {
        Integer n;
        Integer n2;
        Properties props = $this.zkClient().getEntityConfigs("brokers", ((Object)brokerId).toString());
        scala.collection.immutable.Map throttles = ((IterableOnceOps)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttleName -> new Tuple2(throttleName, (Object)Long.parseLong((String)props.getOrDefault(throttleName, "-1"))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Integer n3 = n2 = Integer.valueOf(brokerId);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)throttles);
    }

    public static final /* synthetic */ Integer $anonfun$testReplicaDirectoryMoves$1(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDirectoryMoves$3(String curFoo1Dir$1, String x$4) {
        return !x$4.equals(curFoo1Dir$1);
    }

    public static final /* synthetic */ Integer $anonfun$testReplicaDirectoryMoves$4(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$1(ReassignPartitionsIntegrationTest $this, ObjectRef latestResult$1, Admin adminClient$1, String jsonString$1, boolean preserveThrottles$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1) {
        latestResult$1.elem = $this.runVerifyAssignment(adminClient$1, jsonString$1, preserveThrottles$1);
        return expectedResult$1.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$2(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$1, ObjectRef latestResult$1) {
        return new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult$1).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$1.elem).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForVerifyAssignment$3(String jsonString$2, boolean preserveThrottles$2, ObjectRef latestResult$2, KafkaZkClient zkClient$1, ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$2) {
        String println_x = new StringBuilder(0).append(new StringBuilder(44).append("==> verifyAssignment(zkClient, jsonString=").append(jsonString$2).append(", ").toString()).append(new StringBuilder(19).append("preserveThrottles=").append(preserveThrottles$2).append(")").toString()).toString();
        Console$.MODULE$.println((Object)println_x);
        Object var5_5 = null;
        latestResult$2.elem = ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkClient$1, jsonString$2, preserveThrottles$2);
        return expectedResult$2.equals((Object)((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$2.elem));
    }

    public static final /* synthetic */ String $anonfun$waitForVerifyAssignment$4(ReassignPartitionsCommand.VerifyAssignmentResult expectedResult$2, ObjectRef latestResult$2) {
        return new StringBuilder(0).append(new StringBuilder(49).append("Timed out waiting for verifyAssignment result ").append(expectedResult$2).append(".  ").toString()).append(new StringBuilder(22).append("The latest result was ").append((ReassignPartitionsCommand.VerifyAssignmentResult)latestResult$2.elem).toString()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsIntegrationTest() {
        Tuple2 tuple2;
        int n = 0;
        int to$extension_end = 4;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Tuple2 tuple22;
            Tuple2 tuple23 = tuple22 = ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            tuple22 = null;
            tuple2 = tuple23;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            tuple2 = null;
        }
        Object var2_3 = null;
        Object var3_4 = null;
        Object var4_5 = null;
        tuple2 = null;
        this.unthrottledBrokerConfigs = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Integer $anonfun$testReplicaDirectoryMoves$1$adapted(Object x$3) {
        return ReassignPartitionsIntegrationTest.$anonfun$testReplicaDirectoryMoves$1(BoxesRunTime.unboxToInt((Object)x$3));
    }

    public static final /* synthetic */ Object $anonfun$testReplicaDirectoryMoves$3$adapted(String curFoo1Dir$1, String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsIntegrationTest.$anonfun$testReplicaDirectoryMoves$3(curFoo1Dir$1, x$4));
    }

    public static final /* synthetic */ Integer $anonfun$testReplicaDirectoryMoves$4$adapted(Object x$5) {
        return ReassignPartitionsIntegrationTest.$anonfun$testReplicaDirectoryMoves$4(BoxesRunTime.unboxToInt((Object)x$5));
    }

    public static final /* synthetic */ Tuple2 $anonfun$unthrottledBrokerConfigs$1$adapted(Object brokerId) {
        return ReassignPartitionsIntegrationTest.$anonfun$unthrottledBrokerConfigs$1(BoxesRunTime.unboxToInt((Object)brokerId));
    }

    public class BrokerDirs {
        private final int brokerId;
        private final HashSet<String> logDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs;
        private final scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public int brokerId() {
            return this.brokerId;
        }

        public HashSet<String> logDirs() {
            return this.logDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> curLogDirs() {
            return this.curLogDirs;
        }

        public scala.collection.mutable.HashMap<TopicPartition, String> futureLogDirs() {
            return this.futureLogDirs;
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$BrokerDirs$$$outer() {
            return this.$outer;
        }

        public BrokerDirs(ReassignPartitionsIntegrationTest $outer, DescribeLogDirsResult result, int brokerId) {
            this.brokerId = brokerId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.logDirs = new HashSet();
            this.curLogDirs = new scala.collection.mutable.HashMap();
            this.futureLogDirs = new scala.collection.mutable.HashMap();
            ((java.util.Map)((KafkaFuture)result.values().get(brokerId)).get()).forEach((x0$1, x1$1) -> {
                this.logDirs().add(x0$1);
                x1$1.replicaInfos.forEach((x0$2, x1$2) -> {
                    if (x1$2.isFuture) {
                        this.futureLogDirs().put(x0$2, x0$1);
                        return;
                    }
                    this.curLogDirs().put(x0$2, x0$1);
                });
            });
        }
    }

    public class ReassignPartitionsTestCluster
    implements Closeable {
        private final String zkConnect;
        private final Map<Object, String> brokers;
        private final Map<String, Seq<Seq<Object>>> topics;
        private final Buffer<Properties> brokerConfigs;
        private ArrayBuffer<KafkaServer> servers;
        private String brokerList;
        private Admin adminClient;
        public final /* synthetic */ ReassignPartitionsIntegrationTest $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public Map<Object, String> brokers() {
            return this.brokers;
        }

        public Map<String, Seq<Seq<Object>>> topics() {
            return this.topics;
        }

        public Buffer<Properties> brokerConfigs() {
            return this.brokerConfigs;
        }

        public ArrayBuffer<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(ArrayBuffer<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public String brokerList() {
            return this.brokerList;
        }

        public void brokerList_$eq(String x$1) {
            this.brokerList = x$1;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void setup() {
            this.createServers();
            this.createTopics();
        }

        public void createServers() {
            this.brokers().keySet().foreach((Function1 & Serializable)x0$1 -> ReassignPartitionsTestCluster.$anonfun$createServers$1(this, BoxesRunTime.unboxToInt((Object)x0$1)));
        }

        public void createTopics() {
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), 15000L);
            this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((Seq<KafkaServer>)this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT)));
            Object[] objectArray = new Tuple2[1];
            String $minus$greater$extension_y = this.brokerList();
            String $minus$greater$extension_$this = "bootstrap.servers";
            Object var1_2 = null;
            Object var2_1 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminClient_$eq(Admin.create((java.util.Map)AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava()));
            this.adminClient().createTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((IterableOnceOps)this.topics().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String topicName = (String)x0$1._1();
                Seq parts = (Seq)x0$1._2();
                HashMap partMap = new HashMap();
                ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$2 -> {
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    Seq part = (Seq)x0$2._1();
                    int index = x0$2._2$mcI$sp();
                    List list = partMap.put(index, AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)part.map((Function1 & Serializable)x$6 -> BoxesRunTime.unboxToInt((Object)x$6)))).asJava());
                    return list;
                });
                NewTopic newTopic = new NewTopic(topicName, partMap);
                return newTopic;
            })).toList()).asJava()).all().get();
            this.topics().foreach((Function1 & Serializable)x0$3 -> {
                ReassignPartitionsTestCluster.$anonfun$createTopics$4(this, x0$3);
                return BoxedUnit.UNIT;
            });
        }

        /*
         * WARNING - void declaration
         */
        public void produceMessages(String topic, int partition, int numMessages) {
            IndexedSeq indexedSeq;
            ProducerRecord producerRecord;
            int n = 0;
            Range.Exclusive map_this = new Range.Exclusive(n, numMessages, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                ProducerRecord producerRecord2;
                ProducerRecord producerRecord3;
                Integer n2;
                Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
                Integer n3 = n2 = Integer.valueOf(partition);
                n2 = null;
                ProducerRecord producerRecord4 = producerRecord3 = new ProducerRecord(topic, n3, null, (Object)new byte[10000]);
                producerRecord3 = null;
                ProducerRecord producerRecord5 = producerRecord2 = producerRecord4;
                producerRecord2 = null;
                producerRecord = producerRecord5;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                producerRecord = null;
            }
            IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
            Object var6_5 = null;
            Object var7_6 = null;
            Object var8_7 = null;
            producerRecord = null;
            indexedSeq = null;
            IndexedSeq records = indexedSeq2;
            TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, -1);
        }

        @Override
        public void close() {
            this.brokerList_$eq(null);
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            this.adminClient_$eq(null);
            try {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
            }
            finally {
                this.servers().clear();
            }
        }

        public /* synthetic */ ReassignPartitionsIntegrationTest kafka$admin$ReassignPartitionsIntegrationTest$ReassignPartitionsTestCluster$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ ArrayBuffer $anonfun$createServers$1(ReassignPartitionsTestCluster $this, int x0$1) {
            void $plus$eq_elem;
            void createServer_time;
            void createServer_config;
            KafkaServer kafkaServer;
            ArrayBuffer<KafkaServer> arrayBuffer = $this.servers();
            java.util.Map apply_props = (java.util.Map)$this.brokerConfigs().apply(x0$1);
            Object var3_2 = null;
            Time time = Time.SYSTEM;
            KafkaConfig kafkaConfig = new KafkaConfig(apply_props, true);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
            Object var4_5 = null;
            kafkaConfig = null;
            time = null;
            kafkaServer = null;
            KafkaServer kafkaServer3 = kafkaServer2;
            if (arrayBuffer == null) {
                throw null;
            }
            return (ArrayBuffer)arrayBuffer.addOne((Object)$plus$eq_elem);
        }

        public static final /* synthetic */ void $anonfun$createTopics$4(ReassignPartitionsTestCluster $this, Tuple2 x0$3) {
            if (x0$3 != null) {
                String topicName = (String)x0$3._1();
                Range range = ((Seq)x0$3._2()).indices();
                if (range == null) {
                    throw null;
                }
                Range foreach_this = range;
                if (!foreach_this.isEmpty()) {
                    int foreach_i = foreach_this.start();
                    while (true) {
                        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)$this.servers(), topicName, foreach_i, 15000L);
                        if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                        foreach_i += foreach_this.step();
                    }
                }
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int partition$1, int x$7) {
            return new ProducerRecord(topic$1, Predef$.MODULE$.int2Integer(partition$1), null, (Object)new byte[10000]);
        }

        /*
         * WARNING - void declaration
         */
        public ReassignPartitionsTestCluster(ReassignPartitionsIntegrationTest $outer, String zkConnect) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_y5;
            void $minus$greater$extension_y6;
            void $minus$greater$extension_y7;
            void $minus$greater$extension_y8;
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Object[] objectArray = new Tuple2[5];
            String string = "rack0";
            Integer $minus$greater$extension_$this = 0;
            Object var3_4 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y8);
            String string2 = "rack0";
            Integer $minus$greater$extension_$this2 = 1;
            Object var5_6 = null;
            string2 = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y7);
            String string3 = "rack1";
            Integer $minus$greater$extension_$this3 = 2;
            Object var7_8 = null;
            string3 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y6);
            String string4 = "rack1";
            Integer $minus$greater$extension_$this4 = 3;
            Object var9_10 = null;
            string4 = null;
            objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y5);
            String string5 = "rack1";
            Integer $minus$greater$extension_$this5 = 4;
            Object var11_12 = null;
            string5 = null;
            objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y4);
            this.brokers = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            Object[] objectArray2 = new Tuple2[3];
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))}));
            String $minus$greater$extension_$this6 = "foo";
            Object var13_14 = null;
            seqOps = null;
            objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y3);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2, 1}))}));
            String $minus$greater$extension_$this7 = "bar";
            Object var15_16 = null;
            seqOps2 = null;
            objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y2);
            SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 2})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 1}))}));
            String $minus$greater$extension_$this8 = "baz";
            Object var17_18 = null;
            seqOps3 = null;
            objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y);
            this.topics = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            IterableOnceOps iterableOnceOps = (IterableOnceOps)this.brokers().map((Function1 & Serializable)x0$1 -> {
                void var4_24;
                None$ none$;
                None$ none$2;
                None$ none$3;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int brokerId = x0$1._1$mcI$sp();
                String rack = (String)x0$1._2();
                String x$2 = this.zkConnect();
                Some x$3 = new Some((Object)rack);
                boolean bl = true;
                int n = TestUtils$.MODULE$.RandomPort();
                None$ none$4 = none$3 = None$.MODULE$;
                none$3 = null;
                None$ x$8 = none$4;
                None$ none$5 = none$2 = None$.MODULE$;
                none$2 = null;
                None$ x$9 = none$5;
                None$ none$6 = none$ = None$.MODULE$;
                none$ = null;
                None$ x$10 = none$6;
                boolean bl2 = true;
                boolean bl3 = false;
                int n2 = TestUtils$.MODULE$.RandomPort();
                boolean bl4 = false;
                int n3 = TestUtils$.MODULE$.RandomPort();
                boolean bl5 = false;
                int n4 = TestUtils$.MODULE$.RandomPort();
                boolean bl6 = false;
                int n5 = 1;
                short s = 1;
                Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, x$2, false, bl, n, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl2, bl3, n2, bl4, n3, bl5, n4, (Option<String>)x$3, 3, bl6, n5, s);
                config.setProperty(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
                config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
                config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
                return var4_24;
            });
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps toBuffer_this = iterableOnceOps;
            Object var19_19 = null;
            this.brokerConfigs = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
            this.servers = new ArrayBuffer();
            this.brokerList = null;
            this.adminClient = null;
        }

        public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1$adapted(String topic$1, int partition$1, Object x$7) {
            return ReassignPartitionsTestCluster.$anonfun$produceMessages$1(topic$1, partition$1, BoxesRunTime.unboxToInt((Object)x$7));
        }
    }
}

