/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.TreeSet;
import scala.compat.java8.OptionConverters;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$ = new ReassignPartitionsCommand$();
    private static final String AnyLogDir = "any";
    private static final String helpText = "This tool helps to move topic partitions between replicas.";
    private static final int EarliestVersion = 1;
    private static final int EarliestTopicsJsonVersion = 1;
    private static final String brokerLevelLeaderThrottle = DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp();
    private static final String brokerLevelFollowerThrottle = DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp();
    private static final String brokerLevelLogDirThrottle = DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp();
    private static final Seq<String> brokerLevelThrottles = (Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.brokerLevelLeaderThrottle(), MODULE$.brokerLevelFollowerThrottle(), MODULE$.brokerLevelLogDirThrottle()}));
    private static final String topicLevelLeaderThrottle = LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp();
    private static final String topicLevelFollowerThrottle = LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp();
    private static final Seq<String> topicLevelThrottles = (Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.topicLevelLeaderThrottle(), MODULE$.topicLevelFollowerThrottle()}));
    private static final String cannotExecuteBecauseOfExistingMessage = "Cannot execute because there is an existing partition assignment.  Use --additional to override this and create a new partition assignment in addition to the existing one.";
    private static final String youMustRunVerifyPeriodicallyMessage = "Warning: You must run --verify periodically, until the reassignment completes, to ensure the throttle is removed.";
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String AnyLogDir() {
        return AnyLogDir;
    }

    public String helpText() {
        return helpText;
    }

    public int EarliestVersion() {
        return EarliestVersion;
    }

    public int EarliestTopicsJsonVersion() {
        return EarliestTopicsJsonVersion;
    }

    public String brokerLevelLeaderThrottle() {
        return brokerLevelLeaderThrottle;
    }

    public String brokerLevelFollowerThrottle() {
        return brokerLevelFollowerThrottle;
    }

    public String brokerLevelLogDirThrottle() {
        return brokerLevelLogDirThrottle;
    }

    public Seq<String> brokerLevelThrottles() {
        return brokerLevelThrottles;
    }

    public String topicLevelLeaderThrottle() {
        return topicLevelLeaderThrottle;
    }

    public String topicLevelFollowerThrottle() {
        return topicLevelFollowerThrottle;
    }

    public Seq<String> topicLevelThrottles() {
        return topicLevelThrottles;
    }

    public String cannotExecuteBecauseOfExistingMessage() {
        return cannotExecuteBecauseOfExistingMessage;
    }

    public String youMustRunVerifyPeriodicallyMessage() {
        return youMustRunVerifyPeriodicallyMessage;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        None$ toClose = None$.MODULE$;
        boolean failed = true;
        try {
            try {
                if (opts.options().has(opts.bootstrapServerOpt())) {
                    if (opts.options().has(opts.zkConnectOpt())) {
                        String println_x = "Warning: ignoring deprecated --zookeeper option because --bootstrap-server was specified.  The --zookeeper option will be removed in a future version of Kafka.";
                        Console$.MODULE$.println((Object)println_x);
                        Object var10_5 = null;
                    }
                    Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())), null) : new Properties();
                    props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
                    props.putIfAbsent("client.id", "reassign-partitions-tool");
                    Admin adminClient = Admin.create((Properties)props);
                    toClose = new Some((Object)adminClient);
                    this.handleAction(adminClient, opts);
                } else {
                    String println_x = "Warning: --zookeeper is deprecated, and will be removed in a future version of Kafka.";
                    Console$.MODULE$.println((Object)println_x);
                    Object var11_8 = null;
                    KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), JaasUtils.isZkSaslEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, "kafka.server", "SessionExpireListener", (Option<String>)None$.MODULE$, (Option<ZKClientConfig>)None$.MODULE$);
                    toClose = new Some((Object)zkClient);
                    this.handleAction(zkClient, opts);
                }
                failed = false;
            }
            catch (ReassignPartitionsCommand.TerseReassignmentFailureException terseReassignmentFailureException) {
                String println_x = terseReassignmentFailureException.getMessage();
                Console$.MODULE$.println((Object)println_x);
                Object var12_10 = null;
            }
            catch (Throwable e) {
                String println_x = new StringBuilder(7).append("Error: ").append(e.getMessage()).toString();
                Console$.MODULE$.println((Object)println_x);
                Object var13_12 = null;
                String println_x2 = Utils.stackTrace((Throwable)e);
                Console$.MODULE$.println((Object)println_x2);
                Object var14_13 = null;
            }
        }
        finally {
            toClose.foreach((Function1 & Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
        }
        if (failed) {
            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
        }
    }

    private void handleAction(Admin adminClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            this.verifyAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.generateOpt())) {
            this.generateAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt()))), (String)opts.options().valueOf(opts.brokerListOpt()), !opts.options().has((OptionSpec)opts.disableRackAware()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.executeOpt())) {
            this.executeAssignment(adminClient, opts.options().has((OptionSpec)opts.additionalOpt()), Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt())), Time.SYSTEM);
            return;
        }
        if (opts.options().has((OptionSpec)opts.cancelOpt())) {
            this.cancelAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt())), Time.SYSTEM);
            return;
        }
        if (opts.options().has((OptionSpec)opts.listOpt())) {
            this.listReassignments(adminClient);
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    private void handleAction(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            this.verifyAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.generateOpt())) {
            this.generateAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt()))), (String)opts.options().valueOf(opts.brokerListOpt()), !opts.options().has((OptionSpec)opts.disableRackAware()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.executeOpt())) {
            this.executeAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt())));
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        void var10_11;
        void var8_8;
        void var6_6;
        void var5_5;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetLogDirs = (Map)tuple2._2();
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> tuple23 = this.verifyReplicaMoves(adminClient, (Map<TopicPartitionReplica, String>)var6_6);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Map moveStates = (Map)tuple23._1();
        boolean bl2 = tuple23._2$mcZ$sp();
        if (!(bl || bl2 || preserveThrottles)) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)var10_11, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(adminClient, targets);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        String println_x = this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4);
        Console$.MODULE$.println((Object)println_x);
        Object var5_6 = null;
        return new Tuple2((Object)var4_4, (Object)bl);
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(KafkaZkClient zkClient, String jsonString, boolean preserveThrottles) {
        void var8_9;
        void var5_5;
        void var6_6;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetLogDirs = (Map)tuple2._2();
        if (var6_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        String println_x = "Warning: because you are using the deprecated --zookeeper option, the results may be incomplete.  Use --bootstrap-server instead for more accurate results.";
        Console$.MODULE$.println((Object)println_x);
        Object var9_7 = null;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(zkClient, (Map<TopicPartition, Seq<Object>>)var5_5.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        if (!bl && !preserveThrottles) {
            this.clearAllThrottles(zkClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_9, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)((Map)scala.collection.Map$.MODULE$.empty()), false);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(zkClient, targets);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        String println_x = this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4);
        Console$.MODULE$.println((Object)println_x);
        Object var5_6 = null;
        return new Tuple2((Object)var4_4, (Object)bl);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        void orderingToOrdered_ord;
        void Tuple2_ord2;
        Ordering.Tuple2Ordering tuple2Ordering;
        Ordering.Int$ int$ = Ordering.Int$.MODULE$;
        Ordering.String$ Tuple2_ord1 = Ordering.String$.MODULE$;
        Ordering.Tuple2Ordering tuple2Ordering2 = tuple2Ordering = new Ordering.Tuple2Ordering((Ordering)Tuple2_ord1, (Ordering)Tuple2_ord2);
        Object var3_4 = null;
        int$ = null;
        tuple2Ordering = null;
        Ordering.Tuple2Ordering tuple2Ordering3 = tuple2Ordering2;
        Tuple2 orderingToOrdered_x = new Tuple2((Object)a.topic(), (Object)a.partition());
        Object var6_7 = null;
        tuple2Ordering3 = null;
        return Ordered.$less$((Ordered)new /* Unavailable Anonymous Inner Class!! */, (Object)new Tuple2((Object)b.topic(), (Object)b.partition()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareTopicPartitionReplicas(TopicPartitionReplica a, TopicPartitionReplica b) {
        void orderingToOrdered_ord;
        void Tuple3_ord3;
        void Tuple3_ord2;
        Ordering.Tuple3Ordering tuple3Ordering;
        Ordering.Int$ int$ = Ordering.Int$.MODULE$;
        Ordering.String$ string$ = Ordering.String$.MODULE$;
        Ordering.Int$ Tuple3_ord1 = Ordering.Int$.MODULE$;
        Ordering.Tuple3Ordering tuple3Ordering2 = tuple3Ordering = new Ordering.Tuple3Ordering((Ordering)Tuple3_ord1, (Ordering)Tuple3_ord2, (Ordering)Tuple3_ord3);
        Object var3_5 = null;
        string$ = null;
        int$ = null;
        tuple3Ordering = null;
        Ordering.Tuple3Ordering tuple3Ordering3 = tuple3Ordering2;
        Tuple3 orderingToOrdered_x = new Tuple3((Object)a.brokerId(), (Object)a.topic(), (Object)a.partition());
        Object var7_8 = null;
        tuple3Ordering3 = null;
        return Ordered.$less$((Ordered)new /* Unavailable Anonymous Inner Class!! */, (Object)new Tuple3((Object)b.brokerId(), (Object)b.topic(), (Object)b.partition()));
    }

    /*
     * WARNING - void declaration
     */
    public String partitionReassignmentStatesToString(Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> states) {
        void mkString_end;
        ArrayBuffer bld = new ArrayBuffer();
        String append_elem = "Status of partition reassignment:";
        Buffer cfr_ignored_0 = (Buffer)bld.addOne((Object)append_elem);
        Object var3_3 = null;
        Set set = states.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var4_4 = null;
        ((IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).foreach((Function1 & Serializable)topicPartition -> {
            void append_elem;
            ReassignPartitionsCommand.PartitionReassignmentState state = (ReassignPartitionsCommand.PartitionReassignmentState)states.apply(topicPartition);
            if (state.done()) {
                void append_elem2;
                void mkString_sep;
                void mkString_sep2;
                if (state.currentReplicas().equals(state.targetReplicas())) {
                    void append_elem3;
                    String string = StringOps$.MODULE$.format$extension("Reassignment of partition %s is complete.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.toString()}));
                    if (bld == null) {
                        throw null;
                    }
                    return (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem3));
                }
                Seq<Object> seq = state.currentReplicas();
                String string = ",";
                if (seq == null) {
                    throw null;
                }
                string = null;
                Seq<Object> seq2 = state.targetReplicas();
                String string2 = ",";
                if (seq2 == null) {
                    throw null;
                }
                string2 = null;
                String string3 = new StringBuilder(0).append(new StringBuilder(47).append("There is no active reassignment of partition ").append(topicPartition).append(", ").toString()).append(new StringBuilder(32).append("but replica set is ").append(seq.mkString("", (String)mkString_sep2, "")).append(" rather than ").toString()).append(new StringBuilder(1).append(seq2.mkString("", (String)mkString_sep, "")).append(".").toString()).toString();
                if (bld == null) {
                    throw null;
                }
                return (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem2));
            }
            String string = StringOps$.MODULE$.format$extension("Reassignment of partition %s is still in progress.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}));
            if (bld == null) {
                throw null;
            }
            return (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
        });
        String mkString_sep = System.lineSeparator();
        String string = "";
        String mkString_start = "";
        return IterableOnceOps.mkString$((IterableOnceOps)bld, (String)mkString_start, (String)mkString_sep, (String)mkString_end);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetReassignments) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map currentReassignments = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.listPartitionReassignments().reassignments().get())).asScala();
        Tuple2 tuple2 = targetReassignments.partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$1(currentReassignments, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq foundReassignments = (Seq)tuple2._1();
        Seq notFoundReassignments = (Seq)tuple2._2();
        Seq foundResults = (Seq)var5_5.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$2._1();
            Seq targetReplicas = (Seq)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)((PartitionReassignment)currentReassignments.get((Object)part).get()).replicas()).asScala().map((Function1 & Serializable)i -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$3(i)))), (Seq<Object>)targetReplicas, false));
            return tuple2;
        });
        HashSet topicNamesToLookUp = new HashSet();
        var6_6.foreach((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$3._1();
            BoxedUnit boxedUnit = !currentReassignments.contains((Object)part) ? Boolean.valueOf(topicNamesToLookUp.add((Object)part.topic())) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        scala.collection.mutable.Map topicDescriptions = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)adminClient.describeTopics((Collection)AsJavaExtensions.MutableSetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (scala.collection.mutable.Set)topicNamesToLookUp).asJava()).values()).asScala();
        Seq notFoundResults = (Seq)var6_6.map((Function1 & Serializable)x0$4 -> {
            if (x0$4 == null) throw new MatchError(null);
            TopicPartition part = (TopicPartition)x0$4._1();
            Seq targetReplicas = (Seq)x0$4._2();
            Option option = currentReassignments.get((Object)part);
            if (option instanceof Some) {
                PartitionReassignment reassignment = (PartitionReassignment)((Some)option).value();
                return new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)reassignment.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$6(x$10)))), (Seq<Object>)targetReplicas, false));
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            return new Tuple2((Object)part, (Object)MODULE$.topicDescriptionFutureToState(part.partition(), (KafkaFuture<TopicDescription>)((KafkaFuture)topicDescriptions.apply((Object)part.topic())), (Seq<Object>)targetReplicas));
        });
        if (foundResults == null) {
            throw null;
        }
        Seq allResults = (Seq)foundResults.appendedAll((IterableOnce)notFoundResults);
        return new Tuple2((Object)allResults.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)currentReassignments.nonEmpty());
    }

    private ReassignPartitionsCommand.PartitionReassignmentState topicDescriptionFutureToState(int partition, KafkaFuture<TopicDescription> future, Seq<Object> targetReplicas) {
        try {
            TopicDescription topicDescription = (TopicDescription)future.get();
            if (topicDescription.partitions().size() < partition) {
                throw new ExecutionException("Too few partitions found", (Throwable)new UnknownTopicOrPartitionException());
            }
            return new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()))), targetReplicas, true);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (!(throwable instanceof UnknownTopicOrPartitionException)) {
                throw new MatchError((Object)throwable);
            }
            ReassignPartitionsCommand.PartitionReassignmentState partitionReassignmentState = new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), targetReplicas, true);
            return partitionReassignmentState;
        }
    }

    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targetReassignments) {
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        targetReassignments.groupBy((Function1 & Serializable)x$12 -> ((TopicPartition)x$12._1()).topic()).foreach((Function1 & Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$8(zkClient, results, partitionsBeingReassigned, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)results, (Object)partitionsBeingReassigned.nonEmpty());
    }

    public Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> verifyReplicaMoves(Admin adminClient, Map<TopicPartitionReplica, String> targetReassignments) {
        Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> moveStates = this.findLogDirMoveStates(adminClient, targetReassignments);
        String println_x = this.replicaMoveStatesToString(moveStates);
        Console$.MODULE$.println((Object)println_x);
        Object var4_4 = null;
        return new Tuple2(moveStates, (Object)(!moveStates.values().forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.done())) ? 1 : 0));
    }

    public Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> findLogDirMoveStates(Admin adminClient, Map<TopicPartitionReplica, String> targetMoves) {
        scala.collection.mutable.Map replicaLogDirInfos = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.describeReplicaLogDirs((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)targetMoves.keySet()).asJava()).all().get())).asScala();
        return (Map)targetMoves.map((Function1 & Serializable)x0$1 -> {
            void var3_7;
            if (x0$1 == null) throw new MatchError(null);
            TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
            String targetLogDir = (String)x0$1._2();
            Option option = replicaLogDirInfos.get((Object)replica);
            if (None$.MODULE$.equals(option)) {
                ReassignPartitionsCommand.MissingReplicaMoveState missingReplicaMoveState = new ReassignPartitionsCommand.MissingReplicaMoveState(targetLogDir);
                return new Tuple2((Object)replica, (Object)var3_7);
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
                Product product = info.getCurrentReplicaLogDir() == null ? new ReassignPartitionsCommand.MissingLogDirMoveState(targetLogDir) : (info.getFutureReplicaLogDir() == null ? (info.getCurrentReplicaLogDir().equals(targetLogDir) ? new ReassignPartitionsCommand.CompletedMoveState(targetLogDir) : new ReassignPartitionsCommand.CancelledMoveState(info.getCurrentReplicaLogDir(), targetLogDir)) : new ReassignPartitionsCommand.ActiveMoveState(info.getCurrentReplicaLogDir(), targetLogDir, info.getFutureReplicaLogDir()));
            }
            return new Tuple2((Object)replica, (Object)var3_7);
        });
    }

    /*
     * WARNING - void declaration
     */
    public String replicaMoveStatesToString(Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> states) {
        void mkString_end;
        ArrayBuffer bld = new ArrayBuffer();
        Set set = states.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var3_3 = null;
        ((IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).foreach((Function1 & Serializable)x0$1 -> {
            ArrayBuffer arrayBuffer;
            ReassignPartitionsCommand.LogDirMoveState state = (ReassignPartitionsCommand.LogDirMoveState)states.apply(x0$1);
            if (state instanceof ReassignPartitionsCommand.MissingLogDirMoveState) {
                void append_elem;
                String string = new StringBuilder(0).append(new StringBuilder(25).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" is not found ").toString()).append(new StringBuilder(51).append("in any live log dir on broker ").append(x0$1.brokerId()).append(". There is likely an ").toString()).append("offline log directory on the broker.").toString();
                if (bld == null) {
                    throw null;
                }
                string = null;
                arrayBuffer = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
            } else if (state instanceof ReassignPartitionsCommand.MissingReplicaMoveState) {
                void append_elem;
                String string = new StringBuilder(0).append(new StringBuilder(28).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" cannot be found ").toString()).append(new StringBuilder(37).append("in any live log directory on broker ").append(x0$1.brokerId()).append(".").toString()).toString();
                if (bld == null) {
                    throw null;
                }
                string = null;
                arrayBuffer = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
            } else if (state instanceof ReassignPartitionsCommand.ActiveMoveState) {
                ArrayBuffer arrayBuffer2;
                String futureLogDir;
                ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)state;
                String targetLogDir = activeMoveState.targetLogDir();
                if (targetLogDir.equals(futureLogDir = activeMoveState.futureLogDir())) {
                    void append_elem;
                    String string = new StringBuilder(46).append("Reassignment of replica ").append(x0$1).append(" is still in progress.").toString();
                    if (bld == null) {
                        throw null;
                    }
                    string = null;
                    arrayBuffer2 = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
                } else {
                    void append_elem;
                    String string = new StringBuilder(0).append(new StringBuilder(22).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" on broker ").toString()).append(new StringBuilder(28).append(x0$1.brokerId()).append(" is being moved to log dir ").append(futureLogDir).append(" ").toString()).append(new StringBuilder(12).append("instead of ").append(targetLogDir).append(".").toString()).toString();
                    if (bld == null) {
                        throw null;
                    }
                    string = null;
                    arrayBuffer2 = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
                }
                arrayBuffer = arrayBuffer2;
            } else if (state instanceof ReassignPartitionsCommand.CancelledMoveState) {
                void append_elem;
                ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = (ReassignPartitionsCommand.CancelledMoveState)state;
                String currentLogDir = cancelledMoveState.currentLogDir();
                String targetLogDir = cancelledMoveState.targetLogDir();
                String string = new StringBuilder(0).append(new StringBuilder(22).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" on broker ").toString()).append(new StringBuilder(37).append(x0$1.brokerId()).append(" is not being moved from log dir ").append(currentLogDir).append(" to ").toString()).append(new StringBuilder(1).append(targetLogDir).append(".").toString()).toString();
                if (bld == null) {
                    throw null;
                }
                string = null;
                arrayBuffer = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
            } else if (state instanceof ReassignPartitionsCommand.CompletedMoveState) {
                void append_elem;
                String string = new StringBuilder(48).append("Reassignment of replica ").append(x0$1).append(" completed successfully.").toString();
                if (bld == null) {
                    throw null;
                }
                string = null;
                arrayBuffer = (ArrayBuffer)((Buffer)bld.addOne((Object)append_elem));
            } else {
                throw new MatchError((Object)state);
            }
            return arrayBuffer;
        });
        String mkString_sep = System.lineSeparator();
        String string = "";
        String mkString_start = "";
        return IterableOnceOps.mkString$((IterableOnceOps)bld, (String)mkString_start, (String)mkString_sep, (String)mkString_end);
    }

    /*
     * WARNING - void declaration
     */
    public void clearAllThrottles(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        void $plus$plus_that;
        scala.collection.immutable.Set activeBrokers = ((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((Collection)adminClient.describeCluster().nodes().get())).asScala().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()))).toSet();
        scala.collection.immutable.Set set = ((IterableOnceOps)((IterableOps)targetParts.map((Function1 & Serializable)x$15 -> (Seq)x$15._2())).flatten((Function1)$less$colon$less$.MODULE$.refl())).toSet();
        if (activeBrokers == null) {
            throw null;
        }
        set = null;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)activeBrokers.concat((IterableOnce)$plus$plus_that);
        Object[] objectArray = new Object[2];
        objectArray[0] = brokers.size() == 1 ? "" : "s";
        String mkString_sep = ",";
        Object var7_6 = null;
        objectArray[1] = brokers.mkString("", mkString_sep, "");
        String println_x = StringOps$.MODULE$.format$extension("Clearing broker-level throttles on broker%s %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        Console$.MODULE$.println((Object)println_x);
        Object var9_7 = null;
        this.clearBrokerLevelThrottles(adminClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set topics = ((IterableOnceOps)targetParts.map((Function1 & Serializable)x$16 -> ((TopicPartition)x$16._1()).topic())).toSet();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = topics.size() == 1 ? "" : "s";
        String mkString_sep2 = ",";
        Object var8_9 = null;
        objectArray2[1] = topics.mkString("", mkString_sep2, "");
        String println_x2 = StringOps$.MODULE$.format$extension("Clearing topic-level throttles on topic%s %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2));
        Console$.MODULE$.println((Object)println_x2);
        Object var10_10 = null;
        this.clearTopicLevelThrottles(adminClient, (scala.collection.immutable.Set<String>)topics);
    }

    /*
     * WARNING - void declaration
     */
    public void clearAllThrottles(KafkaZkClient zkClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        void $plus$plus_that;
        scala.collection.immutable.Set activeBrokers = ((IterableOnceOps)zkClient.getAllBrokersInCluster().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()))).toSet();
        scala.collection.immutable.Set set = ((IterableOnceOps)((IterableOps)targetParts.map((Function1 & Serializable)x$18 -> (Seq)x$18._2())).flatten((Function1)$less$colon$less$.MODULE$.refl())).toSet();
        if (activeBrokers == null) {
            throw null;
        }
        set = null;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)activeBrokers.concat((IterableOnce)$plus$plus_that);
        Object[] objectArray = new Object[2];
        objectArray[0] = brokers.size() == 1 ? "" : "s";
        String mkString_sep = ",";
        Object var7_6 = null;
        objectArray[1] = brokers.mkString("", mkString_sep, "");
        String println_x = StringOps$.MODULE$.format$extension("Clearing broker-level throttles on broker%s %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        Console$.MODULE$.println((Object)println_x);
        Object var9_7 = null;
        this.clearBrokerLevelThrottles(zkClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set topics = ((IterableOnceOps)targetParts.map((Function1 & Serializable)x$19 -> ((TopicPartition)x$19._1()).topic())).toSet();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = topics.size() == 1 ? "" : "s";
        String mkString_sep2 = ",";
        Object var8_9 = null;
        objectArray2[1] = topics.mkString("", mkString_sep2, "");
        String println_x2 = StringOps$.MODULE$.format$extension("Clearing topic-level throttles on topic%s %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2));
        Console$.MODULE$.println((Object)println_x2);
        Object var10_10 = null;
        this.clearTopicLevelThrottles(zkClient, (scala.collection.immutable.Set<String>)topics);
    }

    public void clearBrokerLevelThrottles(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        HashMap configOps = new HashMap();
        brokers.foreach((Function1 & Serializable)x0$1 -> configOps.put(new ConfigResource(ConfigResource.Type.BROKER, ((Object)BoxesRunTime.unboxToInt((Object)x0$1)).toString()), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)ReassignPartitionsCommand$.MODULE$.brokerLevelThrottles().map((Function1 & Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE)))).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearBrokerLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> brokers) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)brokerId).toString());
            if (((IterableOnceOps)MODULE$.brokerLevelThrottles().flatMap((Function1 & Serializable)throttle -> Option$.MODULE$.apply(configs.remove(throttle)))).nonEmpty()) {
                adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
            }
        });
    }

    public void clearTopicLevelThrottles(Admin adminClient, scala.collection.immutable.Set<String> topics) {
        HashMap configOps = new HashMap();
        topics.foreach((Function1 & Serializable)topicName -> configOps.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)MODULE$.topicLevelThrottles().map((Function1 & Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE)))).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearTopicLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<String> topics) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1 & Serializable)topic -> {
            ReassignPartitionsCommand$.$anonfun$clearTopicLevelThrottles$3(adminZkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(Admin adminClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void var6_6;
        void var7_7;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq brokersToReassign = (Seq)tuple2._1();
        Seq topicsToReassign = (Seq)tuple2._2();
        Map<TopicPartition, Seq<Object>> currentAssignments = this.getReplicaAssignmentForTopics(adminClient, (Seq<String>)var7_7);
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(adminClient, (Seq<Object>)var6_6, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        String println_x = StringOps$.MODULE$.format$extension("Current partition replica assignment\n%s\n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))}));
        Console$.MODULE$.println((Object)println_x);
        Object var11_11 = null;
        String println_x2 = StringOps$.MODULE$.format$extension("Proposed partition reassignment configuration\n%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))}));
        Console$.MODULE$.println((Object)println_x2);
        Object var12_12 = null;
        return new Tuple2(proposedAssignments, currentAssignments);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void var6_6;
        void var7_7;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq brokersToReassign = (Seq)tuple2._1();
        Seq topicsToReassign = (Seq)tuple2._2();
        Map<TopicPartition, Seq<Object>> currentAssignments = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)var7_7.toSet());
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(zkClient, (Seq<Object>)var6_6, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        String println_x = StringOps$.MODULE$.format$extension("Current partition replica assignment\n%s\n", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))}));
        Console$.MODULE$.println((Object)println_x);
        Object var11_11 = null;
        String println_x2 = StringOps$.MODULE$.format$extension("Proposed partition reassignment configuration\n%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty()))}));
        Console$.MODULE$.println((Object)println_x2);
        Object var12_12 = null;
        return new Tuple2(proposedAssignments, currentAssignments);
    }

    public Map<TopicPartition, Seq<Object>> calculateAssignment(Map<TopicPartition, Seq<Object>> currentAssignment, Seq<BrokerMetadata> brokerMetadatas) {
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        });
        scala.collection.mutable.Map proposedAssignments = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable)x0$2 -> {
            void $plus$plus$eq_xs;
            IterableOps iterableOps;
            if (x0$2 != null) {
                void var7_6;
                String topic = (String)x0$2._1();
                Map assignment = (Map)x0$2._2();
                Tuple2 tuple2 = (Tuple2)assignment.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Seq replicas = (Seq)tuple2._2();
                if (var7_6 == null) {
                    throw null;
                }
                Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), var7_6.length(), -1, -1);
                iterableOps = assignedReplicas.map((Function1 & Serializable)x0$3 -> {
                    Tuple2 tuple2;
                    TopicPartition topicPartition;
                    if (x0$3 == null) {
                        throw new MatchError(null);
                    }
                    int partition = x0$3._1$mcI$sp();
                    Seq replicas = (Seq)x0$3._2();
                    TopicPartition topicPartition2 = topicPartition = new TopicPartition(topic, partition);
                    topicPartition = null;
                    TopicPartition $minus$greater$extension_$this = topicPartition2;
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
                    Object var5_5 = null;
                    tuple2 = null;
                    Tuple2 tuple23 = tuple22;
                    return tuple23;
                });
                if (proposedAssignments == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            iterableOps = null;
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)proposedAssignments.addAll((IterableOnce)$plus$plus$eq_xs);
            return map;
        });
        return proposedAssignments;
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForTopics(Admin adminClient, Seq<String> topics) {
        return (Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.describeTopics((Collection)AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, topics).asJava()).all().get())).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topicName = (String)x0$1._1();
            TopicDescription topicDescription = (TopicDescription)x0$1._2();
            IterableOnce iterableOnce = (IterableOnce)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)topicDescription.partitions()).asScala().map((Function1 & Serializable)info -> new Tuple2((Object)new TopicPartition(topicName, info.partition()), AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)info.replicas()).asScala().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.id()))));
            return iterableOnce;
        });
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForPartitions(Admin adminClient, scala.collection.immutable.Set<TopicPartition> partitions) {
        return (Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.describeTopics((Collection)AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)((Set)partitions.map((Function1 & Serializable)x$23 -> x$23.topic()))).asJava()).all().get())).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topicName = (String)x0$1._1();
            TopicDescription topicDescription = (TopicDescription)x0$1._2();
            IterableOnce iterableOnce = (IterableOnce)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)topicDescription.partitions()).asScala().flatMap((Function1 & Serializable)info -> {
                if (partitions.contains((Object)new TopicPartition(topicName, info.partition()))) {
                    return new Some((Object)new Tuple2((Object)new TopicPartition(topicName, info.partition()), AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)info.replicas()).asScala().map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.id()))));
                }
                return None$.MODULE$;
            });
            return iterableOnce;
        });
    }

    public Seq<BrokerMetadata> getBrokerMetadata(Admin adminClient, Seq<Object> brokers, boolean enableRackAwareness) {
        scala.collection.immutable.Set brokerSet = brokers.toSet();
        scala.collection.immutable.Seq results = ((IterableOnceOps)((IterableOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((Collection)adminClient.describeCluster().nodes().get())).asScala().filter((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)brokerSet.contains((Object)node.id())))).map((Function1 & Serializable)node -> {
            if (enableRackAwareness && node.rack() != null) {
                return new BrokerMetadata(node.id(), (Option<String>)new Some((Object)node.rack()));
            }
            return new BrokerMetadata(node.id(), (Option<String>)None$.MODULE$);
        })).toSeq();
        int numRackless = results.count((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$getBrokerMetadata$3(x$25)));
        if (enableRackAwareness && numRackless != 0 && numRackless != results.length()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return results;
    }

    public Seq<BrokerMetadata> getBrokerMetadata(KafkaZkClient zkClient, Seq<Object> brokers, boolean enableRackAwareness) {
        return new AdminZkClient(zkClient).getBrokerMetadatas((RackAwareMode)(enableRackAwareness ? RackAwareMode$Enforced$.MODULE$ : RackAwareMode$Disabled$.MODULE$), (Option<Seq<Object>>)new Some(brokers));
    }

    public Tuple2<Seq<Object>, Seq<String>> parseGenerateAssignmentArgs(String reassignmentJson, String brokerList) {
        Object var10_7;
        int[] nArray;
        int[] nArray2;
        String[] map$extension_$this = StringOps$.MODULE$.split$extension(brokerList, ',');
        int n = map$extension_$this.length;
        int[] nArray3 = nArray2 = new int[n];
        nArray2 = null;
        int[] nArray4 = nArray = nArray3;
        nArray = null;
        int[] map$extension_ys = nArray4;
        if (n > 0) {
            for (int map$extension_i = 0; map$extension_i < n; ++map$extension_i) {
                int n2;
                map$extension_ys[map$extension_i] = n2 = ReassignPartitionsCommand$.$anonfun$parseGenerateAssignmentArgs$1(map$extension_$this[map$extension_i]);
            }
        }
        void v2 = var10_7;
        Object var9_3 = null;
        var10_7 = null;
        void brokerListToReassign = v2;
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray((int[])brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var7_12 = null;
            objectArray[0] = duplicateReassignments.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Broker list contains duplicate entries: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        Seq<String> topicsToReassign = this.parseTopicsData(reassignmentJson);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var8_15 = null;
            objectArray[0] = duplicateTopicsToReassign.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("List of topics to reassign contains duplicate entries: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        return new Tuple2((Object)Predef$.MODULE$.wrapIntArray((int[])brokerListToReassign), topicsToReassign);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long logDirThrottle, long timeoutMs, Time time) {
        void mkString_sep;
        Map<TopicPartition, Throwable> errors;
        void var13_10;
        void var12_9;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedParts = (Map)tuple2._1();
        Map proposedReplicas = (Map)tuple2._2();
        scala.collection.mutable.Map currentReassignments = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.listPartitionReassignments().reassignments().get())).asScala();
        if (!additional && currentReassignments.nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        this.verifyBrokerIds(adminClient, (scala.collection.immutable.Set<Object>)((IterableOnceOps)var12_9.values().flatten((Function1)$less$colon$less$.MODULE$.refl())).toSet());
        Map<TopicPartition, Seq<Object>> currentParts = this.getReplicaAssignmentForPartitions(adminClient, (scala.collection.immutable.Set<TopicPartition>)var12_9.keySet().toSet());
        String println_x = this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)var12_9, currentParts);
        Console$.MODULE$.println((Object)println_x);
        Object var26_13 = null;
        if (interBrokerThrottle >= 0L || logDirThrottle >= 0L) {
            String println_x2 = this.youMustRunVerifyPeriodicallyMessage();
            Console$.MODULE$.println((Object)println_x2);
            Object var27_14 = null;
            scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateMoveMap((Map<TopicPartition, PartitionReassignment>)currentReassignments, (Map<TopicPartition, Seq<Object>>)var12_9, currentParts);
            Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
            Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
            this.modifyTopicThrottles(adminClient, leaderThrottles, followerThrottles);
            scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
            scala.collection.immutable.Set<Object> movingBrokers = this.calculateMovingBrokers((scala.collection.immutable.Set<TopicPartitionReplica>)var13_10.keySet().toSet());
            this.modifyBrokerThrottles(adminClient, reassigningBrokers, interBrokerThrottle, movingBrokers, logDirThrottle);
            if (interBrokerThrottle >= 0L) {
                String println_x3 = new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString();
                Console$.MODULE$.println((Object)println_x3);
                Object var28_20 = null;
            }
            if (logDirThrottle >= 0L) {
                String println_x4 = new StringBuilder(52).append("The replica-alter-dir throttle limit was set to ").append(logDirThrottle).append(" B/s").toString();
                Console$.MODULE$.println((Object)println_x4);
                Object var29_21 = null;
            }
        }
        if ((errors = this.alterPartitionReassignments(adminClient, (Map<TopicPartition, Seq<Object>>)var12_9)).nonEmpty()) {
            void mkString_sep2;
            Object[] objectArray = new Object[1];
            Set set = errors.keySet();
            if (set == null) {
                throw null;
            }
            Set toBuffer_this = set;
            Object var22_23 = null;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)((IterableOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)x0$1 -> new StringBuilder(2).append(x0$1).append(": ").append(((Throwable)errors.apply(x0$1)).getMessage()).toString());
            String string = System.lineSeparator();
            if (iterableOnceOps == null) {
                throw null;
            }
            string = null;
            objectArray[0] = iterableOnceOps.mkString("", (String)mkString_sep2, "");
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension("Error reassigning partition(s):%n%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = var12_9.size() == 1 ? "" : "s";
        Set set = var12_9.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var24_25 = null;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)));
        String string = ",";
        if (iterableOnceOps == null) {
            throw null;
        }
        string = null;
        objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
        String println_x5 = StringOps$.MODULE$.format$extension("Successfully started partition reassignment%s for %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        Console$.MODULE$.println((Object)println_x5);
        Object var30_27 = null;
        if (var13_10.nonEmpty()) {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)var13_10, timeoutMs, time);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void executeMoves(Admin adminClient, Map<TopicPartitionReplica, String> proposedReplicas, long timeoutMs, Time time) {
        long startTimeMs = time.milliseconds();
        scala.collection.mutable.HashMap pendingReplicas = new scala.collection.mutable.HashMap();
        pendingReplicas.addAll(proposedReplicas);
        boolean done = false;
        do {
            scala.collection.immutable.Set<TopicPartitionReplica> completed;
            if ((completed = this.alterReplicaLogDirs(adminClient, (Map<TopicPartitionReplica, String>)pendingReplicas)).nonEmpty()) {
                void mkString_sep;
                Object[] objectArray = new Object[2];
                objectArray[0] = completed.size() == 1 ? "" : "s";
                IterableOnceOps iterableOnceOps = (IterableOnceOps)((Buffer)Buffer$.MODULE$.from(completed)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)));
                String string = ",";
                if (iterableOnceOps == null) {
                    throw null;
                }
                string = null;
                objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
                String println_x = StringOps$.MODULE$.format$extension("Successfully started log directory move%s for: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
                Console$.MODULE$.println((Object)println_x);
                Object var14_10 = null;
            }
            pendingReplicas.subtractAll(completed);
            if (pendingReplicas.isEmpty()) {
                done = true;
                continue;
            }
            if (time.milliseconds() >= startTimeMs + timeoutMs) {
                void mkString_sep;
                Object[] objectArray = new Object[2];
                objectArray[0] = pendingReplicas.size() == 1 ? "" : "s";
                Set set = pendingReplicas.keySet();
                if (set == null) {
                    throw null;
                }
                Set toBuffer_this = set;
                Object var12_11 = null;
                IterableOnceOps iterableOnceOps = (IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)));
                String string = ",";
                if (iterableOnceOps == null) {
                    throw null;
                }
                string = null;
                objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension("Timed out before log directory move%s could be started for: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
            }
            time.sleep(100L);
        } while (!done);
    }

    public void listReassignments(Admin adminClient) {
        String println_x = this.curReassignmentsToString(adminClient);
        Console$.MODULE$.println((Object)println_x);
    }

    /*
     * WARNING - void declaration
     */
    public String curReassignmentsToString(Admin adminClient) {
        void mkString_sep;
        scala.collection.mutable.Map currentReassignments = AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.listPartitionReassignments().reassignments().get())).asScala();
        Set set = currentReassignments.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var4_3 = null;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((IterableOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)part -> {
            String string;
            Object object;
            void mkString_sep;
            PartitionReassignment reassignment = (PartitionReassignment)currentReassignments.apply(part);
            Buffer replicas = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)reassignment.replicas()).asScala();
            Buffer addingReplicas = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)reassignment.addingReplicas()).asScala();
            Buffer removingReplicas = AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (List)reassignment.removingReplicas()).asScala();
            Object[] objectArray = new Object[4];
            objectArray[0] = part;
            String string2 = ",";
            if (replicas == null) {
                throw null;
            }
            string2 = null;
            objectArray[1] = replicas.mkString("", (String)mkString_sep, "");
            if (addingReplicas.isEmpty()) {
                object = "";
            } else {
                Object[] objectArray2 = new Object[1];
                String mkString_sep2 = ",";
                Object var7_7 = null;
                objectArray2[0] = addingReplicas.mkString("", mkString_sep2, "");
                object = objectArray[2] = StringOps$.MODULE$.format$extension(" adding: %s.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray2));
            }
            if (removingReplicas.isEmpty()) {
                string = "";
            } else {
                Object[] objectArray3 = new Object[1];
                String mkString_sep3 = ",";
                Object var8_8 = null;
                objectArray3[0] = removingReplicas.mkString("", mkString_sep3, "");
                string = StringOps$.MODULE$.format$extension(" removing: %s.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray3));
            }
            objectArray[3] = string;
            return StringOps$.MODULE$.format$extension("%s: replicas: %s.%s%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        });
        String string = System.lineSeparator();
        if (iterableOnceOps == null) {
            throw null;
        }
        string = null;
        String text = iterableOnceOps.mkString("", (String)mkString_sep, "");
        if (text.isEmpty()) {
            return "No partition reassignments found.";
        }
        return StringOps$.MODULE$.format$extension("Current partition reassignments:%n%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{text}));
    }

    public void verifyBrokerIds(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        Some some;
        scala.collection.immutable.Set allNodeIds = ((IterableOnceOps)AsScalaExtensions.CollectionHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Collection)((Collection)adminClient.describeCluster().nodes().get())).asScala().map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28.id()))).toSet();
        Option option = brokers.find((Function1)(JFunction1.mcZI.sp & Serializable)x$29 -> !allNodeIds.contains((Object)x$29));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        Some some2 = some;
        Some some3 = some;
        throw ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt((Object)map_this.get()));
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(KafkaZkClient zkClient, String reassignmentJson, long interBrokerThrottle) {
        void mkString_sep;
        void var6_5;
        void var7_6;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedParts = (Map)tuple2._1();
        Map proposedReplicas = (Map)tuple2._2();
        if (var7_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        this.verifyReplicasAndBrokersInAssignment(zkClient, (Map<TopicPartition, Seq<Object>>)var6_5);
        if (zkClient.reassignPartitionsInProgress()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        Map<TopicPartition, Seq<Object>> currentParts = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((IterableOnceOps)var6_5.map((Function1 & Serializable)x$31 -> ((TopicPartition)x$31._1()).topic())).toSet());
        String println_x = this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)var6_5, currentParts);
        Console$.MODULE$.println((Object)println_x);
        Object var15_8 = null;
        if (interBrokerThrottle >= 0L) {
            String println_x2 = this.youMustRunVerifyPeriodicallyMessage();
            Console$.MODULE$.println((Object)println_x2);
            Object var16_9 = null;
            scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateMoveMap((Map<TopicPartition, PartitionReassignment>)((Map)scala.collection.Map$.MODULE$.empty()), (Map<TopicPartition, Seq<Object>>)var6_5, currentParts);
            Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
            Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
            this.modifyTopicThrottles(zkClient, leaderThrottles, followerThrottles);
            scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
            this.modifyBrokerThrottles(zkClient, reassigningBrokers, interBrokerThrottle);
            String println_x3 = new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString();
            Console$.MODULE$.println((Object)println_x3);
            Object var17_14 = null;
        }
        zkClient.createPartitionReassignment((Map<TopicPartition, Seq<Object>>)var6_5);
        Object[] objectArray = new Object[2];
        objectArray[0] = var6_5.size() == 1 ? "" : "s";
        Set set = var6_5.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var13_15 = null;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)));
        String string = ",";
        if (iterableOnceOps == null) {
            throw null;
        }
        string = null;
        objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep, "");
        String println_x4 = StringOps$.MODULE$.format$extension("Successfully started partition reassignment%s for %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
        Console$.MODULE$.println((Object)println_x4);
    }

    public long executeAssignment$default$4() {
        return -1L;
    }

    public long executeAssignment$default$5() {
        return -1L;
    }

    public long executeAssignment$default$6() {
        return 10000L;
    }

    public Time executeAssignment$default$7() {
        return Time.SYSTEM;
    }

    public String currentPartitionReplicaAssignmentToString(Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        return StringOps$.MODULE$.format$extension("Current partition replica assignment%n%n%s%n%nSave this to use as the %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)((IterableOnceOps)currentParts.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$currentPartitionReplicaAssignmentToString$1(proposedParts, x0$1)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Map<TopicPartitionReplica, String>)((Map)scala.collection.Map$.MODULE$.empty())), "--reassignment-json-file option during rollback"}));
    }

    public void verifyReplicasAndBrokersInAssignment(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> proposedParts) {
        Iterable proposedTopics = (Iterable)proposedParts.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        });
        Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)proposedTopics.toSet());
        Iterable nonExistentPartitions = (Iterable)((IterableOps)proposedParts.map((Function1 & Serializable)x0$2 -> {
            void var1_1;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            return var1_1;
        })).filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((IterableOnceOps)((IterableOps)proposedParts.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).values().flatten((Function1)$less$colon$less$.MODULE$.refl())).filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            String mkString_sep = ",";
            Object var8_8 = null;
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString("", mkString_sep, "")).toString());
        }
    }

    public Map<TopicPartition, Throwable> alterPartitionReassignments(Admin adminClient, Map<TopicPartition, Seq<Object>> reassignments) {
        return (Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)adminClient.alterPartitionReassignments(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)reassignments.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)part, Optional.of(new NewPartitionReassignment(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)replicas.map((Function1 & Serializable)x$32 -> BoxesRunTime.unboxToInt((Object)x$32)))).asJava())));
            return tuple2;
        }))).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$2 -> {
            None$ none$;
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                try {
                    ((KafkaFuture)x0$2._2()).get();
                    none$ = None$.MODULE$;
                }
                catch (ExecutionException t) {
                    none$ = new Some((Object)new Tuple2((Object)part, (Object)t.getCause()));
                }
            } else {
                throw new MatchError(null);
            }
            None$ none$2 = none$;
            return none$2;
        });
    }

    public Map<TopicPartition, Throwable> cancelPartitionReassignments(Admin adminClient, scala.collection.immutable.Set<TopicPartition> reassignments) {
        return (Map)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)adminClient.alterPartitionReassignments(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((IterableOnceOps)reassignments.map((Function1 & Serializable)x$33 -> new Tuple2(x$33, (Object)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension((Option)None$.MODULE$)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            None$ none$;
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    none$ = None$.MODULE$;
                }
                catch (ExecutionException t) {
                    none$ = new Some((Object)new Tuple2((Object)part, (Object)t.getCause()));
                }
            } else {
                throw new MatchError(null);
            }
            None$ none$2 = none$;
            return none$2;
        });
    }

    public scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments, Map<TopicPartition, Seq<Object>> proposedReassignments, Map<TopicPartition, Seq<Object>> currentParts) {
        scala.collection.mutable.HashMap moveMap = new scala.collection.mutable.HashMap();
        currentReassignments.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
            ReassignPartitionsCommand.PartitionMove move = new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)new HashSet(), (scala.collection.mutable.Set<Object>)new HashSet());
            reassignment.replicas().forEach(replica -> {
                void $plus$eq_elem;
                Integer n;
                void $plus$eq_elem2;
                Integer n2;
                scala.collection.mutable.Set<Object> set = move.sources();
                Integer n3 = n2 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)replica));
                n2 = null;
                Integer n4 = n3;
                if (set == null) {
                    throw null;
                }
                set.addOne((Object)$plus$eq_elem2);
                n4 = null;
                scala.collection.mutable.Set<Object> set2 = move.destinations();
                Integer n5 = n = Integer.valueOf(BoxesRunTime.unboxToInt((Object)replica));
                n = null;
                Integer n6 = n5;
                if (set2 == null) {
                    throw null;
                }
                set2.addOne((Object)$plus$eq_elem);
            });
            reassignment.addingReplicas().forEach(x$34 -> {
                void $plus$eq_elem;
                Integer n;
                scala.collection.mutable.Set<Object> set = move.destinations();
                Integer n2 = n = Integer.valueOf(BoxesRunTime.unboxToInt((Object)x$34));
                n = null;
                Integer n3 = n2;
                if (set == null) {
                    throw null;
                }
                set.addOne((Object)$plus$eq_elem);
            });
            reassignment.removingReplicas().forEach(x$35 -> {
                void $minus$eq_elem;
                Integer n;
                scala.collection.mutable.Set<Object> set = move.destinations();
                Integer n2 = n = Integer.valueOf(BoxesRunTime.unboxToInt((Object)x$35));
                n = null;
                Integer n3 = n2;
                if (set == null) {
                    throw null;
                }
                set.subtractOne((Object)$minus$eq_elem);
            });
            Option option = ((scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable)() -> new scala.collection.mutable.HashMap())).put((Object)part.partition(), (Object)move);
            return option;
        });
        proposedReassignments.foreach((Function1 & Serializable)x0$2 -> {
            scala.collection.mutable.Set<Object> set;
            ReassignPartitionsCommand.PartitionMove move;
            Seq replicas;
            TopicPartition part;
            if (x0$2 != null) {
                part = (TopicPartition)x0$2._1();
                replicas = (Seq)x0$2._2();
                move = new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)new HashSet(), (scala.collection.mutable.Set<Object>)new HashSet());
                set = move.destinations();
                if (set == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            set.addAll((IterableOnce)replicas);
            Option option = ((scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable)() -> new scala.collection.mutable.HashMap())).put((Object)part.partition(), (Object)move);
            return option;
        });
        moveMap.foreach((Function1 & Serializable)x0$3 -> {
            ReassignPartitionsCommand$.$anonfun$calculateMoveMap$8(currentParts, x0$3);
            return BoxedUnit.UNIT;
        });
        moveMap.foreach((Function1 & Serializable)x0$5 -> {
            ReassignPartitionsCommand$.$anonfun$calculateMoveMap$10(x0$5);
            return BoxedUnit.UNIT;
        });
        return moveMap;
    }

    public Map<String, String> calculateLeaderThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable)x0$1 -> {
            void mkString_end;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topicName = (String)x0$1._1();
            scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
            TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
            partMoveMap.foreach((Function1 & Serializable)x0$2 -> {
                ReassignPartitionsCommand$.$anonfun$calculateLeaderThrottles$2(components, x0$2);
                return BoxedUnit.UNIT;
            });
            String mkString_sep = ",";
            String string = "";
            String mkString_start = "";
            Object var6_6 = null;
            string = null;
            Object var5_4 = null;
            Tuple2 tuple2 = new Tuple2((Object)topicName, (Object)IterableOnceOps.mkString$((IterableOnceOps)components, (String)mkString_start, (String)mkString_sep, (String)mkString_end));
            return tuple2;
        });
    }

    public Map<String, String> calculateFollowerThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable)x0$1 -> {
            void mkString_end;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topicName = (String)x0$1._1();
            scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
            TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
            partMoveMap.foreach((Function1 & Serializable)x0$2 -> {
                ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$2(components, x0$2);
                return BoxedUnit.UNIT;
            });
            String mkString_sep = ",";
            String string = "";
            String mkString_start = "";
            Object var6_6 = null;
            string = null;
            Object var5_4 = null;
            Tuple2 tuple2 = new Tuple2((Object)topicName, (Object)IterableOnceOps.mkString$((IterableOnceOps)components, (String)mkString_start, (String)mkString_sep, (String)mkString_end));
            return tuple2;
        });
    }

    public scala.collection.immutable.Set<Object> calculateReassigningBrokers(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        TreeSet reassigningBrokers = new TreeSet((Ordering)Ordering.Int$.MODULE$);
        moveMap.values().foreach((Function1 & Serializable)x$36 -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$1(reassigningBrokers, x$36);
            return BoxedUnit.UNIT;
        });
        return reassigningBrokers.toSet();
    }

    public scala.collection.immutable.Set<Object> calculateMovingBrokers(scala.collection.immutable.Set<TopicPartitionReplica> replicaMoves) {
        return ((IterableOnceOps)replicaMoves.map((Function1 & Serializable)x$39 -> BoxesRunTime.boxToInteger((int)x$39.brokerId()))).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void modifyTopicThrottles(Admin adminClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        void $plus$plus_that;
        HashMap configs = new HashMap();
        Set set = leaderThrottles.keySet();
        Set set2 = followerThrottles.keySet();
        if (set == null) {
            throw null;
        }
        set2 = null;
        ((Set)set.concat((IterableOnce)$plus$plus_that)).foreach((Function1 & Serializable)topicName -> {
            Option option;
            ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
            Option option2 = leaderThrottles.get(topicName);
            if (!None$.MODULE$.equals(option2)) {
                if (option2 instanceof Some) {
                    String value = (String)((Some)option2).value();
                    ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.topicLevelLeaderThrottle(), value), AlterConfigOp.OpType.SET));
                } else {
                    throw new MatchError((Object)option2);
                }
            }
            if (!None$.MODULE$.equals(option = followerThrottles.get(topicName))) {
                if (option instanceof Some) {
                    String value = (String)((Some)option).value();
                    ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.topicLevelFollowerThrottle(), value), AlterConfigOp.OpType.SET));
                } else {
                    throw new MatchError((Object)option);
                }
            }
            if (!ops.isEmpty()) {
                return configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), ops);
            }
            return BoxedUnit.UNIT;
        });
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    /*
     * WARNING - void declaration
     */
    public void modifyTopicThrottles(KafkaZkClient zkClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        void $plus$plus_that;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Set set = leaderThrottles.keySet();
        Set set2 = followerThrottles.keySet();
        if (set == null) {
            throw null;
        }
        set2 = null;
        ((Set)set.concat((IterableOnce)$plus$plus_that)).foreach((Function1 & Serializable)topicName -> {
            ReassignPartitionsCommand$.$anonfun$modifyTopicThrottles$2(adminZkClient, leaderThrottles, followerThrottles, topicName);
            return BoxedUnit.UNIT;
        });
    }

    public void modifyBrokerThrottles(Admin adminClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle, scala.collection.immutable.Set<Object> movingBrokers, long logDirThrottle) {
        HashMap configs = new HashMap();
        if (reassigningBrokers == null) {
            throw null;
        }
        reassigningBrokers.concat(movingBrokers).foreach((Function1 & Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyBrokerThrottles$1(interBrokerThrottle, reassigningBrokers, logDirThrottle, movingBrokers, configs, BoxesRunTime.unboxToInt((Object)brokerId)));
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    public void modifyBrokerThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        reassigningBrokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)id).toString());
            configs.put(MODULE$.brokerLevelLeaderThrottle(), ((Object)interBrokerThrottle).toString());
            configs.put(MODULE$.brokerLevelFollowerThrottle(), ((Object)interBrokerThrottle).toString());
            adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id}))), configs);
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> parseExecuteAssignmentArgs(String reassignmentJson) {
        void var4_4;
        void var3_3;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        if (var3_3.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment list cannot be empty");
        }
        if (var3_3.exists((Function1 & Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$1(x$43)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Iterable)var3_3.map((Function1 & Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            return var1_1;
        }));
        if (duplicateReassignedPartitions.nonEmpty()) {
            Object[] objectArray = new Object[1];
            String mkString_sep = ",";
            Object var8_6 = null;
            objectArray[0] = duplicateReassignedPartitions.mkString("", mkString_sep, "");
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Partition reassignment contains duplicate topic partitions: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        Seq duplicateEntries = (Seq)((IterableOps)var3_3.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple2;
        })).filter((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            void mkString_sep;
            String string;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)duplicateEntries.map((Function1 & Serializable)x0$4 -> {
                void mkString_sep;
                String string;
                Object[] objectArray;
                Iterable duplicateReplicas;
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    duplicateReplicas = (Iterable)x0$4._2();
                    objectArray = new Object[2];
                    objectArray[0] = tp;
                    string = ",";
                    if (duplicateReplicas == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                string = null;
                objectArray[1] = duplicateReplicas.mkString("", (String)mkString_sep, "");
                String string2 = StringOps$.MODULE$.format$extension("%s contains multiple entries for %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
                return string2;
            });
            String string2 = ". ";
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps mkString_this = iterableOnceOps;
            String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
            Object var9_9 = null;
            string2 = null;
            string = null;
            String duplicatesMsg = string3;
            throw new AdminCommandFailedException(StringOps$.MODULE$.format$extension("Partition replica lists may not contain duplicate entries: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        return new Tuple2((Object)var3_3.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<scala.collection.immutable.Set<TopicPartition>, scala.collection.immutable.Set<TopicPartitionReplica>> cancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, long timeoutMs, Time time) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetReplicas = (Map)tuple2._2();
        scala.collection.immutable.Set targetPartsSet = ((IterableOnceOps)var8_7.map((Function1 & Serializable)x$45 -> (TopicPartition)x$45._1())).toSet();
        scala.collection.immutable.Set curReassigningParts = ((IterableOnceOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)((java.util.Map)adminClient.listPartitionReassignments(AsJavaExtensions.SetHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Set)targetPartsSet).asJava()).reassignments().get())).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition part = (TopicPartition)x0$1._1();
            PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
            Some some = !reassignment.addingReplicas().isEmpty() || !reassignment.removingReplicas().isEmpty() ? new Some((Object)part) : None$.MODULE$;
            return some;
        })).toSet();
        if (curReassigningParts.nonEmpty()) {
            void mkString_sep;
            Map<TopicPartition, Throwable> errors = this.cancelPartitionReassignments(adminClient, (scala.collection.immutable.Set<TopicPartition>)curReassigningParts);
            if (errors.nonEmpty()) {
                void mkString_sep2;
                Object[] objectArray = new Object[2];
                objectArray[0] = errors.size() == 1 ? "" : "s";
                Set set = errors.keySet();
                if (set == null) {
                    throw null;
                }
                Set toBuffer_this = set;
                Object var14_12 = null;
                IterableOnceOps iterableOnceOps = (IterableOnceOps)((IterableOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply(part)).getMessage()).toString());
                String string = System.lineSeparator();
                if (iterableOnceOps == null) {
                    throw null;
                }
                string = null;
                objectArray[1] = iterableOnceOps.mkString("", (String)mkString_sep2, "");
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(StringOps$.MODULE$.format$extension("Error cancelling partition reassignment%s for:%n%s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = curReassigningParts.size() == 1 ? "" : "s";
            IterableOnceOps iterableOnceOps = (IterableOnceOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)curReassigningParts)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)));
            String string = ",";
            if (iterableOnceOps == null) {
                throw null;
            }
            string = null;
            objectArray[1] = String.valueOf(iterableOnceOps.mkString("", (String)mkString_sep, ""));
            String println_x = StringOps$.MODULE$.format$extension("Successfully cancelled partition reassignment%s for: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray));
            Console$.MODULE$.println((Object)println_x);
            Object var17_15 = null;
        } else {
            String println_x = "None of the specified partition reassignments are active.";
            Console$.MODULE$.println((Object)println_x);
            Object var18_16 = null;
        }
        scala.collection.immutable.Map curMovingParts = this.findLogDirMoveStates(adminClient, (Map<TopicPartitionReplica, String>)var9_8).flatMap((Function1 & Serializable)x0$2 -> {
            None$ none$;
            if (x0$2 != null) {
                TopicPartitionReplica part = (TopicPartitionReplica)x0$2._1();
                ReassignPartitionsCommand.LogDirMoveState moveState = (ReassignPartitionsCommand.LogDirMoveState)x0$2._2();
                if (moveState instanceof ReassignPartitionsCommand.ActiveMoveState) {
                    ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)moveState;
                    none$ = new Some((Object)new Tuple2((Object)part, (Object)activeMoveState.currentLogDir()));
                } else {
                    none$ = None$.MODULE$;
                }
            } else {
                throw new MatchError(null);
            }
            return none$;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (curMovingParts.isEmpty()) {
            String println_x = "None of the specified partition moves are active.";
            Console$.MODULE$.println((Object)println_x);
            Object var19_18 = null;
        } else {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)curMovingParts, timeoutMs, time);
        }
        if (!preserveThrottles) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var8_7);
        }
        return new Tuple2((Object)curReassigningParts, (Object)curMovingParts.keySet());
    }

    public long cancelAssignment$default$4() {
        return 10000L;
    }

    public Time cancelAssignment$default$5() {
        return Time.SYSTEM;
    }

    /*
     * WARNING - void declaration
     */
    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Integer n;
        Object[] objectArray = new Tuple2[2];
        Integer n2 = n = Integer.valueOf(1);
        n = null;
        Integer n3 = n2;
        String $minus$greater$extension_$this = "version";
        Object var3_5 = null;
        n3 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Set set = partitionsToBeReassigned.keySet();
        if (set == null) {
            throw null;
        }
        Set toBuffer_this = set;
        Object var5_6 = null;
        List list = AsJavaExtensions.BufferHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Buffer)((Buffer)((IterableOps)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).sortWith((Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable)tp -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_y3;
            Integer n;
            void $minus$greater$extension_y4;
            Seq replicas = (Seq)partitionsToBeReassigned.apply(tp);
            Object[] objectArray = new Tuple2[4];
            String string = tp.topic();
            String $minus$greater$extension_$this = "topic";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
            Integer n2 = n = Integer.valueOf(tp.partition());
            n = null;
            Integer n3 = n2;
            String $minus$greater$extension_$this2 = "partition";
            Object var6_8 = null;
            n3 = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
            List list = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)replicas).asJava();
            String $minus$greater$extension_$this3 = "replicas";
            Object var8_10 = null;
            list = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
            List list2 = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)((Seq)replicas.map((Function1 & Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$3(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt((Object)r))))).asJava();
            String $minus$greater$extension_$this4 = "log_dirs";
            Object var10_12 = null;
            list2 = null;
            objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
            return AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        }))).asJava();
        String $minus$greater$extension_$this2 = "partitions";
        Object var6_8 = null;
        list = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        return Json$.MODULE$.encodeAsString(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseTopicsData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestTopicsJsonVersion();
            }
            return this.parseTopicsData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)));
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parsePartitionReassignmentData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parsePartitionReassignmentData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer listBuffer;
                ListBuffer listBuffer2 = listBuffer = new ListBuffer();
                listBuffer = null;
                ListBuffer partitionAssignment = listBuffer2;
                scala.collection.mutable.Map replicaAssignment = (scala.collection.mutable.Map)Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_y10;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
        Seq validActions = (Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt(), opts.cancelOpt(), opts.listOpt()}));
        Seq allActions = (Seq)validActions.filter(arg_0 -> ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1$adapted(opts.options(), arg_0));
        if (allActions == null) {
            throw null;
        }
        if (allActions.length() != 1) {
            void mkString_sep;
            Object[] objectArray = new Object[1];
            IterableOnceOps iterableOnceOps = (IterableOnceOps)validActions.map((Function1 & Serializable)x$48 -> new StringBuilder(2).append("--").append(x$48.options().get(0)).toString());
            String string = ", ";
            if (iterableOnceOps == null) {
                throw null;
            }
            string = null;
            objectArray[0] = iterableOnceOps.mkString("", (String)mkString_sep, "");
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), StringOps$.MODULE$.format$extension("Command must include exactly one action: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)objectArray)));
        }
        OptionSpecBuilder action = (OptionSpecBuilder)allActions.apply(0);
        if (!opts.options().has(opts.zkConnectOpt()) && !opts.options().has(opts.bootstrapServerOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Please specify --bootstrap-server");
        }
        Object[] objectArray = new Tuple2[5];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{opts.reassignmentJsonFileOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this = opts.verifyOpt();
        Object var9_8 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y10);
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.brokerListOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this2 = opts.generateOpt();
        Object var11_10 = null;
        seqOps2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y9);
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{opts.reassignmentJsonFileOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this3 = opts.executeOpt();
        Object var13_12 = null;
        seqOps3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y8);
        SeqOps seqOps4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{opts.reassignmentJsonFileOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this4 = opts.cancelOpt();
        Object var15_14 = null;
        seqOps4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y7);
        SeqOps seqOps5 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        OptionSpecBuilder $minus$greater$extension_$this5 = opts.listOpt();
        Object var17_16 = null;
        seqOps5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y6);
        Map requiredArgs = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (scala.collection.immutable.Seq)requiredArgs.get((Object)action).get());
        Object[] objectArray2 = new Tuple2[5];
        SeqOps seqOps6 = scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{opts.bootstrapServerOpt(), opts.commandConfigOpt(), opts.preserveThrottlesOpt(), opts.zkConnectOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this6 = opts.verifyOpt();
        Object var19_19 = null;
        seqOps6 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y5);
        SeqOps seqOps7 = scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{opts.bootstrapServerOpt(), opts.brokerListOpt(), opts.commandConfigOpt(), opts.disableRackAware(), opts.zkConnectOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this7 = opts.generateOpt();
        Object var21_21 = null;
        seqOps7 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y4);
        SeqOps seqOps8 = scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{opts.additionalOpt(), opts.bootstrapServerOpt(), opts.commandConfigOpt(), opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.timeoutOpt(), opts.zkConnectOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this8 = opts.executeOpt();
        Object var23_23 = null;
        seqOps8 = null;
        objectArray2[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y3);
        SeqOps seqOps9 = scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{opts.bootstrapServerOpt(), opts.commandConfigOpt(), opts.preserveThrottlesOpt(), opts.timeoutOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this9 = opts.cancelOpt();
        Object var25_25 = null;
        seqOps9 = null;
        objectArray2[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y2);
        SeqOps seqOps10 = scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{opts.bootstrapServerOpt(), opts.commandConfigOpt()}));
        OptionSpecBuilder $minus$greater$extension_$this10 = opts.listOpt();
        Object var27_27 = null;
        seqOps10 = null;
        objectArray2[4] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y);
        Map permittedArgs = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        opts.options().specs().forEach(opt -> {
            if (!(opt.equals(action) || ((SeqOps)requiredArgs.apply((Object)action)).contains(opt) || ((SeqOps)permittedArgs.apply((Object)action)).contains(opt))) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), StringOps$.MODULE$.format$extension("Option \"%s\" can't be used with action \"%s\"", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{opt, action})));
            }
        });
        if (!opts.options().has(opts.bootstrapServerOpt())) {
            ((Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{opts.additionalOpt(), opts.cancelOpt(), opts.commandConfigOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.listOpt(), opts.timeoutOpt()}))).foreach((Function1 & Serializable)opt -> {
                ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$4(opts, opt);
                return BoxedUnit.UNIT;
            });
        }
        return var2_2;
    }

    public scala.collection.immutable.Set<TopicPartitionReplica> alterReplicaLogDirs(Admin adminClient, Map<TopicPartitionReplica, String> assignment) {
        return ((IterableOnceOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.Map)adminClient.alterReplicaLogDirs(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, assignment).asJava()).values()).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            Some some;
            if (x0$1 != null) {
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    some = new Some((Object)replica);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (!(throwable instanceof ReplicaNotAvailableException)) {
                        if (throwable != null) {
                            throw new AdminCommandFailedException(new StringBuilder(24).append("Failed to alter dir for ").append(replica).toString(), throwable);
                        }
                        throw new MatchError(null);
                    }
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
            } else {
                throw new MatchError(null);
            }
            Some some2 = some;
            return some2;
        })).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$findPartitionReassignmentStates$1(scala.collection.mutable.Map currentReassignments$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition part = (TopicPartition)x0$1._1();
        boolean bl = currentReassignments$1.contains((Object)part);
        return bl;
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$3(Integer i) {
        return BoxesRunTime.unboxToInt((Object)i);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$6(Integer x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$findPartitionReassignmentStates$8(KafkaZkClient zkClient$1, scala.collection.mutable.HashMap results$1, Map partitionsBeingReassigned$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void apply_elems;
            String topic = (String)x0$1._1();
            Map partitions = (Map)x0$1._2();
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient$1.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
            partitions.foreach((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition partition = (TopicPartition)x0$2._1();
                Seq targetReplicas = (Seq)x0$2._2();
                Seq currentReplicas = (Seq)replicasForTopic.getOrElse((Object)partition, (Function0 & Serializable)() -> (Seq)scala.collection.Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
                Option option = results$1.put((Object)partition, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)currentReplicas, (Seq<Object>)targetReplicas, !partitionsBeingReassigned$1.contains((Object)partition)));
                return option;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$clearTopicLevelThrottles$3(AdminZkClient adminZkClient$2, String topic) {
        Properties configs = adminZkClient$2.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        if (((IterableOnceOps)MODULE$.topicLevelThrottles().flatMap((Function1 & Serializable)throttle -> Option$.MODULE$.apply(configs.remove(throttle)))).nonEmpty()) {
            adminZkClient$2.changeTopicConfig(topic, configs);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadata$3(BrokerMetadata x$25) {
        return x$25.rack().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$parseGenerateAssignmentArgs$1(String x$26) {
        return Integer.parseInt(x$26);
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3(int id) {
        throw new AdminCommandFailedException(new StringBuilder(18).append("Unknown broker id ").append(id).toString());
    }

    public static final /* synthetic */ boolean $anonfun$currentPartitionReplicaAssignmentToString$1(Map proposedParts$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition k = (TopicPartition)x0$1._1();
        boolean bl = proposedParts$1.contains((Object)k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$calculateMoveMap$8(Map currentParts$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String topicName = (String)x0$3._1();
            ((scala.collection.mutable.Map)x0$3._2()).foreach((Function1 & Serializable)x0$4 -> {
                Growable growable;
                if (x0$4 == null) throw new MatchError(null);
                int partitionIndex = x0$4._1$mcI$sp();
                ReassignPartitionsCommand.PartitionMove moves = (ReassignPartitionsCommand.PartitionMove)x0$4._2();
                Option option = currentParts$1.get((Object)new TopicPartition(topicName, partitionIndex));
                if (None$.MODULE$.equals(option)) {
                    return BoxedUnit.UNIT;
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Seq replicas = (Seq)((Some)option).value();
                scala.collection.mutable.Set<Object> set = moves.sources();
                if (set == null) {
                    throw null;
                }
                scala.collection.mutable.Set<Object> $plus$plus$eq_this = set;
                Growable growable2 = growable = $plus$plus$eq_this.addAll((IterableOnce)replicas);
                Object var8_8 = null;
                growable = null;
                return growable2;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateMoveMap$10(Tuple2 x0$5) {
        if (x0$5 != null) {
            ((scala.collection.mutable.Map)x0$5._2()).foreach((Function1 & Serializable)x0$6 -> {
                void $minus$minus$eq_xs;
                scala.collection.mutable.Set<Object> set;
                scala.collection.mutable.Set<Object> set2;
                if (x0$6 != null) {
                    ReassignPartitionsCommand.PartitionMove moves = (ReassignPartitionsCommand.PartitionMove)x0$6._2();
                    set2 = moves.destinations();
                    set = moves.sources();
                    if (set2 == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                set = null;
                scala.collection.mutable.Set set3 = (scala.collection.mutable.Set)set2.subtractAll((IterableOnce)$minus$minus$eq_xs);
                return set3;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateLeaderThrottles$2(TreeSet components$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ((ReassignPartitionsCommand.PartitionMove)x0$2._2()).sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable)source -> components$1.add((Object)StringOps$.MODULE$.format$extension("%d:%d", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{partId, source}))));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Object $anonfun$calculateFollowerThrottles$3(ReassignPartitionsCommand.PartitionMove move$2, TreeSet components$2, int partId$2, int destination) {
        if (!move$2.sources().contains((Object)destination)) {
            return components$2.add((Object)StringOps$.MODULE$.format$extension("%d:%d", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{partId$2, destination})));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calculateFollowerThrottles$2(TreeSet components$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ReassignPartitionsCommand.PartitionMove move = (ReassignPartitionsCommand.PartitionMove)x0$2._2();
            move.destinations().foreach((Function1 & Serializable)destination -> ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$3(move, components$2, partId, BoxesRunTime.unboxToInt((Object)destination)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$2(TreeSet reassigningBrokers$1, ReassignPartitionsCommand.PartitionMove partMove) {
        partMove.sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$37 -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)x$37)));
        partMove.destinations().foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$38 -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)x$38)));
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$1(TreeSet reassigningBrokers$1, scala.collection.mutable.Map x$36) {
        x$36.values().foreach((Function1 & Serializable)partMove -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$2(reassigningBrokers$1, partMove);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$modifyTopicThrottles$2(AdminZkClient adminZkClient$3, Map leaderThrottles$2, Map followerThrottles$2, String topicName) {
        Properties configs = adminZkClient$3.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topicName);
        Option option = leaderThrottles$2.get((Object)topicName);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
        } else {
            String string = (String)map_this.get();
            new Some(configs.put(ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), string));
        }
        Object var5_5 = null;
        Option option2 = followerThrottles$2.get((Object)topicName);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        if (map_this2.isEmpty()) {
        } else {
            String string = (String)map_this2.get();
            new Some(configs.put(ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), string));
        }
        Object var6_7 = null;
        adminZkClient$3.changeTopicConfig(topicName, configs);
    }

    public static final /* synthetic */ Object $anonfun$modifyBrokerThrottles$1(long interBrokerThrottle$1, scala.collection.immutable.Set reassigningBrokers$2, long logDirThrottle$1, scala.collection.immutable.Set movingBrokers$1, HashMap configs$5, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        if (interBrokerThrottle$1 >= 0L && reassigningBrokers$2.contains((Object)brokerId)) {
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLeaderThrottle(), ((Object)interBrokerThrottle$1).toString()), AlterConfigOp.OpType.SET));
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelFollowerThrottle(), ((Object)interBrokerThrottle$1).toString()), AlterConfigOp.OpType.SET));
        }
        if (logDirThrottle$1 >= 0L && movingBrokers$1.contains((Object)brokerId)) {
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLogDirThrottle(), ((Object)logDirThrottle$1).toString()), AlterConfigOp.OpType.SET));
        }
        if (!ops.isEmpty()) {
            return configs$5.put(new ConfigResource(ConfigResource.Type.BROKER, ((Object)brokerId).toString()), ops);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$1(Tuple2 x$43) {
        return ((SeqOps)x$43._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Iterable)x0$3._2()).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$3(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0 & Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$47) {
        Object object = x$47._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable)p -> {
            void $plus$plus$eq_xs;
            Tuple2 tuple2;
            TopicPartition topicPartition;
            Seq seq;
            void decodeSeq_factory;
            Factory factory;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            scala.collection.Seq$ iterableFactory_this = scala.collection.Seq$.MODULE$;
            Factory factory2 = factory = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this);
            Object var13_6 = null;
            factory = null;
            Factory factory3 = factory2;
            DecodeJson$DecodeInt$ decodeSeq_decodeJson = DecodeJson$DecodeInt$.MODULE$;
            Object var17_9 = null;
            factory3 = null;
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(new DecodeJson<S>(decodeSeq_decodeJson, (Factory)decodeSeq_factory){
                private final DecodeJson decodeJson$2;
                private final Factory factory$1;

                public Object decode(JsonNode node) {
                    return DecodeJson.decode$(this, node);
                }

                public final Either<String, S> decodeEither(JsonNode node) {
                    return DecodeJson$.kafka$utils$json$DecodeJson$$$anonfun$decodeSeq$1(node, this.decodeJson$2, this.factory$1);
                }
                {
                    this.decodeJson$2 = decodeJson$2;
                    this.factory$1 = factory$1;
                }
            });
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                void decodeSeq_factory2;
                Factory factory4;
                scala.collection.Seq$ iterableFactory_this2 = scala.collection.Seq$.MODULE$;
                Factory factory5 = factory4 = IterableFactory.iterableFactory$((IterableFactory)iterableFactory_this2);
                Object var15_12 = null;
                factory4 = null;
                Factory factory6 = factory5;
                DecodeJson$DecodeString$ decodeSeq_decodeJson2 = DecodeJson$DecodeString$.MODULE$;
                Object var19_15 = null;
                factory6 = null;
                seq = (Seq)((JsonValue)((Some)option).value()).to(new /* invalid duplicate definition of identical inner class */);
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable)x$46 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir());
            } else {
                throw new MatchError(option);
            }
            if (newReplicas == null) {
                throw null;
            }
            if (seq == null) {
                throw null;
            }
            if (newReplicas.length() != seq.length()) {
                throw new AdminCommandFailedException(new StringBuilder(0).append(new StringBuilder(41).append("Size of replicas list ").append(newReplicas).append(" is different from ").toString()).append(new StringBuilder(37).append("size of log dirs list ").append(seq).append(" for partition ").append(new TopicPartition(topic, partition)).toString()).toString());
            }
            TopicPartition topicPartition2 = topicPartition = new TopicPartition(topic, partition);
            topicPartition = null;
            TopicPartition $minus$greater$extension_$this = topicPartition2;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)newReplicas);
            Object var9_18 = null;
            tuple2 = null;
            Tuple2 $plus$eq_elem = tuple22;
            partitionAssignment$1.addOne((Object)$plus$eq_elem);
            Object var11_20 = null;
            IterableOnce iterableOnce = (IterableOnce)((IterableOps)((IterableOps)newReplicas.zip((IterableOnce)seq)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2;
                TopicPartitionReplica topicPartitionReplica;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int replica = x0$1._1$mcI$sp();
                String logDir = (String)x0$1._2();
                TopicPartitionReplica topicPartitionReplica2 = topicPartitionReplica = new TopicPartitionReplica(topic, partition, replica);
                topicPartitionReplica = null;
                TopicPartitionReplica $minus$greater$extension_$this = topicPartitionReplica2;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
                Object var6_6 = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            })).filter((Function1 & Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$47)));
            if (replicaAssignment$1 == null) {
                throw null;
            }
            return (scala.collection.mutable.Map)replicaAssignment$1.addAll((IterableOnce)$plus$plus$eq_xs);
        });
    }

    public static final /* synthetic */ void $anonfun$validateAndParseArgs$4(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, AbstractOptionSpec opt) {
        if (opts$1.options().has((OptionSpec)opt)) {
            throw new RuntimeException(new StringBuilder(36).append("You must specify --bootstrap-server ").append(StringOps$.MODULE$.format$extension("when using \"%s\"", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{opt}))).toString());
        }
    }

    private ReassignPartitionsCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$parseGenerateAssignmentArgs$1$adapted(String x$26) {
        return BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$parseGenerateAssignmentArgs$1(x$26));
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3$adapted(Object id) {
        return ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt((Object)id));
    }

    public static final /* synthetic */ Object $anonfun$validateAndParseArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

