/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.LastRecord;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=e!\u0002\u0012$\u0001\r:\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011\u0001\u001c\t\u0011i\u0002!\u0011!Q\u0001\n]B\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005{!AA\n\u0001B\u0001B\u0003%q\u0007\u0003\u0005N\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0005A!A!\u0002\u0013y\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u0011Y\u0003!\u0011!Q\u0001\n]C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006S\u0002!\tA\u001b\u0005\u0006k\u0002!\tF\u001e\u0005\t\u007f\u0002\u0001\r\u0011\"\u0003\u0002\u0002!I\u0011q\u0002\u0001A\u0002\u0013%\u0011\u0011\u0003\u0005\t\u0003/\u0001\u0001\u0015)\u0003\u0002\u0004!I\u0011\u0011\u0004\u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;A\u0001\"!\t\u0001A\u0003&\u00111\u0001\u0005\n\u0003G\u0001!\u0019!C\u0005\u0003KA\u0001\"!\f\u0001A\u0003%\u0011q\u0005\u0005\t\u0003_\u0001A\u0011A\u0012\u00022!A\u0011q\n\u0001\u0005\u0002\r\n\t\u0006\u0003\u0005\u0002Z\u0001!\taIA.\u0011!\t\u0019\n\u0001C\u0001G\u0005U\u0005bBAp\u0001\u0011%\u0011\u0011\u001d\u0005\b\u0003k\u0004A\u0011BA|\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqA!\b\u0001\t\u0003\u0011y\u0002C\u0004\u0003$\u0001!\tA!\n\t\u0011\t\u001d\u0002\u0001\"\u0001$\u0005SAqAa\u0016\u0001\t\u0013\u0011I\u0006\u0003\u0005\u0003d\u0001!\ta\tB3\u0011\u001d\u0011)\b\u0001C\u0005\u0005o\u0012qa\u00117fC:,'O\u0003\u0002%K\u0005\u0019An\\4\u000b\u0003\u0019\nQa[1gW\u0006\u001c2\u0001\u0001\u0015/!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011qFM\u0007\u0002a)\u0011\u0011'J\u0001\u0006kRLGn]\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\u0002jI\u000e\u0001Q#A\u001c\u0011\u0005%B\u0014BA\u001d+\u0005\rIe\u000e^\u0001\u0004S\u0012\u0004\u0013!C8gMN,G/T1q+\u0005i\u0004C\u0001 J\u001b\u0005y$B\u0001\u0013A\u0015\t\t%)A\u0005j]R,'O\\1mg*\u00111\tR\u0001\bgR|'/Y4f\u0015\t1SI\u0003\u0002G\u000f\u00061\u0011\r]1dQ\u0016T\u0011\u0001S\u0001\u0004_J<\u0017B\u0001&@\u0005%yeMZ:fi6\u000b\u0007/\u0001\u0006pM\u001a\u001cX\r^'ba\u0002\nA\"[8Ck\u001a4WM]*ju\u0016\fq\"\\1y\u0013>\u0014UO\u001a4feNK'0Z\u0001\u0014IV\u0004()\u001e4gKJdu.\u00193GC\u000e$xN\u001d\t\u0003SAK!!\u0015\u0016\u0003\r\u0011{WO\u00197f\u0003%!\bN]8ui2,'\u000f\u0005\u00020)&\u0011Q\u000b\r\u0002\n)\"\u0014x\u000e\u001e;mKJ\fA\u0001^5nKB\u0011\u0001\fX\u0007\u00023*\u0011\u0011G\u0017\u0006\u00037\u0012\u000baaY8n[>t\u0017BA/Z\u0005\u0011!\u0016.\\3\u0002\u0013\rDWmY6E_:,\u0007\u0003B\u0015aE\u001aL!!\u0019\u0016\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA2e\u001b\u0005Q\u0016BA3[\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!K4\n\u0005!T#\u0001B+oSR\fa\u0001P5oSRtD#C6n]>\u0004\u0018O]:u!\ta\u0007!D\u0001$\u0011\u0015!4\u00021\u00018\u0011\u0015Y4\u00021\u0001>\u0011\u0015a5\u00021\u00018\u0011\u0015i5\u00021\u00018\u0011\u0015q5\u00021\u0001P\u0011\u0015\u00116\u00021\u0001T\u0011\u001516\u00021\u0001X\u0011\u0015q6\u00021\u0001`\u0003)awnZ4fe:\u000bW.Z\u000b\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0005Y\u0006twMC\u0001}\u0003\u0011Q\u0017M^1\n\u0005yL(AB*ue&tw-\u0001\u0006sK\u0006$')\u001e4gKJ,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003|\u0003\rq\u0017n\\\u0005\u0005\u0003\u001b\t9A\u0001\u0006CsR,')\u001e4gKJ\faB]3bI\n+hMZ3s?\u0012*\u0017\u000fF\u0002g\u0003'A\u0011\"!\u0006\u000f\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'A\u0006sK\u0006$')\u001e4gKJ\u0004\u0013aC<sSR,')\u001e4gKJ\fqb\u001e:ji\u0016\u0014UO\u001a4fe~#S-\u001d\u000b\u0004M\u0006}\u0001\"CA\u000b#\u0005\u0005\t\u0019AA\u0002\u000319(/\u001b;f\u0005V4g-\u001a:!\u0003m!WmY8naJ,7o]5p]\n+hMZ3s'V\u0004\b\u000f\\5feV\u0011\u0011q\u0005\t\u00041\u0006%\u0012bAA\u00163\nq!)\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001\b3fG>l\u0007O]3tg&|gNQ;gM\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u0006G2,\u0017M\u001c\u000b\u0005\u0003g\t)\u0005E\u0004*\u0003k\tI$a\u0010\n\u0007\u0005]\"F\u0001\u0004UkBdWM\r\t\u0004S\u0005m\u0012bAA\u001fU\t!Aj\u001c8h!\ra\u0017\u0011I\u0005\u0004\u0003\u0007\u001a#\u0001D\"mK\u0006tWM]*uCR\u001c\bbBA$+\u0001\u0007\u0011\u0011J\u0001\nG2,\u0017M\\1cY\u0016\u00042\u0001\\A&\u0013\r\tie\t\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0017a\u00023p\u00072,\u0017M\u001c\u000b\u0007\u0003g\t\u0019&!\u0016\t\u000f\u0005\u001dc\u00031\u0001\u0002J!9\u0011q\u000b\fA\u0002\u0005e\u0012aC2veJ,g\u000e\u001e+j[\u0016\fQb\u00197fC:\u001cVmZ7f]R\u001cHc\u00044\u0002^\u0005\u0015\u00141PA@\u0003\u0003\u000b))a$\t\r\u0011:\u0002\u0019AA0!\ra\u0017\u0011M\u0005\u0004\u0003G\u001a#AC+oS\u001aLW\r\u001a'pO\"9\u0011qM\fA\u0002\u0005%\u0014\u0001C:fO6,g\u000e^:\u0011\r\u0005-\u0014\u0011OA;\u001b\t\tiGC\u0002\u0002p)\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0007M+\u0017\u000fE\u0002m\u0003oJ1!!\u001f$\u0005)aunZ*fO6,g\u000e\u001e\u0005\u0007\u0003{:\u0002\u0019A\u001f\u0002\u00075\f\u0007\u000fC\u0004\u0002X]\u0001\r!!\u000f\t\u000f\u0005\ru\u00031\u0001\u0002@\u0005)1\u000f^1ug\"9\u0011qQ\fA\u0002\u0005%\u0015a\u0005;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007c\u00017\u0002\f&\u0019\u0011QR\u0012\u00035\rcW-\u00198fIR\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\t\u000f\u0005Eu\u00031\u0001\u0002:\u0005)B.Z4bGf$U\r\\3uK\"{'/\u001b>p]6\u001b\u0018!C2mK\u0006t\u0017J\u001c;p)]1\u0017qSAN\u0003W\u000by+!-\u0002<\u0006}\u00161YAc\u00037\fi\u000e\u0003\u0004\u0002\u001ab\u0001\rAY\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\ti\n\u0007a\u0001\u0003?\u000bQb]8ve\u000e,'+Z2pe\u0012\u001c\b\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015&,\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003S\u000b\u0019KA\u0006GS2,'+Z2pe\u0012\u001c\bbBAW1\u0001\u0007\u0011QO\u0001\u0005I\u0016\u001cH\u000f\u0003\u0004\u0002~a\u0001\r!\u0010\u0005\b\u0003gC\u0002\u0019AA[\u0003\u0001\u0012X\r^1j]2+w-Y2z\t\u0016dW\r^3t\u0003:$G\u000b\u001f8NCJ\\WM]:\u0011\u0007%\n9,C\u0002\u0002:*\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002>b\u0001\r!!\u000f\u0002#\u0011,G.\u001a;f%\u0016$XM\u001c;j_:l5\u000f\u0003\u0004\u0002Bb\u0001\raN\u0001\u0012[\u0006DHj\\4NKN\u001c\u0018mZ3TSj,\u0007bBAD1\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003\u000fD\u0002\u0019AAe\u0003qa\u0017m\u001d;SK\u000e|'\u000fZ:PM\u0006\u001bG/\u001b<f!J|G-^2feN\u0004\u0002\"a3\u0002R\u0006e\u0012Q[\u0007\u0003\u0003\u001bTA!a4\u0002n\u00059Q.\u001e;bE2,\u0017\u0002BAj\u0003\u001b\u00141!T1q!\rq\u0014q[\u0005\u0004\u00033|$A\u0003'bgR\u0014VmY8sI\"9\u00111\u0011\rA\u0002\u0005}\u0002bBA,1\u0001\u0007\u0011\u0011H\u0001\u0012OJ|wOQ;gM\u0016\u00148o\u0014:GC&dG#\u00034\u0002d\u0006\u0015\u0018\u0011^Av\u0011\u001d\ti*\u0007a\u0001\u0003?Ca!a:\u001a\u0001\u00049\u0014\u0001\u00039pg&$\u0018n\u001c8\t\r\u0005\u0005\u0017\u00041\u00018\u0011\u001d\ti/\u0007a\u0001\u0003_\fQ\"\\3n_JL(+Z2pe\u0012\u001c\b\u0003BAQ\u0003cLA!a=\u0002$\niQ*Z7pef\u0014VmY8sIN\f!c\u001d5pk2$G)[:dCJ$')\u0019;dQR1\u0011QWA}\u0005\u0007Aq!a?\u001b\u0001\u0004\ti0A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002\"\u0006}\u0018\u0002\u0002B\u0001\u0003G\u00131BU3d_J$')\u0019;dQ\"9\u0011q\u0011\u000eA\u0002\u0005%\u0015AE:i_VdGMU3uC&t'+Z2pe\u0012$b\"!.\u0003\n\t-!q\u0002B\t\u00053\u0011Y\u0002\u0003\u0004\u0002~m\u0001\r!\u0010\u0005\b\u0005\u001bY\u0002\u0019AA[\u0003u\u0011X\r^1j]\u0012+G.\u001a;fg\u001a{'\u000fT3hC\u000eL(+Z2pe\u0012\u001c\bbBA~7\u0001\u0007\u0011Q \u0005\b\u0003K[\u0002\u0019\u0001B\n!\u0011\t\tK!\u0006\n\t\t]\u00111\u0015\u0002\u0007%\u0016\u001cwN\u001d3\t\u000f\u0005\r5\u00041\u0001\u0002@!9\u0011qK\u000eA\u0002\u0005e\u0012aC4s_^\u0014UO\u001a4feN$2A\u001aB\u0011\u0011\u0019\t\t\r\ba\u0001o\u0005q!/Z:u_J,')\u001e4gKJ\u001cH#\u00014\u0002'\u001d\u0014x.\u001e9TK\u001elWM\u001c;t\u0005f\u001c\u0016N_3\u0015\u0015\t-\"1\tB&\u0005\u001f\u0012\u0019\u0006\u0005\u0004\u0003.\tu\u0012\u0011\u000e\b\u0005\u0005_\u0011ID\u0004\u0003\u00032\t]RB\u0001B\u001a\u0015\r\u0011)$N\u0001\u0007yI|w\u000e\u001e \n\u0003-J1Aa\u000f+\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0010\u0003B\t!A*[:u\u0015\r\u0011YD\u000b\u0005\b\u0003Or\u0002\u0019\u0001B#!\u0019\tYGa\u0012\u0002v%!!\u0011JA7\u0005!IE/\u001a:bE2,\u0007B\u0002B'=\u0001\u0007q'A\u0004nCb\u001c\u0016N_3\t\r\tEc\u00041\u00018\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0011\u001d\u0011)F\ba\u0001\u0003s\taCZ5sgR,fn\u00197fC:\f'\r\\3PM\u001a\u001cX\r^\u0001\u001aY\u0006\u001cHo\u00144gg\u0016$hi\u001c:GSJ\u001cHoU3h[\u0016tG\u000f\u0006\u0004\u0002:\tm#\u0011\r\u0005\b\u0005;z\u0002\u0019\u0001B0\u0003\u0011\u0019XmZ:\u0011\r\t5\"QHA;\u0011\u001d\u0011)f\ba\u0001\u0003s\taBY;jY\u0012|eMZ:fi6\u000b\u0007\u000fF\u0006g\u0005O\u0012IG!\u001c\u0003r\tM\u0004B\u0002\u0013!\u0001\u0004\ty\u0006C\u0004\u0003l\u0001\u0002\r!!\u000f\u0002\u000bM$\u0018M\u001d;\t\u000f\t=\u0004\u00051\u0001\u0002:\u0005\u0019QM\u001c3\t\r\u0005u\u0004\u00051\u0001>\u0011\u001d\t\u0019\t\ta\u0001\u0003\u007f\t\u0001DY;jY\u0012|eMZ:fi6\u000b\u0007OR8s'\u0016<W.\u001a8u)I\t)L!\u001f\u0003|\t}$\u0011\u0011BC\u0005\u0013\u0013YI!$\t\r\u0005e\u0015\u00051\u0001c\u0011\u001d\u0011i(\ta\u0001\u0003k\nqa]3h[\u0016tG\u000f\u0003\u0004\u0002~\u0005\u0002\r!\u0010\u0005\b\u0005\u0007\u000b\u0003\u0019AA\u001d\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\t\u001d\u0015\u00051\u0001\u0002:\u00051b.\u001a=u'\u0016<W.\u001a8u'R\f'\u000f^(gMN,G\u000f\u0003\u0004\u0002B\u0006\u0002\ra\u000e\u0005\b\u0003\u000f\u000b\u0003\u0019AAE\u0011\u001d\t\u0019)\ta\u0001\u0003\u007f\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        return this.doClean(cleanable, this.time.milliseconds());
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long currentTime) {
        long l;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            l = ((LogSegment)((Some)option).value()).lastModified() - cleanable.log().config().deleteRetentionMs;
        } else {
            throw new MatchError((Object)option);
        }
        long legacyDeleteHorizonMs = l;
        UnifiedLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to upper bound deletion horizon %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(legacyDeleteHorizonMs)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), log.config().segmentSize, log.config().maxIndexSize, cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), currentTime, stats, transactionMetadata, legacyDeleteHorizonMs);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(UnifiedLog log, Seq<LogSegment> segments, OffsetMap map, long currentTime, CleanerStats stats, CleanedTransactionMetadata transactionMetadata, long legacyDeleteHorizonMs) {
        LogSegment cleaned = UnifiedLog$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> currentSegment.readNextOffset()));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainLegacyDeletesAndTxnMarkers = currentSegment.lastModified() > legacyDeleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cleaning ").append(currentSegment).append(" in log ").append(log.name()).append(" into ").append(cleaned.baseOffset()).append(" ").append("with an upper bound deletion horizon ").append(legacyDeleteHorizonMs).append(" computed from ").append("the segment last modified time of ").append(currentSegment.lastModified()).append(",").append((Object)(retainLegacyDeletesAndTxnMarkers ? "retaining" : "discarding")).append(" deletes.").toString());
                try {
                    this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainLegacyDeletesAndTxnMarkers, log.config().deleteRetentionMs, log.config().maxMessageSize(), transactionMetadata, lastOffsetOfActiveProducers, stats, currentTime);
                }
                catch (LogSegmentOffsetOverflowException e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Caught segment overflow error during cleaning: ").append(e.getMessage()).toString());
                    log.splitOverflowedSegment(currentSegment);
                    throw new LogCleaningAbortedException();
                }
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Swapping in cleaned segment ").append(cleaned).append(" for segment(s) ").append(segments).append(" in log ").append(log).toString());
            log.replaceSegments((Seq<LogSegment>)new .colon.colon((Object)cleaned, (List)Nil$.MODULE$), segments);
            return;
        }
        catch (LogCleaningAbortedException e) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception deleteException) {
                    e.addSuppressed(deleteException);
                }
            }
            catch (Throwable throwable) {
                throw e;
            }
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainLegacyDeletesAndTxnMarkers, long deleteRetentionMs, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers, CleanerStats stats, long currentTime) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, currentTime, deleteRetentionMs, transactionMetadata, lastRecordsOfActiveProducers, map, retainLegacyDeletesAndTxnMarkers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final OffsetMap map$1;
            private final boolean retainLegacyDeletesAndTxnMarkers$2;
            private final CleanerStats stats$3;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                boolean canDiscardBatch = this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2);
                if (batch.isControlBatch()) {
                    this.discardBatchRecords_$eq(canDiscardBatch && batch.deleteHorizonMs().isPresent() && batch.deleteHorizonMs().getAsLong() <= this.currentTime);
                } else {
                    this.discardBatchRecords_$eq(canDiscardBatch);
                }
                MemoryRecords.RecordFilter.BatchRetention batchRetention = batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
                return new MemoryRecords.RecordFilter.BatchRetentionResult(batchRetention, canDiscardBatch && batch.isControlBatch());
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                if (this.discardBatchRecords()) {
                    return false;
                }
                if (batch.isControlBatch()) {
                    return true;
                }
                return this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$1, this.retainLegacyDeletesAndTxnMarkers$2, batch, record, this.stats$3, this.currentTime);
            }

            public static final /* synthetic */ boolean $anonfun$checkBatchRetention$1(RecordBatch batch$1, LastRecord lastRecord) {
                if (lastRecord.lastDataOffset.isPresent()) {
                    return batch$1.lastOffset() == lastRecord.lastDataOffset.getAsLong();
                }
                return batch$1.isControlBatch() && batch$1.producerEpoch() == lastRecord.producerEpoch;
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                return this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId())).exists((Function1 & Serializable & scala.Serializable)lastRecord -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$checkBatchRetention$1(batch$1, lastRecord)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.map$1 = map$1;
                this.retainLegacyDeletesAndTxnMarkers$2 = retainLegacyDeletesAndTxnMarkers$2;
                this.stats$3 = stats$3;
                super(currentTime$2, deleteRetentionMs$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$checkBatchRetention$1$adapted(org.apache.kafka.common.record.RecordBatch org.apache.kafka.storage.internals.log.LastRecord )}, serializedLambda);
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringBuilder(25).append("log segment ").append(sourceRecords.file()).append(" at position ").append(position).toString();
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringBuilder(40).append("Could not determine next batch size for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringBuilder(24).append("Invalid batch size ").append(nextBatchSize).append(" for ").append(logDesc).toString());
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.readBuffer().capacity()) {
                throw new IllegalStateException(new StringBuilder(50).append("Batch size ").append(nextBatchSize).append(" < buffer size ").append(this.readBuffer().capacity()).append(", but not processed for ").append(logDesc).toString());
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringBuilder(69).append("Log segment may be corrupt, batch size ").append(nextBatchSize).append(" > ").append(bytesLeft).append(" bytes left in segment for ").append(logDesc).toString());
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata) {
        if (batch.isControlBatch()) {
            return transactionMetadata.onControlBatchRead(batch);
        }
        return transactionMetadata.onBatchRead(batch);
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletesForLegacyRecords, RecordBatch batch, Record record, CleanerStats stats, long currentTime) {
        if (record.offset() > map.latestOffset()) {
            return true;
        }
        if (record.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record.offset() >= foundOffset;
            boolean legacyRecord = batch.magic() < 2;
            boolean bl = isRetainedValue = record.hasValue() || Cleaner.shouldRetainDeletes$1(legacyRecord, batch, currentTime, retainDeletesForLegacyRecords);
            return latestOffsetForKey && isRetainedValue;
        }
        stats.invalidMessage();
        return false;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Growing cleaner I/O buffers from ").append(this.readBuffer().capacity()).append(" bytes to ").append(newSize).append(" bytes.").toString());
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.readBuffer().capacity() > this.ioBufferSize) {
            this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            return;
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            .colon.colon group = new .colon.colon((Object)((LogSegment)segs.head()), (List)Nil$.MODULE$);
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && (((LogSegment)segs.head()).size() == 0 || this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE)) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        if (segs.size() > 1) {
            return ((LogSegment)segs.apply(1)).baseOffset() - 1L;
        }
        return firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(UnifiedLog log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1 & Serializable & scala.Serializable)nextSegment -> {
                nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                return BoxedUnit.UNIT;
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$3(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$4(full, x$15))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            Cleaner.$anonfun$buildOffsetMap$5(this, log, full, map, start, transactionMetadata, stats, dirty, x$16);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup((long)startOffset).position;
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                try {
                    segment.log().readInto(this.readBuffer(), position);
                }
                catch (Exception e) {
                    throw new KafkaException(new StringBuilder(67).append("Failed to read from segment ").append(segment).append(" of partition ").append(topicPartition).append(" ").append("while loading offset map").toString(), (Throwable)e);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(this, transactionMetadata, stats, startOffset, map, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
            map.updateLatestOffset(nextSegmentStartOffset - 1L);
            this.restoreBuffers();
            return false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private static final boolean shouldRetainDeletes$1(boolean legacyRecord$1, RecordBatch batch$2, long currentTime$3, boolean retainDeletesForLegacyRecords$1) {
        if (!legacyRecord$1) {
            return !batch$2.deleteHorizonMs().isPresent() || currentTime$3 < batch$2.deleteHorizonMs().getAsLong();
        }
        return retainDeletesForLegacyRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$4(BooleanRef full$1, Tuple2 x$15) {
        if (x$15 != null) {
            return !full$1.elem;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$5(Cleaner $this, UnifiedLog log$3, BooleanRef full$1, OffsetMap map$2, long start$1, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$4, Buffer dirty$1, Tuple2 x$16) {
        if (x$16 != null) {
            LogSegment segment = (LogSegment)x$16._1();
            long nextSegmentStartOffset = x$16._2$mcJ$sp();
            $this.checkDone.apply((Object)log$3.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$3.topicPartition(), segment, map$2, start$1, nextSegmentStartOffset, log$3.config().maxMessageSize(), transactionMetadata$3, stats$4);
            if (full$1.elem) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, CleanerStats stats$5, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$1) {
            if (map$3.size() < maxDesiredMapSize$1) {
                map$3.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(Cleaner $this, CleanedTransactionMetadata transactionMetadata$4, CleanerStats stats$5, long startOffset$1, OffsetMap map$3, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        if (batch.isControlBatch()) {
            transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
            stats$5.indexMessagesRead(1);
        } else if (transactionMetadata$4.onBatchRead((RecordBatch)batch)) {
            stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
        } else {
            try (CloseableIterator recordsIterator = batch.streamingIterator($this.decompressionBufferSupplier());){
                ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$2(startOffset$1, map$3, maxDesiredMapSize$1, nonLocalReturnKey1$1, stats$5, record);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (batch.lastOffset() >= startOffset$1) {
            map$3.updateLatestOffset(batch.lastOffset());
            return;
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(10).append("Cleaner ").append(id).append(": ").toString());
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

