/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kafka.server.AddPartitionsToTxnManager;
import kafka.server.AddPartitionsToTxnManager$;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AddPartitionsToTxnRequestData;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001\u0002\u001b6\u0001qBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004U\u0001\u0001\u0006I!\u0013\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019y\u0006\u0001)A\u0005/\"I\u0001\r\u0001a\u0001\u0002\u0004%I!\u0019\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011b\u001c\u0001A\u0002\u0003\u0005\u000b\u0015\u00022\t\u000fA\u0004!\u0019!C\u0001c\"1!\u0010\u0001Q\u0001\nIDqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011B?\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA\u0010\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0005\u0002A1A\u0005\n\u0005]\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0015\u0002A1A\u0005\n\u0005]\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0007\t\u0011\u0005%\u0002A1A\u0005\nEDq!a\u000b\u0001A\u0003%!\u000f\u0003\u0005\u0002.\u0001\u0011\r\u0011\"\u0003r\u0011\u001d\ty\u0003\u0001Q\u0001\nID\u0001\"!\r\u0001\u0005\u0004%I!\u001d\u0005\b\u0003g\u0001\u0001\u0015!\u0003s\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u001d\u0011%\t)\u0005\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u001d\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA'\u0011%\t)\u0006\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA'\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA'\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001e\u0001\t\u0003\ty\u0006C\u0004\u0002\u0002\u0002!\t!a!\t\u000f\u0005m\u0006\u0001\"\u0001\u0002`!9\u0011Q\u0019\u0001\u0005\u0002\u0005}\u0003bBAe\u0001\u0011\u0005\u0011q\f\u0005\b\u0003\u001b\u0004A\u0011AA0\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'D\u0011Ba\u0002\u0001#\u0003%IA!\u0003\t\u0013\t}\u0001!%A\u0005\n\t\u0005\u0002\"\u0003B\u0013\u0001E\u0005I\u0011\u0002B\u0014\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[A\u0011Ba\u001b\u0001#\u0003%IA!\u001c\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!q\u000f\u0001\u0005\n\te$!H!eIB\u000b'\u000f^5uS>t7\u000fV8Uq:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005Y:\u0014AB:feZ,'O\u0003\u00029s\u0005)1.\u00194lC*\t!(\u0001\u0003v]&$8\u0001A\n\u0003\u0001u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001F!\t1\u0005!D\u00016\u00035qW\r^<pe.\u001cE.[3oiV\t\u0011\n\u0005\u0002K%6\t1J\u0003\u0002M\u001b\u000691\r\\5f]R\u001c(B\u0001\u001dO\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005M[%!\u0004(fi^|'o[\"mS\u0016tG/\u0001\boKR<xN]6DY&,g\u000e\u001e\u0011\u0002\tQLW.Z\u000b\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0006kRLGn\u001d\u0006\u000396\u000baaY8n[>t\u0017B\u00010Z\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!G1eIB\u000b'\u000f^5uS>t7\u000fV8Uq:l\u0015M\\1hKJ,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003m\u0015T\u0011\u0001O\u0005\u0003O\u0012\u0014\u0011$\u00113e!\u0006\u0014H/\u001b;j_:\u001cHk\u001c+y]6\u000bg.Y4fe\u0006i\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002k[B\u0011ah[\u0005\u0003Y~\u0012A!\u00168ji\"9anBA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005Q\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o\u001b\u0006t\u0017mZ3sA\u0005)Ao\u001c9jGV\t!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006!A.\u00198h\u0015\u00059\u0018\u0001\u00026bm\u0006L!!\u001f;\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001~!\u0015q\u0018qAA\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005\u0015q(\u0001\u0006d_2dWm\u0019;j_:L1!!\u0003\u0000\u0005\u0011a\u0015n\u001d;\u0011\t\u00055\u0011qB\u0007\u00027&\u0019\u0011\u0011C.\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t7\u000fI\u0001\u0006]>$W\rM\u000b\u0003\u00033\u0001B!!\u0004\u0002\u001c%\u0019\u0011QD.\u0003\t9{G-Z\u0001\u0007]>$W\r\r\u0011\u0002\u000b9|G-Z\u0019\u0002\r9|G-Z\u0019!\u0003\u0015qw\u000eZ33\u0003\u0019qw\u000eZ33A\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE-M\u0001\u0012iJ\fgn]1di&|g.\u00197JIF\u0002\u0013\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u001333\u0003E!(/\u00198tC\u000e$\u0018n\u001c8bY&#'\u0007I\u0001\u0011iJ\fgn]1di&|g.\u00197JIN\n\u0011\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u001a!\u0003-\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u0019\u0016\u0005\u0005e\u0002c\u0001 \u0002<%\u0019\u0011QH \u0003\t1{gnZ\u0001\raJ|G-^2fe&#\u0017\u0007I\u0001\faJ|G-^2fe&#''\u0001\u0007qe>$WoY3s\u0013\u0012\u0014\u0004%A\u0006qe>$WoY3s\u0013\u0012\u001c\u0014\u0001\u00049s_\u0012,8-\u001a:JIN\u0002\u0013aG1vi\",g\u000e^5dCRLwN\\#se>\u0014(+Z:q_:\u001cX-\u0006\u0002\u0002NA\u0019!*a\u0014\n\u0007\u0005E3J\u0001\bDY&,g\u000e\u001e*fgB|gn]3\u00029\u0005,H\u000f[3oi&\u001c\u0017\r^5p]\u0016\u0013(o\u001c:SKN\u0004xN\\:fA\u00059b/\u001a:tS>tW*[:nCR\u001c\u0007NU3ta>t7/Z\u0001\u0019m\u0016\u00148/[8o\u001b&\u001cX.\u0019;dQJ+7\u000f]8og\u0016\u0004\u0013\u0001\u00063jg\u000e|gN\\3di\u0016$'+Z:q_:\u001cX-A\u000beSN\u001cwN\u001c8fGR,GMU3ta>t7/\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0003)D3!JA2!\u0011\t)'a\u001d\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\n1!\u00199j\u0015\u0011\ti'a\u001c\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011\u000f)\u0002\u000b),h.\u001b;\n\t\u0005U\u0014q\r\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u0007\u0019\nY\b\u0005\u0003\u0002f\u0005u\u0014\u0002BA@\u0003O\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0013M,G/\u0012:s_J\u001cH\u0003BAC\u0003[#2A[AD\u0011\u001d\tIi\na\u0001\u0003\u0017\u000babY1mY\n\f7m[#se>\u00148\u000f\u0005\u0005\u0002\u000e\u0006m\u00151BAQ\u001d\u0011\ty)a&\u0011\u0007\u0005Eu(\u0004\u0002\u0002\u0014*\u0019\u0011QS\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\tIjP\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0015q\u0014\u0002\u0004\u001b\u0006\u0004(bAAM\u007fA!\u00111UAU\u001b\t\t)KC\u0002\u0002(n\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003W\u000b)K\u0001\u0004FeJ|'o\u001d\u0005\b\u0003_;\u0003\u0019AAY\u0003\u0019)'O]8sgBA\u00111WA]\u0003\u0017\t\t+\u0004\u0002\u00026*!\u0011qWA\u0002\u0003\u001diW\u000f^1cY\u0016LA!!(\u00026\u0006qA/Z:u\u0003\u0012$G\u000b\u001f8ECR\f\u0007f\u0001\u0015\u0002@B!\u0011QMAa\u0013\u0011\t\u0019-a\u001a\u0003\tQ+7\u000f^\u0001\u0015i\u0016\u001cHoR3oKJ\fG/\u001a*fcV,7\u000f^:)\u0007%\ny,\u0001\u0016uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o\u0011\u0006tG\r\\3s\u000bJ\u0014xN\u001d%b]\u0012d\u0017N\\4)\u0007)\ny,\u0001\u0013uKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2tQ\rY\u0013qX\u0001\u000fG2LWM\u001c;SKN\u0004xN\\:f))\ti%!6\u0002f\u0006M\u0018Q \u0005\b\u0003/d\u0003\u0019AAm\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}7,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019/!8\u0003!\u0005\u00137\u000f\u001e:bGR\u0014Vm\u001d9p]N,\u0007\"CAtYA\u0005\t\u0019AAu\u00035\tW\u000f\u001e5Fq\u000e,\u0007\u000f^5p]B!\u00111^Ax\u001b\t\tiOC\u0002\u00020nKA!!=\u0002n\n9\u0012)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\u001c\u0005\n\u0003kd\u0003\u0013!a\u0001\u0003o\f\u0011#\\5t[\u0006$8\r[#yG\u0016\u0004H/[8o!\u0011\tY/!?\n\t\u0005m\u0018Q\u001e\u0002\u001c+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8\t\u0013\u0005}H\u0006%AA\u0002\t\u0005\u0011\u0001\u00043jg\u000e|gN\\3di\u0016$\u0007c\u0001 \u0003\u0004%\u0019!QA \u0003\u000f\t{w\u000e\\3b]\u0006A2\r\\5f]R\u0014Vm\u001d9p]N,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-!\u0006BAu\u0005\u001bY#Aa\u0004\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053y\u0014AC1o]>$\u0018\r^5p]&!!Q\u0004B\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019G2LWM\u001c;SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0012U\u0011\t9P!\u0004\u00021\rd\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$C'\u0006\u0002\u0003*)\"!\u0011\u0001B\u0007\u0003=!(/\u00198tC\u000e$\u0018n\u001c8ECR\fG\u0003\u0003B\u0018\u0005+\u0012iF!\u0019\u0011\t\tE\"q\n\b\u0005\u0005g\u0011IE\u0004\u0003\u00036\t\u0015c\u0002\u0002B\u001c\u0005\u0007rAA!\u000f\u0003B9!!1\bB \u001d\u0011\t\tJ!\u0010\n\u0003EK!a\u0014)\n\u0005ar\u0015B\u0001/N\u0013\r\u00119eW\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011YE!\u0014\u0002;\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fcV,7\u000f\u001e#bi\u0006T1Aa\u0012\\\u0013\u0011\u0011\tFa\u0015\u0003;\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c+sC:\u001c\u0018m\u0019;j_:TAAa\u0013\u0003N!9!q\u000b\u0019A\u0002\te\u0013a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0011\t\u00055%1L\u0005\u0004s\u0006}\u0005b\u0002B0a\u0001\u0007\u0011\u0011H\u0001\u000baJ|G-^2fe&#\u0007\"\u0003B2aA\u0005\t\u0019\u0001B3\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0019aHa\u001a\n\u0007\t%tHA\u0003TQ>\u0014H/A\rue\u0006t7/Y2uS>tG)\u0019;bI\u0011,g-Y;mi\u0012\u001aTC\u0001B8U\u0011\u0011)G!\u0004\u0002\u001fI,7-Z5wKJ+7\u000f]8og\u0016$2A\u001bB;\u0011\u001d\t9N\ra\u0001\u0003\u001b\nQB^3sS\u001aL(+Z9vKN$H#\u00036\u0003|\t}$\u0011\u0011BB\u0011\u001d\u0011ih\ra\u0001\u00033\t1#\u001a=qK\u000e$X\r\u001a#fgRLg.\u0019;j_:DqAa\u00164\u0001\u0004\u0011I\u0006C\u0004\u0003`M\u0002\r!!\u000f\t\u000f\t\u00155\u00071\u0001\u0003\b\u0006\t\"/Z9vKN$\u0018I\u001c3IC:$G.\u001a:\u0011\t\t%%\u0011S\u0007\u0003\u0005\u0017SAA!$\u0003\u0010\u0006!Q\u000f^5m\u0015\t1T*\u0003\u0003\u0003\u0014\n-%a\u0007*fcV,7\u000f^!oI\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000f")
public class AddPartitionsToTxnManagerTest {
    private final NetworkClient networkClient = (NetworkClient)Mockito.mock(NetworkClient.class);
    private final MockTime time = new MockTime();
    private AddPartitionsToTxnManager addPartitionsToTxnManager;
    private final String topic;
    private final List<TopicPartition> topicPartitions = new .colon.colon((Object)new TopicPartition(this.topic(), 1), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 2), (List)new .colon.colon((Object)new TopicPartition(this.topic(), 3), (List)Nil$.MODULE$)));
    private final Node node0 = new Node(0, "host1", 0);
    private final Node node1 = new Node(1, "host2", 1);
    private final Node node2 = new Node(2, "host2", 2);
    private final String transactionalId1;
    private final String transactionalId2;
    private final String transactionalId3;
    private final long producerId1;
    private final long producerId2;
    private final long producerId3;
    private final ClientResponse authenticationErrorResponse = this.clientResponse(null, (AuthenticationException)new SaslAuthenticationException(""), this.clientResponse$default$3(), this.clientResponse$default$4());
    private final ClientResponse versionMismatchResponse;
    private final ClientResponse disconnectedResponse;

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private MockTime time() {
        return this.time;
    }

    private AddPartitionsToTxnManager addPartitionsToTxnManager() {
        return this.addPartitionsToTxnManager;
    }

    private void addPartitionsToTxnManager_$eq(AddPartitionsToTxnManager x$1) {
        this.addPartitionsToTxnManager = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public List<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    private Node node0() {
        return this.node0;
    }

    private Node node1() {
        return this.node1;
    }

    private Node node2() {
        return this.node2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private String transactionalId3() {
        return this.transactionalId3;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private long producerId3() {
        return this.producerId3;
    }

    private ClientResponse authenticationErrorResponse() {
        return this.authenticationErrorResponse;
    }

    private ClientResponse versionMismatchResponse() {
        return this.versionMismatchResponse;
    }

    private ClientResponse disconnectedResponse() {
        return this.disconnectedResponse;
    }

    @BeforeEach
    public void setup() {
        this.addPartitionsToTxnManager_$eq(new AddPartitionsToTxnManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), this.networkClient(), (Time)this.time()));
    }

    @AfterEach
    public void teardown() {
        this.addPartitionsToTxnManager().shutdown();
    }

    public void setErrors(scala.collection.mutable.Map<TopicPartition, Errors> errors, scala.collection.immutable.Map<TopicPartition, Errors> callbackErrors) {
        callbackErrors.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                Errors error = (Errors)x0$1._2();
                return errors.put((Object)tp, (Object)error);
            }
            throw new MatchError(null);
        });
    }

    @Test
    public void testAddTxnData() {
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction3Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node1(), this.transactionData(this.transactionalId2(), this.producerId2(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId3(), this.producerId3(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction3Errors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map transaction1RetryWithSameEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithNewerEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction1RetryWithOldEpochErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithSameEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$1), (Object)Errors.NETWORK_EXCEPTION), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Object)transaction1Errors);
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), (short)1), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithNewerEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map expectedEpochErrors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)Errors.INVALID_PRODUCER_EPOCH), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithSameEpochErrors);
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), (short)0), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1RetryWithOldEpochErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)expectedEpochErrors, (Object)transaction1RetryWithOldEpochErrors);
        ((Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.addPartitionsToTxnManager().generateRequests()).asScala()).foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testAddTxnData$9(this, requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testGenerateRequests() {
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node1(), this.transactionData(this.transactionalId2(), this.producerId2(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        Iterable requestsAndHandlers = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)2, (int)requestsAndHandlers.size());
        requestsAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$3(this, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node1(), this.transactionData(this.transactionalId2(), this.producerId2(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node2(), this.transactionData(this.transactionalId3(), this.producerId3(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.time().sleep(10L);
        Iterable requestsAndHandlers2 = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers2.size());
        requestsAndHandlers2.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            this.verifyRequest(this.node2(), this.transactionalId3(), this.producerId3(), requestAndHandler);
            return BoxedUnit.UNIT;
        });
        ((RequestAndCompletionHandler)((IterableLike)requestsAndHandlers.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testGenerateRequests$7$adapted(unit.kafka.server.AddPartitionsToTxnManagerTest org.apache.kafka.server.util.RequestAndCompletionHandler ), (Lorg/apache/kafka/server/util/RequestAndCompletionHandler;)Ljava/lang/Object;)((AddPartitionsToTxnManagerTest)this))).head()).handler.onComplete(this.authenticationErrorResponse());
        Iterable requestsAndHandlers3 = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.addPartitionsToTxnManager().generateRequests()).asScala();
        Assertions.assertEquals((int)1, (int)requestsAndHandlers3.size());
        requestsAndHandlers3.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            this.verifyRequest(this.node1(), this.transactionalId2(), this.producerId2(), requestAndHandler);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddPartitionsToTxnHandlerErrorHandling() {
        scala.collection.mutable.Map transaction1Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map transaction2Errors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.immutable.Map expectedAuthErrors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$4), (Object)Errors.SASL_AUTHENTICATION_FAILED), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.authenticationErrorResponse());
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedAuthErrors, (Object)transaction2Errors);
        HashMap expectedVersionMismatchErrors = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.versionMismatchResponse());
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedVersionMismatchErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedDisconnectedErrors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$5 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), (Object)Errors.NETWORK_EXCEPTION), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(this.disconnectedResponse());
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedDisconnectedErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map expectedTopLevelErrors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$6 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$6), (Object)Errors.INVALID_TXN_STATE), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        AddPartitionsToTxnResponse topLevelErrorAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
        ClientResponse topLevelErrorResponse = this.clientResponse((AbstractResponse)topLevelErrorAddPartitionsResponse, this.clientResponse$default$2(), this.clientResponse$default$3(), this.clientResponse$default$4());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(topLevelErrorResponse);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTopLevelErrors, (Object)transaction2Errors);
        scala.collection.immutable.Map preConvertedTransaction1Errors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$7 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$7), (Object)Errors.PRODUCER_FENCED), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map expectedTransaction1Errors = ((TraversableOnce)this.topicPartitions().map((Function1 & Serializable & scala.Serializable)x$8 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$8), (Object)Errors.INVALID_PRODUCER_EPOCH), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map preConvertedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)Errors.NONE)}));
        scala.collection.immutable.Map expectedTransaction2Errors = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)Errors.INVALID_TXN_STATE)}));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction1ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId1(), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)preConvertedTransaction1Errors).asJava()));
        AddPartitionsToTxnResponseData.AddPartitionsToTxnResult transaction2ErrorResponse = AddPartitionsToTxnResponse.resultForTransaction((String)this.transactionalId2(), (java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)preConvertedTransaction2Errors).asJava()));
        AddPartitionsToTxnResponse mixedErrorsAddPartitionsResponse = new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData().setResultsByTransaction(new AddPartitionsToTxnResponseData.AddPartitionsToTxnResultCollection((java.util.Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter(new .colon.colon((Object)transaction1ErrorResponse, (List)new .colon.colon((Object)transaction2ErrorResponse, (List)Nil$.MODULE$)).iterator()).asJava())));
        ClientResponse mixedErrorsResponse = this.clientResponse((AbstractResponse)mixedErrorsAddPartitionsResponse, this.clientResponse$default$2(), this.clientResponse$default$3(), this.clientResponse$default$4());
        this.addTransactionsToVerify$1(transaction1Errors, transaction2Errors);
        this.receiveResponse(mixedErrorsResponse);
        Assertions.assertEquals((Object)expectedTransaction1Errors, (Object)transaction1Errors);
        Assertions.assertEquals((Object)expectedTransaction2Errors, (Object)transaction2Errors);
    }

    @Test
    public void testAddPartitionsToTxnManagerMetrics() {
        long startTime = this.time().milliseconds();
        scala.collection.mutable.Map transactionErrors = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef maxVerificationTime = LongRef.create((long)0L);
        Meter mockVerificationFailureMeter = (Meter)Mockito.mock(Meter.class);
        Histogram mockVerificationTime = (Histogram)Mockito.mock(Histogram.class);
        mockVerificationTime.update(ArgumentMatchers.anyLong());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            long newTime = BoxesRunTime.unboxToLong((Object)invocation.getArgument(0));
            if (newTime > maxVerificationTime$1.elem) {
                maxVerificationTime$1.elem = newTime;
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        MockedConstruction mockMetricsGroupCtor = Mockito.mockConstruction(KafkaMetricsGroup.class, (mock, context) -> {
            Mockito.when((Object)mock.newMeter((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName()), ArgumentMatchers.anyString(), (TimeUnit)((Object)((Object)ArgumentMatchers.any(TimeUnit.class))))).thenReturn((Object)mockVerificationFailureMeter);
            Mockito.when((Object)mock.newHistogram((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName()))).thenReturn((Object)mockVerificationTime);
        });
        AddPartitionsToTxnManager addPartitionsManagerWithMockedMetrics = new AddPartitionsToTxnManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())), this.networkClient(), (Time)this.time());
        try {
            addPartitionsManagerWithMockedMetrics.addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
                this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
                return BoxedUnit.UNIT;
            });
            addPartitionsManagerWithMockedMetrics.addTxnData(this.node1(), this.transactionData(this.transactionalId2(), this.producerId2(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
                this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transactionErrors, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
                return BoxedUnit.UNIT;
            });
            this.time().sleep(100L);
            Collection requestsAndHandlers = addPartitionsManagerWithMockedMetrics.generateRequests();
            IntRef requestsHandled = IntRef.create((int)0);
            requestsAndHandlers.forEach(requestAndCompletionHandler -> {
                this.time().sleep(100L);
                requestAndCompletionHandler.handler.onComplete(this.authenticationErrorResponse());
                ++requestsHandled$1.elem;
                ((Histogram)Mockito.verify((Object)mockVerificationTime, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).update(ArgumentMatchers.anyLong());
                Assertions.assertEquals((long)maxVerificationTime$1.elem, (long)(this.time().milliseconds() - startTime));
                ((Meter)Mockito.verify((Object)mockVerificationFailureMeter, (VerificationMode)Mockito.times((int)requestsHandled$1.elem))).mark(3L);
            });
            addPartitionsManagerWithMockedMetrics.shutdown();
            KafkaMetricsGroup mockMetricsGroup = (KafkaMetricsGroup)mockMetricsGroupCtor.constructed().get(0);
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newMeter((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName()), ArgumentMatchers.anyString(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).newHistogram((String)ArgumentMatchers.eq((Object)AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName()));
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric(AddPartitionsToTxnManager$.MODULE$.VerificationFailureRateMetricName());
            ((KafkaMetricsGroup)Mockito.verify((Object)mockMetricsGroup)).removeMetric(AddPartitionsToTxnManager$.MODULE$.VerificationTimeMsMetricName());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockMetricsGroup});
        }
        catch (Throwable throwable) {
            if (mockMetricsGroupCtor != null) {
                mockMetricsGroupCtor.close();
            }
            if (addPartitionsManagerWithMockedMetrics.isRunning()) {
                addPartitionsManagerWithMockedMetrics.shutdown();
            }
            throw throwable;
        }
        mockMetricsGroupCtor.close();
        if (addPartitionsManagerWithMockedMetrics.isRunning()) {
            addPartitionsManagerWithMockedMetrics.shutdown();
        }
    }

    private ClientResponse clientResponse(AbstractResponse response, AuthenticationException authException, UnsupportedVersionException mismatchException, boolean disconnected) {
        return new ClientResponse(null, null, null, 0L, 0L, disconnected, mismatchException, authException, response);
    }

    private AuthenticationException clientResponse$default$2() {
        return null;
    }

    private UnsupportedVersionException clientResponse$default$3() {
        return null;
    }

    private boolean clientResponse$default$4() {
        return false;
    }

    private AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction transactionData(String transactionalId, long producerId, short producerEpoch) {
        return new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransaction().setTransactionalId(transactionalId).setProducerId(producerId).setProducerEpoch(producerEpoch).setTopics(new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopicCollection((java.util.Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter(new .colon.colon((Object)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(3), (List)Nil$.MODULE$)))).asJava()), (List)Nil$.MODULE$).iterator()).asJava()));
    }

    private short transactionData$default$3() {
        return 0;
    }

    private void receiveResponse(ClientResponse response) {
        ((RequestAndCompletionHandler)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.addPartitionsToTxnManager().generateRequests()).asScala()).head()).handler.onComplete(response);
    }

    private void verifyRequest(Node expectedDestination, String transactionalId, long producerId, RequestAndCompletionHandler requestAndHandler) {
        Assertions.assertEquals((long)this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
        Assertions.assertEquals((Object)expectedDestination, (Object)requestAndHandler.destination);
        Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)((java.util.Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter((Iterator)new .colon.colon((Object)this.transactionData((String)transactionalId, (long)producerId, (short)this.transactionData$default$3()), (List)Nil$.MODULE$).iterator()).asJava()))).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
    }

    public static final /* synthetic */ void $anonfun$testAddTxnData$9(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            Assertions.assertEquals((long)$this.time().milliseconds(), (long)requestAndHandler.creationTimeMs);
            Assertions.assertEquals((Object)AddPartitionsToTxnRequest.Builder.forBroker((AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection)new AddPartitionsToTxnRequestData.AddPartitionsToTxnTransactionCollection((java.util.Iterator)((java.util.Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter((Iterator)new .colon.colon((Object)$this.transactionData((String)$this.transactionalId3(), (long)$this.producerId3(), (short)$this.transactionData$default$3()), (List)new .colon.colon((Object)$this.transactionData((String)$this.transactionalId1(), (long)$this.producerId1(), (short)1), (List)Nil$.MODULE$)).iterator()).asJava()))).data, (Object)((AddPartitionsToTxnRequest.Builder)requestAndHandler.request).data);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), requestAndHandler);
    }

    public static final /* synthetic */ void $anonfun$testGenerateRequests$3(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler requestAndHandler) {
        Node node = requestAndHandler.destination;
        Node node2 = $this.node0();
        if (!(node != null ? !node.equals(node2) : node2 != null)) {
            $this.verifyRequest($this.node0(), $this.transactionalId1(), $this.producerId1(), requestAndHandler);
            return;
        }
        $this.verifyRequest($this.node1(), $this.transactionalId2(), $this.producerId2(), requestAndHandler);
    }

    public static final /* synthetic */ boolean $anonfun$testGenerateRequests$7(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$3) {
        Node node = x$3.destination;
        Node node2 = $this.node1();
        return !(node != null ? !node.equals(node2) : node2 != null);
    }

    private final void addTransactionsToVerify$1(scala.collection.mutable.Map transaction1Errors$2, scala.collection.mutable.Map transaction2Errors$2) {
        transaction1Errors$2.clear();
        transaction2Errors$2.clear();
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId1(), this.producerId1(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction1Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
        this.addPartitionsToTxnManager().addTxnData(this.node0(), this.transactionData(this.transactionalId2(), this.producerId2(), this.transactionData$default$3()), (Function1 & Serializable & scala.Serializable)callbackErrors -> {
            this.setErrors((scala.collection.mutable.Map<TopicPartition, Errors>)transaction2Errors$2, (scala.collection.immutable.Map<TopicPartition, Errors>)callbackErrors);
            return BoxedUnit.UNIT;
        });
    }

    public AddPartitionsToTxnManagerTest() {
        this.topic = "foo";
        this.transactionalId1 = "txn1";
        this.transactionalId2 = "txn2";
        this.transactionalId3 = "txn3";
        this.producerId1 = 0L;
        this.producerId2 = 1L;
        this.producerId3 = 2L;
        UnsupportedVersionException x$2 = new UnsupportedVersionException("");
        AuthenticationException x$3 = this.clientResponse$default$2();
        boolean x$4 = this.clientResponse$default$4();
        this.versionMismatchResponse = this.clientResponse(null, x$3, x$2, x$4);
        boolean x$6 = true;
        AuthenticationException x$7 = this.clientResponse$default$2();
        UnsupportedVersionException x$8 = this.clientResponse$default$3();
        this.disconnectedResponse = this.clientResponse(null, x$7, x$8, x$6);
    }

    public static final /* synthetic */ Object $anonfun$testGenerateRequests$7$adapted(AddPartitionsToTxnManagerTest $this, RequestAndCompletionHandler x$3) {
        return BoxesRunTime.boxToBoolean((boolean)AddPartitionsToTxnManagerTest.$anonfun$testGenerateRequests$7($this, x$3));
    }
}

