/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.loader.LogDeltaManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\b\u0011\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013\u00051\u0005\u0003\u0004=\u0001\u0001\u0006I\u0001\n\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u001f\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u00063\u0002!\tA\u0010\u0005\u00067\u0002!I\u0001\u0018\u0005\u0006g\u0002!I\u0001\u001e\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAa!a\u0017\u0001\t\u0003q\u0004BBA0\u0001\u0011\u0005a\b\u0003\u0004\u0002d\u0001!\tA\u0010\u0002\u001c\u0005J|7.\u001a:NKR\fG-\u0019;b!V\u0014G.[:iKJ$Vm\u001d;\u000b\u0005E\u0011\u0012\u0001C7fi\u0006$\u0017\r^1\u000b\u0005M!\u0012AB:feZ,'OC\u0001\u0016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t\u0001#A\u0007fq&$X\t_2faRLwN\\\u000b\u0002IA\u0019QE\f\u0019\u000e\u0003\u0019R!a\n\u0015\u0002\r\u0005$x.\\5d\u0015\tI#&\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000b\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\tycEA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\t\t\u0014H\u0004\u00023o9\u00111GN\u0007\u0002i)\u0011QGF\u0001\u0007yI|w\u000e\u001e \n\u0003mI!\u0001\u000f\u000e\u0002\u000fA\f7m[1hK&\u0011!h\u000f\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u000f\u000e\u0002\u001d\u0015D\u0018\u000e^#yG\u0016\u0004H/[8oA\u0005)1/\u001a;VaR\tq\b\u0005\u0002\u001a\u0001&\u0011\u0011I\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0005\u0007B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS&\u0002\u000b),h.\u001b;\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u000bE\u0003\"\u0001\u0012*\n\u0005M+%!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;HKR$v\u000e]5d\t\u0016dG/\u0019\u0015\u0003\rY\u0003\"\u0001R,\n\u0005a+%\u0001\u0002+fgR\fQ\u0003^3ti\u001aKg\u000eZ*ue\u0006L(+\u001a9mS\u000e\f7\u000f\u000b\u0002\b-\u00069Qn\\2l\u0019><GcA/d]B\u0011a,Y\u0007\u0002?*\u0011\u0001\rF\u0001\u0004Y><\u0017B\u00012`\u0005))f.\u001b4jK\u0012dun\u001a\u0005\u0006I\"\u0001\r!Z\u0001\bi>\u0004\u0018nY%e!\t1G.D\u0001h\u0015\tA\u0017.\u0001\u0004d_6lwN\u001c\u0006\u0003+)T!a[&\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tiwM\u0001\u0003Vk&$\u0007\"B8\t\u0001\u0004\u0001\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003MFL!A]4\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006QAo\u001c9jG&k\u0017mZ3\u0015\u000bU\\H0!\u0004\u0011\u0005YLX\"A<\u000b\u0005aL\u0017!B5nC\u001e,\u0017B\u0001>x\u0005)!v\u000e]5d\u00136\fw-\u001a\u0005\u0006I&\u0001\r!\u001a\u0005\u0006{&\u0001\rA`\u0001\u0006i>\u0004\u0018n\u0019\t\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u0007\u0001\"a\r\u000e\n\u0007\u0005\u0015!$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bQ\u0002bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcB@\u0002\u0014\u0005]\u0011QD\u0005\u0005\u0003+\tYAA\u0002NCB\u00042!GA\r\u0013\r\tYB\u0007\u0002\u0004\u0013:$\b#B\u0019\u0002 \u0005]\u0011bAA\u0011w\t\u00191+Z9\u0002\u0017Q|\u0007/[2t\u00136\fw-\u001a\u000b\u0005\u0003O\ti\u0003E\u0002w\u0003SI1!a\u000bx\u0005-!v\u000e]5dg&k\u0017mZ3\t\u000f\u0005=\"\u00021\u0001\u00022\u00051Ao\u001c9jGN\u0004B!MA\u0010k\u0006ib.Z<N_\u000e\\G)\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'\u000f\u0006\u0004\u00028\u0005u\u0012\u0011\n\t\u0004C\u0005e\u0012bAA\u001e!\t1B)\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'\u000fC\u0004\u0002@-\u0001\r!!\u0011\u0002\r\t\u0014xn[3s!\u0011\t\u0019%!\u0012\u000e\u0003II1!a\u0012\u0013\u00051\u0011%o\\6feN+'O^3s\u0011\u001d\tYe\u0003a\u0001\u0003\u001b\nA\"\u001a:s_JD\u0015M\u001c3mKJ\u0004B!a\u0014\u0002X5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&A\u0003gCVdGO\u0003\u0002\u0014S&!\u0011\u0011LA)\u000511\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003%\"Xm\u001d;SK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012ABV\u0001!i\u0016\u001cH/\u0012=dKB$\u0018n\u001c8J]V\u0003H-\u0019;f\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0002\u000e-\u0006!C/Z:u\u001d\u0016<\u0018*\\1hKB+8\u000f[3e)><%o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u000b\u0002\u000f-\u0002")
public class BrokerMetadataPublisherTest {
    private final AtomicReference<Throwable> exitException = new AtomicReference<Object>(null);

    public AtomicReference<Throwable> exitException() {
        return this.exitException;
    }

    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((code, x$1) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Exit ").append(code).toString())));
        Exit.setHaltProcedure((code, x$2) -> this.exitException().set(new RuntimeException(new StringBuilder(5).append("Halt ").append(code).toString())));
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        Throwable exception = this.exitException().get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        UnifiedLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        UnifiedLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        UnifiedLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        UnifiedLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        UnifiedLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    private UnifiedLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return log;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partitionId = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration.Builder().setReplicas((int[])replicas.toArray(ClassTag$.MODULE$.Int())).setIsr((int[])replicas.toArray(ClassTag$.MODULE$.Int())).setLeader(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)replicas.head()))).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED).setLeaderEpoch(Predef$.MODULE$.int2Integer(0)).setPartitionEpoch(Predef$.MODULE$.int2Integer(0)).build());
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        ObjectRef retval = ObjectRef.create((Object)TopicsImage.EMPTY);
        topics.foreach((Function1 & Serializable & scala.Serializable)t -> {
            retval.elem = ((TopicsImage)retval.elem).including(t);
            return BoxedUnit.UNIT;
        });
        return (TopicsImage)retval.elem;
    }

    private DynamicConfigPublisher newMockDynamicConfigPublisher(BrokerServer broker, FaultHandler errorHandler) {
        return (DynamicConfigPublisher)Mockito.spy((Object)new DynamicConfigPublisher(broker.config(), errorHandler, broker.dynamicConfigHandlers().toMap(Predef$.MODULE$.$conforms()), "broker"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadUpdatedFilesWithoutConfigChange() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            DynamicConfigPublisher publisher = this.newMockDynamicConfigPublisher(broker, (FaultHandler)cluster.nonFatalFaultHandler());
            AtomicInteger numTimesReloadCalled = new AtomicInteger(0);
            publisher.reloadUpdatedFilesWithoutConfigChange((Properties)ArgumentMatchers.any());
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, numTimesReloadCalled){
                private final AtomicInteger numTimesReloadCalled$1;

                public void answer(InvocationOnMock invocation) {
                    this.numTimesReloadCalled$1.addAndGet(1);
                }
                {
                    this.numTimesReloadCalled$1 = numTimesReloadCalled$1;
                }
            });
            broker.brokerMetadataPublisher().dynamicConfigPublisher_$eq(publisher);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((int)0, (int)numTimesReloadCalled.get());
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$1(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(broker.config().nodeId())), Collections.singleton(new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.MaxConnectionsProp(), "123"), AlterConfigOp.OpType.SET)))).all().get();
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$3(numTimesReloadCalled)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)BrokerMetadataPublisherTest.$anonfun$testReloadUpdatedFilesWithoutConfigChange$4());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testExceptionInUpdateCoordinator() {
        KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();
        try {
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$1(broker);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
            BrokerMetadataPublisher publisher = (BrokerMetadataPublisher)Mockito.spy((Object)broker.brokerMetadataPublisher());
            ((BrokerMetadataPublisher)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("injected failure")}).when((Object)publisher)).updateCoordinator((MetadataImage)ArgumentMatchers.any(), (MetadataDelta)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any(), (Function2)ArgumentMatchers.any());
            broker.sharedServer().loader().removeAndClosePublisher((MetadataPublisher)broker.brokerMetadataPublisher()).get(1L, TimeUnit.MINUTES);
            broker.metadataPublishers().remove(broker.brokerMetadataPublisher());
            broker.sharedServer().loader().installPublishers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)publisher, (List)Nil$.MODULE$)).asJava()).get(1L, TimeUnit.MINUTES);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("foo", 1, (short)1))).all().get();
            }
            TestUtils$ testUtils$2 = TestUtils$.MODULE$;
            long l2 = 60000L;
            if (testUtils$2 == null) {
                throw null;
            }
            TestUtils$ retry_this2 = testUtils$2;
            LongRef retry_wait2 = LongRef.create((long)1L);
            long retry_startTime2 = System.currentTimeMillis();
            while (true) {
                try {
                    BrokerMetadataPublisherTest.$anonfun$testExceptionInUpdateCoordinator$2(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this2.logger().underlying().isInfoEnabled()) {
                        retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                    }
                    Thread.sleep(retry_wait2.elem);
                    retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                    continue;
                }
                break;
            }
        }
        finally {
            cluster.nonFatalFaultHandler().setIgnore(true);
            cluster.close();
        }
    }

    @Test
    public void testNewImagePushedToGroupCoordinator() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        FaultHandler faultHandler = (FaultHandler)Mockito.mock(FaultHandler.class);
        BrokerMetadataPublisher metadataPublisher = new BrokerMetadataPublisher(config, metadataCache, logManager, replicaManager, groupCoordinator, (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class), (DynamicConfigPublisher)Mockito.mock(DynamicConfigPublisher.class), (DynamicClientQuotaPublisher)Mockito.mock(DynamicClientQuotaPublisher.class), (ScramPublisher)Mockito.mock(ScramPublisher.class), (DelegationTokenPublisher)Mockito.mock(DelegationTokenPublisher.class), (AclPublisher)Mockito.mock(AclPublisher.class), faultHandler, faultHandler);
        MetadataImage image = MetadataImage.EMPTY;
        MetadataDelta delta = new MetadataDelta.Builder().setImage(image).build();
        metadataPublisher.onMetadataUpdate(delta, image, (LoaderManifest)LogDeltaManifest.newBuilder().provenance(MetadataProvenance.EMPTY).leaderAndEpoch(LeaderAndEpoch.UNKNOWN).numBatches(1).elapsedNs(100L).numBytes(42L).build());
        ((GroupCoordinator)Mockito.verify((Object)groupCoordinator)).onNewMetadataImage(image, delta);
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$1(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 0;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$2() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ boolean $anonfun$testReloadUpdatedFilesWithoutConfigChange$3(AtomicInteger numTimesReloadCalled$1) {
        return numTimesReloadCalled$1.get() == 1;
    }

    public static final /* synthetic */ String $anonfun$testReloadUpdatedFilesWithoutConfigChange$4() {
        return "numTimesConfigured never reached desired value";
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$1(BrokerServer broker$1) {
        Assertions.assertNotNull((Object)broker$1.brokerMetadataPublisher());
    }

    public static final /* synthetic */ void $anonfun$testExceptionInUpdateCoordinator$2(KafkaClusterTestKit cluster$1) {
        Assertions.assertTrue((boolean)((String)Option$.MODULE$.apply((Object)cluster$1.nonFatalFaultHandler().firstException()).flatMap((Function1 & Serializable & scala.Serializable)e -> Option$.MODULE$.apply((Object)e.getMessage())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "(none)")).contains("injected failure"));
    }
}

