/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAq\u0001\t\u0001C\u0002\u0013\u0005\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\bW\u0001\u0011\r\u0011\"\u0001-\u0011\u0019A\u0004\u0001)A\u0005[!)\u0011\b\u0001C\u0001u!)A\n\u0001C\u0001u!)a\n\u0001C\u0001\u001f\")\u0001\u000e\u0001C\u0001u!1!\u000e\u0001Q\u0005\n-D\u0001\"!\b\u0001A\u0013%\u0011q\u0004\u0005\t\u0003[\u0001\u0001\u0015\"\u0003\u00020!1\u0011Q\b\u0001\u0005\u0002iBa!!\u0011\u0001\t\u0003Q\u0004bBA#\u0001\u0011%\u0011q\t\u0005\u0007U\u0002!I!!\u0018\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\t1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011!\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012!\f\t\u0003]Yj\u0011a\f\u0006\u0003aE\naaY8n[>t'B\u0001\f3\u0015\t\u0019D'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002k\u0005\u0019qN]4\n\u0005]z#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!\u0007;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:FeJ|'oQ8eKN$\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\u0005+:LG\u000f\u000b\u0002\u0007\u0005B\u00111IS\u0007\u0002\t*\u0011QIR\u0001\u0004CBL'BA$I\u0003\u001dQW\u000f]5uKJT!!\u0013\u001b\u0002\u000b),h.\u001b;\n\u0005-#%\u0001\u0002+fgR\f\u0001\u0006^3ti2K7\u000f^(gMN,Go]'bqRKW.Z*uC6\u0004x\n\u001c3fgR4VM]:j_:D#a\u0002\"\u00027\u0005\u001c8/\u001a:u%\u0016\u001c\bo\u001c8tK\u0016\u0013(o\u001c:G_J,\u0005o\\2i)\u0011Y\u0004\u000bW/\t\u000bEC\u0001\u0019\u0001*\u0002\u000b\u0015\u0014(o\u001c:\u0011\u0005M3V\"\u0001+\u000b\u0005U{\u0013\u0001\u00039s_R|7m\u001c7\n\u0005]#&AB#se>\u00148\u000fC\u0003Z\u0011\u0001\u0007!,\u0001\u0005ce>\\WM]%e!\ta4,\u0003\u0002]{\t\u0019\u0011J\u001c;\t\u000byC\u0001\u0019A0\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\t\u0004A\u000e,W\"A1\u000b\u0005\t4\u0013\u0001B;uS2L!\u0001Z1\u0003\u0011=\u0003H/[8oC2\u0004\"a\t4\n\u0005\u001d$#aB%oi\u0016<WM]\u0001\u001bi\u0016\u001cHoQ;se\u0016tG/\u00129pG\"4\u0016\r\\5eCRLwN\u001c\u0015\u0003\u0013\t\u000b1b]3oIJ+\u0017/^3tiR9A.!\u0002\u0002\n\u0005M\u0001CA7\u0000\u001d\tqGP\u0004\u0002pu:\u0011\u0001/\u001f\b\u0003cbt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005U<\u0012A\u0002\u001fs_>$h(C\u00016\u0013\t\u0019D'\u0003\u0002\u0017e%\u0011\u0001'M\u0005\u0003w>\nq!\\3tg\u0006<W-\u0003\u0002~}\u00069B*[:u\u001f\u001a47/\u001a;t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0003w>JA!!\u0001\u0002\u0004\taB*[:u\u001f\u001a47/\u001a;t!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,'BA?\u007f\u0011\u0019\t9A\u0003a\u00015\u0006A1/\u001a:wKJLE\rC\u0004\u0002\f)\u0001\r!!\u0004\u0002\u0013QLW.Z:uC6\u0004\bc\u0001\u001f\u0002\u0010%\u0019\u0011\u0011C\u001f\u0003\t1{gn\u001a\u0005\b\u0003+Q\u0001\u0019AA\f\u0003\u001d1XM]:j_:\u00042\u0001PA\r\u0013\r\tY\"\u0010\u0002\u0006'\"|'\u000f^\u0001\u0014M\u0016$8\r[(gMN,G/\u00118e\u000bB|7\r\u001b\u000b\t\u0003C\t9#!\u000b\u0002,A1A(a\t\u0002\u000eiK1!!\n>\u0005\u0019!V\u000f\u001d7fe!1\u0011qA\u0006A\u0002iCq!a\u0003\f\u0001\u0004\ti\u0001C\u0004\u0002\u0016-\u0001\r!a\u0006\u00029\u0019,Go\u00195PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195XSRDWI\u001d:peRA\u0011\u0011GA\u001c\u0003s\tY\u0004\u0005\u0005=\u0003g\tiAWA\f\u0013\r\t)$\u0010\u0002\u0007)V\u0004H.Z\u001a\t\r\u0005\u001dA\u00021\u0001[\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001bAq!!\u0006\r\u0001\u0004\t9\"A\u0010uKN$(+Z:q_:\u001cX-\u00138dYV$Wm\u001d'fC\u0012,'/\u00129pG\"D#!\u0004\"\u0002kQ,7\u000f\u001e*fgB|gn]3EK\u001a\fW\u000f\u001c;PM\u001a\u001cX\r^!oI2+\u0017\rZ3s\u000bB|7\r\u001b$pe\u0006cGNV3sg&|gn\u001d\u0015\u0003\u001d\t\u000b1#Y:tKJ$(+Z:q_:\u001cX-\u0012:s_J$raOA%\u0003\u0017\ni\u0005C\u0003R\u001f\u0001\u0007!\u000bC\u0003Z\u001f\u0001\u0007!\fC\u0004\u0002P=\u0001\r!!\u0015\u0002\u000fI,\u0017/^3tiB!\u00111KA-\u001b\t\t)FC\u0002\u0002X=\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u00037\n)F\u0001\nMSN$xJ\u001a4tKR\u001c(+Z9vKN$HCBA0\u0003K\nI\u0007\u0005\u0003\u0002T\u0005\u0005\u0014\u0002BA2\u0003+\u00121\u0003T5ti>3gm]3ugJ+7\u000f]8og\u0016Da!a\u001a\u0011\u0001\u0004Q\u0016\u0001\u00037fC\u0012,'/\u00133\t\u000f\u0005=\u0003\u00031\u0001\u0002R\u0005Y1M]3bi\u0016$v\u000e]5d)\u0019\ty'a \u0002\u0004B1\u0011\u0011OA=5jsA!a\u001d\u0002vA\u00111/P\u0005\u0004\u0003oj\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0005u$aA'ba*\u0019\u0011qO\u001f\t\r\u0005\u0005\u0015\u00031\u0001[\u00035qW/\u001c)beRLG/[8og\"1\u0011QQ\tA\u0002i\u000b\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0001")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @Test
    public void testListOffsetsMaxTimeStampOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendRequest(serverId, request).topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$4))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$5))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
            }
            return new Tuple3((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.oldStyleOffsets()).asScala()).head())), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), this.partition(), firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.servers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.servers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.servers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$4) {
        String string = x$4.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$5) {
        return x$5.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

