/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.server.BaseRequestTest;
import kafka.server.BrokerTopicStats$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.server.ProduceRequestTest$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.message.ProduceResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\b\u0011\u0001UAQA\u0007\u0001\u0005\u0002mAq!\b\u0001C\u0002\u0013\u0005a\u0004\u0003\u00046\u0001\u0001\u0006Ia\b\u0005\u0006m\u0001!\ta\u000e\u0005\u0006\u0013\u0002!\tA\u0013\u0005\u0006_\u0002!\ta\u000e\u0005\u0006c\u0002!IA\u001d\u0005\u0006w\u0002!\ta\u000e\u0005\u0006{\u0002!\ta\u000e\u0005\u0007\u007f\u0002!I!!\u0001\b\u000f\u0005\u001d\u0002\u0003#\u0001\u0002*\u00191q\u0002\u0005E\u0001\u0003WAaA\u0007\u0007\u0005\u0002\u0005M\u0002BB5\r\t\u0003\t)D\u0001\nQe>$WoY3SKF,Xm\u001d;UKN$(BA\t\u0013\u0003\u0019\u0019XM\u001d<fe*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0002CA\f\u0019\u001b\u0005\u0001\u0012BA\r\u0011\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001d!\t9\u0002!A\u0007nKR\u0014\u0018nY:LKf\u001cV\r^\u000b\u0002?A\u0019\u0001eJ\u0015\u000e\u0003\u0005R!AI\u0012\u0002\u000f5,H/\u00192mK*\u0011A%J\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!\n#aA*fiB\u0011!fM\u0007\u0002W)\u0011A&L\u0001\u0005G>\u0014XM\u0003\u0002/_\u00059Q.\u001a;sS\u000e\u001c(B\u0001\u00192\u0003\u0019I\u0018-\\7fe*\t!'A\u0002d_6L!\u0001N\u0016\u0003\u00155+GO]5d\u001d\u0006lW-\u0001\bnKR\u0014\u0018nY:LKf\u001cV\r\u001e\u0011\u00021Q,7\u000f^*j[BdW\r\u0015:pIV\u001cWMU3rk\u0016\u001cH\u000fF\u00019!\tI$(D\u0001&\u0013\tYTE\u0001\u0003V]&$\bF\u0001\u0003>!\tqt)D\u0001@\u0015\t\u0001\u0015)A\u0002ba&T!AQ\"\u0002\u000f),\b/\u001b;fe*\u0011A)R\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\r\u0006\u0019qN]4\n\u0005!{$\u0001\u0002+fgR\fq\u0004^3tiB\u0013x\u000eZ;dK^KG\u000f[%om\u0006d\u0017\u000e\u001a+j[\u0016\u001cH/Y7q)\rA4\n\u0017\u0005\u0006\u0019\u0016\u0001\r!T\u0001\u0017[\u0016\u001c8/Y4f)&lWm\u0015;b[B\u001cuN\u001c4jOB\u0011a*\u0016\b\u0003\u001fN\u0003\"\u0001U\u0013\u000e\u0003ES!A\u0015\u000b\u0002\rq\u0012xn\u001c;?\u0013\t!V%\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+&\u0011\u0015IV\u00011\u0001[\u0003=\u0011XmY8sIRKW.Z:uC6\u0004\bCA\u001d\\\u0013\taVE\u0001\u0003M_:<\u0007\u0006B\u0003_M\u001e\u0004\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0011A\u0014xN^5eKJT!aY!\u0002\rA\f'/Y7t\u0013\t)\u0007M\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001iC\u0005I\u0017a\u0006;j[\u0016\u001cH/Y7q\u0007>tg-[4Qe>4\u0018\u000eZ3sQ\t)1\u000e\u0005\u0002m[6\t!-\u0003\u0002oE\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002/Q,7\u000f\u001e)s_\u0012,8-\u001a+p\u001d>t'+\u001a9mS\u000e\f\u0007F\u0001\u0004>\u0003\u0015\u001a'/Z1uKR{\u0007/[2B]\u00124\u0015N\u001c3QCJ$\u0018\u000e^5p]^KG\u000f\u001b'fC\u0012,'\u000f\u0006\u0002tsB!\u0011\b\u001e<w\u0013\t)XE\u0001\u0004UkBdWM\r\t\u0003s]L!\u0001_\u0013\u0003\u0007%sG\u000fC\u0003{\u000f\u0001\u0007Q*A\u0003u_BL7-\u0001\u000fuKN$8i\u001c:skB$HJ\u001f\u001bQe>$WoY3SKF,Xm\u001d;)\u0005!i\u0014A\u0006;fgRT6\u000b\u0016#Qe>$WoY3SKF,Xm\u001d;)\u0005%i\u0014AE:f]\u0012\u0004&o\u001c3vG\u0016\u0014V-];fgR$b!a\u0001\u0002\u001a\u0005u\u0001\u0003BA\u0003\u0003+i!!a\u0002\u000b\t\u0005%\u00111B\u0001\te\u0016\fX/Z:ug*!\u0011QBA\b\u0003\u0019\u0019w.\\7p]*\u00191#!\u0005\u000b\u0007\u0005MQ)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003/\t9AA\bQe>$WoY3SKN\u0004xN\\:f\u0011\u0019\tYB\u0003a\u0001m\u0006AA.Z1eKJLE\rC\u0004\u0002 )\u0001\r!!\t\u0002\u000fI,\u0017/^3tiB!\u0011QAA\u0012\u0013\u0011\t)#a\u0002\u0003\u001dA\u0013x\u000eZ;dKJ+\u0017/^3ti\u0006\u0011\u0002K]8ek\u000e,'+Z9vKN$H+Z:u!\t9BbE\u0002\r\u0003[\u00012!OA\u0018\u0013\r\t\t$\n\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%RCAA\u001c!\u0019\tI$a\u0012\u0002L5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0004tiJ,\u0017-\u001c\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003vi&d'BAA#\u0003\u0011Q\u0017M^1\n\t\u0005%\u00131\b\u0002\u0007'R\u0014X-Y7\u0011\u0007}\u000bi%C\u0002\u0002P\u0001\u0014\u0011\"\u0011:hk6,g\u000e^:")
public class ProduceRequestTest
extends BaseRequestTest {
    private final Set<MetricName> metricsKeySet = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala();

    public static Stream<Arguments> timestampConfigProvider() {
        return ProduceRequestTest$.MODULE$.timestampConfigProvider();
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSimpleProduceRequest() {
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())}), 0L, (int)var2_2, (int)var3_3);
        this.sendAndCheck$1(MemoryRecords.withRecords((CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key1".getBytes(), "value1".getBytes()), new SimpleRecord(System.currentTimeMillis(), "key2".getBytes(), "value2".getBytes())}), 1L, (int)var2_2, (int)var3_3);
    }

    @ParameterizedTest
    @MethodSource(value={"timestampConfigProvider"})
    public void testProduceWithInvalidTimestamp(String messageTimeStampConfig, long recordTimestamp) {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(messageTimeStampConfig, "1000");
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords records = ProduceRequestTest.createRecords$1((byte)2, recordTimestamp, CompressionType.GZIP);
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceResponse produceResponse = this.sendProduceRequest(leader, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.INVALID_TIMESTAMP, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((int)3, (int)partitionProduceResponse.recordErrors().size());
        Buffer recordErrors = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionProduceResponse.recordErrors()).asScala();
        recordErrors.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((int)i, (int)((ProduceResponseData.BatchIndexAndErrorMessage)recordErrors.apply(i)).batchIndex()));
        recordErrors.foreach((Function1 & Serializable & scala.Serializable)recordError -> {
            ProduceRequestTest.$anonfun$testProduceWithInvalidTimestamp$2(recordError);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)"One or more records have been rejected due to invalid timestamp", (Object)partitionProduceResponse.errorMessage());
    }

    @Test
    public void testProduceToNonReplica() {
        String topic = "topic";
        int partition = 0;
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testProduceToNonReplica$1(leader, x$2)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequest produceRequest = (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)records)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build();
        ProduceResponse produceResponse = this.sendProduceRequest(nonReplicaId, produceRequest);
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        Assertions.assertEquals((Object)Errors.NOT_LEADER_OR_FOLLOWER, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
    }

    private Tuple2<Object, Object> createTopicAndFindPartitionWithLeader(String topic) {
        return (Tuple2)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 3, 2, (Seq<KafkaBroker>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    int leader = x1._2$mcI$sp();
                    if (leader != -1) {
                        return (B1)new Tuple2.mcII.sp(partition, leader);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                return x1 != null && x1._2$mcI$sp() != -1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(28).append("No leader elected for topic ").append(topic).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptLz4ProduceRequest() {
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndFindPartitionWithLeader("topic");
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int partition = tuple2._1$mcI$sp();
        int leader = tuple2._2$mcI$sp();
        int timestamp = 1000000;
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.LZ4, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord((long)timestamp, "key".getBytes(), "value".getBytes())});
        int lz4ChecksumOffset = 6;
        memoryRecords.buffer().array()[61 + lz4ChecksumOffset] = 0;
        TopicPartition topicPartition = new TopicPartition("topic", (int)var2_2);
        ProduceResponse produceResponse = this.sendProduceRequest((int)var3_3, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.CORRUPT_MESSAGE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertEquals((int)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProduceRequestTest.$anonfun$testCorruptLz4ProduceRequest$1(x$4))), (int)1);
        Assertions.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testZSTDProduceRequest() {
        String topic = "topic";
        int partition = 0;
        Properties topicConfig = new Properties();
        topicConfig.setProperty("compression.type", BrokerCompressionType.ZSTD.name);
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), topicConfig).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.ZSTD, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes())});
        TopicPartition topicPartition = new TopicPartition("topic", partition);
        ProduceRequestData partitionRecords = new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("topic").setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(partition).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null);
        ProduceResponse produceResponse1 = this.sendProduceRequest(leader, (ProduceRequest)new ProduceRequest.Builder(7, 7, partitionRecords).build());
        ProduceResponseData.TopicProduceResponse topicProduceResponse1 = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse1.data().responses()).asScala()).head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse1 = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse1.partitionResponses()).asScala()).head();
        TopicPartition tp1 = new TopicPartition(topicProduceResponse1.name(), partitionProduceResponse1.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse1.errorCode()));
        Assertions.assertEquals((long)0L, (long)partitionProduceResponse1.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse1.logAppendTimeMs());
        ProduceResponse produceResponse2 = this.sendProduceRequest(leader, new ProduceRequest.Builder(3, 3, partitionRecords).buildUnsafe((short)3));
        ProduceResponseData.TopicProduceResponse topicProduceResponse2 = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse2.data().responses()).asScala()).head();
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse2 = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse2.partitionResponses()).asScala()).head();
        TopicPartition tp2 = new TopicPartition(topicProduceResponse2.name(), partitionProduceResponse2.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp2);
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_COMPRESSION_TYPE, (Object)Errors.forCode((short)partitionProduceResponse2.errorCode()));
    }

    private ProduceResponse sendProduceRequest(int leaderId, ProduceRequest request) {
        return (ProduceResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ProduceResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private final void sendAndCheck$1(MemoryRecords memoryRecords, long expectedOffset, int partition$1, int leader$1) {
        TopicPartition topicPartition = new TopicPartition("topic", partition$1);
        ProduceResponse produceResponse = this.sendProduceRequest(leader$1, (ProduceRequest)ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData().setTopicData(new ProduceRequestData.TopicProduceDataCollection(Collections.singletonList(new ProduceRequestData.TopicProduceData().setName(topicPartition.topic()).setPartitionData(Collections.singletonList(new ProduceRequestData.PartitionProduceData().setIndex(topicPartition.partition()).setRecords((BaseRecords)memoryRecords)))).iterator())).setAcks((short)-1).setTimeoutMs(3000).setTransactionalId(null)).build());
        Assertions.assertEquals((int)1, (int)produceResponse.data().responses().size());
        ProduceResponseData.TopicProduceResponse topicProduceResponse = (ProduceResponseData.TopicProduceResponse)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)produceResponse.data().responses()).asScala()).head();
        Assertions.assertEquals((int)1, (int)topicProduceResponse.partitionResponses().size());
        ProduceResponseData.PartitionProduceResponse partitionProduceResponse = (ProduceResponseData.PartitionProduceResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicProduceResponse.partitionResponses()).asScala()).head();
        TopicPartition tp = new TopicPartition(topicProduceResponse.name(), partitionProduceResponse.index());
        Assertions.assertEquals((Object)topicPartition, (Object)tp);
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)partitionProduceResponse.errorCode()));
        Assertions.assertEquals((long)expectedOffset, (long)partitionProduceResponse.baseOffset());
        Assertions.assertEquals((long)-1L, (long)partitionProduceResponse.logAppendTimeMs());
        Assertions.assertTrue((boolean)partitionProduceResponse.recordErrors().isEmpty());
    }

    private static final MemoryRecords createRecords$1(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    public static final /* synthetic */ void $anonfun$testProduceWithInvalidTimestamp$2(ProduceResponseData.BatchIndexAndErrorMessage recordError) {
        Assertions.assertNotNull((Object)recordError.batchIndexErrorMessage());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceToNonReplica$1(int leader$2, KafkaServer x$2) {
        return x$2.config().brokerId() != leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptLz4ProduceRequest$1(MetricName x$4) {
        return x$4.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMessageCrcRecordsPerSec()));
    }
}

