/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.AlterCredentialsTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsRequest;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\u0007\u000e\u0001IAQa\u0006\u0001\u0005\u0002aAQA\u0007\u0001\u0005BmAq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00045\u0001\u0001\u0006IA\f\u0005\bk\u0001\u0011\r\u0011\"\u0003.\u0011\u00191\u0004\u0001)A\u0005]!)q\u0007\u0001C\u0001q!)a\t\u0001C\u0001q!)\u0001\n\u0001C\u0005\u0013\"9!\rAI\u0001\n\u0013\u0019\u0007\"\u00028\u0001\t\u0013y'!M!mi\u0016\u0014Xk]3s'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bYN\u0014V-];fgRtu\u000e^!vi\"|'/\u001b>fIR+7\u000f\u001e\u0006\u0003\u001d=\taa]3sm\u0016\u0014(\"\u0001\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0005\t\u0003)Ui\u0011!D\u0005\u0003-5\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"\u0001\u0006\u0001\u0002/\t\u0014xn[3s!J|\u0007/\u001a:us>3XM\u001d:jI\u0016\u001cHC\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0011)f.\u001b;\t\u000b\r\u0012\u0001\u0019\u0001\u0013\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!Q\u000f^5m\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003vg\u0016\u0014\u0018'F\u0001/!\ty#'D\u00011\u0015\t\t\u0004&\u0001\u0003mC:<\u0017BA\u001a1\u0005\u0019\u0019FO]5oO\u00061Qo]3sc\u0001\nQ!^:feJ\na!^:feJ\u0002\u0013!\b;fgR\fE\u000e^3s\u001d>$\b.\u001b8h\u001d>$\u0018)\u001e;i_JL'0\u001a3\u0015\u0003qA#a\u0002\u001e\u0011\u0005m\"U\"\u0001\u001f\u000b\u0005ur\u0014aA1qS*\u0011q\bQ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\t%)A\u0003kk:LGOC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012A\u0001V3ti\u0006yB/Z:u\u00032$XM]*p[\u0016$\b.\u001b8h\u001d>$\u0018)\u001e;i_JL'0\u001a3)\u0005!Q\u0014\u0001J:f]\u0012\fE\u000e^3s+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;\u0015\u0007)+&\f\u0005\u0002L'6\tAJ\u0003\u0002N\u001d\u0006A!/Z9vKN$8O\u0003\u0002P!\u000611m\\7n_:T!\u0001E)\u000b\u0005I\u0013\u0015AB1qC\u000eDW-\u0003\u0002U\u0019\n\t\u0013\t\u001c;feV\u001bXM]*de\u0006l7I]3eK:$\u0018.\u00197t%\u0016\u001c\bo\u001c8tK\")a+\u0003a\u0001/\u00069!/Z9vKN$\bCA&Y\u0013\tIFJ\u0001\u0011BYR,'/V:feN\u001b'/Y7De\u0016$WM\u001c;jC2\u001c(+Z9vKN$\bbB.\n!\u0003\u0005\r\u0001X\u0001\rg>\u001c7.\u001a;TKJ4XM\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?>\tqA\\3uo>\u00148.\u0003\u0002b=\na1k\\2lKR\u001cVM\u001d<fe\u0006q3/\u001a8e\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005!'F\u0001/fW\u00051\u0007CA4m\u001b\u0005A'BA5k\u0003%)hn\u00195fG.,GM\u0003\u0002l=\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00055D'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t3\r[3dW\u0006cG.\u0012:s_J\u001c\u0018\t\u001c;fe&twm\u0011:fI\u0016tG/[1mgR1A\u0004]A\f\u0003OAQ!]\u0006A\u0002I\faB]3tk2$8\u000fV8DQ\u0016\u001c7\u000eE\u0002&gVL!\u0001\u001e\u0014\u0003\t1K7\u000f\u001e\t\u0004m\u0006EabA<\u0002\f9\u0019\u00010a\u0002\u000f\u0007e\f)AD\u0002{\u0003\u0007q1a_A\u0001\u001d\tax0D\u0001~\u0015\tq\u0018#\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u0011!KQ\u0005\u0003!EK!a\u0014)\n\u0007\u0005%a*A\u0004nKN\u001c\u0018mZ3\n\t\u00055\u0011qB\u0001&\u00032$XM]+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006T1!!\u0003O\u0013\u0011\t\u0019\"!\u0006\u0003?\u0005cG/\u001a:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgVdGO\u0003\u0003\u0002\u000e\u0005=\u0001bBA\r\u0017\u0001\u0007\u00111D\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tO\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\u0013\u0003?\u0011a!\u0012:s_J\u001c\bbBA\u0015\u0017\u0001\u0007\u00111F\u0001\u000bG>tG/\u001a=u\u001bN<\u0007\u0003BA\u0017\u0003kqA!a\f\u00022A\u0011APH\u0005\u0004\u0003gq\u0012A\u0002)sK\u0012,g-C\u00024\u0003oQ1!a\r\u001f\u0001")
public class AlterUserScramCredentialsRequestNotAuthorizedTest
extends BaseRequestTest {
    private final String user1;
    private final String user2;

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AlterCredentialsTest.TestAuthorizer.class.getName());
        properties.put(KafkaConfig$.MODULE$.PrincipalBuilderClassProp(), AlterCredentialsTest.TestPrincipalBuilderReturningUnauthorized.class.getName());
    }

    private String user1() {
        return this.user1;
    }

    private String user2() {
        return this.user2;
    }

    @Test
    public void testAlterNothingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(new ArrayList()).setUpsertions(new ArrayList())).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)0, (int)results.size());
    }

    @Test
    public void testAlterSomethingNotAuthorized() {
        AlterUserScramCredentialsRequest request = (AlterUserScramCredentialsRequest)new AlterUserScramCredentialsRequest.Builder(new AlterUserScramCredentialsRequestData().setDeletions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialDeletion[]{new AlterUserScramCredentialsRequestData.ScramCredentialDeletion().setName(this.user1()).setMechanism(ScramMechanism.SCRAM_SHA_256.type())})).setUpsertions(Arrays.asList((Object[])new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion[]{new AlterUserScramCredentialsRequestData.ScramCredentialUpsertion().setName(this.user2()).setMechanism(ScramMechanism.SCRAM_SHA_512.type())}))).build();
        List results = this.sendAlterUserScramCredentialsRequest(request, this.sendAlterUserScramCredentialsRequest$default$2()).data().results();
        Assertions.assertEquals((int)2, (int)results.size());
        this.checkAllErrorsAlteringCredentials(results, Errors.CLUSTER_AUTHORIZATION_FAILED, "when not authorized");
    }

    private AlterUserScramCredentialsResponse sendAlterUserScramCredentialsRequest(AlterUserScramCredentialsRequest request, SocketServer socketServer) {
        return (AlterUserScramCredentialsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(AlterUserScramCredentialsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendAlterUserScramCredentialsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private void checkAllErrorsAlteringCredentials(List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> resultsToCheck, Errors expectedError, String contextMsg) {
        Assertions.assertEquals((int)0, (int)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(resultsToCheck).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AlterUserScramCredentialsRequestNotAuthorizedTest.$anonfun$checkAllErrorsAlteringCredentials$1(expectedError, x$1)))).size(), (String)new StringBuilder(49).append("Expected all '").append(expectedError.name()).append("' errors when altering credentials ").append(contextMsg).toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkAllErrorsAlteringCredentials$1(Errors expectedError$1, AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult x$1) {
        return x$1.errorCode() == expectedError$1.code();
    }

    public AlterUserScramCredentialsRequestNotAuthorizedTest() {
        this.user1 = "user1";
        this.user2 = "user2";
    }
}

