/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001\u0002\u000e\u001c\u0001\u0001BQa\n\u0001\u0005\u0002!BQa\u000b\u0001\u0005\u00021BQ!\u0010\u0001\u0005\u00021BQa\u0010\u0001\u0005\u00021BQ!\u0011\u0001\u0005\u00021BQa\u0011\u0001\u0005\u00021BQ!\u0012\u0001\u0005\u00021BQa\u0012\u0001\u0005\u00021BQ!\u0013\u0001\u0005\u00021BQa\u0013\u0001\u0005\u00021BQ!\u0014\u0001\u0005\u00021BQa\u0014\u0001\u0005\u00021BQ!\u0015\u0001\u0005\nICQa\u0019\u0001\u0005\n\u0011DQ\u0001\u001c\u0001\u0005\u00021BQA\u001c\u0001\u0005\u00021BQ\u0001\u001d\u0001\u0005\u00021BQA\u001d\u0001\u0005\u00021BQ\u0001\u001e\u0001\u0005\nUDa!a\b\u0001\t\u0003a\u0003bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!a\u001d\u0001\t\u0003\t)\b\u0003\u0004\u0002\u0004\u0002!\t\u0001\f\u0002\u000e\u0019><7i\u001c8gS\u001e$Vm\u001d;\u000b\u0005qi\u0012a\u00017pO*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002SA\u0011!\u0006A\u0007\u00027\u0005YSM\\:ve\u0016tun\u0015;bi&\u001c\u0017J\\5uS\u0006d\u0017N_1uS>twJ\u001d3fe\u0012+\u0007/\u001a8eK:\u001c\u0017\u0010F\u0001.!\t\u0011c&\u0003\u00020G\t!QK\\5uQ\t\u0011\u0011\u0007\u0005\u00023w5\t1G\u0003\u00025k\u0005\u0019\u0011\r]5\u000b\u0005Y:\u0014a\u00026va&$XM\u001d\u0006\u0003qe\nQA[;oSRT\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f4\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f^&bM.\f7i\u001c8gS\u001e$v\u000e\u0015:paND#aA\u0019\u0002)Q,7\u000f\u001e$s_6\u0004&o\u001c9t\u0013:4\u0018\r\\5eQ\t!\u0011'\u0001\u0010uKN$\u0018J\u001c<bY&$7i\\7qC\u000e$\u0018n\u001c8MC\u001e\u001cuN\u001c4jO\"\u0012Q!M\u0001&g\"|W\u000f\u001c3WC2LG-\u0019;f)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c8i\u001c8gS\u001eD#AB\u0019\u0002\u001fQ,7\u000f\u001e+p\u0011RlG\u000eV1cY\u0016D#aB\u0019\u0002\u0015Q,7\u000f\u001e+p\u0011RlG\u000e\u000b\u0002\tc\u0005\tB/Z:u)>,eN]5dQ\u0016$'k\u001d;)\u0005%\t\u0014!\u0003;fgR$vNU:uQ\tQ\u0011'\u0001\nuKN$x)\u001a;D_:4\u0017n\u001a,bYV,\u0007FA\u00062\u0003\u0015\"Xm\u001d;Pm\u0016\u0014(/\u001b3eK:\u001cuN\u001c4jON\f5\u000fT8hO\u0006\u0014G.Z*ue&tw\r\u000b\u0002\rc\u00059\u0011n\u001d,bY&$GCA*W!\t\u0011C+\u0003\u0002VG\t9!i\\8mK\u0006t\u0007\"B,\u000e\u0001\u0004A\u0016aC2p]\u001aLwMV1mk\u0016\u0004\"!\u00171\u000f\u0005is\u0006CA.$\u001b\u0005a&BA/ \u0003\u0019a$o\\8u}%\u0011qlI\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`G\u0005)\u0012m]:feR\u0004&o\u001c9feRL\u0018J\u001c<bY&$GcA\u0017fO\")aM\u0004a\u00011\u0006!a.Y7f\u0011\u0015Ag\u00021\u0001j\u0003\u00191\u0018\r\\;fgB\u0019!E[\u0011\n\u0005-\u001c#A\u0003\u001fsKB,\u0017\r^3e}\u0005\tC/Z:u\u0019>\u001c\u0017\r\u001c'pOJ+G/\u001a8uS>tG)\u001a:jm\u0016$\u0007K]8qg\"\u0012q\"M\u0001)i\u0016\u001cH\u000fT8dC2dun\u001a*fi\u0016tG/[8o\t\u0016\u0014\u0018N^3e\t\u00164\u0017-\u001e7u!J|\u0007o\u001d\u0015\u0003!E\n!\u0004^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000e\u0015:paND#!E\u0019\u0002CQ,7\u000f^%om\u0006d\u0017\u000e\u001a'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:)\u0005I\t\u0014a\t3p)\u0016\u001cH/\u00138wC2LG\rT8dC2dun\u001a*fi\u0016tG/[8o!J|\u0007o\u001d\u000b\nm\u0006\r\u0011QBA\f\u00037\u0001\"a^@\u000e\u0003aT!!\u001f>\u0002\r\r|gNZ5h\u0015\tYH0\u0001\u0004d_6lwN\u001c\u0006\u0003=uT!A`\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\t\t\u0001\u001f\u0002\u0010\u0007>tg-[4Fq\u000e,\u0007\u000f^5p]\"9\u0011QA\nA\u0002\u0005\u001d\u0011\u0001\u00057pG\u0006d'+\u001a;f]RLwN\\'t!\r\u0011\u0013\u0011B\u0005\u0004\u0003\u0017\u0019#\u0001\u0002'p]\u001eDq!a\u0004\u0014\u0001\u0004\t\t\"A\nm_\u000e\fGNU3uK:$\u0018n\u001c8CsR,7\u000fE\u0002#\u0003'I1!!\u0006$\u0005\rIe\u000e\u001e\u0005\b\u00033\u0019\u0002\u0019AA\t\u00039\u0011X\r^3oi&|gNQ=uKNDq!!\b\u0014\u0001\u0004\t9!A\u0006sKR,g\u000e^5p]6\u001b\u0018A\u000b;fgR,e.\u00192mKJ+Wn\u001c;f\u0019><7\u000b^8sC\u001e,wJ\\\"p[B\f7\r^3e)>\u0004\u0018n\u0019\u0015\u0003)E\n!\u0004^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e\u001cFo\u001c:bO\u0016$2!LA\u0014\u0011\u0019\tI#\u0006a\u0001'\u000692/_:SK6|G/Z*u_J\fw-Z#oC\ndW\r\u001a\u0015\b+\u00055\u0012QHA !\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0003o)\u0014A\u00029be\u0006l7/\u0003\u0003\u0002<\u0005E\"a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u0003\n\u0019%G\u0001\u00023\u0005\u0001\u0001FB\u000b\u0002H\u0019\fy\u0005\u0005\u0003\u0002J\u0005-SBAA\u001b\u0013\u0011\ti%!\u000e\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\t\u0002\u0002R\u0005aD/Z:u\u000b:\f'\r\\3SK6|G/\u001a'pON#xN]1hK\u0002:\u0018\u000e\u001e5!gf\u001c(+Z7pi\u0016\u001cFo\u001c:bO\u0016,e.\u00192mK\u0012T\u0004e\u001f\u0019~\u0003%\"Xm\u001d;U_BL7m\u0011:fCRLwN\\,ji\"LeN^1mS\u0012\u0014V\r^3oi&|g\u000eV5nKR\u0019Q&a\u0016\t\r\u0005%b\u00031\u0001TQ\u001d1\u0012QFA\u001f\u00037bC!!\u0011\u0002D!2a#a\u0012g\u0003?\n#!!\u0019\u0002\u0017R,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ&sg/\u00197jIJ+G/\u001a8uS>tG+[7fA]LG\u000f\u001b\u0011tsN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIj\u00023\u0010M?\u0002SQ,7\u000f\u001e+pa&\u001c7I]3bi&|gnV5uQ&sg/\u00197jIJ+G/\u001a8uS>t7+\u001b>f)\ri\u0013q\r\u0005\u0007\u0003S9\u0002\u0019A*)\u000f]\ti#!\u0010\u0002l1\"\u0011\u0011IA\"Q\u00199\u0012q\t4\u0002p\u0005\u0012\u0011\u0011O\u0001Li\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0013:4\u0018\r\\5e%\u0016$XM\u001c;j_:\u001c\u0016N_3!o&$\b\u000eI:zgJ+Wn\u001c;f'R|'/Y4f\u000b:\f'\r\\3eu\u0001Z\b'`\u0001\u001di\u0016\u001cHOV1mS\u0012\fG/\u001a\"s_.,'\u000fT8h\u0007>tg-[4t)\ri\u0013q\u000f\u0005\u0007\u0003SA\u0002\u0019A*)\u000fa\ti#!\u0010\u0002|1\"\u0011\u0011IA\"Q\u0019A\u0012q\t4\u0002\u0000\u0005\u0012\u0011\u0011Q\u0001?i\u0016\u001cHOV1mS\u0012\fG/\u001a\"s_.,'\u000fT8h\u0007>tg-[4tA]LG\u000f\u001b\u0011tsN\u0014V-\\8uKN#xN]1hK\u0016s\u0017M\u00197fIj\u00023\u0010M?\u0002YQ,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0005\u00164wN]3NCbl5/V:fg\u0012+\u0007O]3dCR,GmQ8oM&<\u0007FA\r2\u0001")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(LogConfig.configNames()).asScala()).filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        long millisInDay = 24L * millisInHour;
        long bytesInGB = 0x40000000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "960");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        kafkaProps.put("log.local.retention.ms", "2592000000");
        kafkaProps.put("log.local.retention.bytes", "4294967296");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(40L * millisInDay)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(30L * millisInDay)), logProps.get("local.retention.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(4L * bytesInGB)), logProps.get("local.retention.bytes"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            if ("unclean.leader.election.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                return;
            }
            if ("retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("cleanup.policy".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                return;
            }
            if ("min.cleanable.dirty.ratio".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                return;
            }
            if ("min.insync.replicas".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                return;
            }
            if ("message.format.version".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                return;
            }
            if ("remote.storage.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                return;
            }
            if ("local.retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            if ("local.retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)-1L, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.localRetentionMs());
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.localRetentionBytes());
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties props = new Properties();
        props.put("remote.storage.enable", "true");
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)props, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
    }

    @Test
    public void testEnableRemoteLogStorageOnCompactedTopic() {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", "true");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("cleanup.policy", "delete");
        logProps.put("remote.storage.enable", "true");
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
        logProps.put("cleanup.policy", "compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
        logProps.put("cleanup.policy", "delete,compact");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
        logProps.put("cleanup.policy", "compact,delete");
        Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())));
    }

    @ParameterizedTest(name="testEnableRemoteLogStorage with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testEnableRemoteLogStorage(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", "true");
        if (sysRemoteStorageEnabled) {
            LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
            return;
        }
        Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("Tiered Storage functionality is disabled in the broker"));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionTime with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionTime(boolean sysRemoteStorageEnabled) {
        Properties kafkaProps = TestUtils$.MODULE$.createDummyBrokerConfig();
        kafkaProps.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000");
        kafkaProps.put("log.local.retention.ms", "900");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.ms", "500");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.ms"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @ParameterizedTest(name="testTopicCreationWithInvalidRetentionSize with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testTopicCreationWithInvalidRetentionSize(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "512");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        logProps.put("remote.storage.enable", Boolean.toString(sysRemoteStorageEnabled));
        logProps.put("retention.bytes", "128");
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validate((Properties)logProps, (Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @ParameterizedTest(name="testValidateBrokerLogConfigs with sysRemoteStorageEnabled: {0}")
    @ValueSource(booleans={true, false})
    public void testValidateBrokerLogConfigs(boolean sysRemoteStorageEnabled) {
        Properties props = TestUtils$.MODULE$.createDummyBrokerConfig();
        props.put("remote.log.storage.system.enable", Boolean.toString(sysRemoteStorageEnabled));
        props.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1024");
        props.put("log.local.retention.bytes", "2048");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        if (sysRemoteStorageEnabled) {
            Assertions.assertTrue((boolean)((ConfigException)Assertions.assertThrows(ConfigException.class, () -> LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled())))).getMessage().contains("local.retention.bytes"));
            return;
        }
        LogConfig.validateBrokerLogConfigValues((Map)kafkaConfig.extractLogConfigMap(), (boolean)Predef$.MODULE$.Boolean2boolean(kafkaConfig.isRemoteLogStorageSystemEnabled()));
    }

    @Test
    public void testTimestampBeforeMaxMsUsesDeprecatedConfig() {
        long oneDayInMillis = 86400000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampBeforeMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampAfterMaxMsProp(), Long.toString(Long.MAX_VALUE));
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageTimestampDifferenceMaxMsProp(), Long.toString(oneDayInMillis));
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.before.max.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)oneDayInMillis), logProps.get("message.timestamp.after.max.ms"));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }
}

