/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerRequestCompletionHandler;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u001d;\u0001\u0005CQ\u0001\u0013\u0001\u0005\u0002%Cq\u0001\u0014\u0001C\u0002\u0013%Q\n\u0003\u0004R\u0001\u0001\u0006IA\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003N\u0011\u0019\u0019\u0006\u0001)A\u0005\u001d\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00020\u0001A\u0003%a\u000bC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u0011\u0004\u0001\u0015!\u0003b\u0011\u001d)\u0007A1A\u0005\n\u0019DaA\u001b\u0001!\u0002\u00139\u0007bB6\u0001\u0005\u0004%IA\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B4\t\u000f5\u0004!\u0019!C\u0005\u001b\"1a\u000e\u0001Q\u0001\n9Cqa\u001c\u0001C\u0002\u0013%Q\n\u0003\u0004q\u0001\u0001\u0006IA\u0014\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u001d\t\t\u0001\u0001Q\u0001\nMD\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u000fA\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003+A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003[A\u0011\"!\u000e\u0001\u0005\u0004%I!a\u000e\t\u0011\u0005}\u0002\u0001)A\u0005\u0003sA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005-\u0003\u0001)A\u0005\u0003\u000bB\u0011\"!\u0014\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003#Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002d\u0001!\t!a\u0017\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\\!9\u0011q\u0010\u0001\u0005\u0002\u0005m\u0003bBAB\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u000f\u0003A\u0011AA.\u0011\u001d\tY\t\u0001C\u0001\u00037Bq!a$\u0001\t\u0003\tY\u0006C\u0004\u0002\u0014\u0002!\t!a\u0017\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\\!9\u00111\u0014\u0001\u0005\u0002\u0005m\u0003bBAP\u0001\u0011\u0005\u00111\f\u0005\b\u0003G\u0003A\u0011AA.\u0011\u001d\t9\u000b\u0001C\u0001\u00037Bq!a+\u0001\t\u0003\tY\u0006C\u0004\u00020\u0002!\t!a\u0017\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\\!9\u0011q\u0017\u0001\u0005\u0002\u0005m\u0003bBA^\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u007f\u0003A\u0011AA.\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\u0005%\b\u0001\"\u0003\u0002l\"9\u0011q\u001e\u0001\u0005\n\u0005E(!\f+sC:\u001c\u0018m\u0019;j_:l\u0015M]6feJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000fV3ti*\u00111\bP\u0001\fiJ\fgn]1di&|gN\u0003\u0002>}\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005y\u0014!B6bM.\f7\u0001A\n\u0003\u0001\t\u0003\"a\u0011$\u000e\u0003\u0011S\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\u0012\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001K!\tY\u0005!D\u0001;\u0003!\u0011'o\\6fe&#W#\u0001(\u0011\u0005\r{\u0015B\u0001)E\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\n\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0003I!\bP\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012A\u0016\t\u0003/rk\u0011\u0001\u0017\u0006\u00033j\u000bA\u0001\\1oO*\t1,\u0001\u0003kCZ\f\u0017BA/Y\u0005\u0019\u0019FO]5oO\u0006\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#W#A1\u0011\u0005\r\u0013\u0017BA2E\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0016\u0003\u001d\u0004\"a\u00115\n\u0005%$%!B*i_J$\u0018A\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eI\u0001\u0012Y\u0006\u001cH\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0017A\u00057bgR\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\u0002\nA\u0002\u001e=o)&lWm\\;u\u001bN\fQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\nibt'+Z:vYR,\u0012a\u001d\t\u0003izl\u0011!\u001e\u0006\u0003m^\f\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003qf\faaY8n[>t'BA {\u0015\tYH0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0006\u0019qN]4\n\u0005},(!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006QA\u000f\u001f8SKN,H\u000e\u001e\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011q\u0001\t\u0005\u0003\u0013\tY!D\u0001x\u0013\r\tia\u001e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;y]&#\u0017I\u001c3NCJ\\WM]:\u0016\u0005\u0005U\u0001CBA\f\u0003;\t\t#\u0004\u0002\u0002\u001a)\u0019\u00111\u0004.\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003?\tIB\u0001\u0003MSN$\bcA&\u0002$%\u0019\u0011Q\u0005\u001e\u0003'QCh.\u00133B]\u0012l\u0015M]6fe\u0016sGO]=\u0002!QDh.\u00133B]\u0012l\u0015M]6feN\u0004\u0013a\u0003;y]6+G/\u00193bi\u0006,\"!!\f\u0011\u0007-\u000by#C\u0002\u00022i\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\fA\u0002\u001e=o\u001b\u0016$\u0018\rZ1uC\u0002\nA#\\1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014XCAA\u001d!\rY\u00151H\u0005\u0004\u0003{Q$a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006)R.\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\u0013a\u0004;y]N#\u0018\r^3NC:\fw-\u001a:\u0016\u0005\u0005\u0015\u0003cA&\u0002H%\u0019\u0011\u0011\n\u001e\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\u0018\u0001\u0005;y]N#\u0018\r^3NC:\fw-\u001a:!\u0003\u001dA\u0017M\u001c3mKJ,\"!!\u0015\u0011\u0007-\u000b\u0019&C\u0002\u0002Vi\u0012\u0011\u0006\u0016:b]N\f7\r^5p]6\u000b'o[3s%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>t\u0007*\u00198eY\u0016\u0014\u0018\u0001\u00035b]\u0012dWM\u001d\u0011\u0002\u00135|7m[\"bG\",GCAA/!\r\u0019\u0015qL\u0005\u0004\u0003C\"%\u0001B+oSR\fqf\u001d5pk2$'+Z#ocV,W/\u001a)beRLG/[8og^CWM\u001c\"s_.,'\u000fR5tG>tg.Z2uK\u0012D3!IA4!\u0011\tI'a\u001e\u000e\u0005\u0005-$\u0002BA7\u0003_\n1!\u00199j\u0015\u0011\t\t(a\u001d\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q\u000f?\u0002\u000b),h.\u001b;\n\t\u0005e\u00141\u000e\u0002\u0005)\u0016\u001cH/A\u001ftQ>,H\u000e\u001a+ie><\u0018\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0017JZ#se>\u00148i\u001c3f\u001d>$\u0018I^1jY\u0006\u0014G.\u001a$peBKG\rK\u0002#\u0003O\n!f\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016tgj\\#se>\u00148\u000fK\u0002$\u0003O\n\u0001g\u001d5pk2$7i\\7qY\u0016$X\rR3mCf,Gm\u00149fe\u0006$\u0018n\u001c8XQ\u0016tgj\u001c;D_>\u0014H-\u001b8bi>\u0014\bf\u0001\u0013\u0002h\u0005!4\u000f[8vY\u0012\u001cu.\u001c9mKR,G)\u001a7bs\u0016$w\n]3sCRLwN\\,iK:\u001cun\u001c:eS:\fGo\u001c:M_\u0006$\u0017N\\4)\u0007\u0015\n9'A\u001dtQ>,H\u000eZ\"p[BdW\r^3EK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]^CWM\\\"p_J$\u0017N\\1u_J,\u0005o\\2i\u0007\"\fgnZ3eQ\r1\u0013qM\u00017g\"|W\u000f\u001c3D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:<\u0006.\u001a8J]Z\fG.\u001b3Qe>$WoY3s\u000bB|7\r\u001b\u0015\u0004O\u0005\u001d\u0014\u0001O:i_VdGmQ8na2,G/\u001a#fY\u0006LX\rZ(qKJ\fG/[8o/\",gnQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GK:\u001cW\r\u001a\u0015\u0004Q\u0005\u001d\u0014\u0001M:i_VdG\r\u00165s_^LE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:<\u0006.\u001a8V].twn\u001e8FeJ|'\u000fK\u0002*\u0003O\nqg\u001d5pk2$G\u000b\u001b:po&cG.Z4bYN#\u0018\r^3Fq\u000e,\u0007\u000f^5p]^CWM\\\"peJ,\b\u000f^'fgN\fw-Z#se>\u0014\bf\u0001\u0016\u0002h\u0005A4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",g.T3tg\u0006<W\rV8p\u0019\u0006\u0014x-Z#se>\u0014\bfA\u0016\u0002h\u0005Y4\u000f[8vY\u0012$\u0006N]8x\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o/\",gNU3d_J$G*[:u)>|G*\u0019:hK\u0016\u0013(o\u001c:)\u00071\n9'\u0001\u001ftQ>,H\u000e\u001a+ie><\u0018\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>tw\u000b[3o\u0013:4\u0018\r\\5e%\u0016\fX/\u001b:fI\u0006\u001b7n]#se>\u0014\bfA\u0017\u0002h\u0005!4\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8V].twn\u001e8U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0016\u0013(o\u001c:)\u00079\n9'\u0001\u0019tQ>,H\u000e\u001a*fiJL\b+\u0019:uSRLwN\\,iK:tu\u000e\u001e'fC\u0012,'o\u0014:G_2dwn^3s\u000bJ\u0014xN\u001d\u0015\u0004_\u0005\u001d\u0014AL:i_VdGMU3uef\u0004\u0016M\u001d;ji&|gn\u00165f]:{G/\u00128pk\u001eD'+\u001a9mS\u000e\f7/\u0012:s_JD3\u0001MA4\u0003e\u001a\bn\\;mIJ+GO]=QCJ$\u0018\u000e^5p]^CWM\u001c(pi\u0016sw.^4i%\u0016\u0004H.[2bg\u00063G/\u001a:BaB,g\u000eZ#se>\u0014\bfA\u0019\u0002h\u0005I3\u000f[8vY\u0012\u0014V\r\u001e:z!\u0006\u0014H/\u001b;j_:<\u0006.\u001a8LC\u001a\\\u0017m\u0015;pe\u0006<W-\u0012:s_JD3AMA4\u0003\u0015\u001b\bn\\;mIJ+Wn\u001c<f)>\u0004\u0018n\u0019)beRLG/[8o\rJ|WnV1ji&twmU3u\u001f:,fn];qa>\u0014H/\u001a3G_JlUm]:bO\u00164uN]7bi\"\u001a1'a\u001a\u0002;Y,'/\u001b4z%\u0016$(/[3t!\u0006\u0014H/\u001b;j_:|e.\u0012:s_J$B!!\u0018\u0002H\"9\u0011\u0011\u001a\u001bA\u0002\u0005-\u0017!B3se>\u0014\b\u0003BAg\u0003'l!!a4\u000b\u0007\u0005Ew/\u0001\u0005qe>$xnY8m\u0013\u0011\t).a4\u0003\r\u0015\u0013(o\u001c:t\u0003\u001d2XM]5gsRC'o\\<JY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8P]\u0016\u0013(o\u001c:\u0015\t\u0005m\u0017\u0011\u001d\t\u0004/\u0006u\u0017bAAp1\n)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>t\u0007bBAek\u0001\u0007\u00111Z\u0001&m\u0016\u0014\u0018NZ=D_6\u0004H.\u001a;f\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:|e.\u0012:s_J$B!!\u0018\u0002h\"9\u0011\u0011\u001a\u001cA\u0002\u0005-\u0017a\t<fe&4\u0017PU3n_Z,G)\u001a7bs\u0016$w\n]3sCRLwN\\(o\u000bJ\u0014xN\u001d\u000b\u0005\u0003;\ni\u000fC\u0004\u0002J^\u0002\r!a3\u00021\r\u0014X-\u0019;f!J|G-^2fe&#WI\u001d:pe6\u000b\u0007\u000f\u0006\u0003\u0002t\n\r\u0001\u0003CA\f\u0003k\fI0!@\n\t\u0005]\u0018\u0011\u0004\u0002\b\u0011\u0006\u001c\b.T1q!\r9\u00161`\u0005\u0003Gb\u0003\u0002\"a\u0006\u0002\u0000\u0006\u001d\u00111Z\u0005\u0005\u0005\u0003\tIBA\u0002NCBDqA!\u00029\u0001\u0004\tY-\u0001\u0004feJ|'o\u001d")
public class TransactionMarkerRequestCompletionHandlerTest {
    private final int brokerId;
    private final int txnTopicPartition;
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTimeoutMs;
    private final int coordinatorEpoch;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkers = Arrays.asList((Object[])new TxnIdAndMarkerEntry[]{new TxnIdAndMarkerEntry(this.transactionalId(), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()})))});
    private final TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})), 0L, 0L);
    private final TransactionMarkerChannelManager markerChannelManager = (TransactionMarkerChannelManager)Mockito.mock(TransactionMarkerChannelManager.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)Mockito.mock(TransactionStateManager.class);
    private final TransactionMarkerRequestCompletionHandler handler = new TransactionMarkerRequestCompletionHandler(this.brokerId(), this.txnStateManager(), this.markerChannelManager(), this.txnIdAndMarkers());

    private int brokerId() {
        return this.brokerId;
    }

    private int txnTopicPartition() {
        return this.txnTopicPartition;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private long producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private List<TxnIdAndMarkerEntry> txnIdAndMarkers() {
        return this.txnIdAndMarkers;
    }

    private TransactionMetadata txnMetadata() {
        return this.txnMetadata;
    }

    private TransactionMarkerChannelManager markerChannelManager() {
        return this.markerChannelManager;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TransactionMarkerRequestCompletionHandler handler() {
        return this.handler;
    }

    private void mockCache() {
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition()));
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata()))));
    }

    @Test
    public void shouldReEnqueuePartitionsWhenBrokerDisconnected() {
        this.mockCache();
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, true, null, null, null));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfErrorCodeNotAvailableForPid() {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(new HashMap());
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNoErrors() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenNotCoordinator() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorLoading() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochChanged() {
        Mockito.when((Object)this.txnStateManager().getTransactionState((String)ArgumentMatchers.eq((Object)this.transactionalId()))).thenReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch() + 1, this.txnMetadata()))));
        this.verifyRemoveDelayedOperationOnError(Errors.NONE);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenInvalidProducerEpoch() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.INVALID_PRODUCER_EPOCH);
    }

    @Test
    public void shouldCompleteDelayedOperationWhenCoordinatorEpochFenced() {
        this.mockCache();
        this.verifyRemoveDelayedOperationOnError(Errors.TRANSACTION_COORDINATOR_FENCED);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenUnknownError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenCorruptMessageError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.CORRUPT_MESSAGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenMessageTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.MESSAGE_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenRecordListTooLargeError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.RECORD_LIST_TOO_LARGE);
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenInvalidRequiredAcksError() {
        this.verifyThrowIllegalStateExceptionOnError(Errors.INVALID_REQUIRED_ACKS);
    }

    @Test
    public void shouldRetryPartitionWhenUnknownTopicOrPartitionError() {
        this.verifyRetriesPartitionOnError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void shouldRetryPartitionWhenNotLeaderOrFollowerError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS);
    }

    @Test
    public void shouldRetryPartitionWhenNotEnoughReplicasAfterAppendError() {
        this.verifyRetriesPartitionOnError(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
    }

    @Test
    public void shouldRetryPartitionWhenKafkaStorageError() {
        this.verifyRetriesPartitionOnError(Errors.KAFKA_STORAGE_ERROR);
    }

    @Test
    public void shouldRemoveTopicPartitionFromWaitingSetOnUnsupportedForMessageFormat() {
        this.mockCache();
        this.verifyCompleteDelayedOperationOnError(Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT);
    }

    private void verifyRetriesPartitionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertEquals((Object)this.txnMetadata().topicPartitions(), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
        ((TransactionMarkerChannelManager)Mockito.verify((Object)this.markerChannelManager())).addTxnMarkersToBrokerQueue(this.transactionalId(), this.producerId(), this.producerEpoch(), this.txnResult(), this.coordinatorEpoch(), (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()})));
    }

    private IllegalStateException verifyThrowIllegalStateExceptionOnError(Errors error) {
        this.mockCache();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        return (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response)));
    }

    private void verifyCompleteDelayedOperationOnError(Errors error) {
        BooleanRef completed = BooleanRef.create((boolean)false);
        this.markerChannelManager().maybeWriteTxnCompletion(this.transactionalId());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$1 -> {
            completed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)this.txnMetadata().topicPartitions().isEmpty());
        Assertions.assertTrue((boolean)completed.elem);
    }

    private void verifyRemoveDelayedOperationOnError(Errors error) {
        BooleanRef removed = BooleanRef.create((boolean)false);
        this.markerChannelManager().removeMarkersForTxnId(this.transactionalId());
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            removed.elem = true;
            return BoxedUnit.UNIT;
        });
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createProducerIdErrorMap(error));
        this.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
        Assertions.assertTrue((boolean)removed.elem);
    }

    private HashMap<Long, Map<TopicPartition, Errors>> createProducerIdErrorMap(Errors errors) {
        HashMap<Long, Map<TopicPartition, Errors>> pidMap = new HashMap<Long, Map<TopicPartition, Errors>>();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.topicPartition(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId()), errorsMap);
        return pidMap;
    }

    public TransactionMarkerRequestCompletionHandlerTest() {
        this.brokerId = 0;
        this.txnTopicPartition = 0;
        this.transactionalId = "txnId1";
        this.producerId = 0;
        this.txnTimeoutMs = 0;
        this.coordinatorEpoch = 0;
    }
}

