/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.timer.SystemTimer$;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\r\u001b\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0019A\u0005\u0001)A\u0005\u0013\"11\u000b\u0001Q\u0001\nQCaA\u0017\u0001!\u0002\u0013Y\u0006BB1\u0001A\u0003%!\r\u0003\u0004f\u0001\u0001\u0006IA\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011B7\t\rM\u0004\u0001\u0015!\u0003u\u0011\u00159\b\u0001\"\u0001y\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bA\u0001\"!\u0005\u0001A\u0003%\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t9\u0003\u0001C\u0001\u0003SAq!a\u000b\u0001\t\u0003\nicB\u0005\u0002:i\t\t\u0011#\u0001\u0002<\u0019A\u0011DGA\u0001\u0012\u0003\ti\u0004\u0003\u0004B)\u0011\u0005\u0011q\b\u0005\n\u0003\u0003\"\u0012\u0013!C\u0001\u0003\u0007B\u0011\"!\u0017\u0015#\u0003%\t!a\u0017\t\u0013\u0005}C#%A\u0005\u0002\u0005\r#aC*zgR,W\u000eV5nKJT!a\u0007\u000f\u0002\u000bQLW.\u001a:\u000b\u0005uq\u0012!B;uS2\u001c(\"A\u0010\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u001b\u0013\tY#DA\u0003US6,'/\u0001\u0007fq\u0016\u001cW\u000f^8s\u001d\u0006lW\r\u0005\u0002/k9\u0011qf\r\t\u0003a\u0011j\u0011!\r\u0006\u0003e\u0001\na\u0001\u0010:p_Rt\u0014B\u0001\u001b%\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\"\u0013A\u0002;jG.l5\u000f\u0005\u0002$u%\u00111\b\n\u0002\u0005\u0019>tw-A\u0005xQ\u0016,GnU5{KB\u00111EP\u0005\u0003\u007f\u0011\u00121!\u00138u\u0003\u001d\u0019H/\u0019:u\u001bN\fa\u0001P5oSRtD#B\"E\u000b\u001a;\u0005CA\u0015\u0001\u0011\u0015aS\u00011\u0001.\u0011\u001dAT\u0001%AA\u0002eBq\u0001P\u0003\u0011\u0002\u0003\u0007Q\bC\u0004A\u000bA\u0005\t\u0019A\u001d\u0002\u0019Q\f7o[#yK\u000e,Ho\u001c:\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015AC2p]\u000e,(O]3oi*\u0011ajT\u0001\u0005kRLGNC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005I[%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0015\u0011,G.Y=Rk\u0016,X\rE\u0002K+^K!AV&\u0003\u0015\u0011+G.Y=Rk\u0016,X\r\u0005\u0002*1&\u0011\u0011L\u0007\u0002\u000e)&lWM\u001d+bg.d\u0015n\u001d;\u0002\u0017Q\f7o[\"pk:$XM\u001d\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000ba!\u0019;p[&\u001c\u0017B\u00011^\u00055\tEo\\7jG&sG/Z4fe\u0006YA/[7j]\u001e<\u0006.Z3m!\tI3-\u0003\u0002e5\tYA+[7j]\u001e<\u0006.Z3m\u00035\u0011X-\u00193Xe&$X\rT8dWB\u0011qM[\u0007\u0002Q*\u0011\u0011nS\u0001\u0006Y>\u001c7n]\u0005\u0003W\"\u0014aCU3f]R\u0014\u0018M\u001c;SK\u0006$wK]5uK2{7m[\u0001\te\u0016\fG\rT8dWB\u0011a.]\u0007\u0002_*\u0011\u0001\u000f[\u0001\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW&\u0011!o\u001c\u0002\t%\u0016\fG\rT8dW\u0006IqO]5uK2{7m\u001b\t\u0003]VL!A^8\u0003\u0013]\u0013\u0018\u000e^3M_\u000e\\\u0017aA1eIR\u0011\u0011\u0010 \t\u0003GiL!a\u001f\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006{6\u0001\rA`\u0001\ni&lWM\u001d+bg.\u0004\"!K@\n\u0007\u0005\u0005!DA\u0005US6,'\u000fV1tW\u0006\t\u0012\r\u001a3US6,'\u000fV1tW\u0016sGO]=\u0015\u0007e\f9\u0001C\u0004\u0002\n9\u0001\r!a\u0003\u0002\u001dQLW.\u001a:UCN\\WI\u001c;ssB\u0019\u0011&!\u0004\n\u0007\u0005=!D\u0001\bUS6,'\u000fV1tW\u0016sGO]=\u0002\u0011I,\u0017N\\:feR\u0004baIA\u000b\u0003\u0017I\u0018bAA\fI\tIa)\u001e8di&|g.M\u0001\rC\u00124\u0018M\\2f\u00072|7m\u001b\u000b\u0005\u0003;\t\u0019\u0003E\u0002$\u0003?I1!!\t%\u0005\u001d\u0011un\u001c7fC:Da!!\n\u0011\u0001\u0004I\u0014!\u0003;j[\u0016|W\u000f^'t\u0003\u0011\u0019\u0018N_3\u0016\u0003u\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002s\"\u001a\u0001!!\r\u0011\t\u0005M\u0012QG\u0007\u00029%\u0019\u0011q\u0007\u000f\u0003\u0015QD'/Z1eg\u00064W-A\u0006TsN$X-\u001c+j[\u0016\u0014\bCA\u0015\u0015'\t!\"\u0005\u0006\u0002\u0002<\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!\u0012+\u0007e\n9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019\u0006J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\f\u0016\u0004{\u0005\u001d\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C\u0007")
public class SystemTimer
implements Timer {
    private final String executorName;
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function1<TimerTaskEntry, BoxedUnit> reinsert;

    public static long $lessinit$greater$default$4() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.delayMs() + Time.SYSTEM.hiResClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry)) {
            if (!timerTaskEntry.cancelled()) {
                this.taskExecutor.submit(timerTaskEntry.timerTask());
                return;
            }
            return;
        }
    }

    @Override
    public boolean advanceClock(long timeoutMs) {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this.reinsert);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    public SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.executorName = executorName;
        this.taskExecutor = Executors.newFixedThreadPool(1, runnable -> {
            String nonDaemon_name = new StringBuilder(9).append("executor-").append($this.executorName).toString();
            return new KafkaThread(nonDaemon_name, runnable, false);
        });
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = (Function1 & Serializable & scala.Serializable)timerTaskEntry -> {
            this.addTimerTaskEntry(timerTaskEntry);
            return BoxedUnit.UNIT;
        };
    }
}

