/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kafka.server.LinuxIoMetricsCollector$;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u000f\u001f\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011)\u0019!C\u0001o!AQ\t\u0001B\u0001B\u0003%\u0001\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!q\u0005A!A!\u0002\u0013A\u0005\"B(\u0001\t\u0003\u0001\u0006b\u0002,\u0001\u0001\u0004%\ta\u0016\u0005\b7\u0002\u0001\r\u0011\"\u0001]\u0011\u0019\u0011\u0007\u0001)Q\u00051\"91\r\u0001a\u0001\n\u00039\u0006b\u00023\u0001\u0001\u0004%\t!\u001a\u0005\u0007O\u0002\u0001\u000b\u0015\u0002-\t\u000f!\u0004\u0001\u0019!C\u0001/\"9\u0011\u000e\u0001a\u0001\n\u0003Q\u0007B\u00027\u0001A\u0003&\u0001\fC\u0004n\u0001\t\u0007I\u0011\u00018\t\re\u0004\u0001\u0015!\u0003p\u0011\u0015Q\b\u0001\"\u0001|\u0011\u0015a\b\u0001\"\u0001|\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u00179q!!\u0004\u001f\u0011\u0003\tyA\u0002\u0004\u001e=!\u0005\u0011\u0011\u0003\u0005\u0007\u001f^!\t!a\u0005\t\u0013\u0005UqC1A\u0005\u0002\u0005]\u0001\u0002CA\u0012/\u0001\u0006I!!\u0007\t\u0013\u0005\u0015rC1A\u0005\u0002\u0005]\u0001\u0002CA\u0014/\u0001\u0006I!!\u0007\u0003/1Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014(BA\u0010!\u0003\u0019\u0019XM\u001d<fe*\t\u0011%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g-\u0001\u0005qe>\u001c'k\\8u!\ta3G\u0004\u0002.cA\u0011aFJ\u0007\u0002_)\u0011\u0001GI\u0001\u0007yI|w\u000e\u001e \n\u0005I2\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\u0014\u0002\tQLW.Z\u000b\u0002qA\u0011\u0011hQ\u0007\u0002u)\u00111\bP\u0001\u0006kRLGn\u001d\u0006\u0003{y\naaY8n[>t'BA\u0011@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011S$\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001\\8hO\u0016\u0014X#\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0005-\u000b\u0015!B:mMRR\u0017BA'K\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003R'R+\u0006C\u0001*\u0001\u001b\u0005q\u0002\"\u0002\u0016\u0007\u0001\u0004Y\u0003\"\u0002\u001c\u0007\u0001\u0004A\u0004\"\u0002$\u0007\u0001\u0004A\u0015\u0001\u00047bgR,\u0006\u000fZ1uK6\u001bX#\u0001-\u0011\u0005\u0015J\u0016B\u0001.'\u0005\u0011auN\\4\u0002!1\f7\u000f^+qI\u0006$X-T:`I\u0015\fHCA/a!\t)c,\u0003\u0002`M\t!QK\\5u\u0011\u001d\t\u0007\"!AA\u0002a\u000b1\u0001\u001f\u00132\u00035a\u0017m\u001d;Va\u0012\fG/Z'tA\u0005y1-Y2iK\u0012\u0014V-\u00193CsR,7/A\ndC\u000eDW\r\u001a*fC\u0012\u0014\u0015\u0010^3t?\u0012*\u0017\u000f\u0006\u0002^M\"9\u0011mCA\u0001\u0002\u0004A\u0016\u0001E2bG\",GMU3bI\nKH/Z:!\u0003A\u0019\u0017m\u00195fI^\u0013\u0018\u000e^3CsR,7/\u0001\u000bdC\u000eDW\rZ,sSR,')\u001f;fg~#S-\u001d\u000b\u0003;.Dq!\u0019\b\u0002\u0002\u0003\u0007\u0001,A\tdC\u000eDW\rZ,sSR,')\u001f;fg\u0002\nA\u0001]1uQV\tq\u000e\u0005\u0002qo6\t\u0011O\u0003\u0002sg\u0006!a-\u001b7f\u0015\t!X/A\u0002oS>T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yc\n!\u0001+\u0019;i\u0003\u0015\u0001\u0018\r\u001e5!\u0003%\u0011X-\u00193CsR,7\u000fF\u0001Y\u0003)9(/\u001b;f\u0005f$Xm]\u0001\rkB$\u0017\r^3WC2,Xm\u001d\u000b\u0004\u007f\u0006\u0015\u0001cA\u0013\u0002\u0002%\u0019\u00111\u0001\u0014\u0003\u000f\t{w\u000e\\3b]\"1\u0011q\u0001\u000bA\u0002a\u000b1A\\8x\u0003\u0019)8/\u00192mKR\tq0A\fMS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;peB\u0011!kF\n\u0003/\u0011\"\"!a\u0004\u0002#I+\u0015\tR0C3R+5k\u0018)S\u000b\u001aK\u0005,\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 U\fA\u0001\\1oO&\u0019A'!\b\u0002%I+\u0015\tR0C3R+5k\u0018)S\u000b\u001aK\u0005\fI\u0001\u0013/JKE+R0C3R+5k\u0018)S\u000b\u001aK\u0005,A\nX%&#Vi\u0018\"Z)\u0016\u001bv\f\u0015*F\r&C\u0006\u0005")
public class LinuxIoMetricsCollector {
    private final Time time;
    private final Logger logger;
    private long lastUpdateMs;
    private long cachedReadBytes;
    private long cachedWriteBytes;
    private final Path path;

    public static String WRITE_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX();
    }

    public static String READ_BYTES_PREFIX() {
        return LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX();
    }

    public Time time() {
        return this.time;
    }

    public Logger logger() {
        return this.logger;
    }

    public long lastUpdateMs() {
        return this.lastUpdateMs;
    }

    public void lastUpdateMs_$eq(long x$1) {
        this.lastUpdateMs = x$1;
    }

    public long cachedReadBytes() {
        return this.cachedReadBytes;
    }

    public void cachedReadBytes_$eq(long x$1) {
        this.cachedReadBytes = x$1;
    }

    public long cachedWriteBytes() {
        return this.cachedWriteBytes;
    }

    public void cachedWriteBytes_$eq(long x$1) {
        this.cachedWriteBytes = x$1;
    }

    public Path path() {
        return this.path;
    }

    public synchronized long readBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedReadBytes();
    }

    public synchronized long writeBytes() {
        long curMs = this.time().milliseconds();
        if (curMs != this.lastUpdateMs()) {
            this.updateValues(curMs);
        }
        return this.cachedWriteBytes();
    }

    public synchronized boolean updateValues(long now) {
        try {
            this.cachedReadBytes_$eq(-1L);
            this.cachedWriteBytes_$eq(-1L);
            ((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.path())).asScala()).foreach((Function1 & java.io.Serializable & Serializable)line -> {
                LinuxIoMetricsCollector.$anonfun$updateValues$1(this, line);
                return BoxedUnit.UNIT;
            });
            this.lastUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update IO metrics", t);
            return false;
        }
    }

    public boolean usable() {
        if (this.path().toFile().exists()) {
            return this.updateValues(this.time().milliseconds());
        }
        this.logger().debug(new StringBuilder(56).append("disabling IO metrics collection because ").append(this.path()).append(" does not exist.").toString());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$updateValues$1(LinuxIoMetricsCollector $this, String line) {
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX())) {
            String string = LinuxIoMetricsCollector$.MODULE$.READ_BYTES_PREFIX();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string2 = line.substring(new StringOps(string).size());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            $this.cachedReadBytes_$eq(new StringOps(string2).toLong());
            return;
        }
        if (line.startsWith(LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX())) {
            void augmentString_x;
            void augmentString_x2;
            String string = LinuxIoMetricsCollector$.MODULE$.WRITE_BYTES_PREFIX();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String string3 = line.substring(new StringOps((String)augmentString_x2).size());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            $this.cachedWriteBytes_$eq(new StringOps((String)augmentString_x).toLong());
            return;
        }
    }

    public LinuxIoMetricsCollector(String procRoot, Time time, Logger logger) {
        this.time = time;
        this.logger = logger;
        this.lastUpdateMs = -1L;
        this.cachedReadBytes = 0L;
        this.cachedWriteBytes = 0L;
        this.path = Paths.get(procRoot, "self", "io");
    }
}

