/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.common.config.ConfigException;
import scala.Predef$;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q;Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQ\u0001H\u0001\u0005\u0002uAqAH\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004/\u0003\u0001\u0006I\u0001\t\u0004\u0005)5\u0001q\u0006\u0003\u0005\u000f\u000b\t\u0005\t\u0015!\u00034\u0011\u0015aR\u0001\"\u00017\u0011\u0015IT\u0001\"\u0011;\u0011\u00151U\u0001\"\u0011H\u0011\u0015\u0001V\u0001\"\u0011R\u0011\u0015)V\u0001\"\u0003W\u0003E!\u0015P\\1nS\u000e$\u0006N]3bIB{w\u000e\u001c\u0006\u0003\u001d=\taa]3sm\u0016\u0014(\"\u0001\t\u0002\u000b-\fgm[1\u0004\u0001A\u00111#A\u0007\u0002\u001b\t\tB)\u001f8b[&\u001cG\u000b\u001b:fC\u0012\u0004vn\u001c7\u0014\u0005\u00051\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002%\u0005)\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001cX#\u0001\u0011\u0011\u0007\u0005\"c%D\u0001#\u0015\t\u0019\u0003$\u0001\u0006d_2dWm\u0019;j_:L!!\n\u0012\u0003\u0007M+G\u000f\u0005\u0002(Y5\t\u0001F\u0003\u0002*U\u0005!A.\u00198h\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0015\u0003\rM#(/\u001b8h\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u00043cA\u0003\u0017aA\u00111#M\u0005\u0003e5\u0011AC\u0011:pW\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0007CA\n5\u0013\t)TBA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014HCA\u001c9!\t\u0019R\u0001C\u0003\u000f\u000f\u0001\u00071'A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0003m\u00022!\t\u0013=!\tiDI\u0004\u0002?\u0005B\u0011q\bG\u0007\u0002\u0001*\u0011\u0011)E\u0001\u0007yI|w\u000e\u001e \n\u0005\rC\u0012A\u0002)sK\u0012,g-\u0003\u0002.\u000b*\u00111\tG\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$\"\u0001S&\u0011\u0005]I\u0015B\u0001&\u0019\u0005\u0011)f.\u001b;\t\u000b1K\u0001\u0019A'\u0002\u00139,woQ8oM&<\u0007CA\nO\u0013\tyUBA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$2\u0001\u0013*U\u0011\u0015\u0019&\u00021\u0001N\u0003%yG\u000eZ\"p]\u001aLw\rC\u0003M\u0015\u0001\u0007Q*\u0001\u0007dkJ\u0014XM\u001c;WC2,X\r\u0006\u0002X5B\u0011q\u0003W\u0005\u00033b\u00111!\u00138u\u0011\u0015Y6\u00021\u0001=\u0003\u0011q\u0017-\\3")
public class DynamicThreadPool
implements BrokerReconfigurable {
    private final KafkaServer server;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        newConfig.values().forEach((k, v) -> {
            if (DynamicThreadPool$.MODULE$.ReconfigurableConfigs().contains(k)) {
                int oldValue;
                int newValue = BoxesRunTime.unboxToInt((Object)v);
                if (newValue != (oldValue = this.currentValue((String)k))) {
                    String errorMsg = new StringBuilder(51).append("Dynamic thread count update validation failed for ").append((String)k).append("=").append(v).toString();
                    if (newValue <= 0) {
                        throw new ConfigException(new StringBuilder(28).append(errorMsg).append(", value should be at least 1").toString());
                    }
                    if (newValue < oldValue / 2) {
                        throw new ConfigException(new StringBuilder(50).append(errorMsg).append(", value should be at least half the current value ").append(oldValue).toString());
                    }
                    if (newValue > oldValue * 2) {
                        throw new ConfigException(new StringBuilder(60).append(errorMsg).append(", value should not be greater than double the current value ").append(oldValue).toString());
                    }
                    return;
                }
                return;
            }
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer n = newConfig.numIoThreads();
        Integer n2 = oldConfig.numIoThreads();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.server.dataPlaneRequestHandlerPool().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numIoThreads()));
        }
        Integer n3 = newConfig.numNetworkThreads();
        Integer n4 = oldConfig.numNetworkThreads();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.server.socketServer().resizeThreadPool(Predef$.MODULE$.Integer2int(oldConfig.numNetworkThreads()), Predef$.MODULE$.Integer2int(newConfig.numNetworkThreads()));
        }
        Integer n5 = newConfig.numReplicaFetchers();
        Integer n6 = oldConfig.numReplicaFetchers();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.server.replicaManager().replicaFetcherManager().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numReplicaFetchers()));
        }
        Integer n7 = newConfig.numRecoveryThreadsPerDataDir();
        Integer n8 = oldConfig.numRecoveryThreadsPerDataDir();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            this.server.getLogManager().resizeRecoveryThreadPool(Predef$.MODULE$.Integer2int(newConfig.numRecoveryThreadsPerDataDir()));
        }
        Integer n9 = newConfig.backgroundThreads();
        Integer n10 = oldConfig.backgroundThreads();
        if (n9 == null ? n10 != null : !((Object)n9).equals(n10)) {
            this.server.kafkaScheduler().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.backgroundThreads()));
            return;
        }
    }

    private int currentValue(String name) {
        String string = KafkaConfig$.MODULE$.NumIoThreadsProp();
        if (!(string != null ? !string.equals(name) : name != null)) {
            return Predef$.MODULE$.Integer2int(this.server.config().numIoThreads());
        }
        String string2 = KafkaConfig$.MODULE$.NumNetworkThreadsProp();
        if (!(string2 != null ? !string2.equals(name) : name != null)) {
            return Predef$.MODULE$.Integer2int(this.server.config().numNetworkThreads());
        }
        String string3 = KafkaConfig$.MODULE$.NumReplicaFetchersProp();
        if (!(string3 != null ? !string3.equals(name) : name != null)) {
            return Predef$.MODULE$.Integer2int(this.server.config().numReplicaFetchers());
        }
        String string4 = KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp();
        if (!(string4 != null ? !string4.equals(name) : name != null)) {
            return Predef$.MODULE$.Integer2int(this.server.config().numRecoveryThreadsPerDataDir());
        }
        String string5 = KafkaConfig$.MODULE$.BackgroundThreadsProp();
        if (!(string5 != null ? !string5.equals(name) : name != null)) {
            return Predef$.MODULE$.Integer2int(this.server.config().backgroundThreads());
        }
        throw new IllegalStateException(new StringBuilder(18).append("Unexpected config ").append(name).toString());
    }

    public DynamicThreadPool(KafkaServer server) {
        this.server = server;
    }
}

