/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.LeaderElectionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LeaderElectionCommand$
implements Logging {
    public static LeaderElectionCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = (ElectionType)commandOptions.options().valueOf(commandOptions.electionType());
        v0 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.pathToJsonFile()));
        if (v0 == null) {
            throw null;
        }
        map_this = v0;
        jsonFileTopicPartitions = map_this.isEmpty() != false ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$run$1((String)map_this.get()));
        var18_7 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.partition()));
        var7_8 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.topic()));
        var8_9 = var18_7;
        if (!(var7_8 instanceof Some)) ** GOTO lbl-1000
        topic = (String)((Some)var7_8).value();
        if (var8_9 instanceof Some) {
            partition = (Integer)((Some)var8_9).value();
            v1 = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition))})));
        } else lbl-1000:
        // 2 sources

        {
            v1 = singleTopicPartition = None$.MODULE$;
        }
        if (jsonFileTopicPartitions == null) {
            throw null;
        }
        topicPartitions = jsonFileTopicPartitions.isEmpty() != false ? LeaderElectionCommand$.$anonfun$run$2((Option)singleTopicPartition) : jsonFileTopicPartitions;
        v2 = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.adminClientConfig()));
        if (v2 == null) {
            throw null;
        }
        map_this = v2;
        v3 /* !! */  = map_this.isEmpty() != false ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$run$3((String)map_this.get()));
        if (v3 /* !! */  == null) {
            throw null;
        }
        getOrElse_this = v3 /* !! */ ;
        props = (Properties)(getOrElse_this.isEmpty() != false ? LeaderElectionCommand$.$anonfun$run$4() : getOrElse_this.get());
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("default.api.timeout.ms", Long.toString(timeout.toMillis()));
        props.setProperty("request.timeout.ms", Long.toString(timeout.toMillis() / 2L));
        adminClient = Admin.create((Properties)props);
        try {
            this.electLeaders(adminClient, electionType, (Option<scala.collection.immutable.Set<TopicPartition>>)topicPartitions);
        }
        finally {
            adminClient.close();
        }
    }

    private scala.collection.immutable.Set<TopicPartition> parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Option<JsonValue> option2 = ((JsonValue)((Some)option).value()).asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                Buffer partitions = ((JsonValue)((Some)option2).value()).asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.asJsonObject()).map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                    int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                    return new TopicPartition(topic, partition);
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringBuilder(53).append("Replica election data contains duplicate partitions: ").append(duplicatePartitions.mkString(",")).toString());
                }
                return partitions.toSet();
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Replica election data is missing \"partitions\" field");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Replica election data is empty");
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private void electLeaders(Admin client, ElectionType electionType, Option<scala.collection.immutable.Set<TopicPartition>> topicPartitions) {
        scala.collection.mutable.Map map;
        try {
            void orNull_ev;
            if (topicPartitions == null) {
                throw null;
            }
            Object object = topicPartitions.isEmpty() ? None$.MODULE$ : new Some((Object)LeaderElectionCommand$.$anonfun$electLeaders$1((scala.collection.immutable.Set)topicPartitions.get()));
            Predef.$less$colon$less $less$colon$less2 = Predef$.MODULE$.$conforms();
            if (object == null) {
                throw null;
            }
            None$ orNull_this = object;
            java.util.Set partitions = (java.util.Set)(orNull_this.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : orNull_this.get());
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(this.msgWithLogIdent(LeaderElectionCommand$.$anonfun$electLeaders$2(electionType, partitions)));
            }
            map = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw e;
        }
        catch (Throwable e) {
            Predef$.MODULE$.println((Object)"Error while making request");
            throw e;
        }
        scala.collection.mutable.Map electionResults = map;
        scala.collection.mutable.Set succeeded = Set$.MODULE$.empty();
        scala.collection.mutable.Set noop = Set$.MODULE$.empty();
        scala.collection.mutable.Map failed = Map$.MODULE$.empty();
        electionResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LeaderElectionCommand$.$anonfun$electLeaders$3(noop, failed, succeeded, x0$1);
            return BoxedUnit.UNIT;
        });
        if (succeeded.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(57).append("Successfully completed leader election (").append(electionType).append(") for partitions ").append(partitions).toString());
        }
        if (noop.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringBuilder(45).append("Valid replica already elected for partitions ").append(partitions).toString());
        }
        if (failed.nonEmpty()) {
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringBuilder(32).append(failed.size()).append(" replica(s) could not be elected").toString());
            failed.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                LeaderElectionCommand$.$anonfun$electLeaders$4(electionType, rootException, x0$2);
                return BoxedUnit.UNIT;
            });
            throw rootException;
        }
    }

    private void validate(LeaderElectionCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (!commandOptions.options().has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(missingOptions.mkString(", ")).toString());
        }
        .colon.colon mutuallyExclusiveOptions = new .colon.colon(commandOptions.topic(), (List)new .colon.colon((Object)commandOptions.allTopicPartitions(), (List)new .colon.colon(commandOptions.pathToJsonFile(), (List)Nil$.MODULE$)));
        switch (mutuallyExclusiveOptions.count(arg_0 -> LeaderElectionCommand$.$anonfun$validate$1$adapted(commandOptions.options(), arg_0))) {
            case 1: {
                break;
            }
            default: {
                throw new AdminCommandFailedException(new StringBuilder(55).append("One and only one of the following options is required: ").append(((TraversableOnce)mutuallyExclusiveOptions.map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5.options().get(0), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
            }
        }
        boolean bl = commandOptions.options().has(commandOptions.partition());
        boolean bl2 = commandOptions.options().has(commandOptions.topic());
        if (bl2 && !bl) {
            throw new AdminCommandFailedException(new StringBuilder(28).append("Missing required option(s): ").append(commandOptions.partition().options().get(0)).toString());
        }
        if (!bl2 && bl) {
            throw new AdminCommandFailedException(new StringBuilder(35).append("Option ").append(commandOptions.partition().options().get(0)).append(" is only allowed if ").append(commandOptions.topic().options().get(0)).append(" is used").toString());
        }
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$run$1(String path) {
        return MODULE$.parseReplicaElectionData(Utils.readFileAsString((String)path));
    }

    public static final /* synthetic */ Option $anonfun$run$2(Option singleTopicPartition$1) {
        return singleTopicPartition$1;
    }

    public static final /* synthetic */ Properties $anonfun$run$3(String config) {
        return Utils.loadProps((String)config);
    }

    public static final /* synthetic */ Properties $anonfun$run$4() {
        return new Properties();
    }

    public static final /* synthetic */ java.util.Set $anonfun$electLeaders$1(scala.collection.immutable.Set x$2) {
        return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)x$2).asJava();
    }

    public static final /* synthetic */ String $anonfun$electLeaders$2(ElectionType electionType$1, java.util.Set partitions$1) {
        return new StringBuilder(36).append("Calling AdminClient.electLeaders(").append(electionType$1).append(", ").append(partitions$1).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$electLeaders$3(scala.collection.mutable.Set noop$1, scala.collection.mutable.Map failed$1, scala.collection.mutable.Set succeeded$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Optional error = (Optional)x0$1._2();
            if (error.isPresent()) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                if ((Throwable)error.get() instanceof ElectionNotNeededException) {
                    noop$1.$plus$eq((Object)topicPartition);
                    return;
                }
                Object t = error.get();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                failed$1.$plus$eq(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y));
                return;
            }
            succeeded$1.$plus$eq((Object)topicPartition);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$electLeaders$4(ElectionType electionType$1, AdminCommandFailedException rootException$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$2._1();
            Throwable exception = (Throwable)x0$2._2();
            Predef$.MODULE$.println((Object)new StringBuilder(53).append("Error completing leader election (").append(electionType$1).append(") for partition: ").append(topicPartition).append(": ").append(exception).toString());
            rootException$1.addSuppressed(exception);
            return;
        }
        throw new MatchError(null);
    }

    private LeaderElectionCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$validate$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

