/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000e\u001c\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"B#\u0001\t\u00031\u0005bB'\u0001\u0005\u0004%\tA\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B(\t\u000bM\u0003A\u0011\u0001+\t\u000b5\u0004A\u0011\u00018\t\u000b=\u0004A\u0011\u00019\t\u000bM\u0004A\u0011\u0001;\t\u000fY\u0004\u0011\u0013!C\u0001o\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\ti\u0003\u0001C\u0005\u0003_Aq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003#\u0002A\u0011BA*\u0011\u001d\t9\u0006\u0001C\u0005\u00033Ba!a\u0018\u0001\t\u0013q'\u0001\u0006+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'O\u0003\u0002\u001d;\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003y\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001e\u0003\u0015)H/\u001b7t\u0013\ta\u0013FA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\ty#'D\u00011\u0015\t\tT$\u0001\u0004tKJ4XM]\u0005\u0003gA\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005Y:T\"A\u000e\n\u0005aZ\"!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0006\u0019\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oKB\u0011agO\u0005\u0003ym\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016\fQ\u0003]1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0005\u00027\u007f%\u0011\u0001i\u0007\u0002\u0016!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0003\u0019\u0019G.[3oiB\u0011agQ\u0005\u0003\tn\u0011a\u0002R3mKRLwN\\\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0007\u000f\"K%j\u0013'\u0011\u0005Y\u0002\u0001\"B\u0017\u0007\u0001\u0004q\u0003\"\u0002\u001b\u0007\u0001\u0004)\u0004\"B\u001d\u0007\u0001\u0004Q\u0004\"B\u001f\u0007\u0001\u0004q\u0004\"B!\u0007\u0001\u0004\u0011\u0015\u0001F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G-F\u0001P!\t\u0011\u0003+\u0003\u0002RG\t9!i\\8mK\u0006t\u0017!F5t\t\u0016dW\r^3U_BL7-\u00128bE2,G\rI\u0001\u0005S:LG\u000fF\u0002V1.\u0004\"A\t,\n\u0005]\u001b#\u0001B+oSRDQ!W\u0005A\u0002i\u000b\u0001$\u001b8ji&\fG\u000eV8qS\u000e\u001cHk\u001c\"f\t\u0016dW\r^3e!\rYf\fY\u0007\u00029*\u0011QlI\u0001\u000bG>dG.Z2uS>t\u0017BA0]\u0005\r\u0019V\r\u001e\t\u0003C\"t!A\u00194\u0011\u0005\r\u001cS\"\u00013\u000b\u0005\u0015|\u0012A\u0002\u001fs_>$h(\u0003\u0002hG\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t97\u0005C\u0003m\u0013\u0001\u0007!,\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\\\u0001\u0011iJLHk\u001c9jG\u0012+G.\u001a;j_:$\u0012!V\u0001\u0019K:\fX/Z;f)>\u0004\u0018nY:G_J$U\r\\3uS>tGCA+r\u0011\u0015\u00118\u00021\u0001[\u0003\u0019!x\u000e]5dg\u00069\"/Z:v[\u0016$U\r\\3uS>tgi\u001c:U_BL7m\u001d\u000b\u0003+VDqA\u001d\u0007\u0011\u0002\u0003\u0007!,A\u0011sKN,X.\u001a#fY\u0016$\u0018n\u001c8G_J$v\u000e]5dg\u0012\"WMZ1vYR$\u0013'F\u0001yU\tQ\u0016pK\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\nk:\u001c\u0007.Z2lK\u0012T!a`\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0004q\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M1\u0017-\u001b7SKBd\u0017nY1EK2,G/[8o)\r)\u0016\u0011\u0002\u0005\b\u0003\u0017q\u0001\u0019AA\u0007\u0003!\u0011X\r\u001d7jG\u0006\u001c\b\u0003B._\u0003\u001f\u00012ANA\t\u0013\r\t\u0019b\u0007\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-Y\u0001\u001f[\u0006\u00148\u000eV8qS\u000eLe.\u001a7jO&\u0014G.\u001a$pe\u0012+G.\u001a;j_:$R!VA\r\u00037AQA]\bA\u0002iC\u0001\"!\b\u0010\t\u0003\u0007\u0011qD\u0001\u0007e\u0016\f7o\u001c8\u0011\t\t\n\t\u0003Y\u0005\u0004\u0003G\u0019#\u0001\u0003\u001fcs:\fW.\u001a \u00029%\u001cHk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019q*!\u000b\t\r\u0005-\u0002\u00031\u0001a\u0003\u0015!x\u000e]5d\u0003eI7\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\u0007=\u000b\t\u0004\u0003\u0004\u0002,E\u0001\r\u0001Y\u0001\u001bSN$v\u000e]5d#V,W/\u001a3Va\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004\u001f\u0006]\u0002BBA\u0016%\u0001\u0007\u0001-A\fd_6\u0004H.\u001a;f%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019Q+!\u0010\t\u000f\u0005-1\u00031\u0001\u0002\u000e\u0005Q\u0012n\u001d+pa&\u001cW\t\\5hS\ndWMR8s\t\u0016dW\r^5p]R\u0019q*a\u0011\t\r\u0005-B\u00031\u0001a\u0003\t\u0012X\r\u001e:z\t\u0016dW\r^5p]\u001a{'/\u00138fY&<\u0017N\u00197f%\u0016\u0004H.[2bgR\u0019Q+!\u0013\t\u000bI,\u0002\u0019\u0001.\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\u0007U\u000by\u0005\u0003\u0004\u0002,Y\u0001\r\u0001Y\u0001\u0010_:$v\u000e]5d\t\u0016dW\r^5p]R\u0019Q+!\u0016\t\u000bI<\u0002\u0019\u0001.\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0007U\u000bY\u0006\u0003\u0004\u0002^a\u0001\rAW\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0017a\u0004:fgVlW\rR3mKRLwN\\:")
public class TopicDeletionManager
implements Logging {
    private final ControllerContext controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    private final DeletionClient client;
    private final boolean isDeleteTopicEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Initializing manager with initial deletions: ").append(initialTopicsToBeDeleted).append(", ").append("initial ineligible deletions: ").append(initialTopicsIneligibleForDeletion).toString());
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.controllerContext.topicsToBeDeleted()));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
        this.client.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext.epochZkVersion());
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
            return;
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
            return;
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            Set topicsToResumeDeletion = (Set)topics.$amp(this.controllerContext.topicsToBeDeleted());
            if (topicsToResumeDeletion.nonEmpty()) {
                this.controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
                this.resumeDeletions();
                return;
            }
            return;
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        if (this.isDeleteTopicEnabled()) {
            Set replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
            if (replicasThatFailedToDelete.nonEmpty()) {
                Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic(), Set$.MODULE$.canBuildFrom());
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
                this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$);
                this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "replica deletion failure");
                this.resumeDeletions();
                return;
            }
            return;
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.controllerContext.topicsToBeDeleted().$amp(topics);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).append(" due to ").append(reason.apply()).toString());
                return;
            }
            return;
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.topicsIneligibleForDeletion().contains((Object)topic);
        }
        return true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$);
        }
        return false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        if (this.isDeleteTopicEnabled()) {
            return this.controllerContext.isTopicQueuedUpForDeletion(topic);
        }
        return false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$);
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void retryDeletionForIneligibleReplicas(Set<String> topics) {
        Set failedReplicas = (Set)topics.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> $this.controllerContext.replicasInState((String)x$2, ReplicaDeletionIneligible$.MODULE$), Set$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Retrying deletion of topics ").append(topics.mkString(",")).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$);
    }

    private void completeDeleteTopic(String topic) {
        this.client.mutePartitionModifications(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$);
        this.controllerContext.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.client.deleteTopic(topic, this.controllerContext.epochZkVersion());
        this.controllerContext.removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        Set unseenTopicsForDeletion = topics.diff(this.controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom());
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.client.sendMetadataUpdate((Set<TopicPartition>)((Set)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic), Set$.MODULE$.canBuildFrom())));
        this.onPartitionDeletion(topics);
    }

    private void onPartitionDeletion(Set<String> topicsToBeDeleted) {
        ListBuffer allDeadReplicas = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer allReplicasForDeletionRetry = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Set allTopicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        topicsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = $this.controllerContext.replicasForTopic((String)topic).partition((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.controllerContext.isReplicaOnline(r.replica(), r.topicPartition(), this.controllerContext.isReplicaOnline$default$3())));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Set aliveReplicas = (Set)tuple2._1();
            Set deadReplicas = (Set)tuple2._2();
            void aliveReplicas2 = var6_6;
            void deadReplicas2 = var7_7;
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controllerContext.replicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = aliveReplicas2.diff(successfullyDeletedReplicas);
            allDeadReplicas.$plus$plus$eq((TraversableOnce)deadReplicas2);
            allReplicasForDeletionRetry.$plus$plus$eq((TraversableOnce)replicasForDeletionRetry);
            if (deadReplicas2.nonEmpty()) {
                this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> TopicDeletionManager.$anonfun$onPartitionDeletion$3((Set)deadReplicas2, topic)));
                return allTopicsIneligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allDeadReplicas, ReplicaDeletionIneligible$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, OfflineReplica$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$);
        if (allTopicsIneligibleForDeletion.nonEmpty()) {
            this.markTopicIneligibleForDeletion((Set<String>)allTopicsIneligibleForDeletion, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "offline replicas");
            return;
        }
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.controllerContext.topicsToBeDeleted());
        scala.collection.mutable.Set topicsEligibleForRetry = scala.collection.mutable.Set$.MODULE$.empty();
        scala.collection.mutable.Set topicsEligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            if ($this.controllerContext.areAllReplicasInState((String)topic, ReplicaDeletionSuccessful$.MODULE$)) {
                this.completeDeleteTopic((String)topic);
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append((String)topic).append(" successfully completed").toString());
            } else if (!$this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionStarted$.MODULE$) && $this.controllerContext.isAnyReplicaInState((String)topic, ReplicaDeletionIneligible$.MODULE$)) {
                topicsEligibleForRetry.$plus$eq(topic);
            }
            if (this.isTopicEligibleForDeletion((String)topic)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append((String)topic).append(" (re)started").toString());
                return topicsEligibleForDeletion.$plus$eq(topic);
            }
            return BoxedUnit.UNIT;
        });
        if (topicsEligibleForRetry.nonEmpty()) {
            this.retryDeletionForIneligibleReplicas((Set<String>)topicsEligibleForRetry);
        }
        if (topicsEligibleForDeletion.nonEmpty()) {
            this.onTopicDeletion((Set<String>)topicsEligibleForDeletion);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$onPartitionDeletion$3(Set deadReplicas$1, String topic$1) {
        return new StringBuilder(33).append("Dead Replicas (").append(deadReplicas$1.mkString(",")).append(") found for topic ").append(topic$1).toString();
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client) {
        this.controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.client = client;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[Topic Deletion Manager ").append(config.brokerId()).append("] ").toString());
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

