/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u0001.\u0011\u0019A\u0004\u0001)A\u0005]!9\u0011\b\u0001b\u0001\n\u0003Q\u0004BB!\u0001A\u0003%1\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r9\u0003\u0001\u0015!\u0003E\u0011\u001dy\u0005A1A\u0005\u0002\rCa\u0001\u0015\u0001!\u0002\u0013!\u0005bB)\u0001\u0005\u0004%\ta\u0011\u0005\u0007%\u0002\u0001\u000b\u0011\u0002#\t\u000fM\u0003!\u0019!C\u0001)\"11\f\u0001Q\u0001\nUCq\u0001\u0018\u0001C\u0002\u0013\u0005Q\f\u0003\u0004j\u0001\u0001\u0006IA\u0018\u0005\nU\u0002\u0001\r\u00111A\u0005\u0002-D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013a\u0004\u0001\u0019!A!B\u0013a\u0007\"B=\u0001\t\u0003Q\bBBA\u0005\u0001\u0011\u0005!\u0010\u0003\u0004\u0002\u0014\u0001!\tA\u001f\u0005\u0007\u0003;\u0001A\u0011\u0001>\t\r\u0005\u0005\u0002\u0001\"\u0001{\u0011\u001d\t)\u0003\u0001C\u0005\u0003O\u00111\u0003R;na2{wmU3h[\u0016tGo\u001d+fgRT!!\b\u0010\u0002\u000bQ|w\u000e\\:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\u000f\u0002\rQl\u0007\u000fR5s+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\tIwNC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$\u0001\u0002$jY\u0016\fq\u0001^7q\t&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003-\u0019XmZ7f]Rt\u0015-\\3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!A\u0010\u001a\u0002\t1\fgnZ\u0005\u0003\u0001v\u0012aa\u0015;sS:<\u0017\u0001D:fO6,g\u000e\u001e(b[\u0016\u0004\u0013a\u00037pO\u001aKG.\u001a)bi\",\u0012\u0001\u0012\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d#S\"\u0001%\u000b\u0005%\u0003\u0013A\u0002\u001fs_>$h(\u0003\u0002LI\u00051\u0001K]3eK\u001aL!\u0001Q'\u000b\u0005-#\u0013\u0001\u00047pO\u001aKG.\u001a)bi\"\u0004\u0013!D5oI\u0016Dh)\u001b7f!\u0006$\b.\u0001\bj]\u0012,\u0007PR5mKB\u000bG\u000f\u001b\u0011\u0002#QLW.Z%oI\u0016Dh)\u001b7f!\u0006$\b.\u0001\nuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031z\tQ!\u001e;jYNL!AW,\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\nqAY1uG\",7/F\u0001_!\ryFMZ\u0007\u0002A*\u0011\u0011MY\u0001\b[V$\u0018M\u00197f\u0015\t\u0019G%\u0001\u0006d_2dWm\u0019;j_:L!!\u001a1\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003W\u001dL!\u0001\u001b\u000f\u0003\u0013\t\u000bGo\u00195J]\u001a|\u0017\u0001\u00032bi\u000eDWm\u001d\u0011\u0002\u00071|w-F\u0001m!\tiw.D\u0001o\u0015\tQg$\u0003\u0002q]\n\u0019Aj\\4\u0002\u000f1|wm\u0018\u0013fcR\u00111O\u001e\t\u0003GQL!!\u001e\u0013\u0003\tUs\u0017\u000e\u001e\u0005\boN\t\t\u00111\u0001m\u0003\rAH%M\u0001\u0005Y><\u0007%A\u0003tKR,\u0006\u000fF\u0001tQ\t)B\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!\u00026v]&$(BAA\u0002\u0003\ry'oZ\u0005\u0004\u0003\u000fq(A\u0002\"fM>\u0014X-\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1\u0012Q\u0002\t\u0004{\u0006=\u0011bAA\t}\n)\u0011I\u001a;fe\u0006\u0001B/Z:u!JLg\u000e\u001e#bi\u0006dun\u001a\u0015\u0004/\u0005]\u0001cA?\u0002\u001a%\u0019\u00111\u0004@\u0003\tQ+7\u000f^\u0001\u0018i\u0016\u001cH\u000fR;na&sG-\u001a=NSNl\u0017\r^2iKND3\u0001GA\f\u0003]!Xm\u001d;Ek6\u0004H+[7f\u0013:$W\r_#se>\u00148\u000fK\u0002\u001a\u0003/\t!C];o\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugR\u0019A)!\u000b\t\u000f\u0005-\"\u00041\u0001\u0002.\u0005!\u0011M]4t!\u0011\u0019\u0013q\u0006#\n\u0007\u0005EBEA\u0003BeJ\f\u0017\u0010")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringBuilder(5).append(this.logDir()).append("/").append(this.segmentName()).append(".log").toString();
    private final String indexFilePath = new StringBuilder(7).append(this.logDir()).append("/").append(this.segmentName()).append(".index").toString();
    private final String timeIndexFilePath = new StringBuilder(11).append(this.logDir()).append("/").append(this.segmentName()).append(".timeindex").toString();
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() {
        void intWrapper_x;
        void intWrapper_x2;
        void intWrapper_x3;
        void intWrapper_x4;
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        this.log_$eq(Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10));
        long now = System.currentTimeMillis();
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x4, 10).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$1(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        int n = 10;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x3, 30).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$2(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        int n2 = 30;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x2, 50).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$3(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        int n3 = 50;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, 60).map((Function1 & Serializable & scala.Serializable)i -> DumpLogSegmentsTest.$anonfun$setUp$4(now, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1 & Serializable & scala.Serializable)batchInfo -> {
            Log qual$1 = this.log();
            MemoryRecords x$11 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            int x$12 = 0;
            AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
            ApiVersion x$14 = qual$1.appendAsLeader$default$4();
            return qual$1.appendAsLeader(x$11, x$12, x$13, x$14);
        });
        this.log().flush();
    }

    @After
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DumpLogSegments$.MODULE$.main(args));
        return outContent.toString();
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$1(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 2), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$2(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 3), new StringBuilder(12).append("message key ").append(i).toString().getBytes(), null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$3(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 5), null, new StringBuilder(14).append("message value ").append(i).toString().getBytes());
    }

    public static final /* synthetic */ SimpleRecord $anonfun$setUp$4(long now$1, int i) {
        return new SimpleRecord(now$1 + (long)(i * 7), null);
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$2(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, int recordIndex) {
        if (i$1.elem == index$1) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$1(IntRef i$1, int index$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BatchInfo batch = (BatchInfo)x0$1._1();
            if (i$1.elem == index$1) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
            ++i$1.elem;
            Range range = batch.records().indices();
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    DumpLogSegmentsTest.$anonfun$testPrintDataLog$2(i$1, index$1, nonLocalReturnKey1$1, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            return;
        }
        throw new MatchError(null);
    }

    private final boolean isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$1(i, index, object, x0$1);
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail(new StringBuilder(19).append("No match for index ").append(index).toString(), new Position("DumpLogSegmentsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ int $anonfun$testPrintDataLog$3(BatchInfo x$1) {
        return x$1.records().size();
    }

    public static final /* synthetic */ void $anonfun$testPrintDataLog$4(DumpLogSegmentsTest $this, String[] lines$1, int totalRecords$1, IntRef offset$1, ObjectRef batch$1, Iterator batchIterator$1, boolean checkKeysAndValues$1, int index) {
        String line = lines$1[lines$1.length - totalRecords$1 - $this.batches().size() + index];
        if ($this.isBatch$1(index)) {
            Assert.assertTrue((String)new StringBuilder(40).append("Not a valid batch-level message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(25).append("baseOffset: ").append(offset$1.elem).append(" lastOffset: ").toString()));
            batch$1.elem = (BatchInfo)batchIterator$1.next();
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("Not a valid message record: ").append(line).toString(), (boolean)line.startsWith(new StringBuilder(9).append(DumpLogSegments$.MODULE$.RecordIndent()).append(" offset: ").append(offset$1.elem).toString()));
        if (checkKeysAndValues$1) {
            String suffix = "headerKeys: []";
            if (((BatchInfo)batch$1.elem).hasKeys()) {
                suffix = new StringBuilder(18).append(suffix).append(" key: message key ").append(offset$1.elem).toString();
            }
            if (((BatchInfo)batch$1.elem).hasValues()) {
                suffix = new StringBuilder(24).append(suffix).append(" payload: message value ").append(offset$1.elem).toString();
            }
            Assert.assertTrue((String)new StringBuilder(37).append("Message record missing key or value: ").append(line).toString(), (boolean)line.endsWith(suffix));
        }
        ++offset$1.elem;
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        void intWrapper_x;
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringBuilder(18).append("Data not printed: ").append(output).toString(), (lines.length > 2 ? 1 : 0) != 0);
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DumpLogSegmentsTest.$anonfun$testPrintDataLog$3(x$1)), ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, totalRecords + this.batches().size());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                DumpLogSegmentsTest.$anonfun$testPrintDataLog$4(this, lines, totalRecords, offset, batch, batchIterator, checkKeysAndValues, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringBuilder(35).append("Data should not have been printed: ").append(output).toString(), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

