/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentClusterIdException;
import kafka.server.BrokerMetadata;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001A\u0002\u0013\u0005Q\u0006C\u00042\u0001\u0001\u0007I\u0011\u0001\u001a\t\rm\u0002\u0001\u0015)\u0003/\u0011\u001da\u0004\u00011A\u0005\u00025Bq!\u0010\u0001A\u0002\u0013\u0005a\b\u0003\u0004A\u0001\u0001\u0006KA\f\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001.\u0011\u001d\u0011\u0005\u00011A\u0005\u0002\rCa!\u0012\u0001!B\u0013q\u0003b\u0002$\u0001\u0001\u0004%\ta\u0012\u0005\b#\u0002\u0001\r\u0011\"\u0001S\u0011\u0019!\u0006\u0001)Q\u0005\u0011\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB0\u0001A\u0003%q\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0003l\u0001\u0011\u0005\u0013\rC\u0003q\u0001\u0011\u0005\u0011\rC\u0003v\u0001\u0011\u0005\u0011\rC\u0003x\u0001\u0011\u0005\u0011\rC\u0003z\u0001\u0011\u0005\u0011\rC\u0003|\u0001\u0011\u0005\u0011\rC\u0003~\u0001\u0011\u0005\u0011\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\u0007\u007f\u0002!\t!a\u000b\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\tY2+\u001a:wKJ<UM\\3sCR,7\t\\;ti\u0016\u0014\u0018\n\u001a+fgRT!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0010\u0002\u0005i\\\u0017BA\u0014%\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011\u0001H\u0001\bG>tg-[42+\u0005q\u0003CA\u00160\u0013\t\u0001DDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aC2p]\u001aLw-M0%KF$\"aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\tUs\u0017\u000e\u001e\u0005\bu\r\t\t\u00111\u0001/\u0003\rAH%M\u0001\tG>tg-[42A\u000591m\u001c8gS\u001e\u0014\u0014aC2p]\u001aLwMM0%KF$\"aM \t\u000fi2\u0011\u0011!a\u0001]\u0005A1m\u001c8gS\u001e\u0014\u0004%A\u0004d_:4\u0017nZ\u001a\u0002\u0017\r|gNZ5hg}#S-\u001d\u000b\u0003g\u0011CqAO\u0005\u0002\u0002\u0003\u0007a&\u0001\u0005d_:4\u0017nZ\u001a!\u0003\u001d\u0019XM\u001d<feN,\u0012\u0001\u0013\t\u0004\u00132sU\"\u0001&\u000b\u0005-+\u0014AC2pY2,7\r^5p]&\u0011QJ\u0013\u0002\u0004'\u0016\f\bCA\u0016P\u0013\t\u0001FDA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"aM*\t\u000fib\u0011\u0011!a\u0001\u0011\u0006A1/\u001a:wKJ\u001c\b%A\nce>\\WM]'fi\u0006\u0004&o\u001c9t\r&dW-F\u0001X!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003mC:<'\"\u0001/\u0002\t)\fg/Y\u0005\u0003=f\u0013aa\u0015;sS:<\u0017\u0001\u00062s_.,'/T3uCB\u0013x\u000e]:GS2,\u0007%A\u0003tKR,\u0006\u000fF\u00014Q\t\u00012\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006)!.\u001e8ji*\t\u0001.A\u0002pe\u001eL!A[3\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007FA\tn!\t!g.\u0003\u0002pK\n)\u0011I\u001a;fe\u0006IB/Z:u\u0003V$xnR3oKJ\fG/Z\"mkN$XM]%eQ\t\u0011\"\u000f\u0005\u0002eg&\u0011A/\u001a\u0002\u0005)\u0016\u001cH/\u0001\u001auKN$\u0018)\u001e;p\u000f\u0016tWM]1uK\u000ecWo\u001d;fe&#gi\u001c:LC\u001a\\\u0017m\u00117vgR,'oU3rk\u0016tG/[1mQ\t\u0019\"/\u0001\u0019uKN$\u0018)\u001e;p\u000f\u0016tWM]1uK\u000ecWo\u001d;fe&#gi\u001c:LC\u001a\\\u0017m\u00117vgR,'\u000fU1sC2dW\r\u001c\u0015\u0003)I\fA\u0007^3ti\u000e{gn]5ti\u0016tGo\u00117vgR,'/\u00133Ge>l'l\\8lK\u0016\u0004XM]!oI\u001a\u0013x.\\'fi\u0006\u0004&o\u001c9tQ\t)\"/\u0001\u001cuKN$\u0018J\\2p]NL7\u000f^3oi\u000ecWo\u001d;fe&#gI]8n5>|7.Z3qKJ\fe\u000e\u001a$s_6lU\r^1Qe>\u00048\u000f\u000b\u0002\u0017e\u0006!D/Z:u\u0013:\u001cwN\\:jgR,g\u000e\u001e\"s_.,'/T3uC\u0012\fG/\u0019\"fi^,WM\\'vYRL\u0007\u000f\\3M_\u001e$\u0015N]:)\u0005]\u0011\u0018a\u00054pe\u001e,'I]8lKJlU\r^1eCR\fGcB\u001a\u0002\u0004\u0005u\u0011q\u0005\u0005\b\u0003\u000bA\u0002\u0019AA\u0004\u0003\u001dawn\u001a#jeN\u0004B!\u0013'\u0002\nA!\u00111BA\r\u001d\u0011\ti!!\u0006\u0011\u0007\u0005=Q'\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\u0011\u0002\rq\u0012xn\u001c;?\u0013\r\t9\"N\u0001\u0007!J,G-\u001a4\n\u0007y\u000bYBC\u0002\u0002\u0018UBq!a\b\u0019\u0001\u0004\t\t#\u0001\u0005ce>\\WM]%e!\r!\u00141E\u0005\u0004\u0003K)$aA%oi\"9\u0011\u0011\u0006\rA\u0002\u0005%\u0011!C2mkN$XM]%e)\u001d\u0019\u0014QFA\u0019\u0003gAq!a\f\u001a\u0001\u0004\tI!\u0001\u0004m_\u001e$\u0015N\u001d\u0005\b\u0003?I\u0002\u0019AA\u0011\u0011\u001d\tI#\u0007a\u0001\u0003\u0013\tAC^3sS\u001aL(I]8lKJlU\r^1eCR\fGCBA\u001d\u0003\u007f\t\t\u0005E\u00025\u0003wI1!!\u00106\u0005\u001d\u0011un\u001c7fC:Dq!!\u0002\u001b\u0001\u0004\t9\u0001C\u0004\u0002*i\u0001\r!!\u0003")
public class ServerGenerateClusterIdTest
extends ZooKeeperTestHarness {
    private KafkaConfig config1 = null;
    private KafkaConfig config2 = null;
    private KafkaConfig config3 = null;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final String brokerMetaPropsFile;

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assert.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assert.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assert.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assert.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        server1.startup();
        Assert.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assert.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assert.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        void traverse_executor;
        void traverse_fn;
        void traverse_cbf;
        void traverse_in;
        void var6_11;
        void var5_10;
        void var4_9;
        void traverse_executor2;
        void traverse_fn2;
        void traverse_cbf2;
        void traverse_in2;
        Future$ future$ = Future$.MODULE$;
        ExecutionContext executionContext = ExecutionContext.Implicits$.MODULE$.global();
        CanBuildFrom canBuildFrom = Seq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)config -> {
            void apply_executor;
            void apply_body;
            Future$ future$ = Future$.MODULE$;
            ExecutionContext executionContext = ExecutionContext.Implicits$.MODULE$.global();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createServer((KafkaConfig)config, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
            if (future$ == null) {
                throw null;
            }
            return future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)apply_executor);
        };
        .colon.colon colon2 = new .colon.colon((Object)this.config1(), (List)new .colon.colon((Object)this.config2(), (List)new .colon.colon((Object)this.config3(), (List)Nil$.MODULE$)));
        if (future$ == null) {
            throw null;
        }
        Future$ traverse_this = future$;
        Future firstBoot = ((Future)traverse_in2.foldLeft((Object)traverse_this.successful((Object)traverse_cbf2.apply((Object)traverse_in2)), (arg_0, arg_1) -> Future$.$anonfun$traverse$1((Function1)traverse_fn2, (ExecutionContext)traverse_executor2, arg_0, arg_1))).map(Future$::$anonfun$traverse$3, (ExecutionContext)Future.InternalCallbackExecutor$.MODULE$);
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
        KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
        KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
        void server12 = var4_9;
        void server22 = var5_10;
        void server32 = var6_11;
        String clusterIdFromServer1 = server12.clusterId();
        String clusterIdFromServer2 = server22.clusterId();
        String clusterIdFromServer3 = server32.clusterId();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assert.assertEquals((String)clusterIdFromServer1, (Object)clusterIdFromServer2, (Object)clusterIdFromServer3);
        Future$ future$2 = Future$.MODULE$;
        ExecutionContext executionContext2 = ExecutionContext.Implicits$.MODULE$.global();
        CanBuildFrom canBuildFrom2 = Seq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)server -> {
            void apply_executor;
            void apply_body;
            Future$ future$ = Future$.MODULE$;
            ExecutionContext executionContext = ExecutionContext.Implicits$.MODULE$.global();
            Function0 & Serializable & scala.Serializable intersect = (Function0 & Serializable & scala.Serializable)() -> {
                server.startup();
                return server;
            };
            if (future$ == null) {
                throw null;
            }
            return future$.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)apply_executor);
        };
        .colon.colon colon3 = new .colon.colon((Object)server12, (List)new .colon.colon((Object)server22, (List)new .colon.colon((Object)server32, (List)Nil$.MODULE$)));
        if (future$2 == null) {
            throw null;
        }
        Future$ traverse_this2 = future$2;
        Future secondBoot = ((Future)traverse_in.foldLeft((Object)traverse_this2.successful((Object)traverse_cbf.apply((Object)traverse_in)), (arg_0, arg_1) -> Future$.$anonfun$traverse$1((Function1)traverse_fn, (ExecutionContext)traverse_executor, arg_0, arg_1))).map(Future$::$anonfun$traverse$3, (ExecutionContext)Future.InternalCallbackExecutor$.MODULE$);
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentClusterIdFromZookeeperAndFromMetaProps() {
        KafkaServer server = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterId = server.clusterId();
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), clusterId));
        server.shutdown();
        server.startup();
        Assert.assertEquals((Object)clusterId, (Object)server.clusterId());
        Assert.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), server.clusterId()));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentClusterIdFromZookeeperAndFromMetaProps() {
        this.forgeBrokerMetadata((Seq<String>)this.config1().logDirs(), this.config1().brokerId(), "aclusterid");
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, x$4);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.startup(), ClassTag$.MODULE$.apply(InconsistentClusterIdException.class), new Position("ServerGenerateClusterIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentBrokerMetadataBetweenMultipleLogDirs() {
        String logDir1 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDir2 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDirs = new StringBuilder(1).append(logDir1).append(",").append(logDir2).toString();
        this.forgeBrokerMetadata(logDir1, 1, "ebwOKU-zSieInaFQh_qP4g");
        this.forgeBrokerMetadata(logDir2, 1, "blaOKU-zSieInaFQh_qP4g");
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.setProperty("log.dir", logDirs);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(config, x$3, x$2, x$4);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> server.startup(), ClassTag$.MODULE$.apply(InconsistentBrokerMetadataException.class), new Position("ServerGenerateClusterIdTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public void forgeBrokerMetadata(Seq<String> logDirs, int brokerId, String clusterId) {
        logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            this.forgeBrokerMetadata(logDir, brokerId, clusterId);
            return BoxedUnit.UNIT;
        });
    }

    public void forgeBrokerMetadata(String logDir, int brokerId, String clusterId) {
        new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append(this.brokerMetaPropsFile()).toString())).write(new BrokerMetadata(brokerId, Option$.MODULE$.apply((Object)clusterId)));
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, String clusterId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$1(this, clusterId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assert.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateClusterIdTest $this, String clusterId$2, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            BrokerMetadata brokerMetadata = (BrokerMetadata)((Some)brokerMetadataOpt).value();
            if (brokerMetadata.clusterId().isDefined()) {
                Object object = brokerMetadata.clusterId().get();
                if (object == null ? clusterId$2 != null : !object.equals(clusterId$2)) {
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
                }
            }
            return;
        }
        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
    }

    public ServerGenerateClusterIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

