/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.LeaderOffsetIncremented$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011]a\u0001B2e\u0001%DQ\u0001\u001d\u0001\u0005\u0002EDq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001e\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001v\u0011\u001d\t\t\u0001\u0001Q\u0001\nYD\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u000fA\u0011\"!\u0006\u0001\u0005\u0004%\t!a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A\u0011\"!\t\u0001\u0005\u0004%\t!a\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003KA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\t\u0011\u0005u\u0002\u0001)A\u0005\u0003oAq!a\u0010\u0001\t\u0003\t\t\u0005C\u0004\u0002\\\u0001!\t!!\u0011\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002B!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005\u0005\u0003bBA7\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003c\u0002A\u0011AA!\u0011\u001d\t)\b\u0001C\u0001\u0003\u0003Bq!!\u001f\u0001\t\u0003\t\t\u0005C\u0004\u0002~\u0001!\t!!\u0011\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002B!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u0005\u0003bBAE\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u001b\u0003A\u0011AA!\u0011\u001d\t\t\n\u0001C\u0001\u0003\u0003Bq!!&\u0001\t\u0003\t\t\u0005C\u0004\u0002\u001a\u0002!\t!!\u0011\t\u000f\u0005u\u0005\u0001\"\u0001\u0002B!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\u0005\u0003bBAS\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003S\u0003A\u0011AA!\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!4\u0001\t\u0003\t\t\u0005C\u0004\u0002R\u0002!\t!!\u0011\t\u000f\u0005M\u0007\u0001\"\u0001\u0002B!9\u0011q\u001b\u0001\u0005\u0002\u0005\u0005\u0003bBAn\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003?\u0004A\u0011AA!\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003\u0003Bq!a:\u0001\t\u0003\t\t\u0005C\u0004\u0002l\u0002!\t!!\u0011\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9!q\u0001\u0001\u0005\u0002\t%\u0001b\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005CAqA!\u000f\u0001\t\u0003\t\t\u0005C\u0004\u0003>\u0001!\t!!\u0011\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002B!9!Q\t\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B%\u0001\u0011%!1\n\u0005\b\u0005?\u0002A\u0011AA!\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0003\u0003BqAa\u001a\u0001\t\u0003\t\t\u0005C\u0004\u0003l\u0001!\t!!\u0011\t\u000f\t=\u0004\u0001\"\u0001\u0002B!9!1\u000f\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B<\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005w\u0002A\u0011AA!\u0011\u001d\u0011y\b\u0001C\u0001\u0003\u0003BqAa!\u0001\t\u0003\t\t\u0005C\u0004\u0003\b\u0002!IA!#\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c\"I!\u0011\u0018\u0001\u0012\u0002\u0013%!1\u0018\u0005\b\u0005#\u0004A\u0011\u0002Bj\u0011\u001d\u0011\t\u000e\u0001C\u0005\u0005[DqA!>\u0001\t\u0013\u00119\u0010C\u0005\u0004\u0004\u0001\t\n\u0011\"\u0003\u0004\u0006!I1\u0011\u0002\u0001\u0012\u0002\u0013%11\u0002\u0005\n\u0007\u001f\u0001\u0011\u0013!C\u0005\u0007#Aqa!\u0006\u0001\t\u0013\u00199\u0002C\u0005\u00042\u0001\t\n\u0011\"\u0003\u00044!I1q\u0007\u0001\u0012\u0002\u0013%1\u0011\b\u0005\b\u0005\u000f\u0003A\u0011BB\u001f\u0011\u001d\u00119\u000e\u0001C\u0005\u0007\u000bBqAa)\u0001\t\u0013\u00199\u0006C\u0005\u0004t\u0001\t\n\u0011\"\u0003\u0004\u0012!I1Q\u000f\u0001\u0012\u0002\u0013%1q\u000f\u0005\n\u0007w\u0002\u0011\u0013!C\u0005\u0007sA\u0011b! \u0001#\u0003%Ia!\u000f\t\u000f\r}\u0004\u0001\"\u0003\u0004\u0002\"I1\u0011\u0015\u0001\u0012\u0002\u0013%1\u0011\b\u0005\n\u0007G\u0003\u0011\u0013!C\u0005\u0007KCqa!+\u0001\t\u0013\u0019Y\u000bC\u0005\u0004B\u0002\t\n\u0011\"\u0003\u0004D\"I1q\u0019\u0001\u0012\u0002\u0013%1\u0011\b\u0005\n\u0007\u0013\u0004\u0011\u0013!C\u0005\u0007KCqaa3\u0001\t\u0013\u0019i\rC\u0005\u0004X\u0002\t\n\u0011\"\u0003\u0004\u0012!91\u0011\u001c\u0001\u0005\n\rm\u0007\"CBr\u0001E\u0005I\u0011BB\t\u0011\u001d\u0019)\u000f\u0001C\u0005\u0007ODqAa)\u0001\t\u0013\u0019Y\u0010C\u0004\u0005\u0002\u0001!I\u0001b\u0001\t\u000f\u0011\u001d\u0001\u0001\"\u0003\u0005\n!9AQ\u0002\u0001\u0005\n\u0011=!A\u0004'pO\u000ecW-\u00198feR+7\u000f\u001e\u0006\u0003K\u001a\f1\u0001\\8h\u0015\u00059\u0017!B6bM.\f7\u0001A\n\u0003\u0001)\u0004\"a\u001b8\u000e\u00031T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_2\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001s!\t\u0019\b!D\u0001e\u0003\u0019!X\u000e\u001d3jeV\ta\u000f\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006\u0011\u0011n\u001c\u0006\u0002w\u0006!!.\u0019<b\u0013\ti\bP\u0001\u0003GS2,\u0017a\u0002;na\u0012L'\u000fI\u0001\u0004I&\u0014\u0018\u0001\u00023je\u0002\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001bQ\u0018\u0001B;uS2LA!!\u0005\u0002\f\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\tI\u0002E\u0002t\u00037I1!!\be\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\nA\u0001^5nKV\u0011\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u00064\u0002\u000bU$\u0018\u000e\\:\n\t\u0005=\u0012\u0011\u0006\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u0003o\u0001B!a\n\u0002:%!\u00111HA\u0015\u0005%!\u0006N]8ui2,'/\u0001\u0006uQJ|G\u000f\u001e7fe\u0002\n\u0001\u0002^3be\u0012|wO\u001c\u000b\u0003\u0003\u0007\u00022a[A#\u0013\r\t9\u0005\u001c\u0002\u0005+:LG\u000fK\u0002\u000f\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0003kk:LGO\u0003\u0002\u0002V\u0005\u0019qN]4\n\t\u0005e\u0013q\n\u0002\u0006\u0003\u001a$XM]\u0001\u0012i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001c\bfA\b\u0002`A!\u0011QJA1\u0013\u0011\t\u0019'a\u0014\u0003\tQ+7\u000f^\u0001/i\u0016\u001cHo\u00117fC:\u001cVmZ7f]R\u001cx+\u001b;i\u0007>t7-\u001e:sK:$8+Z4nK:$H)\u001a7fi&|g\u000eK\u0002\u0011\u0003?\nq\u0006^3tiNK'0\u001a+sS6lW\r\u001a$peB\u0013X-\u00197m_\u000e\fG/\u001a3B]\u0012\u001cu.\u001c9bGR,G\rV8qS\u000eD3!EA0\u0003}!Xm\u001d;EkBd\u0017nY1uK\u000eCWmY6BMR,'o\u00117fC:Lgn\u001a\u0015\u0004%\u0005}\u0013!\t;fgR\u0014\u0015m]5d)J\fgn]1di&|g.Q<be\u0016\u001cE.Z1oS:<\u0007fA\n\u0002`\u0005IC/Z:u\u00072,\u0017M\\,ji\"$&/\u00198tC\u000e$\u0018n\u001c8t'B\fgN\\5oON+w-\\3oiND3\u0001FA0\u0003]!Xm\u001d;D_6l\u0017\u000e^'be.,'OU3n_Z\fG\u000eK\u0002\u0016\u0003?\nA\u0005^3ti\u0012+G.\u001a;fI\n\u000bGo\u00195fg^KG\u000f\u001b(p\u001b\u0016\u001c8/Y4fgJ+\u0017\r\u001a\u0015\u0004-\u0005}\u0013a\n;fgR\u001cu.\\7ji6\u000b'o[3s%\u0016$XM\u001c;j_:<\u0016\u000e\u001e5F[B$\u0018PQ1uG\"D3aFA0\u0003i!Xm\u001d;DY\u0016\fg.R7qif\u001cuN\u001c;s_2\u0014\u0015\r^2iQ\rA\u0012qL\u0001)i\u0016\u001cHoQ8n[&$H/\u001a3Ue\u0006t7/Y2uS>t7\u000b]1o]&twmU3h[\u0016tGo\u001d\u0015\u00043\u0005}\u0013A\n;fgR\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8Ta\u0006tg.\u001b8h'\u0016<W.\u001a8ug\"\u001a!$a\u0018\u0002-Q,7\u000f^!c_J$X*\u0019:lKJ\u0014V-\\8wC2D3aGA0\u0003\u0019\"Xm\u001d;F[B$\u0018PQ1uG\"\u0014V-\\8wC2<\u0016\u000e\u001e5TKF,XM\\2f%\u0016,8/\u001a\u0015\u00049\u0005}\u0013A\n;fgR\f%m\u001c:u\u001b\u0006\u00148.\u001a:SKR,g\u000e^5p]^KG\u000f[#naRL()\u0019;dQ\"\u001aQ$a\u0018\u0002!Q,7\u000f\u001e'be\u001e,W*Z:tC\u001e,\u0007f\u0001\u0010\u0002`\u0005\u0019C/Z:u\u001b\u0016\u001c8/Y4f\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=NKN\u001c\u0018mZ3TSj,\u0007fA\u0010\u0002`\u0005!D/Z:u\u001b\u0016\u001c8/Y4f\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=NKN\u001c\u0018mZ3TSj,w+\u001b;i\u0007>\u0014(/\u001e9u\u0011\u0016\fG-\u001a:)\u0007\u0001\ny&\u0001\u0018uKN$8i\u001c:skB$X*Z:tC\u001e,7+\u001b>f\u0019\u0006\u0014x-\u001a:UQ\u0006t')\u001f;fg\u00063\u0018-\u001b7bE2,\u0007fA\u0011\u0002`\u000513M]3bi\u0016dunZ,ji\"lUm]:bO\u0016\u001cH*\u0019:hKJ$\u0006.\u00198NCb\u001c\u0016N_3\u0015\t\u0005E\u00161\u0019\t\bW\u0006M\u0016qWA_\u0013\r\t)\f\u001c\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007M\fI,C\u0002\u0002<\u0012\u00141\u0001T8h!\r\u0019\u0018qX\u0005\u0004\u0003\u0003$'!\u0004$bW\u0016|eMZ:fi6\u000b\u0007\u000fC\u0004\u0002F\n\u0002\r!a2\u0002!1\f'oZ3NKN\u001c\u0018mZ3TSj,\u0007cA6\u0002J&\u0019\u00111\u001a7\u0003\u0007%sG/A\fuKN$8\t\\3b]&twmV5uQ\u0012+G.\u001a;fg\"\u001a1%a\u0018\u0002'Q,7\u000f\u001e'pO\u000ecW-\u00198feN#\u0018\r^:\u0002SQ,7\u000f\u001e'pO\u000ecW-\u00198feJ+G/Y5ogB\u0013x\u000eZ;dKJd\u0015m\u001d;TKF,XM\\2fQ\r)\u0013qL\u0001:i\u0016\u001cH\u000fT8h\u00072,\u0017M\\3s%\u0016$\u0018-\u001b8t\u0019\u0006\u001cHoU3rk\u0016t7-Z#wK:Le\r\u0016:b]N\f7\r^5p]\u0006\u0013wN\u001d;fI\"\u001aa%a\u0018\u0002/Q,7\u000f\u001e)beRL\u0017\r\\*fO6,g\u000e^\"mK\u0006t\u0007fA\u0014\u0002`\u0005\u0011C/Z:u\u00072,\u0017M\\5oO^KG\u000f[+oG2,\u0017M\\1cY\u0016\u001cVm\u0019;j_:D3\u0001KA0\u00039!Xm\u001d;M_\u001e$vn\u00117fC:D3!KA0\u0003\u0011\"Xm\u001d;M_\u001e$vn\u00117fC:<\u0016\u000e\u001e5V]\u000edW-\u00198bE2,7+Z2uS>t\u0007f\u0001\u0016\u0002`\u0005yB/Z:u\u00072,\u0017M\\5oO^KG\u000f[+oW\u0016LX\rZ'fgN\fw-Z:)\u0007-\ny&\u0001\rmCN$xJ\u001a4tKR\u001c\b+\u001a:CCR\u001c\u0007.\u00138M_\u001e$B!a=\u0003\u0006A1\u0011Q_A~\u0003\u007fl!!a>\u000b\u0007\u0005eH.\u0001\u0006d_2dWm\u0019;j_:LA!!@\u0002x\nA\u0011\n^3sC\ndW\rE\u0002l\u0005\u0003I1Aa\u0001m\u0005\u0011auN\\4\t\r\u0015d\u0003\u0019AA\\\u0003Ia\u0017m\u001d;TKF,XM\\2fg&sGj\\4\u0015\t\t-!\u0011\u0003\t\t\u0003k\u0014i!a@\u0002H&!!qBA|\u0005\ri\u0015\r\u001d\u0005\u0007K6\u0002\r!a.\u0002\u0019=4gm]3ug&sGj\\4\u0015\t\u0005M(q\u0003\u0005\u0007K:\u0002\r!a.\u00021Ut7.Z=fI6+7o]1hK\u000e{WO\u001c;J]2{w\r\u0006\u0003\u0002H\nu\u0001BB30\u0001\u0004\t9,\u0001\bbE>\u0014Ho\u00115fG.$uN\\3\u0015\t\u0005\r#1\u0005\u0005\b\u0005K\u0001\u0004\u0019\u0001B\u0014\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BA!\u000b\u000365\u0011!1\u0006\u0006\u0005\u0005[\u0011y#\u0001\u0004d_6lwN\u001c\u0006\u0004O\nE\"\u0002\u0002B\u001a\u0003'\na!\u00199bG\",\u0017\u0002\u0002B\u001c\u0005W\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u000euKN$8\t\\3b]N+w-\\3oiN<\u0016\u000e\u001e5BE>\u0014H\u000fK\u00022\u0003?\n1\u0003^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001eD3AMA0\u0003\u0011\"Xm\u001d;TK\u001elWM\u001c;He>,\b/\u001b8h/&$\bn\u00159beN,wJ\u001a4tKR\u001c\bfA\u001a\u0002`\u0005YC/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO\u001a{G\u000e\\8xS:<Gj\\1e\u001f\u001aTVM]8J]\u0012,\u0007\u0010K\u00025\u0003?\n\u0011c\u00195fG.\u001cVmZ7f]R|%\u000fZ3s)\u0011\t\u0019E!\u0014\t\u000f\t=S\u00071\u0001\u0003R\u00051qM]8vaN\u0004b!!>\u0003T\t]\u0013\u0002\u0002B+\u0003o\u00141aU3r!\u0019\t)Pa\u0015\u0003ZA\u00191Oa\u0017\n\u0007\tuCM\u0001\u0006M_\u001e\u001cVmZ7f]R\f!\u0003^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\"\u001aa'a\u0018\u0002;Q,7\u000f^*fO6,g\u000e^,ji\"|eMZ:fi>3XM\u001d4m_^D3aNA0\u0003Y!Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCND\u0007f\u0001\u001d\u0002`\u0005YB/Z:u\u0005VLG\u000eZ(gMN,G/T1q\r\u0006\\W\rT1sO\u0016D3!OA0\u0003e!Xm\u001d;Ck&dG\rU1si&\fGn\u00144gg\u0016$X*\u00199)\u0007i\ny&\u0001\u000euKN$8\t\\3b]\u000e{'O];qi6+7o]1hKN+G\u000fK\u0002<\u0003?\nQ\u0005^3ti\u000ec\u0017.\u001a8u\u0011\u0006tG\r\\5oO>37i\u001c:skB$X*Z:tC\u001e,7+\u001a;)\u0007q\ny&\u0001\nuKN$8\t\\3b]R{WNY:u_:,\u0007fA\u001f\u0002`\u0005\u0001C/Z:u\u00072,\u0017M\\5oO\n+\u0017p\u001c8e\u001b&\u001c8/\u001b8h\u001f\u001a47/\u001a;tQ\rq\u0014qL\u0001\u0015i\u0016\u001cH/T1y\u00072,\u0017M\u001c+j[\u0016\u001cVmY:)\u0007}\ny&\u0001\u0006xe&$X\rV8M_\u001e$\u0002\"a=\u0003\f\n5%Q\u0013\u0005\u0007K\u0002\u0003\r!a.\t\u000f\t=\u0005\t1\u0001\u0003\u0012\u0006i1.Z=t\u0003:$g+\u00197vKN\u0004b!!>\u0002|\nM\u0005cB6\u00024\u0006\u001d\u0017q\u0019\u0005\b\u0005/\u0003\u0005\u0019AAz\u0003%ygMZ:fiN+\u0017/A\u000bj]Z\fG.\u001b3DY\u0016\fg.\u001a3NKN\u001c\u0018mZ3\u0015\u0011\tu%\u0011\u0016BW\u0005_\u0003BAa(\u0003&6\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013Y#\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005O\u0013\tKA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0005W\u000b\u0005\u0019AA\u0000\u00035Ig.\u001b;jC2|eMZ:fi\"9!qR!A\u0002\tE\u0005\"\u0003BY\u0003B\u0005\t\u0019\u0001BZ\u0003\u0015\u0019w\u000eZ3d!\u0011\u0011yJ!.\n\t\t]&\u0011\u0015\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\u0006y\u0012N\u001c<bY&$7\t\\3b]\u0016$W*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu&\u0006\u0002BZ\u0005\u007f[#A!1\u0011\t\t\r'QZ\u0007\u0003\u0005\u000bTAAa2\u0003J\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017d\u0017AC1o]>$\u0018\r^5p]&!!q\u001aBc\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012[\u0016\u001c8/Y4f/&$\bn\u00144gg\u0016$H\u0003\u0003BO\u0005+\u0014)O!;\t\u000f\t]7\t1\u0001\u0003Z\u0006\u00191.Z=\u0011\u000b-\u0014YNa8\n\u0007\tuGNA\u0003BeJ\f\u0017\u0010E\u0002l\u0005CL1Aa9m\u0005\u0011\u0011\u0015\u0010^3\t\u000f\t\u001d8\t1\u0001\u0003Z\u0006)a/\u00197vK\"9!1^\"A\u0002\u0005}\u0018AB8gMN,G\u000f\u0006\u0005\u0003\u001e\n=(\u0011\u001fBz\u0011\u001d\u00119\u000e\u0012a\u0001\u0003\u000fDqAa:E\u0001\u0004\t9\rC\u0004\u0003l\u0012\u0003\r!a@\u0002\u000f5\f7.\u001a'pORA\u0011q\u0017B}\u0005w\u0014y\u0010C\u0004\u0000\u000bB\u0005\t\u0019\u0001<\t\u0013\tuX\t%AA\u0002\u0005e\u0011AB2p]\u001aLw\rC\u0005\u0004\u0002\u0015\u0003\n\u00111\u0001\u0002\u0000\u0006i!/Z2pm\u0016\u0014\u0018\u0010U8j]R\f\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u00199AK\u0002w\u0005\u007f\u000b\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iA\u000b\u0003\u0002\u001a\t}\u0016!E7bW\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0003\u0016\u0005\u0003\u007f\u0014y,A\u0006nC.,7\t\\3b]\u0016\u0014H\u0003CB\r\u0007?\u0019\u0019c!\f\u0011\u0007M\u001cY\"C\u0002\u0004\u001e\u0011\u0014qa\u00117fC:,'\u000fC\u0004\u0004\"%\u0003\r!a2\u0002\u0011\r\f\u0007/Y2jifD\u0011b!\nJ!\u0003\u0005\raa\n\u0002\u0013\rDWmY6E_:,\u0007cB6\u0004*\t\u001d\u00121I\u0005\u0004\u0007Wa'!\u0003$v]\u000e$\u0018n\u001c82\u0011%\u0019y#\u0013I\u0001\u0002\u0004\t9-\u0001\bnCblUm]:bO\u0016\u001c\u0016N_3\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0007\u0016\u0005\u0007O\u0011y,A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rm\"\u0006BAd\u0005\u007f#b!a=\u0004@\r\u0005\u0003BB3M\u0001\u0004\t9\fC\u0004\u0004D1\u0003\rA!%\u0002\u0007M,\u0017\u000f\u0006\u0003\u0004H\rM\u0003\u0003BB%\u0007\u001fj!aa\u0013\u000b\u0007\r5#0A\u0002oS>LAa!\u0015\u0004L\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\rUS\n1\u0001\u0002\u0000\u0006\u0011\u0011\u000e\u001a\u000b\u000f\u0005;\u001bIfa\u0017\u0004^\r\u000541NB8\u0011\u001d\u00119N\u0014a\u0001\u0003\u000fDqAa:O\u0001\u0004\t9\rC\u0005\u0004`9\u0003\n\u00111\u0001\u0002\u0000\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0013\r\rd\n%AA\u0002\r\u0015\u0014!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002l\u0007OJ1a!\u001bm\u0005\u0015\u0019\u0006n\u001c:u\u0011%\u0019iG\u0014I\u0001\u0002\u0004\t9-\u0001\u0005tKF,XM\\2f\u0011%\u0019\tH\u0014I\u0001\u0002\u0004\t9-\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r[\u0001\u0011e\u0016\u001cwN\u001d3%I\u00164\u0017-\u001e7uIM\n\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\re$\u0006BB3\u0005\u007f\u000b\u0001C]3d_J$G\u0005Z3gCVdG\u000fJ\u001b\u0002!I,7m\u001c:eI\u0011,g-Y;mi\u00122\u0014aG1qa\u0016tG\r\u0016:b]N\f7\r^5p]\u0006d\u0017i\u001d'fC\u0012,'\u000f\u0006\u0007\u0004\u0004\u000e55qRBI\u0007'\u001b9\nE\u0004l\u0007S\u0019)ia\"\u0011\r\u0005U(1KAd!\r\u00198\u0011R\u0005\u0004\u0007\u0017#'!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0003\u0004f'\u0002\u0007\u0011q\u0017\u0005\b\u0007?\u001a\u0006\u0019AA\u0000\u0011\u001d\u0019\u0019g\u0015a\u0001\u0007KB\u0011b!&T!\u0003\u0005\r!a2\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\u0005\n\u00073\u001b\u0006\u0013!a\u0001\u00077\u000baa\u001c:jO&t\u0007cA:\u0004\u001e&\u00191q\u00143\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\u0002K\u0005\u0004\b/\u001a8e)J\fgn]1di&|g.\u00197Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012\"\u0014!J1qa\u0016tG\r\u0016:b]N\f7\r^5p]\u0006d\u0017i\u001d'fC\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u00199K\u000b\u0003\u0004\u001c\n}\u0016\u0001G1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193feRq11QBW\u0007_\u001b\tla-\u0004>\u000e}\u0006BB3W\u0001\u0004\t9\fC\u0004\u0004`Y\u0003\r!a@\t\u000f\r\rd\u000b1\u0001\u0004f!I1Q\u0017,\u0011\u0002\u0003\u00071qW\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bYB\u00191n!/\n\u0007\rmFNA\u0004C_>dW-\u00198\t\u0013\rUe\u000b%AA\u0002\u0005\u001d\u0007\"CBM-B\u0005\t\u0019ABN\u0003\t\n\u0007\u000f]3oI&#W-\u001c9pi\u0016tG/Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0019\u0016\u0005\u0007o\u0013y,\u0001\u0012baB,g\u000eZ%eK6\u0004x\u000e^3oi\u0006\u001bH*Z1eKJ$C-\u001a4bk2$H%N\u0001#CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0002\u0019\r|W.\\5u\u001b\u0006\u00148.\u001a:\u0015\u0011\tu5qZBi\u0007'Dqaa\u0018[\u0001\u0004\ty\u0010C\u0004\u0004di\u0003\ra!\u001a\t\u0013\rU'\f%AA\u0002\u0005}\u0018!\u0003;j[\u0016\u001cH/Y7q\u0003Y\u0019w.\\7ji6\u000b'o[3sI\u0011,g-Y;mi\u0012\u001a\u0014aC1c_J$X*\u0019:lKJ$\u0002B!(\u0004^\u000e}7\u0011\u001d\u0005\b\u0007?b\u0006\u0019AA\u0000\u0011\u001d\u0019\u0019\u0007\u0018a\u0001\u0007KB\u0011b!6]!\u0003\u0005\r!a@\u0002+\u0005\u0014wN\u001d;NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aQM\u001c3Uq:l\u0015M]6feRa!QTBu\u0007W\u001cioa>\u0004z\"91q\f0A\u0002\u0005}\bbBB2=\u0002\u00071Q\r\u0005\b\u0007_t\u0006\u0019ABy\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u0005\u0005?\u001b\u00190\u0003\u0003\u0004v\n\u0005&!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"9!1\u001e0A\u0002\u0005}\bbBBk=\u0002\u0007\u0011q \u000b\u0007\u0005;\u001bipa@\t\u000f\t]w\f1\u0001\u0002H\"9!q]0A\u0002\te\u0017!D;oW\u0016LX\r\u001a*fG>\u0014H\r\u0006\u0003\u0003\u001e\u0012\u0015\u0001b\u0002BtA\u0002\u0007\u0011qY\u0001\u0010i>l'm\u001d;p]\u0016\u0014VmY8sIR!!Q\u0014C\u0006\u0011\u001d\u00119.\u0019a\u0001\u0003\u000f\fqB]3d_Z,'/\u00118e\u0007\",7m\u001b\u000b\u0007\u0003o#\t\u0002b\u0005\t\u000f\tu(\r1\u0001\u0002\u001a!9AQ\u00032A\u0002\u0005M\u0018\u0001D3ya\u0016\u001cG/\u001a3LKf\u001c\b")
public class LogCleanerTest {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegments() {
        void longWrapper_x;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$22 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$22, x$12, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)new RichLong((long)longWrapper_x).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$2)))), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        Log log = new Log(this, logProps, topicPartition, producerStateManager, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), LogConfig$.MODULE$.fromProps($outer.logConfig().originals(), logProps$1), 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, producerStateManager$1, new LogDirFailureChannel(10));
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final Log log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset(), (LogStartOffsetIncrementReason)LeaderOffsetIncremented$.MODULE$);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            log.roll(log.roll$default$1());
        }
        Assert.assertEquals((long)3L, (long)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Seq segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log, segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assert.assertEquals((long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(originalMaxFileSize));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateCheckAfterCleaning() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        ObjectRef log = ObjectRef.create((Object)this.makeLog(x$2, x$1, x$3));
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Log qual$1 = (Log)log.elem;
        Option x$4 = qual$1.roll$default$1();
        qual$1.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)2);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Integer n2 = BoxesRunTime.boxToInteger((int)2);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Integer n3 = BoxesRunTime.boxToInteger((int)1);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), this.lastSequencesInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(log, logProps);
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader((Log)log.elem, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Log qual$2 = (Log)log.elem;
        Option x$5 = qual$2.roll$default$1();
        qual$2.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), (Log)log.elem, 0L, ((Log)log.elem).activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Tuple2[] tuple2Array2 = new Tuple2[4];
        Integer n4 = BoxesRunTime.boxToInteger((int)2);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Integer n5 = BoxesRunTime.boxToInteger((int)2);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n6 = BoxesRunTime.boxToInteger((int)1);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n7 = BoxesRunTime.boxToInteger((int)0);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)pid4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), this.lastSequencesInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog((Log)log.elem));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog((Log)log.elem));
        this.reloadLog$1(log, logProps);
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader((Log)log.elem, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()))._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        TopicPartition tp = new TopicPartition("test", 0);
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 100;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(100));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        Log log = this.makeLog(x$5, x$4, x$6);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        producer1.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(128));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5()).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(2048));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int x$8 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$8, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int x$13 = this.appendTransactionalAsLeader$default$4();
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, x$13, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(256));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((long)0L, (long)log.collectAbortedTransactions(0L, 100L).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLargeMessage() {
        void longWrapper_x;
        int largeMessageSize = 0x100000;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$32 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$32, x$2);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$5 = this.makeLog$default$1();
        long x$6 = this.makeLog$default$3();
        Log log = this.makeLog(x$5, x$4, x$6);
        while (log.numberOfSegments() < 2) {
            void fill_evidence$9;
            int n = (int)log.logEndOffset();
            Array$ array$ = Array$.MODULE$;
            ClassTag classTag = ClassTag$.MODULE$.Byte();
            if (array$ == null) {
                throw null;
            }
            ArrayBuilder fill_b = array$.newBuilder((ClassTag)fill_evidence$9);
            fill_b.sizeHint(largeMessageSize);
            for (int fill_i = 0; fill_i < largeMessageSize; ++fill_i) {
                fill_b.$plus$eq((Object)BoxesRunTime.boxToByte((byte)LogCleanerTest.$anonfun$testLargeMessage$1()));
            }
            log.appendAsLeader(this.record(n, (byte[])fill_b.result()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)new RichLong((long)longWrapper_x).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)((LogSegment)log.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$3)))), LogTest$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(x$1, x$3, x$2).cleanSegments((Log)log2, (Seq)new .colon.colon((Object)((LogSegment)log2.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog((Log)log2).filter((Function1)((JFunction1.mcZJ.sp & Serializable & scala.Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)offsetMap2, arg_0)))), LogTest$.MODULE$.keysInLog((Log)log2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (Log)log2, (FakeOffsetMap)offsetMap2)), ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        void log2 = var2_2;
        void offsetMap2 = var3_3;
        RandomAccessFile file = new RandomAccessFile(((LogSegment)log2.logSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        int x$1 = Integer.MAX_VALUE;
        int x$2 = 1024;
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$1, x$3, x$2);
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (Log)log2, (FakeOffsetMap)offsetMap2)), ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        void longWrapper_x;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            void fill_evidence$9;
            int n = (int)log.logEndOffset();
            Array$ array$ = Array$.MODULE$;
            ClassTag classTag = ClassTag$.MODULE$.Byte();
            if (array$ == null) {
                throw null;
            }
            ArrayBuilder fill_b = array$.newBuilder((ClassTag)fill_evidence$9);
            fill_b.sizeHint(largeMessageSize);
            for (int fill_i = 0; fill_i < largeMessageSize; ++fill_i) {
                fill_b.$plus$eq((Object)BoxesRunTime.boxToByte((byte)LogCleanerTest.$anonfun$createLogWithMessagesLargerThanMaxSize$1()));
            }
            log.appendAsLeader(this.record(n, (byte[])fill_b.result()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((Object)new RichLong((long)longWrapper_x).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize / 2));
        log.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithDeletes() {
        void intWrapper_x;
        void intWrapper_x2;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long leo = log.logEndOffset();
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x2, (int)leo).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(this.tombstoneRecord(foreach_i), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Set keys = LogTest$.MODULE$.keysInLog(log).toSet();
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0((int)intWrapper_x, (int)leo).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$7 -> !keys.contains((Object)BoxesRunTime.boxToLong((long)x$7))));
    }

    /*
     * WARNING - void declaration
     */
    public void testLogCleanerStats() {
        void var13_10;
        void var11_9;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assert.assertEquals((long)5L, (long)var11_9);
        Assert.assertEquals((long)5L, (long)var13_10.messagesRead());
        Assert.assertEquals((long)initialLogSize, (long)var13_10.bytesRead());
        Assert.assertEquals((long)2L, (long)var13_10.messagesWritten());
        Assert.assertEquals((long)log.size(), (long)var13_10.bytesWritten());
        Assert.assertEquals((long)0L, (long)var13_10.invalidMessagesRead());
        Assert.assertTrue((var13_10.endTime() >= var13_10.startTime() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n3 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, this.appendTransactionalAsLeader$default$4(), this.appendTransactionalAsLeader$default$5());
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Tuple2[] tuple2Array = new Tuple2[1];
        Integer n = BoxesRunTime.boxToInteger((int)2);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Integer n2 = BoxesRunTime.boxToInteger((int)4);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)producerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 > N));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, LogToClean$.MODULE$.apply$default$5()));
        Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogToClean() {
        void intWrapper_x;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 6);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - (long)log.activeSegment().size()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogToCleanWithUncleanableSection() {
        void intWrapper_x;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 6);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), LogToClean$.MODULE$.apply$default$5());
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var14_11;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)var14_11.invalidMessagesRead());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public Map<Object, Object> lastSequencesInLog(Log log) {
        return ((TraversableOnce)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable & scala.Serializable)batch -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Integer n = BoxesRunTime.boxToInteger((int)batch.lastSequence());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)batch.producerId()));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)s -> (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.hasValue()))).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.hasKey()))).map((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)m.offset()), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        void makeCleaner_checkDone;
        void makeCleaner_maxMessageSize;
        int n = this.makeCleaner$default$3();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), (int)makeCleaner_maxMessageSize, (int)makeCleaner_maxMessageSize, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
    }

    @Test
    public void testSegmentGrouping() {
        boolean bl;
        List groups;
        Log log;
        Cleaner cleaner;
        block6: {
            boolean bl2;
            block5: {
                cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
                Properties logProps = new Properties();
                logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
                logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
                LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
                File x$2 = this.makeLog$default$1();
                long x$3 = this.makeLog$default$3();
                log = this.makeLog(x$2, x$1, x$3);
                int i = 0;
                while (log.numberOfSegments() < 10) {
                    log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                    ++i;
                }
                groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
                Assert.assertEquals((long)1L, (long)groups.size());
                Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.head()).size());
                this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
                groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
                Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
                List forall_these = groups;
                while (!forall_these.isEmpty()) {
                    if (!LogCleanerTest.$anonfun$testSegmentGrouping$1((Seq)forall_these.head())) {
                        bl2 = false;
                        break block5;
                    }
                    forall_these = (LinearSeqOptimized)forall_these.tail();
                }
                bl2 = true;
            }
            Assert.assertTrue((String)"All groups should be singletons.", (boolean)bl2);
            this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
            groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
            Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
            List forall_these = groups;
            while (!forall_these.isEmpty()) {
                if (!LogCleanerTest.$anonfun$testSegmentGrouping$2((Seq)forall_these.head())) {
                    bl = false;
                    break block6;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)bl);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, x$18))));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$19)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, x$20))));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)1L, (long)groups.size());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        List foreach_these = groups;
        while (!foreach_these.isEmpty()) {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1((Seq)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(400));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(400));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0x3FFFFFFFL)));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log.logSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        Assert.assertEquals((long)2L, (long)groups.size());
        List foreach_these = groups;
        while (!foreach_these.isEmpty()) {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1((Seq)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable & scala.Serializable)x$21 -> (Seq)x$21.map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)x$22.baseOffset()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start = 0;
        int end = 500;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(start, end).zip((GenIterable)RichInt$.MODULE$.until$extension0(start, end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentWithOffsetOverflow() {
        void intWrapper_x;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(1000));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        long x$2 = Long.MAX_VALUE;
        File x$3 = this.makeLog$default$1();
        Log log = this.makeLog(x$3, config, x$2);
        Option<LogSegment> option = LogTest$.MODULE$.firstOverflowSegment(log);
        if (option == null) {
            throw null;
        }
        Option<LogSegment> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Failed to create log with a segment which has overflowed offsets", new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1288));
        }
        LogSegment segmentWithOverflow = (LogSegment)getOrElse_this.get();
        int numSegmentsInitial = log.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        boolean bl = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, allKeys.size()).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleanerTest.$anonfun$testSegmentWithOffsetOverflow$2(this, expectedKeysAfterCleaning, allKeys, offsetMap, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata()), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
        Assert.assertEquals((long)(numSegmentsInitial + 1), (long)log.logSegments().size());
        Assert.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentToClean, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrash() {
        void intWrapper_x;
        void intWrapper_x2;
        void withFilter_p;
        void withFilter_p2;
        void intWrapper_x3;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, config, x$3);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$5 = 0;
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$4, x$5, x$6, x$7);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        boolean bl = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x3, messageCount).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file));
        ArrayOps.ofRef withFilter_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()));
        new TraversableLike.WithFilter((TraversableLike)withFilter_this, (Function1)withFilter_p2).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file));
        ArrayOps.ofRef withFilter_this2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()));
        new TraversableLike.WithFilter((TraversableLike)withFilter_this2, (Function1)withFilter_p).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$8 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$9 = 0;
            AppendOrigin x$10 = log.appendAsLeader$default$3();
            ApiVersion x$11 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$8, x$9, x$10, x$11);
            ++messageCount;
        }
        boolean bl2 = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0((int)intWrapper_x2, messageCount).by(2);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$12 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6());
            int x$13 = 0;
            AppendOrigin x$14 = log.appendAsLeader$default$3();
            ApiVersion x$15 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$12, x$13, x$14, x$15);
            ++messageCount;
        }
        boolean bl3 = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range3 = RichInt$.MODULE$.until$extension0((int)intWrapper_x, messageCount).by(2);
        if (range3 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this3 = range3;
        if (!foreach$mVc$sp_this3.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
            }
        }
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(120));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(keyStart, keyEnd).zip((GenIterable)RichInt$.MODULE$.until$extension0(keyStart, keyEnd), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)offsetEnd, (long)map.latestOffset());
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(keyEnd - keyStart), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0L)));
        Assert.assertEquals((String)"Map should contain second value", (long)offsetEnd, (long)map.get(this.key(1L)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2(), this.makeLog$default$3());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log.appendAsLeader(this.record(0, 0, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(4, 4, this.record$default$3(), this.record$default$4(), this.record$default$5(), this.record$default$6()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanCorruptMessageSet() {
        void intWrapper_x;
        void intWrapper_x2;
        void intWrapper_x3;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x3, 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0((int)intWrapper_x2, 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(dupSetOffset, dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        int n = 3;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 5);
        int noDupSetOffset = 50;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(noDupSetOffset, noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        void intWrapper_x;
        boolean bl = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range keys = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 10);
        int offset = 50;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(offset, offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3()).buffer());
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, logConfig, x$3);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$7 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$8 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, x$8), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$12 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$13 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, x$13), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType x$17 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$18 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_18;
        void longWrapper_x;
        void intWrapper_x;
        void intWrapper_x2;
        void longWrapper_x2;
        void intWrapper_x3;
        void intWrapper_x4;
        void var6_9;
        void longWrapper_x3;
        void intWrapper_x5;
        void intWrapper_x6;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(0x100000));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Log log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long l = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x6, 9).zip((GenIterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x5, 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong((long)longWrapper_x3).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)11L)));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assert.assertEquals((String)"Cleaning point should pass offset gap", (long)log.activeSegment().baseOffset(), (long)var6_9);
        Log log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, this.makeLog$default$3());
        boolean bl3 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        boolean bl4 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long l2 = 0L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x4, 9).zip((GenIterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x3, 9), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong((long)longWrapper_x2).to((Object)BoxesRunTime.boxToLong((long)9L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)15L)));
        int n = 15;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int n2 = 15;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long l3 = 15L;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x2, 24).zip((GenIterable)RichInt$.MODULE$.to$extension0((int)intWrapper_x, 24), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)new RichLong((long)longWrapper_x).to((Object)BoxesRunTime.boxToLong((long)24L)));
        log2.roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)30L)));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assert.assertEquals((String)"Cleaning point should pass offset gap in multiple segments", (long)log2.activeSegment().baseOffset(), (long)var10_18);
    }

    @Test
    public void testMaxCleanTimeSecs() {
        LogCleaner logCleaner = new LogCleaner(new CleanerConfig(CleanerConfig$.MODULE$.$lessinit$greater$default$1(), CleanerConfig$.MODULE$.$lessinit$greater$default$2(), CleanerConfig$.MODULE$.$lessinit$greater$default$3(), CleanerConfig$.MODULE$.$lessinit$greater$default$4(), CleanerConfig$.MODULE$.$lessinit$greater$default$5(), CleanerConfig$.MODULE$.$lessinit$greater$default$6(), CleanerConfig$.MODULE$.$lessinit$greater$default$7(), CleanerConfig$.MODULE$.$lessinit$greater$default$8(), CleanerConfig$.MODULE$.$lessinit$greater$default$9()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{TestUtils$.MODULE$.tempDir()}), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()), new LogDirFailureChannel(1), (Time)this.time());
        try {
            this.checkGauge$1("max-buffer-utilization-percent", logCleaner);
            this.checkGauge$1("max-clean-time-secs", logCleaner);
            this.checkGauge$1("max-compaction-delay-secs", logCleaner);
        }
        finally {
            logCleaner.shutdown();
        }
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$23)), Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable & scala.Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])Integer.toString(kv._1$mcI$sp()).getBytes(), (byte[])Integer.toString(kv._2$mcI$sp()).getBytes()), Iterable$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.sizeInBytes()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef offset = LongRef.create((long)initialOffset);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        return MemoryRecords.withRecords((long)offset, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(key, value)});
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(Integer.toString(key).getBytes(), Integer.toString(value).getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        long x$3 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(dir, config, x$3, recoveryPoint, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable & scala.Serializable)x$25 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$25);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$writeToLog$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$26)), Iterable$.MODULE$.canBuildFrom());
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(Long.toString(id).getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        return MemoryRecords.withIdempotentRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(Integer.toString(key).getBytes(), Integer.toString(value).getBytes())});
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        boolean x$4 = true;
        int x$6 = this.appendIdempotentAsLeader$default$5();
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, x$4, x$6, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef sequence = IntRef.create((int)0);
        return (Function1 & Serializable & scala.Serializable)keys -> {
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable & scala.Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)), Seq$.MODULE$.canBuildFrom());
            MemoryRecords records = isTransactional ? MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))) : MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence$1.elem, (SimpleRecord[])((SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
            sequence$1.elem += simpleRecords.size();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        byte[] x$1 = Integer.toString(key).getBytes();
        CompressionType x$3 = TestUtils$.MODULE$.singletonRecords$default$3();
        long x$4 = TestUtils$.MODULE$.singletonRecords$default$4();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, x$4, x$5);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(Integer.toString(value).getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler(), LogTest$.MODULE$.recoverAndCheck$default$7());
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$2) {
        ((Log)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$2);
        long x$2 = 0L;
        File x$3 = this.makeLog$default$1();
        log$2.elem = this.makeLog(x$3, x$1, x$2);
    }

    private static final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$1) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        Assert.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ byte $anonfun$testLargeMessage$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(Long.toString(k));
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$1, Log log$4, FakeOffsetMap offsetMap$2) {
        cleaner$1.cleanSegments(log$4, (Seq)new .colon.colon((Object)((LogSegment)log$4.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$2, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$2, Log log$5, FakeOffsetMap offsetMap$3) {
        cleaner$2.cleanSegments(log$5, (Seq)new .colon.colon((Object)((LogSegment)log$5.logSegments().head()), (List)Nil$.MODULE$), (OffsetMap)offsetMap$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ byte $anonfun$createLogWithMessagesLargerThanMaxSize$1() {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()), Iterable$.MODULE$.canBuildFrom())).toSet().size();
    }

    private static final Seq distinctValuesBySegment$1(Log log$7) {
        return ((TraversableOnce)log$7.logSegments().map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 != null) {
            int before = x0$1._1$mcI$sp();
            return x0$1._2$mcI$sp() < before;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    public static final /* synthetic */ byte $anonfun$testLogToClean$1() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords createRecorcs$1() {
        int fill_n;
        void fill_evidence$9;
        Array$ array$ = Array$.MODULE$;
        ClassTag classTag = ClassTag$.MODULE$.Byte();
        int n = 25;
        if (array$ == null) {
            throw null;
        }
        ArrayBuilder fill_b = array$.newBuilder((ClassTag)fill_evidence$9);
        fill_b.sizeHint(fill_n);
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            fill_b.$plus$eq((Object)BoxesRunTime.boxToByte((byte)LogCleanerTest.$anonfun$testLogToClean$1()));
        }
        return TestUtils$.MODULE$.singletonRecords((byte[])fill_b.result(), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ byte $anonfun$testLogToCleanWithUncleanableSection$1() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords createRecords$1() {
        int fill_n;
        void fill_evidence$9;
        Array$ array$ = Array$.MODULE$;
        ClassTag classTag = ClassTag$.MODULE$.Byte();
        int n = 25;
        if (array$ == null) {
            throw null;
        }
        ArrayBuilder fill_b = array$.newBuilder((ClassTag)fill_evidence$9);
        fill_b.sizeHint(fill_n);
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            fill_b.$plus$eq((Object)BoxesRunTime.boxToByte((byte)LogCleanerTest.$anonfun$testLogToCleanWithUncleanableSection$1()));
        }
        return TestUtils$.MODULE$.singletonRecords((byte[])fill_b.result(), Integer.toString(1).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.hasValue()))).count((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$15) {
        return x$15.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$16) {
        return x$16.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$18) {
        return x$18.size() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$19) {
        return x$19.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$20) {
        return x$20.size() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testBuildOffsetMap$1(LogCleanerTest $this, FakeOffsetMap map$5, int i) {
        Assert.assertEquals((String)"Should find all the keys", (long)i, (long)map$5.get($this.key(i)));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$4, Log log$11) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$4.buildOffsetMap(log$11, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(start, end);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleanerTest.$anonfun$testBuildOffsetMap$1(this, map, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
        Assert.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    public static final /* synthetic */ void $anonfun$testSegmentWithOffsetOverflow$2(LogCleanerTest $this, ArrayBuffer expectedKeysAfterCleaning$1, List allKeys$1, FakeOffsetMap offsetMap$4, int k) {
        expectedKeysAfterCleaning$1.$plus$eq(allKeys$1.apply(k - 1));
        offsetMap$4.put($this.key(BoxesRunTime.unboxToLong((Object)allKeys$1.apply(k))), Long.MAX_VALUE);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        void augmentString_x;
        Assert.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        String string = TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2());
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long value = new StringOps((String)augmentString_x).toLong();
        Assert.assertEquals((long)record.offset(), (long)value);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        void augmentString_x;
        long offset = logEntry.offset();
        String string = TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2());
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        long value = new StringOps((String)augmentString_x).toLong();
        Assert.assertEquals((long)offset, (long)value);
    }

    public static final /* synthetic */ int kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1() {
        return 999;
    }

    private final void checkGauge$1(String name, LogCleaner logCleaner$1) {
        Gauge gauge = logCleaner$1.newGauge(name, (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerTest $outer;

            public final int value() {
                return LogCleanerTest.kafka$log$LogCleanerTest$$$anonfun$testMaxCleanTimeSecs$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, logCleaner$1.newGauge$default$3());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToInt((Object)gauge.value()));
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$13, Tuple2 x$23) {
        if (x$23 != null) {
            Tuple2 tuple2 = (Tuple2)x$23._1();
            long offset = x$23._2$mcJ$sp();
            if (tuple2 != null) {
                int key = tuple2._1$mcI$sp();
                int value = tuple2._2$mcI$sp();
                return log$13.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
            }
        }
        throw new MatchError((Object)x$23);
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$25) {
    }

    public static final /* synthetic */ boolean $anonfun$writeToLog$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$14, Tuple2 x$26) {
        if (x$26 != null) {
            int key = x$26._1$mcI$sp();
            int value = x$26._2$mcI$sp();
            return BoxesRunTime.unboxToLong((Object)log$14.appendAsLeader($this.record(key, value, $this.record$default$3(), $this.record$default$4(), $this.record$default$5(), $this.record$default$6()), 0, log$14.appendAsLeader$default$3(), log$14.appendAsLeader$default$4()).firstOffset().get());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = Integer.toString(key).getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Long.toString(Long.MAX_VALUE));
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        double x$1 = Double.MAX_VALUE;
        long x$2 = Long.MAX_VALUE;
        MockTime x$3 = this.time();
        boolean x$4 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$5 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$6 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$1, x$2, x$4, x$5, x$6, (Time)x$3);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleaningWithDeletes$1$adapted(LogCleanerTest $this, Log log$6, Object key) {
        return log$6.appendAsLeader($this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogToClean$2$adapted(Log log$8, Object _) {
        return log$8.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log$8.appendAsLeader$default$3(), log$8.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogToCleanWithUncleanableSection$2$adapted(Log log$9, Object _) {
        return log$9.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log$9.appendAsLeader$default$3(), log$9.appendAsLeader$default$4());
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$1$adapted(Seq x$15) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$15));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$2$adapted(Seq x$16) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$16));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGroupingWithSparseOffsets$1$adapted(Seq group) {
        LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1$adapted(Seq group) {
        LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
        return BoxedUnit.UNIT;
    }
}

