/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AppendOrigin;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]4AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0004/\u0001\t\u0007I\u0011\u0001\u0013\t\r=\u0002\u0001\u0015!\u0003&\u0011\u001d\u0001\u0004A1A\u0005\u0002EBa\u0001\u000f\u0001!\u0002\u0013\u0011\u0004bB\u001d\u0001\u0005\u0004%\tA\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001e\t\u0013\t\u0003\u0001\u0019!a\u0001\n\u0003\u0019\u0005\"C%\u0001\u0001\u0004\u0005\r\u0011\"\u0001K\u0011%\u0001\u0006\u00011A\u0001B\u0003&A\tC\u0003R\u0001\u0011\u0005!\u000bC\u0003]\u0001\u0011\u0005!\u000bC\u0003b\u0001\u0011\u0005!\u000bC\u0003g\u0001\u0011\u0005!\u000bC\u0003i\u0001\u0011\u0005!KA\u0006SKBd\u0017nY1UKN$(B\u0001\u000b\u0016\u0003\u001d\u0019G.^:uKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003M\ta\u0001^7q\t&\u0014X#A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013AA5p\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0003kU\tQ!\u001e;jYNL!a\u000e\u001b\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u000b\u0002\rM,'O^3s\u0013\t\u0001UH\u0001\tCe>\\WM\u001d+pa&\u001c7\u000b^1ug\u0006\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\u0002\u00071|w-F\u0001E!\t)u)D\u0001G\u0015\t\u0011U#\u0003\u0002I\r\n\u0019Aj\\4\u0002\u000f1|wm\u0018\u0013fcR\u00111J\u0014\t\u000351K!!T\u000e\u0003\tUs\u0017\u000e\u001e\u0005\b\u001f.\t\t\u00111\u0001E\u0003\rAH%M\u0001\u0005Y><\u0007%A\u0003tKR,\b\u000fF\u0001LQ\tiA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006)!.\u001e8ji*\t\u0011,A\u0002pe\u001eL!a\u0017,\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007F\u0001\b_!\t)v,\u0003\u0002a-\n)\u0011I\u001a;fe\u0006\u0011D/Z:u'\u0016<W.\u001a8u\t\u0016dW\r^5p]^KG\u000f\u001b%jO\"<\u0016\r^3s[\u0006\u00148.\u00138ji&\fG.\u001b>bi&|g\u000e\u000b\u0002\u0010GB\u0011Q\u000bZ\u0005\u0003KZ\u0013A\u0001V3ti\u0006qC/Z:u\u0007\u0006tgn\u001c;EK2,G/Z*fO6,g\u000e^:Bi>\u0013\u0018IY8wK\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\t\u00012-\u0001\u001auKN$8)\u00198o_RLen\u0019:f[\u0016tG\u000fT8h'R\f'\u000f^(gMN,G\u000fU1ti\"Kw\r[,bi\u0016\u0014X.\u0019:lQ\u0011\t2M[6\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013\u0001\u001c\t\u0003[Vl\u0011A\u001c\u0006\u0003_B\fa!\u001a:s_J\u001c(BA9s\u0003\u0019\u0019w.\\7p]*\u0011ac\u001d\u0006\u0003ib\u000ba!\u00199bG\",\u0017B\u0001<o\u0005eyeMZ:fi>+Ho\u00144SC:<W-\u0012=dKB$\u0018n\u001c8")
public class ReplicaTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private Log log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Log log() {
        return this.log;
    }

    public void log_$eq(Log x$1) {
        this.log = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.log_$eq(Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.time().scheduler(), this.brokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10)));
    }

    @After
    public void tearDown() {
        this.log().close();
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentDeletionWithHighWatermarkInitialization() {
        void intWrapper_x;
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 100);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                ReplicaTest.$anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(this, expiredTimestamp, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        long initialHighWatermark = this.log().updateHighWatermark(25L);
        Assert.assertEquals((long)25L, (long)initialHighWatermark);
        int initialNumSegments = this.log().numberOfSegments();
        this.log().deleteOldSegments();
        Assert.assertTrue((this.log().numberOfSegments() < initialNumSegments ? 1 : 0) != 0);
        Assert.assertTrue((this.log().logStartOffset() <= initialHighWatermark ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCannotDeleteSegmentsAtOrAboveHighWatermark() {
        void intWrapper_x;
        long expiredTimestamp = this.time().milliseconds() - 1000L;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(this, expiredTimestamp, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        Assert.assertTrue((this.log().numberOfSegments() > 5 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.log().highWatermark());
        Assert.assertEquals((long)0L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)100L, (long)this.log().logEndOffset());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x, 100);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$2(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)100L, (long)this.log().logStartOffset());
        Assert.assertEquals((long)1L, (long)this.log().numberOfSegments());
        Assert.assertEquals((long)0L, (long)this.log().activeSegment().size());
    }

    @Test(expected=OffsetOutOfRangeException.class)
    public void testCannotIncrementLogStartOffsetPastHighWatermark() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                ReplicaTest.$anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(this, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        this.log().updateHighWatermark(25L);
        this.log().maybeIncrementLogStartOffset(26L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testSegmentDeletionWithHighWatermarkInitialization$1(ReplicaTest $this, long expiredTimestamp$1, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, expiredTimestamp$1, x$5);
        Log qual$1 = $this.log();
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(records, x$7, x$8, x$9);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1(ReplicaTest $this, long expiredTimestamp$2, int i) {
        byte[] x$1 = new StringBuilder(4).append("test").append(i).toString().getBytes();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, expiredTimestamp$2, x$5);
        Log qual$1 = $this.log();
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(records, x$7, x$8, x$9);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assert.assertTrue((segment.baseOffset() <= (long)hw$1 ? 1 : 0) != 0);
        Assert.assertTrue((segment.baseOffset() >= $this.log().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4(ReplicaTest $this, int hw$1, LogSegment segment) {
        Assert.assertTrue((segment.baseOffset() > (long)hw$1 ? 1 : 0) != 0);
        Assert.assertTrue((segment.baseOffset() >= $this.log().logStartOffset() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$2(ReplicaTest $this, int hw) {
        $this.log().updateHighWatermark((long)hw);
        Assert.assertEquals((long)hw, (long)$this.log().highWatermark());
        $this.log().deleteOldSegments();
        Assert.assertTrue(($this.log().logStartOffset() <= (long)hw ? 1 : 0) != 0);
        Option option = $this.log().logSegments().headOption();
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            LogSegment logSegment = (LogSegment)foreach_this.get();
            ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3($this, hw, logSegment);
        }
        ((IterableLike)$this.log().logSegments().tail()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$4($this, hw, segment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1(ReplicaTest $this, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(4).append("test").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log qual$1 = $this.log();
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        return qual$1.appendAsLeader(records, x$2, x$3, x$4);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testSegmentDeletionWithHighWatermarkInitialization$1$adapted(ReplicaTest $this, long expiredTimestamp$1, Object i) {
        return ReplicaTest.$anonfun$testSegmentDeletionWithHighWatermarkInitialization$1($this, expiredTimestamp$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1$adapted(ReplicaTest $this, long expiredTimestamp$2, Object i) {
        return ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$1($this, expiredTimestamp$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1$adapted(ReplicaTest $this, Object i) {
        return ReplicaTest.$anonfun$testCannotIncrementLogStartOffsetPastHighWatermark$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3$adapted(ReplicaTest $this, int hw$1, LogSegment segment) {
        ReplicaTest.$anonfun$testCannotDeleteSegmentsAtOrAboveHighWatermark$3($this, hw$1, segment);
        return BoxedUnit.UNIT;
    }
}

