/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rUb!\u0002.\\\u0003\u0003\u0001\u0007\"\u00025\u0001\t\u0003I\u0007bB6\u0001\u0005\u0004%\t\u0005\u001c\u0005\u0007g\u0002\u0001\u000b\u0011B7\t\u000bQ\u0004A\u0011I;\t\u000fe\u0004!\u0019!C\u0001Y\"1!\u0010\u0001Q\u0001\n5Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\f\u0001\u0001\u000b\u0011B?\t\u0013\u00055\u0001A1A\u0005\u0002\u0005=\u0001\u0002CA\u0013\u0001\u0001\u0006I!!\u0005\t\u0011\u0005\u001d\u0002A1A\u0005\u0002qDq!!\u000b\u0001A\u0003%Q\u0010C\u0005\u0002,\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0006\u0001!\u0002\u0013\t\t\u0002\u0003\u0005\u00020\u0001\u0011\r\u0011\"\u0001}\u0011\u001d\t\t\u0004\u0001Q\u0001\nuD\u0001\"a\r\u0001\u0005\u0004%\t\u0001\u001c\u0005\b\u0003k\u0001\u0001\u0015!\u0003n\u0011%\t9\u0004\u0001b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA\u001e\u0011)\t\u0019\u0006\u0001EC\u0002\u0013E\u0013Q\u000b\u0005\b\u0003S\u0002A\u0011CA6\u0011%\tY\t\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAH\u0011%\ti\n\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAH\u0011%\t\t\u000b\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAH\u0011%\t)\u000b\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAH\u0011%\tI\u000b\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u0002,\u0002\u0001\u000b\u0011BAH\u0011%\ti\u000b\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAH\u0011%\t\t\f\u0001b\u0001\n\u0003\ti\t\u0003\u0005\u00024\u0002\u0001\u000b\u0011BAH\u0011\u001d\t)\f\u0001D\u0001\u0003oCq!!3\u0001\r\u0003\t9\fC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005U\u0007\u0001\"\u0001\u0002N\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAo\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003?\u0004A\u0011AAg\u0011\u001d\t\t\u000f\u0001C\u0001\u0003\u001bDq!a9\u0001\t\u0003\t)\u000fC\u0004\u0002j\u0002!\t!!4\t\u000f\u0005-\b\u0001\"\u0001\u0002N\"9\u0011Q\u001e\u0001\u0005\u0002\u00055\u0007bBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005\u001f\u0001A\u0011AAy\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003cDqAa\u0005\u0001\t\u0003\t\t\u0010C\u0004\u0003\u0016\u0001!\t!!=\t\u000f\t]\u0001\u0001\"\u0001\u0002r\"9!\u0011\u0004\u0001\u0005\u0002\u0005E\bB\u0002B\u000e\u0001\u0011\u0005S\u000f\u0003\u0004\u0003,\u0001!\t%\u001e\u0005\u0007\u0005k\u0001A\u0011A;\t\r\t}\u0002\u0001\"\u0005v\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BaAa\u001a\u0001\t\u0003)\bB\u0002B6\u0001\u0011\u0005Q\u000f\u0003\u0004\u0003p\u0001!\t!\u001e\u0005\u0007\u0005g\u0002A\u0011A;\t\r\t]\u0004\u0001\"\u0003v\u0011\u0019\u0011I\b\u0001C\u0005k\"9!1\u0010\u0001\u0005\n\tu\u0004b\u0002BA\u0001\u0011E!1\u0011\u0005\u0007\u0005\u000f\u0003A\u0011B;\t\r\t%\u0005\u0001\"\u0001v\u0011\u0019\u0011i\t\u0001C\u0001k\"1!\u0011\u0013\u0001\u0005\u0002UDaAa(\u0001\t\u0003)\bB\u0002BR\u0001\u0011%Q\u000f\u0003\u0004\u0003&\u0002!\t!\u001e\u0005\u0007\u0005S\u0003A\u0011A;\t\r\t5\u0006\u0001\"\u0003v\u0011\u0019\u0011y\u000b\u0001C\u0001k\"9!1\u0017\u0001\u0005\u0016\tU\u0006b\u0002Bk\u0001\u0011U!q\u001b\u0005\n\u0005w\u0004\u0011\u0013!C\u000b\u0005{D\u0011ba\u0005\u0001#\u0003%)B!@\t\u0013\rU\u0001!%A\u0005\u0016\r]\u0001\"CB\u000e\u0001E\u0005IQ\u0003B\u007f\u0011%\u0019i\u0002AI\u0001\n+\u0019y\u0002C\u0004\u0004$\u0001!Ia!\n\t\u0013\r=\u0002!%A\u0005\n\tu\b\"CB\u0019\u0001E\u0005I\u0011\u0002B\u007f\u0011%\u0019\u0019\u0004AI\u0001\n\u0013\u00199BA\rF]\u0012$v.\u00128e\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8UKN$(B\u0001/^\u0003\r\t\u0007/\u001b\u0006\u0002=\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001bKB\u0011!mY\u0007\u00027&\u0011Am\u0017\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tgB\u0011!MZ\u0005\u0003On\u0013\u0011bU1tYN+G/\u001e9\u0002\rqJg.\u001b;?)\u0005Q\u0007C\u00012\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u00035\u0004\"A\\9\u000e\u0003=T\u0011\u0001]\u0001\u0006g\u000e\fG.Y\u0005\u0003e>\u00141!\u00138u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\r\u001awN\u001c4jOV\u0014XmU3dkJLG/\u001f\"fM>\u0014XmU3sm\u0016\u00148o\u0015;beR$\u0012A\u001e\t\u0003]^L!\u0001_8\u0003\tUs\u0017\u000e^\u0001\u000b]Vl'+Z2pe\u0012\u001c\u0018a\u00038v[J+7m\u001c:eg\u0002\n1b\u001a:pkB\u0004&/\u001a4jqV\tQ\u0010E\u0002\u007f\u0003\u000fi\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003mC:<'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0007\u0005%qP\u0001\u0004TiJLgnZ\u0001\rOJ|W\u000f\u001d)sK\u001aL\u0007\u0010I\u0001\u0006OJ|W\u000f]\u000b\u0003\u0003#\u0001B!a\u0005\u0002\"9!\u0011QCA\u000f!\r\t9b\\\u0007\u0003\u00033Q1!a\u0007`\u0003\u0019a$o\\8u}%\u0019\u0011qD8\u0002\rA\u0013X\rZ3g\u0013\u0011\tI!a\t\u000b\u0007\u0005}q.\u0001\u0004he>,\b\u000fI\u0001\fi>\u0004\u0018n\u0019)sK\u001aL\u00070\u0001\u0007u_BL7\r\u0015:fM&D\b%A\u0003u_BL7-\u0001\u0004u_BL7\rI\u0001\to&dGmY1sI\u0006Iq/\u001b7eG\u0006\u0014H\rI\u0001\u0005a\u0006\u0014H/A\u0003qCJ$\b%\u0001\u0002uaV\u0011\u00111\b\t\u0005\u0003{\ti%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0019\u0019w.\\7p]*\u0019a,!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0013aA8sO&!\u0011qJA \u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1\u0001\u001e9!\u00039!(/^:u'R|'/\u001a$jY\u0016,\"!a\u0016\u0011\u000b9\fI&!\u0018\n\u0007\u0005msN\u0001\u0003T_6,\u0007\u0003BA0\u0003Kj!!!\u0019\u000b\t\u0005\r\u00141A\u0001\u0003S>LA!a\u001a\u0002b\t!a)\u001b7f\u0003=\tW\u000f\u001e5pe&TXM]\"mCN\u001cXCAA7a\u0011\ty'!\u001f\u0011\r\u0005M\u0011\u0011OA;\u0013\u0011\t\u0019(a\t\u0003\u000b\rc\u0017m]:\u0011\t\u0005]\u0014\u0011\u0010\u0007\u0001\t-\tYHFA\u0001\u0002\u0003\u0015\t!! \u0003\u0007}#\u0013'\u0005\u0003\u0002\u0000\u0005\u0015\u0005c\u00018\u0002\u0002&\u0019\u00111Q8\u0003\u000f9{G\u000f[5oOB\u0019a.a\"\n\u0007\u0005%uNA\u0002B]f\fQ\u0002^8qS\u000e\u0014Vm]8ve\u000e,WCAAH!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003\u007f\t\u0001B]3t_V\u00148-Z\u0005\u0005\u00033\u000b\u0019JA\bSKN|WO]2f!\u0006$H/\u001a:o\u00039!x\u000e]5d%\u0016\u001cx.\u001e:dK\u0002\nQb\u001a:pkB\u0014Vm]8ve\u000e,\u0017AD4s_V\u0004(+Z:pkJ\u001cW\rI\u0001\u0010G2,8\u000f^3s%\u0016\u001cx.\u001e:dK\u0006\u00012\r\\;ti\u0016\u0014(+Z:pkJ\u001cW\rI\u0001\u0016aJ,g-\u001b=fIR{\u0007/[2SKN|WO]2f\u0003Y\u0001(/\u001a4jq\u0016$Gk\u001c9jGJ+7o\\;sG\u0016\u0004\u0013!\u00069sK\u001aL\u00070\u001a3He>,\bOU3t_V\u00148-Z\u0001\u0017aJ,g-\u001b=fI\u001e\u0013x.\u001e9SKN|WO]2fA\u0005)r/\u001b7eG\u0006\u0014H\rV8qS\u000e\u0014Vm]8ve\u000e,\u0017AF<jY\u0012\u001c\u0017M\u001d3U_BL7MU3t_V\u00148-\u001a\u0011\u0002+]LG\u000eZ2be\u0012<%o\\;q%\u0016\u001cx.\u001e:dK\u00061r/\u001b7eG\u0006\u0014Hm\u0012:pkB\u0014Vm]8ve\u000e,\u0007%A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m+\t\tI\f\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u0007\fy$\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t9-!0\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006q1.\u00194lCB\u0013\u0018N\\2ja\u0006d\u0017!E2mkN$XM]!di&|g.\u0011:hgV\u0011\u0011q\u001a\t\u0006]\u0006E\u0017\u0011C\u0005\u0004\u0003'|'!B!se\u0006L\u0018A\u0006;pa&\u001c'I]8lKJ\u0014V-\u00193BG2\f%oZ:\u0002\u001dA\u0014x\u000eZ;dK\u0006\u001bG.\u0011:hgR!\u0011qZAn\u0011\u001d\tY#\u000ba\u0001\u0003#\tq\u0002Z3tGJL'-Z!dY\u0006\u0013xm]\u0001\u0016I\u0016dW\r^3EKN\u001c'/\u001b2f\u0003\u000ed\u0017I]4t\u0003I!W\r\\3uK^\u0013\u0018\u000e^3BG2\f%oZ:\u0002\u001d\r|gn];nK\u0006\u001bG.\u0011:hgR!\u0011qZAt\u0011\u001d\tY#\fa\u0001\u0003#\tAb\u001a:pkB\f5\r\\!sON\fQ\u0004\u001d:pIV\u001cWmQ8ogVlWmV5mI\u000e\f'\u000fZ!dY\u0006\u0013xm]\u0001\u001faJ|G-^2f\u0007>t7/^7f!J,g-\u001b=fI\u0006\u001bGn]!sON\f\u0001c\u00117vgR,'/Q2uS>t\u0017i\u00197\u0016\u0005\u0005M\bCBA{\u0003\u007f\u0014\u0019!\u0004\u0002\u0002x*!\u0011\u0011`A~\u0003%IW.\\;uC\ndWMC\u0002\u0002~>\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\t!a>\u0003\u0007M+G\u000f\u0005\u0003\u0003\u0006\t-QB\u0001B\u0004\u0015\u0011\u0011I!a\u0010\u0002\u0007\u0005\u001cG.\u0003\u0003\u0003\u000e\t\u001d!AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\f!\u0003V8qS\u000e\u0014%o\\6feJ+\u0017\rZ!dY\u0006aqI]8vaJ+\u0017\rZ!dY\u0006aAk\u001c9jGJ+\u0017\rZ!dY\u0006iAk\u001c9jG^\u0013\u0018\u000e^3BG2\f\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\u0002\u001dQ{\u0007/[2De\u0016\fG/Z!dY\u0006)1/\u001a;Va\"\u001a\u0001Ha\b\u0011\t\t\u0005\"qE\u0007\u0003\u0005GQAA!\n\u0002J\u0005)!.\u001e8ji&!!\u0011\u0006B\u0012\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002:\u0005_\u0001BA!\t\u00032%!!1\u0007B\u0012\u0005\u0015\te\r^3s\u0003m!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3WS\u0006\f5o]5h]\"\u001a!H!\u000f\u0011\t\t\u0005\"1H\u0005\u0005\u0005{\u0011\u0019C\u0001\u0003UKN$\u0018AH2p]\u001aL'/\u001c*fCV$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$(/[2t\u0003!9W\r^$bk\u001e,G\u0003\u0002B#\u0005G\u0002bAa\u0012\u0003Z\tuSB\u0001B%\u0015\u0011\u0011YE!\u0014\u0002\t\r|'/\u001a\u0006\u0005\u0005\u001f\u0012\t&A\u0004nKR\u0014\u0018nY:\u000b\t\tM#QK\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\t]\u0013aA2p[&!!1\fB%\u0005\u00159\u0015-^4f!\rq'qL\u0005\u0004\u0005Cz'A\u0002#pk\ndW\rC\u0004\u0003fq\u0002\r!!\u0005\u0002\u00155,GO]5d\u001d\u0006lW-\u0001\u0010uKN$\bK]8ek\u000e,7i\u001c8tk6,g+[1Tk\n\u001c8M]5cK\"\u001aQH!\u000f\u0002EQ,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.Z,ji\"<\u0016\u000e\u001c3dCJ$\u0017i\u00197tQ\rq$\u0011H\u0001#i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlWmV5uQB\u0013XMZ5yK\u0012\f5\r\\:)\u0007}\u0012I$A\u0018uKN$\bK]8ek\u000e,7i\u001c8tk6,Gk\u001c9jG\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e\u001c%/Z1uK\u0006\u001bG\u000eK\u0002A\u0005s\tqc]3u/&dGmY1sIJ+7o\\;sG\u0016\f5\r\\:\u0002/M,G\u000f\u0015:fM&DX\r\u001a*fg>,(oY3BG2\u001c\u0018aE:fiJ+\u0017\rZ!oI^\u0013\u0018\u000e^3BG2\u001cHc\u0001<\u0003\u0000!9\u0011qG\"A\u0002\u0005m\u0012!E:fi\u0006\u001bGn]!oIB\u0013x\u000eZ;dKR\u0019aO!\"\t\u000f\u0005]B\t1\u0001\u0002<\u0005!2/\u001a;D_:\u001cX/\\3s\u000fJ|W\u000f]!dYN\fQ\u0007^3ti:{G)Z:de&\u0014W\r\u0015:pIV\u001cWm\u0014:D_:\u001cX/\\3XSRDw.\u001e;U_BL7\rR3tGJL'-Z!dY\"\u001aaI!\u000f\u00029Q,7\u000f\u001e(p!J|G-^2f/&$\b\u000eR3tGJL'-Z!dY\"\u001aqI!\u000f\u0002QQ,7\u000f\u001e(p\u0007>t7/^7f/&$\bn\\;u\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\u000f!\u0013ID!&\u0003\u0018\u0006AQ\r\u001f9fGR,Gm\t\u0002\u0003\u001aB!\u0011Q\bBN\u0013\u0011\u0011i*a\u0010\u0003\u001d-\u000bgm[1Fq\u000e,\u0007\u000f^5p]\u0006YC/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197WS\u0006\u001cVOY:de&\u0014W\rK\u0002J\u0005s\t\u0001E\\8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\u0006)C/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\u0004\u0017\ne\u0012\u0001\u000b;fgRtunQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007f\u0001'\u0003:\u0005ibn\\\"p]N,X.Z,ji\"$Um]2sS\n,\u0017i\u00197TKR,\b/\u0001\buKN$hj\\$s_V\u0004\u0018i\u00197)\u00079\u0013I$A\u0006tK:$'+Z2pe\u0012\u001cHc\u0002<\u00038\nE'1\u001b\u0005\b\u0005s{\u0005\u0019\u0001B^\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003B_\u0005\u000b\u0014IM!3\u000e\u0005\t}&\u0002\u0002B]\u0005\u0003TAAa1\u0002D\u000591\r\\5f]R\u001c\u0018\u0002\u0002Bd\u0005\u007f\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#\u00028\u0002R\n-\u0007c\u00018\u0003N&\u0019!qZ8\u0003\t\tKH/\u001a\u0005\u0006s>\u0003\r!\u001c\u0005\b\u0003oy\u0005\u0019AA\u001e\u00039\u0019wN\\:v[\u0016\u0014VmY8sIN$RB\u001eBm\u0005O\u0014IO!<\u0003p\nE\bb\u0002Bn!\u0002\u0007!Q\\\u0001\tG>t7/^7feBA!q\u001cBr\u0005\u0013\u0014I-\u0004\u0002\u0003b*!!1\u001cBa\u0013\u0011\u0011)O!9\u0003\u0011\r{gn];nKJDq!\u001f)\u0011\u0002\u0003\u0007Q\u000e\u0003\u0005\u0003lB\u0003\n\u00111\u0001n\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRD\u0011\"a\u000bQ!\u0003\u0005\r!!\u0005\t\u0011\u0005M\u0002\u000b%AA\u00025D\u0011Ba=Q!\u0003\u0005\rA!>\u0002\u000fQLW.Z8viB\u0019aNa>\n\u0007\texN\u0001\u0003M_:<\u0017\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q \u0016\u0004[\u000e\u00051FAB\u0002!\u0011\u0019)aa\u0004\u000e\u0005\r\u001d!\u0002BB\u0005\u0007\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r5q.\u0001\u0006b]:|G/\u0019;j_:LAa!\u0005\u0004\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"a!\u0007+\t\u0005E1\u0011A\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111\u0011\u0005\u0016\u0005\u0005k\u001c\t!A\u0017d_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0012B^B\u0014\u0007S\u0019Yc!\f\t\u000f\tmg\u000b1\u0001\u0003^\"9\u0011P\u0016I\u0001\u0002\u0004i\u0007\u0002\u0003Bv-B\u0005\t\u0019A7\t\u0013\u0005-b\u000b%AA\u0002\u0005E\u0011aN2p]N,X.\u001a*fG>\u0014Hm]%h]>\u0014Xm\u00148f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$#'A\u001cd_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$C-\u001a4bk2$HeM\u00018G>t7/^7f%\u0016\u001cwN\u001d3t\u0013\u001etwN]3P]\u0016\fU\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000f\n\u001b")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final ResourcePattern topicResource;
    private final ResourcePattern groupResource;
    private final ResourcePattern clusterResource;
    private final ResourcePattern prefixedTopicResource;
    private final ResourcePattern prefixedGroupResource;
    private final ResourcePattern wildcardTopicResource;
    private final ResourcePattern wildcardGroupResource;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    public Class<?> authorizerClass() {
        return AclAuthorizer.class;
    }

    public ResourcePattern topicResource() {
        return this.topicResource;
    }

    public ResourcePattern groupResource() {
        return this.groupResource;
    }

    public ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    public ResourcePattern prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public ResourcePattern prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public ResourcePattern wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public ResourcePattern wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public abstract KafkaPrincipal clientPrincipal();

    public abstract KafkaPrincipal kafkaPrincipal();

    public String[] clusterActionArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()});
    }

    public String[] topicBrokerReadAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipal()).toString()});
    }

    public String[] produceAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] describeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteDescribeAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] deleteWriteAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] consumeAclArgs(String topic) {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] groupAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumeWildcardAclArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return (String[])((Object[])new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipal()).toString()});
    }

    public scala.collection.immutable.Set<AccessControlEntry> ClusterActionAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicBrokerReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> GroupReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicReadAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicWriteAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicDescribeAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)}));
    }

    public scala.collection.immutable.Set<AccessControlEntry> TopicCreateAcl() {
        return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW)}));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Should have been zero expired connections killed total", (double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        Option option = ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, x0$1)))).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }
        return (Gauge)((Tuple2)getOrElse_this.get())._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int x$4 = this.consumeRecords$default$3();
        int x$5 = this.consumeRecords$default$5();
        long x$6 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, x$4, x$3, x$5, x$6);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setReadAndWriteAcls(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setReadAndWriteAcls$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        this.setReadAndWriteAcls(tp);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    private void setConsumerGroupAcls() {
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl() {
        this.setConsumerGroupAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int x$2 = this.numRecords();
            String x$3 = this.tp().topic();
            int x$4 = this.consumeRecords$default$3();
            int x$5 = this.consumeRecords$default$5();
            long x$6 = this.consumeRecords$default$6();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, x$4, x$3, x$5, x$6);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ExecutionException e1 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Map)adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause()).toString(), (boolean)(e1.getCause() instanceof TopicAuthorizationException));
        String topic2 = "topic2";
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.setReadAndWriteAcls(tp2);
        this.sendRecords(producer, this.numRecords(), tp2);
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$8 = this.numRecords();
        int x$10 = this.consumeRecords$default$3();
        int x$11 = this.consumeRecords$default$5();
        long x$12 = this.consumeRecords$default$6();
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$8, x$10, topic2, x$11, x$12);
        Map describeResults = adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults.get(topic2)).get()).partitions().size());
        ExecutionException e2 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (Map)adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava()).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause()).toString(), (boolean)(e2.getCause() instanceof TopicAuthorizationException));
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        this.sendRecords(producer, this.numRecords(), tp2);
        BooleanRef topic2RecordConsumed = BooleanRef.create((boolean)false);
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void pollRecordsUntilTrue_action;
            long l = TestUtils$.MODULE$.pollRecordsUntilTrue$default$4();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)records -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.verifyNoRecords$1(records, tp2, topic2RecordConsumed));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long pollRecordsUntilTrue_x$3 = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1((Consumer)consumer, (Function1)pollRecordsUntilTrue_action)) {
                void pollRecordsUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + pollRecordsUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(EndToEndAuthorizationTest.$anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)pollRecordsUntilTrue_waitTimeMs, pollRecordsUntilTrue_x$3));
            }
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.setReadAndWriteAcls(this.tp());
        if (!topic2RecordConsumed.elem) {
            this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 1, topic2);
        }
        this.sendRecords(producer, this.numRecords(), this.tp());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic());
        Map describeResults2 = adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2}))).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(this.topic())).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(topic2)).get()).partitions().size());
    }

    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw Assertions$.MODULE$.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$2 = 3000L;
            int x$3 = this.consumeRecords$default$2();
            int x$4 = this.consumeRecords$default$3();
            String x$5 = this.consumeRecords$default$4();
            int x$6 = this.consumeRecords$default$5();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$3, x$4, x$5, x$6, x$2);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.setReadAndWriteAcls(this.tp());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$))).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            long x$8 = 3000L;
            int x$9 = this.consumeRecords$default$2();
            int x$10 = this.consumeRecords$default$3();
            String x$11 = this.consumeRecords$default$4();
            int x$12 = this.consumeRecords$default$5();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$9, x$10, x$11, x$12, x$8);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.consumeRecordsIgnoreOneAuthorizationException$default$2(), this.consumeRecordsIgnoreOneAuthorizationException$default$3(), this.consumeRecordsIgnoreOneAuthorizationException$default$4());
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        }
        catch (TopicAuthorizationException e) {
            Assert.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)this.TopicWriteAcl().$plus$plus(this.TopicDescribeAcl()).$plus$plus(this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.consumeRecords$default$2(), this.consumeRecords$default$3(), this.consumeRecords$default$4(), this.consumeRecords$default$5(), this.consumeRecords$default$6());
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        try {
            void intWrapper_x;
            ((IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, numRecords).map((Function1 & Serializable & scala.Serializable)i -> EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        void intWrapper_x;
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, numRecords);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                EndToEndAuthorizationTest.$anonfun$consumeRecords$1(records, startingOffset, topic, part, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    private void consumeRecordsIgnoreOneAuthorizationException(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic) {
        try {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.consumeRecords$default$5(), this.consumeRecords$default$6());
            return;
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.consumeRecords$default$5(), this.consumeRecords$default$6());
            return;
        }
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$2() {
        return 1;
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$3() {
        return 0;
    }

    private String consumeRecordsIgnoreOneAuthorizationException$default$4() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.clusterResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue(s, "expired-connections-killed-count");
        Assert.assertTrue((String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString(), (numExpiredKilled == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assert.assertTrue((String)"failed re-authentications not 0", (TestUtils$.MODULE$.totalMetricValue(s, "failed-reauthentication-total") == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String string = ((MetricName)x0$1._1()).getName();
            return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl()).$plus$plus($this.TopicBrokerReadAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$setReadAndWriteAcls$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicReadAcl().$plus$plus($this.TopicWriteAcl()).$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, tp$1.topic(), PatternType.LITERAL), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    private static final boolean verifyNoRecords$1(ConsumerRecords records, TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1) {
        Assert.assertEquals((String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(records).toString(), Collections.singleton(tp2$1), (Object)records.partitions());
        topic2RecordConsumed$1.elem = true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$7() {
        return "Consumer didn't fail with authorization exception within timeout";
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)$this.TopicWriteAcl().$plus$plus($this.TopicDescribeAcl()).$plus$plus($this.TopicCreateAcl())), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource(), TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Predef$.MODULE$.int2Integer(tp$2.partition()), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$2.send(record);
    }

    public static final /* synthetic */ void $anonfun$consumeRecords$1(Seq records$1, int startingOffset$1, String topic$1, int part$1, int i) {
        ConsumerRecord record = (ConsumerRecord)records$1.apply(i);
        int offset = startingOffset$1 + i;
        Assert.assertEquals((Object)topic$1, (Object)record.topic());
        Assert.assertEquals((long)part$1, (long)record.partition());
        Assert.assertEquals((long)offset, (long)record.offset());
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new ResourcePattern(ResourceType.TOPIC, this.topic(), PatternType.LITERAL);
        this.groupResource = new ResourcePattern(ResourceType.GROUP, this.group(), PatternType.LITERAL);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.prefixedTopicResource = new ResourcePattern(ResourceType.TOPIC, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new ResourcePattern(ResourceType.GROUP, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new ResourcePattern(ResourceType.TOPIC, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new ResourcePattern(ResourceType.GROUP, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClass().getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
        this.consumerConfig().setProperty("metadata.max.age.ms", "1500");
    }
}

