/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug!B\u0012%\u0003\u0003I\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003F\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011C9\t\ri\u0004\u0001\u0015!\u0003s\u0011\u001dY\bA1A\u0005\nqDq!!\u0001\u0001A\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0006!9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0002\"CA-\u0001E\u0005I\u0011CA.\u0011%\t\t\bAI\u0001\n#\tY\u0006C\u0005\u0002t\u0001\t\n\u0011\"\u0005\u0002\\!I\u0011Q\u000f\u0001\u0012\u0002\u0013E\u0011q\u000f\u0005\n\u0003w\u0002\u0011\u0013!C\t\u0003{B\u0011\"!!\u0001#\u0003%\t\"! \t\u000f\u0005\r\u0005\u0001\"\u0005\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0001bBAJ\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003/\u0003A\u0011AA\u0003\u0011\u001d\tY\n\u0001C\t\u0003;C\u0011\"a*\u0001#\u0003%\t\"a\u0017\t\u0013\u0005%\u0006!%A\u0005\u0012\u0005u\u0004bBAV\u0001\u0011E\u0011Q\u0016\u0005\b\u0003\u000b\u0004A\u0011AA\u0003\u0011\u001d\tI\r\u0001C\u0001\u0003\u000bAq!!4\u0001\t\u0003\t)\u0001C\u0004\u0002R\u0002!\t!!\u0002\t\u000f\u0005U\u0007\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u001c\u0001\u0005\u0002\u0005\u0015!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00020Y\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00017!\r9DHP\u0007\u0002q)\u0011\u0011HO\u0001\u000bG>dG.Z2uS>t'\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uB$aA*fcB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0003%aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8ogVlWM]\u000b\u0002\rB!q\t\u0015*S\u001b\u0005A%B\u0001#J\u0015\tQ5*A\u0004dY&,g\u000e^:\u000b\u0005\u001db%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\r\u0019FKV\u0007\u0002u%\u0011QK\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'^K!\u0001\u0017\u001e\u0003\t\tKH/Z\u0001\rG>t7/^7fe~#S-\u001d\u000b\u00037z\u0003\"a\u0015/\n\u0005uS$\u0001B+oSRDqa\u0018\u0003\u0002\u0002\u0003\u0007a)A\u0002yIE\n\u0011bY8ogVlWM\u001d\u0011\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1\u0007(A\u0004nkR\f'\r\\3\n\u0005!,'A\u0002\"vM\u001a,'\u000f\u0005\u0003k[J\u0013V\"A6\u000b\u00051L\u0015\u0001\u00039s_\u0012,8-\u001a:\n\u00059\\'!D&bM.\f\u0007K]8ek\u000e,'/\u0001\u0006qe>$WoY3sg\u0002\nQ\u0001^8qS\u000e,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\u0005i\bCA*\u007f\u0013\ty(HA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005)1/\u001a;VaR\t1\fK\u0002\r\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001fq\u0015!\u00026v]&$\u0018\u0002BA\n\u0003\u001b\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u00075\tI\u0002\u0005\u0003\u0002\f\u0005m\u0011\u0002BA\u000f\u0003\u001b\u0011Q!\u00114uKJ\fab\u0019:fCR,\u0007K]8ek\u000e,'\u000fF\bj\u0003G\tY$a\u0010\u0002D\u0005\u001d\u00131JA+\u0011\u001d\t)C\u0004a\u0001\u0003O\t!B\u0019:pW\u0016\u0014H*[:u!\u0011\tI#a\u000e\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[QTBAA\u0018\u0015\r\t\t\u0004K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005U\"(\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u0006e\"bAA\u001bu!A\u0011Q\b\b\u0011\u0002\u0003\u0007Q0\u0001\u0005mS:<WM]'t\u0011!\t\tE\u0004I\u0001\u0002\u0004i\u0018!\u00053fY&4XM]=US6,w.\u001e;Ng\"A\u0011Q\t\b\u0011\u0002\u0003\u0007Q0A\u0005cCR\u001c\u0007nU5{K\"I\u0011\u0011\n\b\u0011\u0002\u0003\u0007\u0011qE\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qK\"I\u0011Q\n\b\u0011\u0002\u0003\u0007\u0011qJ\u0001\u000b[\u0006D(\t\\8dW6\u001b\bcA*\u0002R%\u0019\u00111\u000b\u001e\u0003\t1{gn\u001a\u0005\n\u0003/r\u0001\u0013!a\u0001\u0003\u001f\n!BY;gM\u0016\u00148+\u001b>f\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003;R3!`A0W\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA6u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0014Q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002z)\"\u0011qEA0\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u007fRC!a\u0014\u0002`\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014HcA5\u0002\b\")A.\u0006a\u0001S\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$\bf\u0001\f\u0002\u000eB!\u00111BAH\u0013\u0011\t\t*!\u0004\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0018\u0003\u001b\u000b!\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0019\u0003\u001b\u000bQb]3oI\u0006sGMV3sS\u001aLHcB.\u0002 \u0006\u0005\u00161\u0015\u0005\u0006Yf\u0001\r!\u001b\u0005\bwf\u0001\n\u00111\u0001~\u0011%\t)+\u0007I\u0001\u0002\u0004\ty%A\u0005uS6,w.\u001e;Ng\u000692/\u001a8e\u0003:$g+\u001a:jMf$C-\u001a4bk2$HEM\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIM\nac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u00067\u0006=\u0016\u0011\u0017\u0005\u0006Yr\u0001\r!\u001b\u0005\b\u0003gc\u0002\u0019AA[\u00035!\u0018.\\3ti\u0006l\u0007\u000fV=qKB!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016A\u0002:fG>\u0014HMC\u0002\u0002@.\u000baaY8n[>t\u0017\u0002BAb\u0003s\u0013Q\u0002V5nKN$\u0018-\u001c9UsB,\u0017!\u0003;fgR\u001cEn\\:fQ\ri\u0012QR\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0004=\u00055\u0015\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007fA\u0010\u0002\u000e\u0006IA/Z:u\r2,8\u000f\u001b\u0015\u0004A\u00055\u0015\u0001\u000b;fgR\u001cEn\\:f/&$\bNW3s_RKW.Z8vi\u001a\u0013x.\\\"bY2,'\u000f\u00165sK\u0006$\u0007fA\u0011\u0002\u000e\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7+\u001a8eKJ$\u0006N]3bI\"\u001a!%!$")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(4));
        String x$2 = this.zkConnect();
        boolean x$3 = false;
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, x$3, x$7, (Option<SecurityProtocol>)x$4, x$5, x$6, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        String x$3 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$11));
    }

    @Override
    @After
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        int x$12 = TestUtils$.MODULE$.createProducer$default$5();
        int x$13 = TestUtils$.MODULE$.createProducer$default$10();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, x$11, maxBlockMs, bufferSize, x$12, deliveryTimeoutMs, lingerMs, batchSize, compressionType, x$13, x$3, x$4, x$5, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public long createProducer$default$7() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assert.assertEquals((String)"Should have offset 1", (long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 2", (long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assert.assertEquals((String)"Should have offset 3", (long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            try {
                ProducerRecord record4 = new ProducerRecord(null, Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
                producer.send(record4, (Callback)this.callback$2(callback$module, partition));
                throw Assertions$.MODULE$.fail("Should not allow sending a record without topic", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void intWrapper_x;
                boolean bl = true;
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x, this.kafka$api$BaseProducerSendTest$$numRecords());
                if (inclusive == null) {
                    throw null;
                }
                Range.Inclusive foreach_this = inclusive;
                if (!foreach_this.isEmpty()) {
                    int foreach_i = foreach_this.start();
                    while (true) {
                        producer.send(record0, (Callback)this.callback$2(callback$module, partition));
                        if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                        foreach_i += foreach_this.step();
                    }
                }
                Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString(), (long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset());
            }
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$1 = this.brokerList();
        String x$2 = "gzip";
        int x$3 = Integer.MAX_VALUE;
        int x$4 = Integer.MAX_VALUE;
        int x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        long x$7 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$5, x$2, x$6, x$7);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    /*
     * WARNING - void declaration
     */
    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            void map_bf;
            void map_f;
            void intWrapper_x;
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            boolean bl = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x, numRecords);
            CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i));
            if (inclusive == null) {
                throw null;
            }
            IndexedSeq futures = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assert.assertEquals((long)numRecords, (long)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    /*
     * WARNING - void declaration
     */
    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            void map_bf;
            void map_f;
            void intWrapper_x;
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
            } else {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            }
            this.createTopic(this.topic(), 1, 2, topicProps);
            boolean bl = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x, this.kafka$api$BaseProducerSendTest$$numRecords());
            CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i));
            if (inclusive == null) {
                throw null;
            }
            IndexedSeq recordAndFutures = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset());
        }
        finally {
            producer.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            void intWrapper_x;
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            boolean bl = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x, this.kafka$api$BaseProducerSendTest$$numRecords());
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    producer.send(record0);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            Future response0 = producer.send(record0);
            producer.close();
            Assert.assertTrue((String)"The last message should be acked before producer is shutdown", (boolean)response0.isDone());
            Assert.assertEquals((String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString(), (long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            void intWrapper_x;
            void map_bf;
            void map_f;
            void intWrapper_x2;
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            boolean bl = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x2, this.kafka$api$BaseProducerSendTest$$numRecords());
            CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)));
            if (inclusive == null) {
                throw null;
            }
            boolean bl2 = false;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            ((TraversableLike)((IndexedSeq)((TraversableLike)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendToPartition$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$4);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
            ((IterableLike)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.consumeRecords$default$3()).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        void intWrapper_x;
        void map_bf;
        void map_f;
        void intWrapper_x2;
        String x$1 = this.brokerList();
        long x$2 = 5000L;
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        int x$52 = this.createProducer$default$4();
        String x$62 = this.createProducer$default$5();
        long x$72 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$52, x$62, x$2, x$72);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        boolean bl = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0((int)intWrapper_x2, this.kafka$api$BaseProducerSendTest$$numRecords());
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)));
        if (inclusive == null) {
            throw null;
        }
        boolean bl2 = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        ((TraversableLike)((IndexedSeq)((TraversableLike)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)).map((Function1 & Serializable & scala.Serializable)x$5 -> (RecordMetadata)x$5.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0((int)intWrapper_x, this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$6);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        try {
            producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get();
            throw Assertions$.MODULE$.fail("Should not allow sending a record to a partition not present in the metadata", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
        }
        catch (ExecutionException executionException) {
            void intWrapper_x3;
            void map_bf2;
            void map_f2;
            void intWrapper_x4;
            void intWrapper_x5;
            void map_bf3;
            void map_f3;
            void intWrapper_x6;
            Throwable throwable = executionException.getCause();
            if (!(throwable instanceof TimeoutException)) {
                throw new Exception("Sending to a partition not present in the metadata should result in a TimeoutException", throwable);
            }
            Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    void $minus$greater$extension_$this;
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    return new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom());
            AdminZkClient qual$1 = this.adminZkClient();
            String x$102 = this.topic();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$82 = qual$2.getBrokerMetadatas$default$1();
            Option x$92 = qual$2.getBrokerMetadatas$default$2();
            Seq x$12 = qual$2.getBrokerMetadatas(x$82, x$92);
            int x$13 = 2;
            Option x$14 = qual$1.addPartitions$default$5();
            boolean x$15 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$102, existingAssignment, x$12, x$13, x$14, x$15);
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            boolean bl3 = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive2 = RichInt$.MODULE$.to$extension0((int)intWrapper_x6, this.kafka$api$BaseProducerSendTest$$numRecords());
            CanBuildFrom canBuildFrom2 = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)));
            if (inclusive2 == null) {
                throw null;
            }
            boolean bl4 = false;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            ((TraversableLike)((IndexedSeq)((TraversableLike)TraversableLike.map$((TraversableLike)inclusive2, (Function1)map_f3, (CanBuildFrom)map_bf3)).map((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0((int)intWrapper_x5, this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$8(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$9(this, partition1, x$8);
                return BoxedUnit.UNIT;
            });
            boolean bl5 = true;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive3 = RichInt$.MODULE$.to$extension0((int)intWrapper_x4, this.kafka$api$BaseProducerSendTest$$numRecords());
            CanBuildFrom canBuildFrom3 = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)));
            if (inclusive3 == null) {
                throw null;
            }
            int n = this.kafka$api$BaseProducerSendTest$$numRecords();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            ((TraversableLike)((IndexedSeq)((TraversableLike)TraversableLike.map$((TraversableLike)inclusive3, (Function1)map_f2, (CanBuildFrom)map_bf2)).map((Function1 & Serializable & scala.Serializable)x$9 -> (RecordMetadata)x$9.get(30L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom())).zip((GenIterable)RichInt$.MODULE$.until$extension0((int)intWrapper_x3, 2 * this.kafka$api$BaseProducerSendTest$$numRecords()), IndexedSeq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$12(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$13(this, partition0, x$10);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            void intWrapper_x;
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            boolean bl = false;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, 50);
            if (range == null) {
                throw null;
            }
            Range foreach$mVc$sp_this = range;
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    BaseProducerSendTest.$anonfun$testFlush$1(this, producer, record, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i != foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) {
                        foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 50);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$1(this, record0, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), partition), (List)Nil$.MODULE$)).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 50);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assert.assertEquals((long)partition$2, (long)recordMetadata.partition());
        Assert.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assert.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assert.assertEquals((Object)record.timestamp(), (Object)BoxesRunTime.boxToLong((long)recordMetadata.timestamp()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendToPartition$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$4) {
        if (x$4 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$4._1();
            Assert.assertEquals((long)x$4._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition$4, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assert.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assert.assertEquals((long)partition$4, (long)record.partition());
            Assert.assertEquals((long)i, (long)record.offset());
            Assert.assertNull((Object)record.key());
            Assert.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assert.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$6) {
        if (x$6 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$6._1();
            Assert.assertEquals((long)x$6._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$8(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$9(BaseProducerSendTest $this, int partition1$1, Tuple2 x$8) {
        if (x$8 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$8._1();
            Assert.assertEquals((long)x$8._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition1$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testSendBeforeAndAfterPartitionExpansion$12(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$13(BaseProducerSendTest $this, int partition0$1, Tuple2 x$10) {
        if (x$10 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$10._1();
            Assert.assertEquals((long)x$10._2$mcI$sp(), (long)recordMetadata.offset());
            Assert.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assert.assertEquals((long)partition0$1, (long)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$12) {
        return !x$12.isDone();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testFlush$1(BaseProducerSendTest $this, KafkaProducer producer$7, ProducerRecord record$1, int _) {
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$11 -> producer$7.send(record$1), IndexedSeq$.MODULE$.canBuildFrom());
        Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$12))));
        producer$7.flush();
        Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isDone())));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        try {
            future.get();
            throw Assertions$.MODULE$.fail("No message should be sent successfully.", new Position("BaseProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        }
        catch (ExecutionException e) {
            Assert.assertEquals(KafkaException.class, e.getCause().getClass());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$1(BaseProducerSendTest $this, ProducerRecord record0$3, int _) {
        void intWrapper_x;
        KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6(), $this.createProducer$default$7());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)x$14 -> producer.send(record0$3), IndexedSeq$.MODULE$.canBuildFrom());
        Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$15))));
        producer.close(Duration.ZERO);
        responses.foreach((Function1 & Serializable & scala.Serializable)future -> {
            BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Fetch response should have no message returned.", (long)0L, (long)$this.consumer().poll(Duration.ofMillis(50L)).count());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    int n = 0;
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    Range range = RichInt$.MODULE$.until$extension0(n, this.$outer.kafka$api$BaseProducerSendTest$$numRecords());
                    if (range == null) {
                        throw null;
                    }
                    Range foreach_this = range;
                    if (!foreach_this.isEmpty()) {
                        int foreach_i = foreach_this.start();
                        while (true) {
                            Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, foreach_i);
                            if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                            foreach_i += foreach_this.step();
                        }
                    }
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$16) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1$adapted(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, Object x$16) {
                return Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1($this, BoxesRunTime.unboxToInt((Object)x$16));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$17) {
        return !x$17.isDone();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6(), $this.createProducer$default$7());){
            void intWrapper_x;
            boolean bl = false;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable & scala.Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)"No request is complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$17))));
            producer.flush();
            Assert.assertTrue((String)"All requests are complete.", (boolean)responses.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isDone())));
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }

    public static final /* synthetic */ Future $anonfun$testSendOffset$1$adapted(BaseProducerSendTest $this, KafkaProducer producer$1, ProducerRecord record0$1, LazyRef callback$module$1, int partition$1, Object _) {
        return producer$1.send(record0$1, (Callback)$this.callback$2(callback$module$1, partition$1));
    }

    public static final /* synthetic */ Future $anonfun$testClose$1$adapted(KafkaProducer producer$4, ProducerRecord record0$2, Object _) {
        return producer$4.send(record0$2);
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1$adapted(BaseProducerSendTest $this, ProducerRecord record$2, Object i) {
        return BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1($this, record$2, BoxesRunTime.unboxToInt((Object)i));
    }
}

