/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.RackAwareMode;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r)\u0003\u0001\u0015)\u00035\u0011\u001dY\u0005A1A\u0005\u00021Ca!\u0017\u0001!\u0002\u0013i\u0005b\u0002.\u0001\u0005\u0004%\ta\u0017\u0005\u0007G\u0002\u0001\u000b\u0011\u0002/\t\u000b\u0011\u0004A\u0011I3\t\u000b=\u0004A\u0011A3\t\u000bQ\u0004A\u0011A3\t\u000bY\u0004A\u0011A3\t\u000ba\u0004A\u0011A3\t\u000bi\u0004A\u0011B>\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u00111\n\u0001\u0005\n\u00055\u0003BBA+\u0001\u0011%Q\rC\u0004\u0002X\u0001!I!!\u0017\t\r\u0005U\u0004\u0001\"\u0001f\u0011\u0019\tI\b\u0001C\u0001K\"1\u0011Q\u0010\u0001\u0005\u0002\u0015Da!!!\u0001\t\u0003)\u0007BBAC\u0001\u0011\u0005Q\r\u0003\u0004\u0002\n\u0002!\t!\u001a\u0005\u0007\u0003\u001b\u0003A\u0011A3\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\"I\u0011q\u0017\u0001\u0012\u0002\u0013%\u0011\u0011\u0018\u0005\n\u0003\u001f\u0004\u0011\u0013!C\u0005\u0003#Dq!!%\u0001\t\u0013\t)\u000eC\u0004\u0002r\u0002!I!a=\t\r\t=\u0001\u0001\"\u0001f\u0011\u0019\u0011\u0019\u0002\u0001C\u0001K\nyA)\u001a7fi\u0016$v\u000e]5d)\u0016\u001cHO\u0003\u0002$I\u0005)\u0011\rZ7j]*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#BA\u0016%\u0003\tQ8.\u0003\u0002.U\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0019\u0011\u0005E\u0002Q\"\u0001\u0012\u0002\u000fM,'O^3sgV\tA\u0007E\u00026uqj\u0011A\u000e\u0006\u0003oa\n!bY8mY\u0016\u001cG/[8o\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e7\u0005\r\u0019V-\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\naa]3sm\u0016\u0014\u0018BA!?\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\t\"\u0003\"!\u0012$\u000e\u0003aJ!a\u0012\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b\u0013\u000e\t\t\u00111\u00015\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+\u0005i\u0005\u0003\u0002(R'Zk\u0011a\u0014\u0006\u0003!Z\n\u0011\"[7nkR\f'\r\\3\n\u0005I{%aA'baB\u0011Q\tV\u0005\u0003+b\u00121!\u00138u!\rqukU\u0005\u00031>\u0013A\u0001T5ti\u0006QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA\u0005iR\r\u001f9fGR,GMU3qY&\u001c\u0017MR;mY\u0006\u001b8/[4o[\u0016tG/F\u0001]!\u0011q\u0015kU/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0011!m\u0018\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018AH3ya\u0016\u001cG/\u001a3SKBd\u0017nY1Gk2d\u0017i]:jO:lWM\u001c;!\u0003!!X-\u0019:E_^tG#\u0001#)\u0005%9\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015QWO\\5u\u0015\u0005a\u0017aA8sO&\u0011a.\u001b\u0002\u0006\u0003\u001a$XM]\u0001$i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[!mY\u0006c\u0017N^3SKBd\u0017nY1tQ\tQ\u0011\u000f\u0005\u0002ie&\u00111/\u001b\u0002\u0005)\u0016\u001cH/\u0001\u0016uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2XSRD'+Z2pm\u0016\u0014X\r\u001a$pY2|w/\u001a:)\u0005-\t\u0018!\u000b;fgR\u0014Vm];nK\u0012+G.\u001a;f)>\u0004\u0018nY(o\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'\u000f\u000b\u0002\rc\u0006QC/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007FA\u0007r\u0003I9\u0018-\u001b;V]RLG\u000eV8qS\u000e<uN\\3\u0015\t\u0011c\u0018\u0011\u0003\u0005\u0006{:\u0001\rA`\u0001\fC\u0012l\u0017N\\\"mS\u0016tG\u000fE\u0002\u0000\u0003\u001bi!!!\u0001\u000b\u0007\r\n\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011aB2mS\u0016tGo\u001d\u0006\u0004K\u0005%!bAA\u0006W\u00061\u0011\r]1dQ\u0016LA!a\u0004\u0002\u0002\t)\u0011\tZ7j]\"9\u00111\u0003\bA\u0002\u0005U\u0011!\u0003;pa&\u001cg*Y7f!\u0011\t9\"!\n\u000f\t\u0005e\u0011\u0011\u0005\t\u0004\u00037ATBAA\u000f\u0015\r\tyBJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0002(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\tIC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003GA\u0014!\t<fe&4\u0017PU3bgNLwM\\7f]R4\u0015-\u001b7t\r>\u0014X*[:tS:<Gc\u0002#\u00020\u0005E\u0012\u0011\t\u0005\u0006{>\u0001\rA \u0005\b\u0003gy\u0001\u0019AA\u001b\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\u0011\tY$a\u0002\u0002\r\r|W.\\8o\u0013\u0011\ty$!\u000f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u00111I\bA\u0002\u0005\u0015\u0013\u0001\u0004:fCN\u001c\u0018n\u001a8nK:$\bcA@\u0002H%!\u0011\u0011JA\u0001\u0005aqUm\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^\u0001\u000eO\u0016$8i\u001c8ue>dG.\u001a:\u0015\u0005\u0005=\u0003#B#\u0002Rq\u001a\u0016bAA*q\t1A+\u001e9mKJ\na#\u001a8tkJ,7i\u001c8ue>dG.\u001a:Fq&\u001cHo]\u0001\u001dO\u0016$\u0018\t\u001c7SKBd\u0017nY1t\rJ|W.Q:tS\u001etW.\u001a8u)\u0019\tY&a\u001a\u0002lA1\u0011qCA/\u0003CJA!a\u0018\u0002*\t\u00191+\u001a;\u0011\u0007y\u000b\u0019'C\u0002\u0002f}\u00131\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!!\u001b\u0013\u0001\u0004\t)\"A\u0003u_BL7\rC\u0004\u0002nI\u0001\r!a\u001c\u0002\u0015\u0005\u001c8/[4o[\u0016tG\u000fE\u0004\u0002\u0018\u0005E4+a\u001d\n\u0007I\u000bI\u0003E\u00026uM\u000b1\u0006^3ti&s7M]3bg\u0016\u0004\u0016M\u001d;ji&|gnQ8v]R$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003'E\f\u0011\u0005^3ti\u0012+G.\u001a;f)>\u0004\u0018n\u0019#ve&tw-\u00113e!\u0006\u0014H/\u001b;j_:D#\u0001F9\u0002CQ,7\u000f^!eIB\u000b'\u000f^5uS>tG)\u001e:j]\u001e$U\r\\3uKR{\u0007/[2)\u0005U\t\u0018A\b;fgR\u0014Vm\u0019:fCR,Gk\u001c9jG\u00063G/\u001a:EK2,G/[8oQ\t1\u0012/\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$\u0018N\\4U_BL7\r\u000b\u0002\u0018c\u0006QB/Z:u\t\u0016dW\r^3U_BL7mV5uQ\u000ecW-\u00198fe\"\u0012\u0001$]\u0001&i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG\u0006c'/Z1es6\u000b'o[3e\u0003N$U\r\\3uK\u0012D#!G9\u00023\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u000b\bi\u0005U\u0015qSAQ\u0011\u001d\tIG\u0007a\u0001\u0003+A\u0011\"!'\u001b!\u0003\u0005\r!a'\u0002%\u0011,G.\u001a;f)>\u0004\u0018nY#oC\ndW\r\u001a\t\u0004\u000b\u0006u\u0015bAAPq\t9!i\\8mK\u0006t\u0007\"CAR5A\u0005\t\u0019AAS\u0003E\u0011X\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u0003/\t\thUAT!\u0015\tI+a-T\u001d\u0011\tY+a,\u000f\t\u0005m\u0011QV\u0005\u0002s%\u0019\u0011\u0011\u0017\u001d\u0002\u000fA\f7m[1hK&\u0019\u0001,!.\u000b\u0007\u0005E\u0006(A\u0012de\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005m&\u0006BAN\u0003{[#!a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013D\u0014AC1o]>$\u0018\r^5p]&!\u0011QZAb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001$GJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019N\u000b\u0003\u0002&\u0006uFc\u0002\u001b\u0002X\u0006e\u0017q\u001e\u0005\b\u0003Sj\u0002\u0019AA\u000b\u0011\u001d\tY.\ba\u0001\u0003;\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0003B\u001b;\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003vi&d'BAAu\u0003\u0011Q\u0017M^1\n\t\u00055\u00181\u001d\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAR;\u0001\u0007\u0011QU\u0001\noJLG/\u001a#vaN$\u0002\"!>\u0002z\u0006u(\u0011\u0001\t\u0005ki\n9\u0010E\u0003F\u0003#\u001a6\u000b\u0003\u0004\u0002|z\u0001\raU\u0001\b]Vl7*Z=t\u0011\u0019\tyP\ba\u0001'\u00069a.^7EkB\u001c\bb\u0002B\u0002=\u0001\u0007!QA\u0001\u0004Y><\u0007\u0003\u0002B\u0004\u0005\u0017i!A!\u0003\u000b\u0007\t\rA%\u0003\u0003\u0003\u000e\t%!a\u0001'pO\u00061B/Z:u\t&\u001c\u0018M\u00197f\t\u0016dW\r^3U_BL7\r\u000b\u0002 c\u0006\tC/Z:u\t\u0016dW\r^5oOB\u000b'\u000f^5bY2LH)\u001a7fi\u0016$Gk\u001c9jG\"\u0012\u0001%\u001d")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$2(this, follower, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$6(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option option = this.zkClient().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)getOrElse_this.get());
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$4(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$5(topicPartition$2, x$2)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)servers, TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        try (Admin adminClient = Admin.create((Properties)props);){
            this.waitUntilTopicGone(adminClient, "test");
            this.verifyReassignmentFailsForMissing(adminClient, new TopicPartition(topic, 0), new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilTopicGone(Admin adminClient, String topicName) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$waitUntilTopicGone$1(adminClient, topicName)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$waitUntilTopicGone$2(topicName), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private void verifyReassignmentFailsForMissing(Admin adminClient, TopicPartition partition, NewPartitionReassignment reassignment) {
        try {
            adminClient.alterPartitionReassignments(Collections.singletonMap(partition, Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))))).all().get();
            throw Assertions$.MODULE$.fail("expected partition reassignment to fail for [test,0]", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        }
        catch (ExecutionException e) {
            Assert.assertEquals(UnknownTopicOrPartitionException.class, e.getCause().getClass());
            return;
        }
    }

    private Tuple2<KafkaServer, Object> getController() {
        Option option = this.zkClient().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)getOrElse_this.get());
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    /*
     * WARNING - void declaration
     */
    private void ensureControllerExists() {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$ensureControllerExists$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$ensureControllerExists$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((TraversableOnce)assignment.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                return (Seq)((Seq)x0$1._2()).map((Function1 & Serializable & scala.Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        void var9_12;
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(topicPartition$3, x$3)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, this.expectedReplicaAssignment());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$8((KafkaServer)var9_12, topic, allReplicasForTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$9(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)servers, TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        Admin adminClient = Admin.create((Properties)props);
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            NewPartitions newPartitions = NewPartitions.increaseTo((int)2);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topic);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()).all().get();
        }
        catch (ExecutionException executionException) {}
        var9_12.shutdown();
        this.ensureControllerExists();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$10(this, n)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$11(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        follower.startup();
        var9_12.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
        adminClient.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteTopicDuringAddPartition() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$6)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        follower.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$2(this, follower)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$3(follower), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        int x$62 = 2;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, x$62, (Option)x$7, x$8);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$4(this, newPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddPartitionDuringDeleteTopic() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        int x$6 = 2;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        boolean x$82 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, x$6, (Option)x$7, x$82);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$8))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecreateTopicAfterDeletion() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw Assertions$.MODULE$.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$1(this, topicPartition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Log log = (Log)qual$1.getLog(topicPartition, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$4 = 0L;
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, x$4, x$5);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw Assertions$.MODULE$.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$11 -> x$11.setProperty("delete.topic.enable", Boolean.toString(deleteTopicEnabled)));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$4(topicPartition$6, x$12)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$createTestTopicAndCluster$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        void intWrapper_x;
        IntRef counter = IntRef.create((int)0);
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (Seq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDisableDeleteTopic$2(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$13))));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingPartiallyDeletedTopic() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.startup();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaServer x$1) {
        LogManager qual$1 = x$1.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$2(DeleteTopicTest $this, KafkaServer follower$1, TopicPartition topicPartition$1) {
        return ((IterableLike)$this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower$1, s)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition$1, x$1)));
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$5() {
        return "Replicas 0,1 have not deleted log.";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$6(DeleteTopicTest $this, String topic$1) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$1);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$7() {
        return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$2, int controllerId$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$4(DeleteTopicTest $this, String topic$2) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicOnControllerFailover$5() {
        return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$5(TopicPartition topicPartition$2, KafkaServer x$2) {
        LogManager qual$1 = x$2.getLogManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$2, x$22).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilTopicGone$1(Admin adminClient$1, String topicName$1) {
        try {
            adminClient$1.describeTopics(Collections.singletonList(topicName$1)).all().get();
            return false;
        }
        catch (ExecutionException e) {
            return UnknownTopicOrPartitionException.class.equals(e.getCause().getClass());
        }
    }

    public static final /* synthetic */ String $anonfun$waitUntilTopicGone$2(String topicName$1) {
        return new StringBuilder(25).append("Topic ").append(topicName$1).append(" should be deleted.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerExists$1(DeleteTopicTest $this) {
        try {
            $this.getController();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureControllerExists$2() {
        return "Controller should eventually exist";
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$1, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$1), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(TopicPartition topicPartition$3, KafkaServer x$3) {
        LogManager qual$1 = x$3.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$8(KafkaServer controller$1, String topic$4, scala.collection.immutable.Set allReplicasForTopic$1) {
        Set replicasInDeletionSuccessful = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Set offlineReplicas = controller$1.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)OfflineReplica$.MODULE$);
        scala.collection.immutable.Set set = allReplicasForTopic$1;
        Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$9(String topic$4) {
        return new StringBuilder(95).append("Not all replicas for topic ").append(topic$4).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$10(DeleteTopicTest $this, int previousControllerId$1) {
        Tuple2<KafkaServer, Object> tuple2 = $this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer cfr_ignored_0 = (KafkaServer)tuple2._1();
        return tuple2._2$mcI$sp() != previousControllerId$1;
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$11() {
        return "The new controller should not have the failed controller id";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$6) {
        return x$6.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$2(DeleteTopicTest $this, KafkaServer follower$2) {
        return $this.zkClient().getBroker(follower$2.config().brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$3(KafkaServer follower$2) {
        return new StringBuilder(33).append("Follower ").append(follower$2.config().brokerId()).append(" was not removed from ZK").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(TopicPartition newPartition$1, KafkaServer x$7) {
        LogManager qual$3 = x$7.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$1, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$4(DeleteTopicTest $this, TopicPartition newPartition$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(newPartition$1, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$6() {
        return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$8) {
        LogManager qual$3 = x$8.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$2, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$4, KafkaServer x$9) {
        LogManager qual$1 = x$9.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$4, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$1(DeleteTopicTest $this, TopicPartition topicPartition$4) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition$4, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testRecreateTopicAfterDeletion$3() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$2(TopicPartition topicPartition$5, KafkaServer x$10) {
        LogManager qual$1 = x$10.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$5, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$1(DeleteTopicTest $this, TopicPartition topicPartition$5) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2(topicPartition$5, x$10)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$3() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$4(TopicPartition topicPartition$6, KafkaServer x$12) {
        LogManager qual$1 = x$12.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$6, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$5() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, Log log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(counter$1.elem).getBytes(), Integer.toString(key).getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, Log log$1, int _) {
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (IndexedSeq)RichInt$.MODULE$.until$extension0((int)intWrapper_x, numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$1(DeleteTopicTest $this, String topic$5) {
        return !$this.zkClient().isTopicMarkedForDeletion(topic$5);
    }

    public static final /* synthetic */ String $anonfun$testDisableDeleteTopic$2(String topic$5) {
        String string = "Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$5}));
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$13) {
        LogManager qual$1 = x$13.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$7, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaServer x$16) {
        return x$16.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$3(DeleteTopicTest $this) {
        return $this.servers().exists((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$16)));
    }

    public static final /* synthetic */ String $anonfun$testDeletingPartiallyDeletedTopic$5() {
        return "No controller is elected";
    }

    /*
     * WARNING - void declaration
     */
    public DeleteTopicTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.expectedReplicaFullAssignment = (scala.collection.immutable.Map)this.expectedReplicaAssignment().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                int k = x0$1._1$mcI$sp();
                List v = (List)x0$1._2();
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq)v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }
}

