/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0004\b\u0001'!)\u0001\u0004\u0001C\u00013!)1\u0004\u0001C\u00019!)A\u0007\u0001C\u00019!)a\u0007\u0001C\u00019!)\u0001\b\u0001C\u00019!)!\b\u0001C\u00019!)A\b\u0001C\u00019!)a\b\u0001C\u00019!)\u0001\t\u0001C\u00019!)!\t\u0001C\u00019!)A\t\u0001C\u00019!)a\t\u0001C\u00019\tAB)\u001a7fi\u0016\u001cuN\\:v[\u0016\u0014xI]8vaN$Vm\u001d;\u000b\u0005=\u0001\u0012!B1e[&t'\"A\t\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+Yi\u0011AD\u0005\u0003/9\u0011\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u0016\u0001\u0005IB/Z:u\t\u0016dW\r^3XSRDGk\u001c9jG>\u0003H/[8o)\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDCA\u0001\u0013-[A\u0011QEK\u0007\u0002M)\u0011q\u0005K\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002S\u0005\u0019qN]4\n\u0005-2#\u0001\u0002+fgR\f\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002]A\u0011qFM\u0007\u0002a)\t\u0011'\u0001\u0006k_B$8/[7qY\u0016L!a\r\u0019\u0003\u001f=\u0003H/[8o\u000bb\u001cW\r\u001d;j_:\fQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u0015\u0003\u0007\u0011\n!\u0004^3ti\u0012+G.\u001a;f\u001d>tW\t_5ti&twm\u0012:pkBD#\u0001\u0002\u0013\u00025Q,7\u000f\u001e#fY\u0016$XmQ7e\u001d>tW)\u001c9us\u001e\u0013x.\u001e9)\u0005\u0015!\u0013a\u0006;fgR$U\r\\3uK:{g.R7qif<%o\\;qQ\t1A%A\fuKN$H)\u001a7fi\u0016\u001cU\u000eZ#naRLxI]8va\"\u0012q\u0001J\u0001\u0017i\u0016\u001cH\u000fR3mKR,7)\u001c3BY2<%o\\;qg\"\u0012\u0001\u0002J\u0001\u0015i\u0016\u001cH\u000fR3mKR,W)\u001c9us\u001e\u0013x.\u001e9)\u0005%!\u0013!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8sQ\tQA%\u0001\u0012uKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5NSb|emU;dG\u0016\u001c8/\u00118e\u000bJ\u0014xN\u001d\u0015\u0003\u0017\u0011\n1\u0006^3ti\u0012+G.\u001a;f/&$\b.\u00168sK\u000e|wM\\5{K\u0012tUm^\"p]N,X.\u001a:PaRLwN\u001c\u0015\u0005\u0019\u0011bS\u0006")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @Test(expected=OptionException.class)
    public void testDeleteWithTopicOption() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group(), "--topic"});
        this.getConsumerGroupService(cgcArgs);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNonExistingGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", missingGroup});
        Map result = this.getConsumerGroupService(cgcArgs).deleteGroups();
        Assert.assertTrue((String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString(), (result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdNonEmptyGroup$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString(), (output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteNonEmptyGroup$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assert.assertNotNull((String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString(), (Object)result.apply((Object)this.group()));
        Assert.assertTrue((String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString(), (result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service.deleteGroups();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (boolean)output.contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDeleteCmdAllGroups() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        var7_1 = true;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        v0 = RichInt$.MODULE$.to$extension0((int)intWrapper_x, 3);
        var9_2 = IndexedSeq$.MODULE$.canBuildFrom();
        var8_3 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$1$adapted(kafka.admin.DeleteConsumerGroupsTest java.lang.Object ), (Ljava/lang/Object;)Lscala/Tuple2;)((DeleteConsumerGroupsTest)this);
        if (v0 == null) {
            throw null;
        }
        groups = ((TraversableOnce)TraversableLike.map$((TraversableLike)v0, (Function1)map_f, (CanBuildFrom)map_bf)).toMap(Predef$.MODULE$.$conforms());
        cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--all-groups"});
        service = this.getConsumerGroupService(cgcArgs);
        var13_7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var11_8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$2(service, groups)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        groups.values().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$5$adapted(kafka.admin.ConsumerGroupCommandTest$ConsumerGroupExecutor ), (Lkafka/admin/ConsumerGroupCommandTest$ConsumerGroupExecutor;)Ljava/lang/Object;)());
        var19_10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var17_11 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$6(groups, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$8(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        var23_13 = (JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testDeleteCmdAllGroups$9(kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()V)((ConsumerGroupCommand.ConsumerGroupService)service);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        output = grabConsoleOutput_out.toString().trim();
        expectedGroupsForDeletion = groups.keySet();
        var10_18 = output.substring(output.indexOf(40) + 1, output.indexOf(41));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        deletedGroupsGrepped = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps((String)augmentString_x).split(','))), (Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$10(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        if (!output.matches("Deletion of requested consumer groups (.*) was successful.")) ** GOTO lbl-1000
        v1 = deletedGroupsGrepped;
        if (!(v1 != null ? v1.equals(expectedGroupsForDeletion) == false : expectedGroupsForDeletion != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        Assert.assertTrue((String)"The consumer group(s) could not be deleted as expected", (boolean)v2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteEmptyGroup() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assert.assertTrue((String)"The consumer group could not be deleted as expected", (result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteCmdWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> service2.deleteGroups();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteWithMixOfSuccessAndError() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Map result = this.getConsumerGroupService((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cgcArgs)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--group", missingGroup})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).deleteGroups();
        Assert.assertTrue((String)"The consumer group deletion did not work as expected", (result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0);
    }

    @Test(expected=OptionException.class)
    public void testDeleteWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--delete", "--group", this.group()});
        this.getConsumerGroupService(cgcArgs);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$2) {
        return ((SeqLike)((Option)service$2.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$3) {
        return ((SeqLike)((Option)service$3.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        if (service$4.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$4.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        String string = service$4.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1(DeleteConsumerGroupsTest $this, int i) {
        void $minus$greater$extension_$this;
        String group = new StringBuilder(0).append($this.group()).append(i).toString();
        int x$1 = 1;
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(x$1, x$3, group, x$4, x$5, x$6);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)group);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)executor);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$3(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Stable";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$2(ConsumerGroupCommand.ConsumerGroupService service$5, scala.collection.immutable.Map groups$1) {
        Set set = service$5.listConsumerGroups().toSet();
        Set set2 = groups$1.keySet();
        return !(set != null ? !set.equals(set2) : set2 != null) && groups$1.keySet().forall((Function1 & Serializable & scala.Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$3(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$4() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$7(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map groups$1, ConsumerGroupCommand.ConsumerGroupService service$5) {
        return groups$1.keySet().forall((Function1 & Serializable & scala.Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$7(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$8() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ void $anonfun$testDeleteCmdAllGroups$9(ConsumerGroupCommand.ConsumerGroupService service$5) {
        service$5.deleteGroups();
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$10(String x$1) {
        return x$1.replaceAll("'", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        if (service$6.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$6.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        String string = service$6.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        if (service$7.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$7.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        String string = service$7.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        if (service$8.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$8.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        String string = service$8.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1$adapted(DeleteConsumerGroupsTest $this, Object i) {
        return DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeleteCmdAllGroups$5$adapted(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
        executor.shutdown();
        return BoxedUnit.UNIT;
    }
}

