/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t4Aa\u0004\t\u0001+!)a\u0005\u0001C\u0001O!9\u0011\u0006\u0001a\u0001\n\u0003Q\u0003bB\u001d\u0001\u0001\u0004%\tA\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0015B\u0016\t\u000b\t\u0003A\u0011I\"\t\u000b5\u0003A\u0011A\"\t\u000bI\u0003A\u0011A\"\t\u000bQ\u0003A\u0011A\"\t\u000bY\u0003A\u0011A\"\t\u000ba\u0003A\u0011A\"\t\u000bi\u0003A\u0011A\"\t\u000bq\u0003A\u0011A\"\t\u000by\u0003A\u0011A\"\t\u000b\u0001\u0004A\u0011A\"\u0003#\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002\u0012%\u0005)\u0011\rZ7j]*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00011BD\t\t\u0003/ii\u0011\u0001\u0007\u0006\u00033I\t!A_6\n\u0005mA\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 %\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h!\t\u0019C%D\u0001\u0011\u0013\t)\u0003CA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\t\u0001\u0002\u000fM,'O^3sgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a.\u0005\r\u0019V-\u001d\t\u0003i]j\u0011!\u000e\u0006\u0003mI\taa]3sm\u0016\u0014\u0018B\u0001\u001d6\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u0003=J!AP\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u000e\t\t\u00111\u0001,\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001<Q\t)Q\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006)!.\u001e8ji*\t!*A\u0002pe\u001eL!\u0001T$\u0003\u000b\u00053G/\u001a:\u00027Q,7\u000f^'b]V\fGNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\t1q\n\u0005\u0002G!&\u0011\u0011k\u0012\u0002\u0005)\u0016\u001cH/A\u000buKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:LeNW&)\u0005\u001dy\u0015A\b;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[\"pY2L7/[8oQ\tAq*A\u0011uKN$Xj\\2lK\u0012\u001cuN\\2veJ,g\u000e\u001e+pa&\u001c7I]3bi&|g\u000e\u000b\u0002\n\u001f\u0006YB/Z:u\u0007>t7-\u001e:sK:$Hk\u001c9jG\u000e\u0013X-\u0019;j_:D#AC(\u0002+Q,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u00121bT\u0001$g\"|W\u000f\u001c3Qe>\u0004\u0018mZ1uK\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4tQ\taq*A\u000euKN$(i\\8ugR\u0014\u0018\r]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u0015\u0003\u001b=\u000ba\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0015\u0003\u001d=\u0003")
public class AdminZkClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testManualReplicaAssignment() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            Tuple2[] tuple2Array = new Tuple2[3];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            Tuple2[] tuple2Array = new Tuple2[4];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable4 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Tuple2[] tuple2Array = new Tuple2[2];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.adminZkClient().createTopicWithAssignment("test", topicConfig, assignment);
        Map found = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                void $minus$greater$extension_y;
                void $minus$greater$extension_$this;
                int k = x0$1._1$mcI$sp();
                List v = (List)x0$1._2();
                ReplicaAssignment replicaAssignment = ReplicaAssignment$.MODULE$.apply((Seq)v, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k));
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom()), (Object)found.apply((Object)"test"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreationInZK() {
        void intWrapper_x;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        void $minus$greater$extension_y13;
        void $minus$greater$extension_$this13;
        void $minus$greater$extension_y14;
        void $minus$greater$extension_$this14;
        void $minus$greater$extension_y15;
        void $minus$greater$extension_$this15;
        void $minus$greater$extension_y16;
        void $minus$greater$extension_$this16;
        void $minus$greater$extension_y17;
        void $minus$greater$extension_$this17;
        void $minus$greater$extension_y18;
        void $minus$greater$extension_$this18;
        void $minus$greater$extension_y19;
        void $minus$greater$extension_$this19;
        void $minus$greater$extension_y20;
        void $minus$greater$extension_$this20;
        void $minus$greater$extension_y21;
        void $minus$greater$extension_$this21;
        void $minus$greater$extension_y22;
        void $minus$greater$extension_$this22;
        void $minus$greater$extension_y23;
        void $minus$greater$extension_$this23;
        void $minus$greater$extension_y24;
        void $minus$greater$extension_$this24;
        Tuple2[] tuple2Array = new Tuple2[12];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this24, (Object)$minus$greater$extension_y24);
        List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this23, (Object)$minus$greater$extension_y23);
        List list3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this22, (Object)$minus$greater$extension_y22);
        List list4 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this21, (Object)$minus$greater$extension_y21);
        List list5 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this20, (Object)$minus$greater$extension_y20);
        List list6 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this19, (Object)$minus$greater$extension_y19);
        List list7 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[6] = new Tuple2((Object)$minus$greater$extension_$this18, (Object)$minus$greater$extension_y18);
        List list8 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}));
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[7] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)$minus$greater$extension_y17);
        List list9 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}));
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[8] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y16);
        List list10 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}));
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[9] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y15);
        List list11 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[10] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y14);
        List list12 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}));
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[11] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y13);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Tuple2[] tuple2Array2 = new Tuple2[12];
        Integer n = BoxesRunTime.boxToInteger((int)0);
        Object object13 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        Integer n2 = BoxesRunTime.boxToInteger((int)1);
        Object object14 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        Integer n3 = BoxesRunTime.boxToInteger((int)2);
        Object object15 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        Integer n4 = BoxesRunTime.boxToInteger((int)3);
        Object object16 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        Integer n5 = BoxesRunTime.boxToInteger((int)4);
        Object object17 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[4] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        Integer n6 = BoxesRunTime.boxToInteger((int)0);
        Object object18 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[5] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Integer n7 = BoxesRunTime.boxToInteger((int)1);
        Object object19 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[6] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Integer n8 = BoxesRunTime.boxToInteger((int)2);
        Object object20 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[7] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Integer n9 = BoxesRunTime.boxToInteger((int)3);
        Object object21 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[8] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Integer n10 = BoxesRunTime.boxToInteger((int)4);
        Object object22 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[9] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n11 = BoxesRunTime.boxToInteger((int)1);
        Object object23 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[10] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n12 = BoxesRunTime.boxToInteger((int)1);
        Object object24 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[11] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        String topic = "test";
        Properties topicConfig = new Properties();
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaMap = ((TraversableOnce)leaderForPartitionMap.keys().map((Function1 & Serializable & scala.Serializable)p -> AdminZkClientTest.$anonfun$testTopicCreationInZK$1(this, topic, BoxesRunTime.unboxToInt((Object)p)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaMap.size());
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, actualReplicaMap.size());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicCreationInZK$2(expectedReplicaAssignment, actualReplicaMap, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminZkClient qual$1 = this.adminZkClient();
        int x$2 = 3;
        int x$3 = 1;
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, x$2, x$3, x$4, x$5);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AdminZkClient qual$2 = this.adminZkClient();
            int x$7 = 3;
            int x$8 = 1;
            Properties x$9 = qual$2.createTopic$default$4();
            RackAwareMode x$10 = qual$2.createTopic$default$5();
            qual$2.createTopic(collidingTopic, x$7, x$8, x$9, x$10);
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic$1(topic, props), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic$1(topic, props), (List)Nil$.MODULE$)), (int)15000L);
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        int x$3 = 1;
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, partitions, x$3, x$4, x$5);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.createServer((KafkaConfig)x$1, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(limit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(limit))})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(newLimit)), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(newLimit))})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            void augmentString_x;
            void augmentString_x2;
            Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            String string = configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Assert.assertEquals((long)newLimit, (long)new StringOps((String)augmentString_x2).toInt());
            String string2 = configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Assert.assertEquals((long)newLimit, (long)new StringOps((String)augmentString_x).toInt());
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overridden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetBrokerMetadatas() {
        int fill_n;
        int fill_n2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0((int)intWrapper_x, 5);
        Tuple2[] tuple2Array = new Tuple2[5];
        String string = "rack1";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string2 = "rack2";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string3 = "rack2";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string4 = "rack1";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string5 = "rack3";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$22 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$22);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom()));
        List$ list$ = List$.MODULE$;
        int n = brokerList.size();
        if (list$ == null) {
            throw null;
        }
        Builder fill_b = list$.newBuilder();
        fill_b.sizeHint(fill_n2);
        for (int fill_i = 0; fill_i < fill_n2; ++fill_i) {
            fill_b.$plus$eq((Object)AdminZkClientTest.$anonfun$testGetBrokerMetadatas$2());
        }
        Assert.assertEquals((Object)((GenTraversable)fill_b.result()), (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.rack(), Seq$.MODULE$.canBuildFrom()));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$32 = RackAwareMode.Safe$.MODULE$;
        Option x$42 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$32, x$42);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Seq$.MODULE$.canBuildFrom()));
        List$ list$2 = List$.MODULE$;
        int n2 = brokerList.size();
        if (list$2 == null) {
            throw null;
        }
        Builder fill_b2 = list$2.newBuilder();
        fill_b2.sizeHint(fill_n);
        for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
            fill_b2.$plus$eq((Object)AdminZkClientTest.$anonfun$testGetBrokerMetadatas$5());
        }
        Assert.assertEquals((Object)((GenTraversable)fill_b2.result()), (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.rack(), Seq$.MODULE$.canBuildFrom()));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            return qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.option2Iterable(x$7.rack()), Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        String x$72 = "foo";
        int x$9 = 2;
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        qual$4.createTopic(x$72, numPartitions, x$9, x$11, (RackAwareMode)x$10);
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$testTopicCreationInZK$1(AdminZkClientTest $this, String topic$1, int p) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Seq seq = $this.zkClient().getReplicasForPartition(new TopicPartition(topic$1, p));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$testTopicCreationInZK$2(Map expectedReplicaAssignment$1, scala.collection.immutable.Map actualReplicaMap$1, int i) {
        Assert.assertEquals((Object)expectedReplicaAssignment$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)actualReplicaMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i)));
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Assert.assertEquals((String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString(), (long)1L, (long)partitionReplicaAssignment.replicas().size());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$3, Properties props$1) {
        void var8_8;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            int x$2 = 3;
            int x$3 = 1;
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            qual$1.createTopic(topic$3, x$2, x$3, props$1, x$5);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$3}))).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assert.assertEquals((long)3L, (long)var8_8.size());
        var8_8.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$3);
        Assert.assertEquals((Object)props$1, (Object)savedProps);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(messageSize));
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assert.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assert.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected.split(","))).toSeq(), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$2(String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1, int part) {
        TopicPartition tp = new TopicPartition(topic$4, part);
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(tp, x$2);
        Assert.assertTrue((boolean)log.isDefined());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)retentionMs$1), (Object)((Log)log.get()).config().retentionMs());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)messageSize$1), (Object)((Log)log.get()).config().maxMessageSize());
        AdminZkClientTest.checkList$1(((Log)log.get()).config().LeaderReplicationThrottledReplicas(), throttledLeaders$1);
        AdminZkClientTest.checkList$1(((Log)log.get()).config().FollowerReplicationThrottledReplicas(), throttledFollowers$1);
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server$1.quotaManagers().leader().isThrottled(tp)));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        void intWrapper_x;
        boolean bl = false;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0((int)intWrapper_x, partitions$1);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicConfigChange$2(topic$4, server$1, retentionMs$1, messageSize$1, throttledLeaders$1, throttledFollowers$1, quotaManagerIsThrottled$1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$4, KafkaServer server$1) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$4, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().leader().upperBound());
        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().follower().upperBound());
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$3(AdminZkClientTest $this, long limit$1) {
        $this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long limit) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$3(this, limit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$5() {
        return None$.MODULE$;
    }

    public AdminZkClientTest() {
        RackAwareTest.$init$(this);
        this.servers = Nil$.MODULE$;
    }
}

