/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Iterator;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\r\u001b\u0001iq\u0002\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011e\u0002!\u0011!Q\u0001\n9B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005y!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003C\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000b5\u0003A\u0011\u0001(\t\u000fQ\u0003!\u0019!C\u0005+\"1\u0011\r\u0001Q\u0001\nYCqA\u0019\u0001C\u0002\u0013%\u0011\t\u0003\u0004d\u0001\u0001\u0006IA\u0011\u0005\u0006I\u0002!I!\u001a\u0005\u0006k\u0002!IA\u001e\u0005\u0006s\u0002!IA\u001f\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA0\u0001\u0011%\u0011\u0011\r\u0005\b\u0003_\u0002A\u0011AA9\u0011\u0019\ti\b\u0001C\u0001\u0003\"9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAN\u0001\u0011\u0005\u0013Q\u0014\u0002\u0013!J|G-^2fe\u0006\u0003\b/\u001a8e\u0013:4wN\u0003\u0002\u001c9\u0005\u0019An\\4\u000b\u0003u\tQa[1gW\u0006\u001c2\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011a%K\u0007\u0002O)\u0011\u0001\u0006H\u0001\u0006kRLGn]\u0005\u0003U\u001d\u0012q\u0001T8hO&tw-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0004\u0001U\ta\u0006\u0005\u00020o5\t\u0001G\u0003\u00022e\u000511m\\7n_:T!!H\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003qA\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002yA\u0011\u0001%P\u0005\u0003}\u0005\u0012A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00031\u0019WO\u001d:f]R,e\u000e\u001e:z+\u0005\u0011\u0005CA\"E\u001b\u0005Q\u0012BA#\u001b\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\u0002\u001b\r,(O]3oi\u0016sGO]=!\u0003\u0019y'/[4j]V\t\u0011\n\u0005\u0002D\u0015&\u00111J\u0007\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\\\u0001\b_JLw-\u001b8!\u0003\u0019a\u0014N\\5u}Q)q\nU)S'B\u00111\t\u0001\u0005\u0006W%\u0001\rA\f\u0005\u0006u%\u0001\r\u0001\u0010\u0005\u0006\u0001&\u0001\rA\u0011\u0005\u0006\u000f&\u0001\r!S\u0001\riJ\fgn]1di&|gn]\u000b\u0002-B\u0019q\u000b\u00180\u000e\u0003aS!!\u0017.\u0002\u000f5,H/\u00192mK*\u00111,I\u0001\u000bG>dG.Z2uS>t\u0017BA/Y\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\t\u0003\u0007~K!\u0001\u0019\u000e\u0003\u0017QCh.T3uC\u0012\fG/Y\u0001\u000eiJ\fgn]1di&|gn\u001d\u0011\u0002\u0019U\u0004H-\u0019;fI\u0016sGO]=\u0002\u001bU\u0004H-\u0019;fI\u0016sGO]=!\u0003Yi\u0017-\u001f2f-\u0006d\u0017\u000eZ1uK\u0012\u000bG/\u0019\"bi\u000eDG\u0003\u00024j]N\u0004\"\u0001I4\n\u0005!\f#\u0001B+oSRDQA\u001b\bA\u0002-\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007C\u0001\u0011m\u0013\ti\u0017EA\u0003TQ>\u0014H\u000fC\u0003p\u001d\u0001\u0007\u0001/\u0001\u0005gSJ\u001cHoU3r!\t\u0001\u0013/\u0003\u0002sC\t\u0019\u0011J\u001c;\t\u000bQt\u0001\u0019\u0001\u001f\u0002\r=4gm]3u\u0003I\u0019\u0007.Z2l!J|G-^2fe\u0016\u0003xn\u00195\u0015\u0007\u0019<\b\u0010C\u0003k\u001f\u0001\u00071\u000eC\u0003u\u001f\u0001\u0007A(A\u0007dQ\u0016\u001c7nU3rk\u0016t7-\u001a\u000b\u0005Mndh\u0010C\u0003k!\u0001\u00071\u000eC\u0003~!\u0001\u0007\u0001/\u0001\bbaB,g\u000e\u001a$jeN$8+Z9\t\u000bQ\u0004\u0002\u0019\u0001\u001f\u0002\u0015%t7+Z9vK:\u001cW\r\u0006\u0004\u0002\u0004\u0005%\u0011Q\u0002\t\u0004A\u0005\u0015\u0011bAA\u0004C\t9!i\\8mK\u0006t\u0007BBA\u0006#\u0001\u0007\u0001/A\u0004mCN$8+Z9\t\r\u0005=\u0011\u00031\u0001q\u0003\u001dqW\r\u001f;TKF\fa!\u00199qK:$GCBA\u000b\u0003C\t\t\u0004E\u0003!\u0003/\tY\"C\u0002\u0002\u001a\u0005\u0012aa\u00149uS>t\u0007cA\"\u0002\u001e%\u0019\u0011q\u0004\u000e\u0003\u0019\r{W\u000e\u001d7fi\u0016$G\u000b\u001f8\t\u000f\u0005\r\"\u00031\u0001\u0002&\u0005)!-\u0019;dQB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,A\naA]3d_J$\u0017\u0002BA\u0018\u0003S\u00111BU3d_J$')\u0019;dQ\"9\u00111\u0007\nA\u0002\u0005U\u0012A\u00064jeN$xJ\u001a4tKRlU\r^1eCR\fw\n\u001d;\u0011\u000b\u0001\n9\"a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u001d\u0003\u0019\u0019XM\u001d<fe&!\u0011\u0011IA\u001e\u0005EaunZ(gMN,G/T3uC\u0012\fG/Y\u0001\u0010CB\u0004XM\u001c3ECR\f')\u0019;dQRya-a\u0012\u0002L\u00055\u0013qJA*\u0003/\nY\u0006\u0003\u0004\u0002JM\u0001\ra[\u0001\u0006KB|7\r\u001b\u0005\u0006_N\u0001\r\u0001\u001d\u0005\u0007\u0003\u0017\u0019\u0002\u0019\u00019\t\r\u0005E3\u00031\u0001=\u00035a\u0017m\u001d;US6,7\u000f^1na\"9\u0011QK\nA\u0002\u0005]\u0012a\u00054jeN$xJ\u001a4tKRlU\r^1eCR\f\u0007BBA-'\u0001\u0007A(\u0001\u0006mCN$xJ\u001a4tKRDq!!\u0018\u0014\u0001\u0004\t\u0019!A\bjgR\u0013\u0018M\\:bGRLwN\\1m\u0003U\u0019\u0007.Z2l\u0007>|'\u000fZ5oCR|'/\u00129pG\"$RAZA2\u0003[Bq!!\u001a\u0015\u0001\u0004\t9'\u0001\u0007f]\u0012$\u0006P\\'be.,'\u000f\u0005\u0003\u0002(\u0005%\u0014\u0002BA6\u0003S\u0011A#\u00128e)J\fgn]1di&|g.T1sW\u0016\u0014\b\"\u0002;\u0015\u0001\u0004a\u0014AE1qa\u0016tG-\u00128e)btW*\u0019:lKJ$\"\"a\u0007\u0002t\u0005U\u0014qOA=\u0011\u001d\t)'\u0006a\u0001\u0003OBQA[\u000bA\u0002-DQ\u0001^\u000bA\u0002qBa!a\u001f\u0016\u0001\u0004a\u0014!\u0003;j[\u0016\u001cH/Y7q\u0003\u001d!x.\u00128uef\f1c\u001d;beR,G\r\u0016:b]N\f7\r^5p]N,\"!a!\u0011\u000b\u0005\u0015\u0015Q\u00130\u000f\t\u0005\u001d\u0015\u0011\u0013\b\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013bAAJC\u00059\u0001/Y2lC\u001e,\u0017\u0002BAL\u00033\u0013A\u0001T5ti*\u0019\u00111S\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a(\u0011\t\u0005\u0005\u0016\u0011\u0016\b\u0005\u0003G\u000b)\u000bE\u0002\u0002\n\u0006J1!a*\"\u0003\u0019\u0001&/\u001a3fM&!\u00111VAW\u0005\u0019\u0019FO]5oO*\u0019\u0011qU\u0011")
public class ProducerAppendInfo
implements Logging {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final AppendOrigin origin;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public AppendOrigin origin() {
        return this.origin;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateDataBatch(short producerEpoch, int firstSeq, long offset) {
        block7: {
            block6: {
                AppendOrigin$Client$ appendOrigin$Client$;
                AppendOrigin appendOrigin;
                block5: {
                    this.checkProducerEpoch(producerEpoch, offset);
                    appendOrigin = this.origin();
                    appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
                    if (appendOrigin != null) break block5;
                    if (appendOrigin$Client$ != null) {
                        return;
                    }
                    break block6;
                }
                if (!appendOrigin.equals(appendOrigin$Client$)) break block7;
            }
            this.checkSequence(producerEpoch, firstSeq, offset);
            return;
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            String message = new StringBuilder(79).append("Producer's epoch at offset ").append(offset).append(" in ").append(this.topicPartition()).append(" is ").append(producerEpoch).append(", which is ").append("smaller than the last seen epoch ").append(this.updatedEntry().producerEpoch()).toString();
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                return;
            }
            throw new ProducerFencedException(message);
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        int currentLastSeq;
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(96).append("Invalid sequence number for new epoch at offset ").append(offset).append(" in ").append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString());
                }
                return;
            }
            return;
        }
        int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
        if (this.currentEntry().producerEpoch() != -1 && !this.inSequence(currentLastSeq, appendFirstSeq)) {
            throw new OutOfOrderSequenceException(new StringBuilder(126).append("Out of order sequence number for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(appendFirstSeq).append(" (incoming seq. number), ").append(currentLastSeq).append(" (current end sequence number)").toString());
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                return new Some((Object)completedTxn);
            }
            return None$.MODULE$;
        }
        if (firstOffsetMetadataOpt == null) {
            throw null;
        }
        LogOffsetMetadata firstOffsetMetadata = (LogOffsetMetadata)(firstOffsetMetadataOpt.isEmpty() ? ProducerAppendInfo.$anonfun$append$1(batch) : firstOffsetMetadataOpt.get());
        this.appendDataBatch(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
        return None$.MODULE$;
    }

    public void appendDataBatch(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset();
        this.maybeValidateDataBatch(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(68).append("Expected transactional write from producer ").append(this.producerId()).append(" at ").append("offset ").append(firstOffsetMetadata).append(" in partition ").append(this.topicPartition()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata, TxnMetadata$.MODULE$.apply$default$3()));
            return;
        }
    }

    private void checkCoordinatorEpoch(EndTransactionMarker endTxnMarker, long offset) {
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Detected invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("is older than previously known coordinator epoch ").append(this.updatedEntry().coordinatorEpoch()).toString());
                return;
            }
            throw new TransactionCoordinatorFencedException(new StringBuilder(89).append("Invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString());
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch, offset);
        this.checkCoordinatorEpoch(endTxnMarker, offset);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().maybeUpdateProducerEpoch(producerEpoch);
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(timestamp);
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public String toString() {
        return new StringBuilder(159).append("ProducerAppendInfo(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").append("lastTimestamp=").append(this.updatedEntry().lastTimestamp()).append(", ").append("startedTransactions=").append(this.transactions()).append(")").toString();
    }

    public static final /* synthetic */ LogOffsetMetadata $anonfun$append$1(RecordBatch batch$1) {
        return new LogOffsetMetadata(batch$1.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, AppendOrigin origin) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        Logging.$init$(this);
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().lastTimestamp_$eq(currentEntry.lastTimestamp());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

