/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.TreeSet;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordered$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final String AnyLogDir;
    private final String helpText;
    private final int EarliestVersion;
    private final int EarliestTopicsJsonVersion;
    private final String brokerLevelLeaderThrottle;
    private final String brokerLevelFollowerThrottle;
    private final String brokerLevelLogDirThrottle;
    private final Seq<String> brokerLevelThrottles;
    private final String topicLevelLeaderThrottle;
    private final String topicLevelFollowerThrottle;
    private final Seq<String> topicLevelThrottles;
    private final String cannotExecuteBecauseOfExistingMessage;
    private final String youMustRunVerifyPeriodicallyMessage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public String helpText() {
        return this.helpText;
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public int EarliestTopicsJsonVersion() {
        return this.EarliestTopicsJsonVersion;
    }

    public String brokerLevelLeaderThrottle() {
        return this.brokerLevelLeaderThrottle;
    }

    public String brokerLevelFollowerThrottle() {
        return this.brokerLevelFollowerThrottle;
    }

    public String brokerLevelLogDirThrottle() {
        return this.brokerLevelLogDirThrottle;
    }

    public Seq<String> brokerLevelThrottles() {
        return this.brokerLevelThrottles;
    }

    public String topicLevelLeaderThrottle() {
        return this.topicLevelLeaderThrottle;
    }

    public String topicLevelFollowerThrottle() {
        return this.topicLevelFollowerThrottle;
    }

    public Seq<String> topicLevelThrottles() {
        return this.topicLevelThrottles;
    }

    public String cannotExecuteBecauseOfExistingMessage() {
        return this.cannotExecuteBecauseOfExistingMessage;
    }

    public String youMustRunVerifyPeriodicallyMessage() {
        return this.youMustRunVerifyPeriodicallyMessage;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        None$ toClose = None$.MODULE$;
        boolean failed = true;
        try {
            try {
                if (opts.options().has(opts.bootstrapServerOpt())) {
                    if (opts.options().has(opts.zkConnectOpt())) {
                        Predef$.MODULE$.println((Object)"Warning: ignoring deprecated --zookeeper option because --bootstrap-server was specified.  The --zookeeper option will be removed in a future version of Kafka.");
                    }
                    Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
                    props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
                    props.putIfAbsent("client.id", "reassign-partitions-tool");
                    Admin adminClient = Admin.create((Properties)props);
                    toClose = new Some((Object)adminClient);
                    this.handleAction(adminClient, opts);
                } else {
                    Predef$.MODULE$.println((Object)"Warning: --zookeeper is deprecated, and will be removed in a future version of Kafka.");
                    KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), JaasUtils.isZkSaslEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10());
                    toClose = new Some((Object)zkClient);
                    this.handleAction(zkClient, opts);
                }
                failed = false;
            }
            catch (ReassignPartitionsCommand.TerseReassignmentFailureException e) {
                Predef$.MODULE$.println((Object)e.getMessage());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(7).append("Error: ").append(e.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
        finally {
            if (toClose == null) {
                throw null;
            }
            if (!toClose.isEmpty()) {
                ((AutoCloseable)toClose.get()).close();
            }
        }
        if (failed) {
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    private void handleAction(Admin adminClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            this.verifyAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.generateOpt())) {
            this.generateAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt()))), (String)opts.options().valueOf(opts.brokerListOpt()), !opts.options().has((OptionSpec)opts.disableRackAware()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.executeOpt())) {
            this.executeAssignment(adminClient, opts.options().has((OptionSpec)opts.additionalOpt()), Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt())), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt())), this.executeAssignment$default$7());
            return;
        }
        if (opts.options().has((OptionSpec)opts.cancelOpt())) {
            this.cancelAssignment(adminClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt())), this.cancelAssignment$default$5());
            return;
        }
        if (opts.options().has((OptionSpec)opts.listOpt())) {
            this.listReassignments(adminClient);
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    private void handleAction(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            this.verifyAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), opts.options().has((OptionSpec)opts.preserveThrottlesOpt()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.generateOpt())) {
            this.generateAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt()))), (String)opts.options().valueOf(opts.brokerListOpt()), !opts.options().has((OptionSpec)opts.disableRackAware()));
            return;
        }
        if (opts.options().has((OptionSpec)opts.executeOpt())) {
            this.executeAssignment(zkClient, Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt()))), BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt())));
            return;
        }
        throw new RuntimeException("Unsupported action.");
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(Admin adminClient, String jsonString, boolean preserveThrottles) {
        void var10_11;
        void var8_8;
        void var6_6;
        void var5_5;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetLogDirs = (Map)tuple2._2();
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> tuple23 = this.verifyReplicaMoves(adminClient, (Map<TopicPartitionReplica, String>)var6_6);
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        Map moveStates = (Map)tuple23._1();
        boolean bl2 = tuple23._2$mcZ$sp();
        if (!(bl || bl2 || preserveThrottles)) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)var10_11, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(adminClient, targets);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Predef$.MODULE$.println((Object)this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4));
        return new Tuple2((Object)var4_4, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.VerifyAssignmentResult verifyAssignment(KafkaZkClient zkClient, String jsonString, boolean preserveThrottles) {
        void var8_8;
        void var5_5;
        void var6_6;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetLogDirs = (Map)tuple2._2();
        if (var6_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        Predef$.MODULE$.println((Object)"Warning: because you are using the deprecated --zookeeper option, the results may be incomplete.  Use --bootstrap-server instead for more accurate results.");
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple22 = this.verifyPartitionAssignments(zkClient, (Map<TopicPartition, Seq<Object>>)var5_5.toMap(Predef$.MODULE$.$conforms()));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple22._1();
        boolean bl = tuple22._2$mcZ$sp();
        if (!bl && !preserveThrottles) {
            this.clearAllThrottles(zkClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)var5_5);
        }
        return new ReassignPartitionsCommand.VerifyAssignmentResult((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var8_8, bl, (Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>)scala.collection.Map$.MODULE$.empty(), false);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> verifyPartitionAssignments(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targets) {
        void var4_4;
        Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> tuple2 = this.findPartitionReassignmentStates(zkClient, targets);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partStates = (Map)tuple2._1();
        boolean bl = tuple2._2$mcZ$sp();
        Predef$.MODULE$.println((Object)this.partitionReassignmentStatesToString((Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>)var4_4));
        return new Tuple2((Object)var4_4, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        return Ordered$.MODULE$.orderingToOrdered((Object)new Tuple2((Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple2((Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public boolean compareTopicPartitionReplicas(TopicPartitionReplica a, TopicPartitionReplica b) {
        return Ordered$.MODULE$.orderingToOrdered((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)a.brokerId()), (Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)b.brokerId()), (Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public String partitionReassignmentStatesToString(Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState> states) {
        ArrayBuffer bld = new ArrayBuffer();
        bld.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Status of partition reassignment:"}));
        ((IterableLike)states.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            ReassignPartitionsCommand$.$anonfun$partitionReassignmentStatesToString$2(states, bld, topicPartition);
            return BoxedUnit.UNIT;
        });
        return bld.mkString(System.lineSeparator());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetReassignments) {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Map currentReassignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        Tuple2 tuple2 = targetReassignments.partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$1(currentReassignments, x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq foundReassignments = (Seq)tuple2._1();
        Seq notFoundReassignments = (Seq)tuple2._2();
        void foundReassignments2 = var5_5;
        void notFoundReassignments2 = var6_6;
        Seq foundResults = (Seq)foundReassignments2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                Seq targetReplicas = (Seq)x0$2._2();
                return new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((PartitionReassignment)currentReassignments.get((Object)part).get()).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$3(i)), Buffer$.MODULE$.canBuildFrom())), (Seq<Object>)targetReplicas, false));
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        HashSet topicNamesToLookUp = new HashSet();
        notFoundReassignments2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 != null) {
                TopicPartition part = (TopicPartition)x0$3._1();
                if (!currentReassignments.contains((Object)part)) {
                    return BoxesRunTime.boxToBoolean((boolean)topicNamesToLookUp.add((Object)part.topic()));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError(null);
        });
        scala.collection.mutable.Map topicDescriptions = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)topicNamesToLookUp).asJava()).values()).asScala();
        Seq notFoundResults = (Seq)notFoundReassignments2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            if (x0$4 != null) {
                TopicPartition part = (TopicPartition)x0$4._1();
                Seq targetReplicas = (Seq)x0$4._2();
                Option option = currentReassignments.get((Object)part);
                if (option instanceof Some) {
                    PartitionReassignment reassignment = (PartitionReassignment)((Some)option).value();
                    return new Tuple2((Object)part, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$6(x$10)), Buffer$.MODULE$.canBuildFrom())), (Seq<Object>)targetReplicas, false));
                }
                if (None$.MODULE$.equals(option)) {
                    return new Tuple2((Object)part, (Object)MODULE$.topicDescriptionFutureToState(part.partition(), (KafkaFuture<TopicDescription>)((KafkaFuture)topicDescriptions.apply((Object)part.topic())), (Seq<Object>)targetReplicas));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
        Seq allResults = (Seq)foundResults.$plus$plus((GenTraversableOnce)notFoundResults, Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)allResults.toMap(Predef$.MODULE$.$conforms()), (Object)BoxesRunTime.boxToBoolean((boolean)currentReassignments.nonEmpty()));
    }

    private ReassignPartitionsCommand.PartitionReassignmentState topicDescriptionFutureToState(int partition, KafkaFuture<TopicDescription> future, Seq<Object> targetReplicas) {
        try {
            TopicDescription topicDescription = (TopicDescription)future.get();
            if (topicDescription.partitions().size() < partition) {
                throw new ExecutionException("Too few partitions found", (Throwable)new UnknownTopicOrPartitionException());
            }
            return new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()), Buffer$.MODULE$.canBuildFrom())), targetReplicas, true);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof UnknownTopicOrPartitionException) {
                return new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)Nil$.MODULE$, targetReplicas, true);
            }
            throw throwable;
        }
    }

    public Tuple2<Map<TopicPartition, ReassignPartitionsCommand.PartitionReassignmentState>, Object> findPartitionReassignmentStates(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> targetReassignments) {
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        targetReassignments.groupBy((Function1 & Serializable & scala.Serializable)x$12 -> ((TopicPartition)x$12._1()).topic()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$findPartitionReassignmentStates$8(zkClient, results, partitionsBeingReassigned, x0$1);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)results, (Object)BoxesRunTime.boxToBoolean((boolean)partitionsBeingReassigned.nonEmpty()));
    }

    public Tuple2<Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState>, Object> verifyReplicaMoves(Admin adminClient, Map<TopicPartitionReplica, String> targetReassignments) {
        Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> moveStates = this.findLogDirMoveStates(adminClient, targetReassignments);
        Predef$.MODULE$.println((Object)this.replicaMoveStatesToString(moveStates));
        return new Tuple2(moveStates, (Object)BoxesRunTime.boxToBoolean((!moveStates.values().forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.done())) ? 1 : 0) != 0));
    }

    public Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> findLogDirMoveStates(Admin adminClient, Map<TopicPartitionReplica, String> targetMoves) {
        scala.collection.mutable.Map replicaLogDirInfos = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeReplicaLogDirs((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(targetMoves.keySet()).asJava()).all().get()).asScala();
        return (Map)targetMoves.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object object;
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                String targetLogDir = (String)x0$1._2();
                Option option = replicaLogDirInfos.get((Object)replica);
                if (None$.MODULE$.equals(option)) {
                    object = new ReassignPartitionsCommand.MissingReplicaMoveState(targetLogDir);
                } else if (option instanceof Some) {
                    DescribeReplicaLogDirsResult.ReplicaLogDirInfo info = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
                    object = info.getCurrentReplicaLogDir() == null ? new ReassignPartitionsCommand.MissingLogDirMoveState(targetLogDir) : (info.getFutureReplicaLogDir() == null ? (info.getCurrentReplicaLogDir().equals(targetLogDir) ? new ReassignPartitionsCommand.CompletedMoveState(targetLogDir) : new ReassignPartitionsCommand.CancelledMoveState(info.getCurrentReplicaLogDir(), targetLogDir)) : new ReassignPartitionsCommand.ActiveMoveState(info.getCurrentReplicaLogDir(), targetLogDir, info.getFutureReplicaLogDir()));
                } else {
                    throw new MatchError((Object)option);
                }
                ReassignPartitionsCommand.MissingReplicaMoveState moveState = object;
                return new Tuple2((Object)replica, (Object)moveState);
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public String replicaMoveStatesToString(Map<TopicPartitionReplica, ReassignPartitionsCommand.LogDirMoveState> states) {
        ArrayBuffer bld = new ArrayBuffer();
        ((IterableLike)states.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$replicaMoveStatesToString$2(states, bld, x0$1);
            return BoxedUnit.UNIT;
        });
        return bld.mkString(System.lineSeparator());
    }

    /*
     * WARNING - void declaration
     */
    public void clearAllThrottles(Admin adminClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        void augmentString_x;
        void augmentString_x2;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Iterable$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)((GenericTraversableTemplate)targetParts.map((Function1 & Serializable & scala.Serializable)x$15 -> (Seq)x$15._2(), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
        String string = "Clearing broker-level throttles on broker%s %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokers.size() == 1 ? "" : "s", brokers.mkString(",")})));
        this.clearBrokerLevelThrottles(adminClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set topics = ((TraversableOnce)targetParts.map((Function1 & Serializable & scala.Serializable)x$16 -> ((TopicPartition)x$16._1()).topic(), Seq$.MODULE$.canBuildFrom())).toSet();
        String string2 = "Clearing topic-level throttles on topic%s %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.size() == 1 ? "" : "s", topics.mkString(",")})));
        this.clearTopicLevelThrottles(adminClient, (scala.collection.immutable.Set<String>)topics);
    }

    /*
     * WARNING - void declaration
     */
    public void clearAllThrottles(KafkaZkClient zkClient, Seq<Tuple2<TopicPartition, Seq<Object>>> targetParts) {
        void augmentString_x;
        void augmentString_x2;
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)((TraversableOnce)zkClient.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), Seq$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)((GenericTraversableTemplate)targetParts.map((Function1 & Serializable & scala.Serializable)x$18 -> (Seq)x$18._2(), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
        String string = "Clearing broker-level throttles on broker%s %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokers.size() == 1 ? "" : "s", brokers.mkString(",")})));
        this.clearBrokerLevelThrottles(zkClient, (scala.collection.immutable.Set<Object>)brokers);
        scala.collection.immutable.Set topics = ((TraversableOnce)targetParts.map((Function1 & Serializable & scala.Serializable)x$19 -> ((TopicPartition)x$19._1()).topic(), Seq$.MODULE$.canBuildFrom())).toSet();
        String string2 = "Clearing topic-level throttles on topic%s %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topics.size() == 1 ? "" : "s", topics.mkString(",")})));
        this.clearTopicLevelThrottles(zkClient, (scala.collection.immutable.Set<String>)topics);
    }

    public void clearBrokerLevelThrottles(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        HashMap configOps = new HashMap();
        brokers.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> ReassignPartitionsCommand$.$anonfun$clearBrokerLevelThrottles$1(configOps, BoxesRunTime.unboxToInt((Object)x0$1)));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearBrokerLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> brokers) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            if (((TraversableOnce)MODULE$.brokerLevelThrottles().flatMap((Function1 & Serializable & scala.Serializable)throttle -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(configs.remove(throttle))), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
                adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                return;
            }
        });
    }

    public void clearTopicLevelThrottles(Admin adminClient, scala.collection.immutable.Set<String> topics) {
        HashMap configOps = new HashMap();
        topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> (Collection)configOps.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)MODULE$.topicLevelThrottles().map((Function1 & Serializable & scala.Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom())).asJava()));
        adminClient.incrementalAlterConfigs(configOps).all().get();
    }

    public void clearTopicLevelThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<String> topics) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ReassignPartitionsCommand$.$anonfun$clearTopicLevelThrottles$3(adminZkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(Admin adminClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void augmentString_x;
        void augmentString_x2;
        void var7_7;
        void var6_6;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq brokersToReassign = (Seq)tuple2._1();
        Seq topicsToReassign = (Seq)tuple2._2();
        void brokersToReassign2 = var6_6;
        void topicsToReassign2 = var7_7;
        Map<TopicPartition, Seq<Object>> currentAssignments = this.getReplicaAssignmentForTopics(adminClient, (Seq<String>)topicsToReassign2);
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(adminClient, (Seq<Object>)brokersToReassign2, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        String string = "Current partition replica assignment\n%s\n";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        String string2 = "Proposed partition reassignment configuration\n%s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        return new Tuple2(proposedAssignments, currentAssignments);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, String reassignmentJson, String brokerListString, boolean enableRackAwareness) {
        void augmentString_x;
        void augmentString_x2;
        void var7_7;
        void var6_6;
        Tuple2<Seq<Object>, Seq<String>> tuple2 = this.parseGenerateAssignmentArgs(reassignmentJson, brokerListString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq brokersToReassign = (Seq)tuple2._1();
        Seq topicsToReassign = (Seq)tuple2._2();
        void brokersToReassign2 = var6_6;
        void topicsToReassign2 = var7_7;
        Map<TopicPartition, Seq<Object>> currentAssignments = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topicsToReassign2.toSet());
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadata(zkClient, (Seq<Object>)brokersToReassign2, enableRackAwareness);
        Map<TopicPartition, Seq<Object>> proposedAssignments = this.calculateAssignment(currentAssignments, brokerMetadatas);
        String string = "Current partition replica assignment\n%s\n";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        String string2 = "Proposed partition reassignment configuration\n%s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(proposedAssignments, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        return new Tuple2(proposedAssignments, currentAssignments);
    }

    public Map<TopicPartition, Seq<Object>> calculateAssignment(Map<TopicPartition, Seq<Object>> currentAssignment, Seq<BrokerMetadata> brokerMetadatas) {
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return ((TopicPartition)x0$1._1()).topic();
            }
            throw new MatchError(null);
        });
        scala.collection.mutable.Map proposedAssignments = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                void var6_6;
                String topic = (String)x0$2._1();
                Map assignment = (Map)x0$2._2();
                Tuple2 tuple2 = (Tuple2)assignment.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Seq replicas = (Seq)tuple2._2();
                Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), var6_6.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                return (scala.collection.mutable.Map)proposedAssignments.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        void $minus$greater$extension_$this;
                        int partition = x0$3._1$mcI$sp();
                        Seq replicas = (Seq)x0$3._2();
                        Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition));
                        if (Predef.ArrowAssoc$.MODULE$ == null) {
                            throw null;
                        }
                        return new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
                    }
                    throw new MatchError(null);
                }, scala.collection.Map$.MODULE$.canBuildFrom()));
            }
            throw new MatchError(null);
        });
        return proposedAssignments;
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForTopics(Admin adminClient, Seq<String> topics) {
        return (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                TopicDescription topicDescription = (TopicDescription)x0$1._2();
                return (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)info -> new Tuple2((Object)new TopicPartition(topicName, info.partition()), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.id()), Buffer$.MODULE$.canBuildFrom())), Buffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicPartition, Seq<Object>> getReplicaAssignmentForPartitions(Admin adminClient, scala.collection.immutable.Set<TopicPartition> partitions) {
        return (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)partitions.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.topic(), Set$.MODULE$.canBuildFrom())).asJava()).all().get()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                TopicDescription topicDescription = (TopicDescription)x0$1._2();
                return (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)info -> {
                    if (partitions.contains((Object)new TopicPartition(topicName, info.partition()))) {
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)new TopicPartition(topicName, info.partition()), ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(info.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.id()), Buffer$.MODULE$.canBuildFrom()))));
                    }
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }, Buffer$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Seq<BrokerMetadata> getBrokerMetadata(Admin adminClient, Seq<Object> brokers, boolean enableRackAwareness) {
        scala.collection.immutable.Set brokerSet = brokers.toSet();
        Seq results = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)brokerSet.contains((Object)BoxesRunTime.boxToInteger((int)node.id()))))).map((Function1 & Serializable & scala.Serializable)node -> {
            if (enableRackAwareness && node.rack() != null) {
                return new BrokerMetadata(node.id(), (Option<String>)new Some((Object)node.rack()));
            }
            return new BrokerMetadata(node.id(), (Option<String>)None$.MODULE$);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        int numRackless = results.count((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$getBrokerMetadata$3(x$25)));
        if (enableRackAwareness && numRackless != 0 && numRackless != results.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return results;
    }

    public Seq<BrokerMetadata> getBrokerMetadata(KafkaZkClient zkClient, Seq<Object> brokers, boolean enableRackAwareness) {
        return new AdminZkClient(zkClient).getBrokerMetadatas((RackAwareMode)(enableRackAwareness ? RackAwareMode$Enforced$.MODULE$ : RackAwareMode$Disabled$.MODULE$), (Option<Seq<Object>>)new Some(brokers));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Seq<Object>, Seq<String>> parseGenerateAssignmentArgs(String reassignmentJson, String brokerList) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int[] brokerListToReassign = (int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(brokerList).split(','))), (Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$parseGenerateAssignmentArgs$1(x$26)), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            void augmentString_x;
            String string = "Broker list contains duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        Seq<String> topicsToReassign = this.parseTopicsData(reassignmentJson);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            void augmentString_x;
            String string = "List of topics to reassign contains duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        return new Tuple2((Object)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToReassign);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(Admin adminClient, boolean additional, String reassignmentJson, long interBrokerThrottle, long logDirThrottle, long timeoutMs, Time time) {
        void augmentString_x;
        Map<TopicPartition, Throwable> errors;
        void var13_10;
        void var12_9;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedParts = (Map)tuple2._1();
        Map proposedReplicas = (Map)tuple2._2();
        void proposedParts2 = var12_9;
        void proposedReplicas2 = var13_10;
        scala.collection.mutable.Map currentReassignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        if (!additional && currentReassignments.nonEmpty()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        this.verifyBrokerIds(adminClient, (scala.collection.immutable.Set<Object>)((TraversableOnce)proposedParts2.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSet());
        Map<TopicPartition, Seq<Object>> currentParts = this.getReplicaAssignmentForPartitions(adminClient, (scala.collection.immutable.Set<TopicPartition>)proposedParts2.keySet().toSet());
        Predef$.MODULE$.println((Object)this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts));
        if (interBrokerThrottle >= 0L || logDirThrottle >= 0L) {
            Predef$.MODULE$.println((Object)this.youMustRunVerifyPeriodicallyMessage());
            scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateMoveMap((Map<TopicPartition, PartitionReassignment>)currentReassignments, (Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts);
            Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
            Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
            this.modifyTopicThrottles(adminClient, leaderThrottles, followerThrottles);
            scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
            scala.collection.immutable.Set<Object> movingBrokers = this.calculateMovingBrokers((scala.collection.immutable.Set<TopicPartitionReplica>)proposedReplicas2.keySet().toSet());
            this.modifyBrokerThrottles(adminClient, reassigningBrokers, interBrokerThrottle, movingBrokers, logDirThrottle);
            if (interBrokerThrottle >= 0L) {
                Predef$.MODULE$.println((Object)new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString());
            }
            if (logDirThrottle >= 0L) {
                Predef$.MODULE$.println((Object)new StringBuilder(52).append("The replica-alter-dir throttle limit was set to ").append(logDirThrottle).append(" B/s").toString());
            }
        }
        if ((errors = this.alterPartitionReassignments(adminClient, (Map<TopicPartition, Seq<Object>>)proposedParts2)).nonEmpty()) {
            void augmentString_x2;
            String string = "Error reassigning partition(s):%n%s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)errors.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> new StringBuilder(2).append(x0$1).append(": ").append(((Throwable)errors.apply(x0$1)).getMessage()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator())})));
        }
        String string = "Successfully started partition reassignment%s for %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proposedParts2.size() == 1 ? "" : "s", ((TraversableOnce)proposedParts2.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(",")})));
        if (proposedReplicas2.nonEmpty()) {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)proposedReplicas2, timeoutMs, time);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void executeMoves(Admin adminClient, Map<TopicPartitionReplica, String> proposedReplicas, long timeoutMs, Time time) {
        long startTimeMs = time.milliseconds();
        scala.collection.mutable.HashMap pendingReplicas = new scala.collection.mutable.HashMap();
        pendingReplicas.$plus$plus$eq(proposedReplicas);
        boolean done = false;
        do {
            scala.collection.immutable.Set<TopicPartitionReplica> completed;
            if ((completed = this.alterReplicaLogDirs(adminClient, (Map<TopicPartitionReplica, String>)pendingReplicas)).nonEmpty()) {
                void augmentString_x;
                String string = "Successfully started log directory move%s for: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completed.size() == 1 ? "" : "s", ((TraversableOnce)completed.toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            pendingReplicas.$minus$minus$eq(completed);
            if (pendingReplicas.isEmpty()) {
                done = true;
                continue;
            }
            if (time.milliseconds() >= startTimeMs + timeoutMs) {
                void augmentString_x;
                String string = "Timed out before log directory move%s could be started for: %s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pendingReplicas.size() == 1 ? "" : "s", ((TraversableOnce)pendingReplicas.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(a, b)))).mkString(",")})));
            }
            time.sleep(100L);
        } while (!done);
    }

    public void listReassignments(Admin adminClient) {
        Predef$.MODULE$.println((Object)this.curReassignmentsToString(adminClient));
    }

    /*
     * WARNING - void declaration
     */
    public String curReassignmentsToString(Admin adminClient) {
        void augmentString_x;
        scala.collection.mutable.Map currentReassignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.listPartitionReassignments().reassignments().get()).asScala();
        String text = ((TraversableOnce)((TraversableLike)currentReassignments.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable & scala.Serializable)part -> {
            String string;
            Object object;
            void augmentString_x;
            PartitionReassignment reassignment = (PartitionReassignment)currentReassignments.apply(part);
            Buffer replicas = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.replicas()).asScala();
            Buffer addingReplicas = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.addingReplicas()).asScala();
            Buffer removingReplicas = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(reassignment.removingReplicas()).asScala();
            String string2 = "%s: replicas: %s.%s%s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            StringOps stringOps = new StringOps((String)augmentString_x);
            Object[] objectArray = new Object[4];
            objectArray[0] = part;
            objectArray[1] = replicas.mkString(",");
            if (addingReplicas.isEmpty()) {
                object = "";
            } else {
                void augmentString_x2;
                String string3 = " adding: %s.";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                object = objectArray[2] = new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{addingReplicas.mkString(",")}));
            }
            if (removingReplicas.isEmpty()) {
                string = "";
            } else {
                void augmentString_x3;
                String string4 = " removing: %s.";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                string = new StringOps((String)augmentString_x3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{removingReplicas.mkString(",")}));
            }
            objectArray[3] = string;
            return stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray));
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        if (text.isEmpty()) {
            return "No partition reassignments found.";
        }
        String string = "Current partition reassignments:%n%s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}));
    }

    public void verifyBrokerIds(Admin adminClient, scala.collection.immutable.Set<Object> brokers) {
        Some some;
        scala.collection.immutable.Set allNodeIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)adminClient.describeCluster().nodes().get()).asScala()).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28.id()), Iterable$.MODULE$.canBuildFrom())).toSet();
        Option option = brokers.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$29 -> !allNodeIds.contains((Object)BoxesRunTime.boxToInteger((int)x$29)));
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        Some some2 = some;
        Some some3 = some;
        throw ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt((Object)map_this.get()));
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(KafkaZkClient zkClient, String reassignmentJson, long interBrokerThrottle) {
        void augmentString_x;
        void var7_6;
        void var6_5;
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseExecuteAssignmentArgs(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedParts = (Map)tuple2._1();
        Map proposedReplicas = (Map)tuple2._2();
        void proposedParts2 = var6_5;
        if (var7_6.nonEmpty()) {
            throw new AdminCommandFailedException("bootstrap-server needs to be provided when replica reassignments are present.");
        }
        this.verifyReplicasAndBrokersInAssignment(zkClient, (Map<TopicPartition, Seq<Object>>)proposedParts2);
        if (zkClient.reassignPartitionsInProgress()) {
            throw new ReassignPartitionsCommand.TerseReassignmentFailureException(this.cannotExecuteBecauseOfExistingMessage());
        }
        Map<TopicPartition, Seq<Object>> currentParts = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((TraversableOnce)proposedParts2.map((Function1 & Serializable & scala.Serializable)x$31 -> ((TopicPartition)x$31._1()).topic(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Predef$.MODULE$.println((Object)this.currentPartitionReplicaAssignmentToString((Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts));
        if (interBrokerThrottle >= 0L) {
            Predef$.MODULE$.println((Object)this.youMustRunVerifyPeriodicallyMessage());
            scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap = this.calculateMoveMap((Map<TopicPartition, PartitionReassignment>)scala.collection.Map$.MODULE$.empty(), (Map<TopicPartition, Seq<Object>>)proposedParts2, currentParts);
            Map<String, String> leaderThrottles = this.calculateLeaderThrottles(moveMap);
            Map<String, String> followerThrottles = this.calculateFollowerThrottles(moveMap);
            this.modifyTopicThrottles(zkClient, leaderThrottles, followerThrottles);
            scala.collection.immutable.Set<Object> reassigningBrokers = this.calculateReassigningBrokers(moveMap);
            this.modifyBrokerThrottles(zkClient, reassigningBrokers, interBrokerThrottle);
            Predef$.MODULE$.println((Object)new StringBuilder(47).append("The inter-broker throttle limit was set to ").append(interBrokerThrottle).append(" B/s").toString());
        }
        zkClient.createPartitionReassignment((Map<TopicPartition, Seq<Object>>)proposedParts2);
        String string = "Successfully started partition reassignment%s for %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{proposedParts2.size() == 1 ? "" : "s", ((TraversableOnce)proposedParts2.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(",")})));
    }

    public long executeAssignment$default$4() {
        return -1L;
    }

    public long executeAssignment$default$5() {
        return -1L;
    }

    public long executeAssignment$default$6() {
        return 10000L;
    }

    public Time executeAssignment$default$7() {
        return Time.SYSTEM;
    }

    public String currentPartitionReplicaAssignmentToString(Map<TopicPartition, Seq<Object>> proposedParts, Map<TopicPartition, Seq<Object>> currentParts) {
        String string = "Current partition replica assignment%n%n%s%n%nSave this to use as the %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)((TraversableOnce)currentParts.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$currentPartitionReplicaAssignmentToString$1(proposedParts, x0$1)))).toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty()), "--reassignment-json-file option during rollback"}));
    }

    public void verifyReplicasAndBrokersInAssignment(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> proposedParts) {
        Iterable proposedTopics = (Iterable)proposedParts.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return ((TopicPartition)x0$1._1()).topic();
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom());
        Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)proposedTopics.toSet());
        Iterable nonExistentPartitions = (Iterable)((TraversableLike)proposedParts.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                return (TopicPartition)x0$2._1();
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)proposedParts.toMap(Predef$.MODULE$.$conforms()).values().flatten((Function1)Predef$.MODULE$.$conforms())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString(",")).toString());
        }
    }

    public Map<TopicPartition, Throwable> alterPartitionReassignments(Admin adminClient, Map<TopicPartition, Seq<Object>> reassignments) {
        return (Map)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)reassignments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)part, Optional.of(new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.unboxToInt((Object)x$32), Seq$.MODULE$.canBuildFrom())).asJava())));
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())).asJava()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                try {
                    ((KafkaFuture)x0$2._2()).get();
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                catch (ExecutionException t) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)part, (Object)t.getCause())));
                }
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Map<TopicPartition, Throwable> cancelPartitionReassignments(Admin adminClient, scala.collection.immutable.Set<TopicPartition> reassignments) {
        return (Map)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)reassignments.map((Function1 & Serializable & scala.Serializable)x$33 -> new Tuple2(x$33, (Object)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)None$.MODULE$))), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                catch (ExecutionException t) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)part, (Object)t.getCause())));
                }
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> calculateMoveMap(Map<TopicPartition, PartitionReassignment> currentReassignments, Map<TopicPartition, Seq<Object>> proposedReassignments, Map<TopicPartition, Seq<Object>> currentParts) {
        scala.collection.mutable.HashMap moveMap = new scala.collection.mutable.HashMap();
        currentReassignments.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
                ReassignPartitionsCommand.PartitionMove move = new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)new HashSet(), (scala.collection.mutable.Set<Object>)new HashSet());
                reassignment.replicas().forEach(replica -> {
                    move.sources().$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(replica)));
                    move.destinations().$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(replica)));
                });
                reassignment.addingReplicas().forEach(x$34 -> move.destinations().$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$34))));
                reassignment.removingReplicas().forEach(x$35 -> move.destinations().$minus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$35))));
                return ((scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable & scala.Serializable)() -> new scala.collection.mutable.HashMap())).put((Object)BoxesRunTime.boxToInteger((int)part.partition()), (Object)move);
            }
            throw new MatchError(null);
        });
        proposedReassignments.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition part = (TopicPartition)x0$2._1();
                Seq replicas = (Seq)x0$2._2();
                ReassignPartitionsCommand.PartitionMove move = new ReassignPartitionsCommand.PartitionMove((scala.collection.mutable.Set<Object>)new HashSet(), (scala.collection.mutable.Set<Object>)new HashSet());
                move.destinations().$plus$plus$eq((TraversableOnce)replicas);
                return ((scala.collection.mutable.Map)moveMap.getOrElseUpdate((Object)part.topic(), (Function0 & Serializable & scala.Serializable)() -> new scala.collection.mutable.HashMap())).put((Object)BoxesRunTime.boxToInteger((int)part.partition()), (Object)move);
            }
            throw new MatchError(null);
        });
        moveMap.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ReassignPartitionsCommand$.$anonfun$calculateMoveMap$8(currentParts, x0$3);
            return BoxedUnit.UNIT;
        });
        moveMap.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            ReassignPartitionsCommand$.$anonfun$calculateMoveMap$10(x0$5);
            return BoxedUnit.UNIT;
        });
        return moveMap;
    }

    public Map<String, String> calculateLeaderThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
                TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
                partMoveMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ReassignPartitionsCommand$.$anonfun$calculateLeaderThrottles$2(components, x0$2);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)topicName, (Object)components.mkString(","));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> calculateFollowerThrottles(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        return (Map)moveMap.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                scala.collection.mutable.Map partMoveMap = (scala.collection.mutable.Map)x0$1._2();
                TreeSet components = new TreeSet((Ordering)Ordering.String$.MODULE$);
                partMoveMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$2(components, x0$2);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)topicName, (Object)components.mkString(","));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Set<Object> calculateReassigningBrokers(scala.collection.mutable.Map<String, scala.collection.mutable.Map<Object, ReassignPartitionsCommand.PartitionMove>> moveMap) {
        TreeSet reassigningBrokers = new TreeSet((Ordering)Ordering.Int$.MODULE$);
        moveMap.values().foreach((Function1 & Serializable & scala.Serializable)x$36 -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$1(reassigningBrokers, x$36);
            return BoxedUnit.UNIT;
        });
        return reassigningBrokers.toSet();
    }

    public scala.collection.immutable.Set<Object> calculateMovingBrokers(scala.collection.immutable.Set<TopicPartitionReplica> replicaMoves) {
        return ((scala.collection.immutable.Set)replicaMoves.map((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToInteger((int)x$39.brokerId()), Set$.MODULE$.canBuildFrom())).toSet();
    }

    public void modifyTopicThrottles(Admin adminClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        HashMap configs = new HashMap();
        leaderThrottles.keySet().$plus$plus((GenTraversableOnce)followerThrottles.keySet()).foreach((Function1 & Serializable & scala.Serializable)topicName -> {
            Option option;
            ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
            Option option2 = leaderThrottles.get(topicName);
            if (!None$.MODULE$.equals(option2)) {
                if (option2 instanceof Some) {
                    String value = (String)((Some)option2).value();
                    ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.topicLevelLeaderThrottle(), value), AlterConfigOp.OpType.SET));
                } else {
                    throw new MatchError((Object)option2);
                }
            }
            if (!None$.MODULE$.equals(option = followerThrottles.get(topicName))) {
                if (option instanceof Some) {
                    String value = (String)((Some)option).value();
                    ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.topicLevelFollowerThrottle(), value), AlterConfigOp.OpType.SET));
                } else {
                    throw new MatchError((Object)option);
                }
            }
            if (!ops.isEmpty()) {
                return configs.put(new ConfigResource(ConfigResource.Type.TOPIC, topicName), ops);
            }
            return BoxedUnit.UNIT;
        });
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    public void modifyTopicThrottles(KafkaZkClient zkClient, Map<String, String> leaderThrottles, Map<String, String> followerThrottles) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        leaderThrottles.keySet().$plus$plus((GenTraversableOnce)followerThrottles.keySet()).foreach((Function1 & Serializable & scala.Serializable)topicName -> {
            ReassignPartitionsCommand$.$anonfun$modifyTopicThrottles$2(adminZkClient, leaderThrottles, followerThrottles, topicName);
            return BoxedUnit.UNIT;
        });
    }

    public void modifyBrokerThrottles(Admin adminClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle, scala.collection.immutable.Set<Object> movingBrokers, long logDirThrottle) {
        HashMap configs = new HashMap();
        reassigningBrokers.$plus$plus(movingBrokers).foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReassignPartitionsCommand$.$anonfun$modifyBrokerThrottles$1(interBrokerThrottle, reassigningBrokers, logDirThrottle, movingBrokers, configs, BoxesRunTime.unboxToInt((Object)brokerId)));
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    public void modifyBrokerThrottles(KafkaZkClient zkClient, scala.collection.immutable.Set<Object> reassigningBrokers, long interBrokerThrottle) {
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        reassigningBrokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> {
            Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(id));
            configs.put(MODULE$.brokerLevelLeaderThrottle(), Long.toString(interBrokerThrottle));
            configs.put(MODULE$.brokerLevelFollowerThrottle(), Long.toString(interBrokerThrottle));
            adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), configs);
        });
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartitionReplica, String>> parseExecuteAssignmentArgs(String reassignmentJson) {
        void var4_4;
        void var3_3;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJson);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        void partitionsToBeReassigned2 = var3_3;
        void replicaAssignment2 = var4_4;
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment list cannot be empty");
        }
        if (partitionsToBeReassigned2.exists((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$1(x$43)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Iterable)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (TopicPartition)x0$1._1();
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            void augmentString_x;
            String string = "Partition reassignment contains duplicate topic partitions: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartition tp = (TopicPartition)x0$2._1();
                Seq replicas = (Seq)x0$2._2();
                return new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseExecuteAssignmentArgs$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            void augmentString_x;
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 != null) {
                    TopicPartition tp = (TopicPartition)x0$4._1();
                    Iterable duplicateReplicas = (Iterable)x0$4._2();
                    String string = "%s contains multiple entries for %s";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                }
                throw new MatchError(null);
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            String string = "Partition replica lists may not contain duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        return new Tuple2((Object)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()), (Object)replicaAssignment2);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<scala.collection.immutable.Set<TopicPartition>, scala.collection.immutable.Set<TopicPartitionReplica>> cancelAssignment(Admin adminClient, String jsonString, boolean preserveThrottles, long timeoutMs, Time time) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq targetParts = (Seq)tuple2._1();
        Map targetReplicas = (Map)tuple2._2();
        void targetParts2 = var8_7;
        void targetReplicas2 = var9_8;
        scala.collection.immutable.Set targetPartsSet = ((TraversableOnce)targetParts2.map((Function1 & Serializable & scala.Serializable)x$45 -> (TopicPartition)x$45._1(), Seq$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set curReassigningParts = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)targetPartsSet).asJava()).reassignments().get()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition part = (TopicPartition)x0$1._1();
                PartitionReassignment reassignment = (PartitionReassignment)x0$1._2();
                if (!reassignment.addingReplicas().isEmpty() || !reassignment.removingReplicas().isEmpty()) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)part));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
        if (curReassigningParts.nonEmpty()) {
            void augmentString_x;
            Map<TopicPartition, Throwable> errors = this.cancelPartitionReassignments(adminClient, (scala.collection.immutable.Set<TopicPartition>)curReassigningParts);
            if (errors.nonEmpty()) {
                void augmentString_x2;
                String string = "Error cancelling partition reassignment%s for:%n%s";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                throw new ReassignPartitionsCommand.TerseReassignmentFailureException(new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors.size() == 1 ? "" : "s", ((TraversableOnce)((TraversableLike)errors.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable & scala.Serializable)part -> new StringBuilder(2).append(part).append(": ").append(((Throwable)errors.apply(part)).getMessage()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator())})));
            }
            String string = "Successfully cancelled partition reassignment%s for: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{curReassigningParts.size() == 1 ? "" : "s", String.valueOf(((TraversableOnce)curReassigningParts.toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).mkString(","))})));
        } else {
            Predef$.MODULE$.println((Object)"None of the specified partition reassignments are active.");
        }
        scala.collection.immutable.Map curMovingParts = ((TraversableOnce)this.findLogDirMoveStates(adminClient, (Map<TopicPartitionReplica, String>)targetReplicas2).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                TopicPartitionReplica part = (TopicPartitionReplica)x0$2._1();
                ReassignPartitionsCommand.LogDirMoveState moveState = (ReassignPartitionsCommand.LogDirMoveState)x0$2._2();
                if (moveState instanceof ReassignPartitionsCommand.ActiveMoveState) {
                    ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)moveState;
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)part, (Object)activeMoveState.currentLogDir())));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError(null);
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (curMovingParts.isEmpty()) {
            Predef$.MODULE$.println((Object)"None of the specified partition moves are active.");
        } else {
            this.executeMoves(adminClient, (Map<TopicPartitionReplica, String>)curMovingParts, timeoutMs, time);
        }
        if (!preserveThrottles) {
            this.clearAllThrottles(adminClient, (Seq<Tuple2<TopicPartition, Seq<Object>>>)targetParts2);
        }
        return new Tuple2((Object)curReassigningParts, (Object)curMovingParts.keySet());
    }

    public long cancelAssignment$default$4() {
        return 10000L;
    }

    public Time cancelAssignment$default$5() {
        return Time.SYSTEM;
    }

    /*
     * WARNING - void declaration
     */
    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        Integer n = BoxesRunTime.boxToInteger((int)1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"version");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Object object2 = CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)partitionsToBeReassigned.keySet().toBuffer().sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(a, b)))).map((Function1 & Serializable & scala.Serializable)tp -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            void $minus$greater$extension_y3;
            void $minus$greater$extension_$this3;
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            Seq replicas = (Seq)partitionsToBeReassigned.apply(tp);
            Tuple2[] tuple2Array = new Tuple2[4];
            String string = tp.topic();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"topic");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            Integer n = BoxesRunTime.boxToInteger((int)tp.partition());
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"partition");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
            Object object3 = CollectionConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava();
            Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"replicas");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            Object object5 = CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$3(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom())).asJava();
            Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"log_dirs");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"partitions");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
            } else if (None$.MODULE$.equals(option2)) {
                n = this.EarliestTopicsJsonVersion();
            } else {
                throw new MatchError(option2);
            }
            int version = n;
            return this.parseTopicsData(version, js);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
            } else if (None$.MODULE$.equals(option2)) {
                n = this.EarliestVersion();
            } else {
                throw new MatchError(option2);
            }
            int version = n;
            return this.parsePartitionReassignmentData(version, js);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("The input string is not a valid JSON");
        }
        throw new MatchError(option);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
                scala.collection.mutable.Map replicaAssignment = Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable & scala.Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
        .colon.colon validActions = new .colon.colon((Object)opts.generateOpt(), (List)new .colon.colon((Object)opts.executeOpt(), (List)new .colon.colon((Object)opts.verifyOpt(), (List)new .colon.colon((Object)opts.cancelOpt(), (List)new .colon.colon((Object)opts.listOpt(), (List)Nil$.MODULE$)))));
        Seq allActions = (Seq)validActions.filter(arg_0 -> ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1$adapted(opts.options(), arg_0));
        if (allActions.size() != 1) {
            void augmentString_x;
            String string = "Command must include exactly one action: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)validActions.map((Function1 & Serializable & scala.Serializable)x$48 -> new StringBuilder(2).append("--").append(x$48.options().get(0)).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        }
        OptionSpecBuilder action = (OptionSpecBuilder)allActions.apply(0);
        if (!opts.options().has(opts.zkConnectOpt()) && !opts.options().has(opts.bootstrapServerOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Please specify --bootstrap-server");
        }
        Tuple2[] tuple2Array = new Tuple2[5];
        .colon.colon colon2 = new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)opts.verifyOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        .colon.colon colon3 = new .colon.colon(opts.topicsToMoveJsonFileOpt(), (List)new .colon.colon(opts.brokerListOpt(), (List)Nil$.MODULE$));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)opts.generateOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        .colon.colon colon4 = new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)opts.executeOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        .colon.colon colon5 = new .colon.colon(opts.reassignmentJsonFileOpt(), (List)Nil$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)opts.cancelOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Nil$ nil$ = Nil$.MODULE$;
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)opts.listOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Map requiredArgs = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq)requiredArgs.get((Object)action).get());
        Tuple2[] tuple2Array2 = new Tuple2[5];
        .colon.colon colon6 = new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.preserveThrottlesOpt(), (List)new .colon.colon(opts.zkConnectOpt(), (List)Nil$.MODULE$))));
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)opts.verifyOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        .colon.colon colon7 = new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.brokerListOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.disableRackAware(), (List)new .colon.colon(opts.zkConnectOpt(), (List)Nil$.MODULE$)))));
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)opts.generateOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        .colon.colon colon8 = new .colon.colon((Object)opts.additionalOpt(), (List)new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon(opts.interBrokerThrottleOpt(), (List)new .colon.colon(opts.replicaAlterLogDirsThrottleOpt(), (List)new .colon.colon(opts.timeoutOpt(), (List)new .colon.colon(opts.zkConnectOpt(), (List)Nil$.MODULE$)))))));
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)opts.executeOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        .colon.colon colon9 = new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon((Object)opts.preserveThrottlesOpt(), (List)new .colon.colon(opts.timeoutOpt(), (List)Nil$.MODULE$))));
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)opts.cancelOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        .colon.colon colon10 = new .colon.colon(opts.bootstrapServerOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)Nil$.MODULE$));
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)opts.listOpt());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[4] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map permittedArgs = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        opts.options().specs().forEach(opt -> {
            if (!(opt.equals(action) || ((SeqLike)requiredArgs.apply((Object)action)).contains(opt) || ((SeqLike)permittedArgs.apply((Object)action)).contains(opt))) {
                void augmentString_x;
                String string = "Option \"%s\" can't be used with action \"%s\"";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt, action})));
            }
        });
        if (!opts.options().has(opts.bootstrapServerOpt())) {
            new .colon.colon((Object)opts.additionalOpt(), (List)new .colon.colon((Object)opts.cancelOpt(), (List)new .colon.colon(opts.commandConfigOpt(), (List)new .colon.colon(opts.replicaAlterLogDirsThrottleOpt(), (List)new .colon.colon((Object)opts.listOpt(), (List)new .colon.colon(opts.timeoutOpt(), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)opt -> {
                ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$4(opts, opt);
                return BoxedUnit.UNIT;
            });
        }
        return opts;
    }

    public scala.collection.immutable.Set<TopicPartitionReplica> alterReplicaLogDirs(Admin adminClient, Map<TopicPartitionReplica, String> assignment) {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(adminClient.alterReplicaLogDirs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(assignment).asJava()).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)replica));
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof ReplicaNotAvailableException) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    if (throwable != null) {
                        throw new AdminCommandFailedException(new StringBuilder(24).append("Failed to alter dir for ").append(replica).toString(), throwable);
                    }
                    throw new MatchError(null);
                }
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$partitionReassignmentStatesToString$2(Map states$1, ArrayBuffer bld$1, TopicPartition topicPartition) {
        void augmentString_x;
        ReassignPartitionsCommand.PartitionReassignmentState state = (ReassignPartitionsCommand.PartitionReassignmentState)states$1.apply((Object)topicPartition);
        if (state.done()) {
            if (state.currentReplicas().equals(state.targetReplicas())) {
                void augmentString_x2;
                String[] stringArray = new String[1];
                String string = "Reassignment of partition %s is complete.";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                stringArray[0] = new StringOps((String)augmentString_x2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition.toString()}));
                bld$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
                return;
            }
            bld$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(80).append("There is no active reassignment of partition ").append(topicPartition).append(", ").append("but replica set is ").append(state.currentReplicas().mkString(",")).append(" rather than ").append(state.targetReplicas().mkString(",")).append(".").toString()}));
            return;
        }
        String[] stringArray = new String[1];
        String string = "Reassignment of partition %s is still in progress.";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        stringArray[0] = new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}));
        bld$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
    }

    public static final /* synthetic */ boolean $anonfun$findPartitionReassignmentStates$1(scala.collection.mutable.Map currentReassignments$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition part = (TopicPartition)x0$1._1();
            return currentReassignments$1.contains((Object)part);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$3(Integer i) {
        return BoxesRunTime.unboxToInt((Object)i);
    }

    public static final /* synthetic */ int $anonfun$findPartitionReassignmentStates$6(Integer x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10);
    }

    public static final /* synthetic */ void $anonfun$findPartitionReassignmentStates$8(KafkaZkClient zkClient$1, scala.collection.mutable.HashMap results$1, Map partitionsBeingReassigned$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            Map partitions = (Map)x0$1._2();
            Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient$1.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            partitions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    Seq targetReplicas = (Seq)x0$2._2();
                    Seq currentReplicas = (Seq)replicasForTopic.getOrElse((Object)partition, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                    return results$1.put((Object)partition, (Object)new ReassignPartitionsCommand.PartitionReassignmentState((Seq<Object>)currentReplicas, (Seq<Object>)targetReplicas, !partitionsBeingReassigned$1.contains((Object)partition)));
                }
                throw new MatchError(null);
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$replicaMoveStatesToString$2(Map states$2, ArrayBuffer bld$2, TopicPartitionReplica x0$1) {
        ReassignPartitionsCommand.LogDirMoveState state = (ReassignPartitionsCommand.LogDirMoveState)states$2.apply((Object)x0$1);
        if (state instanceof ReassignPartitionsCommand.MissingLogDirMoveState) {
            bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(112).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" is not found ").append("in any live log dir on broker ").append(x0$1.brokerId()).append(". There is likely an ").append("offline log directory on the broker.").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.MissingReplicaMoveState) {
            bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(65).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" cannot be found ").append("in any live log directory on broker ").append(x0$1.brokerId()).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.ActiveMoveState) {
            String futureLogDir;
            ReassignPartitionsCommand.ActiveMoveState activeMoveState = (ReassignPartitionsCommand.ActiveMoveState)state;
            String targetLogDir = activeMoveState.targetLogDir();
            if (targetLogDir.equals(futureLogDir = activeMoveState.futureLogDir())) {
                bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(46).append("Reassignment of replica ").append(x0$1).append(" is still in progress.").toString()}));
                return;
            }
            bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(62).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" on broker ").append(x0$1.brokerId()).append(" is being moved to log dir ").append(futureLogDir).append(" ").append("instead of ").append(targetLogDir).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.CancelledMoveState) {
            ReassignPartitionsCommand.CancelledMoveState cancelledMoveState = (ReassignPartitionsCommand.CancelledMoveState)state;
            String currentLogDir = cancelledMoveState.currentLogDir();
            String targetLogDir = cancelledMoveState.targetLogDir();
            bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(60).append("Partition ").append(x0$1.topic()).append("-").append(x0$1.partition()).append(" on broker ").append(x0$1.brokerId()).append(" is not being moved from log dir ").append(currentLogDir).append(" to ").append(targetLogDir).append(".").toString()}));
            return;
        }
        if (state instanceof ReassignPartitionsCommand.CompletedMoveState) {
            bld$2.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(48).append("Reassignment of replica ").append(x0$1).append(" completed successfully.").toString()}));
            return;
        }
        throw new MatchError((Object)state);
    }

    public static final /* synthetic */ Collection $anonfun$clearBrokerLevelThrottles$1(HashMap configOps$1, int x0$1) {
        return (Collection)configOps$1.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(x0$1)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)MODULE$.brokerLevelThrottles().map((Function1 & Serializable & scala.Serializable)throttle -> new AlterConfigOp(new ConfigEntry(throttle, null), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    public static final /* synthetic */ void $anonfun$clearTopicLevelThrottles$3(AdminZkClient adminZkClient$2, String topic) {
        Properties configs = adminZkClient$2.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        if (((TraversableOnce)MODULE$.topicLevelThrottles().flatMap((Function1 & Serializable & scala.Serializable)throttle -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(configs.remove(throttle))), Seq$.MODULE$.canBuildFrom())).nonEmpty()) {
            adminZkClient$2.changeTopicConfig(topic, configs);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadata$3(BrokerMetadata x$25) {
        return x$25.rack().isEmpty();
    }

    public static final /* synthetic */ int $anonfun$parseGenerateAssignmentArgs$1(String x$26) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$26).toInt();
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3(int id) {
        throw new AdminCommandFailedException(new StringBuilder(18).append("Unknown broker id ").append(id).toString());
    }

    public static final /* synthetic */ boolean $anonfun$currentPartitionReplicaAssignmentToString$1(Map proposedParts$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition k = (TopicPartition)x0$1._1();
            return proposedParts$1.contains((Object)k);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateMoveMap$8(Map currentParts$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String topicName = (String)x0$3._1();
            ((scala.collection.mutable.Map)x0$3._2()).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 != null) {
                    int partitionIndex = x0$4._1$mcI$sp();
                    ReassignPartitionsCommand.PartitionMove moves = (ReassignPartitionsCommand.PartitionMove)x0$4._2();
                    Option option = currentParts$1.get((Object)new TopicPartition(topicName, partitionIndex));
                    if (None$.MODULE$.equals(option)) {
                        return BoxedUnit.UNIT;
                    }
                    if (option instanceof Some) {
                        Seq replicas = (Seq)((Some)option).value();
                        return moves.sources().$plus$plus$eq((TraversableOnce)replicas);
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(null);
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateMoveMap$10(Tuple2 x0$5) {
        if (x0$5 != null) {
            ((scala.collection.mutable.Map)x0$5._2()).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                if (x0$6 != null) {
                    ReassignPartitionsCommand.PartitionMove moves = (ReassignPartitionsCommand.PartitionMove)x0$6._2();
                    return (scala.collection.mutable.Set)moves.destinations().$minus$minus$eq(moves.sources());
                }
                throw new MatchError(null);
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateLeaderThrottles$2(TreeSet components$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ((ReassignPartitionsCommand.PartitionMove)x0$2._2()).sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)source -> {
                String string = "%d:%d";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return components$1.add((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId), BoxesRunTime.boxToInteger((int)source)})));
            });
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$calculateFollowerThrottles$3(ReassignPartitionsCommand.PartitionMove move$2, TreeSet components$2, int partId$2, int destination) {
        if (!move$2.sources().contains((Object)BoxesRunTime.boxToInteger((int)destination))) {
            void augmentString_x;
            String string = "%d:%d";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return BoxesRunTime.boxToBoolean((boolean)components$2.add((Object)new StringOps((String)augmentString_x).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId$2), BoxesRunTime.boxToInteger((int)destination)}))));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$calculateFollowerThrottles$2(TreeSet components$2, Tuple2 x0$2) {
        if (x0$2 != null) {
            int partId = x0$2._1$mcI$sp();
            ReassignPartitionsCommand.PartitionMove move = (ReassignPartitionsCommand.PartitionMove)x0$2._2();
            move.destinations().foreach((Function1 & Serializable & scala.Serializable)destination -> ReassignPartitionsCommand$.$anonfun$calculateFollowerThrottles$3(move, components$2, partId, BoxesRunTime.unboxToInt((Object)destination)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$2(TreeSet reassigningBrokers$1, ReassignPartitionsCommand.PartitionMove partMove) {
        partMove.sources().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$37 -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)x$37)));
        partMove.destinations().foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$38 -> reassigningBrokers$1.add((Object)BoxesRunTime.boxToInteger((int)x$38)));
    }

    public static final /* synthetic */ void $anonfun$calculateReassigningBrokers$1(TreeSet reassigningBrokers$1, scala.collection.mutable.Map x$36) {
        x$36.values().foreach((Function1 & Serializable & scala.Serializable)partMove -> {
            ReassignPartitionsCommand$.$anonfun$calculateReassigningBrokers$2(reassigningBrokers$1, partMove);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$modifyTopicThrottles$2(AdminZkClient adminZkClient$3, Map leaderThrottles$2, Map followerThrottles$2, String topicName) {
        Properties configs = adminZkClient$3.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topicName);
        Option option = leaderThrottles$2.get((Object)topicName);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
        } else {
            String string = (String)map_this.get();
            new Some(configs.put(ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), string));
        }
        Option option2 = followerThrottles$2.get((Object)topicName);
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        if (map_this2.isEmpty()) {
        } else {
            String string = (String)map_this2.get();
            new Some(configs.put(ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), string));
        }
        adminZkClient$3.changeTopicConfig(topicName, configs);
    }

    public static final /* synthetic */ Object $anonfun$modifyBrokerThrottles$1(long interBrokerThrottle$1, scala.collection.immutable.Set reassigningBrokers$2, long logDirThrottle$1, scala.collection.immutable.Set movingBrokers$1, HashMap configs$5, int brokerId) {
        ArrayList<AlterConfigOp> ops = new ArrayList<AlterConfigOp>();
        if (interBrokerThrottle$1 >= 0L && reassigningBrokers$2.contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLeaderThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelFollowerThrottle(), Long.toString(interBrokerThrottle$1)), AlterConfigOp.OpType.SET));
        }
        if (logDirThrottle$1 >= 0L && movingBrokers$1.contains((Object)BoxesRunTime.boxToInteger((int)brokerId))) {
            ops.add(new AlterConfigOp(new ConfigEntry(MODULE$.brokerLevelLogDirThrottle(), Long.toString(logDirThrottle$1)), AlterConfigOp.OpType.SET));
        }
        if (!ops.isEmpty()) {
            return configs$5.put(new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId)), ops);
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$1(Tuple2 x$43) {
        return ((SeqLike)x$43._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseExecuteAssignmentArgs$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((Iterable)x0$3._2()).nonEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$3(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0 & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$47) {
        Object object = x$47._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable & scala.Serializable)p -> {
            void $minus$greater$extension_$this;
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                seq = (Seq)((JsonValue)((Some)option).value()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable & scala.Serializable)x$46 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            Seq newLogDirs = seq;
            if (newReplicas.size() != newLogDirs.size()) {
                throw new AdminCommandFailedException(new StringBuilder(78).append("Size of replicas list ").append(newReplicas).append(" is different from ").append("size of log dirs list ").append(newLogDirs).append(" for partition ").append(new TopicPartition(topic, partition)).toString());
            }
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            partitionAssignment$1.$plus$eq((Object)new Tuple2((Object)$minus$greater$extension_$this, (Object)newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip((GenIterable)newLogDirs, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    void $minus$greater$extension_$this;
                    int replica = x0$1._1$mcI$sp();
                    String logDir = (String)x0$1._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, partition, replica));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
                }
                throw new MatchError(null);
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$47))));
        });
    }

    public static final /* synthetic */ void $anonfun$validateAndParseArgs$4(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, AbstractOptionSpec opt) {
        if (opts$1.options().has((OptionSpec)opt)) {
            String string = "when using \"%s\"";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new RuntimeException(new StringBuilder(36).append("You must specify --bootstrap-server ").append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opt}))).toString());
        }
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.AnyLogDir = "any";
        this.helpText = "This tool helps to move topic partitions between replicas.";
        this.EarliestVersion = 1;
        this.EarliestTopicsJsonVersion = 1;
        this.brokerLevelLeaderThrottle = DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp();
        this.brokerLevelFollowerThrottle = DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp();
        this.brokerLevelLogDirThrottle = DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp();
        this.brokerLevelThrottles = new .colon.colon((Object)this.brokerLevelLeaderThrottle(), (List)new .colon.colon((Object)this.brokerLevelFollowerThrottle(), (List)new .colon.colon((Object)this.brokerLevelLogDirThrottle(), (List)Nil$.MODULE$)));
        this.topicLevelLeaderThrottle = LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp();
        this.topicLevelFollowerThrottle = LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp();
        this.topicLevelThrottles = new .colon.colon((Object)this.topicLevelLeaderThrottle(), (List)new .colon.colon((Object)this.topicLevelFollowerThrottle(), (List)Nil$.MODULE$));
        this.cannotExecuteBecauseOfExistingMessage = "Cannot execute because there is an existing partition assignment.  Use --additional to override this and create a new partition assignment in addition to the existing one.";
        this.youMustRunVerifyPeriodicallyMessage = "Warning: You must run --verify periodically, until the reassignment completes, to ensure the throttle is removed.";
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(AutoCloseable x$1) {
        x$1.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Nothing$ $anonfun$verifyBrokerIds$3$adapted(Object id) {
        return ReassignPartitionsCommand$.$anonfun$verifyBrokerIds$3(BoxesRunTime.unboxToInt((Object)id));
    }

    public static final /* synthetic */ Object $anonfun$validateAndParseArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

